/***************************************************************************
**
** File name : error.c
**
** Error process/print.
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"


/**************************************************************************
**
** Local define
**
***************************************************************************/

/**************************************************************************
**
** Local variables
**
***************************************************************************/

/**************************************************************************
**
** Name : prn_ferr(c)
**
** Function : print error message
**
**     Input  : error code/index -- int
**
**     Output : message/string on the VPOut.
**
** Notes:
**
**************************************************************************/

prn_ferr(int c) {
int  VPTmp;
char temp[100];

// Chen 05/26/94
int loop;
extern U8 lineBuf[512];
extern S16 posPtr;

static char  *ferr1[] = {
   /*   0 */   "Too many arguments in command file calling!",
   /*   1 */   "Input is out of range!",
   /*   2 */   "Parenthesis unmatched!",
   /*   3 */   "Too many levels in command file calling!",
   /*   4 */   "DMA can not be set with other status!",
   /*   5 */   "Command error!",
   /*   6 */   "Loop uncompleted!",
   /*   7 */   "Invalid label!",
   /* x 8 */   "Uncompleted download file!",
   /*   9 */   "Invalid else!",
   /*   10 */  "Macro command file aborted!",
   /*   11 */  "Invalid branch into a loop!",
   /* x 12 */  "Disk error reading!",
   /* x 13 */  "Upload aborted!",
   /* x 14 */  "Download aborted!",
   /*   15 */  "File open error!",
   /* x 16 */  "Missing file name!",
   /* x 17 */  "Download failure!",
   /* x 18 */  "Disk full!",
   /* x 19 */  "Symbol undefined!",
   /*   20 */  "Symbol redefined!",
   /*   21 */  "No such symbol!",
   /*   22 */  "File access failure!",    // added for ssave & srecall cmds by amy
   /*   23 */  "New symbol table full!",
   /*   24 */  "No local variables!",
   /*   25 */  "Syntax error!",
   /*   26 */  "Local variables not alive!",
   /*   27 */  "Symbol file not loaded!",
   /*   28 */  "Invalid symbol file!",
   /* x 29 */  "Too many module!",
   /* x 30 */  "Module undefined!",
   /*   31 */  "Disk error writing!",
   /*   32 */  "The buffer of monitored data isn't enough!",
   /* x 33 */  "Invalid command on fly mode!",
   /* x 34 */  "Invalid symbol file! (need re-converted!)",
   /* x 35 */  "Symbolic debugging capability only in physical address mode!",
   /* x 36 */  "Physical address can't convert to logical address!",
   /*   37 */  "Invalid argument!",
   /*   38 */  "Invalid download file!",
   /*   39 */  "Too many labels!",
   /* x 40 */  "Communication error!",
   /*   41 */  "File read error!",
   /*   42 */  "Invalid file format!",
   /* x 43 */  "Intel format file download in protection mode not allowed!",
   /* x 44 */  "\'r\' is not allowed for mice-ii!",
   /*   45 */  "Memory allocation failure!",
   /* x 46 */  "Create label failure!",
   /* x 47 */  "Listup aborted!",
   /* x 48 */  "Listdown aborted!",
   /*   49 */  "S/W breakpoint enable failure!",
   /*   50 */  "Invalid address range!",
   /* x 51 */  "Address overflow!",
   /* x 52 */  "Range error!",
   /* x 53 */  "Program halted!",
   /* x 54 */  "Module duration analysis not available with mice-ii!",
   /* x 55 */  "Can't open \"mv186.lsa\"!",
   /* x 56 */  "Trace buffer empty!",
   /*   57 */  "No log or journal file found!",
   /*   58 */  "No log file!",
   /*   59 */  "No journal file!",
   /*   60 */  "Invalid level!",
   /* x 61 */  "Invalid background color!",
   /* x 62 */  "Invalid text color!",
   /* x 63 */  "Invalid softkey number!",
   /*   64 */  "Not allowed to use \"USave/URecall\" when command viewport is maximum!",
   /*   65 */  "Invalid line number!",
   /*   66 */  "Can't find help information in \"MV86HLPC.TXT\"!",
   /*   67 */  "Insufficient memory to load symbol!",
   /*   68 */  "No address matched!",
   /*   69 */  "No symbol matched!",
   /*   70 */  "No line number matched!",
   /*   71 */  "Can't locate current module!",
   /*   72 */  "Invalid module!",
   /*   73 */  "Invalid address format!",
   /*   74 */  "Symbol not found!",
   /* x 75 */  "Spa isn't available in this firmware version!",
   /*   76 */  "Line number is not availabe for assembly mode!",
   /* x 77 */  "Trace board does not exist!",
   /*   78 */  "Command line length is limited up to 511 characters!",
   /*   79 */  "Word length is limited up to 80 characters!",
// Chen 05/25/94
   /*   80 */  "Word length is limited up to 220 characters!",
   /*   81 */  "Insufficient memory !",
   /*   82 */  "Repeat to keyin, please !",     // Chen 06/09/94
   /*   83 */  "Double quotation marks unmatched!",    // Chen 07/12/94
   /* x 84 */  "Can't open \"mv186.pat\"!",//liu, 1994.11.24
};

   usd_prn_ferr = 1;
   VPTmp = VPOut;
   VPOut = COMVP;
   EraseCMDCURSOR();
   sprintf(temp," %s\n\r", ferr1[ c ]);

// Chen 05/26/94
    if ( c==78 || c==79 ) {      // c==78, 511 characters error
        for ( loop=0; loop<=(strlen(lineBuf)-posPtr)/78; loop++ ) {
            DisplayStr("\n\r");
        }
    }

   DisplayStr(temp);
   VPOut = VPTmp;
   return( TRUE );

}  /* end of prn_ferr(c) */


/**************************** End of File **********************************/

