/***************************************************************************
**
** File name : exec86.c for MICE-III
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/29/1992 By Cheerson
**     0. Update the include files.
**
**
**
** X. Date -- 12/18/1992 By Cheerson
**    0. Delete emuGetPC() routine.
**    1. Replace the "emuGetPC()" calling of the emuRunUntil() to be
**       emuGetRegister(REG_PC,&addr).
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include <string.h>
#include <ctype.h>

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG86_DEFINE_
#include "reg86.h"
#endif

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

#ifndef _SD_ABI_EXT_
#include "sdabiext.h"
#endif

#define OK ICE_OK
#define CR 0xd
#define HAND_SHAKE 0x3
#define NULL 0
#define WAIT -1

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define HighWord(x)      ((U16)((U32)(x) >> 16))
#define LowWord(x)       ((U16)(x))
#define HighByte(x)      ((U8)((U16)(x) >> 8))
#define LowByte(x)       ((U8)(x))


/**************************************************************************
**
** Local variables
**
***************************************************************************/
char *logicOP[]={""," OR "," AND "," THEN "};
char *stat_code[]={" S"," R"," W"," I"," O"," AK"," H"};


/**************************************************************************
**
** Externals
**
**************************************************************************/
extern char event_clr[];
extern char level_clr[];
extern QUALIFY *tmpQualify;  //added by frank, 4/18/1994
extern ESCflag; //frank 6/2

/**************************************************************************
**
** Functions Prototype
**
**************************************************************************/
send_delay(unsigned delay);
send_stat(unsigned char val);
send_wild(unsigned long val, unsigned long mask, int i);
send_count(U32 count);
send_data(int dataspec, U32 datalo, U32 datahi);
send_address(int addrspec, U32 addrlo, U32 addrhi);
STATUS emuSetEvent(U16 evId, BUS_EVENT *busEventData);
STATUS emuSetQualify(U16 quaNo, QUALIFY *tmpQualify);
STATUS emuGetTraceDepth(U16 bufID, BUFFER_DEPTH *trcDepth);
STATUS emuGetCpuStatus(U8 *goEnd);
STATUS emuReset(VOID);
STATUS emuAbort(VOID);
STATUS emuStepOne(VOID);
STATUS emuStepRange(ADDR addr1, ADDR addr2);
STATUS emuClrBP(U16 evId);
STATUS emuClrEvent(U16 evId);

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuClrEvent(U16 evId)
{
int i;

        if (!evId) send_str("E CL");
        else{
          event_cmd[2] = evId+'0';
          send_str2(event_cmd);
          send_str(" CL");
        }
        if (!evId) { //both LAM and LAM2
            for (i=0; i < 4; i++) event_record[i].defined = 0;
            for (i=0; i< 4; i++) bp_record[i].defined = 0;
            ext_record = 0 ;
        } else{
          if ( !LAM2 && evId < 3 ) event_record[evId-1].defined = 0;
          else if ( LAM2 && evId < 5) event_record[evId-1].defined = 0;
          else if (!LAM2 && evId > 3) bp_record[evId-4-LAM2].defined = 0;
          else if ( LAM2 && evId > 5) bp_record[evId-4-LAM2].defined = 0;
          else ext_record = 0;
         }
	return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuClrBP(U16 evId)
{
        event_clr[2]=evId+'0';
        send_str(event_clr);

        if (!LAM2) bp_record[evId-4-LAM2].defined = 0;
           else bp_record[evId-4-LAM2].defined = 0;
}

/**************************************************************************
**
** Name : emuStepRange()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuStepRange(ADDR addr1, ADDR addr2)
{
char c;
char *ptr;
int i;

	send_str2("S ");
	send_csip(addr1);
	send(' ');
	send_csip(addr2);
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE){
		if (ESCflag){
			ESCflag = 0;
			send_ESC();
			break;
		}
		*ptr ++ = c;
	}
	*ptr=NULL;

	i = check_error(tx_buf);
	if (i !=OK) return(i);
//	  send_ESC();
	emuGetAllReg(cpuReg);
}      /* end of emuStepRange() */

STATUS emuStepOverRange(ADDR addr1, ADDR addr2)
{
char c;
char *ptr;
int i;

	send_str2("S ");
	send_csip(addr1);
	send(' ');
	send_csip(addr2);
	send(' ');
	send_str2("CALL");
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE){
		if (ESCflag){
			ESCflag = 0;
			send_ESC();
			break;
		}
		*ptr ++ = c;
	}
	*ptr=NULL;

	i = check_error(tx_buf);
	if (i !=OK) return(i);
//	  send_ESC();
	emuGetAllReg(cpuReg);
}      /* end of emuStepRange() */


/**************************************************************************
**
** Name : emuStepOne()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuStepOne(VOID)
{
int i;

        if (i=for1step()) return(i);
   /* if exist a interrupt, then skip it. */
        if (strstr(tx_buf,"A-") != NULL) skipINT();
        emuGetAllReg(cpuReg);
	return(OK);
}      /* end of emuStepOne() */

for1step()
{
char c;
int i, key;
char *ptr;

	send('S');
	send(CR);

        while ((c=receive()) != HAND_SHAKE) {
            key = chk_hlt();
            if (key == ESC || ESCflag) {
                 ESCflag = 0;
                 send_ESC();
                 return(-13); //(-13) -- "Stopped by user"
             }
	}
	send(CR);
	while ((c=receive()) != HAND_SHAKE) {
                if (c < 0) {
                      send_ESC();
                      return(OK);
                }
	}
	send_ESC();
	return(OK);
}

skipINT()
{
unsigned long sp_ptr, retPC;

        emuGetAllReg(cpuReg);
	emuGetReg(I86_REG,REG_SP,&sp_ptr);
	retPC = getStack(sp_ptr, 1);
	emuRunUntil(retPC);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuAbort(VOID)
{
	send_ESC();
}

/**************************************************************************
**
** Name : emuReset
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuReset(VOID)
{
	send_str("RESET");
	return(OK);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetCpuStatus(U8 *goEnd)
{
char *ptr,c;

        send(CR);
	ptr = tx_buf;
	while((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=0;
	if (strstr(tx_buf,"Run>") != NULL) {
		*goEnd=0;
		return(ICE_OK);
	} else {
		*goEnd=1;
		return(ICE_BROKE);
	}
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

STATUS emuGetTraceDepth(U16 bufID, BUFFER_DEPTH *trcDepth)
{
char *ptr, c;
U32 l;

        trcDepth->startFrame = 0;
	trcDepth->endFrame = 0;
	send_str2("L N");
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) if (c > 0) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf,"empty") == NULL) {
		ptr = tx_buf;
		while (*ptr++ != '=');
		sscanf(ptr," %hx", &l);
		trcDepth->endFrame = l & 0xffff;
	}	
	return(OK);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
* typedef struct {
*    int defined;  1=event is defined, 0=not defined 
*    int addrSpec; 
*    U32 addrLo;
*    U32 addrHi;
*    int dataSpec;
*    U32 dataLo;
*    U32 dataHi;
*    U32 stat;
*    U16 count;
* }BUS_EVENT;
**
**************************************************************************/
extern struct syntax {
  int argc;
  long argv[5];
  char asc[80];
  char input[80];
} cmd_syntax;
STATUS emuSetEvent(U16 evId, BUS_EVENT *busEventData)
{
   char c, *ptr;
   int i;

   send_str2("E ");
   send(hex[evId]);

   if (!LAM2){
        switch(evId) {
            case 1: send_address(busEventData->addrSpec,busEventData->addrLo,
                                 busEventData->addrHi);
                    send_data(busEventData->dataSpec,busEventData->dataLo,
                                 busEventData->dataHi);
                    send_stat((U8)busEventData->stat);
                    if ( busEventData->count > 1 )
                        send_count((U32)busEventData->count);
                    break;
            case 2: send_address(busEventData->addrSpec,busEventData->addrLo,
                                 busEventData->addrHi);
                    send_data(busEventData->dataSpec,busEventData->dataLo,
                                 busEventData->dataHi);
                    send_stat((U8)busEventData->stat);
                    break;
            }
        }
        else{
             send_address(busEventData->addrSpec,busEventData->addrLo,
                          busEventData->addrHi);
             send_data(busEventData->dataSpec,busEventData->dataLo,
                          busEventData->dataHi);
             send_stat((U8)busEventData->stat);
              if ( cmd_syntax.asc[0] != '\0'){
                         send_str2(" EXT ");
			 send_str2(cmd_syntax.asc);
              }
             if (busEventData->count > 1)
                   send_count((U32)busEventData->count);
        }
        send(CR);
        ptr = tx_buf;
        while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i !=OK) return(i);
        memcpy(&event_record[evId-1],busEventData,sizeof(BUS_EVENT));
	return(OK);
}
/**************************************************************
**   name:  send_address
**
**   function:
**
**   Input:
**
**   output:
**************************************************************/
send_address(int addrspec, U32 addrlo, U32 addrhi)
{
   int i;
   char c;

        send(' '); /* send delimeter */
        switch(addrspec) {
            case 0: /* address not specified */
                send_str2("XXXXX");
                break;
            case 1: /* address is a simple value */
                for (i=4; i >= 0; i--) {
                    c=(addrlo>>i*4)&0xf;
                    send(hex[c]);
                }
                break;
            case 2: /* address with range value */
                send_str2("Range ");
                for (i=4; i >= 0; i--) {
                    c=(addrlo>>i*4)&0xf;
                    send(hex[c]);
                }
                send(' ');
                for (i=4; i >= 0; i--) {
                    c=(addrhi>>i*4)&0xf;
                    send(hex[c]);
                }
                break;
            case 3: /* address with mask */
                send_wild(addrlo, addrhi, 5);
                break;
        }
}
/**************************************************************
**   name:  send_data
**
**   function:
**
**   Input:
**
**   output:
**************************************************************/
send_data(int dataspec, U32 datalo, U32 datahi)
{
        send(' '); /* send delimeter */
        switch(dataspec)
        {
        case 0: /* data not specified */
                break;
        case 1: /* data is a simple value */
                send_word(datalo);
                break;
        case 3: /* data with mask */
                send_wild(datalo, datahi, 4);
                break;
        }
}

/**************************************************************
**   name:  send_count
**
**   function:
**
**   Input:
**
**   output:
**************************************************************/
send_count(U32 count)
{
	send_str2(" CO ");
	send_word(count);
}

/**************************************************************
**   name:  send_wild
**
**   function:
**
**   Input:
**
**   output:
**************************************************************/
send_wild(unsigned long val, unsigned long mask, int i)
{
int j, jj;
char c, d;

    for (j=i-1;j >= 0;j--) {
		c = (mask >> (j*4)) & 0xf;
        d = (val >> (j*4)) & 0xf;
        if (c == 0xf) send(hex[d]);
        else if (!c) send('X');
        else {
            send('(');
            for (jj=3; jj >= 0; jj--) {
				if (!((c >> jj) & 1)) send('X');
                else if ((d >> jj) & 1) send('1');
                else send('0');
            }
            send(')');
        }
    }
}
/**************************************************************
**   name:  send_stat
**
**   function:
**
**   Input:
**
**   output:
**************************************************************/
send_stat(unsigned char val)
{
int i;

    for (i=0;i<7;i++) if ((val>>i)&1) send_str2(stat_code[i]);
}

/**************************************************************
**   name:  send_delay
**
**   function:
**
**   Input:
**
**   output:
**************************************************************/
send_delay(unsigned delay)
{
}   // end of send_delay()


/**************************************************************************
**
** Name : emuSetAllEvents
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetAllEvents(BUS_EVENT *event_record,
                       EXEC_EVENT *bp_record, U16 ext_record)
{
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetExtEvent(U16 evData)
{

      if (!LAM2) send_str2("EV3 ");
      else send_str2("EV5 ");
      if(evData) send('H');
      else send('L');
      send(CR);
      while(receive() !=HAND_SHAKE);
      ext_record = evData;
      return(OK);
}

/**************************************************************************
**
** Name :   emuGetEvent
**
** Function : during the initializing, EV4 ~ EV6  are set. And while executing
**            go or step, EV4 also is to be set, so receiving directly from
**            firmWare is a appropiate way.  (upper is for LAM)
**            only get bp_record.
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetEvent(BUS_EVENT *event_record, EXEC_EVENT *bp_record,
                   U16 *ext_record, U8 *cntFlag, U32 *timerRecord,
                   U16 *counter)
{
  /**
   int c,i;
   int eq0=0, eq1=0, eq2=0 ;
   int subNumber;
   char *ptr;
   char *pch;
   char *endPtr, *endPtr2;
   char addrSeg[5], addrOff[5];

   send('E');
   send_CR_wait(CR);
      for(;;){
         ptr = tx_buf;
         while (((c=receive()) != HAND_SHAKE) && (c != CR)) *ptr++ = c;
         *ptr = NULL;
         if (i = check_error(tx_buf) != OK) return(i);
         if (c == HAND_SHAKE && *--ptr == '>') break;
         if (((!LAM2 && ((eq0= strstr(tx_buf, "EV4") != NULL) ||
                         (eq1= strstr(tx_buf, "EV5") != NULL) ||
                         (eq2= strstr(tx_buf, "EV6") != NULL)))
            || (LAM2 && ((eq0= strstr(tx_buf, "EV6") != NULL) ||
                         (eq1= strstr(tx_buf, "EV7") != NULL) ||
                         (eq2= strstr(tx_buf, "EV8") != NULL))))
                    && (pch=strchr(tx_buf, ':')) ){
               if( eq0 ==1 ) subNumber = 0;
               else if ( eq1 == 1 ) subNumber = 1;
               else subNumber = 2;
               strncpy( addrSeg, pch - 4, 4 );
               strncpy( addrOff, pch + 1, 4 );
               bp_record[subNumber].addr =
                     ((U32)strtoul(addrSeg, &endPtr, 16)<<16)
                   + (U32)strtoul(addrOff, &endPtr2, 16);
               bp_record[subNumber].defined = 1;
         }
      }
      */
   return(OK);
}

/**************************************************************************
**
** Name : emuSetBP
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetBP(U16 evId, ADDR addr)
{
   char c, *ptr;
   int i;
   int sub;

        event_cmd[2]=evId+'0';
	send_str2(event_cmd);
        send_csip(addr);
        send_CR_wait(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i !=OK) return(i);
        sub= evId-4-LAM2;
        bp_record[sub].defined = 1;
        bp_record[sub].addr = addr;
        return(OK);
}

STATUS emuSetBP0(S16 flag, ADDR addr, U16 count)
{
   char c, *ptr;
   int i;

        event_cmd[2]=4+LAM2+'0';
        send_str2(event_cmd);
        if ( flag ) send_str2("RUN ");
        send_csip(addr);
        if (count != 0){
            send(' ');
            send_str2("COUNT ");
            send_word(count);
         }
        send_CR_wait(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c; 
	*ptr=NULL;
	i = check_error(tx_buf);
	if (i !=OK) return(i);
        bp_record[0].defined = 1;
        if (flag ) bp_record[0].runFlag = 1;
        else bp_record[0].runFlag = 0;
        bp_record[0].addr = addr;
        if ( count > 1 ) bp_record[0].count = count;
            else bp_record[0].count = 1;
        return(OK);
}

int emuSetTempBP(int evId, ADDR addr)
{
   int iDefinedFlag = 0;
   int iSub;

          iSub = evId - 4 -LAM2;
          if (bp_record[iSub].defined){
               memcpy(&tempBP, &bp_record[iSub], sizeof(EXEC_EVENT));
               iDefinedFlag = 1;
          }
          if (evId == 4+LAM2 ) emuSetBP0(0,addr,0);
          else  emuSetBP(evId,addr);
   return iDefinedFlag;
}


void emuRetTempBP(int flag, int evId)
{
   int iSub;

   iSub = evId-4-LAM2;
        if (flag) {
            memcpy(&bp_record[iSub], &tempBP, sizeof(EXEC_EVENT));
			if (evId == 4+LAM2 && MICE >= I8088MAX)  //80286 NOT THOUGHT
                emuSetBP0(tempBP.runFlag, tempBP.addr, tempBP.count);
            else emuSetBP(evId, tempBP.addr);
        }
        else emuClrBP(evId);
}

/**************************************************************************
**
** Name :  emuGetAllTrig
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetAllTrig(TRIGGER *trig_record)
{
   return(OK);
}

/**************************************************************************
**
** Name :  emuGetTraceInfo
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetTraceInfo(U16 *lastBuff, U16 *curCNT0, U16 *curCNT1, U16 *bufNO)
{
        *lastBuff = 1;
}

/**************************************************************************
**
** Name :  emuTrace
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuTrace(TRACE *trcInfo)
{
   send_str2("T");
   if(trcInfo->runflag) send_str2(" R");
   send_address(trcInfo->addrspec,trcInfo->addrHi,trcInfo->addrLo);
   send_stat((U8) trcInfo->stat);
   send_count((U32) trcInfo->count);
   if(trcInfo->mode) send_str2(" B");
   else send_str2(" F");
   send_CR_wait(HAND_SHAKE);
   return(OK);
}


/**************************** End of File **********************************/

