/*--------------------------------------------------------------------------*/
/*  gbl.h                            */
/*--------------------------------------------------------------------------*/

/*  information array of viewports  */
struct VPtag  VP[7];

/*  viewport's border -----
      1. no STAVP
    TopVPBdr    : BREVP, REGVP, TRAVP
    MiddleVPBdr : CODVP
    BottomVPBdr : COMVP
      2. has STAVP
    TopVPBdr    : BREVP, REGVP, TRAVP
    LeftVPBdr   : CODVP
    RightVPBdr  : STAVP
    BottomVPBdr : COMVP
      3. no STAVP, BREVP, REGVP, TRAVP
    TopVPBdr : CODVP
    BottomVPBdr : COMVP
      4. has STAVP, but no BREVP, REGVP, TRAVP
    TopLeftVPBdr   : CODVP
    TopRightVPBdr  : STAVP
    BottomVPBdr    : COMVP
      5. COMVP maximum
    SingleVPBdr    : COMVP
*/
/* CORE 90.08.10 Cheng Bdr Style */
#ifdef NEC_PC9801
BORDER  TopLeftVPBdr = { 0x95, 0x95, 0x96, 0x96, 0x98, 0x95, 0x92, 0x93 };
BORDER  TopRightVPBdr= { 0x95, 0x95, 0x96, 0x96, 0x91, 0x99, 0x92, 0x90 };
BORDER  TopVPBdr     = { 0x95, 0x95, 0x96, 0x96, 0x98, 0x99, 0x92, 0x93 };
BORDER  MiddleVPBdr  = { 0x95, 0x95, 0x96, 0x96, 0x93, 0x92, 0x92, 0x93 };
BORDER  BottomVPBdr  = { 0x95, 0x95, 0x96, 0x96, 0x93, 0x92, 0x9b, 0x9a };
BORDER  LeftVPBdr    = { 0x95, 0x95, 0x96, 0x96, 0x93, 0x95, 0x95, 0x93 };
BORDER  RightVPBdr   = { 0x95, 0x95, 0x96, 0x96, 0x91, 0x92, 0x92, 0x90 };
BORDER  SingleVPBdr  = { 0x95, 0x95, 0x96, 0x96, 0x98, 0x99, 0x9b, 0x9a };
#else   /* NEC_PC9801 */
BORDER  TopLeftVPBdr  = { 205, 205, 179, 179, 213, 205, 181, 198 };
BORDER  TopRightVPBdr = { 205, 205, 179, 179, 209, 184, 181, 207 };
BORDER  TopVPBdr      = { 205, 205, 179, 179, 213, 184, 181, 198 };
BORDER  MiddleVPBdr   = { 205, 205, 179, 179, 198, 181, 181, 198 };
BORDER  BottomVPBdr   = { 205, 205, 179, 179, 198, 181, 190, 212 };
BORDER  LeftVPBdr     = { 205, 205, 179, 179, 198, 205, 205, 198 };
BORDER  RightVPBdr    = { 205, 205, 179, 179, 209, 181, 181, 207 };
BORDER  SingleVPBdr   = { 205, 205, 179, 179, 213, 184, 190, 212 };
#endif   /* NEC_PC9801 */

/*  pointers of menu-bar and all pull-down menus  */
MFORMPTR  MenuBar, Menu[9];

/*  menu-item pointers of menu-bar and all pull-down menus  */
MFIELDPTR  MenuBarItem[9], MenuItem[9][10];

/*  active viewport  */
int  ActVP;

/*  indicate whether the current video mode is "text mode, 80x25 color"  */
int  ColorMode;

/*  colors of active and inactive viewport's titles  */
int  LVPTITLEACT;
int  LVPTITLEINACT;

/*  indicate whether the target will be aborted when USD-III is loaded  */
int  AbortTarget;

/*  command file buffer  */
char  CmdFileBuf[ CMDFILEBUFSIZE + 1 ];

/*  store commands generated from the function key or the softkey  */
char  FuncKeyBuf[ FUNCKEYBUFSIZE + 1 ];

/*  store user-defined commands corresponding to SHIFT-F1 through SHIFT-F10 */
char  SoftKeyBuf[10][ SOFTKEYBUFSIZE + 1 ];

/*  store commands generated from the dialog-box or the menu-item  */
char  DlgBuf[ DLGBUFSIZE + 1 ];

/*  receive the echo string from the MICE  */
char  MICEBuf[ MICEBUFSIZE + 1 ];

/*  store the viewport information while reading from or writing to
    'USD3.SAV'                          */
char  VPInfoBuf[ VPINFOBUFSIZE + 1 ];

/*  user's keyin  */
int  Keyin;

/*  viewport which display routines will act on  */
int  VPOut;

/*  viewport which linking messages will be displayed  */
WINDOWPTR  VPLink;

/*  memory file pointer for choice list  */
MFILEPTR  CListMFilePtr;

/*  uninitialized global variables : be used in "io.asm"  */
long	       near etr_tot, near ext_tot;
int	       near cnt_flag, near spa_flag, near ext_ptr;
int	       near tunit, near lsa_ptr;
int	       near full, near oddev, near fr_cnt;

/* memory file pointer for help */
MFILEPTR   DlgMFilePtr;
WINDOWPTR  CmdHelpWnp;
MFILEPTR   CmdMFilePtr;

/*  original video mode  */
int  OldVideoMode;
int  TmpOldVideoMode;

/*  flag used for masking the updating operations of viewports  */
int  MaskRedrawFlag;

/*  flag used for recognizing the situation that currently displayed command
    are retrived from the history buffer                  */
int  his_flag;

/*  buffer index that current PC indicates  */
int  CurrentPC;

/*  copy of the STABUFROW except executing the ISTEP command  */
int  StaBufRow;

/*  file handle of 'USD3.SAV'  */
int  USD3SAVFileHan;

/*  */
char  LastCOMVPLine[ COMBUFCOL+1 ];

/*  */
int  ExitUSD3 = FALSE;

/*  */
unsigned char  KbdBuf[ CMDBUFSIZE + 1 ] = "";
int          KbdBufIdx = 0;       /*  next character will be read  */
int          KbdBufLastIdx = -1;  /*  last character which was filled  */

/*  */
DLIBPTR  VVDLibp;

/*  */
int  TopVP;

/*  */
int  ExecDlgFlag;

/*  */
DFORMPTR DlgFmPtr;
DFORMPTR lam2Sequence;  // pointer to data form: LAM2TrigSeq
int lam2SeqFlag = FALSE;
CLISTPTR SaveCListPtr;

/*  */
int  VPIsSet[7];

/* function key viewport structure */
WINDOWPTR  FuncKeyVP;
SCRPTR     FuncKeyVPBuf;

/* Ctrl- key viewport structure */
WINDOWPTR  CtrlKeyVP;
SCRPTR     CtrlKeyVPBuf;

/* Alt- key viewport structure */
WINDOWPTR  AltKeyVP;
SCRPTR     AltKeyVPBuf;

/*  */
WINDOWPTR  CmdHelpVP;

/*  */
int  AdapterType;

/*  */
int  REGVPLine;

/*  */
int  ErrorCondition = 0;

/*  */
int  ScrnDisplay = 0;

/* have LAM-II or not */

int  LAM2;

int formRetLevel = 0;

/*  */

struct MonVarTag  MonVar[DATBUFROW];
int               MonVarCount = 0, MonVPfull = 0;

char  CODBuf[CODBUFROW*CODBUFCOL+1];

#ifdef NEC_PC9801

int	      THR = 0x30, RBR = 0x30, IER = 0x37, IIR = 0x32;
int	      LCR = 0x00, MCR = 0x32, LSR = 0x32, MSR = 0x32;
unsigned int  IRQ = 0xffef, IRQCMPL = 0x10;
int	      VEC_NO = 12;
/* CORE 90.08.09 Add PORTC Definition */
int	      PORTC  = 0x35;

#else /* NEC_PC9801 */

int	      THR = 0x3f8, RBR = 0x3f8, IER = 0x3f9, IIR = 0x3fa;
int	      LCR = 0x3fb, MCR = 0x3fc, LSR = 0x3fd, MSR = 0x3fe;
unsigned int  IRQ = 0xffef, IRQCMPL = 0x10;
int	      VEC_NO = 12;

#endif /* NEC_PC9801 */

int             pre_chk_hlt; // added by liu for LSA
char            prompt[15];

/**************************** End of File **********************************/
