/*--------------------------------------------------------------------------*/
/*  gblext.h
/*--------------------------------------------------------------------------*/

/*  information array of viewports  */
extern struct VPtag  VP[];
/*  viewport's border -----
      1. no STAVP
    TopVPBdr    : BREVP, REGVP, TRAVP
    MiddleVPBdr : CODVP
    BottomVPBdr : COMVP
      2. has STAVP
    TopVPBdr    : BREVP, REGVP, TRAVP
    LeftVPBdr   : CODVP
    RightVPBdr  : STAVP
    BottomVPBdr : COMVP
      3. no STAVP, BREVP, REGVP, TRAVP
    TopVPBdr : CODVP
    BottomVPBdr : COMVP
      4. has STAVP, but no BREVP, REGVP, TRAVP
    TopLeftVPBdr   : CODVP
    TopRightVPBdr  : STAVP
    BottomVPBdr    : COMVP
      5. COMVP maximum
    SingleVPBdr    : COMVP
*/
/* CORE 90.08.10 Cheng Bdr Style */
#ifdef NEC_PC9801
extern BORDER  TopLeftVPBdr;
extern BORDER  TopRightVPBdr;
extern BORDER  TopVPBdr;
extern BORDER  MiddleVPBdr;
extern BORDER  BottomVPBdr;
extern BORDER  LeftVPBdr;
extern BORDER  RightVPBdr;
extern BORDER  SingleVPBdr;
#else   /* NEC_PC9801 */
extern BORDER  TopLeftVPBdr;
extern BORDER  TopRightVPBdr;
extern BORDER  TopVPBdr;
extern BORDER  MiddleVPBdr;
extern BORDER  BottomVPBdr;
extern BORDER  LeftVPBdr;
extern BORDER  RightVPBdr;
extern BORDER  SingleVPBdr;
#endif   /* NEC_PC9801 */

/*  pointers of menu-bar and all pull-down menus  */
extern MFORMPTR  MenuBar, Menu[];

/*  menu-item pointers of menu-bar and all pull-down menus  */
extern MFIELDPTR  MenuBarItem[], MenuItem[][10];

/*  active viewport  */
extern int  ActVP;

/*  indicate whether the current video mode is "text mode, 80x25 color"  */
extern int  ColorMode;

/*  colors of active and inactive viewport's titles  */
extern int  LVPTITLEACT;
extern int  LVPTITLEINACT;

/*  indicate whether the target will be aborted when USD-III is loaded  */
extern int  AbortTarget;

/*  command file buffer  */
extern char  CmdFileBuf[];

/*  store commands generated from the function key or the softkey  */
extern char  FuncKeyBuf[];

/*  store user-defined commands corresponding to SHIFT-F1 through SHIFT-F10 */
extern char  SoftKeyBuf[][ SOFTKEYBUFSIZE + 1 ];

/*  store commands generated from the dialog-box or the menu-item  */
extern char  DlgBuf[];

/*  receive the echo string from the MICE  */
extern char  MICEBuf[];

/*  store the viewport information while reading from or writing to
    'USD3.SAV'                          */
extern char  VPInfoBuf[];

/*  user's keyin  */
extern int  Keyin;

/*  viewport which display routines will act on  */
extern int  VPOut;

/*  viewport which linking messages will be displayed  */
extern WINDOWPTR  VPLink;

/*  memory file pointer for choice list  */
extern MFILEPTR  CListMFilePtr;

/* memory file pointer for help */
extern MFILEPTR   DlgMFilePtr;
extern WINDOWPTR  CmdHelpWnp;
extern MFILEPTR   CmdMFilePtr;

/*  original video mode  */
extern int  OldVideoMode;
extern int  TmpOldVideoMode;

/*  flag used for masking the updating operations of viewports  */
extern int  MaskRedrawFlag;

/*  flag used for recognizing the situation that currently displayed command
    are retrived from the history buffer                  */
extern int  his_flag;

/*  buffer index that current PC indicates  */
extern int  CurrentPC;

/*  copy of the STABUFROW except executing the ISTEP command  */
extern int  StaBufRow;

/*  file handle of 'USD3.SAV'  */
extern int  USD3SAVFileHan;

/*  */
extern char  LastCOMVPLine[];

/*  */
extern int  ExitUSD3;

/*  */
extern unsigned char  KbdBuf[];
extern int         KbdBufIdx;      /*  next character will be read  */
extern int         KbdBufLastIdx;  /*  last character which was filled  */

/*  */
extern DLIBPTR  VVDLibp;

/*  */
extern int  TopVP;

/*  */
extern int  ExecDlgFlag;

/*  */
extern DFORMPTR  DlgFmPtr;
extern DFORMPTR  lam2Sequence;  // pointer to data form: LAM2TrigSeq
extern int lam2SeqFlag;
extern CLISTPTR  SaveCListPtr;

/*  */
extern int  VPIsSet[];

/* function key viewport structure */
extern WINDOWPTR  FuncKeyVP;
extern SCRPTR     FuncKeyVPBuf;

/* Ctrl- key viewport structure */
extern WINDOWPTR  CtrlKeyVP;
extern SCRPTR     CtrlKeyVPBuf;

/* Alt- key viewport structure */
extern WINDOWPTR  AltKeyVP;
extern SCRPTR     AltKeyVPBuf;

/*  */
extern WINDOWPTR  CmdHelpVP;

/*  */
extern int  AdapterType;

/*  */
extern int  REGVPLine;

/*  */
extern int  ErrorCondition;

/*  */
extern int  ScrnDisplay;

/* have LAM-II or not */
extern int   LAM2;

extern int formRetLevel;

/*  */
extern struct MonVarTag  MonVar[];
extern int               MonVarCount, MonVPfull;

/*  allocate CODE viewport buffer  */
extern char  CODBuf[];
