/***************************************************************************
**
** File name : include.c
**
**
**
** Changing :
**
** A. Date -- 10/22/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**     3. Delete all "send_ESC()" calling.
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "database.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define ARG_F_ERROR -2


/**************************************************************************
**
** Externals
**
**************************************************************************/
extern int cmdfile_end_flag;
extern int errorCode;

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : includecmd()
**
** Function
**
**     Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

IncludeCmd()
{
extern int MaxIncLevel;
int ll, i;
char c, *cmd_fname, *ptr;

   if (++which >= MaxIncLevel) {
      prn_ferr(3);
      which --;
      return (TRUE);
   }
   init_cmd_f();
   cmd_fname = cmd_syntax.asc;
   if (cmd_logged == TRUE) {
      ll = strlen(log_cmd_file);
      c = cmd_fname[ll];
      if( !strnicmp(cmd_fname,log_cmd_file,ll) && (c == '(' || c == '\0') )
         Blog_close();
   }

   i = ParseArguments(cmd_fname);
   if (i == CMD_F_ERROR)  prn_ferr(2);
   else if (i == ARG_F_ERROR)  prn_ferr(0);
   else
      if ((SUBMIT[which].fd = fopen(SUBMIT[which].cmd_line,"rt")) != NULL) {
         cmdfile_flag = f_cmd_line = 1;
         InitNewCmd();
         WmCmdFile();
      }
      else  prn_ferr(15);
   which --;
   errorCode = 0;
   return (TRUE);
}          /* end of includecmd() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

WmCmdFile()
{
int retcode;

   if (which == 0)  cmdfile_end_flag = 0;
   while ( cmdfile_flag ) {
      if ( ReadCmdFile( -1 ) == END )  break;
      /*  get next command line from the command file  */
      if (CmdFileBuf[0] == CR) {
         DisplayStr("\n\r");
         continue;
      }
      else if (CmdFileBuf[0] != NULL ) {
         keep_it_for_IF = 1;
         send_ESC();    // added by Chen, 08/12/94
         retcode = KeyinProcess(CmdFileBuf, 0);
         // RE_INPUT = -4 and FUNCTION_KEY = -5 in CMDLINE.C
         if (retcode != -4 && retcode != -5)
            send_ESC();    // added by Chen, 08/12/94
            ExecuteCmd(0);
            send_ESC();    // added by Chen, 08/12/94
         if (retcode == -4)
            DisplayStr("\r");
      }
   }  /*  end of while ( cmdfile_flag  )  */
   VPOut = COMVP;
   DisplayCh( CR );
}  /*  of WmCmdFile()  */

/**************************************************************************
**
** Name : ParseArguments()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

static ParseArguments(char *cmd_fname)
{
int i, k, parenth, VPtmp;
char c, *ptr, tempBuf[80];

   k = parenth = 0;
   i = SUBMIT[which].arg_count = -1;
   strcat(cmd_fname, cmd_syntax.input);
   do {
      c = cmd_fname[++i];
      if (SUBMIT[which].arg_count < 0)
         switch(c) {
         case '(':
            SUBMIT[which].cmd_line[k] = '\0';
            SUBMIT[which].arg_count++;
            parenth++;
            k = 0;
            break;
         case ')':
            parenth--;
            SUBMIT[which].cmd_line[k] = '\0';
            goto start;
         case NULL:
         default:
            SUBMIT[which].cmd_line[k++] = c;
         }    /* end of switch(c) */
      else
         switch(c) {
         case ',':
            SUBMIT[which].arg_len[SUBMIT[which].arg_count] = k;
            SUBMIT[which].cmd_line[i] = '\0';
            SUBMIT[which].arg_count++;
            if (SUBMIT[which].arg_count > 9)  return (ARG_F_ERROR);
            k = 0;
            break;
         case ')':
            SUBMIT[which].arg_len[SUBMIT[which].arg_count] = k;
            SUBMIT[which].cmd_line[i] = '\0';
            parenth--;
            goto start;
         default:
            if(!k)
               SUBMIT[which].arg[SUBMIT[which].arg_count] =
                  &(SUBMIT[which].cmd_line[i]);
            SUBMIT[which].cmd_line[i] = c;
            k++;
         }
   } while (c);
start:
   return ((!parenth) ? END : CMD_F_ERROR);
}

/**************************************************************************
**
** Name : init_cmd_f()
**
** Function
**
**     Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

init_cmd_f()
{
int i, j;

   d_buf_idx = d_buf[0] = loop_chk = 0;
   if (which == 0) {   // first level
      lab_ptr = 0;
      looptr = now_loop = -1;
   }
   SUBMIT[which].lab_start = lab_ptr;
   SUBMIT[which].lop_start = looptr;
   for (i = lab_ptr ; i < LABEL_SIZE; i++) {
      memset(upLABEL[i].name, SP, 10);
      upLABEL[i].lin_c = upLABEL[i].pos = 0;
   }
   for (i = looptr+1 ; i < LOOP_SIZE; i++)
      LOOP[i].start_l = LOOP[i].end_l = LOOP[i].count = LOOP[i].if_close = 0;
   memset(SUBMIT[which].cmd_line, SP, sizeof(SUBMIT[which].cmd_line) - 1);
   SUBMIT[which].arg_count = -1;
   SUBMIT[which].labptr_tmp = 0;
   SUBMIT[which].loptr_tmp = SUBMIT[which].line_count = 0;
   error_abort = OFF;
   echo_flag = 1;
}        /* end of init_cmd_f() */


/**************************** End of File **********************************/

