/***************************************************************************
**
** File name : initold.c
**
**
** Changing :
**
** A. Date -- 10/28/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 11/02/1992 By Cheerson
**   x 0. Enlarge IO_COUNT from 5000 to 50000;
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  <sys\types.h>
#include  <sys\stat.h>
#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

#ifdef NEC_PC9801 /*NEC_PC9801*/
#include  <memory.h>
#endif /*NEC_PC9801*/

/**************************************************************************
**
** Local define
**
***************************************************************************/


/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int COMVPMax;
extern int log_count;
extern int sizeFlag;
extern unsigned long VectAdr;
extern unsigned char newVect[];
extern char log_menu_file[];

// copy from Dome, 09/07/94
extern int RBR,THR,IER,IIR,LCR,MCR,LSR,MSR;
extern int VEC_NO;
extern unsigned IRQ, IRQCMPL;

/**************************************************************************
**
** Local Variable / Prototype Define
**
**************************************************************************/

char *baud_pat[] = {
   "110", "150", "300", "600", "1200", "2400", "4800", "9600", "19200",
   "38400", "57600"
};
char *parity_pat[] = {"NONE","ODD","","EVEN"};

/*              "012345678901234567890123456789012345678901234" */
char link_mg1[]="Linking parallel port: 200\n\r";
char link_mg2[80];
int  MAXFlag = 0;
char serial_msg[]="Linking serial port: COM%d %s Baud, 8 Data Bit, NONE Parity\n\r";
int targetCPU;
int diagFlag=0; // Flag for Dignosis  On/Off (1/0)
int testFlag=0; // Flag for Function test  On/Off (1/0)
int goStepFlag=1;
char LOGNAME[81];
int log_fid;
int logFlag;
int InitFlag; //7/08/94, Frank
/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

InitOldGbls()
{
   strcpy(hex,"0123456789ABCDEF");
   IO_COUNT = 20000;
   P_DATA=0x200;
   P_STATUS=0x201;
   PORT = R_2_386 = 0;
   HAND_SHAKE = 3;
   AbortTarget = TRUE;
   SymLoaded = FAIL;
   cmd_logged = out_logged = FALSE;
   sym_flag = echo_flag = 1;
   rear_his = front_his = his_count = 0;
   curr_his = -1;
   sizeFlag = 0;
   log_cmd_file[0] = '\0';
   log_menu_file[0] = '\0';
   log_out_file[0] = '\0';

// copy from Dome, 09/07/94
   baud = -1;
   RS232 = 0xf3;
   RS232_COM = 0;

}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
InitPort()
{
char buf[100];

   strcpy(buf,"( ");
   if (PORT) 
   	strcat(buf,link_mg1);
   else 
	strcat(buf,link_mg2);
   strcpy(buf+strlen(buf)-2," )");
   v_stpl( 7,CENTER_TEXT,buf,VPLink );
   return(OK);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
DisplayLinkMsg(int row, char *buff)
{
	v_stpl( row, LEFT_TEXT, buff, VPLink );
}
*/
// changed by Chen, 07/12/94
const int nLinkStartLine = 8; // used in SUB86.C
DisplayLinkMsg(int row, char *buff)
{
int nRow, nCol;

    if ( VPLink != NULLP ) {
        v_stpl( row, LEFT_TEXT, buff, VPLink );
        strcat(MICEBuf, buff);
        strcat(MICEBuf, "\n");
    }
    else if ( VP[COMVP].Ptr != NULLP ) {
        if ( row == nLinkStartLine ) {
            return;
        }
        csr_plwn(VP[COMVP].Ptr);
        save_curs(&nRow, &nCol);
        v_stpl( nRow+1, LEFT_TEXT, buff, VP[COMVP].Ptr );
    }
}

/**************************************************************************
**
** Name : ReadUSD3INS()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
// char sdInsFileName[512]="SD.INS";   // added by Chen, 07/08/94
char sdInsFileName[512]="MV.INS";   // added by Chen, 09/05/94

ReadUSD3INS()
{
FILE *fp;
int pat_len, i;
char c, buf[81], *ptr, *ptr1, buf2[80];
unsigned long aa, bb;

//   _searchenv("SD.INS", "SD186", sdInsFileName);    // Chen 07/08/94
   _searchenv("MV.INS", "MV186", sdInsFileName);    // Chen 09/05/94

   PORT = 1; /* default as P:200 */
   P_STATUS = 0x201;
   P_DATA = 0x200;
   targetCPU = 5; /* default target CPU is 80C186XL */
   VectAdr = 0x3fc; /* set default INT 3 trap as 0:3fc */
   *((unsigned long *)newVect)=VectAdr;

   if((fp=fopen(sdInsFileName,"r")) != NULL) {

     while(fgets(buf,80,fp) != NULL) {

       ptr = buf - 1;
       do {
         c = *++ptr;
         *ptr = ch_toupper(c);
       } while(c && c!=CR && c!=LF);
       *ptr = '\0';
       ptr = buf;
       while ((c= *++ptr) != ':' && c);
        if (c != ':') {
            memset(buf, NULL, sizeof(buf));
            continue;
        }

    // skip the line started with REM, added by Chen, 08/25/94
        if ( buf[0] == 'R' && buf[1] == 'E' && buf[2] == 'M' && buf[3] == ' ' ) {
            memset(buf, NULL, sizeof(buf));
            continue;
        }

       else if(buf[0] == 'L') {      // skip self-testing
            if ( buf[2] == 'S' ) InitFlag = 1;
            else InitFlag = 0;
       }

       else if(buf[0] == 'P') { // parallel port address
            sscanf(buf+2,"%x",&P_DATA);
            P_STATUS = P_DATA + 1;
            PORT = 1;
            sprintf(&link_mg1[23],"%3x\n\r",P_DATA);
       }

       else if(buf[0] == 'S') { // serial port setting
            do {
                while (!isalnum(c=*++ptr) &&c);
                if (isalpha(c)) {
                    if (!(strncmp(ptr,"COM",3))) {
                        ptr+=3;
                        // if (*ptr == '2') RS232_COM = 1;
                        // copy from Dome, 09/07/94
                        if(*ptr == '2') {
                            RS232_COM = 1;
                            RBR -= 0x100;
                            THR -= 0x100;
                            IER -= 0x100;
                            IIR -= 0x100;
                            LCR -= 0x100;
                            MCR -= 0x100;
                            LSR -= 0x100;
                            MSR -= 0x100;
                            IRQ = 0xfff7;
                            IRQCMPL = 8;
                            VEC_NO = 11;
                        }
                    }
                    else if (c=='E'||c=='O'||c=='N') {
                        RS232 &= 0xe7; // clear bit4, 3
                        if (c != 'N') RS232|=((c=='E')<<4|8);
                    }
                } else if (isdigit(c)) {
                    if (c == '7' || c == '8') {
                        RS232 &= 0xfe;
                        RS232|=(c=='8');
                    }
                    else {
                        // decide_baud(ptr);
                        // copy form Dome, 09/07/94
                        pat_len = decide_baud(ptr);
                        ptr += (pat_len-1);
                    }
                }
            } while(c=*ptr) ;
            sprintf(link_mg2,serial_msg,RS232_COM+1,baud_pat[baud],
                      (RS232&1)+7,parity_pat[(RS232&0x18)>>3]);
            PORT = 0;
       }

       else if(buf[0] == 'M') {     // COMVP is at maximum size
          sscanf(buf+2,"%x", &i);
          MAXFlag = i;
       }

/*
       else if(buf[0] == 'F') {
          sscanf(buf+2,"%x", &i);
          testFlag = i;
       } else if(buf[0] == 'D') {
         sscanf(buf+2,"%x", &i);
         diagFlag = i;
       } else if(buf[0] == 'G') {
         sscanf(buf+2,"%x", &i);
          goStepFlag = i;
       } else if(buf[0] == 'T') {
                  if (strstr(buf+2, "188XL") != NULL) targetCPU=1;
                  else if (strstr(buf+2, "188EA") != NULL) targetCPU=2;
                  else if (strstr(buf+2, "188EB") != NULL) targetCPU=3;
                  else if (strstr(buf+2, "188EC") != NULL) targetCPU=4;
                  else if (strstr(buf+2, "186XL") != NULL) targetCPU=5;
                  else if (strstr(buf+2, "186EA") != NULL) targetCPU=6;
                  else if (strstr(buf+2, "186EB") != NULL) targetCPU=7;
                  else if (strstr(buf+2, "186EC") != NULL) targetCPU=8;
                  else if (strstr(buf+2, "8088") != NULL) targetCPU=9;
                  else if (strstr(buf+2, "80286") != NULL) targetCPU=10;
                  else if (strstr(buf+2, "8086MAX") != NULL) targetCPU=11;
                  else if (strstr(buf+2, "8086MIN") != NULL) targetCPU=12;
                  else if (strstr(buf+2, "V20MAX") != NULL) targetCPU=13;
                  else if (strstr(buf+2, "V20MIN") != NULL) targetCPU=14;
                  else if (strstr(buf+2, "V30MAX") != NULL) targetCPU=15;
                  else if (strstr(buf+2, "V30MIN") != NULL) targetCPU=16;
       }
*/

// marked by Chen, 08/25/94
// SD186 for MICE-III(186) doesn't support the above options
       else if(buf[0] == 'O') {     // log file
				sscanf(buf+2,"%s",LOGNAME);
				log_fid=creat(LOGNAME, S_IWRITE);
				if (log_fid != -1) {
					logFlag=1;
					log_count=0;
				}
       }

/*
       else if(buf[0] == 'R') {
          if (buf[1] != ':') continue;
          sscanf(buf+2,"%s",buf2);
          // changed by Chen, 08/10/94  ; don't support this option
          // AbortTarget = (buf2[0] == 'N');
            AbortTarget = 1;
       }
*/

       else if(buf[0] == 'V') {         // modify INT 3 vector address
          sscanf(buf+2,"%s",buf2);
          if(buf2[0] == 'N') VNFlag = 1;
          else {
            if(!index(buf+2,':')) {
               sscanf(buf+2,"%lx",&VectAdr);
            } else {
               sscanf(buf+2,"%lx:%lx",&aa,&bb);
               VectAdr = (aa << 16) + (bb & 0xffff);
            }
            *((unsigned long *)newVect)=VectAdr;
          }
       }

       else if (buf[0] == 'I') {        // include command file
          auto_flag=1;
          strcpy( KbdBuf, "INC " );
          ptr1 = &KbdBuf[4];
          while(!isalnum(c=*++ptr) &&c);
          if ( c )
            do {
             c=*ptr++;
             *ptr1++=c;
            } while (c);
          *ptr1 = '\0';

          strcat( KbdBuf, "\r" );
          KbdBufIdx = 0;
          KbdBufLastIdx = strlen( KbdBuf ) - 1;
       }

    // initialize the input buffer
        memset(buf, NULL, sizeof(buf));
     }      // end of while ( fgets(...

     fclose(fp);
   }        // end of if( fp = fopen(...

}        /* end of ReadUSD3INS() */


decide_baud(ptr)
char *ptr;
{
	int i,j;
	int pat_len;
	char *p;
	for(i=0 ; i<11 ; i++) {
                pat_len = strlen(baud_pat[i]);
		if(!strnicmp(baud_pat[i],ptr,pat_len)) {
			baud = i;
			RS232 &= 0x1f;
			RS232 |= (baud<<5);
			return(pat_len);
		}
	}
	p = index(ptr,',');
	if(!p) pat_len = strlen(ptr);
	else pat_len = p - ptr;
	return(pat_len);
}

/**************************** End of File **********************************/

