/***************************************************************************
**
** File name : key.c
**
** Changing :
**
** A. Date -- 10/14/1992 By Cheerson
**
**    0. Initial version.
**    1. From USD-III keyboard.c to key.c by "copy keyboard.c key.c".
**    2. Gather and sort externals/includes/local definitions ..etc.
**    3. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/15/1992 By Cheerson
**
**    0. Delete KEY_UP_DN() routine, because that new cmdexp.c should
**       include the history_cmd supporting and all the key operations
**       which include arrow_up/down/left/right, PgUp/PgDn/Home/End.
**    1. Corresponding to modify the KeyinAnalysis() for itme 0.
**
** C. Date -- 10/16/1992 By CHeerson
**
**    0. Delete InputProcess(). Instead of the old InputProcess() function
**       "cmdexp.c"'s routines are in used.
**
** D. Date -- 10/22/1992 By Cheerson
**        0. Delete the "KeyinAnalysis()" routine. Because that USD3.c main
**               program call the keyin process directly by "KeyinProcess" of
**               cmdexp1.c.
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int cursor_appear_or_not;
extern int cursor_appear_or_not;
extern int pulldown_or_dialog, special_dialog;
extern int current_menubar_item, next_menubar_item, next_menubar_item, need_next_mn_rd;
extern int current_status, current_x, current_y;
extern InputProcess();
extern int cmdIdx, synIdx;
extern int MAXFlag;
extern char lineBuf[];
extern char existTraceBoard;

extern char bdrBuf[80];     // Chen 06/01/94
extern U16 cpuReg[];

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define ERROR     -1
#define CORRECT   1
#define DIALOG      2

/**************************************************************************
**
** Local variables
**
***************************************************************************/

/**************************************************************************
**
** GBL variables
**
***************************************************************************/
int  COMVPMax = 0;
int  Text50Lines = 0;
char nullLine = FALSE;

int nMaxToMin = FALSE;  // Chen 06/29/94
    // TRUE:    Alt-F7 to normal command viewport from maximum
    // FALSE:   otherwise

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name :   KEY_F1_F10()
**
** Function : Function_key F1 to F10 operation.
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

KEY_F1_F10()
{
WINDOWPTR   MsgWnp;
static int  COMVPyOrg, COMVPxOrg, COMVPHeight, COMVPWidth;
static int  OldMaskRedrawFlag, STAVPIsUp, DATVPIsUp;
int         COMVPr, COMVPc, COMVProw_org, COMVPcol_org;
DFORMPTR    DFormPtr;
DFIELDPTR   DFieldPtr;
char        ResetMICE[2], *msg, tmpBuf[80];
int         i, ret;
extern WINDOWPTR sCmdHelpWnp;
extern MFILEPTR  sCmdMFilePtr;
unsigned long addr;
KEYFP tempF1;


   nullLine = FALSE;
   if ( CmdHelpWnp && wn_isup(CmdHelpWnp) && (( Keyin >= KEY_AF10 &&
//        Keyin <= KEY_AF5 && Keyin != KEY_AF8) || (Keyin >= KEY_CF10 &&
// Chen 04/02/94
        Keyin <= KEY_AF4 && Keyin != KEY_AF8) || (Keyin >= KEY_CF10 &&
        Keyin <= KEY_CF8)))  return 0;
   switch ( Keyin ) {
      case  KEY_F1  : /*  "Help" command  */
         DisplayHelp(0);
         csr_plwn( VP[COMVP].Ptr );
         return 1;
         break;
      case  KEY_F2  : //  Toggle between 25/50 rows display mode
         i = vid_adapter();
         if (i == MDA || i == CGA)  break;
         SaveScrnLayout();
         Switch50Lines();
         if (COMVPMax) {
            COMVPyOrg   = VP[COMVP].yOrg;
            COMVPxOrg   = VP[COMVP].xOrg;
            COMVPHeight = VP[COMVP].Height;
            COMVPWidth  = VP[COMVP].Width;
            VP[COMVP].Height = vs_rowq() - 2;
            VP[COMVP].yOrg = VP[REGVP].yOrg;
            wn_mod_no_pre_wn_unset( VP[COMVP].yOrg, VP[COMVP].xOrg,
               VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );
         }
         DisplayStr("");   // update command viewport first
         RestoreScrnLayout();

         if (CmdHelpWnp != NULLP) {
            wn_up(CmdHelpWnp);
            mf_disp(CmdHelpWnp);
         }
         if (sCmdHelpWnp != NULLP) {
            wn_up(sCmdHelpWnp);
            mf_disp(sCmdHelpWnp);
         }
         csr_plwn( VP[COMVP].Ptr );
         InitMouse();
         wn_mod( vs_rowq()-1, 0, 1, vs_colq(), ERR_WNP );
         break;
      case  KEY_F3  : //  Toggle Source/Mix/Assembly mode
         ExecuteCmdLine( "MO" );
         break;
      case  KEY_F4  : //  "Find" command (Find next)
         ExecuteCmdLine( "FIN" );
         break;
      case  KEY_F5  : //  "Go" command
         ExecuteCmdLine( "G" );
         break;
      case  KEY_F6  : //  Toggle cursor between Code/Command Viewport
         if ( COMVPMax )  break;
         VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
         v_titleatt( NULLP, LVPTITLEINACT, VP[ActVP].Ptr );
         if ( ActVP == CODVP ) ActVP = COMVP;
         else  {
            ActVP = CODVP;
            VP[ActVP].Ptr->c = 0;
            v_ch( '\x10', VP[CODVP].Ptr );
         }
         VP[ActVP].Ptr->titleatt = LVPTITLEACT;
         v_titleatt( NULLP, LVPTITLEACT, VP[ActVP].Ptr );
         break;
      case  KEY_F7  : //  Go to cursor
         if ( ActVP == CODVP && ((ret=GetAddrInCODVP(VP[ActVP].Ptr->r, &addr))
              == 1 || ret == 6) ) {
            sprintf(tmpBuf, "G %04X:%04X", (U16)(addr>>16), (U16)addr);
            ExecuteCmdLine( tmpBuf );
         }
         else {
            nullLine = TRUE;
            beep_vv( BPMEDIUM, BPMIDDLE);
         }
         break;
      case  KEY_F8  : //  "Step" command
         ExecuteCmdLine( "S" );
         break;
      case  KEY_F9  : //  Set/Unset breakpoint at cursor position
         if ( ActVP == CODVP && ((ret=GetAddrInCODVP(VP[ActVP].Ptr->r, &addr))
              == 1 || ret == 3 || ret == 6) ) {
            if ((i = IsBKPT(addr, (addr>>16)*0x0ffff)) >= 0)
               sprintf(tmpBuf, "CL %2X", i+1 );
            else sprintf(tmpBuf, "BR %04X:%04X", (U16)(addr>>16), (U16)addr);
            ExecuteCmdLine( tmpBuf );
         }
         else {
            nullLine = TRUE;
            beep_vv( BPMEDIUM, BPMIDDLE);
         }
         break;
      case  KEY_F10 : /*  "Step Over" command  */
         ExecuteCmdLine( "S O" );
         break;

// Chen 06/02/94
      case  KEY_AF4 : /*  "Step Till Ret" command  */
         ExecuteCmdLine( "Step Till Ret" );
         break;

      case  KEY_AF5  : //  switches among BREAKPOINT, REGISTER, TRACE viewports and no viewport
                       //  if no Trace Board, toggle between BREAKPOINT and REGISTER viewports
         if ( COMVPMax )  break;

         if ( TopVP != -1 && ActVP == TopVP ) {
            VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
            ActVP = -1;
         }
         if ( TopVP != -1 ) wn_dn( VP[TopVP].Ptr );
         if (existTraceBoard) {
            if (TopVP == -1) TopVP = BREVP;
            else if ( TopVP == BREVP )  TopVP = REGVP;
            else  if ( TopVP == REGVP )  TopVP = TRAVP;
            else  TopVP = -1;
         }
         else {
            if (TopVP == -1) TopVP = BREVP;
            else if ( TopVP == BREVP )  TopVP = REGVP;
            else  TopVP = -1;
         }

        // TRA -> none
         if (TopVP == -1)  {
            VP[DATVP].Height = VP[STAVP].Height = VP[CODVP].Height =
              vs_rowq() - 1 - VP[COMVP].Height;
            VP[DATVP].yOrg = VP[STAVP].yOrg = VP[CODVP].yOrg = 1;
            wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg,
                  VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
            wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg,
                  VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
            wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg,
                 VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
            if ( wn_isup( VP[STAVP].Ptr ) || wn_isup( VP[DATVP].Ptr ) ) {
               v_bdr_csr_plwn( &TopLeftVPBdr, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
               if ( wn_isup( VP[STAVP].Ptr ) )
                  v_bdr_csr_plwn( &TopRightVPBdr, VP[STAVP].Ptr );
               else v_bdr_csr_plwn( &TopRightVPBdr, VP[DATVP].Ptr );
            }
            else {
               v_bdr_csr_plwn( &TopVPBdr, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
            }
            if ( ActVP == -1 ) ActVP = CODVP;
            VP[ActVP].Ptr->titleatt = LVPTITLEACT;
            v_titleatt( NULLP, LVPTITLEACT, VP[ActVP].Ptr );
         }
         else {     // none -> BRE
            if (TopVP == BREVP) {
               sw_opt( WNECHO, OFF, VP[COMVP].Ptr );
               sw_opt( WNECHO, OFF, VP[CODVP].Ptr );
               VP[COMVP].yOrg =
                   VP[BREVP].yOrg + VP[BREVP].Height + VP[CODVP].Height - 2;
                if ( VP[COMVP].yOrg>vs_rowq()-4 ) {
                    VP[COMVP].yOrg = vs_rowq()-4;
                }
               VP[COMVP].Height =
                  vs_rowq() - VP[BREVP].Height - VP[CODVP].Height;
                if ( VP[COMVP].Height<3 ) {
                    VP[COMVP].Height = 3;
                }
               VP[DATVP].yOrg = VP[STAVP].yOrg = VP[CODVP].yOrg =
                   VP[BREVP].yOrg + VP[BREVP].Height -1;
               VP[DATVP].Height = VP[STAVP].Height = VP[CODVP].Height=
                  vs_rowq() - VP[BREVP].Height - VP[COMVP].Height;
               wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg,
                   VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
               wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg,
                  VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
               wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg,
                  VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
               wn_mod_no_pre_wn_unset( VP[COMVP].yOrg, VP[COMVP].xOrg,
                   VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );
               wn_msadj( VP[CODVP].Ptr );
               wn_msadj( VP[COMVP].Ptr );
               sw_opt( WNECHO, ON, VP[CODVP].Ptr );
               sw_opt( WNECHO, ON, VP[COMVP].Ptr );
               wn_upd( VP[CODVP].Ptr );
               wn_upd( VP[COMVP].Ptr );
               if ( wn_isup( VP[STAVP].Ptr )) {
                  sw_opt( WNECHO, OFF, VP[STAVP].Ptr );
                  wn_msadj( VP[STAVP].Ptr );
                  sw_opt( WNECHO, ON, VP[STAVP].Ptr );
                  sw_msorg( ( VP[STAVP].Ptr->r = VP[STAVP].Maxr ) -
                            VP[STAVP].Height + 3, VP[STAVP].Ptr->col_org,
                            VP[STAVP].Ptr );
                  wn_upd( VP[STAVP].Ptr );
               }
               else if (wn_isup( VP[DATVP].Ptr ) ) {
                  sw_opt( WNECHO, OFF, VP[DATVP].Ptr );
                  wn_msadj( VP[DATVP].Ptr );
                  sw_opt( WNECHO, ON, VP[DATVP].Ptr );
                  wn_upd( VP[DATVP].Ptr );
               }
            }
            wn_up( VP[TopVP].Ptr );
            if ( wn_isup( VP[STAVP].Ptr ) || wn_isup( VP[DATVP].Ptr ) ) {
               v_bdr_csr_plwn( &LeftVPBdr, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
               if ( wn_isup( VP[STAVP].Ptr ) )  v_bdr_csr_plwn( &RightVPBdr, VP[STAVP].Ptr );
               else  v_bdr_csr_plwn( &RightVPBdr, VP[DATVP].Ptr );
            }
            else {
                v_bdr_csr_plwn( &MiddleVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
            }
            if ( ActVP == -1 ) ActVP = TopVP;
            VP[ActVP].Ptr->titleatt = LVPTITLEACT;
            v_titleatt( NULLP, LVPTITLEACT, VP[ActVP].Ptr );
            if ( ( TopVP == BREVP ) && ( ! ( MaskRedrawFlag & REDRAWBRE ) ) )
                 UpdateBREVP( 0 );
            else
               if ( ( TopVP == REGVP ) && ( ! ( MaskRedrawFlag & REDRAWREG ) ) )
                  UpdateREGVP();
               else
                  if ( ( TopVP == TRAVP ) && ( ! ( MaskRedrawFlag & REDRAWTRA ) ) )
                     UpdateTRAVP( 0 );
         }
         if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
            csr_hide();
         else
            if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
               csr_show();
         break;
      case  KEY_AF6  : /*  toggles On/Off STACK/DATA viewport  */
         if ( COMVPMax )  break;
         if ( wn_isup( VP[STAVP].Ptr ) ) {
            wn_dn( VP[STAVP].Ptr );
            VP[CODVP].Width = VP[REGVP].Width - VP[DATVP].Width;
            wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
            if ( TopVP == -1 ) {
                v_bdr_csr_plwn( &TopLeftVPBdr, VP[CODVP].Ptr );
            }
            else {
                v_bdr_csr_plwn( &LeftVPBdr, VP[CODVP].Ptr );
            }
            v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
            if (TopVP == -1)
                sw_bdr( &TopRightVPBdr, VP[DATVP].Ptr );
            else
                sw_bdr( &RightVPBdr, VP[DATVP].Ptr );
            wn_up( VP[DATVP].Ptr );
            if ( ! ( MaskRedrawFlag & REDRAWDAT ) )  UpdateDATVP();
            if ( ActVP == STAVP ) {
               VP[STAVP].Ptr->titleatt = LVPTITLEINACT;
               ActVP = DATVP;
               VP[DATVP].Ptr->titleatt = LVPTITLEACT;
               v_titleatt( NULLP, LVPTITLEACT, VP[DATVP].Ptr );
            }
         } else
            if ( wn_isup( VP[DATVP].Ptr ) ) {
               wn_dn( VP[DATVP].Ptr );
               VP[CODVP].Width = VP[REGVP].Width;
               if (TopVP == -1) sw_bdr( &TopVPBdr, VP[CODVP].Ptr );
               else sw_bdr( &MiddleVPBdr, VP[CODVP].Ptr );
               wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
               if ( ActVP == DATVP ) {
                  VP[DATVP].Ptr->titleatt = LVPTITLEINACT;
                  ActVP = CODVP;
                  VP[CODVP].Ptr->titleatt = LVPTITLEACT;
                  v_titleatt( NULLP, LVPTITLEACT, VP[CODVP].Ptr );
               }
            } else {
               VP[CODVP].Width = VP[REGVP].Width - VP[STAVP].Width;
               if (TopVP == -1) sw_bdr( &TopLeftVPBdr, VP[CODVP].Ptr );
               else sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
               wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
               if (TopVP == -1) sw_bdr( &TopRightVPBdr, VP[STAVP].Ptr );
               else sw_bdr( &RightVPBdr, VP[STAVP].Ptr );
               wn_up( VP[STAVP].Ptr );
               if ( ! ( MaskRedrawFlag & REDRAWSTA ) )  UpdateSTAVP();
            }
         if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
            csr_hide();
         else
            if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
               csr_show();
         break;
      case  KEY_AF7  : /*  toggles Maximum/Regular size of COMMAND viewport  */
         if ( ! COMVPMax ) {
            COMVPMax = 1;
            VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
            if (TopVP >= BREVP) wn_dn( VP[TopVP].Ptr );
            wn_dn( VP[CODVP].Ptr );
            if ( STAVPIsUp = wn_isup( VP[STAVP].Ptr ) )
               wn_dn( VP[STAVP].Ptr );
            else
               if ( DATVPIsUp = wn_isup( VP[DATVP].Ptr ) )
                  wn_dn( VP[DATVP].Ptr );
            COMVPyOrg   = VP[COMVP].yOrg;
            COMVPxOrg   = VP[COMVP].xOrg;
            COMVPHeight = VP[COMVP].Height;
            COMVPWidth  = VP[COMVP].Width;
            sw_opt( WNECHO, OFF, VP[COMVP].Ptr );
            sw_bdr( &SingleVPBdr, VP[COMVP].Ptr );
//          wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, 23, VP[REGVP].Width, VP[COMVP].Ptr );
            VP[COMVP].Height = vs_rowq() - 2;
            VP[COMVP].yOrg = VP[REGVP].yOrg;
            wn_mod_no_pre_wn_unset( VP[COMVP].yOrg, VP[COMVP].xOrg,
               VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );
            if ( VP[COMVP].Ptr->r < (VP[COMVP].Ptr->row_org+20) ) {
               sw_msorg( 0, VP[COMVP].Ptr->col_org, VP[COMVP].Ptr );
               wn_msadj( VP[COMVP].Ptr );
               csr_plwn( VP[COMVP].Ptr );
            }
            sw_opt( WNECHO, ON, VP[COMVP].Ptr );
            wn_upd( VP[COMVP].Ptr );
            ActVP = COMVP;
            VP[COMVP].Ptr->titleatt = LVPTITLEACT;
            v_titleatt( NULLP, LVPTITLEACT, VP[COMVP].Ptr );
         } else {
            COMVPMax = 0;
            emuGetAllReg(cpuReg);
            if (MAXFlag) {
                MAXFlag = 0;
                CreateVP();
                InitVPDisplay();
                DisplayPrompt(FALSE);
            } else {
                if (TopVP >= BREVP) {
                    wn_up( VP[TopVP].Ptr );
                }
                else {
                    VP[CODVP].yOrg = VP[STAVP].yOrg = VP[DATVP].yOrg = 1;
                    if ( VP[CODVP].Height>vs_rowq()-4 ) {
                        VP[CODVP].Height=VP[DATVP].Height=VP[STAVP].Height
                        = vs_rowq()-4;
                    }
                    wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg,
                                            VP[CODVP].Height,VP[CODVP].Width,
                                            VP[CODVP].Ptr );
                    wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg,
                                            VP[DATVP].Height,VP[DATVP].Width,
                                            VP[DATVP].Ptr );
                    wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg,
                                            VP[STAVP].Height,VP[STAVP].Width,
                                            VP[STAVP].Ptr );
                    COMVPyOrg = VP[CODVP].yOrg+VP[CODVP].Height-1;
                    COMVPHeight = vs_rowq()-VP[CODVP].Height-1;
                }
                if ( TopVP<BREVP ) {
                    if ( STAVPIsUp ) {
                        sw_bdr( &TopLeftVPBdr, VP[CODVP].Ptr );
                        sw_bdr( &TopRightVPBdr, VP[STAVP].Ptr );
                    }
                    else if ( DATVPIsUp ) {
                        sw_bdr( &TopLeftVPBdr, VP[CODVP].Ptr );
                        sw_bdr( &TopRightVPBdr, VP[DATVP].Ptr );
                    }
                    else {
                        sw_bdr( &TopVPBdr, VP[CODVP].Ptr );
                    }
                }
                sw_bdr( &BottomVPBdr, VP[COMVP].Ptr );
                wn_up( VP[CODVP].Ptr );
                sw_opt( WNECHO, OFF, VP[COMVP].Ptr );
                wn_mod_no_pre_wn_unset( VP[COMVP].yOrg = COMVPyOrg,
                VP[COMVP].xOrg = COMVPxOrg,   VP[COMVP].Height = COMVPHeight,
                VP[COMVP].Width = COMVPWidth, VP[COMVP].Ptr );
                wn_msadj( VP[COMVP].Ptr );
                csr_plwn( VP[COMVP].Ptr );
                sw_opt( WNECHO, ON, VP[COMVP].Ptr );
                wn_upd( VP[COMVP].Ptr );
                if ( STAVPIsUp )  wn_up( VP[STAVP].Ptr );
                else
                   if ( DATVPIsUp ) wn_up( VP[DATVP].Ptr );
                // it will view the current PC address
                nMaxToMin = TRUE;   // Chen 06/29/94
                RedrawFlag = ~MaskRedrawFlag;
                UpdateVP();
           }
        }
        if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
            csr_hide();
         else
            if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
               csr_show();
        csr_plwn( VP[COMVP].Ptr );
         break;
      case  KEY_AF8  : /*  change "active viewport"  */
         if (CmdHelpWnp && wn_isup( CmdHelpWnp ) ) {
            if (sCmdHelpWnp && wn_isup( sCmdHelpWnp )) {
               msg= " Cursor keys to scroll, <ESC> Quit, <Alt-F8> Toggle HELP/Input";
               BrowseHelpWindow( &sCmdHelpWnp, &sCmdMFilePtr, msg );
            }
            else DisplayHelp(2);
            csr_plwn( VP[COMVP].Ptr );
         }
         else ChangeActiveViewport();
         break;
      case  KEY_AF9  :
         if ( COMVPMax )  break;

         if ( ActVP==CODVP || ActVP==STAVP || ActVP==DATVP ) {
            if ( VP[COMVP].Height > 3 )
                ZoomVP( ActVP, BOTTOMSIDE, ZOOMDOWN );
            else
                ZoomVP( ActVP, TOPSIDE, ZOOMUP );
         }
         else
            if ( ActVP==COMVP )
                ZoomVP( ActVP, TOPSIDE, ZOOMUP );
            else
               if ( (ActVP==BREVP) || (ActVP==REGVP) || (ActVP==TRAVP) )
                  ZoomVP( ActVP, BOTTOMSIDE, ZOOMDOWN );
         GetCodeVPRange( PARTIAL );
         break;

      case  KEY_AF10 :
         if ( COMVPMax )  break;

         if ( (ActVP==CODVP) || (ActVP==STAVP) || (ActVP==DATVP) )
            ZoomVP( ActVP, BOTTOMSIDE, ZOOMUP );
         else
            if ( ActVP==COMVP )  ZoomVP( ActVP, TOPSIDE, ZOOMDOWN );
            else
               if ( (ActVP==BREVP) || (ActVP==REGVP) || (ActVP==TRAVP) )
                  ZoomVP( ActVP, BOTTOMSIDE, ZOOMUP );
         GetCodeVPRange( PARTIAL );
         break;

      case  KEY_CF8 :
         if ( ActVP == COMVP ) {
            COMVPr = VP[COMVP].Ptr->r;
            COMVPc = VP[COMVP].Ptr->c;
            COMVProw_org = VP[COMVP].Ptr->row_org;
            COMVPcol_org = VP[COMVP].Ptr->col_org;
         }
         switch (ActVP) {
            case BREVP: v_titleatt( "     \030\031     ", 0, VP[BREVP].Ptr );break;
            case CODVP: v_titleatt( " \030\031\033\032 ", 0, VP[CODVP].Ptr );break;
            case COMVP: v_titleatt( "   \030\031    ", 0, VP[COMVP].Ptr );   break;
            case REGVP: v_titleatt( "    \030\031    ", 0, VP[REGVP].Ptr );  break;
            case STAVP: v_titleatt( "  \030\031   ", 0, VP[STAVP].Ptr );     break;
            case DATVP: v_titleatt( "  \030\031  ", 0, VP[DATVP].Ptr );      break;
            default   : v_titleatt( "  \030\031   ", 0, VP[TRAVP].Ptr );
         }

         MsgWnp = wn_def( vs_rowq()-1,0,1,vs_colq(), LMESSAGE, BDR_NULLP );
         wn_up( MsgWnp );
//       if ( ( ActVP == BREVP ) || ( ActVP == TRAVP ) || ( ActVP == CODVP ) )
//          v_stpl( 0, 1, "Cursor keys to scroll, <ESC> to quit, <Ctrl-PgUp/PgDn> for prev/next buffer", MsgWnp );
//       else
            v_stpl( 0, 1, "Cursor keys to scroll, <ESC> to quit", MsgWnp );

         if ( ( VP[ActVP].Ptr->r < VP[ActVP].Ptr->row_org ) ||
     ( VP[ActVP].Ptr->r > VP[ActVP].Ptr->row_org + VP[ActVP].Height - 3 ) )
            VP[ActVP].Ptr->r = VP[ActVP].Ptr->row_org;

// Chen
        tempF1 = kt_rplkey(KEY_F1, (KEYFP)NULLP ,VIEWKTP);
         wn_browse( VP[ActVP].Ptr );
        kt_rplkey(KEY_F1, (KEYFP)tempF1 ,VIEWKTP);

         wn_dn( MsgWnp );
         wn_free( MsgWnp );
         switch (ActVP) {
            case BREVP: v_titleatt( " BREAKPOINT ", 0, VP[BREVP].Ptr );break;
//            case CODVP: v_titleatt( " CODE ", 0, VP[CODVP].Ptr );      break;
// Chen 06/01/94
            case CODVP: v_titleatt( bdrBuf, 0, VP[CODVP].Ptr );        break;
            case COMVP: v_titleatt( " COMMAND ", 0, VP[COMVP].Ptr );   break;
            case REGVP: v_titleatt( " REGISTER ", 0, VP[REGVP].Ptr );  break;
            case STAVP: v_titleatt( " STACK ", 0, VP[STAVP].Ptr );     break;
            case DATVP: v_titleatt( " DATA ", 0, VP[DATVP].Ptr );      break;
            default   : v_titleatt( " TRACE ", 0, VP[TRAVP].Ptr );
         }

//         if ( ActVP == CODVP )  GetCodeVPRange( PARTIAL );
// Chen 06/01/94
        if ( ActVP == CODVP ) {
            DownView(TRUE);
        }

         if ( ActVP == COMVP ) {
            VP[COMVP].Ptr->r = COMVPr;
            VP[COMVP].Ptr->c = COMVPc;
            sw_msorg( COMVProw_org, COMVPcol_org, VP[COMVP].Ptr );
            wn_msadj( VP[COMVP].Ptr );
            wn_upd( VP[COMVP].Ptr );
         }
         if ( ActVP != COMVP ) {
            if ( cursor_appear_or_not==1 ) csr_plwn( VP[COMVP].Ptr );
            else if ( csr_isvisible() == 1 ) csr_hide();
         } else {
            csr_plwn(VP[COMVP].Ptr);
            if ( cursor_appear_or_not==0 ) cursor_appear_or_not==1;
         }
         break;
      case  KEY_CF9 :
         if ( (++VP[ActVP].BackgrndColor) > YELCOLOR )
            VP[ActVP].BackgrndColor = BLACOLOR;
         else  if ( VP[ActVP].BackgrndColor == BROCOLOR )
              VP[ActVP].BackgrndColor = CYACOLOR;
         sw_att( COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ), VP[ActVP].Ptr );
         ms_clratt( COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ), VP[ActVP].Buf );
         v_chattrow( 0, 0,
              ' ', COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ),
              ENDWN, ATT, VP[ActVP].Ptr );
         if ( ActVP == CODVP )  MarkPC( CurrentPC );
         break;
      case  KEY_CF10:
         if ( (++VP[ActVP].TextColor) > YELCOLOR ) VP[ActVP].TextColor = BLACOLOR;
         else
            if ( VP[ActVP].TextColor == BROCOLOR ) VP[ActVP].TextColor = CYACOLOR;
         sw_att( COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ), VP[ActVP].Ptr );
         ms_clratt( COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ), VP[ActVP].Buf );
         v_chattrow( 0, 0,
                 ' ', COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ),
                 ENDWN, ATT, VP[ActVP].Ptr );
         if ( ActVP == CODVP )  MarkPC( CurrentPC );
         break;
      default   : break;
   }
   return 0;
}  /*  of KEY_F1_F10()  */

/**************************************************************************
**
** Name : ChangeActiveViewport()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
ChangeActiveViewport()
{
   if ( COMVPMax )  return;
   VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
   v_titleatt( NULLP, LVPTITLEINACT, VP[ActVP].Ptr );
   if  ( ActVP == TopVP )  ActVP = CODVP;
   else
      if ( ActVP == CODVP ) {
         if ( wn_isup( VP[STAVP].Ptr ) )  ActVP = STAVP;
         else
            if ( wn_isup( VP[DATVP].Ptr ) )  ActVP = DATVP;
            else  ActVP = COMVP;
      }
      else {
         if ( ( ActVP == STAVP ) || ( ActVP == DATVP ) )  ActVP = COMVP;
         else  if (TopVP >= BREVP) ActVP = TopVP;
         else  ActVP = CODVP;
      }
   VP[ActVP].Ptr->titleatt = LVPTITLEACT;
   v_titleatt( NULLP, LVPTITLEACT, VP[ActVP].Ptr );
   return;
}

/**************************************************************************
**
** Name : Switch50Lines()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
Switch50Lines()
{
int i;

   Text50Lines = !Text50Lines;
   vid_vga50(Text50Lines);

// Adjust positions of FuncKeyVP, CtrlKeyVP, AltKeyVP and CmdHelpVP
   wn_mod_no_pre_wn_unset(vs_rowq() - 1, 0, 1, 80, FuncKeyVP);
   wn_mod_no_pre_wn_unset(vs_rowq() - 1, 0, 1, 80, CtrlKeyVP);
   wn_mod_no_pre_wn_unset(vs_rowq() - 1, 0, 1, 80, AltKeyVP);
   wn_mod_no_pre_wn_unset(vs_rowq() - 1, 0, 1, 80, CmdHelpVP);

/*** Adjust positions and sizes of other viewports ***/
   VP[REGVP].yOrg = VP[BREVP].yOrg = VP[TRAVP].yOrg = 1;
   if (!Text50Lines && VP[REGVP].Height > 19)
      VP[REGVP].Height = VP[BREVP].Height = VP[TRAVP].Height = 19;
   VP[CODVP].yOrg = VP[STAVP].yOrg = VP[DATVP].yOrg =
      VP[REGVP].yOrg + VP[REGVP].Height - 1;
   if (!Text50Lines && VP[CODVP].Height > 23-VP[REGVP].yOrg-VP[REGVP].Height)
      VP[CODVP].Height = VP[STAVP].Height = VP[DATVP].Height =
         23 - VP[REGVP].yOrg - VP[REGVP].Height;
   VP[COMVP].yOrg = VP[CODVP].yOrg + VP[CODVP].Height - 1;
   VP[COMVP].Height = vs_rowq() - 1 - VP[COMVP].yOrg;
   for (i = BREVP; i <= DATVP; i++)
      wn_mod_no_pre_wn_unset(VP[i].yOrg, VP[i].xOrg,
                             VP[i].Height, VP[i].Width, VP[i].Ptr);
}  /* end of Switch50Lines() */

/**************************************************************************
**
** Name : ZoomVP( ZoomedVP, Side, Direction )
**
** Function  : zoom viewport
**
**    Input  : ZoomedVP --
**             Side --
**             Direction --
**
**    Output :
**
** Notes:
**    the sequences of redrawing viewports in processing zooming facility :
**    ( BREVP | REGVP | TRAVP ) ---> CODVP ---> COMVP ---> ( STAVP | DATVP )
**
**************************************************************************/
ZoomVP( ZoomedVP, Side, Direction )
int  ZoomedVP, Side, Direction;
{
U8 changed=0;

   switch ( ZoomedVP ) {
      case BREVP :
      case REGVP :
      case TRAVP :
         if ( Side == TOPSIDE )   /*  bell()  */ ;
         else ZoomVP(CODVP, TOPSIDE, Direction);
         break;
      case CODVP :
      case STAVP :
      case DATVP :
         if ( Side == TOPSIDE )   /*  TOPSIDE  */
            if ( Direction == ZOOMUP )   /*  TOPSIDE, ZOOMUP  */
               if ( TopVP < BREVP || VP[TopVP].Height == 3 )  /*  bell()  */ ;
               else {
                  wn_mod_no_pre_wn_unset( VP[BREVP].yOrg, VP[BREVP].xOrg, --VP[BREVP].Height, VP[BREVP].Width, VP[BREVP].Ptr );
                  wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, --VP[REGVP].Height, VP[REGVP].Width, VP[REGVP].Ptr );
                  wn_mod_no_pre_wn_unset( VP[TRAVP].yOrg, VP[TRAVP].xOrg, --VP[TRAVP].Height, VP[TRAVP].Width, VP[TRAVP].Ptr );
                  wn_mod_no_pre_wn_unset( --VP[CODVP].yOrg, VP[CODVP].xOrg, ++VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
                  v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
                  if ( --VP[STAVP].Ptr->row_org < 0 )  ++VP[STAVP].Ptr->row_org;
                  wn_mod_no_pre_wn_unset( --VP[STAVP].yOrg, VP[STAVP].xOrg, ++VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
                  wn_mod_no_pre_wn_unset( --VP[DATVP].yOrg, VP[DATVP].xOrg, ++VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
                  changed = 1;
               }
            else   /*  TOPSIDE, ZOOMDOWN  */
               if ( VP[CODVP].Height == 3 )
                  if ( VP[COMVP].Height > 3 ) {
                     ZoomVP( COMVP, TOPSIDE, ZOOMDOWN );
                     ZoomVP( CODVP, TOPSIDE, ZOOMDOWN );
                  } else  /*  bell()  */ ;
               else {
                  wn_mod_no_pre_wn_unset( VP[BREVP].yOrg, VP[BREVP].xOrg, ++VP[BREVP].Height, VP[BREVP].Width, VP[BREVP].Ptr );
                  wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, ++VP[REGVP].Height, VP[REGVP].Width, VP[REGVP].Ptr );
                  wn_mod_no_pre_wn_unset( VP[TRAVP].yOrg, VP[TRAVP].xOrg, ++VP[TRAVP].Height, VP[TRAVP].Width, VP[TRAVP].Ptr );
                  wn_mod_no_pre_wn_unset( ++VP[CODVP].yOrg, VP[CODVP].xOrg, --VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
                  v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
                  ++VP[STAVP].Ptr->row_org;
                  wn_mod_no_pre_wn_unset( ++VP[STAVP].yOrg, VP[STAVP].xOrg, --VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
                  wn_mod_no_pre_wn_unset( ++VP[DATVP].yOrg, VP[DATVP].xOrg, --VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
                  changed = 1;
               }
         else   /*  BOTTOMSIDE  */
            ZoomVP(COMVP, TOPSIDE, Direction);
         if (changed && TopVP < BREVP) {
            if (wn_isup(VP[STAVP].Ptr) || wn_isup(VP[DATVP].Ptr)) {
               v_bdr_csr_plwn( &TopLeftVPBdr, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
               if ( wn_isup( VP[STAVP].Ptr ) )
                   v_bdr_csr_plwn( &TopRightVPBdr, VP[STAVP].Ptr );
               else v_bdr_csr_plwn( &TopRightVPBdr, VP[DATVP].Ptr );
            }
            else {
               v_bdr_csr_plwn( &TopVPBdr, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
            }
         }
// 04/28/94
        else if ( changed && TopVP>=BREVP ) {
            if ( wn_isup(VP[STAVP].Ptr) || wn_isup(VP[DATVP].Ptr) ) {
                v_bdr_csr_plwn( &TopVPBdr, VP[TopVP].Ptr );
                v_bdr_csr_plwn( &LeftVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
                if ( wn_isup( VP[STAVP].Ptr ) )
                    v_bdr_csr_plwn( &RightVPBdr, VP[STAVP].Ptr );
                else
                    v_bdr_csr_plwn( &RightVPBdr, VP[DATVP].Ptr );
            }
            else {
                v_bdr_csr_plwn( &TopVPBdr, VP[TopVP].Ptr );
                v_bdr_csr_plwn( &MiddleVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
            }
        }
// 04/28/94
         break;
      case COMVP :
         if ( Side == TOPSIDE )
            if ( Direction == ZOOMUP )   /*  TOPSIDE, ZOOMUP  */
               if ( VP[CODVP].Height == 3 )  {
                  if ( TopVP >= BREVP && VP[TopVP].Height > 3 ) {
                     ZoomVP( CODVP, TOPSIDE, ZOOMUP );
                     ZoomVP( COMVP, TOPSIDE, ZOOMUP );
                  }
               }
               else {
                  wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, --VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
                  if ( --VP[COMVP].Ptr->row_org < 0 )  ++VP[COMVP].Ptr->row_org;
                  wn_mod_no_pre_wn_unset( --VP[COMVP].yOrg, VP[COMVP].xOrg, ++VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );
                  ++VP[STAVP].Ptr->row_org;
                  wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg, --VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
                  wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg, --VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
                  changed = 1;
               }
            else   /*  TOPSIDE, ZOOMDOWN  */
               if ( VP[COMVP].Height == 3 )   /*  bell()  */ ;
               else {
                  wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, ++VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
                  if ( ++VP[COMVP].Ptr->row_org > VP[COMVP].Ptr->r )  --VP[COMVP].Ptr->row_org;
                  wn_mod_no_pre_wn_unset( ++VP[COMVP].yOrg, VP[COMVP].xOrg, --VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );
                  if ( --VP[STAVP].Ptr->row_org < 0 )  ++VP[STAVP].Ptr->row_org;
                  wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg, ++VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
                  wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg, ++VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
                  changed = 1;
               }
         else   /*  BOTTOMSIDE  */
            /*  bell()  */ ;
         if (changed && TopVP < BREVP) {
            if (wn_isup(VP[STAVP].Ptr) || wn_isup(VP[DATVP].Ptr)) {
               v_bdr_csr_plwn( &TopLeftVPBdr, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
               if ( wn_isup( VP[STAVP].Ptr ) )
                   v_bdr_csr_plwn( &TopRightVPBdr, VP[STAVP].Ptr );
               else v_bdr_csr_plwn( &TopRightVPBdr, VP[DATVP].Ptr );
            }
            else {
               v_bdr_csr_plwn( &TopVPBdr, VP[CODVP].Ptr );
               v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
            }
         }
// 04/28/94
        else if ( changed && TopVP>=BREVP ) {
            if ( wn_isup(VP[STAVP].Ptr) || wn_isup(VP[DATVP].Ptr) ) {
                v_bdr_csr_plwn( &TopVPBdr, VP[TopVP].Ptr );
                v_bdr_csr_plwn( &LeftVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
                if ( wn_isup( VP[STAVP].Ptr ) )
                    v_bdr_csr_plwn( &RightVPBdr, VP[STAVP].Ptr );
                else
                    v_bdr_csr_plwn( &RightVPBdr, VP[DATVP].Ptr );
            }
            else {
                v_bdr_csr_plwn( &TopVPBdr, VP[TopVP].Ptr );
                v_bdr_csr_plwn( &MiddleVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
            }
        }
// 04/28/94
   }  /*  of switch ( ZoomedVP )  */
   if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) ) csr_hide();
   else
      if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) ) csr_show();

}  /*  of ZoomVP()  */

/**************************************************************************
**
** Name :  KEY_AF_AH()
**
** Function : Menu-bar operation for Alt+F  --> "FILE"
**                                   Alt+S  --> "SETUP"
**                                   Alt+M  --> "MEMORY"
**                                   Alt+E  --> "EMULATION"
**                                   Alt+T  --> "TRACE"
**                                   Alt+Y  --> "SYMBOL"
**                                   Alt+O  --> "OPTION"
**                                   Alt+P  --> "SPA"
**                                   Alt+L  --> "LSA"
**    Input  : none
**
**    Output :
**
** Notes:
**    KEY_AF ~~ KEY_AL are defined in vv_key.h of vermont-view.
**
**************************************************************************/

KEY_AF_AH()
{
WINDOWPTR   MsgWnp;
int         i, j;

   switch (Keyin) {
      case KEY_AF :  i = 0; break;
      case KEY_AS :  i = 1; break;
      case KEY_AM :  i = 2; break;
      case KEY_AE :  i = 3; break;
      case KEY_AT :  i = 4; break;
      case KEY_AY :  i = 5; break;
      case KEY_AO :  i = 6; break;
      //**** added by liu for spa, lsa
      case KEY_AP :  i = 7; break;
      case KEY_AL :  i = 8; break;
      //**** end by liu
      default     :  return 0;
   }

   DlgBuf[0] = '\0';
   ExecDlgFlag = 0;
   MsgWnp = wn_def( vs_rowq()-1,0,1,vs_colq(), LMESSAGE, BDR_NULLP );
   wn_up( MsgWnp );
   v_stpl( 0, 1, "<F1> for help, Cursor keys to move, <ESC> to quit, <CR> to select", MsgWnp );

   need_next_mn_rd = 0;

   do {
      current_menubar_item = i;
      if (cmdfile_flag || menu_flag) {
         for (j= FILMENU; j <= LSAMENU; j++) smn_entrynum(0, Menu[j]);
      }
      mn_rd( i, MenuBar );
      if ( !need_next_mn_rd ) break;
      else
         if ( need_next_mn_rd == 1 ) {
            i = next_menubar_item;
            need_next_mn_rd = 0;
         } else {
            ShowCursor();
            do {
               ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
               if (current_status != 1) {
                  HideCursor();
                  goto do_wn_dn;
               }
               current_x /= 8;
               current_y /= 8;
               i = MenubarItemNo(current_x, current_y);
               if ( ( i >= 0 ) && ( i <= 8 ) ) {
                  HideCursor();
                  break;
               }
            } while ( 1 );
         }
   } while (1);

do_wn_dn:
   wn_dn( MsgWnp );
   wn_free( MsgWnp );
   if ( ExecDlgFlag ) ExecDlg();
   csr_plwn( VP[COMVP].Ptr );
   if (ExecDlgFlag) return 1 ;
   else return 0 ;
}  /*  of KEY_AF_AH()  */


/**************************************************************************
**
** Name : KEY_SF1_SF10()
**
** Function : Soft-key F1 to F10
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

KEY_SF1_SF10()
{
int  i;

   if (strlen(lineBuf)) {
      ClearLine();
      DisplayPrompt(FALSE);
   }
   strcpy( FuncKeyBuf, SoftKeyBuf[ KEY_SF1 - Keyin ] );
   strcat( FuncKeyBuf, "\r" );

 /*  change ';' to CR  */
   i = 0;

   while ( FuncKeyBuf[i] != '\0' ) {
      if ( FuncKeyBuf[i] == '\073' )  FuncKeyBuf[i] = '\015';
      i++;
   }
   i = KEY_SF1 - Keyin;
   ExecSoftKey(i);
}  /*  of KEY_SF1_SF10()  */

/**************************************************************************
**
** Name : ExecSoftKey()
**
** Function : execute commands generated from the function key or the softkey
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

static ExecSoftKey(int kn)
{
int cmd, syn, chkFlag;
// char tempBuf[240];
char tempBuf[512];    // Chen 06/08/94
int i=0,j=0, tempInt=-1;

   memset(tempBuf,NULL,sizeof(tempBuf));
   do {
      tempBuf[++tempInt] = SoftKeyBuf[kn][i++];
      if ( tempInt && (( tempBuf[tempInt] == ';' ) || ( tempBuf[tempInt] == 0 )) ) {
         tempBuf[tempInt] = CR;
            if ( tempInt >= 510 ) {     // added by Chen 06/08/94
                tempInt = 510;
            }
         tempBuf[tempInt+1] = NULL;     // added by Chen 06/08/94
         chkFlag = KeyinProcess(tempBuf, 0 );
         ExecuteCmd(0);
         DisplayPrompt(FALSE);
         // reset the counter to the first character of the buffer
         tempInt = -1;
        memset(tempBuf,NULL,sizeof(tempBuf));   // Chen 06/08/94
     }
   } while (SoftKeyBuf[kn][i-1] != 0);
}  /*  of ExecSoftKey()  */

/**************************************************************************
**
** Name : ExecDlg()
**
** Function : execute commands generated from the dialog-box or the menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ExecDlg()
{
 int i=0, j=0;
 char tempBuf[512+1], k, *localBuf;

 localBuf = malloc( strlen(DlgBuf) + 1);
 strcpy( localBuf, DlgBuf );
 if (!cmdfile_flag && strlen(lineBuf)) {
    ClearLine();
    DisplayPrompt(FALSE);
 }
 memset(tempBuf, NULL, sizeof(tempBuf));
 while ( localBuf[i] ) {
    if (j >= 511) {
       DisplayStr("\n\r");
       prn_ferr(78);
       memset(DlgBuf, NULL, 5 * CMDBUFSIZE);
       return;
    }
    k = tempBuf[j++] = localBuf[i++];
    if (k == '\r') {
       KeyinProcess(tempBuf, 0);
       ExecuteCmd(0);
       if (!cmdfile_flag || (cmdfile_flag && localBuf[i])) DisplayPrompt(FALSE);
       j=0;
    }
 }
 free( localBuf );
}  /*  of ExecDlg()  */

/**************************************************************************
**
** Name : ExecuteCmdLine()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
ExecuteCmdLine(char *cmdLine)
{
    if (strlen(lineBuf)) {
       ClearLine();
       DisplayPrompt(FALSE);
    }
    sprintf( FuncKeyBuf, "%s\r", cmdLine );
    KeyinProcess( FuncKeyBuf, 0);
    ExecuteCmd(0);
    return;
}
/******************************* End of File *******************************/
