/***************************************************************************
**
** File name : lib1.c
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**    3. Delete the "Parser()" routine. We use the "InputProcess()" of
**       "cmdexp.c" to deal with the command parsing include the syntax
**       checking.
**    4. Delete the "parser2_go_cmd()" routine. The reason is the same as
**       item-3.
**    5. Delete the "parser2_breakpoint_cmd() " routine. The reason is the
**       same as item-3.
**    6. Delete the "parser2_clear_cmd() " routine. The reason is the same
**       as item-3.
**    7. Delete the "MICEEchoKeyin" routine. It's no necessary to echo the
**       user's keyin.
**    8. Delete the "USDtoupper()". Use "ch_toupper()" instead of old one.
**       Other .c files have to change this using for decreasing the calling
**       deepth/stack.
**
** B. Date -- 10/20/1992 By Cheerson
**    0. Delete the "usd_fclose(int fd)", no other routine call this.
**    1. In "cmd_f.c" file has to change "USDtoupper()" to "ch_toupper()".
**       For the reason as upper item-8.
**
** C. Date -- 11/02/1992 By Cheerson
**     0. Modify the "receive()" routine for dat receive a "0".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  <bios.h>
#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "reg86.h"

int ESCflag=0;
#define LOG_SIZE 2048

char log_buf[LOG_SIZE];
int log_count;
/**************************************************************************
**
** Externals
**
**************************************************************************/
extern int P_DATA, P_STATUS;
extern int log_fid, logFlag;
extern char prompt[]; // by liu

extern int read_pcport(char *);
/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : usd_strncmp(a,b,c)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
usd_strncmp(a,b,c)
char *a, *b;
int c;
{
   int len, i;
   int VPtmp;

   if ((a==0L) || (b==0L)) return(1);
   len = strlen(b);
   for(i=0 ; i<c ; i++)
        if(ch_toupper(a[i]) != b[i]) break;
   if(i < c) return(1);
   for( ; i<len+1 ; i++)
        if(!a[i] || (ch_toupper(a[i]) != b[i])) break;
   if(!a[i] || a[i]==SP || a[i]==CR) return(0);
   return(1);
} */      /* end of usd_strncmp(a,b,c) */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ishex(c)
char c;
{
   return(isdigit(c) || (c>='A'&&c<='F') || (c>='a'&&c<='f') || c==':');
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

asc__h(k)
{
   if(isdigit(k)) k -= '0';
   else k = k - 'A' + 10;
   return(k);
}


/**************************************************************************
**
** Name : hlld_lmalloc(flag,size)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

char *hlld_lmalloc(flag,size)
WORD flag;
WORD size;
{
   if((ptr_malloc.ptr = malloc(size)) == NULL) return(NULL);
   return(ptr_malloc.ptr);
}         /* end of hlld_lmalloc(flag,size) */

/**************************************************************************
**
** Name : hlld_lfree(p)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

hlld_lfree(p)
struct malloc_tag *p;
{
   free(p->ptr);
} /* end of hlld_lfree(p) */


/**************************************************************************
**
** Name : UsdOpenFile(lptr,flag)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

UsdOpenFile(lptr,flag)
char  *lptr;
int   flag;
{
 return( open( lptr, flag | O_BINARY ) );
}    /* end of UsdOpenFile(lptr,flag) */


/**************************************************************************
**
** Name : GetPC(ppp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

GetPC(ppp)
struct pcstatus *ppp;
{
char *ptr, *ptr1;
int i;
unsigned long l, l1;

   //killAllRegs();
   emuGetReg(I86_REG, REG_PC, &l);
   ptr = ppp->addr;
   for (i=3;i>=0;i--) {
      l1 = (l>>(i*8)) & 0xff;
      *ptr++ = (unsigned char) l1;
   }
   ptr = ppp->addr;
   ptr1 = ppp->ascii;
   for (i=0;i < 4;i++) {
      hex2asc(ptr1,*ptr++);
      ptr1 += 2;
      if (i == 1) *ptr1++ = ':';
   }
   ppp->flag = OK;
}         /* end of GetPC(ppp) */

/**************************************************************************
**
** Name :  upRX_DATA()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

upRX_DATA()
{
char c;
int ret;

	if (PORT) {
		if(inportb(P_STATUS)&RV_RDY) c=inportb(P_DATA);
		else c = -1;
	} else {
        ret=read_pcport(&c);
		if (ret != 1) return(-1);
	}
	return(c);
}          /* end of upRX_DATA() */

writeLog(fd,c)
int fd;
char c;
{
	log_buf[log_count++]=c;
	if (log_count == LOG_SIZE) {
		write(fd, log_buf, LOG_SIZE);
		log_count = 0;
	}
}

SEND_str(str)
char *str;
{
	int c,i;   // DOS/16M
	while((c=*str++)) {
		send(c);
		while(receive() != c) ;
	}
	send(CR);
	for( i = 0; i < (IO_COUNT*2); i++ );  /*  for firmware parsing delay  */
	while(receive() != CR) ;
	while((c=receive())==CR || c==LF || !c) ;
	return(c);
}

/**************************************************************************
**
** Name : receiveWait1Sec()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
receiveWait1Sec() {
int rxData, i;
   for ( i = 0; i < IO_COUNT; i++ )
      if(inportb(P_STATUS) & RV_RDY) {
         rxData = inportb(P_DATA);
         return(rxData);
      }
   return(-1);
}
*/

/**************************************************************************
**
** Name : receive()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
receive()
{
int c, i;
  while (1) {
     for ( i = 0; i < IO_COUNT; i++ )
        if( (c=upRX_DATA()) > 0 ){
           if (logFlag) writeLog(log_fid, (char)c);
             return(c);
        }

     if (chk_hlt() == ESC) {
         ESCflag=1;
         return(-1);
     }
   }
}         /* end of receive() */

/**************************************************************************
**
** Name : receive2()
**
**************************************************************************/
receive2()
{
int c, i;
   for ( i = 0; i < IO_COUNT; i++ ) {
	  if (chk_hlt() == ESC) {
	  	ESCflag=1;
	    return(-1);
      }
      if( (c=upRX_DATA()) > 0 ){
         if (logFlag) writeLog(log_fid, (char)c);
           return(c);
      }
   }
   return(-2);
}         /* end of receive2() */
/**************************************************************************
**
** Name :   InitNewCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

InitNewCmd()
{
   char *ptr, c;

// CmdKeyinBufIdx = -1;
// ModuInCmd = NOT_IN_LOCAL;
   usd_prn_ferr= 0;
   VPOut = COMVP;

   if ( wn_isup( CmdHelpVP ) )  wn_dn( CmdHelpVP );
}           /* end of InitNewCmd() */

/**************************************************************************
**
** Name : DebugInfo( VPName, Row, Col, Info )
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
DebugInfo( VPName, Row, Col, Info )
int   VPName,Row,Col;
char  *Info;
{
 int VPTmp;

 VPTmp=VPOut;
 VPOut=VPName;
 DisplayPosStr(Row,Col,Info);
 VPOut=VPTmp;
} */      /* end of DebugInfo( VPName, Row, Col, Info ) */

/**************************************************************************
**
** Name : IsBKPT
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

IsBKPT(unsigned long addr,unsigned long csp) {
int i;
   for (i=0;;i++) {
      if (!SwBreak[i].exists) return(-1);
      if (SwBreak[i].address == addr) return(i);
   }
}         /* end of IsBKPT */

do_1_cmd_save(cmd,ptr,len)
char *cmd, *ptr;
int len;
{
	char c;
	c = SEND_str(cmd);
/****** 5-22-89, for MICE-II not LF-CR pair */
	*ptr++ = c;
	len--;
	while(--len && (c=receive_2()) != HAND_SHAKE) {
		if(c) *ptr++ = c;
	}
	*ptr = '\0';
	return((len) ? OK : BUFFULL);
}

/******************************* End of File *****************************/

receive_2()
{
	int c, i;
	extern int  pre_chk_hlt;

	while (1) {

		for ( i = 0; i < IO_COUNT; i++ )
			if( (c=upRX_DATA()) > 0 )  return(c);

		disableRS232();
		if ( ( chk_hlt() == ESC ) && !pre_chk_hlt )  pre_chk_hlt = 1;
		enableRS232();
	}
}

d_o_prompt()
{
	if(echo_flag) {
		VPOut = COMVP;
		d_putc(LF);
		d_putc(CR);
		d_prntf(prompt);
		DisplayCMDCURSOR();
	}
}

