/***************************************************************************
**
** File name : lib2.c
**
**
**
** Changing :
**
** A. Date -- 10/22/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**    3. Change "USDtoupper()" to "ch_toupper()".
**     4. Delete "WmTimer()" routine.
**     5. Delete all "send_ESC()" routine calling.
**
** B. Date -- 10/23/1992 By Cheerson
**     0. Delete the "LogOneCmdLine()" routine. Directly use the while
**       loop in the "CRwasPressed()" in "cmdexp1.c".
**     1. Call loop of "logb()" instead of "LogOneCmdLine()".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/
#ifndef _SYSTEMDEF_
#include  "system.h"
#endif
#include  "menu.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif
#include  "reg86.h"
#include  <signal.h>
#include  "database.h"
#ifndef _SD_ABI_EXT_
#include  "sdabiext.h"
#endif
#ifndef _LINUMDEF_
#include  "linumdef.h"
#endif
#include <time.h>
#include <errno.h>
#include <process.h>
#include <sys\timeb.h>

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define PC_ONLY 0
#define NO_PC   2
#define EMPTY   20

#define PULLDOWN   1
#define DIALOG      2

#define BKPT_SIGN '*'
#define ASM         0
#define HIGH        1
#define MIX         2
#define ADDR2ABS(addr)  (U32)((addr>>12)&0x0FFFF0) + (U16)addr

/**************************************************************************
**
** Global variables
**
***************************************************************************/
char dspMode = ASM;

/**************************************************************************
**
** Local variables
**
***************************************************************************/

int  AskAbortUSD3 = 0;

// unsigned char dsm_buf[80];
// Added by Chen, 02/16/95
unsigned char dsm_buf[256];

unsigned char codvp_buf[512];
int  USD3CtrlCHandler();
int cmdfile_end_flag=0;
unsigned int curLineNum=0;

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int pulldown_or_dialog;
extern int mouse_have_been_pressed, mouse_not_released;
extern int special_dialog;
extern int Text50Lines;
extern unsigned char langMode;
extern int backLevel;   // the stack depth of current code viewport
extern int  (*OldCtrlCHandler)();
extern CURRENT_MODULE curModule;
extern int COMVPMax;
extern void ShowCPUType(void);
extern int errorflag;       // Chen 06/01/94 MV186.V13
extern int NECflag;

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

getc_mpds()
{
   char c;
   if(cmdfile_flag) {
         if (ReadCmdFile(-1) != END) {
            c = CmdFileBuf[0];
            return(c);
         } else EndCmdFile();
   }
   c = get_key();
   return(c);
}



/****************************************************************************
**
** Name      : get_key()
**
** Function  : wait and accept a key input
**
**    Input  : none
**
**    Output : key code
**
** Notes     :
**
****************************************************************************/
int get_key( void )
{
    extern void UpdateCtrlKeyVP(void);
    extern void UpdateAltKeyVP(void);
    extern void RestoreFuncKeyVP(void);

    int   Keyin,i;
    int keyStatus = 0;   // one bit set for Ctrl, Alt and Shift key depressed

    ShowCursor();

    do {
        pulldown_or_dialog = PULLDOWN;
        special_dialog = 0;
        i = Keyin = 0;
        mouse_have_been_pressed = mouse_not_released = 0;

        keyStatus = ki_stat();
        if ( keyStatus & CTRL_ISDOWN ) {
            UpdateCtrlKeyVP();
        }
        else if ( keyStatus & ALT_ISDOWN ) {
            UpdateAltKeyVP();
        }
        else {
            RestoreFuncKeyVP();
        }

        if ( ki_chk() != 0 ) {
            Keyin = ki();
        }
        else {
            i = MouseSVR( &Keyin );
        }

        if ( i ) {
            return ( 0 );
        }

        if ( ( Keyin == 3 ) || ( Keyin == -1 ) ) { // CTRL-C or CTRL-BREAK
            HideCursor();
            if ( AbortUSD3() ) {
                DestroyVP();
                DestroyMenu();
                WmClose();
                FreeGbl();
                vs_clr();
                USD3vid_setmode( OldVideoMode );
                exit_vv();
                exit(-1);
            }
            else {
                ShowCursor();
                continue;
            }
        }
        else if ( Keyin != 0 ) {
            HideCursor();
            return ( Keyin );
        }

    } while ( 1 );

}   // end of get_key()



/**************************************************************************
**
** Name : chk_kb()
**
** Function : check keyboard input and get it if it existed
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

chk_kb()
{
int  Keyin;

   Keyin = 0;
   if ( ki_chk() ) Keyin = ki();
   else ChkMouseLBAndEsc(&Keyin);/*MouseSVR(&Keyin);*/
   if ( ( Keyin == 3 ) || ( Keyin == -1 ) ) {
     if ( AbortUSD3() ) {
        DestroyVP();
        DestroyMenu();
        WmClose();
        FreeGbl();
        vs_clr();
        USD3vid_setmode( OldVideoMode );
        exit_vv();
        exit(-1);
     } else return( 0 );
   } else return( Keyin );

}  /*  of chk_kb()  */

/**************************************************************************
**
** Name : chk_hlt()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

chk_hlt()
{
int c=0;
extern unsigned char    CoverageEscFlag;

   c = chk_kb();
   if (c == ESC) {
      if (cmdfile_flag) cmdfile_end_flag = 1;
      CoverageEscFlag = 1;
   }
   else if (c == CTRL_S)
      while ((c=get_key()) != CTRL_Q && c != ESC)  ;
   return (c);
}  /*  of chk_hlt()  */

/**************************************************************************
**
** Name : DisplayCharAndShowCursor(c)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayCharAndShowCursor(c)
{
   EraseCMDCURSOR();
   d_putc(c);
   DisplayCMDCURSOR();
}        /* end of DisplayCharAndShowCursor(c) */

/**************************************************************************
**
** Name : get_str2(buf,len)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
get_str2(char *buf, int len)
{
int r=END, r1;
char *ptr11, c1;

   in_get_str2 = 1;
   if(cmdfile_flag == 1) {
      while((r=ReadCmdFile(-1))!=END &&
            (r1=CMDFILEget_str2(CmdFileBuf,len))==(END+10)) ;
      strncpy(buf, CmdFileBuf, len);
      buf[len] = '\0';
   }
   if(r == END) r = STDINget_str2(buf,len);
   else {
     if(!r1) {
       if(CmdFileBuf[0] == ESC) r = ESC;
       else {
         get_str2_BuftoUpper(CmdFileBuf);
         d_putc(LF);
         strcpy(buf,CmdFileBuf);
       }
     } else r = r1;
   }
   if(cmd_flag) {
     if(r) {
       if(r == ESC) logb('\\');
       else logb(r);
     } else {
       ptr11 = (char *)buf;
       while((c1=*ptr11++)!=CR && c1!=LF) logb(c1);
     }
     logb(CR);
     logb(LF);
   }
   in_get_str2 = 0;
   return(r);
}        /* end of get_str2(buf,len) */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

CMDFILEget_str2(char *buf,int len)
{
char *ptr, *ptr11, *ptr22, a, c, flag[100];
int i, j, in_def=0, in_sym=0;
char quotation;

     ptr = flag;
     *ptr = in_sym;
     ptr11 = (char *) buf;
     while(c = *ptr11++) {
       switch(c) {
         case SP:
            if(R_2_386 && env.Mmodel==25) continue;
            if(more_encounter==1 || R_2_386) goto RET1;
            if(in_sym) in_sym = 0;
            *ptr++ = in_sym;
            d_putc(c);
            break;
         case CR:
         case ESC:
               goto RET1;
            default:
               if (!R_2_386 && (c > 0x20 && c <= 0x7E && more_encounter != 1)) {
                  if (!in_sym)
                     if (!in_def && (c == '\'' || c == '"')) {
                        quotation = c;
                        in_def = 1;
                        *ptr++ = 0;
                     }
                     else if (in_def && c == quotation) {
                        quotation = 0;
                        in_def = 0;
                        *ptr++ = 0;
                     }
                  if(c == NAME && !in_def) {
                     in_sym = 1;
                     *ptr++ = 0;
                  }
                  if (c != NAME && !isalnum(c) && c != '_')  in_sym = 0;
                  if (!in_sym && !in_def)  c = ch_toupper(c);
                  *ptr++ = in_sym;
                  d_putc(c);
               }
         }
      }
      c = END + 10;
RET1:
   return(c);
}

/**************************************************************************
**
** Name : STDINget_str2(buf,len)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STDINget_str2(char *buf,int len)
{
char *ptr, *ptr11, a, c, flag[100];
int i, j, in_def=0, in_sym=0;
char quotation;

   DisplayCMDCURSOR();
   more_encounter = 0;  // added by Chen, 08/18/94
   ptr = flag;
   *ptr = in_sym;
   ptr11 = (char *) buf;
   *ptr11 = CR;
   while(1) {
      switch(c=getc_mpds()) {
      case ESC:
         goto RET1;
      case BS:
         if(!R_2_386 && ptr11 != buf) {
            ptr--;
            ptr11--;
            DisplayCharAndShowCursor(BS);
            in_sym = *ptr;
            if (!in_def && (*ptr11 == '\'' || *ptr11 == '"')) {
               quotation = *ptr11;
               in_def = 1;
            }
            else if (in_def && *ptr11 == quotation) {
               quotation = 0;
               in_def = 0;
            }
            more_encounter = 0;  // added by Chen, 08/18/94
         }
         continue;
      case CTRL_S:
         if (R_2_386) continue;
         while((c=get_key())!=CTRL_Q && c!=ESC) ;
         if(c==ESC) goto RET1;
      case CTRL_Q:
         continue;
      case CR:
         if(more_encounter == 0) {
            *ptr11++=c;
            *ptr11 = '\0';
            EraseCMDCURSOR();
            d_putc(CR);
            c = 0;
         }
         goto RET1;
      default:
         if(more_encounter != 1 && !R_2_386 && c >= 0x20 && c <= 0x7E) {
            if (!in_sym)
               if (!in_def && (c == '\'' || c == '"')) {
                  quotation = c;
                  in_def = 1;
                  *ptr++ = 0;
               }
               else if (in_def && c == quotation) {
                  quotation = 0;
                  in_def = 0;
                  *ptr++ = 0;
               }
            if(c == NAME && !in_def) {
               in_sym = 1;
               *ptr++ = 0;
            }
            if (in_sym)
               if(c != NAME && !isalnum(c) && c!='_') in_sym = 0;
            if(!in_sym && !in_def) c=ch_toupper(c);
            *ptr++ = in_sym;
            if((ptr11-buf) >=len) {
                more_encounter = 1; // added by Chen, 07/18/94
               beep_vv(BPMEDIUM, BPLOW);
            } else {
               *ptr11++ = c;
               DisplayCharAndShowCursor(c);
            }
         }
         else if ( more_encounter == 1 ) {  // added by Chen, 07/18/94
               beep_vv(BPMEDIUM, BPLOW);
         }
      }
   }

RET1:
   EraseCMDCURSOR();
   return(c);
}        /* end of STDINget_str2(buf,len) */

/**************************************************************************
**
** Name : get_str2_BuftoUpper(s)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

get_str2_BuftoUpper(char *s)
{
   char c, *p= s - 1;
   int in_sym=0, in_def=0;
   while(c = *++p) {
      if(c == DEFINE_BYTE && !in_sym) in_def = 1 - in_def;
      else if(c == NAME && !in_def) in_sym = 1;
      else if(!isalnum(c) && c!='_') in_sym = 0;
        *p = (!in_sym && !in_def) ? ch_toupper(c) : c;
   }
}        /* end of get_str2_BuftoUpper(s) */

/**************************************************************************
**
** Name : save_curs(rp,cp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

save_curs(rp,cp)
int *rp, *cp;
{
   *rp = VP[COMVP].Ptr->r;
   *cp = VP[COMVP].Ptr->c;
}      /* end of save_curs(rp,cp)   */

/**************************************************************************
**
** Name : set_cur(r,c)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

set_cur(r,c)
{
   VP[COMVP].Ptr->r = r;
   VP[COMVP].Ptr->c = c;
}         /* end of set_cur(r,c) */

/**************************************************************************
**
** Name : open_a_o(str,fdptr,flag)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

open_a_o(str,fdptr,flag)
char *str, flag;
LPINT fdptr;
{
   char c, tmp_cmd_flag, bbuu[80];
   int mode=OF_CREATE|OF_WRITE;
   long ll=0L;

   tmp_cmd_flag = cmd_flag;
   cmd_flag = 0;
   if((*fdptr=UsdOpenFile((LPSTR)str,O_RDONLY)) != -1) {
        close(*fdptr);
      if(flag == 'I') {
aa:
         d_prntf(" File already existed, overwrite? [Y/N] ");
         c = get_str2(bbuu,10);
         DisplayStr("\r\n");
         if(c == ESC) return(c);
         c = bbuu[0];
         if(c=='N' || c=='n') {
            c = ESC;
         return(c);
         } else if(c!='Y' && c!='y') goto aa;
      } else if(flag=='A' || flag=='a') mode = OF_READWRITE;
   }

// MV186.V13
  if ( errorflag ||
     ( *fdptr = open((LPSTR)str, mode|O_BINARY, S_IREAD|S_IWRITE)) == -1 ) {
      prn_ferr(15);
      c = 1 - OPEN_OK;
   } else {
      c = OPEN_OK;
      if(flag=='A' || flag=='a') ll = _llseek(*fdptr,0L,SEEK_END);
   }
   cmd_flag = tmp_cmd_flag;
   return(c);
}        /* end of open_a_o(str,fdptr,flag) */

/**************************************************************************
**
** Name : JournalCh(c)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

JournalCh(c)
char c;
{
   int c1;
   if(!c) return;
   if(c == TAB) c = NAME;
   if(out_flag == 1 && VPOut==COMVP) {
      if(c == BS) {
         if(!log_cnt) {
            _llseek(fd_out_log,(long)(-1),1);
         } else --log_cnt;
      } else if(c == LF) {
         if(logc_last() == CR) logc(LF);
         else {
            logc(CR);
            logc(LF);
         }
      } else if(c == CR) {
         if((c1=logc_last())!=CR && c1!=LF) logc(CR);
      } else logc(c);
   }
   if(keep_it_for_IF && VPOut==COMVP) {
        c = ch_toupper(c);
      if(d_buf_idx >= D_BUF_SIZE) {
         d_buf[D_BUF_SIZE] = '\0';
         keep_it_for_IF = 0;
      } else if (c) d_buf[d_buf_idx++] = c;
   }
}        /* end of JournalCh(c) */

/**************************************************************************
**
** Name : JournalStr(ptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

JournalStr(char *ptr)
{
char c, *str=ptr;

   if (out_flag == 1 && VPOut==COMVP) {
      while(c = *str++) JournalCh(c);
   }
   else if (keep_it_for_IF && VPOut==COMVP) {
      while(c = *ptr++) {
         c = ch_toupper(c);
         if(d_buf_idx >= D_BUF_SIZE) {
            d_buf[D_BUF_SIZE] = '\0';
            keep_it_for_IF = 0;
            break;
         }
         else if (c) d_buf[d_buf_idx++] = c;
      }
   }
}        /* end of JournalStr(ptr) *.

/**************************************************************************
**
** Name : JournalHistory()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

JournalHistory()
{
   char buf[CMDBUFSIZE+1];
   if(his_flag != 0) {
      out_flag = his_flag - 1;
      his_flag = 0;
      if(out_flag) {
//       if(VP[COMVP].Ptr->c > COMBUFCOL) {
//          strcpy(buf,CmdKeyinBuf);
//          buf[CmdKeyinBufIdx+1] = '\0';
//       } else {
            v_stcpy( LastCOMVPLine, FROM_WN, ROW, VP[COMVP].Ptr );
            strncpy( buf, LastCOMVPLine, VP[COMVP].Ptr->c );
            buf[ VP[COMVP].Ptr->c ] = '\0';
//       }
         JournalStr(buf);
      }
   }
}        /* end of JournalHistory() */

/**************************************************************************
**
** Name : logc_last()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

logc_last()
{
   int i;
   i = (log_cnt + 511 ) % 512;
   return(O_BUF[i]);
}         /* end of logc_last() */

/**************************************************************************
**
** Name : logc()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

logc(char c)
{
   if(log_cnt == 512) {
      _lwrite(fd_out_log,(LPSTR)O_BUF,512);
      log_cnt=0;
   }
   O_BUF[log_cnt++]=c;
}        /* end of logc() */

/**************************************************************************
**
** Name : logb(c)
**
** Function : log one byte charater into the log-file -- ^B
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

logb(char c)
{
   if(b_cnt == 512) {
      _lwrite(fd_cmd_log,(LPSTR)BAT_BUF,512);
      b_cnt = 0;
   }
   BAT_BUF[b_cnt++]=c;
}    /* end of logb(c) */


/**************************************************************************
**
** Name : TimeDelayinSec( Second )
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

TimeDelayinSec( Second )
double  Second;
{
 time_t  StartTime, EndTime;

 time( &StartTime );
 while ( Second > difftime( time(&EndTime), StartTime ) );
}

/**************************************************************************
**
** Name : SetCodeVPData(flag)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
SetCodeVPData(int flag)
{
extern int NECflag;
#define MAXREC 20
extern long viewAddr;
extern unsigned int viewLine;
static unsigned long recordAddr[MAXREC], previousAddr;
static int recordLine[MAXREC], previousLine=0;
static int recordCount = 0, extraLine = 0, lineCount=0;

char *ptr, *temp, cnt;
unsigned long startAddr, baseAddr, addr;
int recordUsed = 0, len, i, j, retValue, lineUsed=0;
int startLine, oldOrg;
int ret;

   GetCodeVPRange(NONE);

   dspMode = langMode;
/*** determine start address/line to display ***/

//   if ((temp=malloc(100)) == NULL) return(OK);
// Changed by Chen, 02/16/95
//
   if ((temp=malloc(256)) == NULL) return(OK);
   memset(temp, NULL, sizeof(temp));

   if (flag == -1) {   /* reset */
      emuGetReg(I86_REG, REG_PC, &startAddr);
    if (dspMode != ASM && GetModuleAndLineNum(startAddr, &startLine)==FAIL) {
         dspMode = ASM;
    }
      VP[CODVP].Ptr->row_org = 0;
      recordCount = 0;
      backLevel = 0;
   }
   else if (flag == 0) {   /* refresh */
      if ((retValue=GetAddrInCODVP( VP[CODVP].Ptr->row_org, &startAddr)) == 0) {
         free(temp);
         return (OK);    // cannot get addr in top line of VP
      }
      startLine = curLineNum;
      if (dspMode != ASM) {
         if (startLine < 1 )
            if (GetModuleAndLineNum(startAddr, &startLine)==FAIL) dspMode=ASM;
      }
      VP[CODVP].Ptr->row_org = 0;
      recordCount = 0;
   }
   else if (flag == CODVP_VIEW) {
      startAddr = viewAddr;
      if (dspMode != ASM && !viewLine) {
         if (GetModuleAndLineNum(startAddr, &startLine)==FAIL) dspMode=ASM;
      }
      else startLine = viewLine;
      VP[CODVP].Ptr->row_org = 0;
      recordCount = 0;
   }
   else if (flag == CODVP_BOTTOM) {
      if (GetLastPageStart(&startLine) == FAIL) return(OK);
      if (curModule.lastLine < CODBUFROW) {
         if (curModule.lastLine <= VP[CODVP].Height-2)
            VP[CODVP].Ptr->row_org = 0;
         else VP[CODVP].Ptr->row_org = curModule.lastLine-VP[CODVP].Height+2;
      }
      else VP[CODVP].Ptr->row_org = CODBUFROW - VP[CODVP].Height + 2;
      recordCount = 0;
   }
   else if ( flag == CODVP_PREV || flag == CODVP_NEXT || flag == CODVP_PGUP ||
             flag == CODVP_PGDN ) {
      oldOrg = VP[CODVP].Ptr->row_org;
      if ((retValue=GetAddrInCODVP( VP[CODVP].Ptr->row_org, &baseAddr)) == 0) {
         free(temp);
         return (OK);    // cannot get addr in top line of VP
      }
      if (retValue == 6 && GetModuleAndLineNum(baseAddr, &curLineNum)==FAIL)
         dspMode = ASM;
      cnt = VP[CODVP].Height - 4;
      if (flag == CODVP_NEXT || flag == CODVP_PGDN) {
         VP[CODVP].Ptr->row_org = (flag== CODVP_PGDN) ? 0 : 1;
         if (dspMode == ASM && flag == CODVP_PGDN)
//            VP[CODVP].Ptr->row_org = cnt;
            VP[CODVP].Ptr->row_org = 6;
// 05/05/94
      }
      else if (flag == CODVP_PREV) {
         VP[CODVP].Ptr->row_org = CODBUFROW - VP[CODVP].Height + 1;
         if (dspMode == HIGH && curLineNum <= VP[CODVP].Ptr->row_org)
            VP[CODVP].Ptr->row_org = curLineNum > 2 ? curLineNum - 2 : 0;
      }
      else {   // flag == CODVP_PGUP
         VP[CODVP].Ptr->row_org = CODBUFROW - VP[CODVP].Height + 2;
         if (dspMode == HIGH && curLineNum < CODBUFROW - 1) {
            VP[CODVP].Ptr->row_org = curLineNum > cnt + 1 ?
                                     curLineNum - cnt - 1 : 0;
         }
      }
      if (dspMode != ASM) { // define startLine
         if (flag == CODVP_PGDN ) startLine = curLineNum + cnt;
         else if (flag == CODVP_NEXT) startLine = curLineNum;
         else if (flag == CODVP_PGUP) {
            startLine = curLineNum + 2 <= CODBUFROW ? 1 :
                        curLineNum + 2 - CODBUFROW ;
         }
         else {  // flag == CODVP_PREV
            startLine = curLineNum + cnt + 2 <= CODBUFROW ? 1 :
                        curLineNum + cnt + 2 - CODBUFROW ;
         }
      }
      if (dspMode == ASM && (flag == CODVP_PREV || flag == CODVP_PGUP)) {
         VP[CODVP].Ptr->row_org -= extraLine;
         extraLine = 0;
      }
      if ( retValue == 2) {   // symbol line
         if (flag == CODVP_PREV && recordCount == 0) (VP[CODVP].Ptr->row_org)--;
      }
      else
         if ( dspMode == ASM && (flag == CODVP_NEXT || flag == CODVP_PGDN) &&
              dsmAddr2Sym(baseAddr, temp) == TRUE) {
            (VP[CODVP].Ptr->row_org)++;
            extraLine = 1;
         }
      startAddr = baseAddr;
      if (flag == CODVP_PREV || flag == CODVP_PGUP) {
         if (recordCount > 0 && flag == CODVP_PREV) {
            startAddr = recordAddr[--recordCount];
            recordUsed = 1;
            if (dspMode != ASM) {
               startLine = recordLine[--lineCount];
               lineUsed = 1;
            }
            else VP[CODVP].Ptr->row_org -= cnt;
         }
         else GetUpAddr(flag, startAddr, &startAddr);
      }
      else if (flag == CODVP_NEXT  ) {
         /* record start address of current page */
         if (recordCount < MAXREC) {
            recordAddr[recordCount++] = previousAddr;
            if (dspMode != ASM)  recordLine[lineCount++] = previousLine;
         }
         else {
            memcpy(&recordAddr[0], &recordAddr[1],
                   sizeof(recordAddr[0]) * (MAXREC-1));
            recordAddr[MAXREC-1] =  previousAddr;
            memcpy(&recordLine[0], &recordLine[1],
                   sizeof(recordLine[0]) * (MAXREC-1));
            recordLine[MAXREC-1] =  previousLine;
         }
      }
   }  // end of if ( flag == CODVP_PREV || flag == CODVP_NEXT ||
      //             flag == CODVP_PGUP || flag == CODVP_PGDN )
   else {
      free(temp);
      return (OK);
   }
   if (dspMode != ASM && startLine > 0) {
      if ( ( dspMode == MIX &&
             PutMixinCODBuf(startLine, flag, oldOrg, &cnt) == FAIL) ||
           ( dspMode == HIGH && PutSourceinCODBuf( startLine, &cnt ) == FAIL ))
         dspMode=ASM;
      else {
         previousLine = startLine;
         previousAddr = startAddr;
         CodeVPRange.LFcount = cnt;
         free(temp);
         return (OK);
      }
   }

/*** Disassemble ***/
   CODBuf[0] = NULL;
   j = 7 * CODBUFROW;
   addr = startAddr;
   if ( MICE < V20MAX || NECflag == 0 )
        GetMemWrap(addr, codvp_buf, j);
   ptr = codvp_buf;
   for (i = 0; i < CODBUFROW; i++) {
      if (dsmAddr2Sym(addr, temp) == TRUE && temp[1]) {
         sprintf(dsm_buf,"%17s%s:\r\n", "", temp);
         strcat(CODBuf, dsm_buf);            /* add location symbol */
         if (flag == CODVP_PREV && !recordUsed && (int)(addr-baseAddr) <= 0)
            (VP[CODVP].Ptr->row_org)++;   // because symbol occupies one line
      }
        if ( (MICE < V20MAX) || NECflag == 0 )
            PutOneAsmRowinBuf( &addr, &ptr, &j, temp );
        else {
            if ( (addr>>12)&0x0ffff0 + (addr&0x0ffff) > 0xfffff )
                addr = 0xffff;
            ret = PutOneAsmV20( &addr, temp );
        }
        strcat(CODBuf, temp);
   }
   previousAddr = startAddr;
   CodeVPRange.LFcount = CODBUFROW;
   free(temp);
   return (OK);
}        /* end of SetCodeVPData() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:  return : 0 - error;
**                  1 - valid address or exact line number found
**                  2 - symbol (asm)
**                  3 - linnum is between 2 addr's or no addr found before this
**                      line(source)
**                  4 - no address found ( addr is curPC ) (source)
**                  5 - source line in mix mode ( with valid address )
**                  6 - source or mix mode with no source( with valid address)
**************************************************************************/
int GetAddrInCODVP(int row, unsigned long *addr)
{
char buffer[CODBUFCOL+1], symbol[80], *ptr, flag=FALSE;
int oldRow, retValue;
unsigned long offset;

   curLineNum = 0;
/*** Get one line from viewport ***/
   oldRow = VP[CODVP].Ptr->r;
   VP[CODVP].Ptr->r = row;
   v_stcpy(buffer, FROM_WN, ROW, VP[CODVP].Ptr);
   VP[CODVP].Ptr->r = oldRow;

/*** Check whether it is a normal logical address or a symbol line ***/
   ptr = &buffer[CODVPINDENT];
   if (dspMode == MIX && buffer[CODVPINDENT-1] == '<' ) {
      if (!sscanf(ptr,"%d ",&curLineNum)) return(0);
      if (LinNum2Addr( curLineNum, addr ) != OK) {
         oldRow = VP[CODVP].Ptr->r;
         while (row < VP[CODVP].Maxr) {
            VP[CODVP].Ptr->r = ++row;
            v_stcpy(buffer, FROM_WN, ROW, VP[CODVP].Ptr);
            ptr = &buffer[CODVPINDENT];
            if (isxdigit(*ptr) && sscanf(ptr,"%lx:%lx", addr, &offset) == 2) {
               *addr = (*addr << 16) + offset;
               flag = TRUE;
               break;
            }
         }
      }
      if (flag == FALSE) emuGetReg(I86_REG, REG_PC, addr);
      VP[CODVP].Ptr->r = oldRow;
      return( flag == TRUE ? 5 : 4 );
   }
   if (isxdigit(*ptr) && sscanf(ptr,"%lx:%lx", addr, &offset) == 2) {
      *addr = (*addr << 16) + offset;
      return (langMode == ASM ? 1 : 6);
   }
   if (dspMode == HIGH && sscanf(ptr,"%d ",&curLineNum) > 0) {
      if ((retValue = LinNum2Addr( curLineNum, addr )) == FAIL ) {
         emuGetReg(I86_REG, REG_PC, addr);
         return(4);
      }
      if (retValue == OK) return(1);
      return(3);
   }
   sscanf(ptr,"%s", symbol);
   if (symbol[0] != '%')  return (0);
   if (symbol[strlen(symbol) - 1] == ':')
      symbol[strlen(symbol) - 1] = '\0';   /* remove tailing ':' */
   if (asmSym2Addr(&symbol[1], addr) == FALSE)  return (0);
   return (2);
}  /* end of GetAddrInCODVP() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
static GetUpAddr(int flag, unsigned long nowAddr, unsigned long *upAddr)
{
unsigned char buffer[7 * (CODBUFROW+1)], *ptr;
unsigned long addr, saveAddr[CODBUFROW];
int bufferSize = 7 * CODBUFROW, tryCount, index, instLen;
unsigned long frame, offset;  // added by James

   /* point backward */
   if ( MICE < V20MAX || NECflag == 0 )  { // updated by James
        addr = (nowAddr & 0xFFFF0000) + ((nowAddr - bufferSize) & 0x0000FFFF);
        GetMemWrap(addr, buffer, bufferSize + 7);
   }
   else {
      frame  = nowAddr & 0xFFFF0000;
      offset = nowAddr & 0x0000FFFF;
      addr = frame + ((((signed long)offset - bufferSize) > 0 ? offset-bufferSize : 0) & 0x0000FFFF);
      *upAddr = addr;
      return;
   }
   ptr = buffer;

   for (tryCount = index = 0; addr != nowAddr; ) {
      saveAddr[(index++) % CODBUFROW] = addr;
      if ( MICE < V20MAX || NECflag == 0 )  // updated by James
         instLen = Disassemble(addr, ptr, bufferSize,  (char *)NULL);
//    else
//       instLen = DisassembleV20(nowAddr, (char *)NULL);
      ptr += instLen;
      addr = (addr & 0xFFFF0000) + ((addr + instLen) & 0x0000FFFF);
      if ((int)(addr - nowAddr) > 0) {   // pass over nowAddr
         if (++tryCount > 7)  break;
         /* extract saved address which is furthest */
         addr = saveAddr[ (index + VP[CODVP].Height - 2) % CODBUFROW ] - 1;
         ptr = buffer + bufferSize - ((nowAddr - addr) & 0x0000FFFF);
         index = 0;
      }
   }
   if (flag == CODVP_PREV)
      *upAddr = saveAddr[ (index + VP[CODVP].Height - 2) % CODBUFROW ];
   else *upAddr = saveAddr[ (index + 2) % CODBUFROW ];

}  /* end of GetUpAddr */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

/*** code:
   'Z'   SetCodeVPData()
   'L'   SetTraceVPData()
   'R'   GetPC()
***/
/*
ValidateResult(s,code)
char *s, code;
{
   int r;
   char *ptr;
   char *strstr();
   if(ptr = index(s,'!')) {
      if(!strnicmp(ptr-5,"ERROR",5)) {
         if(code == 'R') r = NO_PC;
         else r = FALSE;
      } else if(!strnicmp(ptr-4,"STEP",4)) r = FALSE;
      else r = TRUE;
   } else if(*s == NULL) r = EMPTY;
   else if( (strstr(s,"step")!=NULL) || (strstr(s,"halt")!=NULL) ) {
      r = FALSE;
   } else r = TRUE;
   return(r);
}
*/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

GetCodeVPRange(int flag)
{
/* flag=ALL:     whole buffer refresh */
/* flag=PARTIAL: scroll CODVP screen only */
/* flag=NONE:   reset CodeVPRange */
int i,  ret, ll;
unsigned long  addr;

   CodeVPRange.flag = FAIL; // range unavailable
   if (flag == NONE) return;
   ll = env.Miplen;
   if (flag == ALL) {
      //************* Get Buffer Start ************************
      CodeVPRange.bufStartAddr = 0xFFFFFFFF;
      CodeVPRange.bufStartLine = 0xFFFF;
      i = 0;
      while (i < CodeVPRange.LFcount &&
          (ret=GetAddrInCODVP(i++, &addr)) == 2) ; // symbol
      if (!ret || ret==2) return;
      if (ret==1 || ret == 6) CodeVPRange.bufStartAddr = addr;
      if (ret != 6) CodeVPRange.bufStartLine = curLineNum;

      //************* Get Buffer End ************************
      CodeVPRange.bufEndAddr = 0L;
      CodeVPRange.bufEndLine = 0;
      i=CodeVPRange.LFcount-1;
      while (i >= 0 && (ret=GetAddrInCODVP(i--, &addr)) == 2);
      if (!ret || ret==2) return;
      if (ret==1 || ret == 6) CodeVPRange.bufEndAddr = addr;
      if (ret != 6) CodeVPRange.bufEndLine = curLineNum;
   }

   //************* Get Screen Start ************************
   CodeVPRange.scrStartAddr = 0xFFFFFFFF;
   CodeVPRange.scrStartLine=0xFFFF;
   i = VP[CODVP].Ptr->row_org;
   while (i < CodeVPRange.LFcount &&
          (ret=GetAddrInCODVP(i++, &addr)) == 2) ; // symbol
   if (!ret || ret ==2) return;
   if (ret==1 || ret == 6 ) CodeVPRange.scrStartAddr = addr;
   if (ret != 6) CodeVPRange.scrStartLine = curLineNum;

   //************* Get Screen End ************************
   CodeVPRange.scrEndAddr = 0L;
   CodeVPRange.scrEndLine = 0;
   i = MIN( (VP[CODVP].Ptr->row_org+wn_rowq(VP[CODVP].Ptr)-1), CodeVPRange.LFcount-1 );
   while ( i>=0 && (ret=GetAddrInCODVP(i--, &addr)) == 2 );
   if (!ret || ret == 2) return;
   if (ret==1 || ret == 6) CodeVPRange.scrEndAddr = addr;
   if (ret != 6) CodeVPRange.scrEndLine = curLineNum;

   CodeVPRange.flag = OK;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MarkBKPTinCodeVP(U32 breakAddr, char ch)
{
   int i;

   if (CodeVPRange.flag==OK && LocatePCLine(breakAddr, &i) == OK)
      MarkBKPT(i,ch);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  mark the source line that software breakpoint is set          */

MarkBKPT(int Bufy, char BKPTSign )
{
 int oldrow, oldcol;

   oldrow = VP[CODVP].Ptr->r;
   oldcol = VP[CODVP].Ptr->c;

   VP[CODVP].Ptr->r = Bufy;
   VP[CODVP].Ptr->c = CODVPINDENT-1;
   v_ch( BKPTSign, VP[CODVP].Ptr );

   VP[CODVP].Ptr->r = oldrow;
   VP[CODVP].Ptr->c = oldcol;
}  /*  of MarkBKPT()  */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

SetBKPTinCodeVP()
{
   int i, ii, j;
   char *ptr, *ptr1;
   char LastCODVPLine[ CODBUFCOL+1 ];
   int oldrow, oldcol;

   oldrow = VP[CODVP].Ptr->r;
   oldcol = VP[CODVP].Ptr->c;

   for ( i=0, j=0;   i<CodeVPRange.LFcount; i++, j=0, ptr1 = ( ptr += (VP[CODVP].Maxc+2) ) )   {

       VP[CODVP].Ptr->r = i;
       v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
       ptr1 = ptr = LastCODVPLine + LABELINDENT + env.mmu[1];

       if (dspMode==ASM) while(ishex(*ptr1++)) j++;
       else j=3;
       if ( j>=3 && CheckIsBKPT(ptr)>=0 ) {
          VP[CODVP].Ptr->c = CODVPINDENT-1;
          v_ch( BKPT_SIGN, VP[CODVP].Ptr );
       }
   }
   VP[CODVP].Ptr->r = oldrow;
   VP[CODVP].Ptr->c = oldcol;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

adr_ascii(adr,len,buf)
unsigned char *adr;
int len;
char *buf;
{
   int i, ii;
   for(i=0,ii=0 ; i<len ; i++) {
      buf[ii++] = hex[(adr[i]>>4)&0xf];
      buf[ii++] = hex[adr[i]&0xf];
      if (i == 1) buf[ii++] = ':';
   }
   buf[ii] = '\0';
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MarkNewPCinCodeVP()
{
   U32 ppp;
   int r, i;
   int botMargin;

   backLevel=0;
   if( wn_isup(VP[CODVP].Ptr) && (RedrawFlag&REDRAWCOD) && (!(MaskRedrawFlag&REDRAWCOD)) && CodeVPRange.flag==OK) {
      emuGetReg(I86_REG, REG_PC, &ppp);
      botMargin = VP[CODVP].Ptr->row_org + VP[CODVP].Height - 3;
      if (InCodeVPScreen() && LocatePCLine(ppp, &i) == OK &&
          i >= VP[CODVP].Ptr->row_org && i <= botMargin ) {
         VP[CODVP].Ptr->c = 0;  /*  for scrolling  */
         v_ch( ' ', VP[CODVP].Ptr );
         MarkPC(i);
         VP[CODVP].Ptr->r = i;  /*  for scrolling  */
         VP[CODVP].Ptr->c = 0;  /*  for scrolling  */
         v_ch( '\x10', VP[CODVP].Ptr );
         RedrawFlag &= ~REDRAWCOD;
      }
      else if (InCodeVPBuf() && LocatePCLine(ppp, &i) == OK &&
                OnePageMore(i)== TRUE){
         NewPCPage(i);
         RedrawFlag &= ~REDRAWCOD;
         GetCodeVPRange(PARTIAL);
      }
   }
  else RedrawFlag &= ~REDRAWCOD;
// Changed by Chen, 07/04/94
//   else RedrawFlag |= REDRAWCOD;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

InCodeVPScreen()
{
unsigned long addr, abs;
int line;
char ret1=0, ret2=0;

   emuGetReg(I86_REG, REG_PC, &addr);
   abs = ADDR2ABS(addr);

   if ( dspMode != ASM && Addr2LinNum(addr, &line) != FAIL) {
      ret2 = line >= CodeVPRange.scrStartLine ? TRUE : FALSE;
      if (dspMode==HIGH) {
         ret1 = line <= CodeVPRange.scrEndLine ? TRUE : FALSE;
         return(ret1&ret2);
      }
      else ret1 = line < CodeVPRange.scrEndLine ? TRUE : FALSE;
   }
   if (!ret1) ret1 = abs <= ADDR2ABS(CodeVPRange.scrEndAddr)  ? TRUE : FALSE;
   if (!ret2) ret2 = abs >= ADDR2ABS(CodeVPRange.scrStartAddr) ? TRUE :FALSE;
   return( ret1&ret2 );
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

InCodeVPBuf()
{
unsigned long addr, abs;
int line;
char ret1=0, ret2=0;

   emuGetReg(I86_REG, REG_PC, &addr);
   abs = ADDR2ABS(addr);

   if ( dspMode != ASM && Addr2LinNum(addr, &line) != FAIL) {
      ret2 = line >= CodeVPRange.bufStartLine ? TRUE : FALSE;
      if (dspMode==HIGH) {
         ret1 = line <= CodeVPRange.bufEndLine ? TRUE : FALSE;
         return(ret1&ret2);
      }
      else ret1 = line < CodeVPRange.bufEndLine ? TRUE : FALSE;
   }
   if (!ret1) ret1 = abs <= ADDR2ABS(CodeVPRange.bufEndAddr)  ? TRUE : FALSE;
   if (!ret2) ret2 = abs >= ADDR2ABS(CodeVPRange.bufStartAddr) ? TRUE :FALSE;
   return( ret1&ret2 );
}
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

LocatePCLine( U32 ppp, int *idx)
{
   U32 addr;
   int j, ret;

   for ( j=0 ; j<CodeVPRange.LFcount ; j++ ) {
      if (((ret = GetAddrInCODVP(j, &addr)) == 1 || ret == 6) &&
            ADDR2ABS(ppp) == ADDR2ABS(addr)) {
         *idx = j;
         return(OK);
      }
   }
   return(FAIL);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

OnePageMore(i)
int i;
{
   return(((i + VP[CODVP].Height - 2) <= CodeVPRange.LFcount) ? TRUE : FALSE);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

CheckIsBKPT(ptr)
char *ptr;
{
unsigned int lineNum;
unsigned long addr, cs386p;

   if (dspMode == HIGH && sscanf(ptr,"%d ",&lineNum) > 0) {
      if (LinNum2Addr( lineNum, &addr ) != OK) return(-1);
      cs386p = (addr >> 16) * 0x0FFFF;
   }
   else if(!index(ptr,':')) {
      sscanf(ptr,"%lx",&addr);
   } else {
      sscanf(ptr,"%lx:%lx",&cs386p,&addr);
      addr = (cs386p << 16) | (addr & 0xffff);
   }
   return(IsBKPT(addr,cs386p));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :  flag=0:           refresh TraceVP content
**              flag=TRAVP_NEXT:  show next page of TraceVP
**              flag=TRAVP_PREV:  show previous page of TraceVP
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  replaced with "emuGetMICEBuf()" defined in SDABI.C
SetTraceVPData( int flag )
{
extern int curBuf;
long startframe, endframe, orgframe;

   MICEBuf[0] = '\0';
   if (emuGetTraceDepth(curBuf-1, &traceDepth[curBuf-1]) == BUFFER_EMPTY)  return (OK);
   startframe = traceDepth[curBuf-1].startFrame;
   endframe   = traceDepth[curBuf-1].endFrame;
   if (flag == -1) {   // reset trace viewport
      TraceVPRange.start = startframe;
      VP[TRAVP].Ptr->row_org = 0;
   }
   else if (flag == TRAVP_NEXT) {
      if (TraceVPRange.end >= endframe)  return (OK);
      TraceVPRange.start += TRABUFROW - (VP[TRAVP].Height - 2) + 1;
      VP[TRAVP].Ptr->row_org = 0;
   }
   else if (flag == TRAVP_PREV) {
      if (TraceVPRange.start <= startframe)  return (OK);
      orgframe = TraceVPRange.start - TRABUFROW + VP[TRAVP].Height - 3;
      if (orgframe < startframe)  orgframe = startframe;
      VP[TRAVP].Ptr->row_org = TraceVPRange.start - orgframe - 1;
      TraceVPRange.start = orgframe;
   }
   if ((TraceVPRange.end = TraceVPRange.start + TRABUFROW - 1) > endframe)
      TraceVPRange.end = endframe;
   TraceVPRange.LFcount = TraceVPRange.end - TraceVPRange.start + 1;
   SetPutsBuf(MICEBuf, TRABUFROW, 0);
//   deqListFrame(curBuf, TraceVPRange.start, 0L, 0xFFFFFFFFL, 0xFF);
   return (OK);
}   // end of SetTraceVPData()
*/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  save screen layout which including menu-bar and viewports           */

SaveScrnLayout()
{
 int  i;

/* CORE 90.08.16 */

#ifdef NEC_PC9801 /*NEC_PC9801*/
 wi_sav( MenuBar->wnp );
#else /*NEC_PC9801*/
 mn_dn( MenuBar );
#endif /*NEC_PC9801*/

 for ( i = BREVP; i <= DATVP; i++ ) {
     if ( wn_isup( VP[i].Ptr ) ) {
   VPIsSet[i] = TRUE;
   wn_dn( VP[i].Ptr );
     } else  VPIsSet[i] = FALSE;
 }

 wn_dn( FuncKeyVP );
 vs_clr();

}  /*  of SaveScrnLayout()  */


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  restore screen layout which including menu-bar and viewports        */

RestoreScrnLayout()
{
 if ( ColorMode == FALSE ) {
    USD3vid_setmode( MONO );
 } else {
    USD3vid_setmode( CO80 );
    if (Text50Lines)  vid_vga50(ON);
    vid_hibg( ON );
 }
 vs_clr();

/* CORE 90.08.16 */

#ifdef NEC_PC9801 /*NEC_PC9801*/
 wi_unsav( MenuBar->wnp );
#else /*NEC_PC9801*/
 mn_up( MenuBar );
#endif /*NEC_PC9801*/


 if (!COMVPMax && !VPIsSet[REGVP] && !VPIsSet[BREVP] && !VPIsSet[TRAVP] ) {
    VP[DATVP].Height = VP[STAVP].Height = VP[CODVP].Height = vs_rowq() - 1 -
                                                             VP[COMVP].Height;
    VP[DATVP].yOrg = VP[STAVP].yOrg = VP[CODVP].yOrg = VP[REGVP].yOrg;
    wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg,
          VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
    wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg,
          VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
    wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg,
         VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
 }


// redraw the VP border
    if ( !COMVPMax ) {      // COMVP is not maximum
        if ( !VPIsSet[REGVP] && !VPIsSet[TRAVP] && !VPIsSet[BREVP] ) {
            if ( !VPIsSet[DATVP] && !VPIsSet[STAVP] ) {
                sw_bdr( &TopVPBdr, VP[CODVP].Ptr );
            }
            else if ( VPIsSet[DATVP] && !VPIsSet[STAVP] ) {
                sw_bdr( &TopLeftVPBdr, VP[CODVP].Ptr );
                sw_bdr( &TopRightVPBdr, VP[DATVP].Ptr );
            }
            else if ( !VPIsSet[DATVP] && VPIsSet[STAVP] ) {
                sw_bdr( &TopLeftVPBdr, VP[CODVP].Ptr );
                sw_bdr( &TopRightVPBdr, VP[STAVP].Ptr );
            }
        }
        else if ( TopVP==BREVP || TopVP==REGVP || TopVP==TRAVP ) {
            if ( !VPIsSet[DATVP] && !VPIsSet[STAVP] ) {
                sw_bdr( &TopVPBdr, VP[TopVP].Ptr );
                sw_bdr( &MiddleVPBdr, VP[CODVP].Ptr );
            }
            else if ( VPIsSet[DATVP] && !VPIsSet[STAVP] ) {
                sw_bdr( &TopVPBdr, VP[TopVP].Ptr );
                sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
                sw_bdr( &RightVPBdr, VP[DATVP].Ptr );
            }
            else if ( !VPIsSet[DATVP] && VPIsSet[STAVP] ) {
                sw_bdr( &TopVPBdr, VP[TopVP].Ptr );
                sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
                sw_bdr( &RightVPBdr, VP[STAVP].Ptr );
            }
        }
        sw_bdr( &BottomVPBdr, VP[COMVP].Ptr );
    }
    else {      // COMVP is maximum
        sw_bdr( &SingleVPBdr, VP[COMVP].Ptr );
    }


 if ( VPIsSet[REGVP] )  wn_up( VP[REGVP].Ptr );
 if ( VPIsSet[BREVP] )  wn_up( VP[BREVP].Ptr );
 if ( VPIsSet[TRAVP] )  wn_up( VP[TRAVP].Ptr );
 if ( VPIsSet[CODVP] )  wn_up( VP[CODVP].Ptr );
 if ( VPIsSet[COMVP] )  wn_up( VP[COMVP].Ptr );
 if ( VPIsSet[STAVP] )  wn_up( VP[STAVP].Ptr );
 else  if ( VPIsSet[DATVP] )  wn_up( VP[DATVP].Ptr );
 wn_up( FuncKeyVP );


/*
// redraw the VP border
    if ( !COMVPMax ) {      // COMVP is not maximum
        if ( !VPIsSet[REGVP] && !VPIsSet[TRAVP] && !VPIsSet[BREVP] ) {
            if ( !VPIsSet[DATVP] && !VPIsSet[STAVP] ) {
                v_bdr_csr_plwn( &TopVPBdr, VP[CODVP].Ptr );
            }
            else if ( VPIsSet[DATVP] && !VPIsSet[STAVP] ) {
                v_bdr_csr_plwn( &TopLeftVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &TopRightVPBdr, VP[DATVP].Ptr );
            }
            else if ( !VPIsSet[DATVP] && VPIsSet[STAVP] ) {
                v_bdr_csr_plwn( &TopLeftVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &TopRightVPBdr, VP[STAVP].Ptr );
            }
        }
        else if ( TopVP==BREVP || TopVP==REGVP || TopVP==TRAVP ) {
            if ( !VPIsSet[DATVP] && !VPIsSet[STAVP] ) {
                v_bdr_csr_plwn( &TopVPBdr, VP[TopVP].Ptr );
                v_bdr_csr_plwn( &MiddleVPBdr, VP[CODVP].Ptr );
            }
            else if ( VPIsSet[DATVP] && !VPIsSet[STAVP] ) {
                v_bdr_csr_plwn( &TopVPBdr, VP[TopVP].Ptr );
                v_bdr_csr_plwn( &LeftVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &RightVPBdr, VP[DATVP].Ptr );
            }
            else if ( !VPIsSet[DATVP] && VPIsSet[STAVP] ) {
                v_bdr_csr_plwn( &TopVPBdr, VP[TopVP].Ptr );
                v_bdr_csr_plwn( &LeftVPBdr, VP[CODVP].Ptr );
                v_bdr_csr_plwn( &RightVPBdr, VP[STAVP].Ptr );
            }
        }
        v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
    }
    else {      // COMVP is maximum
        v_bdr_csr_plwn( &SingleVPBdr, VP[COMVP].Ptr );
    }
*/


// show CPU type
    ShowCPUType();

}  /*  of RestoreScrnLayout()  */


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  decide whether the user want to abort USD-III               */
AbortUSD3()
{
   DFORMPTR   DFormPtr;
   DFIELDPTR  DFieldPtr;
   char       Abort[2];
   int save_pulldown_or_dialog, i;

   AskAbortUSD3 = 1;
   Abort[0] = 'Y';
   Abort[1] = '\0';
   DFormPtr  = fm_def( 10, 28, 5, 24, LWHI_RED, BDR_DLNP );
   DFieldPtr = fld_def( 1, 3, "Abort MICEview ? ", FADJACENT, "!", F_STRING, Abort, DFormPtr );
   if (DFieldPtr == NULLP) return (FALSE);
   sf_attact( LRED_WHI, DFieldPtr );
   sf_attinact( LWHI_RED, DFieldPtr );
   sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr ); /* USD-III V2.0x */

   save_pulldown_or_dialog = pulldown_or_dialog;
   pulldown_or_dialog = DIALOG;
   special_dialog = 1;
   i = fm_proc( 0, DFormPtr );
   fm_free( DFormPtr );
   pulldown_or_dialog = save_pulldown_or_dialog;
   special_dialog = 0;

   if (!i) return (FALSE); /* Error */
   if ( i == AC_EXIT && Abort[0] == 'Y' ) {
      if ( ScrnDisplay && !COMVPMax && VerUSAV() == TRUE ) UsaveCmd();
      return( TRUE );
   }
   else {
      if ( VPLink != NULL ) csr_plwn( VPLink );
      else  if ( VP[COMVP].Ptr != NULL )  csr_plwn( VP[COMVP].Ptr );
      return( FALSE );
   }
}  /*  of AbortUSD3()  */


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PopMessage(char *str)
{
   DFORMPTR   DFormPtr;
   DFIELDPTR  DFieldPtr;
   char tmp[2];

//   tmp[0]=NULL;
    tmp[0] = '!';
    tmp[1] = NULL;  // Chen 06/27/94
   DFormPtr  = fm_def( 10, 22, 5, 36, LWHI_RED, BDR_DLNP );
   DFieldPtr = fld_def( 1, 3, str, FADJACENT, "!", F_STRING, tmp, DFormPtr );
   if (DFieldPtr == NULLP) return (FALSE);
   sf_attact( LRED_WHI, DFieldPtr );
   sf_attinact( LWHI_RED, DFieldPtr );
   sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );

   pulldown_or_dialog = DIALOG;
   special_dialog = 1;
   fm_proc( 0, DFormPtr );
   fm_free( DFormPtr );
   special_dialog = 0;
}


/****************************************************************************
**
** Name     :   SoftkeyConfirm()
**
** Function :   confirm whether to save the softkey definitions
**
**   Input  :   none
**
**   Output :   none
**
** Notes    :   added by Chen, 07/15/94
**
****************************************************************************/
void SoftkeyConfirm( void )
{
    extern int nSaveSoftkey;    // declared in MENU3.C

    DFORMPTR DFormPtr;
    DFIELDPTR DFieldPtr;
    char chTmpBuf[2];

// initial displayed field
    strcpy(chTmpBuf, "Y");

// define form and field
    DFormPtr = fm_def( 10, 23, 5, 34, LWHI_RED, BDR_DLNP );
    DFieldPtr = fld_def( 1, 3, "Save softkey definition? ", FADJACENT, "!", F_STRING, chTmpBuf, DFormPtr );
    sf_attact(LRED_WHI, DFieldPtr);
    sf_attinact(LWHI_RED, DFieldPtr);
    sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );

// execute the form
    pulldown_or_dialog = DIALOG;
    special_dialog = 1;
    fm_proc(0, DFormPtr);
    fm_free( DFormPtr );

// confirm the flag
    if ( chTmpBuf[0] == 'Y' || chTmpBuf[0] == 'y' ) {
        nSaveSoftkey = TRUE;
    }
    else {
        nSaveSoftkey = FALSE;
    }

}   // end of SoftkeyConfirm()

 
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
VerUSAV()
{
 DFORMPTR   DFormPtr;
 DFIELDPTR  DFieldPtr;
 char       DoUSAV[2];

/* USD-III V2.0x */
 DoUSAV[0] = 'Y';
 DoUSAV[1] = '\0';

 DFormPtr  = fm_def( 14, 23, 5, 34, LWHI_RED, BDR_DLNP );
 DFieldPtr = fld_def( 1, 3, "Save screen and softkey? ", FADJACENT, "!", F_STRING, DoUSAV, DFormPtr );
 sf_attact( LRED_WHI, DFieldPtr );
 sf_attinact( LWHI_RED, DFieldPtr );

/* USD-III V2.0x */ sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );

 pulldown_or_dialog = DIALOG;
 special_dialog = 1;

// When will reach this case?   ; Chen
 if ( fm_proc( 0, DFormPtr ) == AC_QUIT ) {
    fm_free( DFormPtr );
//    csr_plwn( VP[COMVP].Ptr );
    return( FALSE );
 }

 fm_free( DFormPtr );

// added 'y' by Chen, 07/15/94
 if ( DoUSAV[0] == 'Y' || DoUSAV[0] == 'y' )  return( TRUE );
 else {
//   csr_plwn( VP[COMVP].Ptr );
   return( FALSE );
 }

}  /*  of VerUSAV()  */


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

GetTime(lp)
long *lp;
{
/*********
   long l1, l2;
   struct regs *INREG_ptr=&INREG, *OUTREG_ptr=&OUTREG;
   INREG_ptr->AX = 0x2c00;
   sysint(0x21,INREG_ptr,OUTREG_ptr);
   l1 = (OUTREG_ptr->CX >> 8) & 0xff;
   l1 *= 3600;
   l2 = OUTREG_ptr->CX & 0xff;
   *lp = l1 + l2 * 60 + ((OUTREG_ptr->DX >> 8) & 0xff);
*******/
   struct timeb ttt;
   ftime(&ttt);
   *lp = ttt.time;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

pause_delay(i)
int i;
{
   long ll, lll;
   GetTime(&ll);
   lll = ll + i;
   do {
      if(chk_hlt() == ESC || down_ESC_send) {
         down_ESC_send = 0;
         break;
      }
      GetTime(&ll);
   } while(ll < lll) ;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

tick_delay(delay_count)
int delay_count;
{
   int r = 1 - END;
   char c;
   long ll;
   int VPtmp;
   char bbb[80];

   USDSetTimer(delay_count);

   do {
//    if (chk_hlt() == ESC) return(0);
      GetTime(&ll);
   } while(r!=END && ll<tick_deadline) ;
// return(1);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
any_G_mesg()
{
   char c, r=0, end_c;
   if((c=upRX_DATA()) >= 0) {
get_next_mesg:
      while(c != HAND_SHAKE) {
         d_putc(c);
         if(c == LF || c == CR) break;
         if(c =='=' || c =='y') r = END;
         c = receive();
      }
      if(c != HAND_SHAKE) {
         end_c = (env.Mmodel<=MICE_3_BOUND || env.Mmodel==NEW_Z80)
            ? HAND_SHAKE : (0x17-c);
         while((c=receive()) != end_c) {
            d_putc(c);
            if(c=='=' || c=='y') r = END;
         }
         if(c != HAND_SHAKE) d_putc(c);
         if(env.Mmodel < MICE_3_BOUND) r = END;
      }
      if(env.Mmodel>=MICE_3_BOUND && (c=upRX_DATA())>=0) goto get_next_mesg;
   }
   return(r);
}
*/
/**************************************************************************
**
** Name : USDSetTimer()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

USDSetTimer(int i)
{
   long ll;
   GetTime(&ll);
   tick_deadline = ll + i;
}


/**************************************************************************
**
** Name : DosCmd()
**
** Function : DOS shell command
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
DosCmd()
{
int i;

   SaveScrnLayout();
   signal( SIGINT, SIG_IGN );

   if ( cmd_syntax.argc == 0 ) {
      printf( "\n\r*****  To return to MICEview, type \"exit\".  *****\n\r" );
      i = spawnlp( P_WAIT, "COMMAND.COM", "COMMAND.COM", NULL );
   } else {
      i = system( cmd_syntax.asc );
      if ( !cmdfile_flag && i != -1 ) {
         printf( "\n\r*****  Press any key to return to MICEview.  *****" );
         ki();
      }
   }

   RestoreScrnLayout();

   if ( i == -1 ) {
      switch( errno ) {
        case ENOENT  : DisplayStr( " Error! Cannot find \"COMMAND.COM\".\r\n" );
           break;
        case ENOEXEC : DisplayStr( " Error! Invalid \"COMMAND.COM\".\r\n" );
           break;
        case ENOMEM  : DisplayStr( " Not enough memory to load \"COMMAND.COM\"!\r\n" );
           break;
        default      : DisplayStr( " Not enough memory to load \"COMMAND.COM\"!\r\n" );
      }
   }

   signal( SIGINT, USD3CtrlCHandler );
   InitMouse();

   return( TRUE );

}  /*  of DosCmd()  */


/**************************************************************************
**
** Name : DosACmd()
**
** Function : DOS shell command, return back to SD186 directly
**
**    Input :
**
**   Output :
**
** Notes:
**
**************************************************************************/
DosACmd()
{
int i;

   SaveScrnLayout();

   signal( SIGINT, SIG_IGN );
   i = system( cmd_syntax.asc );

   RestoreScrnLayout();

   if ( i == -1 ) {
      switch( errno ) {
        case ENOENT  : DisplayStr( " Error! Cannot find \"COMMAND.COM\".\r\n" );
           break;
        case ENOEXEC : DisplayStr( " Error! Invalid \"COMMAND.COM\".\r\n" );
           break;
        case ENOMEM  : DisplayStr( " Not enough memory to load \"COMMAND.COM\"!\r\n" );
           break;
        default      : DisplayStr( " Not enough memory to load \"COMMAND.COM\"!\r\n" );
      }
   }

   signal( SIGINT, USD3CtrlCHandler );
   InitMouse();

   return( TRUE );

}   // end of DosACmd()


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

USD3CtrlCHandler()
{
   signal( SIGINT, SIG_IGN );

   HideCursor(); /* USD-III V2.0x */
   if ( AbortUSD3() ) {
      DestroyVP();
      DestroyMenu();
      WmClose();
      FreeGbl();
      vs_clr();
      USD3vid_setmode( OldVideoMode );
      exit_vv();
      signal( SIGINT, OldCtrlCHandler );
      exit(-1);
   }
   else  ShowCursor(); /* USD-III V2.0x */

   signal( SIGINT, USD3CtrlCHandler );
}

/***************************************************************************
**
**  Name: asmSym2Addr(Symbol,  Addr)
**
**  Description:
**     convert symbol to address
**
**  Input:  symbol
**
**  Output: address which consists of segment and offset
**
**  Return: TRUE if successful conversion, FALSE otherwise
**
****************************************************************************/
int asmSym2Addr(STR Symbol,  U32 *Addr)
{
int i;

// if (!sym_flag)  return (FALSE);
   if (*Symbol == '%')  Symbol++;   /* skip '%' */
   if (Symbol[0] == '\0')  return (FALSE);
   strcpy(comsym.name, Symbol);
   comsym.mask = 0;
   if (SymToAddr() == FALSE)  return (FALSE);
   for (*Addr = 0, i = 0; i < 4; i++)
      *Addr = (*Addr << 8) + comsym.addr[i];
   return (TRUE);
}  /* end of asmSym2Addr() */

/**************************** End of File **********************************/

