/***************************** Macro Definition ****************************/
#ifndef _LINUMDEF_
#define _LINUMDEF_
#endif
#define EXTERN  extern
#define VOID    void
#define GLOBAL
#define LOCAL   static
#define PUBLIC
#define STATIC static
//#define PRIVATE LOCAL
//#define OK      0
//#define FAIL    ~OK
#define BETWEEN  2
#define LASTLINE 3
#define NOCODE   4
#define FALSE   0
#define TRUE    1
#define TYPDEF  0x8E

#define BUFROW  50
#define NAMELEN 39
#define ROWLEN  70
#define FINDSIZE 8192
#define BUFSIZE 4096
#define POSCNT  256
#define ASM         0
#define HIGH        1
#define MIX         2
#define FORWARD     1
#define BACKWARD    2
#define TABS      "   "
#define TYPERECNO   50
#define ADDR2ABS(addr)  (U32)((addr>>12)&0x0FFFF0) + (U16)addr

/***************************** Type Declaration ****************************/
typedef unsigned char U8;
typedef unsigned int  U16;
typedef unsigned long U32;
typedef signed   char S8;
typedef signed   int  S16;
typedef S8            FLAG;
typedef signed   long S32;
typedef S8            *STR;
typedef U8            *STRING;
typedef int           RETCODE;

typedef struct {
    U16  lineNum, offset;
} LINNUMINFO;

typedef struct {
    S16  modNum;
    U16  startLine, size;
    S32  filePos[BUFROW];
    U8   line[BUFROW][ROWLEN+1];
} FILEBUF;

typedef struct {
    S16  modNum;
    U16  lastLine;
    S8   modName[NAMELEN+1];
} CURRENT_MODULE;

typedef struct {
    S8   name[NAMELEN+1];
    U32  startAddr;
    U32  endAddr;
    U16  retByte;
    S16  retOffset;
    U32  blkSymPos;
    S16  blkSymCnt;
} BLOCK_INFO;

typedef struct {
    U16  subType;
    S8   dim;
    U16  size[16]; // dimension size
} ARRAY_INFO;

typedef struct {
    U8   name[NAMELEN+1];
    S16  itemCnt;
    U16  itemType[20];
    U8   *itemName[20];
} STRUCT_INFO;

typedef struct {
    U16  type;
    U32  len;          // bits
    U8   scope;
    U32  ptrLen[20];
} TYPE_INFO;

typedef enum {
  NIL,         // 0 : nil
  UNCHAR,      // 1 : unsigned char
  SCHAR,       // 2 : char
  UNINT,       // 3 : unsigned int
  SINT,        // 4 : int
  UNLONG,      // 5 : unsigned long
  SLONG,       // 6 : long
  SINGLE,      // 7 : float
  DOUBLE,      // 8 : double
  LDOUBLE,     // 9 : long double
  LABEL_SHORT, // label, short jump
  LABEL_LONG,  // label, long jump
  ARRAY,
  STRUCTURE,   // struct
  PROCEDURE,
  POINTER,     // *
  UNION,       // union  06/15/1994 James Wang
  ENUM,        // enumeration
} GENERIC_TYPE;

typedef enum {
  T_INTERRUPT = 0x63, // 0x63
  T_FILE,             // 0x64
  T_PACKED,           // 0x65
  T_UNPACKED,         // 0x66
  T_SET,              // 0x67
  T_RESERVE1,         // 0x68
  T_CHAMELEON,        // 0x69
  T_BOOLEAN,          // 0x6A
  T_TRUE,             // 0x6B
  T_FALSE,            // 0x6C
  T_CHAR,             // 0x6D
  T_INTEGER,          // 0x6E
  T_CONST,            // 0x6F
  T_RESERVE2,         // 0x70
  T_LABEL,            // 0x71
  T_LONG,             // 0x72
  T_SHORT,            // 0x73
  T_PROCEDURE,        // 0x74
  T_PARAMETER,        // 0x75
  T_DIMENSION,        // 0x76
  T_ARRAY,            // 0x77
  T_RESERVE3,         // 0x78
  T_STRUCTURE,        // 0x79
  T_POINTER,          // 0x7A
  T_SCALAR,           // 0x7B
  T_UNSIGNED,         // 0x7C
  T_SIGNED,           // 0x7D
  T_REAL,             // 0x7E
  T_LIST,             // 0x7F
  T_NULL,             // 0x80
  T_U16,              // 0x81
  T_NAME,             // 0x82
  T_INDEX,            // 0x83
  T_U24,              // 0x84
  T_REPEAT,           // 0x85
  T_S8,               // 0x86
  T_S16,              // 0x87
  T_S32,              // 0x88
} DATATYPE;

