/***************************************************************************
**
** File name : mem86.c for MICE-III(186)
**
** Function :
**
**
**    Copyright (C) 1994 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**
**                              INCLUDE FILES
**
**
***************************************************************************/
#ifndef _ABI_FUNC_
#include "abifunc.h"
#endif

#ifndef _REG86_DEFINE_
#include "reg86.h"
#endif

#ifndef ABI_EXTERNAL_
#include "abiexts.h"
#endif

#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif

#ifndef _SD_ABI_EXT_
#include "sdabiext.h"
#endif

#include <string.h>

extern CmdFileBuf[];
extern cmdfile_flag;
extern GetOneLineFromCmdFile();
extern int ESCflag;
/**************************************************************************
**
**
**    LOCAL DEFINITIONS
**
**
***************************************************************************/
#define BUFF_SIZE        240
#define CR 0xd
#define HAND_SHAKE 0x3
#define NULL 0

S8 *attr_code[]={"IR", "I", "ER", "E", "G" };
//S8 mapTable[256];
S16 first_load, next_load;
struct 	csipData {
       U32 low;
       U32 high;
} RangeAdr; 

/**************************************************************************
**
**
**    Functions Prototype Declaration
**
**
***************************************************************************/
S16 writeMemN(ADDR addr, U8 *buffer, U16 n);
S16 getAdrRange(ADDR addr, U16 len);
S16 binEnd(void);
S16 sendBin(S16 REC_ID, S16 length);
S16 binDown(ADDR addr, U8 *buffer, U16 len);
S16 binInit(void);
S16 send_long2(ADDR addr);
S16 emuEndLoad(void);
STATUS emuOutput(U16 port, U8 *data, U16 len, U16 size);
STATUS emuInput(U16 port, U16 len, U16 size, U8 *buff);
// STATUS emuTest(ADDR addr, U32 len);
// STATUS emuChecksum(ADDR addr, U32 len, U16 *n);
STATUS emuSearch(ADDR addr1, U32 len, U8 *buff, U16 patternLen, U16 *times);
STATUS emuCompare(ADDR addr1, U32 len, ADDR addr2, U16 *diff);
STATUS emuCopy(ADDR addr1, U32 len, ADDR addr2);
STATUS emuSetMem(ADDR addr, U8 ch);
STATUS emuGetMem(ADDR addr, U8 *buff);
STATUS emuGetMemN(ADDR addr, U8 *buff, U16 len);
STATUS emuFill(ADDR addr, U32 len, U8 *buff, U16 patternLen);
//STATUS emuGetMap(MAP_INFO *mapData);
STATUS emuGetMapSize(U8 *emmSize);
//STATUS emuSetMap (ADDR addr1, ADDR addr2, U16 attr);

STATUS send_5ch(U32 length);
extern S16 downCmdFlag;


STATUS emuGetMapSize(U8 *emmSize)
{
        if (HEMM) *emmSize = 2;
        else *emmSize = 0;
}

send_5ch(U32 length)
{
	int i;
	char c;

	for (i=4; i>=0; i--){
	   c = (length>>4*i)&0xf;
	   send(hex[c]);
	}
}

/****************************************************************************
**
**  Name : emuFill
**
**  Function :
**
**     Input :
**
**     Output :
**
**  Notes :
****************************************************************************/
STATUS emuFill(ADDR addr, U32 len, U8 *buff, U16 patternLen)
{
char *ptr, c;
S16 i;

        send_str2("F ");
	send_csip(addr);
	send_str2(" LEN ");
	send_5ch(len);
	ptr=buff;
        for (i=0;i < patternLen;i++) {
	    send(' ');
	    send_byte(*ptr++);
	}
	send(CR);
	ptr=tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr=NULL;
	return check_error(tx_buf);
}   // end of emuFill(addr, len, buff, patternLen)


/****************************************************************************
**
**  Name :  emuGetMemN
**
**  Function :
**
**     Input  :
**
**     Output :
**
**  Note :
**
****************************************************************************/
STATUS emuGetMemN(ADDR addr, U8 *buff, U16 len)
{
S8 *ptr;
U8 *ptr1, check_sum;
U8 c, d;
U32 l, l1, l2, l3;
S16 i, j, k, length, seg_flag;

        if (!len) return(OK);
        if (getAdrRange(addr, len) == -1) return(OK);   //get struct RangeAdr
        ptr1=buff;
        send_str2("UP ");
        send_csip(RangeAdr.low);
        send(' ');
        send_long(RangeAdr.high);
     //   send(CR);
        send_CR_wait(CR);
        for (;;) {
                seg_flag=0;
                for (j=0;j<5;j++) {
                        check_sum=0;
                        ptr=tx_buf;
                        while ((c=receive()) != ':')
                           if (c == HAND_SHAKE ) return (ICE_ERROR_READ);
                        length=rx_byte(); //two BCD codes
                        check_sum += (U8)length;
                        for (i=0;i<2;i++) {
                                c=rx_byte();
                                check_sum += c;
                        }
                        if ((c=rx_byte()) == 1) { // TYPE 01, EOF Record
                                while (receive() != HAND_SHAKE);
                                send(ACK);
                                while (receive() != HAND_SHAKE);
                                send_ESC();
                                return(OK);
                        } else check_sum += c;
                        if (c == 2) {
                                seg_flag=1;
                                while (receive() != HAND_SHAKE);
                                send(ACK);
                                break;
                        }
                        for (i=0;i<length;i++) {
                                c=rx_byte();
                                check_sum += c;
                                *ptr++=c;
                        }
                        c=rx_byte();
                        receive();        // receive HAND_SHAKE
                        d= 0 - check_sum;
                        if (c == d) break;
                        send(NACK);
                }
                if (j == 5) {
                        send_ESC();
                        return (ICE_ERROR_READ);
                }
                if (!seg_flag) {
                        ptr=tx_buf;
                        for (i=0;i<length;i++) *ptr1++ = *ptr++;
                        send(ACK);
                }
        }
} /* end of emuGetMemN() */

/****************************************************************************
**
**  Name :  emuGetMem
**
**  Function :
**
**     Input  :
**
**     Output :
**
**  Note :
**
****************************************************************************/
STATUS emuGetMem(ADDR addr, U8 *buff)
{

U8 c;
U32 rx_long();
U32 l;

        send('B');
        send(' ');
        send_csip(addr);
        send(CR);
        l=rx_long();
        c=(char)l;
        send_ESC();
        *buff=c;
        return(OK);
}

/**************************************************************************
**
** Name : emuSetMemN
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetMemN(ADDR addr, U8 *buff, U16 len)
{
STATUS retCode = OK;

    if (!downCmdFlag) retCode = writeMemN(addr, buff, len);
    else {
      noLoad=0;
      if (!downLoadMode) binInit();
      binDown(addr, buff, len);
      next_load = addr + len;
   }
   return (retCode);
}



/**************************************************************************
**
**  Name : emuEndLoad
**
**  Function :
**
**    Input  :
**
**    Output :
**
**  Note :
**
**************************************************************************/
STATUS emuEndLoad(void)
{
    binEnd();
    downLoadMode=0;
        binFlag=0;
        emuSetReg(I86_REG,IP,(U32)cpu_regs[IP]);
        emuSetReg(I86_REG,CS,(U32)cpu_regs[CS]);
        emuSetReg(I86_REG,DS,(U32)cpu_regs[DS]);
        emuSetReg(I86_REG,SS,(U32)cpu_regs[SS]);
        emuSetReg(I86_REG,RSP,(U32)cpu_regs[RSP]);
}


/**************************************************************************
**
** Name : emuSetMem
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetMem(ADDR addr, U8 ch)
{
U16 i;
char *ptr, c;

        send('B');
        send(' ');
        send_csip(addr);
        send(' ');
        send_byte(ch);
        send(CR);
        ptr=tx_buf;
        while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
        *ptr=NULL;
        i = check_error(tx_buf);
        if (i != OK) return(i);
   //     send_byte(ch);
   //     send_CR_wait(HAND_SHAKE);
   //     send_ESC();
        return(OK);
}  /* end of emuSetMem(addr, d) */

/**************************************************************************
**
** Name : emuCopy()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuCopy(ADDR addr1, U32 len, ADDR addr2)
{
S8 *ptr, c;

        send_str2("CO ");
        send_csip(addr1);
		send_str2(" LEN ");
		send_5ch(len);
        if (addr1 != addr2) {
                 send(' ');
                 send_csip(addr2);
        }
       	send(CR);
        ptr=tx_buf;
        while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
        *ptr=NULL;
        return check_error(tx_buf);
}   // end of emuCopy()

/**************************************************************************
**
** Name : emuCompare()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuCompare(ADDR addr1, U32 len, ADDR addr2, U16 *diff)
{
S8 *ptr, c;
S16 i,j;
U32 findCS1, findCS2;
U16 findIP1, findIP2;
U16 findData1, findData2;
U32 loop;
char  BUF[80], tempChar;
U32 tempAddr1, stdAddr, stdAddr1;
U32 tempAddr2;
S32 tempLen;
int key;

   *diff = 0;
   emuGetAccessSize(&j);
   j++;     // j=1:byte; 2:word
   tempAddr1 = (addr1&0xf000ffff)+(U16)((addr1&0x0fff0000)>>12);
   tempAddr2 = (addr2&0xf000ffff)+(U16)((addr2&0x0fff0000)>>12);
   tempLen = len;

   stdAddr = tempAddr1 + len;
   if ( (stdAddr&0xffff0000) != (tempAddr1&0xffff0000))
      stdAddr1 = stdAddr - 0x10000 + 0x10000000;

   for (loop=0; loop < len, tempLen > 0; loop+=j){
	  key = chk_hlt();
	  if (key == ESC || ESCflag){
            ESCflag = 0;
            send_ESC();
			return(HALT_USER);
        }
      send_str2("COM ");
      send_csip(tempAddr1);
	  send_str2(" LEN ");
	  send_5ch(tempLen);
      send(' ');
      send_csip(tempAddr2);
      send(CR);

   ptr=tx_buf;
   while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
   *ptr=NULL;
   i = check_error(tx_buf);
   if (i != OK) return(i);
   if (strstr(tx_buf, "complete") != NULL ){
      if ( *diff == 0)
           return(NO_DIFF);
      else return(OK);
   }

   ptr = tx_buf;
   while (*ptr++ != '(');
   sscanf(ptr,"%lx:%x) = %x",&findCS1, &findIP1, &findData1);
   while (*++ptr != '(');
   sscanf(ptr,"(%lx:%x) = %x",&findCS2,&findIP2,&findData2);

        if (*diff == 0) DisplayStr(" Data difference found at:\r\n");
        if (j == 1)
          sprintf(BUF," (%04X:%04X)=%02X, (%04X:%04X)=%02X\r\n",
               (U16)findCS1, findIP1, findData1,
               (U16)findCS2, findIP2, findData2);
        else
          sprintf(BUF," (%04X:%04X)=%04X, (%04X:%04X)=%04X\r\n",
               (U16)findCS1, findIP1, findData1,
               (U16)findCS2, findIP2, findData2);
        DisplayStr(BUF);
        (*diff)++;

         tempAddr1 = (findCS1<<16) + findIP1+j;
         tempAddr2 = (findCS2<<16) + findIP2+j;
         tempLen = stdAddr - tempAddr1;

         if (findIP1 >= findIP1+j){
            findIP1 += j;
            tempAddr1 = ( (findCS1+0x1000)<<16) +findIP1;
            stdAddr = stdAddr1;
            tempLen = stdAddr - tempAddr1;
         }
         if (findIP2 >= findIP2+j){
            findIP2 += j;
            tempAddr2 = ( (findCS2+0x1000)<<16) + findIP2;
         }
        if ((*diff & 0xf) == 0) {
              DisplayStr("[More]");
                       if (cmdfile_flag) {
                                GetOneLineFromCmdFile();
                                tempChar = CmdFileBuf[0];
                       } else tempChar = getch();
               if (tempChar == ESC) break;
               else DisplayStr("\r\n");
        }
   }      // end of for
   return(OK);
}    /* end of emuCompare() */

/**************************************************************************
**
** Name : emuSearch(addr, len, buff, size, times)
**
** Function   search block for pattern
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSearch(ADDR addr1, U32 len, U8 *buff, U16 patternLen, U16 *times)
{
S8 *ptr, c;
S16 i, j;
ADDR tempAddr,stdAddr, stdAddr1;
U32 loop;
U32 searchCS;
U16 searchIP;
char  BUF[80], tempChar;
S32 tempLen;
int key;

   *times = 0;
   emuGetAccessSize(&j);
   j++;     // j=1:byte; 2:word

   tempAddr = (addr1&0xf000ffff)+(U16)((addr1&0x0fff0000)>>12);
   tempLen = len;
   stdAddr = tempAddr + len;
   if ( (stdAddr&0xffff0000) != (tempAddr&0xffff0000))
      stdAddr1 = stdAddr - 0x10000 + 0x10000000;

   for (loop=0; loop < len, tempLen > 0; loop+=j){
		key = chk_hlt();
		if (key == ESC || ESCflag){
			   ESCflag = 0;
			   send_ESC();
			   return(HALT_USER);
		}
		send_str2("SE ");
        send_csip(tempAddr);
		send_str2(" LEN ");
		send_5ch(tempLen);
        ptr=buff;
        for (i=0;i < patternLen;i++) {
                send(' ');
                send_byte(*ptr++);
        }
        send(CR);

        ptr=tx_buf;
        while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
        *ptr=NULL;
        i = check_error(tx_buf);
        if (i != OK) return(i);
        if (strstr(tx_buf, "complete") != NULL){
            if ( *times == 0) return(NO_FOUND);
            else return(OK);
        }

     ptr = tx_buf;
     while ((c=*ptr++) != '-');
     sscanf(ptr,"- data matched at %lx:%x", &searchCS, &searchIP);

         sprintf(BUF," Data matched at %04X:%04X \n\r", (U16)searchCS, searchIP );
         DisplayStr(BUF);
         (*times)++;
         if ( (searchCS<<16) != (tempAddr&0xffff0000) )
             stdAddr = stdAddr1;
         if ( searchIP >= searchIP+j ){
            searchIP += j;
            tempAddr = ( (searchCS+0x1000)<<16) +searchIP;
            stdAddr = stdAddr1;
          }
         else tempAddr = (searchCS<<16) + searchIP+j;
         tempLen = stdAddr - tempAddr;
         if ((*times & 0xf) == 0) {
            DisplayStr("[More]");
                    if (cmdfile_flag) {
                        GetOneLineFromCmdFile();
                        tempChar = CmdFileBuf[0];
                    } else tempChar = getch();
            if (tempChar == ESC) {
               break;
            } else DisplayStr("\r\n");
         }
      }
      return(OK);
} /* end of emuSearch() */

/**************************************************************************
**
** Name : emuChecksum
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
STATUS emuChecksum(ADDR addr, U32 len, U16 *n)
{
S8 c, *ptr;
S16 i;
U16 j;

        send_str2("CH ");
        send_csip(addr);
        send_str2(" L ");
                if (len >= 0x10000) send_str2("10000");else send_word(len);
        send(CR);
        ptr=tx_buf;
        while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
        *ptr=NULL;
        i = check_error(tx_buf);
        if (i != OK) return(i);
		ptr = tx_buf;
		while (*ptr++ != 'i');
        sscanf(ptr, "s %x", &j);
        *n = j;
		return(OK);
}
*/

/**************************************************************************
**
** Name :  emuTest
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
STATUS emuTest(ADDR addr, U32 len)
{
S8 c, *ptr;
S16 i;
U32 l1,l2;

        send_str2("TE ");
        send_csip(addr);
        send_str2(" L ");
        if (len >= 0x10000) send_str2("10000");
            else send_word(len);
        send(CR);
        ptr=tx_buf;
        while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
        *ptr=NULL;
        i = check_error(tx_buf);
        if (i != OK) return(i);
		if (strstr(tx_buf, "found") != NULL) return(OK);
		ptr = tx_buf;
		while (*ptr++ != '-');
		sscanf(ptr, "- failure at %lx:%lx", &l1, &l2);
		ret_addr1 = (l1<<16) + l2; 
		return(TEST_FAIL);
}
*/

/**************************************************************************
**
** Name : emuInput
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuInput(U16 port, U16 len, U16 size, U8 *buff)
{
S8 c, *ptr;
U16 l1, l2;

        if (size) send_str2("I W ");else send_str2("I ");
	send_word(port);
	send_CR_wait(CR);
	while (receive() != CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	sscanf(tx_buf,"%x %x", &l1, &l2);
	*buff++ = (U8)l2&0xff;
	if (size) *buff = (U8)(l2>>8)&0xff;
	return(OK);
}

/**************************************************************************
**
** Name :  emuOutput
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuOutput(U16 port, U8 *data, U16 len, U16 size)
{
	if (size) send_str2("O W ");else send_str2("O ");
	send_word(port);
	send(' ');
	if (size) send_byte(*data++);
	send_byte(*data);
	send_CR_wait(HAND_SHAKE);
	return(OK);
}

/**************************************************************************
**
** Name : getAdrRange
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 getAdrRange(U32 addr, U16 len)
{
U32 L0, L1, L2, L3, L4;

        L0 = (addr >> 16) * 0x10 + (addr & 0xffff); //startAbsAddr
        if (L0 >= 0x100000) return(-1);
        L1 = L0+len-1;    //endAbsAddr
        if (L1 >= 0x100000) L1 = 0xfffff;
        L2 = addr >> 16;
        for (;;) {
                L3 = L1 - (L2 * 0x10);   //endOffset, deal while L1>0x100000
                if (L3 < 0x10000) break;
                L2++;
        }
        RangeAdr.high = (L2 << 16) + L3; //endAddr
        L3 = L0 - (L2 * 0x10);
        RangeAdr.low = (L2 << 16) + L3;  //startAddr
        return(0);
}

/**************************************************************************
**
** Name : send_long2
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 send_long2(U32 addr)
{
S16 i;
char c;

        for (i=4; i >= 0; i--) {
                c=(addr>>i*4)&0xf;
                send(hex[c]);
        }
}

/**************************************************************************
**
** Name : writeMemN(addr, buffer, n)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
writeMemN(U32 addr, U8 *buffer, U16 n)
{
U16 i;
U8 c;
S8 *ptr;

        if (n == 1) return emuSetMem(addr, *buffer);
        send('B');
        send(' ');
        send_csip(addr);
        for (i=0;i < n;i++) {
             send(' ');
             send_byte(*buffer++);
        }
        send(CR);
        ptr=tx_buf;
        while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
        *ptr=NULL;
        return check_error(tx_buf);
}  /* end of writeMemN() */

/**************************************************************************
**
** Name : binInit
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 binInit(void)
{
S16 i;
S16 c;

        first_load = 1;
        send(0xb);
        for (;;) {
                c = receive(); /*    c = RX_DATAP(); */
                if (c < 0) continue;
                if (c == 0xb) break;
                if (c != HAND_SHAKE) while (receive() != HAND_SHAKE);
                downLoadMode = 1;
                binFlag=1;
                return;
        }
        send_ESC();
        binFlag=0;
}

/**************************************************************************
**
** Name : binDown
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 binDown(U32 addr, U8 *buffer, U16 len)
{
S16 i, j, length, len1;
U8 c, check_sum, *ptr;
S8 *ptr1;
U32 stadr, l;

  if (first_load || addr != next_load) {
        ptr1=tx_buf;
        *ptr1++=0x24;
        i=4;
        for (j=3;j >= 0 ; j--) {
                l = addr >> (8*j);
                *ptr1++ = (S8) (l & 0xff);
        }
        for (j=0,ptr1=tx_buf,check_sum=0;j<i+1; j++)
                check_sum += *ptr1++;
        *ptr1 = 0xff-check_sum;
        sendBin(0,i+2);
        first_load = 0;
    }
        ptr=buffer;
        for (;;) {
                ptr1=tx_buf;
                check_sum=0;
                len1=len;
                for (i=0;i<224 && len1 > 0;i++,len1--) {
                        c = *ptr++;
                        check_sum += c;
                        *ptr1++ = c;
                }
                if (len1 == 0) length=len;
                else {
                        length=224;
                        len -= 224;
                }
                check_sum += length;
                *ptr1 = 0xff-check_sum;
                sendBin(length, length+1);
                if (len1 == 0) break;
        }
}   /* end of binDown(addr, buffer, len) */

/**************************************************************************
**
** Name : sendBin
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 sendBin(S16 REC_ID, S16 length)
{
S16 i, j;
S8 *ptr1, c;

        for (j=0;j<5;j++) {
            send(REC_ID);
            ptr1=tx_buf;
            for (i=0;i < length;i++) {
                c = *ptr1++;
                                send(c);
                }
                c=receive();
                if (receive() != HAND_SHAKE) {
                    while (receive() != HAND_SHAKE);
                noLoad=1;
                return(MEM_PROTECT);
                }
            if (c == ACK) break;
                if (j == 5) {
              binEnd();
              return(ERROR_COM);
                }
        }
        return(0);
}

/**************************************************************************
**
** Name : binEnd
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 binEnd(void)
{
        send(0x0);
        send(0x10);
        send(0xef);
        while (receive() != 0x6);
        while (receive() != HAND_SHAKE);
}

/**************************** End of File **********************************/
