/***************************************************************************
**
** File name : menu1.c
**
**    This file includes the routines for processing the FILE, SETUP,
**    MEMORY, and EMULATION pulldown menus.
**
** Changing :
**
** A. Date -- 10/20/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/22/1992 By Cheerson
**      0.
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "menu.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "dialog.h"
#include  "dlggbl.h"
#include  "funcdecl.h"
#include  "funclist.h"
#include  "funcext.h"
#include  "abidef.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define PULLDOWN    1
#define DIALOG      2

/**************************************************************************
**
** Local variables
**
***************************************************************************/

char FormMsg[]       = " <F1> Help, <F6> Clear, <F10> Execute, <ESC> Quit, <CR> Accept input";
char TFormMsg[]      = " <F1>Help <F2>Show choices <SP>Toggle options <F6>Clear <F10>Execute <ESC>Quit";
char BoolFldMsg[]    = " <F1> Help, <SPACE> Toggle the option, <F10> Execute, <ESC> Quit, <CR> Enter";
char chListMsg[]   = " <F1> Help, <F2> Show choices, <F6> Clear, <F10> Execute, <ESC> Quit";
int retcode;
UCHAR selection[DATBUFROW];
int selcnt=0, rowcnt;
int MarkIt(),ShowMonData(), F2Control();

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int pulldown_or_dialog;
extern UCHAR GblDlgColor[];
extern UCHAR GblDlgMono[];
extern  MFILEPTR tmpMFile;
extern char log_menu_file[];
extern int MICE;

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : ShowShadow(wnp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ShowShadow(WINDOWPTR wnp)
{
/* CORE 90.08.14 Test */
#ifndef NEC_PC9801
   sw_updnfp(wn_expset,wn_expunset,wnp);
   if (vid_getmode() == MONO) memcpy((wnp->lattarray+26),GblDlgMono,3);
   else memcpy((wnp->lattarray+26),GblDlgColor,3);
#endif
}      /* end of ShowShadow(wnp) */

/**************************************************************************
**
** Name : ErrorProc()
**
** Function: Shows error message window when errors happen.
**
**    Input  : VV_ERR (global )
**
**    Output : none
**
** Notes:
**
**************************************************************************/

ErrorProc()
{
   WINDOWPTR wnp;
   char temp[20];

   wnp = wn_def(10,16,5,50,LWHI_RED,BDR_DLNP);
   sw_bdratt(LWHI_RED,wnp);
   wn_up(wnp);

   switch (VV_ERR)  {
      case MEMLACK:
         v_st("\nInsufficient memory!\n",wnp);
         break;
      case ERRCLOSE:
         v_st("\nError closing dialog library!\n",wnp);
         break;
      case ERROPEN:
         v_st("\nError opening file!\n",wnp);
         break;
      case FILETOOBIG:
         v_st("\nFile too big to load!\n",wnp);
         break;
      case DL_LIBCOR:
         v_st("\nUnable to access dialog library!\n",wnp);
         break;
      case DL_LOCKED:
         v_st("\nPlease remove MV86DLG.VV$ directory.\n",wnp);
         break;
      case FL_NLIB:
         v_st("\nUnable to find dialog library file!\n",wnp);
         break;
      case FL_NUNLOCKED:
         v_st("\nFL_NUNLOCKED",wnp);
         sprintf(temp,"\nError code: %d",VV_ERR);
         v_st(temp,wnp);
         break;
      default:
         sprintf(temp,"\nError code: %d",VV_ERR);
         v_st(temp,wnp);
         break;
   }  /* end switch */
   v_st("\nPress any key to continue ... ",wnp);
   ki();
   wn_dn(wnp);
   wn_free(wnp);
   return;
}        /* end of ErrorProc() */

/**************************************************************************
**
** Name : MN_F_DOWNLOAD( FilMenuCopy )
**
** Function :  FILE menu Download menu-item
**
**    Input  : Menu form pointer
**
**    Output : DlgBuf, ExecDlgFlag
**
** Notes:
**
**************************************************************************/

MN_F_DOWNLOAD(MFORMPTR  FilMenuCopy )
{
   FDOWNLOAD *datap;
   DFIELDPTR fldptr;
   WINDOWPTR msgwnp;
   KEYFP tmpF2;

/*-------------------------------------------------------------------
   Sets data form, user function, choice list, and vvd  pointers.
   Note that Filename field installed a dummy choicelist(in VVD)
   for enabling mouse left button to function in Filename field.
   It is assigned to F2 and used for popping up the DIR window.
   User function : FilenameEnd
   Choicelist : dummy
  ------------------------------------------------------------------*/
   datap = &fdownload;
   VV_ERR = 0;
   DlgFmPtr = dl_fmget("FDownload",datap,usd3dlg,CListMFilePtr ,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
/*-------------------------------------------------------------------
   Initialize Filename field
 ------------------------------------------------------------------*/
   if (!(datap->filename[0])) strcpy( datap->filename, "*.OMF" );
/* else {
      if ((strstr(datap->filename, "*") != NULL) ||
          (strstr(datap->filename, "?") != NULL)) {
         fldptr = (DFIELDPTR) i_namptr("filename",DlgFmPtr);
         sf_msg(chListMsg+1,fldptr);
      }
   } */
/*-------------------------------------------------------------------
   Shows message window and processes data form
 ------------------------------------------------------------------*/
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
/*-------------------------------------------------------------------
   Convert dialog box to command line
 ------------------------------------------------------------------*/
   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcpy(DlgBuf,"DO ");
         strcat(DlgBuf,datap->filename);
         strcat(DlgBuf,"\r");
      }
   }
/*-------------------------------------------------------------------
   Assigns return level :
   EXITMENU  : leave from both dialog box and pull down menu
   SAMELEVEL : leave from dialog box only
 ------------------------------------------------------------------*/
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  end of MN_F_DOWNLOAD()  */

/**************************************************************************
**
** Name : MN_F_UPLOAD( FilMenuCopy )
**
** Function :  FILE menu Upload menu-item
**
**    Input  : Menu form pointer
**
**    Output : DlgBuf, ExecDlgFlag
**
** Notes:
**
**************************************************************************/

MN_F_UPLOAD(MFORMPTR  FilMenuCopy )
{
   FUPLOAD   *datap;
   DFIELDPTR fldptr;
   WINDOWPTR msgwnp;
   KEYFP tmpF2;

/*-------------------------------------------------------------------
   Sets data form, user function, choice list, and vvd  pointers.
   Note that Filename field installed a dummy choicelist(in VVD)
   for enabling mouse left button to function in Filename field.
   It is assigned to F2 and used for poping up the DIR window.
   User function : FilenameEnd
   Choicelist : dummy
  ------------------------------------------------------------------*/
   datap = &fupload;
   VV_ERR = 0;
   DlgFmPtr = dl_fmget("FUpload",datap,usd3dlg,CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
/*-------------------------------------------------------------------
   Initialize Filename field
 ------------------------------------------------------------------*/
   if (!(datap->filename[0])) strcpy( datap->filename, "*.*" );
/* else {
      if ((strstr(datap->filename, "*") != NULL) ||
          (strstr(datap->filename, "?") != NULL)) {
         fldptr = (DFIELDPTR) i_namptr("filename",DlgFmPtr);
         sf_msg(chListMsg+1,fldptr);
      }
   } */
/*-------------------------------------------------------------------
   Shows message window and processes data form
 ------------------------------------------------------------------*/
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
/*-------------------------------------------------------------------
   Convert dialog box to command line
 ------------------------------------------------------------------*/
   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcpy(DlgBuf,"U ");
         strcat(DlgBuf,datap->filename);
         strcat(DlgBuf,"\r");
      }
   }
/*-------------------------------------------------------------------
   Assigns return level :
   EXITMENU  : leave from both dialog box and pull down menu
   SAMELEVEL : leave from dialog box only
 ------------------------------------------------------------------*/
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  end of MN_F_UPLOAD()  */

/**************************************************************************
**
** Name : MN_F_INCLUDE( FilMenuCopy )
**
** Function :  FILE menu Include menu-item
**
**    Input  : memu form pointer
**
**    Output : DlgBuf, ExecDlgFlag
**
** Notes:
**
**************************************************************************/

MN_F_INCLUDE(MFORMPTR  FilMenuCopy )
{
   FINCLUDE *datap;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;
   KEYFP tmpF2;

/*-------------------------------------------------------------------
   Sets data form, user function, and vvd  pointers.
   User function : FilenameEnd
  ------------------------------------------------------------------*/
   VV_ERR = 0;
   datap = &finclude;
   DlgFmPtr = dl_fmget("FInclude",datap,usd3dlg,CListMFilePtr , VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
/*-------------------------------------------------------------------
   Shows message window and processes data form
 ------------------------------------------------------------------*/
   if (!(datap->filename[0])) strcpy( datap->filename, "*.INC" );
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
/*-------------------------------------------------------------------
   Convert dialog box to command line
 ------------------------------------------------------------------*/
   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcpy(DlgBuf,"INC ");
         strcat(DlgBuf,datap->filename);
         if (datap->arguments[0] != '\0') {
            strcat(DlgBuf," (");
            strcat(DlgBuf,datap->arguments);
            strcat(DlgBuf,")");
         }
         strcat(DlgBuf,"\r");
      }
   }
/*-------------------------------------------------------------------
   Assigns return level :
   EXITMENU  : leave from both dialog box and pull down menu
   SAMELEVEL : leave from dialog box only
 ------------------------------------------------------------------*/
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_F_INCLUDE()  */

/**************************************************************************
**
** Name : MN_F_LOG( FilMenuCopy )
**
** Function : FILE menu Log File menu-item
**
**    Input  : memu form pointer
**
**    Output : DlgBuf, ExecDlgFlag
**
** Notes:
**
**************************************************************************/

MN_F_LOG(MFORMPTR  FilMenuCopy )
{
   FLOG *datap;
   DFIELDPTR fldptr;
   WINDOWPTR msgwnp;
   KEYFP tmpF2;

/*-------------------------------------------------------------------
   link data structure with data form, and get form from VVD library
   User function : FilenameEnd
  ------------------------------------------------------------------*/
   VV_ERR = 0;
   datap = &flog;
   DlgFmPtr = dl_fmget("FLog",datap,usd3dlg,CListMFilePtr ,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   fldptr = (DFIELDPTR) i_namptr("append",DlgFmPtr);
   sf_msg(BoolFldMsg+1,fldptr);
   memset(datap->filename,NULL,20);
   if (!(log_cmd_file[0])) strcpy( datap->filename, "*.LOG" );
   else memcpy(datap->filename,log_cmd_file,12);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcpy(DlgBuf,"LOG ");
         strcat(DlgBuf,datap->filename);
         if (datap->append == TRUE) strcat(DlgBuf," APPEND");
         strcat(DlgBuf,"\r");
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_F_LOG()  */

/**************************************************************************
**
** Name : MN_F_DOS()
**
** Function : FILE menu DOS     menu-item
**
**    Input  : memu form pointer
**
**    Output : DlgBuf, ExecDlgFlag
**
** Notes:
**
**************************************************************************/

MN_F_DOS(MFORMPTR  FilMenuCopy )
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"DOS\r");
   return( EXITMENU );

}  /*  of MN_F_DOS()  */

/**************************************************************************
**
** Name : MN_F_QUIT()
**
** Function :FILE menu QUIT    menu-item
**
**    Input  : memu form pointer
**
**    Output : DlgBuf, ExecDlgFlag
**
** Notes:
**
**************************************************************************/

MN_F_QUIT(MFORMPTR FilMenuCopy )
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"Q\r");
   return( EXITMENU );

}  /*  of MN_F_QUIT()  */

/**************************************************************************
**
** Name : MN_F_VERSION()
**
** Function : FILE menu VERSION    menu-item
**
**    Input  : memu form pointer
**
**    Output : none
**
** Notes:
**
**************************************************************************/

MN_F_VERSION(MFORMPTR  FilMenuCopy )
{
   return( SAMELEVEL );

}  /*  of MN_F_VERSION()  */

/**************************************************************************
**
** Name : MN_F_CLOSE_LOGJOU( FilMenuCopy )
**
** Function : FILE menu Close Log/Journal File dialog
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_F_CLOSE_LOGJOU(MFORMPTR   FilMenuCopy )
{
   FCLOSELOGJOU *datap;
   DFIELDPTR fldptr;
   WINDOWPTR msgwnp;

/*-------------------------------------------------------------------
   link data structure with data form, and get form from VVD library
  ------------------------------------------------------------------*/
   VV_ERR = 0;
   datap = &fcloselogjou;
   DlgFmPtr = dl_fmget("FCloselogjou",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
   memset(datap->logfile,NULL,13);
   memset(datap->joufile,NULL,13);
   memcpy(datap->logfile,log_cmd_file,12);
   memcpy(datap->joufile,log_out_file,12);
   if (log_cmd_file[0] != '\0') datap->log = FALSE;
   if (log_out_file[0] != '\0') datap->journal = FALSE;

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      if (datap->log == TRUE) {
         if (log_cmd_file[0] != '\0') strcat(DlgBuf,"LOG C\r");
      }
      if (datap->journal == TRUE) {
         if (log_out_file[0] != '\0') strcat(DlgBuf,"JOU C\r");
      }
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);
}         /* end of MN_F_CLOSE_LOGJOU()  */


/**************************************************************************
**
** Name : MN_F_JOURNAL( FilMenuCopy )
**
** Function : FILE menu Journal File menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_F_JOURNAL(MFORMPTR  FilMenuCopy )
{
   FJOURNAL *datap;
   DFIELDPTR fldptr;
   WINDOWPTR msgwnp;
   KEYFP tmpF2;

   datap = &fjournal;
   VV_ERR = 0;
   DlgFmPtr = dl_fmget("FJournal",datap,usd3dlg,CListMFilePtr ,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
   fldptr = (DFIELDPTR) i_namptr("append",DlgFmPtr);
   sf_msg(BoolFldMsg+1,fldptr);
   memset(datap->filename,NULL,20);
   if (!(log_out_file[0])) strcpy( datap->filename, "*.JOU" );
   else memcpy(datap->filename,log_out_file,12);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcpy(DlgBuf,"JO ");
         strcat(DlgBuf,datap->filename);
         if (datap->append == TRUE) strcat(DlgBuf," APPEND");
         strcat(DlgBuf,"\r");
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_F_JOURNAL()  */

/**************************************************************************
**
** Name : MN_S_MAP()
**
** Function : SETUP menu Map menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_S_MAP(MFORMPTR SetMenuCopy )
{
extern int HEMM;        // how to get the value of HEMM
extern int MICE;

   SMAP1 *datap;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;
   char temp[20];


   VV_ERR = 0;
   datap = &smap1;
//   DlgFmPtr = dl_fmget("SMap1",datap,usd3dlg,CListMFilePtr,VVDLibp);
    if ( MICE >= I8088MAX && MICE <= V30MIN ) {
        DlgFmPtr = dl_fmget("SMap8688",datap,usd3dlg,CListMFilePtr,VVDLibp);
    }
    else if ( HEMM==1 ) {
        DlgFmPtr = dl_fmget("SMapHEMM",datap,usd3dlg,CListMFilePtr,VVDLibp);
    }
    else if ( HEMM==0 ) {
        DlgFmPtr = dl_fmget("SMapEMM",datap,usd3dlg,CListMFilePtr,VVDLibp);
    }

    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   fldptr = (DFIELDPTR) i_namptr("mapOptions",DlgFmPtr);
   sf_msg(BoolFldMsg+1,fldptr);
   fldptr = (DFIELDPTR) i_namptr("mapattr",DlgFmPtr);
   sf_msg(TFormMsg+1,fldptr);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"MAp");
      if (datap->mapOptions == TRUE) {
         strcat(DlgBuf, " 0 FFFFF E\r");
         return(EXITMENU);
      }
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->mapbeg);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->mapend);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->mapattr);
      strcat(DlgBuf,"\r");
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);
}  /*  of MN_S_MAP()  */

/**************************************************************************
**
** Name : MapOptionsEnd
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
MapOptionsEnd(DFORMPTR dfmptr)
{
   DFIELDPTR fldptr,pp;
   int curItem, state, i ;

   curItem = curitemnum(dfmptr);
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr  );
   fld_get(fldptr->datap,curItem, dfmptr );
   if (*((UCHAR *)(fldptr->datap)) == TRUE) state = ON;
   else state = OFF;
   for (i=0; i < 3; i++ ) {
      pp = (DFIELDPTR) i_numptr(++curItem, dfmptr );
      sf_opt(SKIP, state, pp);
   }
   return(TRUE);
}
/**************************************************************************
**
** Name : MN_S_RECALL( SetMenuCopy )
**
** Function :  SETUP menu Recall menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_S_RECALL(MFORMPTR  SetMenuCopy )
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"RECall \r");
   return( EXITMENU );


/*
   SRECALL   *datap;
   DFIELDPTR fldptr;
   WINDOWPTR msgwnp;
   KEYFP tmpF2;

   datap = &srecall;
   VV_ERR = 0;
   DlgFmPtr = dl_fmget("SRecall",datap,usd3dlg, CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
    if (!(datap->filename[0])) {    // Chen 06/10/94
        if ( LAM2 == 2 ) {
            strcpy( datap->filename, "MICELAM2.SAV" );
        }
        else if ( LAM2 == 0 ) {
            strcpy( datap->filename, "MICELAM.SAV" );
        }
    }

// else {
//      if ((strstr(datap->filename, "*") != NULL) ||
//          (strstr(datap->filename, "?") != NULL)) {
//         fldptr = (DFIELDPTR) i_namptr("filename",DlgFmPtr);
//         sf_msg(chListMsg+1,fldptr);
//      }
//   }

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcpy(DlgBuf,"REC ");
         strcat(DlgBuf,datap->filename);
         strcat(DlgBuf,"\r");
      }
      return( EXITMENU );
   }
   else if (retcode == AC_QUIT) return(SAMELEVEL);
*/
}

/**************************************************************************
**
** Name : MN_S_SAVE( SetMenuCopy )
**
** Function :  SETUP menu Save menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_S_SAVE(MFORMPTR  SetMenuCopy )
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"SAve \r");
   return( EXITMENU );


/*
   SSAVE *datap;
   DFIELDPTR fldptr;
   WINDOWPTR msgwnp;
   KEYFP tmpF2;

   datap = &ssave;
   VV_ERR = 0;
   DlgFmPtr = dl_fmget("SSave",datap,usd3dlg,CListMFilePtr ,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
    if (!(datap->filename[0])) {
        if ( LAM2 == 2 ) {
            strcpy( datap->filename, "MICELAM2.SAV" );
        }
        else if ( LAM2 == 0 ) {
            strcpy( datap->filename, "MICELAM.SAV" );
        }
    }

// else {
//      if ((strstr(datap->filename, "*") != NULL) ||
//          (strstr(datap->filename, "?") != NULL)) {
//         fldptr = (DFIELDPTR) i_namptr("filename",DlgFmPtr);
//         sf_msg(chListMsg+1,fldptr);
//      }
//   }

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcpy(DlgBuf,"SA ");
         strcat(DlgBuf,datap->filename);
         strcat(DlgBuf,"\r");
      }
      return( EXITMENU );
   }
   else if (retcode == AC_QUIT) return(SAMELEVEL);
*/

}

/**************************************************************************
**
** Name : MN_S_SETUP()
**
** Function :SETUP menu SETUP   menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_S_SETUP(MFORMPTR SetMenuCopy )
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"SET\r");
   return( EXITMENU );

}  /*  of MN_S_SETUP()  */

/**************************************************************************
**
** Name : MN_M_CHECKSUM( MemMenuCopy )
**
** Function :  MEMORY menu Checksum menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_CHECKSUM(MFORMPTR   MemMenuCopy )
{
   MCHECKSUM *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &mchecksum;
   DlgFmPtr = dl_fmget("MChecksum",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"CH ");
      strcat(DlgBuf,datap->checkbegin);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->checkend);
      strcat(DlgBuf,"\r");
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_CHECKSUM()  */

/**************************************************************************
**
** Name : MN_M_COMPARE( MemMenuCopy )
**
** Function :  MEMORY menu Compare menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_COMPARE(MFORMPTR  MemMenuCopy )
{
   MCOMPARE *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &mcompare;
   DlgFmPtr = dl_fmget("MCompare",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"COM ");
      strcat(DlgBuf,datap->compbeg);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->compend);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->compdest);
      strcat(DlgBuf,"\r");
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_COMPARE()  */

/**************************************************************************
**
** Name : MN_M_COPY( MemMenuCopy )
**
** Function :  MEMORY menu Copy menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_COPY(MFORMPTR   MemMenuCopy )
{
   MCOPY *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &mcopy;
   DlgFmPtr = dl_fmget("MCopy",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"C ");
      strcat(DlgBuf,datap->copybeg);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->copyend);
      if (datap->copydest[0] != '\0')  {
         strcat(DlgBuf," ");
         strcat(DlgBuf,datap->copydest);
      }
      strcat(DlgBuf,"\r");
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_COPY()  */

/**************************************************************************
**
** Name :
**
** Function :  MEMORY menu Disassembly menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_DISASSEMBLY(MFORMPTR  MemMenuCopy )
{
   MDISASSEMBLY *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &mdisassembly;
   DlgFmPtr = dl_fmget("MDisassembly",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"D");
      if (datap->disasmbeg[0] != '\0') {
         strcat(DlgBuf," ");
         strcat(DlgBuf,datap->disasmbeg);
         if (datap->disasmend[0] != '\0') {
            strcat(DlgBuf," ");
            strcat(DlgBuf,datap->disasmend);
         }
      }
      strcat(DlgBuf,"\r");
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_DISASSEMBLY()  */

/**************************************************************************
**
** Name :
**
** Function :  MEMORY menu Dump menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_DUMP( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
   MDUMP *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &mdump;
   DlgFmPtr = dl_fmget("MDump",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"M ");
      if (datap->dumpbeg[0] != '\0') {
         strcat(DlgBuf,datap->dumpbeg);
         if (datap->dumpend[0] != '\0') {
            strcat(DlgBuf," ");
            strcat(DlgBuf,datap->dumpend);
         }
      }
      strcat(DlgBuf,"\r");
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_DUMP()  */

/**************************************************************************
**
** Name :
**
** Function :  MEMORY menu Fill menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_FILL( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
   MFILL *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &mfill;
   DlgFmPtr = dl_fmget("MFill",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"F ");
      strcat(DlgBuf,datap->fillbeg);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->fillend);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->data);
      strcat(DlgBuf,"\r");
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_FILL()  */

/**************************************************************************
**
** Name :
**
** Function :  MEMORY menu Search menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_SEARCH( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
   MSEARCH *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &msearch;
   DlgFmPtr = dl_fmget("MSearch",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"SE ");
      strcat(DlgBuf,datap->searchbeg);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->searchend);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->data);
      strcat(DlgBuf,"\r");
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_SEARCH()  */

/**************************************************************************
**
** Name :
**
** Function :   MEMORY menu Test menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_TEST( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
   MTEST *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &mtest;
   DlgFmPtr = dl_fmget("MTest",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      strcat(DlgBuf,"TE ");
      strcat(DlgBuf,datap->testbeg);
      strcat(DlgBuf," ");
      strcat(DlgBuf,datap->testend);
      strcat(DlgBuf,"\r");
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_TEST()  */

/**************************************************************************
**
** Name :
**
** Function : MEMORY menu MONITOR menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_M_MONITOR( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
   MMONITOR *datap;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;
   MEMOPTR memoptr;
   int i;
   char tt[10];
   KEYFP tmpF2;

   VV_ERR = 0;
   datap = &mmonitor;
// if (datap->operation == FALSE)
      datap->variable[0] = '\0';
   DlgFmPtr = dl_fmget("MMonitor",datap,usd3dlg,CListMFilePtr,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   if (MonVarCount > 0) {
      tmpF2 = kt_rplkey(KEY_F2,(KEYFP) ShowMonData,TTMEMOKTP);
      memoptr = (MEMOPTR) i_namptr("variable", DlgFmPtr );
      sf_msg(chListMsg+1, memoptr);
   }
   fldptr = (DFIELDPTR) i_namptr("element",DlgFmPtr);
   sf_msg(FormMsg+1,fldptr);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(TFormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
   if (MonVarCount > 0) kt_rplkey(KEY_F2,tmpF2,TTMEMOKTP);

   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      if (strstr(datap->operation,"ALL") != NULL)
         strcat(DlgBuf,"NOM\r");
      else if (strstr(datap->operation,"SET") != NULL) {
         strcat(DlgBuf,"MON ");
         strcat(DlgBuf,datap->variable);
         strcat(DlgBuf," ");
         strcat(DlgBuf,datap->element);
         strcat(DlgBuf," ");
         strcat(DlgBuf,datap->type);
         strcat(DlgBuf,"\r");
      } else if (strstr(datap->operation,"CLEAR") != NULL) {
         for (i = MonVarCount - 1; i >= 0; i--) {
            if (selection[i]) {
               sprintf(tt,"NOM %X\r",i+1);
               strcat(DlgBuf,tt);
            }
         }
      }
   }
   memset(selection,NULL,sizeof(selection));
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}   /* end of MN_M_MONITOR() */


/**************************************************************************
**
** Name : ShowMonData( dfmptr )
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ShowMonData(DFORMPTR dfmptr)
{
   KEYFP tmpEnter,tmpESC, tmpSPACE;
   CLISTPTR clistp;
   WINDOWPTR msgwnp;
   MEMOPTR memoptr;
   DFIELDPTR fldptr;
   int width, i;
   MFILEPTR tmpMFile;
   UCHAR *rowbuf, format[15], tt[6];

   fldptr = (DFIELDPTR) i_namptr("operation", dfmptr );
   fld_get(fldptr->datap,i_namnum("operation", dfmptr ), dfmptr );
   if (strstr(fldptr->datap,"SET") != NULL) return (TRUE);
   else if (strstr(fldptr->datap,"ALL") != NULL) return (TRUE);
   else if (strcmp(fldptr->datap,"") == 0) return (TRUE);
   if (MonVarCount == 0) return (TRUE);

   memoptr = (MEMOPTR) i_namptr("variable", dfmptr );
   if (memoptr->datap[0] != '\0')  {
      memoptr->datap[0] = '\0';
      memo_upd(memoptr->datap,i_namnum("variable", dfmptr ), dfmptr );
   }
   selcnt = 0;
   memset(selection, NULL, sizeof(selection));
   for (width = 0, i = 0; i < MonVarCount; i++)
      if (strlen(MonVar[i].Sym) > width) width = strlen(MonVar[i].Sym);
   if (width < 9) width = 9;   /* "XX. XXXX:XXXX XX BYTE" */
   sprintf(format," %%2X. %%-%ds ", width);
   width += 15;
   tmpMFile = mf_def(MonVarCount + 1, width);
   if (tmpMFile == NULLP) {
      ErrorProc();
      return (EXITMENU);
   }

   if ( (rowbuf=(char *) malloc(width + 1)) == NULL ) {
      ErrorProc();
      mf_free(tmpMFile);
      return (EXITMENU);
   }
   for (i = 0; i < MonVarCount; i++) {
      sprintf(rowbuf,format, i + 1,
         MonVar[i].Sym[0] == '\0' ? MonVar[i].Addr : MonVar[i].Sym);
      if (MonVar[i].Count != 1) sprintf(tt,"%2X ", MonVar[i].Count);
      else strcpy(tt,"   ");
      strcat(rowbuf, tt);
      if (MonVar[i].Type == 0) {
         if      (MonVar[i].Format == 0) strcat(rowbuf,"BYTE");
         else if (MonVar[i].Format == 1) strcat(rowbuf,"WORD");
         else if (MonVar[i].Format == 2) strcat(rowbuf,"LONG");
      }
      mf_rowins(rowbuf, APPEND_ROW, tmpMFile);
   }  // end for: to insert row to mem file

   i = (MonVarCount > 10) ? 10 : MonVarCount;
   memoptr = (MEMOPTR) i_namptr("variable", dfmptr );
   clistp = cl_def(memoptr->wnp->rb + 1, memoptr->wnp->cb-8, i+2,
                   width + 4, BDR_SLNP, NULLP, tmpMFile);
   if (clistp == NULLP) {
      ErrorProc();
      mf_free(tmpMFile);
      free(rowbuf);
      return (EXITMENU);
   }
   scl_opt(CLWRAP, ON, clistp);
   scl_attinact( LFLDACTOFF, clistp);
   scl_attact( LFLDACTON, clistp);
   sw_bdratt( LFLDACTOFF, clistp->wnp);
   scl_help("*MonitorVariable", clistp);
   if (MonVarCount > 10) sw_sb(AUTOUPD, VSBAR, clistp->wnp);
   tmpEnter = kt_rplkey(KEY_ENTER, (KEYFP) MarkIt, CLKTP);
   tmpSPACE = kt_rplkey(KEY_SPACE, (KEYFP) MarkIt, CLKTP);
   tmpESC = kt_rplkey(KEY_ESC, k_quit, CLKTP);

   msgwnp = wn_def(vs_rowq()-1, 0, 1, vs_colq(), LMESSAGE, BDR_NULLP);
   wn_up(msgwnp);
   v_st("<F1> for help, <ESC> to quit, <Space Bar> to select/unselect, <F10> to exit",msgwnp);
   cl_up(clistp);
   while ( (retcode=cl_rd(cl_curnum(clistp),clistp)) != AC_EXIT &&
            retcode != AC_QUIT )  ;
   cl_dn(clistp);
   cl_free(clistp);
   mf_free(tmpMFile);
   wn_dn(msgwnp);
   wn_free(msgwnp);
   kt_rplkey(KEY_ENTER, tmpEnter, CLKTP);
   kt_rplkey(KEY_SPACE, tmpSPACE, CLKTP);
   kt_rplkey(KEY_ESC, tmpESC, CLKTP);

   if (retcode == AC_EXIT && selcnt > 0) {
      strcpy(memoptr->datap,"<< selected >>");
      memo_upd(memoptr->datap, i_namnum("variable", dfmptr ), dfmptr );
   }
   else {
      selcnt = 0;
      memset(selection, NULL, sizeof(selection));
   }
   return(TRUE);
}         /* end of ShowMonData(dfmptr) */

/**************************************************************************
**
** Name : MarkIt(keyptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MarkIt(keyptr)
KEYCTRLPTR  keyptr;
{
   CLISTPTR clistp;
   UCHAR rowbuf[100];
   int i;

   clistp = (CLISTPTR) keyptr;
   i = cl_curnum(clistp);
   cl_curtxt(rowbuf,clistp);
   if ((rowbuf[0] == 0x20) && !selection[i]) {
      rowbuf[0] = 251;
      selection[i] = 1;
      selcnt++;
   } else if ((rowbuf[0] == 251) && selection[i]) {
      rowbuf[0] = 0x20;
      selection[i]--;
      selcnt--;
   }
   cli_rpl(rowbuf,cl_curnum(clistp),clistp);
   cl_upd(clistp);
   kv_dn(keyptr);
   return(1);
}         /* end of MarkIt(keyptr) */

/**************************************************************************
**
** Name : MonitorOpEnd(dfmptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MonitorOpEnd(dfmptr)
DFORMPTR dfmptr;
{
   DFIELDPTR fldptr;
   MEMOPTR memoptr;

   fldptr = (DFIELDPTR) i_namptr("operation", dfmptr );
   fld_get(fldptr->datap,i_namnum("operation", dfmptr ), dfmptr );
   if (strstr(fldptr->datap,"CLEAR") != NULL) {
      memoptr = (MEMOPTR) i_namptr("variable",dfmptr);
      memoptr->datap[0] = '\0';
      memo_upd(memoptr->datap,i_namnum("variable",dfmptr),dfmptr);
      if (strstr(fldptr->datap,"ALL") != NULL)
         sf_opt(SKIP,ON,memoptr);
      else    sf_opt(SKIP,OFF,memoptr);
      fldptr = (DFIELDPTR) i_namptr("element",dfmptr);
      fld_upd(fldptr->datap,i_namnum("element",dfmptr),dfmptr);
      sf_opt(SKIP,ON,fldptr);
      fldptr = (DFIELDPTR) i_namptr("type",dfmptr);
      fld_upd(fldptr->datap,i_namnum("type",dfmptr),dfmptr);
      sf_opt(SKIP,ON,fldptr);
   } else if (strstr(fldptr->datap,"SET") != NULL) {
      memoptr = (MEMOPTR) i_namptr("variable",dfmptr);
      memoptr->datap[0] = NULL;
      memo_upd(memoptr->datap,i_namnum("variable",dfmptr),dfmptr);
      sf_opt(SKIP,OFF,memoptr);
      fldptr = (DFIELDPTR) i_namptr("element",dfmptr);
      strcpy(fldptr->datap,"");
      fld_upd(fldptr->datap,i_namnum("element",dfmptr),dfmptr);
      sf_opt(SKIP,OFF,fldptr);
      fldptr = (DFIELDPTR) i_namptr("type",dfmptr);
      strcpy(fldptr->datap,"");
      fld_upd(fldptr->datap,i_namnum("type",dfmptr),dfmptr);
      sf_opt(SKIP,OFF,fldptr);
   }
   return(TRUE);
}         /* end of MonitorOpEnd(dfmptr) */

/**************************************************************************
**
** Name : MonitorVarBegin(dfmptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MonitorVarBegin(dfmptr)
DFORMPTR dfmptr;
{
   DFIELDPTR fldptr;

   fldptr = (DFIELDPTR) i_namptr("operation",dfmptr);
   fld_get(fldptr->datap,i_namnum("operation",dfmptr),dfmptr);
   if ((strstr(fldptr->datap,"CLEAR") != NULL) &&
       (strstr(fldptr->datap,"ALL")   == NULL))
      ShowMonData((DFORMPTR) dfmptr);
   return(TRUE);
}         /* end of MonitorVarBegin(dfmptr) */

/**************************************************************************
**
** Name : MN_E_ISTEP( emuMenuCopy )
**
** Function :  EMULATION menu Istep menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_E_ISTEP( emuMenuCopy )
MFORMPTR  emuMenuCopy;
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"S\r");
   return( EXITMENU );

}  /*  of MN_E_ISTEP()  */

/**************************************************************************
**
** Name : MN_E_ISTEP_OVER( emuMenuCopy )
**
** Function :  EMULATION menu Istep Over menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_E_ISTEP_OVER( emuMenuCopy )
MFORMPTR  emuMenuCopy;
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"S O\r");
   return( EXITMENU );

}  /*  of MN_E_ISTEP_OVER()  */

/**************************************************************************
**
** Name : MN_E_ISTEP_FOREVER( emuMenuCopy )
**
** Function :  EMULATION menu Istep Forever menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_E_ISTEP_FOREVER( emuMenuCopy )
MFORMPTR  emuMenuCopy;
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"S FO\r");
   return( EXITMENU );

}  /*  of MN_E_ISTEP_FOREVER()  */

/**************************************************************************
**
** Name : MN_E_ISTEP_OVER_FOREVER( emuMenuCopy )
**
** Function :  EMULATION menu Istep Over Forever menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_E_ISTEP_OVER_FOREVER( emuMenuCopy )
MFORMPTR  emuMenuCopy;
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"S O FO\r");
   return( EXITMENU );

}  /*  of MN_E_ISTEP_OVER_FOREVER()  */

/**************************************************************************
**
** Name :
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int CreateDirMemFile( char *fileType, MFILEPTR *memFile, int *fileCnt)
{
  struct find_t fileInfo;
  int handle, done;
  char buf[20];
  MFILEPTR dirMf;

// Create a file for filenames to be written in

   *fileCnt = 0;
   if ((handle=open("CURDIR.TMP",O_RDWR | O_TEXT | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE)) == -1)
        return 0;
   write(handle,"*DirChoiceList\n", 15 );
   done = _dos_findfirst(fileType, _A_NORMAL, &fileInfo);
   while ( !done && strstr(fileInfo.name,"CURDIR.TMP")==NULL ) {
      ++(*fileCnt);
      sprintf(buf, "%s\n", fileInfo.name);
      write(handle, buf, strlen(buf) );
      done = _dos_findnext(&fileInfo);
   }
   close(handle);

// Define a DIR choice list and attach it to the field

   dirMf = mf_def( *fileCnt + 1, 15 );
   mf_rd("CURDIR.TMP", dirMf);
   mf_sort( "*DirChoiceList", dirMf );
   *memFile = dirMf;
   return 1;
}  //  of CreateDirMemFile()

/**************************************************************************
**
** Name : F2Control(dfmptr)
**
** Function: This key function is invoked by all data form modules which
**           have "Filename" field.  It's for allowing  mouse left button
**           ( here is F2) pressed.
**
**    Input  : key pointer
**
**    Output : none
**
** Notes:
**
**************************************************************************/

F2Control( DFORMPTR  dfmptr )
{
 kd_nextitem( dfmptr );
}

/**************************************************************************
**
** Name : FilenameEnd()
**
**
** Function : This user function is defined in SD186.lib for Filename field.
**            It will be invoked when the input of Filename field ends.
**            If the input has wildcard words, this function will create
**            a popup window to display the file list for selection.
**
**    Input  : data form pointer
**
**    Output : none
**
** Notes:
**
**************************************************************************/
FilenameEnd(DFORMPTR dfmptr)
{
 DFIELDPTR fldptr, pp;
 int curItem, state, i, retcode, fileCnt, rowCnt, len, col;
 char temp[80], *ptr;
 CLISTPTR clistp;
 KEYFP keyESC;
 MFILEPTR dirMemFile;
 WINDOWPTR errWnp, msgWnp;

   curItem = curitemnum(dfmptr);
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr  );
   fld_get(fldptr->datap,curItem, dfmptr );
   if (_ki_last == KEY_ESC ) state = AC_QUIT;
   else
      if ((strstr(fldptr->datap, "*") != NULL) ||
          (strstr(fldptr->datap, "?") != NULL)) {
         CreateDirMemFile( fldptr->datap, &dirMemFile, &fileCnt );
         if (!fileCnt) {
            errWnp = dfmptr->err_wnp;
            v_st("\n File not found ! ",errWnp);
            beep_vv( BPLONG  , BPMIDDLE);
            sfm_nextitem( AC_NEXTITEM, dfmptr );
            return(TRUE);
         }
         rowCnt = (fileCnt < 9) ? fileCnt : 9;
         len = strlen(fldptr->datap);
         col    = ((len+6) < 18 ) ? 18 : len + 6;
         clistp = cl_def(11, 30, rowCnt+2, col , BDR_DLNP, "*DirChoiceList", dirMemFile );
         if (clistp == NULLP) {
            ErrorProc();
            return(EXITMENU);
         }
         scl_attact( LFLDACTON,  clistp );
         scl_attinact( LFLDACTOFF, clistp );
         scl_help( "*Clist", clistp );
         sw_bdratt( LFLDACTOFF, clistp->wnp );
         sprintf(temp, " %s ", fldptr->datap );
         sw_title( temp, LFLDACTOFF, TOPLEFT, clistp->wnp);
         sw_sb(AUTOUPD,VSBAR, clistp->wnp);
         ptr = strrchr( fldptr->datap, '\\');
         keyESC = kt_rplkey(KEY_ESC, k_quit, CLKTP);
         msgWnp = wn_def(vs_rowq()-1, 0, 1, vs_colq(), LMESSAGE, BDR_NULLP);
         wn_up( msgWnp );
         v_stpl( 0, 1, "<F1> for help, Cursor keys to move, <ESC> to quit, <CR> to select", msgWnp );
         retcode = cl_proc( 0, clistp );
         wn_dn( msgWnp );
         wn_free( msgWnp );
         if (ptr) StrmnCopy(temp, fldptr->datap, 0, (int)(1+ptr-(fldptr->datap)));
         else
           if ((ptr = strrchr( fldptr->datap, ':')) != NULL )
              StrmnCopy(temp, fldptr->datap, 0, (int)(1+ptr-(fldptr->datap)));
         if (retcode == AC_EXIT) {
            cl_curtxt( fldptr->datap, clistp );
            if (ptr) {
               strcat( temp, fldptr->datap );
               strcpy( fldptr->datap, temp );
            }
            fld_upd( fldptr->datap, curItem,  dfmptr  );
            state = AC_NEXTITEM;
         }
         else state = AC_SAMEITEM;
         cl_free( clistp );
         mf_free(dirMemFile);
         unlink( "CURDIR.TMP" );
         kt_rplkey(KEY_ESC, keyESC, CLKTP);
      }
      else state = AC_NEXTITEM;
   sfm_nextitem( state, dfmptr );
   return(TRUE);
} // of FilenameEnd()
/**************************** End of File **********************************/
