/***************************************************************************
**
** File name : menu2.c
**
** Description:  This file includes the routines for TRACE pulldown menu
**               processings.
**
**    Copyright (C) 1992, 1993  Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include <stdlib.h>
#include  "menu.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "dialog.h"
#include  "dlgext.h"
#include  "funcdecl.h"
#include  "funcext.h"
#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif
#include  "sdabiext.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define PULLDOWN        1
#define DIALOG          2



/**************************************************************************
**
** Externals
**
**************************************************************************/

extern UCHAR selection[DATBUFROW];
extern int selcnt;
extern int pulldown_or_dialog;
extern FUNCLIS usd3dlg[];
extern char FormMsg[]       ;
extern char TFormMsg[]      ;
extern char BoolFldMsg[]    ;
extern char chListMsg[];
extern int retcode;
extern char *statusPtr[];
extern int MICE;
/**************************************************************************
**
** Local variables
**
***************************************************************************/
MFILEPTR tmpMFile;

ShowBreakpointData( DFORMPTR fmptr );
EventStatusKeyLeft( DFORMPTR  fmptr );
EventKeyRight( DFORMPTR  fmptr );
// TriggerToggle( KEYCTRLPTR keyptr );
TriggerF2( DFORMPTR  fmptr );
char *SepLineFromLongString();

static UCHAR *boolOp[] = { "\0\30", "\1\31" } ;
static int breakptCnt=0;

int LAM2SeqEventBegin( void );
char eventClist[12];        // store event choice list item

int LAM2ActThenEnd( void );


/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : ShowStatus(dfmptr)
**
** Function: Shows the status choice list and waits for user's input.
**           Status may be multiple choices. After the selection,
**           update "status" field.
**
**    Input  : dfmptr (data form pointer )
**
**    Output : memoptr->datap
**
** Notes:
**
**************************************************************************/
ShowStatus( DFORMPTR dfmptr )
{
   KEYFP tmpSPACE,tmpESC, tmpENTER;
   CLISTPTR clistp;
   WINDOWPTR msgwnp;
   MEMOPTR memoptr;
   int i,j, curItem, xx;
   UCHAR rowBuf[40];
   U32 stat=0;

   curItem = curitemnum( dfmptr );
   memoptr = (MEMOPTR) i_numptr( curItem , dfmptr );
   memo_get( memoptr->datap, curItem, dfmptr );
   if ((xx = memoptr->wnp->rb+1) > 13) xx = 13;
   clistp = cl_def(xx ,memoptr->wnp->cb-15,9,35,BDR_SLNP,"*Status",CListMFilePtr);
   if (clistp == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   scl_attinact( LFLDACTOFF, clistp);
   scl_attact( LFLDACTON, clistp);
   sw_bdratt( LFLDACTOFF, clistp->wnp);
   scl_help("*StatusClist",clistp);
   tmpSPACE = kt_rplkey(KEY_SPACE,(KEYFP) MarkIt,CLKTP);
   tmpENTER = kt_rplkey(KEY_ENTER,(KEYFP) MarkIt,CLKTP);
   tmpESC = kt_rplkey(KEY_ESC,k_quit,CLKTP);

// get settings and rewrite the memory file section for the choice list
   memset(selection,NULL,sizeof(selection));
   selcnt=0;
   mf_kwdset( "*Status", CListMFilePtr );
   for (i=0; i < 7; i++ ) {
      mf_rowget( rowBuf, i, CListMFilePtr );
      if (strstr(memoptr->datap, statusPtr[i])) {
         rowBuf[0] = 251;
         selection[i] = 1;
         ++selcnt;
      }
      else rowBuf[0] = 0x20;
      mf_rowrpl( rowBuf, i, CListMFilePtr );
   }

// process window
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st("<F1> for help, <ESC> to quit, <Space Bar> to select/unselect, <F10> to exit",msgwnp);
   cl_up(clistp);
   while (((retcode=cl_rd(cl_curnum(clistp),clistp)) != AC_EXIT) && (retcode != AC_QUIT)) ;
   cl_dn(clistp);
   cl_free(clistp);
   wn_dn(msgwnp);
   wn_free(msgwnp);
   kt_rplkey(KEY_SPACE,tmpSPACE,CLKTP);
   kt_rplkey(KEY_ENTER,tmpENTER,CLKTP);
   kt_rplkey(KEY_ESC,tmpESC,CLKTP);

   if (retcode == AC_EXIT) {
      if (selcnt > 0) {
         for (i=0; i<7; i++) { if (selection[i]) stat |= _rotl( 1, i ); }
         GetStatus( memoptr->datap, stat );
      }
      else memoptr->datap[0] = NULL ;
   }
   else {
      memoptr->datap[0] = NULL ;
      memset(selection,NULL,sizeof(selection));
      selcnt = 0;
   }
   memo_upd(memoptr->datap,curitemnum( dfmptr ), dfmptr );
   return(TRUE);
}

/**************************************************************************
**
** Name : Hex2String()
**
** Function : Converts a hexadecimal value to string, and ingores all zero's
**            preceding to the first non-zero digit( if the value is not zero).
**
**    Input  : hexNo
**    Output : string
**
** Notes: . eg. 000012FC  ->   "12FC"
**        . Coded and maintained by C. Joyce Lin
**
**************************************************************************/
char *Hex2String(char *str, U32 hexNo)
{
   char *hhex = "0123456789ABCDEF";
   int i=0, k=0;
   U8 pos;

   if (!hexNo) i = 7;
   else while( !((hexNo >> (4*(7-i))) & 0x0f ) && ( i< 8)) i++;
   for (; i < 8 ; i++ ) {
      pos = (U8) (hexNo >> (4*(7-i))) & 0x0f;
      str[k++] = *(hhex+ pos);
   }
   str[k] = '\0';
   return(str);
}

/**************************************************************************
**
** Name : Long2String()
**
** Function: Convert a signed long value to a string.
**
**    Input : s32( signed long )
**    Output: string
**
** Notes: Coded and maintained by C. Joyce Lin
**
**************************************************************************/
char *Long2String(char *str, long s32 )
{
   char temp[10];
   int i=0, k=0;
   U8 pos;

   *str = '\0';
   if (s32 < 0 ) {
      strcpy(str, "-");
      s32 *= (-1);
   }
   Hex2String( temp, (U32) s32 );
   if (*temp) strcat(str, temp);
   return(str);
}
/**************************************************************************
**
** Name : MN_T_SW( TraMenuCopy )
**
** Function :  Processes S/W Breakpoint menu-item in TRACE menu.
**
**    Input  : TraMenuCopy
**    Output : ExecDlgFlag, DlgBuf.
**
** Notes: Maintained by C. Joyce Lin
**
**************************************************************************/
MN_T_SW(MFORMPTR TraMenuCopy )
{
   TSW *datap;
   int i,j,k, selected=0;
   DFIELDPTR fldptr;
   WINDOWPTR msgwnp;
   MEMOPTR memoPtr;
   KEYFP tmpF2;
   char tt[10], tbuf[100];

   VV_ERR = 0;
   breakptCnt = 0;
   datap = &tsw;
   datap->address[0] = '\0';
   DlgFmPtr = dl_fmget("TSw",datap,usd3dlg,CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
   fldptr = (DFIELDPTR) i_namptr("action",DlgFmPtr);
   sf_msg(TFormMsg+1,fldptr);
   if (SwBreak[0].exists) {
      memoPtr = (MEMOPTR) i_namptr("address",DlgFmPtr);
      sf_msg( chListMsg+1,memoPtr);
      tmpF2 = kt_rplkey(KEY_F2,(KEYFP) ShowBreakpointData,TTMEMOKTP);
   }
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE ,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
   if (SwBreak[0].exists) kt_rplkey(KEY_F2,tmpF2,TTMEMOKTP);
   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      if (strstr(datap->action,"ALL") != NULL) strcpy(DlgBuf,"CL\r");
      else
         if (strstr(datap->action,"SET") != NULL) {
            strcpy(DlgBuf,"BR ");
            strcat(DlgBuf,datap->address);
            strcat(DlgBuf," ");
            strcat(DlgBuf,datap->count);
            strcat(DlgBuf,"\r");
         }
         else
            if (strstr(datap->action,"CLEAR") != NULL) {
               for (i = breakptCnt - 1; i >= 0; i--) {
                  if (selection[i]) {
                     sprintf(tt,"CL %X\r",i+1);
                     strcat(DlgBuf,tt);
                     selected = 1;
                  }
               }
               if (!selected) {
                  if (*(datap->address) == '%') {
                     strcpy(comsym.name, 1+(datap->address));
                     if ( SymToAddr() == FOUND )
                         addr2str( comsym.addr, datap->address);
                  }
                  i = CheckIsBKPT(datap->address);
                  if (i >= 0) {
                     strcat(DlgBuf,"CL ");
                     itoa(i+1,tbuf,10);
                     strcat(DlgBuf,tbuf);
                     strcat(DlgBuf,"\r");
                  }
               }
            }
            else ExecDlgFlag = 0;
   }
   memset(selection,NULL,sizeof(selection));
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_SW()  */

/**************************************************************************
**
** Name : BreakpntOpEnd(DFORMPTR dfmptr)
**
** Function: Initializes address and count fields, and sets fields options:
**           if "action" input is "CLEAR", skip "count" field;
**           if "action" input is "CLEAR ALL", skip "address", "count" fields;
**
**    Input  : data form pointer
**    Output : none
**
** Notes: Coded and maintained by C. Joyce Lin
**
**************************************************************************/
BreakpntOpEnd(DFORMPTR dfmptr)
{
 DFIELDPTR fldptr, pp;
 int curItem;
 MEMOPTR memoptr;

   memoptr = (MEMOPTR) i_namptr("address",dfmptr);
   memoptr->datap[0] = NULL;
   memo_upd( memoptr->datap, i_namnum("address",dfmptr), dfmptr);
   pp = (DFIELDPTR) i_namptr( "count", dfmptr);
   strcpy( pp->datap, "" );
   fld_upd( pp->datap, i_namnum("count",dfmptr), dfmptr);
   fldptr = (DFIELDPTR) i_namptr( "action", dfmptr );
   fld_get( fldptr->datap, i_namnum("action",dfmptr), dfmptr  );
   if (strstr(fldptr->datap,"CLEAR") != NULL) {
      sf_opt(SKIP, ON, pp);
      if (strstr( fldptr->datap,"ALL") != NULL) sf_opt(SKIP, ON, memoptr);
      else  {
         sf_opt(SKIP, OFF, memoptr);
         ShowBreakpointData( dfmptr );
      }
   }
   else
      if (strstr(fldptr->datap, "SET") != NULL) {
         sf_opt(SKIP, OFF, memoptr);
         sf_opt(SKIP, OFF, pp);
      }
   return(TRUE);
}         /* end of BreakpntOpEnd(dfmptr) */

/**************************************************************************
**
** Name : ShowBreakpointData( dfmptr )
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
ShowBreakpointData( DFORMPTR dfmptr )
{
   KEYFP tmpSPACE,tmpESC, tmpENTER;
   CLISTPTR clistp;
   WINDOWPTR msgwnp;
   MEMOPTR memoptr;
   DFIELDPTR fldptr;
   int i,j,k, width, tmpWidth;
   MFILEPTR tmpMFile;
   char tbuf[100], buf[50];
   UCHAR adr1[10];

   fldptr = (DFIELDPTR) i_namptr("action", dfmptr);
   fld_get(fldptr->datap,i_namnum("action", dfmptr), dfmptr);
   if (strstr(fldptr->datap,"SET") != NULL) return (TRUE);
   else
      if (strstr(fldptr->datap,"ALL") != NULL) return (TRUE);
      else if (strcmp(fldptr->datap,"") == 0) return (TRUE);

   if ( !SwBreak[0].exists ) {
        return (TRUE);
    }

   memoptr = (MEMOPTR) i_namptr("address", dfmptr);
   memoptr->datap[0] = NULL;
   memo_upd(memoptr->datap,i_namnum("address", dfmptr ), dfmptr  );
   memset(selection, NULL, sizeof(selection));
   breakptCnt= selcnt = 0;
   width = 10;
   while (SwBreak[breakptCnt].exists) {
      if (( tmpWidth = strlen(SwBreak[ breakptCnt ].sym )) > width )
         width = tmpWidth;
      breakptCnt++;
   }
   tmpMFile = mf_def( breakptCnt+1, width+7 );
   if ( breakptCnt > 0) {
     for (i=0; i< breakptCnt; i++) {
        if (SwBreak[i].sym[0]) strcpy(buf,SwBreak[i].sym);
        else {
           for (j=env.Maddrunit-1,k=0; j>=0; j--,k+=8)
                adr1[j]=(SwBreak[i].address >> k) & 0xff;
           adr_ascii(adr1,env.Maddrunit,buf);
        }
        sprintf(tbuf," %2X. %s", 1+i, buf);
        mf_rowins(tbuf,APPEND_ROW,tmpMFile);
     }
     i = (breakptCnt > 10) ? 10 : breakptCnt;
     clistp = cl_def(memoptr->wnp->rb + 1, memoptr->wnp->cb-8, i+2,
                     width+11, BDR_SLNP, NULLP, tmpMFile);
     if (clistp == NULLP) {
        ErrorProc();
        mf_free(tmpMFile);
        return (EXITMENU);
     }
     scl_opt(CLWRAP, ON, clistp);
     scl_attinact( LFLDACTOFF, clistp);
     scl_attact( LFLDACTON, clistp);
     sw_bdratt( LFLDACTOFF, clistp->wnp);
     scl_help("*BpAddr", clistp);
     if (breakptCnt > 10) sw_sb(AUTOUPD, VSBAR, clistp->wnp);
     tmpSPACE = kt_rplkey(KEY_SPACE,(KEYFP) MarkIt,CLKTP);
     tmpENTER = kt_rplkey(KEY_ENTER,(KEYFP) MarkIt,CLKTP);
     tmpESC = kt_rplkey(KEY_ESC,k_quit,CLKTP);
   }
   msgwnp = wn_def(vs_rowq()-1, 0, 1, vs_colq(), LMESSAGE, BDR_NULLP);
   wn_up(msgwnp);
   v_st("<F1> for help, <ESC> to quit, <Space Bar> to select/unselect, <F10> to exit",msgwnp);
   cl_up(clistp);
   while ((retcode=cl_rd(cl_curnum(clistp),clistp)) != AC_EXIT &&
           retcode != AC_QUIT )  ;
   cl_dn(clistp);
   cl_free(clistp);
   mf_free(tmpMFile);
   wn_dn(msgwnp);
   wn_free(msgwnp);
   kt_rplkey(KEY_SPACE,tmpSPACE,CLKTP);
   kt_rplkey(KEY_ENTER,tmpENTER,CLKTP);
   kt_rplkey(KEY_ESC,tmpESC,CLKTP);

   if (retcode == AC_EXIT && selcnt > 0) {
      strcpy(memoptr->datap,"<< selected >>");
      memo_upd(memoptr->datap, i_namnum("address", dfmptr ), dfmptr);
   }
   else {
      selcnt = 0;
      memset(selection, NULL, sizeof(selection));
   }
   return(TRUE);
}         /* end of ShowBreakpointData( dfmptr) */

/**************************************************************************
**
** Name : GetBusEventInfo
**
** Function : Gets Bus event settings( address, data, status) from global
**            structure event_record, and converts them to strings.
**
**    Input  : structure eventRecord.
**    Output : strings addr, datum, stat.
**
** Notes: Coded and maintained by C. Joyce Lin
**
**************************************************************************/
GetBusEventInfo( char *addr, char *datum, char *stat, char *count, BUS_EVENT eventRecord )
{
 int len;

/*
  len = (MICE == M68020 || MICE == M68030) ? 8 : 6;
  GetAddrDataValue( addr, eventRecord.addrSpec, eventRecord.addrLo,
                    eventRecord.addrHi, len);
  len = (MICE == M68020 || MICE == M68030) ? 8 : 4;
  GetAddrDataValue( datum, eventRecord.dataSpec, eventRecord.dataLo,
                    eventRecord.dataHi, len);
  GetStatus( stat, eventRecord.stat);
  GetCount( count, eventRecord.count );
*/

//  len = MICE < 5 ? 2 : 4;
// added by Chen, 08/25/94
    if ( (MICE >= I80C188XL && MICE <= I80C188EC) || MICE == I8088MAX ||
        MICE == I8088MIN || MICE == V20MAX || MICE == V20MIN ) {
        len = 2;
    }
    else {
        len = 4;
    }

  GetAddrDataValue( addr, eventRecord.addrSpec, eventRecord.addrLo,
                    eventRecord.addrHi, 5);
  GetAddrDataValue( datum, eventRecord.dataSpec, eventRecord.dataLo,
                    eventRecord.dataHi, len);
  GetStatus( stat, eventRecord.stat);
  GetCount( count, eventRecord.count );

}


/**************************************************************************
**
** Name : GetWildCard
**
** Function :  Converts wildcard value to string
**
**    Input  : wildcard value, mask, length
**    Output : string
**
** Notes: . Eg. if a wildcard is
**
**        . Coded and maintained by C. Joyce Lin
**
**************************************************************************/
char *GetWildCard( char *str, U32 mask, U32 wvalue, U8 len )
{
int i,j, k, l, oldMask, mmask, value;
char *hex = "0123456789ABCDEF";

   oldMask = 0;
   for (j=0, k=0; j < len; j++ ) {
      value = (wvalue >> 4*(len-1-j)) & 0x0f;
      mmask = (mask >> 4*(len-1-j)) & 0x0f;
      if (( mmask == 0x0f)  || (!mmask) ) {
         if (oldMask) str[k++] = ')';
         oldMask = 0;
         str[k++] = mmask ? hex[value] : 'X';
      }
      else {
         if (!oldMask) {
            str[k++] = '(';
            oldMask = 1;
         }
         for (l=3; l>=0; l-- )
            str[k++] = (mmask & _rotl(0x01, l))  ?
                       ((value & _rotl(0x01, l)) ? '1' : '0' ) : 'X';
      }
   }
   if (oldMask) str[k++] = ')';
   str[k] = '\0';
}

/**************************************************************************
**
** Name : GetCount()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
static GetCount( char *str, U16 count )
{
unsigned char temp;
int i;

    for ( i=12; i>=0; i-=4 ) {
        temp = (unsigned char) ( (count >> i) & 0x0f );
        if ( temp >= 0x00 && temp <= 0x09 ) {
            *str++ = temp - 0x00 + '0';
        }
        else if ( temp >= 0x0A && temp <= 0x0F ) {
            *str++ = temp - 0x0A + 'A';
        }
        *str = NULL;
    }

    return ( TRUE );
}

/**************************************************************************
**
** Name : GetStatus()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
static GetStatus( char *str, U32 status )
{
  int i;

  *str = '\0';
//  for (i=0; i < 9; i++)
// Chen, 07/18/94 ; no DMA status
  for (i=0; i < 7; i++)
     if (status & _rotl( 1, i )) {
        strcat(str , statusPtr[i] );
        strcat(str, " ");
     }
  return TRUE;
}

/**************************************************************************
**
** Name : MN_T_EVENT( TraMenuCopy )
**
** Function :   TRACE menu Event menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
MN_T_EVENT(MFORMPTR TraMenuCopy )
{
TEVENT *datap;
BUS_EVENTS *busEvents;
WINDOWPTR msgwnp;
DFIELDPTR fldptr;
MEMOPTR memoPtr;
int i,j, k, state;
char temp1[80];
KEYFP tmpF2, tmpRIGHT, tmpLEFT;
MEMOPTR memoptr;
int field;
int eventNumber;

   VV_ERR = 0;
   datap = &tevent;
   DlgFmPtr = dl_fmget("TEvent",datap,usd3dlg,CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
   busEvents = (BUS_EVENTS *)&tevent;

// Gets settings
   memset(datap,NULL,sizeof(tevent));
//   emuGetEvent(event_record,bp_record,&ext_record,&cntFlag,&timerRecord,counter);
   if ( LAM2 != 0 ) j = 4; else j = 2;
   for ( i=0; i < j; i++ ) {
      if (event_record[i].defined)
         GetBusEventInfo( busEvents->ev[i].address, busEvents->ev[i].datum,
                          busEvents->ev[i].status, busEvents->ev[i].count,
                          event_record[i] );
   }

// initialize fields status and messages
    if ( LAM2 != 0 ) {
        field = 20; // 4*5 = 20
    }
    else {
        field = 10;
    }

   for (i=1; i< field; i++) {
      state = (i % 5) ? ON : OFF;
      if ((i>2) && !((i-3)%5)) {
         memoptr = (MEMOPTR) i_numptr(i, DlgFmPtr);
         sf_msg( chListMsg+1, memoptr);
         sf_opt(SKIP, state, memoptr);
      }
      else  {
         fldptr  = (DFIELDPTR) i_numptr(i,DlgFmPtr);
         sf_opt(SKIP, state, fldptr);
         if ( (i>1) && !((i-2)%5) || (i>1) && !((i-4)%5) )
            sf_msg(FormMsg+1, fldptr);
      }
   }

// processes window
   tmpF2    = kt_rplkey(KEY_F2,    (KEYFP) ShowStatus,    TTMEMOKTP );
   tmpLEFT  = kt_rplkey(KEY_LEFT , (KEYFP) EventStatusKeyLeft, TTMEMOKTP );
   tmpRIGHT = kt_rplkey(KEY_RIGHT, (KEYFP) EventKeyRight, FMKTP );
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(TFormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
   kt_rplkey(KEY_F2,    (KEYFP) tmpF2,   TTMEMOKTP);
   kt_rplkey(KEY_LEFT , (KEYFP) tmpLEFT, TTMEMOKTP );
   kt_rplkey(KEY_RIGHT, (KEYFP) tmpRIGHT, FMKTP );

// set event number
    if ( LAM2 != 0 ) {
        eventNumber = 4;
    }
    else {
        eventNumber = 2;
    }


   if (retcode == AC_EXIT)  {
      for ( i=0; i < eventNumber; i++ ) {
         if (strstr(strupr(busEvents->ev[i].op),"CLEAR") != NULL) {
            sprintf(temp1, "EV%1d CL\r", 1+i );
            strcat(DlgBuf, temp1);
         }
         else
            if (strstr(strupr(busEvents->ev[i].op),"SET") != NULL) {
               sprintf(temp1, "EV%1d ", 1+i );
               strcat(DlgBuf, temp1);
               if (busEvents->ev[i].address[0]) {
                  strcat(DlgBuf,busEvents->ev[i].address);
                  strcat(DlgBuf," ");
               }
               if (busEvents->ev[i].datum[0]) {
                  strcat(DlgBuf,busEvents->ev[i].datum);
                  strcat(DlgBuf," ");
               }
               if (busEvents->ev[i].status[0]) {
                  strcat(DlgBuf,busEvents->ev[i].status);
                  strcat(DlgBuf," ");
               }
               if (busEvents->ev[i].count[0]) {
                  strcat(DlgBuf,"Count ");
                  strcat(DlgBuf,busEvents->ev[i].count);
                  strcat(DlgBuf," ");
               }
               strcat(DlgBuf,"\r");
            }
      }
      if (DlgBuf[0]) ExecDlgFlag = 1;
      return( EXITMENU );
   }
   if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_EVENT()  */

/**************************************************************************
**
** Name : EventOpEnd(dfmptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
EventOpEnd(DFORMPTR dfmptr)
{
 DFIELDPTR fldptr, pp;
 int curItem, state, i, color, retCode, k;
 MEMOPTR memoptr;
 WINDOWPTR mwnp;

 if (((k= _ki_last) == KEY_ENTER ) || (k == KEY_RIGHT) || (k == KEY_F2) ||
      (k == KEY_UP) || (k == KEY_DN)) {
    curItem = curitemnum(dfmptr);
    fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr );
    fld_get(fldptr->datap,curItem, dfmptr );
    state = (stricmp(fldptr->datap, "SET") == NULL) ? OFF : ON;
    color = (state == OFF) ? (fldptr->inact_att) : (fldptr->skip_att);
    for (i=1; i<3; i++) {
       pp = (DFIELDPTR) i_numptr( curItem+i, dfmptr );
       sf_opt(SKIP, state, pp);
       fld_updatt( color, curItem+i, dfmptr );
    }

    memoptr = (MEMOPTR) i_numptr( 3+curItem, dfmptr );
    mwnp = memoptr->wnp;
    retCode = v_chattrow( mwnp->rb-1, mwnp->cb-2, NULL, color, 18, ATT, dfmptr->wnp );
    sf_opt(SKIP, state, memoptr);

       pp = (DFIELDPTR) i_numptr( curItem+4, dfmptr );
       sf_opt(SKIP, state, pp);
       fld_updatt( color, curItem+4, dfmptr );


//  sfm_nextitem(AC_NEXTITEM, dfmptr );
 }

 return(TRUE);
}     /* end of EventOpEnd(dfmptr)  */

/**************************************************************************
**
** Name : AddressTypeEnd(dfmptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
AddressTypeEnd(DFORMPTR dfmptr)
{
 DFORMPTR dfmp;
 WINDOWPTR msgwnp;
 DFIELDPTR fldptr, addr1Ptr, addr2Ptr;
 int curItem, i;
 char addr1[25], addr2[25], temp[80];

   if (_ki_last == KEY_ESC )
      return( sfm_nextitem( AC_QUIT, dfmptr) );
   curItem = curitemnum(dfmptr);
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr);
   memset(addr1, NULL, sizeof(addr1));
   memset(addr2, NULL, sizeof(addr2));
   fld_get( fldptr->datap, curItem, dfmptr  );
   if (strstr(fldptr->datap, " ") != NULL) return( TRUE );
   if (strstr(strupr(fldptr->datap), "RANGE") != NULL) {
      dfmp  = fm_def( 9, 20, 7, 40, LFORMS, BDR_DLNP );
      sfm_opt(VERIFYQUIT, OFF, dfmp );
      sw_title(" Address Range ", LFORMS, TOPCENTER, dfmp->wnp );
      addr1Ptr = fld_def( 1, 3, "Start address: ", FADJACENT, "XXXXXXXXXX", F_STRING, addr1, dfmp );
      addr2Ptr = fld_def( 3, 3, "End address:   ", FADJACENT, "XXXXXXXXXX", F_STRING, addr2, dfmp );
      sf_help( "*EventRangeAddrStart", addr1Ptr );
      sf_help( "*EventRangeAddrEnd", addr2Ptr );
      sf_attact( LFLDACTON, addr1Ptr );
      sf_attact( LFLDACTON, addr2Ptr );
      sf_attinact( LFLDACTOFF, addr1Ptr );
      sf_attinact( LFLDACTOFF, addr2Ptr );
      msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
      wn_up(msgwnp);
      v_st(FormMsg,msgwnp);
      retcode = fm_proc(0, dfmp );
      wn_dn(msgwnp);
      wn_free(msgwnp);
      fm_free(dfmp);
      if ((retcode == AC_EXIT) && (addr1[0] || addr2[0] )) {
         sprintf(temp,"RAnge %s %s", addr1, addr2 );
         fld_upd( temp, curItem, dfmptr );
         sfm_nextitem( AC_NEXTITEM, dfmptr );

      }
      else {
         fld_blank( curItem, dfmptr );
         sfm_nextitem( AC_SAMEITEM, dfmptr );
      }
      return( TRUE );
   }
   else
      if ((strstr(strupr(fldptr->datap), "SINGLE") != NULL) ||
          (strstr(strupr(fldptr->datap), "WILDCARD") != NULL)) {
         dfmp  = fm_def( 9, 20, 5, 40, LFORMS, BDR_DLNP );
         sfm_opt(VERIFYQUIT, OFF, dfmp );
         addr1Ptr = fld_def( 1, 3, "Address: ", FADJACENT, "XXXXXXXXXXXXXXXXXXXXXX", F_STRING, addr1, dfmp );
         if (strstr(strupr(fldptr->datap), "SINGLE") != NULL) {
            sf_help( "*EventSingleAddress", addr1Ptr );
            sw_title(" Single address ", LFORMS, TOPCENTER, dfmp->wnp );
         }
         else {
            sf_help( "*EventWildcardAddress", addr1Ptr );
            sw_title(" Wildcard address ", LFORMS, TOPCENTER, dfmp->wnp );
         }
         sf_attact( LFLDACTON, addr1Ptr );
         sf_attinact( LFLDACTOFF, addr1Ptr );
         msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
         wn_up(msgwnp);
         v_st(FormMsg,msgwnp);
         retcode = fm_proc(0, dfmp );
         wn_dn(msgwnp);
         wn_free(msgwnp);
         fm_free(dfmp);
         if ((retcode == AC_EXIT) && addr1[0]) {
            fld_upd( addr1, curItem, dfmptr );
            sfm_nextitem( AC_NEXTITEM, dfmptr );
         }
         else {
            fld_blank( curItem, dfmptr );
            sfm_nextitem( AC_SAMEITEM, dfmptr );
         }
      }
  return( TRUE );
}     /* end of AddressTypeEnd(dfmptr)  */



/**************************************************************************
**
** Name : MN_T_TR1( TraMenuCopy ) to MN_T_TR4( TraMenuCopy )
**
** Function :  TRACE menu Trigger Level menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
MN_T_TR1(MFORMPTR  TraMenuCopy)
{
   MnTrigger(1);
}

MN_T_TR2(MFORMPTR  TraMenuCopy)
{
   MnTrigger(2);
}

MN_T_TR3(MFORMPTR  TraMenuCopy)
{
   MnTrigger(3);
}

MN_T_TR4(MFORMPTR  TraMenuCopy)
{
   MnTrigger(4);
}
*/

/**************************************************************************
**
** Name : MnTrigger (trNo )
**
** Function :  Processes Trigger level setting windows
**
**    Input  : trNo
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
MnTrigger(U8 trNo)
{
DFORMPTR dfmp;
TTRIGGER *datap;
TLEVEL *ttr;
WINDOWPTR msgwnp;
DFIELDPTR fldptr, pp, boolPtr;
char temp[80],c, actionBuf[256];
int i,j, k=0,p, state, curItem;
U8 evNo, ret, isSet = TRUE ;
KEYFP tmpSPACE, tmpLEFT, tmpRIGHT, tmpF2;
static U8 *evMsg = " <F1> Help, <SP> Show setting, <F10> Execute, <ESC> Quit, <CR> Next item";

// Form1 : Choose to SET or CLEAR trigger level #N

   VV_ERR = 0;
   DlgFmPtr  = fm_def( 10, 20, 5, 35, LFORMS, BDR_DLNP );
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   sfm_opt(VERIFYQUIT, OFF, DlgFmPtr );
   sf_help( "*TTriggerLevel", DlgFmPtr );
   sprintf(temp," TRIGGER LEVEL %1d ", trNo);
   sw_title(temp, LFORMS, TOPCENTER, DlgFmPtr->wnp );
   boolPtr = fld_def( 1, 3, "Operation : ", FADJACENT, "X", F_BOOL,
                     (PTR) &isSet, DlgFmPtr );
   sf_help( "*TTriggerLevel", boolPtr );
   sf_booltoggle( "Set", "Clear", LFLDACTOFF, LFLDACTOFF, boolPtr );
   sf_attact( LFLDACTON, boolPtr );
   sf_attinact( LFLDACTOFF, boolPtr );
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0, DlgFmPtr );
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
   if (retcode == AC_EXIT)  {
      if (isSet == FALSE)  {
         ExecDlgFlag = 1;
         sprintf(temp,"TR%1d CL\r", trNo);
         strcpy( DlgBuf, temp );
         return(EXITMENU);
      }
   }
   else return( SAMELEVEL );

// Form2 : SET trigger level
   VV_ERR = 0;
   datap = &ttrigger;
   sprintf(temp,"TTR%1d", trNo);
   DlgFmPtr = dl_fmget( temp, datap,usd3dlg,CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ttr = (TLEVEL *)&ttrigger;
   ShowShadow(DlgFmPtr->wnp);

// Sets field messages for choice lists
   for ( i = 0; i < 89; i++ ) {
      fldptr = (DFIELDPTR) i_numptr(i,DlgFmPtr);
      if ( !(j= i % 8) && (i < 72 ))  sf_msg(evMsg+1,fldptr);
      else if (((j > 2) && (j < 7)) || (i==88) )  sf_msg(TFormMsg+1,fldptr);
   }
   if (trNo < 2) {
      fldptr = (DFIELDPTR) i_namptr("mode",DlgFmPtr);
      sf_msg(TFormMsg+1,fldptr);
   }

// Gets settings

   memset(datap,NULL,sizeof(ttrigger));
   emuGetAllTrig(trig_record);
   for ( p = 1; p < 12; p++ ) {
      *temp = NULL;
      if (p < 10) sprintf(temp,"EV%1d", p);
      else
         if (cntFlag == 0x04 ) {
            if (p == 11) break;
            strcpy(temp,"TImer");
         }
         else sprintf(temp,"CNT%1d", p-10);
      strcpy( ttr->tEv[ p-1 ].evName, temp );
      ttr->tEv[ p-1 ].on = FALSE;
      if (trig_record[trNo-1].defined) {
         for ( i=0; i < 11; i++) {
            if (!(evNo = trig_record[trNo-1].evNo[i])) break;
            if (evNo != p ) continue;
            ttr->tEv[ p-1 ].on = TRUE;
            for (j=0; j <11; j++) {
               if (trig_record[trNo-1].act[i] & _rotl(0x01, j)) {
                  switch ( j ) {
                     case 0:  strcpy( ttr->tEv[p-1].act1, "BReak" ); break;
                     case 1:  strcpy( ttr->tEv[p-1].act1, "Reset" ); break;
                     case 2:  strcpy( ttr->tEv[p-1].act1, "Seq"   ); break;
                     case 3:  strcpy( ttr->tEv[p-1].act2, "Troff" ); break;
                     case 4:  strcpy( ttr->tEv[p-1].act2, "Next" );  break;
                     case 5:  strcpy( ttr->tEv[p-1].act3, "INC0" );  break;
                     case 6:  strcpy( ttr->tEv[p-1].act3, "RST0" );  break;
                     case 7:  strcpy( ttr->tEv[p-1].act4, "INC1" );  break;
                     case 8:  strcpy( ttr->tEv[p-1].act4, "RST1" );  break;
                     case 9:  ttr->tEv[p-1].extIn = TRUE;  break;
                     case 10: ttr->tEv[p-1].extOut = TRUE; break;
                     default : break;
                  }
               }
               else {
                  if (j == 9)  ttr->tEv[p-1].extIn = FALSE;
                  if (j == 10) ttr->tEv[p-1].extOut = FALSE;
               }
            }         // end of for ( j=0; j < 11; j++ )
            break;
         }            // end of  for ( i=0; i < 11; i++)
      }               // end of if (trig_record[trNo-1].defined)
   }                  // end of for ( p=1; p < 12; p++)

// Gets trace_mode. Note that Trace_mode is in the record of trigger 1 only
   if ( trig_record[0].defined ) {
      switch ( trig_record[0].mode ) {
         case 0 : strcpy( datap->mode , "BAckward" ); break;
         case 1 : strcpy( datap->mode , "Forward" );  break;
         case 2 : strcpy( datap->mode , "Center" ); break;
         default : break;
      }
   }
// Gets counter settings.
//   emuGetEvent(event_record,bp_record,&ext_record,&cntFlag,&timerRecord,counter);
// marked with Chen, 03/31/94
//   if (cntFlag & 0x01)  Hex2String( datap->cnt0, (U32) counter[0] );
//   if (cntFlag & 0x02)  Hex2String( datap->cnt1, (U32) counter[1] );

// initialize fields status
   for (i=0; i< 11; i++) {
      if ((i == 10 ) && (cntFlag == 0x04 )) {
         for (curItem = 80; curItem < 88; curItem++ ) {
            pp = (DFIELDPTR) i_numptr(curItem,DlgFmPtr);
            sf_opt(SKIP, ON, pp);
            sf_opt(INITIALBLANKS, ON, pp);
         }
      }
      else {
         curItem = 1 + 8 * i;
         state = (ttr->tEv[i].on == TRUE) ? OFF : ON;
         for (k=0; k<6; k++ ) {
            pp = (DFIELDPTR) i_numptr(++curItem,DlgFmPtr);
            if (((k > 2) || (k < 5)) && (cntFlag == 0x04)) sf_opt(SKIP, ON, pp);
            else sf_opt(SKIP, state, pp);
            if ((state == ON) && ((k==0) || (k==5)))
               sf_opt(INITIALBLANKS, state, pp);
         }
      }
   }
   pp = (DFIELDPTR) i_namptr("mode",DlgFmPtr);
   sf_opt(SKIP, (trNo < 2) ? OFF : ON, pp);

// Process window
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   tmpF2    = kt_rplkey(KEY_F2   , (KEYFP) TriggerF2, FMKTP );
   tmpSPACE = kt_rplkey(KEY_SPACE, (KEYFP) TriggerToggle, FMKTP );
   tmpLEFT  = kt_rplkey(KEY_LEFT,  (KEYFP) kd_lftitem, FMKTP );
   tmpRIGHT = kt_rplkey(KEY_RIGHT, (KEYFP) kd_rtitem, FMKTP );
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   kt_rplkey(KEY_F2,    (KEYFP) tmpF2,    FMKTP );
   kt_rplkey(KEY_SPACE, (KEYFP) tmpSPACE, FMKTP );
   kt_rplkey(KEY_LEFT,  (KEYFP) tmpLEFT , FMKTP );
   kt_rplkey(KEY_RIGHT, (KEYFP) tmpRIGHT, FMKTP );
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

// Converts settings to command line
   if (retcode == AC_EXIT)  {
      sprintf(temp, "TR%1d ", trNo );
      strcat(DlgBuf,temp);
      for (i=0; i< 11; i++ ) {
         if ( ttr->tEv[i].on == TRUE) {
            memset( actionBuf, NULL, sizeof(actionBuf));
            if (ttr->tEv[i].extIn  == TRUE) strcat(actionBuf,"EXTI ");
            if (ttr->tEv[i].act1[0] != NULL) {
               sprintf(temp, "%s ", ttr->tEv[i].act1);
               strcat( actionBuf, temp);
            }
            if (ttr->tEv[i].act2[0] != NULL) {
               sprintf(temp, "%s ", ttr->tEv[i].act2);
               strcat( actionBuf, temp);
            }
            if ((ttr->tEv[i].act3[0] != NULL) && (cntFlag != 0x04)) {
               sprintf(temp, "%s ", ttr->tEv[i].act3);
               strcat( actionBuf, temp);
            }
            if ((ttr->tEv[i].act4[0] != NULL) && (cntFlag != 0x04)) {
               sprintf(temp, "%s ", ttr->tEv[i].act4);
               strcat( actionBuf, temp);
            }
            if (ttr->tEv[i].extOut == TRUE) strcat( actionBuf, "EXTO " );
            if ( actionBuf[0] != NULL ) {
               ExecDlgFlag = 1;
               sprintf(temp, "%s ", ttr->tEv[i].evName);
               strcat( DlgBuf, temp );
               strcat( DlgBuf, actionBuf );
            }
         }
      }
      if ( (trNo < 2) && (datap->mode[0] != NULL)) {
         sprintf(temp, "%s ", datap->mode);
         strcat(DlgBuf, temp);
      }
      strcat(DlgBuf,"\r");
   }
   if ( retcode == AC_EXIT ) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}   // end of MN_T_TRIGGER()
*/


/**************************************************************************
**
** Name : TriggerOnEnd(dfmptr)
**
** Function: If op field is ON, set SKIP OFF and field attribute as INACTIVE
**           for the rest; otherwise, set SKIP ON.
**
**    Input  : data form pointer
**
**    Output : none
**
** Notes:
**
**************************************************************************/
/*
TriggerOnEnd(DFORMPTR dfmptr)
{
 DFIELDPTR fldptr, pp;
 int curItem, state, k;
 UCHAR color;

   curItem = curitemnum(dfmptr);
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr );
   if (fld_isaltered( fldptr )) {
      fld_get(fldptr->datap,curItem, dfmptr );
      state = (*((UCHAR *)(fldptr->datap)) == TRUE) ? OFF : ON;
      color = (state == OFF) ? (fldptr->inact_att) : (fldptr->skip_att) ;
      for (k=0; k<6; k++ ) {
         pp = (DFIELDPTR) i_numptr(++curItem, dfmptr);
         if (((k==3) && !(cntFlag & 0x01)) || ((k==4) && !(cntFlag & 0x02))
             || (curItem == 66)) {
            sf_opt(SKIP, ON, pp);
            fld_updatt( fldptr->skip_att, curItem, dfmptr );
         }
         else {
            sf_opt(SKIP, state, pp);
            fld_updatt( color, curItem, dfmptr );
         }
      }
   }
   return(TRUE);
}       // end of TriggerOnEnd(dfmptr)
*/


/**************************************************************************
**
** Name : CntOpEnd(dfmptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
CntOpEnd(DFORMPTR dfmptr)
{
 DFIELDPTR fldptr, pp;
 int curItem, state, i;
 UCHAR timerOp[3];

   curItem = curitemnum(dfmptr);
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr  );
   fld_get( fldptr->datap, curItem, dfmptr );
   state  = *((UCHAR *)(fldptr->datap)) == TRUE ? OFF : ON;
   memcpy( timerOp, *((UCHAR *)(fldptr->datap)) ? boolOp[0] : boolOp[1], 3 );
   fld_upd( (PTR) timerOp, 0, dfmptr );
   for (i=0; i<6; i++) {
      if (i != curItem) {
         if ((i>0) && !(i % 2)) fld_upd( fldptr->datap, i, dfmptr );
         pp = (DFIELDPTR) i_numptr( i, dfmptr  );
         if (i<2) sf_opt(SKIP, 1-state, pp);
         else sf_opt(SKIP, state, pp);
      }
   }
   return(TRUE);
}     // end of CntOpEnd(dfmptr)
*/

/**************************************************************************
**
** Name : TimerOpEnd(dfmptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
TimerOpEnd(DFORMPTR dfmptr)
{
 DFIELDPTR fldptr, pp;
 int curItem, state, k, i;
 UCHAR cntOp[3];

   fldptr = (DFIELDPTR) i_namptr( "timerOp", dfmptr  );
   fld_get( fldptr->datap, 0, dfmptr );
   state  = *((UCHAR *)(fldptr->datap)) == TRUE ? ON : OFF;
   memcpy( cntOp, *((UCHAR *)(fldptr->datap))  ? boolOp[0] : boolOp[1], 3 );
   for (k=1; k<6; k++) {
      if (!(k%2)) fld_upd( (PTR)cntOp, k, dfmptr );
      pp = (DFIELDPTR) i_numptr( k, dfmptr  );
      if (k < 2)  sf_opt(SKIP, 1-state , pp );
      else sf_opt(SKIP, state, pp);
   }
   return TRUE;
}       // end of TimerOpEnd(dfmptr)
*/

/**************************************************************************
**
** Name : MN_T_TIMER( TraMenuCopy )
**
** Function :  TRACE menu Timer/Counters
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
MN_T_TIMER( MFORMPTR TraMenuCopy)
{
 TTIMER *datap;
 WINDOWPTR msgwnp;
 DFIELDPTR fldptr;

   VV_ERR = 0;
   datap = &ttimer;
   memset(datap,NULL,sizeof(ttimer));
   DlgFmPtr = dl_fmget("TTimer",datap,usd3dlg,NULLP,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

// Set Messages
   fldptr = (DFIELDPTR) i_namptr("timer",DlgFmPtr);
   sf_msg(FormMsg+1,fldptr);
   fldptr = (DFIELDPTR) i_namptr("cnt0",DlgFmPtr);
   sf_msg(FormMsg+1,fldptr);
   fldptr = (DFIELDPTR) i_namptr("cnt1",DlgFmPtr);
   sf_msg(FormMsg+1,fldptr);

// Get Settings
//   emuGetEvent(event_record,bp_record,&ext_record,&cntFlag,&timerRecord,counter);
   if (cntFlag == 0x04) datap->timerOp = TRUE;
   else {
      if (cntFlag & 0x01) datap->cnt0Op = TRUE;
      if (cntFlag & 0x02) datap->cnt1Op = TRUE;
   }
   Hex2String( datap->timer, timerRecord );
   Hex2String( datap->cnt0, (U32) counter[0] );
   Hex2String( datap->cnt1, (U32) counter[1] );

// Window processing
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if ((datap->timerOp == TRUE) && (datap->timer[0])) {
         ExecDlgFlag = 1;
         strcat(DlgBuf, "TI ");
         strcat(DlgBuf, datap->timer );
         strcat(DlgBuf, "\r");
         return( EXITMENU );
      }
      if ((datap->cnt0Op == TRUE) && (datap->cnt0[0])) {
         ExecDlgFlag = 1;
         strcat(DlgBuf, "CNT0 ");
         strcat(DlgBuf, datap->cnt0 );
         strcat(DlgBuf, "\r");
      }
      if ((datap->cnt1Op == TRUE) && (datap->cnt1[0])) {
         ExecDlgFlag = 1;
         strcat(DlgBuf, "CNT1 ");
         strcat(DlgBuf, datap->cnt1 );
         strcat(DlgBuf, "\r");
      }
      return( EXITMENU );
   }
   else if (retcode == AC_QUIT) return(SAMELEVEL);
}
*/

/**************************************************************************
**
** Name : MN_T_SYNC( TraMenuCopy )
**
** Function :  TRACE menu SYNC Control menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_T_SYNC(MFORMPTR  TraMenuCopy )
{
 TSYNC *datap;
 WINDOWPTR msgwnp;
 DFIELDPTR fldptr;
 char tmpChar;

   VV_ERR = 0;
   datap = &tsync;
   memset(datap,NULL,sizeof(tsync));
   DlgFmPtr = dl_fmget("TSync",datap,usd3dlg,NULLP,VVDLibp);
   if (DlgFmPtr == NULLP) {
           ErrorProc();
           return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

// get previous settings
   emuGetSync(&tmpChar);
   datap->synci = tmpChar&1;
   datap->synco = tmpChar >> 1;

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
   if (retcode == AC_EXIT)  {
      ExecDlgFlag = 1;
      if (datap->synci == TRUE) strcat(DlgBuf,"SY I O\r");
      else if (datap->synci == FALSE) strcat(DlgBuf,"SY I OF\r");

      if (datap->synco == TRUE) strcat(DlgBuf,"SY OU O\r");
      else if (datap->synco == FALSE) strcat(DlgBuf,"SY OU OF\r");
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_SYNC()  */

/**************************************************************************
**
** Name : MN_T_GO( TraMenuCopy )
**
** Function :  TRACE menu Go menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_T_GO(MFORMPTR TraMenuCopy )
{
        ExecDlgFlag = 1;
        strcat(DlgBuf,"G\r");
        return( EXITMENU );

}  /*  of MN_T_GO()  */

/**************************************************************************
**
** Name : MN_T_HALT( TraMenuCopy )
**
** Function :  TRACE menu Halt menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_T_HALT(MFORMPTR      TraMenuCopy )
{
        ExecDlgFlag = 1;
        strcat(DlgBuf,"HA\r");
        return( EXITMENU );

}  /*  of MN_T_HALT()  */

/**************************************************************************
**
** Name : MN_T_LIST( TraMenuCopy )
**
** Function : TRACE menu List menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_T_LIST(MFORMPTR TraMenuCopy )
{
    TLIST *datap;
    WINDOWPTR msgwnp;
    DFIELDPTR fldptr;
    MEMOPTR memoPtr;
    KEYFP tmpF2;

    VV_ERR = 0;
    datap = &tlist;

    DlgFmPtr = dl_fmget("TList",datap,usd3dlg,CListMFilePtr,VVDLibp);
    if (DlgFmPtr == NULLP) {
       ErrorProc();
       return(EXITMENU);
    }
    ShowShadow(DlgFmPtr->wnp);

    fldptr = (DFIELDPTR) i_namptr("format",DlgFmPtr);
    sf_msg(TFormMsg+1,fldptr);
    memoPtr = (MEMOPTR) i_namptr("status",DlgFmPtr);
    sf_msg( chListMsg+1,memoPtr);

// Get Settings
    if (emuGetTraceDepth(curBuf-1, &traceDepth[curBuf-1] ) != BUFFER_EMPTY)  {
       Hex2String( datap->traceBufID, (U32) curBuf );
       Long2String( datap->startFrame,(long) traceDepth[ curBuf-1 ].startFrame);
       Long2String( datap->endFrame, (long) traceDepth[ curBuf-1 ].endFrame);
    }

    tmpF2 = kt_rplkey(KEY_F2,(KEYFP) ShowStatus,TTMEMOKTP);
    msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
    wn_up(msgwnp);
    v_st(FormMsg,msgwnp);
    pulldown_or_dialog = DIALOG;
    retcode = fm_proc(0,DlgFmPtr);
    pulldown_or_dialog = PULLDOWN;
    wn_dn(msgwnp);
    wn_free(msgwnp);
    fm_free(DlgFmPtr);
    kt_rplkey(KEY_F2,(KEYFP) tmpF2, TTMEMOKTP);

    if (retcode == AC_EXIT)  {
       ExecDlgFlag = 1;
       strcat(DlgBuf,"L ");
/*
       if (strstr(strupr(datap->format),"MIX") != NULL) strcat(DlgBuf,"SO ");
       else
          if (strstr(datap->format,"ASSEMBLY") != NULL) strcat(DlgBuf,"IN ");
*/
// changed by Chen, 07/06/94
        if ( strstr(strupr(datap->format),"INSTRUCTION") != NULL ) {
            strcat(DlgBuf,"IN ");
        }
        else if ( strstr(strupr(datap->format),"SOURCE") != NULL ) {
            strcat(DlgBuf,"SO ");
        }
        else if ( strstr(strupr(datap->format),"MIXED") != NULL ) {
            strcat(DlgBuf,"MI ");
        }
        else if ( strstr(strupr(datap->format),"MODULE") != NULL ) {
            strcat(DlgBuf,"MO ");
        }
          else
                if (strstr(datap->format,"RAW") == NULL) { //illegal input
                    strcpy(DlgBuf, "");
                    return (EXITMENU);
                }
             else {   // frame [abs1 abs2] [status] [trace-bits]
                if (datap->frameToStart[0] != '\0') {
                   strcat(DlgBuf,datap->frameToStart);
                   strcat(DlgBuf," ");
                }
                if (datap->begAddr[0] != '\0') {
                   strcat(DlgBuf,datap->begAddr);
                   strcat(DlgBuf," ");
                   strcat(DlgBuf,datap->endAddr);
                   strcat(DlgBuf," ");
                }
                if (datap->status[0] != '\0') {
                   strcat(DlgBuf, datap->status);
                   strcat(DlgBuf, " ");
                }
                if (datap->traceBits[0] != '\0') strcat(DlgBuf, datap->traceBits);
                strcat(DlgBuf,"\r");
                return(EXITMENU);
             }
       if (datap->frameToStart[0] != '\0') strcat(DlgBuf,datap->frameToStart);
       strcat(DlgBuf,"\r");
    } /* end if (AC_EXIT)  */

    if (retcode == AC_EXIT) return( EXITMENU );
    else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_LIST()  */

/**************************************************************************
**
** Name : ListFormatEnd(DFORMPTR dfmptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ListFormatEnd(DFORMPTR dfmptr)
{
 DFIELDPTR fldptr, pp;
 int curItem, state, i;
 MEMOPTR memoPtr;

   curItem = curitemnum(dfmptr);
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr  );
   fld_get(fldptr->datap,curItem, dfmptr );
   state = (strstr(strupr(fldptr->datap), "RAW") != NULL) ? OFF : ON;
   for (i=1; i<5; i++) {
      if (i==3)  {
         memoPtr = (MEMOPTR) i_numptr( curItem + i, dfmptr   );
         sf_opt(SKIP,state, memoPtr);
         if (state == ON) memo_upd( "\0", curItem+i, dfmptr   );
      }
      else {
         pp = (DFIELDPTR) i_numptr( curItem+i, dfmptr  );
         sf_opt(SKIP, state, pp);
         if (state == ON) fld_blank( curItem+i, dfmptr  );
      }
   }
   return(TRUE);
}         /* end of ListFormatEnd(dfmptr) */

/**************************************************************************
**
** Name : GetAddrDataValue()
**
** Function: Converts the event address or datum setting to a string.
**
**    Input  : dataSpec, dataLo, dataHi, len
**
**    Output : *retStr
**
** Notes:
**
**************************************************************************/
GetAddrDataValue(U8 *retStr, int dataSpec, U32 dataLo, U32 dataHi, U8 len )
{
 U8 temp1[80], temp2[80];

 *retStr = '\0';
 if (dataSpec == 2) {   /* Range value */
    GetWildCard( temp1, 0xFFFFFFFF, dataLo, len );
    GetWildCard( temp2, 0xFFFFFFFF, dataHi, len );
    sprintf( retStr, "RAnge %s %s", temp1, temp2);
 }
 else
    if ((dataSpec == 1 ) || (dataSpec == 3))  /* Single value or Wildcard value */
       GetWildCard( retStr, dataHi, dataLo, len);
    else return 0;
 return 1;
} /* end of GetAddrDataValue() */

/**************************************************************************
**
** Name : TriggerToggle(keyptr)
**
** Function : Processes fields when key SPACE is pressed.
**            Event  : Displays corresponding event.
**            On/Off : Sets option SKIP ON/OFF, and field attribute
**                     SKIP/INACTIVE.
**            Actions: Toggle choices.
**
**    Input  : key pointer
**    Output : none
**
** Notes:
**
**************************************************************************/
/*
TriggerToggle( KEYCTRLPTR keyptr )
{
 int curItem;
 DFIELDPTR fldptr;

   curItem = curitemnum( DlgFmPtr );
   fldptr = curdfldp( DlgFmPtr);
   if (!(curItem % 8) && (curItem < 72))
      return( TriggerDisplayEvent(curItem, fldptr) );
   if (fldptr->togglep) {
      kd_booltoggle( DlgFmPtr );
      if (!((curItem-1) % 8)) TriggerOnEnd( DlgFmPtr ); // field "on"
      return TRUE;
   }
   return(SpaceToggle( keyptr ));
}
*/

/**************************************************************************
**
** Name : TriggerF2(keyptr)
**
** Function: Allows mouse functioning at event fields to display event
**           settings in trigger dialog box when the mouse button is clicked.
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
TriggerF2( DFORMPTR  dfmptr  )
{
 int curItem;
 DFIELDPTR fldptr;

   curItem = curitemnum( dfmptr );
   fldptr = curdfldp( dfmptr );
   if (!(curItem % 8) && (curItem <  72))
      return( TriggerDisplayEvent(curItem, fldptr) );
   else return( kd_clist( dfmptr ) );
}
/**************************************************************************
**
** Name : TriggerDisplayEvent
**
** Function: Displays event window on event field in Trigger Dialog box
**           when SPACE pressed or mouse left button clicked.
**
**    Input  : curItem: current field no., fldptr: current field ptr.
**    Output : None
**
** Notes:
**
**************************************************************************/
TriggerDisplayEvent (int curItem, DFIELDPTR fldptr )
{
 WINDOWPTR evWnp;
 char addr[40], datum[40], stat[40], count[5], temp[100];
 int idx;

   idx = curItem/8;
//   emuGetEvent(event_record,bp_record,&ext_record,&cntFlag,&timerRecord,counter);
   if (event_record[ idx ].defined) {
      GetBusEventInfo( addr, datum, stat, count, event_record[ idx ] );
      sprintf(temp,"EV%1d: %s %s %s %s", idx+1, addr,  datum, stat, count);
   }
   else strcpy(temp, "Event is not set !");
   evWnp = wn_def(fldptr->rb+1,fldptr->cb-3,3,50, LBLA_WHI, BDR_DLNP);
   sw_bdratt(LBLA_WHI, evWnp);
   wn_up(evWnp);
   v_stpl(0, 1, temp, evWnp);
   RedDialogKi(); // Wait for any keys or mouse buttons being pressed
   wn_dn(evWnp);
   wn_free(evWnp);
   sfm_nextitem(AC_NEXTITEM, DlgFmPtr);
   return TRUE;
}

/**************************************************************************
**
** Name : EventKeyRight
**
** Function: Allows KEY_RIGHT to move to the field at right of Event operation
**           field, if the content of operation field is "Set".
**
** Notes:
**
**************************************************************************/
EventKeyRight( DFORMPTR dfmptr )
{
 int curItem, item;
 DFIELDPTR fldptr;

 curItem = curitemnum( dfmptr );
 fldptr = curdfldp( dfmptr );
 if ((dfmptr == DlgFmPtr) && (!(curItem % 5)))  EventOpEnd( dfmptr );
 return( kd_rtcsr( dfmptr) );
}

/**************************************************************************
**
** Name : EventStatusKeyLeft
**
** Function: Allows KEY_LEFT to move to the field at left of Event status
**           field.
**
** Notes:
**
**************************************************************************/
EventStatusKeyLeft( DFORMPTR dfmptr )
{
 MEMOPTR memoptr;

 memoptr = curmemop( dfmptr );
 if (!(3 + dfmptr->wnp->c - memoptr->wnp->cb)) // check if cursor at the
    return(kd_lftitem( dfmptr ));              // first position of the field
 else return(ke_lft(dfmptr));
}



/****************************************************************************
**
** Name     : MN_T_LAMTRIGGER()
**
** Function : TRACE menu TRIGGLE item   ( for LAM )
**
** Notes:
**
****************************************************************************/
int MN_T_LAMTRIGGER( MFORMPTR TraMenuCopy )
{
TTRIGGER *datap;
WINDOWPTR msgwnp;
DFIELDPTR fldptr1, fldptr2, fldptr3, fldptr4;
MEMOPTR memoptr;

// link data structure with data form
   VV_ERR = 0;
   datap = &ttrigger;

// get form from VVD library
   DlgFmPtr = dl_fmget( "TTrigger", datap, usd3dlg, CListMFilePtr, VVDLibp );
   if ( DlgFmPtr == NULLP ) {
      ErrorProc();
      return ( EXITMENU );
   }

// it will be added to show shadow
   ShowShadow( DlgFmPtr->wnp );

// specify messages to the form field
   fldptr1 = (DFIELDPTR) i_namptr( "operation", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr1 );

   fldptr2 = (DFIELDPTR) i_namptr( "eventseq", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr2 );

   fldptr3 = (DFIELDPTR) i_namptr( "action", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr3 );

   fldptr4 = (DFIELDPTR) i_namptr( "mode", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr4 );

   memoptr = (MEMOPTR) i_namptr( "count", DlgFmPtr );
   sf_msg( FormMsg+1, memoptr );

// show the message to the status line
   msgwnp = wn_def( vs_rowq()-1, 0, 1, vs_colq(), LMESSAGE, BDR_NULLP );
   wn_up( msgwnp );
   v_st( FormMsg, msgwnp );

// active the data form entry
   pulldown_or_dialog = DIALOG;    // dialog box flag
   retcode = fm_proc( 0, DlgFmPtr );

// inactive the status message and release the memory
   pulldown_or_dialog = PULLDOWN;    // pull-down menu flag
   wn_dn( msgwnp );
   wn_free( msgwnp );
   fm_free( DlgFmPtr );

// leave from dialog box only
   if ( retcode == AC_QUIT )
      return ( SAMELEVEL );


// process the input read in the data form

// do nothing if no any choice
   if ( strstr( datap->operation, "" ) != NULL ) {
      return ( EXITMENU );   //  retcode == AC_EXIT
   }

// clear the trigger
   if ( strstr( strupr(datap->operation), "CLEAR" ) != NULL ) {
      ExecDlgFlag = 1;
      strcpy( DlgBuf, "Trigger CLear \r " );
      return ( EXITMENU );   //  retcode == AC_EXIT
   }

// display the trigger setting
   if ( strstr(strupr(datap->operation),"SHOW")!=NULL &&
        strlen(datap->operation)==strlen("SHOW") ) {
      ExecDlgFlag = 1;
      strcpy( DlgBuf, "Trigger \r " );
      return ( EXITMENU );   //  retcode == AC_EXIT
   }

// set the trigger
   if ( strstr(strupr(datap->operation),"SET")!=NULL &&
        strlen(datap->operation)==strlen("SET") ) {
        ExecDlgFlag = 1;
        strcpy( DlgBuf, "Trigger " );
        if ( datap->eventseq[0] == '\0' ) {
            strcat( DlgBuf, " \r" );
            return ( EXITMENU );
        }
        else {
            if ( datap->action[0] != '\0' ) {
                if ( strstr(strupr(datap->action),"RUN")!=NULL &&
                     strlen(datap->action)==strlen("RUN") ) {
                    strcat( DlgBuf, datap->action );
                    strcat( DlgBuf, " " );
                }
            }
            strcat( DlgBuf, datap->eventseq );
            strcat( DlgBuf, " " );
            if ( datap->mode[0] != '\0' ) {
                strcat( DlgBuf, datap->mode );
                strcat( DlgBuf, " " );
            }
            if ( strstr(strupr(datap->mode),"DELAY")==NULL ) {
                strcat( DlgBuf, " \r" );
                return ( EXITMENU );
            }
            else {
                strcat( DlgBuf, datap->count );
                strcat( DlgBuf, " " );
                strcat( DlgBuf, "\r" );
                return ( EXITMENU );
            }
        }
    }    // end of "SET"


// confirm the quit level
   if ( retcode == AC_EXIT )
      return ( EXITMENU );   // leave from both dialog box and menu
   else if ( retcode == AC_QUIT )
      return ( SAMELEVEL );   // leave from dialog box only

}   // end of MN_T_LAMTRIGGER()



/****************************************************************************
**
** Name      : TriggerOperationEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int TriggerOpEnd( DFORMPTR dfmptr )
{
   DFIELDPTR fldptr;   // point to the special field
   DFIELDPTR pp;   // point to current field
   int curItem;   // ID of the current item
   int state;   // flag: skip the current field or not
   int i ;   // loop controler of for_loop
   int count;   // count of field item

   curItem = curitemnum( dfmptr );
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr  );
   fld_get( fldptr->datap, curItem, dfmptr );

    if ( strstr(strupr(fldptr->datap),"SET")!=NULL &&
         strlen(fldptr->datap)==strlen("SET") ) {
        state = OFF;
    }
    else {
        state = ON;
    }

//    count = 4;
    count = 3;  // changed by Chen, 07/19/94

   for ( i = 0; i <= count; i++ ) {
      pp = (DFIELDPTR) i_numptr( curItem++, dfmptr );
      sf_opt( SKIP, state, pp );
   }

   return ( TRUE );

}   // end of TriggerOpEnd()


/****************************************************************************
**
** Name      : TriggerModeEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int TriggerModeEnd( DFORMPTR dfmptr )
{
   DFIELDPTR fldptr;   // point to the special field
   DFIELDPTR pp;   // point to current field
   int curItem;   // ID of the current item
   int state;   // flag: skip the current field or not
   int i ;   // loop controler of for_loop

   curItem = curitemnum( dfmptr );
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr  );
   fld_get( fldptr->datap, curItem, dfmptr );

   if ( strstr( fldptr->datap, "Delay" ) != NULL )
      state = OFF;
   else
      state = ON;

   for ( i = 0; i <= 1; i++ ) {
      pp = (DFIELDPTR) i_numptr( curItem++, dfmptr );
      sf_opt( SKIP, state, pp );
   }

   return ( TRUE );

}   // end of TriggerModeEnd()



/****************************************************************************
**
** Name     : MN_T_LAM2TLEVEL()
**
** Function : TRACE menu TLEVEL item    ( for LAM2 )
**
** Notes:
**
****************************************************************************/
int MN_T_LAM2TLEVEL( MFORMPTR TraMenuCopy )
{
LAM2TLEVEL *datap;
WINDOWPTR msgwnp;
DFIELDPTR fldptr1, fldptr2, fldptr3, fldptr4;
MEMOPTR memoptr1;

// link data structure with data form
   VV_ERR = 0;
   datap = &lam2tlevel;

// get form from VVD library
   DlgFmPtr = dl_fmget( "LAM2TLevel", datap, usd3dlg, CListMFilePtr, VVDLibp );
   if ( DlgFmPtr == NULLP ) {
      ErrorProc();
      return ( EXITMENU );
   }

// it will be added to show shadow
   ShowShadow( DlgFmPtr->wnp );

// specify messages to the form field
   fldptr1 = (DFIELDPTR) i_namptr( "operation", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr1 );

   fldptr2 = (DFIELDPTR) i_namptr( "levelno", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr2 );

   fldptr3 = (DFIELDPTR) i_namptr( "trace", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr3 );

   fldptr4 = (DFIELDPTR) i_namptr( "timer", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr4 );

   memoptr1 = (MEMOPTR) i_namptr( "eventseq", DlgFmPtr );
   sf_msg( FormMsg+1, memoptr1 );

// show the message to the status line
   msgwnp = wn_def( vs_rowq()-1, 0, 1, vs_colq(), LMESSAGE, BDR_NULLP );
   wn_up( msgwnp );
   v_st( FormMsg, msgwnp );

// active the data form entry
   pulldown_or_dialog = DIALOG;    // dialog box flag
   retcode = fm_proc( 0, DlgFmPtr );

// inactive the status message and release the memory
   pulldown_or_dialog = PULLDOWN;    // pull-down menu flag
   wn_dn( msgwnp );
   wn_free( msgwnp );
   fm_free( DlgFmPtr );

// leave from dialog box only
    if ( retcode == AC_QUIT ) {
        return ( SAMELEVEL );
    }


// process the input read in the data form

// display the trigger setting
   if ( strstr(strupr(datap->operation),"SHOW")!=NULL &&
        strlen(datap->operation)==strlen("SHOW") ) {
      ExecDlgFlag = 1;
      strcpy( DlgBuf, "Trigger Level \r" );
      return ( EXITMENU );   //  retcode == AC_EXIT
   }

// clear the trigger
   if ( strstr( strupr(datap->operation), "CLEAR" ) != NULL ) {
        ExecDlgFlag = 1;
        strcpy(DlgBuf, "Trigger Level ");
        strcat(DlgBuf, datap->levelno);
        strcat(DlgBuf, " CLear \r");
        return ( EXITMENU );   //  retcode == AC_EXIT
   }

// do nothing if Operation field is not SET, SHOW nor CLEAR
    if ( strstr( strupr(datap->operation), "SET" ) == NULL ) {
	DlgBuf[0] = NULL;
	return ( EXITMENU );   //  retcode == AC_EXIT
    }

// set the trigger number
    if ( (datap->levelno[0] >= 'A') && (datap->levelno[0] <= 'H') ) {
        ExecDlgFlag = 1;
        strcpy( DlgBuf, "Trigger Level " );
        strcat( DlgBuf, datap->levelno );
        strcat( DlgBuf, " " );
    }
    else {
        return ( EXITMENU );   //  retcode == AC_EXIT
    }

// process Event Sequence field
    if ( datap->eventseq[0] != NULL ) {
        strcat( DlgBuf, datap->eventseq );
        strcat( DlgBuf, " " );
    }
    else {
        DlgBuf[0] = NULL;
        return ( EXITMENU );   //  retcode == AC_EXIT
    }

// process Trace field
    if ( strstr(strupr(datap->trace),"ON") != NULL ) {
        strcat( DlgBuf, "Trace On" );
        strcat( DlgBuf, " " );
    }
    else if ( strstr(strupr(datap->trace),"OFF") != NULL ) {
        strcat( DlgBuf, "Trace OFf" );
        strcat( DlgBuf, " " );
    }

// process Timer field
    if ( strstr(strupr(datap->timer),"ON") != NULL ) {
        strcat( DlgBuf, "TImer On" );
        strcat( DlgBuf, " " );
    }
    else if ( strstr(strupr(datap->timer),"OFF") != NULL ) {
        strcat( DlgBuf, "TImer OFf" );
        strcat( DlgBuf, " " );
    }

// execute the dialog box input
    strcat( DlgBuf, "\r" );
    return ( EXITMENU );   // leave from both dialog box and menu


}   // end of MN_T_LAM2TLEVEL()



/****************************************************************************
**
** Name      : LAM2TLevelOpEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int LAM2TLevelOpEnd( DFORMPTR dfmptr )
{
DFIELDPTR fldptr;   // point to the special field
DFIELDPTR pp;       // point to current field
int curItem;        // ID of the current item
int state;          // flag: skip the current field or not
int i;              // loop controler of for_loop


    curItem = curitemnum( dfmptr );
    fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr );
    fld_get( fldptr->datap, curItem, dfmptr );

    if ( strstr(strupr(fldptr->datap),"SHOW")!=NULL &&
         strlen(fldptr->datap)==strlen("SHOW") ) {
        state = ON;
    }
    else {
        state = OFF;
    }

    for ( i = 0; i <= 4; i++ ) {
        pp = (DFIELDPTR) i_numptr( curItem++, dfmptr );
        sf_opt( SKIP, state, pp );
    }

    return (TRUE);

}   // end of LAM2TLevelOpEnd()



/****************************************************************************
**
** Name      : LAM2TLevelNoEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int LAM2TLevelNoEnd( DFORMPTR dfmptr )
{
DFIELDPTR fldptr;   // point to the special field
DFIELDPTR pp;       // point to current field
int curItem;        // ID of the current item
int state;          // flag: skip the current field or not
int i;              // loop controler of for_loop


// if Operation is "Clear", skip all the next field
    curItem = i_namnum("operation", dfmptr);
    fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr );
    fld_get( fldptr->datap, curItem, dfmptr );
    if ( strstr( strupr(fldptr->datap), "CLEAR" ) != NULL ) {
        curItem++;
        state = ON;
    }
    else {
        curItem = curitemnum( dfmptr );
        fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr );
        fld_get( fldptr->datap, curItem, dfmptr );
        if ( strstr( strupr(fldptr->datap), "A" ) != NULL ||
             strstr( strupr(fldptr->datap), "B" ) != NULL ||
             strstr( strupr(fldptr->datap), "C" ) != NULL ||
             strstr( strupr(fldptr->datap), "D" ) != NULL ||
             strstr( strupr(fldptr->datap), "E" ) != NULL ||
             strstr( strupr(fldptr->datap), "F" ) != NULL ||
             strstr( strupr(fldptr->datap), "G" ) != NULL ||
             strstr( strupr(fldptr->datap), "H" ) != NULL ) {
            state = OFF;
        }
        else {
            state = ON;
        }
    }

    for ( i = 0; i <= 3; i++ ) {
        pp = (DFIELDPTR) i_numptr( curItem++, dfmptr );
        sf_opt( SKIP, state, pp );
    }

   return ( TRUE );

}   // end of LAM2TLevelNoEnd()



/****************************************************************************
**
** Name      : LAM2LevelSeqBeg()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int LAM2LevelSeqBeg( DFORMPTR dfmptr )
{
WINDOWPTR msgwnp;           // pointer to status line message window
int curItem;                // item unmber of the previous data form
unsigned char tempSeq[57];  // temp array to store LAM2 sequence
DFIELDPTR event1Ptr, event2Ptr, event3Ptr, event4Ptr, event5Ptr;
        // pointer to LAM2 events sequence field
DFIELDPTR logic1Ptr, logic2Ptr, logic3Ptr, logic4Ptr;
        // pointer to LAM2 events logic field
static unsigned char event1[8], event2[8], event3[8], event4[8], event5[8];
        // to store event field input
static unsigned char logic1[6], logic2[6], logic3[6], logic4[6];
        // to store logic field input
CLISTPTR log1Clstp, log2Clstp, log3Clstp, log4Clstp;
        // pointer to choice list for logic field


// get the current field number of the previous form
    curItem = curitemnum( dfmptr );

// initialize the data array
    memset( tempSeq, NULL, sizeof(tempSeq) );
    memset( event1, NULL, sizeof(event1) );
    memset( event2, NULL, sizeof(event2) );
    memset( event3, NULL, sizeof(event3) );
    memset( event4, NULL, sizeof(event4) );
    memset( event5, NULL, sizeof(event5) );
    memset( logic1, NULL, sizeof(logic1) );
    memset( logic2, NULL, sizeof(logic2) );
    memset( logic3, NULL, sizeof(logic3) );
    memset( logic4, NULL, sizeof(logic4) );

// define data form
    lam2Sequence = fm_def( 10, 6, 7, 69, LFORMS, BDR_DLNP );
    if ( lam2Sequence == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

// set the special flag
    lam2SeqFlag = TRUE;

// close the VERIFYQUIT option
    sfm_opt( VERIFYQUIT, OFF, lam2Sequence );

// define the title
    sw_title( " EVENT SEQUENCE ", LFORMS, TOPCENTER, lam2Sequence->wnp );

// draw the background line
    bg_linedef( 0, 1, 65, RIGHT|X_LINE, LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 2, 1, 65, RIGHT|X_LINE, LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 4, 1, 65, RIGHT|X_LINE, LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 1,  5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 9,  5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 15, 5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 23, 5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 29, 5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 37, 5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 43, 5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 51, 5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 57, 5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );
    bg_linedef( 0, 65, 5, DOWN|X_LINE,  LFORMS, LINE_SLNP, lam2Sequence );

// draw the background text
    bg_txtdef( 1,  2, " EVENT ", LFORMS, lam2Sequence );
    bg_txtdef( 1, 10, "LOGIC",   LFORMS, lam2Sequence );
    bg_txtdef( 1, 16, " EVENT ", LFORMS, lam2Sequence );
    bg_txtdef( 1, 24, "LOGIC",   LFORMS, lam2Sequence );
    bg_txtdef( 1, 30, " EVENT ", LFORMS, lam2Sequence );
    bg_txtdef( 1, 38, "LOGIC",   LFORMS, lam2Sequence );
    bg_txtdef( 1, 44, " EVENT ", LFORMS, lam2Sequence );
    bg_txtdef( 1, 52, "LOGIC",   LFORMS, lam2Sequence );
    bg_txtdef( 1, 58, " EVENT ", LFORMS, lam2Sequence );

// define the data field
    event1Ptr = fld_def( 3, 2, NULLP, FADJACENT, "XXXXXXX", F_STRING,
                         event1, lam2Sequence );
    if ( event1Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    logic1Ptr = fld_def( 3, 10, NULLP, FADJACENT, "XXXXX", F_STRING,
                         logic1, lam2Sequence );
    if ( logic1Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    event2Ptr = fld_def( 3, 16, NULLP, FADJACENT, "XXXXXXX", F_STRING,
                         event2, lam2Sequence );
    if ( event2Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    logic2Ptr = fld_def( 3, 24, NULLP, FADJACENT, "XXXXX", F_STRING,
                         logic2, lam2Sequence );
    if ( logic2Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    event3Ptr = fld_def( 3, 30, NULLP, FADJACENT, "XXXXXXX", F_STRING,
                         event3, lam2Sequence );
    if ( event3Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    logic3Ptr = fld_def( 3, 38, NULLP, FADJACENT, "XXXXX", F_STRING,
                         logic3, lam2Sequence );
    if ( logic3Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    event4Ptr = fld_def( 3, 44, NULLP, FADJACENT, "XXXXXXX", F_STRING,
                         event4, lam2Sequence );
    if ( event4Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    logic4Ptr = fld_def( 3, 52, NULLP, FADJACENT, "XXXXX", F_STRING,
                         logic4, lam2Sequence );
    if ( logic4Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    event5Ptr = fld_def( 3, 58, NULLP, FADJACENT, "XXXXXXX", F_STRING,
                         event5, lam2Sequence );
    if ( event5Ptr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

//  set the field option
    sf_opt( CLEARONKEY, ON, event1Ptr );
    sf_opt( CLEARONKEY, ON, event2Ptr );
    sf_opt( CLEARONKEY, ON, event3Ptr );
    sf_opt( CLEARONKEY, ON, event4Ptr );
    sf_opt( CLEARONKEY, ON, event5Ptr );
    sf_opt( CLEARONKEY, ON, logic1Ptr );
    sf_opt( CLEARONKEY, ON, logic2Ptr );
    sf_opt( CLEARONKEY, ON, logic3Ptr );
    sf_opt( CLEARONKEY, ON, logic4Ptr );

// define field active/inactive color
    sf_attact( LFLDACTON, event1Ptr );
    sf_attact( LFLDACTON, event2Ptr );
    sf_attact( LFLDACTON, event3Ptr );
    sf_attact( LFLDACTON, event4Ptr );
    sf_attact( LFLDACTON, event5Ptr );
    sf_attact( LFLDACTON, logic1Ptr );
    sf_attact( LFLDACTON, logic2Ptr );
    sf_attact( LFLDACTON, logic3Ptr );
    sf_attact( LFLDACTON, logic4Ptr );
    sf_attinact( LFLDACTOFF, event1Ptr );
    sf_attinact( LFLDACTOFF, event2Ptr );
    sf_attinact( LFLDACTOFF, event3Ptr );
    sf_attinact( LFLDACTOFF, event4Ptr );
    sf_attinact( LFLDACTOFF, event5Ptr );
    sf_attinact( LFLDACTOFF, logic1Ptr );
    sf_attinact( LFLDACTOFF, logic2Ptr );
    sf_attinact( LFLDACTOFF, logic3Ptr );
    sf_attinact( LFLDACTOFF, logic4Ptr );

// define field help message
    sf_help( "*LAM2SequenceEvent", event1Ptr );
    sf_help( "*LAM2SequenceEvent", event2Ptr );
    sf_help( "*LAM2SequenceEvent", event3Ptr );
    sf_help( "*LAM2SequenceEvent", event4Ptr );
    sf_help( "*LAM2SequenceEvent", event5Ptr );
    sf_help( "*LAM2SequenceLogic", logic1Ptr );
    sf_help( "*LAM2SequenceLogic", logic2Ptr );
    sf_help( "*LAM2SequenceLogic", logic3Ptr );
    sf_help( "*LAM2SequenceLogic", logic4Ptr );

// define begin function for Event field
    sf_begfp( LAM2SeqEventBegin, event1Ptr );
    sf_begfp( LAM2SeqEventBegin, event2Ptr );
    sf_begfp( LAM2SeqEventBegin, event3Ptr );
    sf_begfp( LAM2SeqEventBegin, event4Ptr );
    sf_begfp( LAM2SeqEventBegin, event5Ptr );


// define choice list for the Logic field
//
/* locate the choise list by myself in the below way
*  locate it automaticly by VV system in the current version
*    if ( !sf_clist( "*LAM2TrigLogic", CLMANUAL|CLAUTOMOVE|CLCHSELECT|CLWRAP,
*                    CListMFilePtr, logic1Ptr ) ) {
*        ErrorProc();
*        return ( EXITMENU );
*    }
*    scl_attinact( LFLDACTOFF, logic1Ptr->clistp );
*    scl_attact( LFLDACTON, logic1Ptr->clistp );
*    sw_bdratt( LFLDACTOFF, logic1Ptr->clistp->wnp );
*    wn_mod( lam2Sequence->wnp->rb+logic1Ptr->rb+1,
*            lam2Sequence->wnp->cb+logic1Ptr->cb-1,
*            4, 9, logic1Ptr->clistp->wnp );
*/

    if ( !sf_clist( "*LAM2TrigLogic", CLAUTOMOVE|CLCHSELECT|CLWRAP,
                    CListMFilePtr, logic1Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, logic1Ptr->clistp );
    scl_attact( LFLDACTON, logic1Ptr->clistp );
    sw_bdratt( LFLDACTOFF, logic1Ptr->clistp->wnp );

    if ( !sf_clist( "*LAM2TrigLogic", CLAUTOMOVE|CLCHSELECT|CLWRAP,
                    CListMFilePtr, logic2Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, logic2Ptr->clistp );
    scl_attact( LFLDACTON, logic2Ptr->clistp );
    sw_bdratt( LFLDACTOFF, logic2Ptr->clistp->wnp );

    if ( !sf_clist( "*LAM2TrigLogic", CLAUTOMOVE|CLCHSELECT|CLWRAP,
                    CListMFilePtr, logic3Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, logic3Ptr->clistp );
    scl_attact( LFLDACTON, logic3Ptr->clistp );
    sw_bdratt( LFLDACTOFF, logic3Ptr->clistp->wnp );

    if ( !sf_clist( "*LAM2TrigLogic", CLAUTOMOVE|CLCHSELECT|CLWRAP,
                    CListMFilePtr, logic4Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, logic4Ptr->clistp );
    scl_attact( LFLDACTON, logic4Ptr->clistp );
    sw_bdratt( LFLDACTOFF, logic4Ptr->clistp->wnp );

// define choice list for the Event field
    if ( !sf_clist( eventClist, CLAUTOMOVE|CLWRAP,
                    CListMFilePtr, event1Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, event1Ptr->clistp );
    scl_attact( LFLDACTON, event1Ptr->clistp );
    sw_bdratt( LFLDACTOFF, event1Ptr->clistp->wnp );

    if ( !sf_clist( eventClist, CLAUTOMOVE|CLWRAP,
                    CListMFilePtr, event2Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, event2Ptr->clistp );
    scl_attact( LFLDACTON, event2Ptr->clistp );
    sw_bdratt( LFLDACTOFF, event2Ptr->clistp->wnp );

    if ( !sf_clist( eventClist, CLAUTOMOVE|CLWRAP,
                    CListMFilePtr, event3Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, event3Ptr->clistp );
    scl_attact( LFLDACTON, event3Ptr->clistp );
    sw_bdratt( LFLDACTOFF, event3Ptr->clistp->wnp );

    if ( !sf_clist( eventClist, CLAUTOMOVE|CLWRAP,
                    CListMFilePtr, event4Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, event4Ptr->clistp );
    scl_attact( LFLDACTON, event4Ptr->clistp );
    sw_bdratt( LFLDACTOFF, event4Ptr->clistp->wnp );

    if ( !sf_clist( eventClist, CLAUTOMOVE|CLWRAP,
                    CListMFilePtr, event5Ptr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, event5Ptr->clistp );
    scl_attact( LFLDACTON, event5Ptr->clistp );
    sw_bdratt( LFLDACTOFF, event5Ptr->clistp->wnp );

// define the status line message
    msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
    wn_up( msgwnp );
    v_st( TFormMsg+1, msgwnp );

// process the form
    retcode = fm_proc( 0, lam2Sequence );

// destroy the form
    wn_dn( msgwnp );
    wn_free( msgwnp );
    fm_free( lam2Sequence );

// reset the special flag
    lam2SeqFlag = FALSE;

// accept the input data
    if ( retcode == AC_EXIT ) {
        if ( event1[0] ) {
            strcat( tempSeq, event1 );
            strcat( tempSeq, " " );
        }
        if ( logic1[0] ) {
            strcat( tempSeq, logic1 );
            strcat( tempSeq, " " );
        }
        if ( event2[0] ) {
            strcat( tempSeq, event2 );
            strcat( tempSeq, " " );
        }
        if ( logic2[0] ) {
            strcat( tempSeq, logic2 );
            strcat( tempSeq, " " );
        }
        if ( event3[0] ) {
            strcat( tempSeq, event3 );
            strcat( tempSeq, " " );
        }
        if ( logic3[0] ) {
            strcat( tempSeq, logic3 );
            strcat( tempSeq, " " );
        }
        if ( event4[0] ) {
            strcat( tempSeq, event4 );
            strcat( tempSeq, " " );
        }
        if ( logic4[0] ) {
            strcat( tempSeq, logic4 );
            strcat( tempSeq, " " );
        }
        if ( event5[0] ) {
            strcat( tempSeq, event5 );
            strcat( tempSeq, " " );
        }
        memo_upd( tempSeq, curItem, dfmptr );
        sfm_nextitem( AC_NEXTITEM, dfmptr );
//        sfm_nextitem( AC_SAMEITEM, dfmptr );  How to browse this field ?
    }
    else if ( retcode == AC_QUIT ) {
        sfm_nextitem( AC_NEXTITEM, dfmptr );
        return ( TRUE );
    }

// transform data to the parents data structure
    strcpy( lam2tlevel.eventseq, tempSeq );

// return back
    return ( TRUE );

}   // end of LAM2LevelSeqBeg()



/****************************************************************************
**
** Name      : LAM2SeqEventBegin()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int LAM2SeqEventBegin( void )
{
DFIELDPTR fldptr;   // point to the special field
unsigned char clistFlag = 0;    // indicate which choice list will be shown
unsigned char tempSeq[57];  // temp array to store LAM2 sequence
int i;      // item number of event field

// get the current field data into a temp buffer
    memset( tempSeq, NULL, sizeof(tempSeq) );
    for ( i = 0; i <= 8; i += 2 ) {
        fldptr = (DFIELDPTR) i_numptr( i, lam2Sequence );
        fld_get( fldptr->datap, i, lam2Sequence );
        strcat( tempSeq, fldptr->datap );
    }

// set the choice list flag
    if ( strstr(tempSeq, "EV1") ) {
        clistFlag |= 0x01;
    }

    if ( strstr(tempSeq, "EV2") ) {
        clistFlag |= 0x02;
    }

    if ( strstr(tempSeq, "EV3") ) {
        clistFlag |= 0x04;
    }

    if ( strstr(tempSeq, "EV4") ) {
        clistFlag |= 0x08;
    }

    if ( strstr(tempSeq, "EV5") ) {
        clistFlag |= 0x10;
    }

// get the event choice list number of the trigger sequence for LAM2
    switch ( clistFlag & 0x1f ) {
        case 0 :
            strcpy( eventClist, "*LAM2Seq0" );
            break;
        case 1 :
            strcpy( eventClist, "*LAM2Seq1" );
            break;
        case 2 :
            strcpy( eventClist, "*LAM2Seq2" );
            break;
        case 3 :
            strcpy( eventClist, "*LAM2Seq3" );
            break;
        case 4 :
            strcpy( eventClist, "*LAM2Seq4" );
            break;
        case 5 :
            strcpy( eventClist, "*LAM2Seq5" );
            break;
        case 6 :
            strcpy( eventClist, "*LAM2Seq6" );
            break;
        case 7 :
            strcpy( eventClist, "*LAM2Seq7" );
            break;
        case 8 :
            strcpy( eventClist, "*LAM2Seq8" );
            break;
        case 9 :
            strcpy( eventClist, "*LAM2Seq9" );
            break;
        case 10 :
            strcpy( eventClist, "*LAM2Seq10" );
            break;
        case 11 :
            strcpy( eventClist, "*LAM2Seq11" );
            break;
        case 12 :
            strcpy( eventClist, "*LAM2Seq12" );
            break;
        case 13 :
            strcpy( eventClist, "*LAM2Seq13" );
            break;
        case 14 :
            strcpy( eventClist, "*LAM2Seq14" );
            break;
        case 15 :
            strcpy( eventClist, "*LAM2Seq15" );
            break;
        case 16 :
            strcpy( eventClist, "*LAM2Seq16" );
            break;
        case 17 :
            strcpy( eventClist, "*LAM2Seq17" );
            break;
        case 18 :
            strcpy( eventClist, "*LAM2Seq18" );
            break;
        case 19 :
            strcpy( eventClist, "*LAM2Seq19" );
            break;
        case 20 :
            strcpy( eventClist, "*LAM2Seq20" );
            break;
        case 21 :
            strcpy( eventClist, "*LAM2Seq21" );
            break;
        case 22 :
            strcpy( eventClist, "*LAM2Seq22" );
            break;
        case 23 :
            strcpy( eventClist, "*LAM2Seq23" );
            break;
        case 24 :
            strcpy( eventClist, "*LAM2Seq24" );
            break;
        case 25 :
            strcpy( eventClist, "*LAM2Seq25" );
            break;
        case 26 :
            strcpy( eventClist, "*LAM2Seq26" );
            break;
        case 27 :
            strcpy( eventClist, "*LAM2Seq27" );
            break;
        case 28 :
            strcpy( eventClist, "*LAM2Seq28" );
            break;
        case 29 :
            strcpy( eventClist, "*LAM2Seq29" );
            break;
        case 30 :
            strcpy( eventClist, "*LAM2Seq30" );
            break;
        default :
            break;
    }

// return back
    return ( TRUE );

}   // end of LAM2SeqEventBegin()



/****************************************************************************
**
** Name     : MN_T_LAM2TRIGGER()
**
** Function : TRACE menu TRIGGLE item
**
** Notes:
**
****************************************************************************/
int MN_T_LAM2TRIGGER( MFORMPTR TraMenuCopy )
{
LAM2TRIGGER *datap;
WINDOWPTR msgwnp;
DFIELDPTR fldptr1, fldptr2, fldptr3, fldptr4, fldptr5;
MEMOPTR memoptr1, memoptr2;

// link data structure with data form
   VV_ERR = 0;
   datap = &lam2trigger;

// get form from VVD library
   DlgFmPtr = dl_fmget( "LAM2Trigger", datap, usd3dlg, CListMFilePtr, VVDLibp );
   if ( DlgFmPtr == NULLP ) {
      ErrorProc();
      return ( EXITMENU );
   }

// it will be added to show shadow
   ShowShadow( DlgFmPtr->wnp );

// specify messages to the form field
   fldptr1 = (DFIELDPTR) i_namptr( "operation", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr1 );

   fldptr2 = (DFIELDPTR) i_namptr( "trace", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr2 );

   fldptr3 = (DFIELDPTR) i_namptr( "timer", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr3 );

   fldptr4 = (DFIELDPTR) i_namptr( "action", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr4 );

   fldptr5 = (DFIELDPTR) i_namptr( "mode", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr5 );

   memoptr1 = (MEMOPTR) i_namptr( "state", DlgFmPtr );
   sf_msg( FormMsg+1, memoptr1 );

   memoptr2 = (MEMOPTR) i_namptr( "count", DlgFmPtr );
   sf_msg( FormMsg+1, memoptr2 );


// show the message to the status line
   msgwnp = wn_def( vs_rowq()-1, 0, 1, vs_colq(), LMESSAGE, BDR_NULLP );
   wn_up( msgwnp );
   v_st( FormMsg, msgwnp );

// active the data form entry
   pulldown_or_dialog = DIALOG;    // dialog box flag
   retcode = fm_proc( 0, DlgFmPtr );

// inactive the status message and release the memory
   pulldown_or_dialog = PULLDOWN;    // pull-down menu flag
   wn_dn( msgwnp );
   wn_free( msgwnp );
   fm_free( DlgFmPtr );

// leave from dialog box only
    if ( retcode == AC_QUIT ) {
        return ( SAMELEVEL );
    }


// process the input read in the data form

// display the trigger setting
   if ( strstr(strupr(datap->operation),"SHOW")!=NULL &&
        strlen(datap->operation)==strlen("SHOW") ) {
      ExecDlgFlag = 1;
      strcpy( DlgBuf, "Trigger \r" );
      return ( EXITMENU );   //  retcode == AC_EXIT
   }

// clear the trigger
   if ( strstr( strupr(datap->operation), "CLEAR" ) != NULL ) {
        ExecDlgFlag = 1;
        strcpy(DlgBuf, "Trigger CLear \r");
        return ( EXITMENU );   //  retcode == AC_EXIT
   }

// do nothing if Operation field is not SET, SHOW nor CLEAR
    if ( strstr( strupr(datap->operation), "SET" ) == NULL ) {
	DlgBuf[0] = NULL;
	return ( EXITMENU );   //  retcode == AC_EXIT
    }
    else {
        ExecDlgFlag = 1;
        strcpy(DlgBuf, "Trigger ");
    }

// set Trace ON/OFF or TImer ON/OFF
    if ( datap->trace[0]!=NULL || datap->timer[0]!=NULL ) {
        if ( strstr(strupr(datap->trace), "ON")!=NULL &&
            strlen(datap->trace)==strlen("ON") ) {
            strcat(DlgBuf, "Trace ON ");
        }
        else if ( strstr(strupr(datap->trace), "OFF")!=NULL &&
            strlen(datap->trace)==strlen("OFF") ) {
            strcat(DlgBuf, "Trace OFF ");
        }
        if ( strstr(strupr(datap->timer), "ON")!=NULL &&
            strlen(datap->timer)==strlen("ON") ) {
            strcat(DlgBuf, "TImer ON ");
        }
        else if ( strstr(strupr(datap->timer), "OFF")!=NULL &&
            strlen(datap->timer)==strlen("OFF") ) {
            strcat(DlgBuf, "TImer OFF ");
        }
        strcat(DlgBuf, "\r");
        return (EXITMENU);
    }
    else {  // not Trace or TImer setting
        // action is set: RUN; BREAK is default
        if ( strstr(strupr(datap->action), "RUN")!=NULL &&
            strlen(datap->action)==strlen("RUN") ) {
            strcat(DlgBuf, "RUN ");
        }

        // process state field
        if ( datap->state[0] != NULL ) {
            strcat( DlgBuf, datap->state );
            strcat( DlgBuf, " " );
        }
        else {
            DlgBuf[0] = NULL;
            return ( EXITMENU );   //  retcode == AC_EXIT
        }

        // process Trace Mode field
        if ( datap->mode[0] != NULL ) {
            strcat( DlgBuf, datap->mode );
            strcat( DlgBuf, " " );
        }

        // process Delay Count field
        if ( strstr(strupr(datap->mode), "DELAY")!=NULL &&
            strlen(datap->mode)==strlen("DELAY") ) {
            strcat( DlgBuf, datap->count );
            strcat( DlgBuf, " " );
            strcat( DlgBuf, "\r" );
            return (EXITMENU);
        }
        else {
            strcat( DlgBuf, " " );
            strcat( DlgBuf, "\r" );
            return (EXITMENU);
        }
    }

// confirm the quit level
   if ( retcode == AC_EXIT )
      return ( EXITMENU );   // leave from both dialog box and menu
   else if ( retcode == AC_QUIT )
      return ( SAMELEVEL );   // leave from dialog box only

}   // end of MN_T_LAM2TRIGGER()



/****************************************************************************
**
** Name      : LAM2TrigOpEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int LAM2TrigOpEnd( DFORMPTR dfmptr )
{
DFIELDPTR fldptr;   // point to the special field
DFIELDPTR pp;       // point to current field
int curItem;        // ID of the current item
int state;          // flag: skip the current field or not
int i;              // loop controler of for_loop


    curItem = curitemnum( dfmptr );
    fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr );
    fld_get( fldptr->datap, curItem, dfmptr );

    if ( strstr(strupr(fldptr->datap),"SET")!=NULL &&
         strlen(fldptr->datap)==strlen("SET") ) {
        state = OFF;
    }
    else {
        state = ON;
    }

    for ( i = 0; i <= 5; i++ ) {
        pp = (DFIELDPTR) i_numptr( curItem++, dfmptr );
        sf_opt( SKIP, state, pp );
    }

    return (TRUE);

}   // end of LAM2TrigOpEnd()



/****************************************************************************
**
** Name      : LAM2ModeEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int LAM2ModeEnd( DFORMPTR dfmptr )
{
DFIELDPTR fldptr;   // point to the special field
DFIELDPTR pp;       // point to current field
int curItem;        // ID of the current item
int state;          // flag: skip the current field or not
int i ;             // loop controler of for_loop


   curItem = curitemnum( dfmptr );
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr  );
   fld_get( fldptr->datap, curItem, dfmptr );

    if ( strstr(strupr(fldptr->datap),"DELAY")!=NULL &&
         strlen(fldptr->datap)==strlen("DELAY") ) {
        state = OFF;
    }
    else {
        state = ON;
    }

   for ( i = 0; i <= 1; i++ ) {
      pp = (DFIELDPTR) i_numptr( curItem++, dfmptr );
      sf_opt( SKIP, state, pp );
   }

   return ( TRUE );

}   // end of LAM2ModeEnd()



/****************************************************************************
**
** Name      : LAM2TimerEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int LAM2TimerEnd( DFORMPTR dfmptr )
{
DFIELDPTR fldptr1;  // point to the special field
DFIELDPTR fldptr2;  // point to the special field
DFIELDPTR pp;       // point to current field
int nItem1, nItem2; // ID of the items
int state;          // flag: skip the current field or not
int i;              // loop controler of for_loop


// if Trace or TImer is not NULL, skip all the next field
    nItem1 = i_namnum("trace", dfmptr);
    fldptr1 = (DFIELDPTR) i_numptr( nItem1, dfmptr );
    fld_get( fldptr1->datap, nItem1, dfmptr );
    nItem2 = i_namnum("timer", dfmptr);
    fldptr2 = (DFIELDPTR) i_numptr( nItem2, dfmptr );
    fld_get( fldptr2->datap, nItem2, dfmptr );

    if ( strlen(fldptr1->datap)==0 && strlen(fldptr2->datap)==0 ) {
        state = OFF;
    }
    else {
        state = ON;
    }

   for ( i = 0; i <= 4; i++ ) {
      pp = (DFIELDPTR) i_numptr( nItem2++, dfmptr );
      sf_opt( SKIP, state, pp );
   }

   return ( TRUE );

}   // end of LAM2TimerEnd()



/****************************************************************************
**
** Name      : LAM2CountBeg()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
int LAM2CountBeg( DFORMPTR dfmptr )
{
/*
DFIELDPTR fldptr;   // point to the special field
int curItem;        // ID of the current item


    curItem = i_namnum("mode", dfmptr);
    fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr );

    if ( strstr(strupr(fldptr->datap),"DELAY")!=NULL &&
         strlen(fldptr->datap)==strlen("DELAY") ) {
        NULL;
    }
    else {
        curItem = i_namnum("count", dfmptr);
        fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr );
        fld_get( fldptr->datap, curItem, dfmptr );
        sf_opt( SKIP, ON, fldptr );
    }

*/
   return ( TRUE );

}   // end of LAM2CountBeg()





/****************************************************************************
**  The below routines are not ued.
**      Chen 06/17/94
****************************************************************************/

/****************************************************************************
**
** Name      : TriggerSeqEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
/*
int TriggerSeqEnd( DFORMPTR dfmptr )
{

    return ( TRUE );

}   // end of TriggerSeqEnd()
*/



/****************************************************************************
**
** Name      : LAM2ActThenEnd()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
/*
int LAM2ActThenEnd( void )
{
DFIELDPTR fldptr;   // point to the special field


// get the "then" field
   fldptr = (DFIELDPTR) i_numptr( 2, lam2Sequence );
   fld_get( fldptr->datap, 2, lam2Sequence );

// skip the balance field if "then" field is filled
    if ( strlen(fldptr->datap) != 0 && strstr(fldptr->datap," ") == NULL ) {
        fldptr = (DFIELDPTR) i_numptr( 3, lam2Sequence );
        sf_opt( SKIP, ON, fldptr );
        fldptr = (DFIELDPTR) i_numptr( 4, lam2Sequence );
        sf_opt( SKIP, ON, fldptr );
    }

// return back
   return ( TRUE );

}   // end of LAM2ActThenEnd()
*/



/****************************************************************************
**
** Name      : TrigActBegin()
**
** Function  :
**
**    Input  :
**
**    Output :
**
** Notes     :
**
****************************************************************************/
/*
int TrigActBegin( DFORMPTR dfmptr )
{
WINDOWPTR msgwnp;
int curItem;
unsigned char tempAct[21];
DFIELDPTR resetPtr, runPtr, thenPtr, ifPtr, elsePtr;
static unsigned char run[2], reset[2], then1[2], if1[2], else1[2];
CLISTPTR thenClstp, ifClstp, elseClstp;


// get the current field number of the previous form
    curItem = curitemnum( dfmptr );

// initialize the data array
//    memset( run, NULL, sizeof(run) );
//    memset( reset, NULL, sizeof(reset) );
//    memset( then1, NULL, sizeof(then1) );
//    memset( if1, NULL, sizeof(if1) );
//    memset( else1, NULL, sizeof(else1) );
    memset( tempAct, NULL, sizeof(tempAct) );

// define data form
    lam2Sequence = fm_def( 12, 28, 9, 30, LFORMS, BDR_DLNP );
    if ( lam2Sequence == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

// set the special flag
    lam2SeqFlag = TRUE;

// close the VERIFYQUIT option
    sfm_opt( VERIFYQUIT, OFF, lam2Sequence );

// define the title
    sw_title( " ACTION ", LFORMS, TOPCENTER, lam2Sequence->wnp );

// draw the background text
    bg_txtdef( 1,  4, "Run :  ",      LFORMS, lam2Sequence );
    bg_txtdef( 1, 16, "Reset :  ",    LFORMS, lam2Sequence );
    bg_txtdef( 3,  4, "Arm :  THEN ", LFORMS, lam2Sequence );
    bg_txtdef( 5,  4, "Arm :  IF  ",  LFORMS, lam2Sequence );
    bg_txtdef( 5, 18, "ELSE  ",       LFORMS, lam2Sequence );

// define the data field
    runPtr = fld_def( 1, 11, NULLP, FADJACENT, "!", F_BOOL,
                      run, lam2Sequence );
    if ( runPtr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    resetPtr = fld_def( 1, 24, NULLP, FADJACENT, "!", F_BOOL,
                        reset, lam2Sequence );
    if ( resetPtr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    thenPtr = fld_def( 3, 16, NULLP, FADJACENT, "9", F_STRING,
                       then1, lam2Sequence );
    if ( thenPtr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    ifPtr = fld_def( 5, 15, NULLP, FADJACENT, "9", F_STRING,
                     if1, lam2Sequence );
    if ( ifPtr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

    elsePtr = fld_def( 5, 24, NULLP, FADJACENT, "9", F_STRING,
                       else1, lam2Sequence );
    if ( elsePtr == NULLP ) {
        ErrorProc();
        return ( EXITMENU );
    }

//  set the field option
    sf_opt( CLEARONKEY, ON, runPtr );
    sf_opt( CLEARONKEY, ON, resetPtr );
    sf_opt( CLEARONKEY, ON, thenPtr );
    sf_opt( CLEARONKEY, ON, ifPtr );
    sf_opt( CLEARONKEY, ON, elsePtr );
//    sf_opt( INITIALBLANKS, OFF, runPtr );
//    sf_opt( INITIALBLANKS, OFF, resetPtr );
//    sf_opt( INITIALBLANKS, OFF, thenPtr );
//    sf_opt( INITIALBLANKS, OFF, ifPtr );
//    sf_opt( INITIALBLANKS, OFF, elsePtr );

// define field act/inact color
    sf_attact( LFLDACTON, runPtr );
    sf_attinact( LFLDACTOFF, runPtr );
    sf_attact( LFLDACTON, resetPtr );
    sf_attinact( LFLDACTOFF, resetPtr );
    sf_attact( LFLDACTON, thenPtr );
    sf_attinact( LFLDACTOFF, thenPtr );
    sf_attact( LFLDACTON, ifPtr );
    sf_attinact( LFLDACTOFF, ifPtr );
    sf_attact( LFLDACTON, elsePtr );
    sf_attinact( LFLDACTOFF, elsePtr );

// define field help message
    sf_help( "*LAM2ActionRun", runPtr );
    sf_help( "*LAM2ActionReset", resetPtr );
    sf_help( "*LAM2ActionThen", thenPtr );
    sf_help( "*LAM2ActionIf", ifPtr );
    sf_help( "*LAM2ActionElse", elsePtr );

// define boolean field character and indicated string
    sf_boolch( 'y', 'n', runPtr );
    sf_boolch( 'y', 'n', resetPtr );
    sf_booltoggle( "", " ", LFLDACTOFF, LFLDACTOFF, runPtr );
    sf_booltoggle( "", " ", LFLDACTOFF, LFLDACTOFF, resetPtr );

// define begin function for Event field
    sf_endfp( LAM2ActThenEnd, thenPtr );

// define choice list for the Logic field
    if ( !sf_clist( "*LAM2TrigAction", CLAUTOMOVE|CLCHSELECT|CLWRAP,
                    CListMFilePtr, thenPtr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, thenPtr->clistp );
    scl_attact( LFLDACTON, thenPtr->clistp );
    sw_bdratt( LFLDACTOFF, thenPtr->clistp->wnp );

    if ( !sf_clist( "*LAM2TrigAction", CLAUTOMOVE|CLCHSELECT|CLWRAP,
                    CListMFilePtr, ifPtr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, ifPtr->clistp );
    scl_attact( LFLDACTON, ifPtr->clistp );
    sw_bdratt( LFLDACTOFF, ifPtr->clistp->wnp );

    if ( !sf_clist( "*LAM2TrigAction", CLAUTOMOVE|CLCHSELECT|CLWRAP,
                    CListMFilePtr, elsePtr ) ) {
        ErrorProc();
        return ( EXITMENU );
    }
    scl_attinact( LFLDACTOFF, elsePtr->clistp );
    scl_attact( LFLDACTON, elsePtr->clistp );
    sw_bdratt( LFLDACTOFF, elsePtr->clistp->wnp );

// specify messages to the form field
   sf_msg( BoolFldMsg+1, runPtr );
   sf_msg( BoolFldMsg+1, resetPtr );
   sf_msg( TFormMsg+1, thenPtr );
   sf_msg( TFormMsg+1, ifPtr );
   sf_msg( TFormMsg+1, elsePtr );

// define the status line message
    msgwnp = wn_def( vs_rowq()-1, 0, 1, vs_colq(), LMESSAGE, BDR_NULLP );
    wn_up( msgwnp );
    v_st( BoolFldMsg+1, msgwnp );

// process the form
    retcode = fm_proc( 0, lam2Sequence );

// destroy the form
    wn_dn( msgwnp );
    wn_free( msgwnp );
    fm_free( lam2Sequence );

// reset the special flag
    lam2SeqFlag = FALSE;

// accept the input data
    if ( retcode == AC_EXIT ) {
        if ( run != FALSE ) {
            strcat( tempAct, "Run" );
            strcat( tempAct, " " );
        }
        if ( reset != FALSE ) {
            strcat( tempAct, "Reset" );
            strcat( tempAct, " " );
        }
        if ( then1[0] != NULL ) {
            strcat( tempAct, "Arm" );
            strcat( tempAct, " " );
            strcat( tempAct, "{" );
            strcat( tempAct, then1 );
            strcat( tempAct, "}" );
            strcat( tempAct, " " );
        }
        else if ( if1[0] != NULL ) {
            strcat( tempAct, "Arm" );
            strcat( tempAct, " " );
            strcat( tempAct, "{" );
            strcat( tempAct, if1 );
            if ( else1[0] != NULL ) {
                strcat( tempAct, "," );
                strcat( tempAct, else1 );
            }
            strcat( tempAct, "}" );
            strcat( tempAct, " " );
        }
        fld_upd( tempAct, curItem, dfmptr );
        sfm_nextitem( AC_NEXTITEM, dfmptr );
    }
    else if ( retcode == AC_QUIT ) {
        sfm_nextitem( AC_NEXTITEM, dfmptr );
        return ( TRUE );
    }

// transform data to the previous data structure
    strcpy( lam2trigger.lam2action, tempAct );

// return back
    return ( TRUE );

}   // end of TrigActBegin()
*/



/****************************************************************************
**
** Name     : MN_T_LAM2TRIGGER()
**
** Function : TRACE menu TRIGGLE item
**
** Notes:
**
****************************************************************************/
/*
int MN_T_LAM2TRIGGER( MFORMPTR TraMenuCopy )
{
LAM2TRIGGER *datap;
WINDOWPTR msgwnp;
DFIELDPTR fldptr1, fldptr2, fldptr3, fldptr4, fldptr5;
MEMOPTR memoptr1, memoptr2, memoptr3;

// link data structure with data form
   VV_ERR = 0;
   datap = &lam2trigger;

// get form from VVD library
   DlgFmPtr = dl_fmget( "LAM2Trigger", datap, usd3dlg, CListMFilePtr, VVDLibp );
   if ( DlgFmPtr == NULLP ) {
      ErrorProc();
      return ( EXITMENU );
   }

// it will be added to show shadow
   ShowShadow( DlgFmPtr->wnp );

// specify messages to the form field
   fldptr1 = (DFIELDPTR) i_namptr( "levelno", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr1 );

   fldptr2 = (DFIELDPTR) i_namptr( "operation", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr2 );

   fldptr3 = (DFIELDPTR) i_namptr( "timer", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr3 );

   fldptr4 = (DFIELDPTR) i_namptr( "trace", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr4 );

   fldptr5 = (DFIELDPTR) i_namptr( "mode", DlgFmPtr );
   sf_msg( TFormMsg+1, fldptr5 );

   memoptr1 = (MEMOPTR) i_namptr( "eventseq", DlgFmPtr );
   sf_msg( FormMsg+1, memoptr1 );

   memoptr2 = (MEMOPTR) i_namptr( "lam2action", DlgFmPtr );
   sf_msg( FormMsg+1, memoptr2 );

   memoptr3 = (MEMOPTR) i_namptr( "count", DlgFmPtr );
   sf_msg( FormMsg+1, memoptr3 );

// show the message to the status line
   msgwnp = wn_def( vs_rowq()-1, 0, 1, vs_colq(), LMESSAGE, BDR_NULLP );
   wn_up( msgwnp );
   v_st( FormMsg, msgwnp );

// active the data form entry
   pulldown_or_dialog = DIALOG;    // dialog box flag
   retcode = fm_proc( 0, DlgFmPtr );

// inactive the status message and release the memory
   pulldown_or_dialog = PULLDOWN;    // pull-down menu flag
   wn_dn( msgwnp );
   wn_free( msgwnp );
   fm_free( DlgFmPtr );

// leave from dialog box only
    if ( retcode == AC_QUIT ) {
        return ( SAMELEVEL );
    }


// process the input read in the data form
// set the trigger number
    if ( (datap->levelno[0] >= '1') && (datap->levelno[0] <= '8') ) {
        ExecDlgFlag = 1;
        strcpy( DlgBuf, "Trigger " );
        strcat( DlgBuf, datap->levelno );
        strcat( DlgBuf, " " );
    }
    else {
        return ( EXITMENU );   //  retcode == AC_EXIT
    }

// clear the trigger
   if ( strstr( datap->operation, "Clear" ) != NULL ) {
      strcat( DlgBuf, "CLear \r " );
      return ( EXITMENU );   //  retcode == AC_EXIT
   }

// do nothing if Operation field is not CLEAR nor SET
    if ( strstr( datap->operation, "Set" ) == NULL ) {
	DlgBuf[0] = NULL;
	return ( EXITMENU );   //  retcode == AC_EXIT
    }

// process Event Sequence field
    if ( datap->eventseq[0] != NULL ) {
        strcat( DlgBuf, datap->eventseq );
        strcat( DlgBuf, " " );
    }
//    else {
//        DlgBuf[0] = NULL;
//        return ( EXITMENU );   //  retcode == AC_EXIT
//    }

// process Action field
    if ( datap->lam2action[0] != NULL ) {
        strcat( DlgBuf, datap->lam2action );
        strcat( DlgBuf, " " );
    }

// process Timer field
    if ( strstr(datap->timer,"ON") != NULL ) {
        strcat( DlgBuf, "TMON" );
        strcat( DlgBuf, " " );
    }
    else if ( strstr(datap->timer,"OFF") != NULL ) {
        strcat( DlgBuf, "TMOFF" );
        strcat( DlgBuf, " " );
    }

// process Trace field
    if ( strstr(datap->trace,"ON") != NULL ) {
        strcat( DlgBuf, "TRON" );
        strcat( DlgBuf, " " );
    }
    else if ( strstr(datap->trace,"OFF") != NULL ) {
        strcat( DlgBuf, "TROFF" );
        strcat( DlgBuf, " " );
    }

// process Trace Mode field
    if ( datap->mode[0] != NULL ) {
        strcat( DlgBuf, datap->mode );
        strcat( DlgBuf, " " );
    }

// process Delay Count field
    if ( strstr(datap->mode,"Delay") == NULL ) {
        strcat( DlgBuf, " \r" );
        return ( EXITMENU );
    }
    else {
        strcat( DlgBuf, datap->count );
        strcat( DlgBuf, " " );
        strcat( DlgBuf, "\r" );
        return ( EXITMENU );
    }


// confirm the quit level
   if ( retcode == AC_EXIT )
      return ( EXITMENU );   // leave from both dialog box and menu
   else if ( retcode == AC_QUIT )
      return ( SAMELEVEL );   // leave from dialog box only

}   // end of MN_T_LAM2TRIGGER()
*/

/* added by liu for LSA */

CCOperationEnd(dummyptr)
DFORMPTR  dummyptr;
{
	DFIELDPTR fldptr;
	DFIELDPTR   memop;
	int curitem;

	curitem = curitemnum(DlgFmPtr);
	fldptr  = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
	fld_get(fldptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
	if (*((UCHAR *)(fldptr->datap)) == FALSE) {  // if op fld == clear
		memop =  (DFIELDPTR)i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP, ON, memop);
		memop =  (DFIELDPTR)i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP, ON, memop);
	} else {
		memop =  (DFIELDPTR)i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP, OFF, memop);
		memop =  (DFIELDPTR)i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP, OFF, memop);
	}
	return(TRUE);
}

/****************************** End of File ******************************/

