/***************************************************************************
**
** File name : menu3.c
**
** This file includes the routines for processing the SYMBOL, OPTION, SPA,
** and LSA pulldown menus.
**
** Changing :
**
** A. Date -- 10/20/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/22/1992 By Cheerson
**     0.
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "menu.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "dialog.h"
#include  "dlgext.h"
#include  "funcdecl.h"
#include  "funcext.h"


/**************************************************************************
**
** Local define
**
***************************************************************************/

#define PULLDOWN   1
#define DIALOG      2


/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int pulldown_or_dialog;
extern FUNCLIS usd3dlg[];
extern char FormMsg[]       ;
extern char TFormMsg[]      ;
extern char BoolFldMsg[]    ;
extern char chListMsg[]    ;
extern int retcode;
extern int F2Control();
extern MFILEPTR tmpMFile;


/**************************************************************************
**
** Local variables
**
***************************************************************************/

UCHAR selection[DATBUFROW];
UCHAR GblDlgColor[3]= { catt_def(0xe,0x1),   // LFORMS     yellow on blue
              catt_def(0x1,0xe),   // LFLDACTON  blue on yellow
              catt_def(0xe,0x3) };   // LFLDACTOFF yellow on cyan
UCHAR GblDlgMono[3]  = { NORMAL,              // LFORMS
               REVERSE,      // LFLDACTON
               UNDERLINE };           // LFLDACTOFF

int   Entry_Duration_Time_Cover_Lsa = 0; // added by liu for test

/**************************************************************************

**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : MN_Y_LIST( SymMenuCopy )
**
** Function : SYMBOL menu List menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_LIST(MFORMPTR   SymMenuCopy )
{
   YLIST *datap;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;

   datap = &ylist;
   VV_ERR = 0;
   DlgFmPtr = dl_fmget("YList",datap,usd3dlg,CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   fldptr = (DFIELDPTR) i_namptr("mname",DlgFmPtr);
   sf_msg(FormMsg+1,fldptr);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(TFormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->option[0] != '\0') {
         ExecDlgFlag = 1;
         strcat(DlgBuf,"SYM ");
         if (strstr(strupr(datap->option),"MODULE") != NULL) {
            if (datap->mname[0] != '\0') {
               strcat(DlgBuf,"%%");
               strcat(DlgBuf,datap->mname);
            }
         }
         else strcat(DlgBuf,datap->option);
         strcat(DlgBuf,"\r");
      }
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_LIST()  */

/**************************************************************************
**
** Name : YListOpEnd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
YListOpEnd(DFORMPTR dfmptr)
{
 DFIELDPTR fldptr, pp;
 int curItem, state, i;

   curItem = curitemnum(dfmptr);
   fldptr = (DFIELDPTR) i_numptr( curItem, dfmptr);
   fld_get(fldptr->datap,curItem, dfmptr );
   pp = (DFIELDPTR) i_numptr( ++curItem, dfmptr  );
   sf_opt(SKIP, strstr(strupr(fldptr->datap), "MODULE") ? OFF : ON, pp);
   return(TRUE);
}     /* end of YListOpEnd(dfmptr)  */
/**************************************************************************
**
** Name : MN_Y_LOAD( SymMenuCopy )
**
** Function : SYMBOL menu Load menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_LOAD(MFORMPTR   SymMenuCopy )
{
   YLOAD *datap;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;
   KEYFP tmpF2;

   datap = &yload;
   VV_ERR = 0;
   DlgFmPtr = dl_fmget("YLoad",datap,usd3dlg,CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
   if (!(datap->filename[0])) strcpy( datap->filename, "*.USD" );
/* else {
      if ((strstr(datap->filename, "*") != NULL) ||
          (strstr(datap->filename, "?") != NULL)) {
         fldptr = (DFIELDPTR) i_namptr("filename",DlgFmPtr);
         sf_msg(chListMsg+1,fldptr);
      }
   }  */

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcat(DlgBuf,"LOA ");
         strcat(DlgBuf,datap->filename);
         strcat(DlgBuf,"\r");
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_LOAD()  */

/**************************************************************************
**
** Name : MN_Y_CREATE( SymMenuCopy )
**
** Function : SYMBOL menu Create menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_CREATE(MFORMPTR  SymMenuCopy )
{
   YCREATE *datap;
   WINDOWPTR msgwnp;
   char *ptr;

   VV_ERR = 0;
   datap = &ycreate;
   DlgFmPtr = dl_fmget("YCreate",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if ((datap->symname[0] != '\0') &&
          (datap->addr[0] != '\0')) {
         ExecDlgFlag = 1;
         strcat(DlgBuf,"CR ");
         if ((ptr=strchr(datap->symname,'%')) != NULL)
            strcat(DlgBuf,datap->symname);
         else  {
            strcat(DlgBuf,"%");
            strcat(DlgBuf,datap->symname);
         }
         strcat(DlgBuf," ");
         strcat(DlgBuf,datap->addr);
         strcat(DlgBuf,"\r");
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_CREATE()  */

/**************************************************************************
**
** Name : MN_Y_DELETE( SymMenuCopy )
**
** Function :  SYMBOL menu Delete menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_DELETE(MFORMPTR  SymMenuCopy )
{
   YDELETE *datap;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;
   int i;
   char *ptr;

   VV_ERR = 0;
   datap = &ydelete;
   if (addinx > 0) {
      tmpMFile = mf_def(addinx+3,41);
      if (tmpMFile == NULLP) {
         ErrorProc();
         return(EXITMENU);
      }
   }
   DlgFmPtr = dl_fmget("YDelete",datap,NULLP,tmpMFile,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      mf_free(tmpMFile);
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
   if (addinx > 0) {
      mf_rowins("*DelSymbol",APPEND_ROW,tmpMFile);
             for (i=0; i < addinx; i++) mf_rowins(addtable[i].name,APPEND_ROW,tmpMFile);
      fldptr = (DFIELDPTR) i_namptr("symname",DlgFmPtr);
      sf_clist("*DelSymbol",CLWRAP|CLAUTOMOVE,tmpMFile,fldptr);
      scl_attinact(LFLDACTOFF,fldptr->clistp);
      scl_attact(LFLDACTON,fldptr->clistp);
      sw_bdratt(LFLDACTOFF,fldptr->clistp->wnp);
      scl_help("*symname",fldptr->clistp);
      if (addinx > 13) sw_sb(AUTOUPD,VSBAR,fldptr->clistp->wnp);
   }

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st( chListMsg, msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);
   if (addinx > 0)  mf_free(tmpMFile);

   if (retcode == AC_EXIT)  {
      if (datap->symname[0] != '\0') {
         ExecDlgFlag = 1;
         strcat(DlgBuf,"DEL ");
         if ((ptr=strchr(datap->symname,'%')) != NULL)
            strcat(DlgBuf,datap->symname);
         else  {
            strcat(DlgBuf,"%");
            strcat(DlgBuf,datap->symname);
         }
         strcat(DlgBuf,"\r");
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_DELETE()  */

/**************************************************************************
**
** Name : MN_Y_MODULE( SymMenuCopy )
**
** Function : SYMBOL menu Module menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_MODULE(MFORMPTR  SymMenuCopy )
{
   ExecDlgFlag = 1;
   strcat(DlgBuf,"MODU\r");
   return( EXITMENU );

}  /*  of MN_Y_MODULE()  */

/**************************************************************************
**
** Name : MN_Y_SSAVE( SymMenuCopy )
**
** Function : SYMBOL menu SSAVE   menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_SSAVE(MFORMPTR  SymMenuCopy )
{
   YSSAVE *datap;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;
   KEYFP tmpF2;

   VV_ERR = 0;
   datap = &yssave;
   DlgFmPtr = dl_fmget("YSsave",datap,usd3dlg,CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
   if (!(datap->filename[0])) strcpy( datap->filename, "*.*" );
/* else {
      if ((strstr(datap->filename, "*") != NULL) ||
          (strstr(datap->filename, "?") != NULL)) {
         fldptr = (DFIELDPTR) i_namptr("filename",DlgFmPtr);
         sf_msg(chListMsg+1,fldptr);
      }
   } */

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st( FormMsg, msgwnp );
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcat(DlgBuf,"SS ");
         strcat(DlgBuf,datap->filename);
         strcat(DlgBuf,"\r");
      }
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_SSAVE()  */

/**************************************************************************
**
** Name : MN_Y_SRECALL( SymMenuCopy )
**
** Function : SYMBOL menu SRECALL   menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_SRECALL(MFORMPTR  SymMenuCopy )
{
   YSRECALL *datap;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;
   KEYFP tmpF2;

   VV_ERR = 0;
   datap = &ysrecall;
   DlgFmPtr = dl_fmget("YSrecall",datap,usd3dlg,CListMFilePtr,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);
   if (!(datap->filename[0])) strcpy( datap->filename, "*.*" );
/* else {
      if ((strstr(datap->filename, "*") != NULL) ||
          (strstr(datap->filename, "?") != NULL)) {
         fldptr = (DFIELDPTR) i_namptr("filename",DlgFmPtr);
         sf_msg(chListMsg+1,fldptr);
      }
   } */
   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   tmpF2 = kt_rplkey(KEY_F2,(KEYFP)F2Control, FMKTP);
   retcode = fm_proc(0,DlgFmPtr);
   kt_rplkey(KEY_F2,(KEYFP)tmpF2, FMKTP);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->filename[0] != '\0') {
         ExecDlgFlag = 1;
         strcat(DlgBuf,"SR ");
         strcat(DlgBuf,datap->filename);
         strcat(DlgBuf,"\r");
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_SRECALL()  */

/**************************************************************************
**
** Name : MN_Y_SYMBOL( SymMenuCopy )
**
** Function : SYMBOL menu Symbol Query menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_SYMBOL(MFORMPTR SymMenuCopy )
{
   YSYMBOL *datap;
   WINDOWPTR msgwnp;
   char *ptr;

   VV_ERR = 0;
   datap = &ysymbol;
   DlgFmPtr = dl_fmget("YSymbol",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->symname[0] != '\0') {
         ExecDlgFlag = 1;
         strcat(DlgBuf,"QUE ");
         if ((ptr=strchr(datap->symname,'%')) != NULL)
            strcat(DlgBuf,datap->symname);
         else  {
            strcat(DlgBuf,"%");
            strcat(DlgBuf,datap->symname);
         }
         strcat(DlgBuf,"\r");
      }
   }
   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_SYMBOL()  */

/**************************************************************************
**
** Name : MN_Y_ADDRESS( SymMenuCopy )
**
** Function : SYMBOL menu Address Query menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_Y_ADDRESS(MFORMPTR SymMenuCopy )
{
   YADDRESS *datap;
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   datap = &yaddress;
   DlgFmPtr = dl_fmget("YAddress",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->addr[0] != '\0') {
         ExecDlgFlag = 1;
         strcat(DlgBuf,"QUE ");
         strcat(DlgBuf,datap->addr);
         strcat(DlgBuf,"\r");
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_ADDRESS()  */

/**************************************************************************
**
** Name : MN_O_TOGGLE( OptMenuCopy )
**
** Function : OPTIONS menu Toggle-Status dialog box
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_O_TOGGLE(MFORMPTR OptMenuCopy )
{
   OTOGGLE *datap,oset;
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;

   VV_ERR = 0;
   datap = &otoggle;
   memset(datap,NULL,sizeof(otoggle));
   DlgFmPtr = dl_fmget("OToggle",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   if (sym_flag == 1)                   datap->symbol  = oset.symbol   = TRUE;
   if ((cmd_flag == 1) || (menu_flag))  datap->log     = oset.log      = TRUE;
   if (out_flag == 1)                   datap->journal = oset.journal  = TRUE;
   if (noRAM == 0)                      datap->swbp    = oset.swbp     = TRUE;
   if (caseFlag == 1)                   datap->caseFlag= oset.caseFlag = TRUE;

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (datap->symbol != oset.symbol) {
         ExecDlgFlag = 1;
         if (datap->symbol == TRUE) strcat(DlgBuf,"OP S O\r");
         else strcat(DlgBuf,"OP S OF\r");
      }
      if (datap->log != oset.log) {
         ExecDlgFlag = 1;
         if (datap->log == TRUE) strcat(DlgBuf,"OP L O\r");
         else strcat(DlgBuf,"OP L OF\r");
      }
      if (datap->journal != oset.journal) {
         ExecDlgFlag = 1;
         if (datap->journal == TRUE) strcat(DlgBuf,"OP J O\r");
         else                        strcat(DlgBuf,"OP J OF\r");
      }
      if (datap->swbp != oset.swbp) {
         if (datap->swbp == TRUE) strcat(DlgBuf,"OP B ON\r");
         else strcat(DlgBuf,"OP B OF\r");
         ExecDlgFlag = 1;
      }
      if (datap->caseFlag != oset.caseFlag) {
         if (datap->caseFlag == TRUE) strcat(DlgBuf,"OP C ON\r");
         else strcat(DlgBuf,"OP C OF\r");
         ExecDlgFlag = 1;
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}         /* end of MN_O_TOGGLE( OptMenuCopy ) */

/**************************************************************************
**
** Name : MN_O_UPDATE( OptMenuCopy )
**
** Function : OPTIONS menu Update Viewport menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_O_UPDATE(MFORMPTR  OptMenuCopy )
{
   OUPDATE *datap,ostatus;
   UCHAR upd[3];
   WINDOWPTR msgwnp;
   DFIELDPTR fldptr;

   VV_ERR = 0;
   datap = &oupdate;
   DlgFmPtr = dl_fmget("OUpdate",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   if (!(MaskRedrawFlag&REDRAWBRE)) ostatus.bp    = datap->bp    = TRUE;
   else                             ostatus.bp    = datap->bp    = FALSE;
   if (!(MaskRedrawFlag&REDRAWCOD)) ostatus.code  = datap->code  = TRUE;
   else                             ostatus.code  = datap->code  = FALSE;
   if (!(MaskRedrawFlag&REDRAWREG)) ostatus.reg   = datap->reg   = TRUE;
   else                             ostatus.reg   = datap->reg   = FALSE;
   if (!(MaskRedrawFlag&REDRAWSTA)) ostatus.stack = datap->stack = TRUE;
   else                             ostatus.stack = datap->stack = FALSE;
   if (!(MaskRedrawFlag&REDRAWTRA)) ostatus.trace = datap->trace = TRUE;
   else                             ostatus.trace = datap->trace = FALSE;
   if (!(MaskRedrawFlag&REDRAWDAT)) ostatus.data  = datap->data  = TRUE;
   else                             ostatus.data  = datap->data  = FALSE;

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT)  {
      if (ostatus.bp != datap->bp) {
         if (datap->bp == TRUE)    strcat(DlgBuf,"UPD B O\r");
         else strcat(DlgBuf,"UPD B OF\r");
         ExecDlgFlag = 1;
      }
      if (ostatus.code != datap->code) {
         if (datap->code == TRUE) strcat(DlgBuf,"UPD C O\r");
         else strcat(DlgBuf,"UPD C OF\r");
         ExecDlgFlag = 1;
      }
      if (ostatus.reg != datap->reg) {
         if (datap->reg == TRUE) strcat(DlgBuf,"UPD R O\r");
         else strcat(DlgBuf,"UPD R OF\r");
         ExecDlgFlag = 1;
      }
      if (ostatus.stack != datap->stack) {
         if (datap->stack == TRUE) strcat(DlgBuf,"UPD S O\r");
         else strcat(DlgBuf,"UPD S OF\r");
         ExecDlgFlag = 1;
      }
      if (ostatus.trace != datap->trace) {
         if (datap->trace == TRUE) strcat(DlgBuf,"UPD T O\r");
         else strcat(DlgBuf,"UPD T OF\r");
         ExecDlgFlag = 1;
      }
      if (ostatus.data != datap->data) {
         if (datap->data == TRUE) strcat(DlgBuf,"UPD D O\r");
         else strcat(DlgBuf,"UPD D OF\r");
         ExecDlgFlag = 1;
      }
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_O_UPDATE()  */

/**************************************************************************
**
** Name : MN_O_DEFINE( OptMenuCopy )
**
** Function : OPTIONS menu Define Softkey menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int nSaveSoftkey = TRUE;    // added by Chen, 07/15/94 ; used in INIT.C,
// save the softkey definitions after exiting the DEFINE menu item.
MN_O_DEFINE(MFORMPTR OptMenuCopy )
{
   WINDOWPTR msgwnp;

   VV_ERR = 0;
   DlgFmPtr = dl_fmget("ODefine",(ODEFINE *)SoftKeyBuf[0],NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(FormMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

    // added by Chen, 07/15/94
    if ( retcode == AC_EXIT && nSaveSoftkey == TRUE ) {
        strcpy(DlgBuf, "USave Softkey \r");
        ExecDlgFlag = 1;
    }
    else {
        nSaveSoftkey == TRUE;
        ExecDlgFlag = 0;
    }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_O_DEFINE()  */

/**************************************************************************
**
** Name : MN_O_USAVE( OptMenuCopy )
**
** Function :  OPTIONS menu Usave menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_O_USAVE(MFORMPTR  OptMenuCopy )
{
   WINDOWPTR msgwnp;
   OUSAVE *datap;

   VV_ERR = 0;
   datap = &ousave;
   DlgFmPtr = dl_fmget("OUsave",datap,NULLP,NULLP,VVDLibp);
    if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;
   wn_dn(msgwnp);
   wn_free(msgwnp);
   fm_free(DlgFmPtr);

   if (retcode == AC_EXIT) {
      ExecDlgFlag = 1;
      if ((datap->screen == TRUE) && (datap->softkey == TRUE))
         strcat(DlgBuf,"US\r");
      else if ((datap->screen == TRUE) && (datap->softkey == FALSE))
         strcat(DlgBuf,"US W\r");
      else if ((datap->screen == FALSE) && (datap->softkey == TRUE))
         strcat(DlgBuf,"US S\r");
      else ExecDlgFlag = 0;
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_O_USAVE()  */

/**************************************************************************
**
** Name : MN_O_URECALL( OptMenuCopy )
**
** Function :  OPTIONS menu Urecall menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_O_URECALL(MFORMPTR  OptMenuCopy )
{
   WINDOWPTR msgwnp;
   OURECALL *datap;

   VV_ERR = 0;
   datap = &ourecall;
   DlgFmPtr = dl_fmget("OUrecall",datap,NULLP,NULLP,VVDLibp);
   if (DlgFmPtr == NULLP) {
      ErrorProc();
      return(EXITMENU);
   }
   ShowShadow(DlgFmPtr->wnp);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st(BoolFldMsg,msgwnp);
   pulldown_or_dialog = DIALOG;
   retcode = fm_proc(0,DlgFmPtr);
   pulldown_or_dialog = PULLDOWN;

   if (retcode == AC_EXIT) {
      ExecDlgFlag = 1;
      if ((datap->screen == TRUE) && (datap->softkey == TRUE))
         strcat(DlgBuf,"UR\r");
      else if ((datap->screen == TRUE) && (datap->softkey == FALSE))
         strcat(DlgBuf,"UR W\r");
      else if ((datap->screen == FALSE) && (datap->softkey == TRUE))
         strcat(DlgBuf,"UR S\r");
      else ExecDlgFlag = 0;
   }

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_O_URECALL()  */

/**************************************************************************
**
** Name : MN_O_DLGCOLOR( OptMenuCopy )
**
** Function :  OPTIONS menu dialog color menu-item
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

MN_O_DLGCOLOR(MFORMPTR   OptMenuCopy )
{
   UCHAR curset[3],curmon[3],curstr[2][2];
   UCHAR atttbl[256][2],attary[256];
   UCHAR fg,bg,att[3];
   int mono,keyin,i,j,curfld=0,currow=3;
   WINDOWPTR msgwnp,cwnp;

// get the original values from USD3.SAV or USD3DLG.LIB
   strcpy(curstr[0],"");
   strcpy(curstr[1]," ");
   memcpy(curset,GblDlgColor,3);
   memcpy(curmon,GblDlgMono,3);

   for (i=0; i < 16; i++) {    // background
      if ((j=(i%3)) == 0) bg = NORMAL;
      else if (j == 1)    bg = UNDERLINE;
      else if (j == 2)    bg = REVERSE;
      for (j=0; j < 16; j++)  {    // foreground
         if ((mono=(j%4)) == 0)   fg = 0;
         else if (mono == 1)      fg = HIGH_INT;
         else if (mono == 2)      fg = BLINK;
         else if (mono == 3)      fg = BLINK|HIGH_INT;
         atttbl[i*16+j][0] = (bg|fg);
         atttbl[i*16+j][1] = catt_def(j,i);
      }
   }

   if (vid_getmode() == MONO) {
    i = 0;  memcpy(att,curmon,3);
   } else { i = 1; memcpy(att,curset,3);
   }
   latt_init(i,256,2,atttbl[0],attary);

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st("<>/<> change field, <F9> foreground color, <F10> background color, <CR> exit",msgwnp);

   cwnp = wn_def(4,18,11,45,curset[0],BDR_DLNP);
   sw_latt(attary,cwnp);
   sw_title(" CHANGING DIALOG BOX COLOR ",curset[0],TOPCENTER,cwnp);
   wn_up(cwnp);
   v_stattnop(1,5,"Changing colors for ...",curset[0],22,STATT,cwnp);
   v_stattnop(3,9,curstr[0],curset[0],2,STATT,cwnp);
   v_stattnop(3,12," text including border  ",curset[0],24,STATT,cwnp);
   v_stattnop(5,12,"  text in active field  ",curset[1],24,STATT,cwnp);
   v_stattnop(7,12," text in inactive field ",curset[2],24,STATT,cwnp);
   bg = (curset[0] & 0xf0) >> 4;
   fg = curset[0] & 0x0f;
   i = 0;
   retcode = 5;
   while (1) {
      keyin = DialogColorKi(cwnp, &curfld);
      switch (keyin) {
         case 0x30:
            v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
            curfld = 0;
            currow = 3;
            v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
            bg = (curset[curfld] & 0xf0) >> 4;
            fg = curset[curfld] & 0x0f;
            break;
         case 0x31:
            v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
            curfld = 1;
            currow = 5;
            v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
            bg = (curset[curfld] & 0xf0) >> 4;
            fg = curset[curfld] & 0x0f;
            break;
         case 0x32:
            v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
            curfld = 2;
            currow = 7;
            v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
            bg = (curset[curfld] & 0xf0) >> 4;
            fg = curset[curfld] & 0x0f;
            break;
         case KEY_DN:
DnArrowKey:
            v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
            curfld++;
            if (curfld == 3) curfld = 0;
            if (curfld == 0) currow = 3;
            else if (curfld == 1)  currow = 5;
            else if (curfld == 2)  currow = 7;
            v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
            bg = (curset[curfld] & 0xf0) >> 4;
            fg = curset[curfld] & 0x0f;
            break;
         case KEY_UP:
            v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
            curfld--;
            if (curfld < 0 ) curfld = 2;
            if (curfld == 0) currow = 3;
            else if (curfld == 1)  currow = 5;
            else if (curfld == 2)  currow = 7;
            v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
            bg = (curset[curfld] & 0xf0) >> 4;
            fg = curset[curfld] & 0x0f;
            break;
         case KEY_F9:
               fg++;
            if (fg > 15) fg = 0;
            curset[curfld] = catt_def(fg,bg);
            if (vid_getmode() == MONO)
               curmon[curfld] = atttbl[curset[curfld]][0];
            if (curfld == 0) {
               sw_att(curset[0],cwnp);
               sw_bdratt(curset[0],cwnp);
               sw_title(" CHANGING COLORS FOR DIALOG BOX ",
                   curset[0],TOPCENTER,cwnp);
               v_bdr(BDR_DLNP,cwnp);
               v_chattrow(0,0,' ',curset[0],
                    ENDWN,ATT,cwnp);
            }
            v_stattnop(5,12,"  text in active field  ",
                 curset[1],24,ATT,cwnp);
            v_stattnop(7,12," text in inactive field ",
                 curset[2],24,ATT,cwnp);
            break;
         case KEY_F10:
               bg++;
            if (bg > 15) bg = 0;
            curset[curfld] = catt_def(fg,bg);
            if (vid_getmode() == MONO)
               curmon[curfld] = atttbl[curset[curfld]][0];
            if (curfld == 0) {
               sw_att(curset[0],cwnp);
               sw_bdratt(curset[0],cwnp);
               sw_title(" CHANGING COLORS FOR DIALOG BOX ",
                   curset[0],TOPCENTER,cwnp);
               v_bdr(BDR_DLNP,cwnp);
               v_chattrow(0,0,' ',curset[curfld],
                    ENDWN,ATT,cwnp);
            }
            v_stattnop(5,12,"  text in active field  ",
                 curset[1],24,ATT,cwnp);
            v_stattnop(7,12," text in inactive field ",
                 curset[2],24,ATT,cwnp);
            break;
         case KEY_ENTER:
            if (curfld < 2) goto DnArrowKey;
            memcpy(GblDlgColor,curset,3);
            memcpy(GblDlgMono, curmon,3);
            retcode = AC_EXIT;
            break;
         case KEY_ESC:
            retcode = AC_QUIT;
            break;
         case KEY_F1:
            sw_mf(DlgMFilePtr,HELP_WNP);
            mf_kwdset( "*ODlgColor",DlgMFilePtr );
            wn_up(HELP_WNP);
            v_stpl(1,LEFT_TEXT,"Cursor keys to scroll, <ESC> to quit", msgwnp );
            mf_browse(HELP_WNP);
            wn_dn(HELP_WNP);
            v_stpl(1,LEFT_TEXT,"<>/<> change field, <F9> foreground color, <F10> background color, <CR> exit",msgwnp);
            break;
         default:
            break;
      }
      if (retcode == AC_EXIT || retcode == AC_QUIT) break;
   }

   wn_dn(cwnp);
   wn_free(cwnp);
   wn_dn(msgwnp);
   wn_free(msgwnp);
   ExecDlgFlag = 0;

   if (retcode == AC_EXIT) return( EXITMENU );
   else if (retcode == AC_QUIT) return(SAMELEVEL);

}         /* end of MN_O_DLGCOLOR( OptMenuCopy )  */

/****************************************************************************/
/*  SPA menu-bar Entry menu-item					    */
/****************************************************************************/

MN_P_ENTRY( SpaMenuCopy )
MFORMPTR  SpaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 1;
 return( EXITMENU );

}  /*  of MN_P_ENTRY()  */

MN_P_ENTRY1()
{
 SaveScrnLayout();

 if (!start_up1())
    spa1();

 RestoreScrnLayout();
 return( EXITMENU );

}  /*  of MN_P_ENTRY1()  */

/****************************************************************************/
/*  SPA menu-bar Duration menu-item					    */
/****************************************************************************/

MN_P_DURATION( SpaMenuCopy )
MFORMPTR  SpaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 2;
 return( EXITMENU );

}  /*  of MN_P_DURATION()  */

MN_P_DURATION1()
{
 SaveScrnLayout();

 if (!start_up1())
    spa2();

 RestoreScrnLayout();
 return( EXITMENU );

}  /*  of MN_P_DURATION1()  */

/****************************************************************************/
/*  SPA menu-bar Time menu-item						    */
/****************************************************************************/

MN_P_TIME( SpaMenuCopy )
MFORMPTR  SpaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 3;
 return( EXITMENU );

}  /*  of MN_P_TIME()  */

MN_P_TIME1()
{
 SaveScrnLayout();

 if (!start_up1())
    spa3();

 RestoreScrnLayout();
 return( EXITMENU );

}  /*  of MN_P_TIME1()  */

/****************************************************************************/
/*  SPA menu-bar Coverage menu-item					    */
/****************************************************************************/

MN_P_COVERAGE( SpaMenuCopy )
MFORMPTR  SpaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 4;
 return( EXITMENU );

}  /*  of MN_P_COVERAGE()  */

MN_P_COVERAGE1()
{
 SaveScrnLayout();
 SPACover();
 RestoreScrnLayout();
 return( EXITMENU );

}  /*  of MN_P_COVERAGE1()  */

/****************************************************************************/
/*  LSA menu-bar Lsa menu-item						    */
/****************************************************************************/

MN_L_LSA( LsaMenuCopy )
MFORMPTR  LsaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 5;
 return( EXITMENU );

}  /*  of MN_L_LSA()  */

MN_L_LSA1()
{
 SaveScrnLayout();

 if (!start_up1())
    logst();

 RestoreScrnLayout();
 return( EXITMENU );

}  /*  of MN_L_LSA1()  */

/**************************** End of File **********************************/

