/****************************************************************************
**
** File name : mouse.h
**
**      Description:
**
**
** Changing :
**
** A. Date -- 10/28/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


/****************************************************************************
**
** Local define
**
****************************************************************************/
#define SCREEN_MASK     0x78FF
#define CURSOR_MASK     0x7800
#define MINVERTICAL     0
#define MAXVERTICAL     (vs_rowq()*8-1)     // 199 or 399
#define MINHORIZONTAL   0
#define MAXHORIZONTAL   (vs_colq()*8-1)     // 639
#define MOUSE_LB    0
#define MOUSE_RB    1
#define PULLDOWN    1
#define DIALOG      2
#define LBDOWN_ANOTHER_ITEM     0
#define LBDOWN_MENUBAR_BLANK    1
#define LBDOWN_NOACTION         2
#define LBDOWN_INSIDE_PULLDOWN  3
#define RELEASE_NOACTION            0
#define RELEASE_CURRENT_ITEM        1
#define RELEASE_INSIDE_PULLDOWN     2
#define MOUSE_TEXT_CURSOR_SELECT    0


/****************************************************************************
**
** Proto-type define
**
****************************************************************************/
void Int33h(int *, int *, int *, int *);                      /* INT 33H */
void ResetAndStatus(int *, int *);                            /* AX = 00 */
void ShowCursor(void);                                        /* AX = 01 */
void HideCursor(void);                                        /* AX = 02 */
void ButtonStatusAndMousePosition(int *, int *, int *);       /* AX = 03 */
void SetMouseCursorPosition(int, int);                        /* AX = 04 */
void GetButtonPressInformation(int *, int *, int *, int *);   /* AX = 05 */
void GetButtonReleaseInformation(int *, int *, int *, int *); /* AX = 06 */
void SetMinMaxHorizontal(int, int);                           /* AX = 07 */
void SetMinMaxVertical(int, int);                             /* AX = 08 */
void SetTextCursor(int, int, int);                            /* AX = 10 */
void ReadMouseMotionCounters(int *, int *);                   /* AX = 11 */

void InitMouse(void);
void FuncKeyNo(int *, int);
void CtrlKeyNo(int *Keyin_addr, int x);
void AltKeyNo(int *Keyin_addr, int x);
void MenuBarItemPos(int *, int);
void ToActiveAnyOneVP(int);
void ZoomDragSVR(int);
void ScrollVPLine(WINDOWPTR, int);
void TimeDelay(int);
void ChkMouseLBAndEsc(int *);
void ChkVPoperation( void );
int CheckLBClick(int *);
int MouseSVR(int *);
int WhichAreaPressed(void);
int VScrollKeyPressed( void );
int VScrollBarPressed( void );
int PulldownDialogKi(FORMPTR);
int PulldownKi(FORMPTR);
int DialogKi(FORMPTR);
int CListKi(CLISTPTR);
int AreaWhileLBDown(FORMPTR, int *);
int AreaWhileRelease(FORMPTR);
int MenubarItemNo(int, int);
int DialogItem(FORMPTR, int, int);
int InDialogWin(FORMPTR, int, int);
int ReadDialogKi(void);
int HelpKi(WINDOWPTR);
int HelpUpOrDown(WINDOWPTR, int, int);
int DialogColorItem(int, int);
int InDialogColorWin(int, int);
int ToggleBrkpoint( int x, int y );
int VScrollBarPressed( void );
int CmdFileKi( int *key );
int MouseLBDoubleClick( void );



/****************************************************************************
**
** Externals
**
****************************************************************************/
extern int COMVPMax;
extern unsigned long RedrawFlag;
extern char dspMode;
extern unsigned int curLineNum;
extern unsigned char actF1;
extern char *cmdFileKeyPtr;
extern char far cmdfile_flag;
extern WINDOWPTR  sCmdHelpWnp;



/****************************************************************************
**
** Local Defined Variables
**
****************************************************************************/
int press_m1, press_m2, press_x, press_y;
// (press_x, press_y): coordinates when the mouse button is pressed

int release_m1, release_m2, release_x, release_y;

int current_status, current_x, current_y;
// (current_x, current_y): coordinates the mouse is at currently

int static_tr, static_tc;

int cursor_appear_or_not = 1;   // 1: appear; 0: don't appear

int pulldown_or_dialog = PULLDOWN;

int drag_status_or_not = 0;

int current_menubar_item, next_menubar_item, need_next_mn_rd;

int mouse_have_been_pressed;

int mouse_not_released;

int special_dialog = 0, have_mouse_driver = 1;

int old_bar_pos = -1, old_hbar_pos = 0;



/**************************** End of File **********************************/

