/***************************************************************************
**
** File name : mousedrv.c
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**    3. Change "USDtoupper()" to "ch_toupper()".
**
** B. Date -- 11/03/1992 By Cheerson
**      0. Mask all "SPA" & "LSA" menu bar display or operation.
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include <dos.h>
#include <stdio.h>
#include <graph.h>
#include "funcext.h"
#include "system.h"
#include "usd3.h"
#include "gblext.h"
#include "mouse.h"
#include  "system.h"
#ifndef _LINUMDEF_
#include "linumdef.h"
#endif

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : Int33h(M1, M2, M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void Int33h(int *M1, int *M2, int *M3, int *M4)
{
union REGS M_INREG, M_OUTREG;
union REGS *M_INREG_ptr=&M_INREG, *M_OUTREG_ptr=&M_OUTREG;

   M_INREG_ptr->x.ax = *M1;
   M_INREG_ptr->x.bx = *M2;
   M_INREG_ptr->x.cx = *M3;
   M_INREG_ptr->x.dx = *M4;

   if (have_mouse_driver==1) {
      int86(0x33,M_INREG_ptr,M_OUTREG_ptr);
      *M1 = M_OUTREG_ptr->x.ax;
      *M2 = M_OUTREG_ptr->x.bx;
      *M3 = M_OUTREG_ptr->x.cx;
      *M4 = M_OUTREG_ptr->x.dx;
   } else {
      *M1 = 0;
      *M2 = 0;
      *M3 = 0;
      *M4 = 0;
   }
}        /* end of Int33h(M1, M2, M3, M4) */

/**************************************************************************
**
** Name : void ResetAndStatus(M1, M2)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void ResetAndStatus(int *M1, int *M2)
{
int M3, M4;

   *M1 = 0;
   *M2 = 0;
   M3 = 0;
   M4 = 0;
   Int33h(M1, M2, &M3, &M4);
}         /* end of void ResetAndStatus(M1, M2) */

/**************************************************************************
**
** Name : void ShowCursor()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

void ShowCursor()
{
int M1, M2, M3, M4;

   M1 = 1;
   M2 = 0;
   M3 = 0;
   M4 = 0;
   Int33h(&M1, &M2, &M3, &M4);
}        /* end of void ShowCursor() */

/**************************************************************************
**
** Name : HideCursor()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void HideCursor()
{
    int M1, M2, M3, M4;

    M1 = 2;
    M2 = 0;
    M3 = 0;
    M4 = 0;
    Int33h(&M1, &M2, &M3, &M4);
}         /* end of HideCursor() */

/**************************************************************************
**
** Name : ButtonStatusAndMousePosition(M2, M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void ButtonStatusAndMousePosition(int *M2, int *M3, int *M4)
{
int M1;

   M1 = 3;
   *M2 = 0;
   *M3 = 0;
   *M4 = 0;
   Int33h(&M1, M2, M3, M4);
}         /* end of ButtonStatusAndMousePosition(M2, M3, M4) */

/**************************************************************************
**
** Name : SetMouseCursorPosition(M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void SetMouseCursorPosition(M3, M4)
int M3, M4;
{
int M1, M2;

   M1 = 4;
   M2 = 0;
   Int33h(&M1, &M2, &M3, &M4);
}         /* end of SetMouseCursorPosition(M3, M4) */

/**************************************************************************
**
** Name : GetButtonPressInfomation(M1, M2, M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void GetButtonPressInfomation(M1, M2, M3, M4)
int *M1, *M2, *M3, *M4;
{

   *M1 = 5;
   *M3 = 0;
   *M4 = 0;
   Int33h(M1, M2, M3, M4);
}         /* end of GetButtonPressInfomation(M1, M2, M3, M4) */

/**************************************************************************
**
** Name : GetButtonReleaseInfomation(M1, M2, M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void GetButtonReleaseInfomation(M1, M2, M3, M4)
int *M1, *M2, *M3, *M4;
{

   *M1 = 6;
   *M3 = 0;
   *M4 = 0;
   Int33h(M1, M2, M3, M4);
}         /* end of GetButtonReleaseInfomation(M1, M2, M3, M4) */

/**************************************************************************
**
** Name : SetMinMaxHorizontal(M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void SetMinMaxHorizontal(M3, M4)
int M3, M4;
{
int M1, M2;

   M1 = 7;
   M2 = 0;
   Int33h(&M1, &M2, &M3, &M4);
}         /* end of SetMinMaxHorizontal(M3, M4) */

/**************************************************************************
**
** Name : SetMinMaxVertical(M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void SetMinMaxVertical(M3, M4)
int M3, M4;
{
int M1, M2;

   M1 = 8;
   M2 = 0;
   Int33h(&M1, &M2, &M3, &M4);
}         /* end of SetMinMaxVertical(M3, M4) */

/**************************************************************************
**
** Name : SetTextCursor(M2, M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void SetTextCursor(M2, M3, M4)
int M2, M3, M4;
{
int M1;

   M1 = 10;
   Int33h(&M1, &M2, &M3, &M4);
}         /* end of SetTextCursor(M2, M3, M4) */

/**************************************************************************
**
** Name : ReadMouseMotionCounters(M3, M4)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void ReadMouseMotionCounters(M3, M4)
int *M3, *M4;
{
int M1, M2;

   M1 = 11;
   M2 = 0;
   *M3 = 0;
   *M4 = 0;
    Int33h(&M1, &M2, M3, M4);
}         /* end of ReadMouseMotionCounters(M3, M4) */

/**************************************************************************
**
** Name : InitMouse()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void InitMouse()
{
int mouse_status, number_of_button;

   have_mouse_driver = 1;
   ResetAndStatus(&mouse_status, &number_of_button);
   if(mouse_status == -1) {
       have_mouse_driver = 1;
       SetTextCursor(0, SCREEN_MASK, CURSOR_MASK);
       SetMinMaxHorizontal(MINHORIZONTAL,MAXHORIZONTAL);
       SetMinMaxVertical(MINVERTICAL, vs_rowq() * 8 - 1);
   } else have_mouse_driver = 0;
}         /* end of InitMouse() */

/**************************************************************************
**
** Name : MouseSVR(Keyin_addr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int MouseSVR(int *Keyin_addr)
{
int x_position, ret;

   *Keyin_addr = 0;
   switch (CheckLBClick(&x_position)) {
      case 0:
         break;
      case 1:
         FuncKeyNo(Keyin_addr, x_position);
         break;
      case 2:
         MenuBarItemPos(Keyin_addr, x_position);
         mouse_have_been_pressed = mouse_not_released = 1;
         break;
      case 3:
         HideCursor();
         ToActiveAnyOneVP(TopVP);
         ShowCursor();
         break;
      case 4:
         HideCursor();
         ToActiveAnyOneVP(COMVP);
         ShowCursor();
         break;
      case 5:
         HideCursor();
         ToActiveAnyOneVP(CODVP);
         ret=ToggleBrkpoint(press_x, press_y);  // Toggle breakpoint in CODVP
         ShowCursor();
         return(ret); // if ret == TRUE, a command line has been executed,
                      // so it has to return to InputProcess()
      case 6:
         HideCursor();
         ToActiveAnyOneVP(STAVP);
         ShowCursor();
         break;
      case 7:
         HideCursor();
         ToActiveAnyOneVP(DATVP);
         ShowCursor();
         break;
      case 8:
         *Keyin_addr = 27;
         break;
      case 9:
         AltKeyNo( Keyin_addr, x_position );
         break;
      case 10:        // choice Ctrl_* function key number
         CtrlKeyNo( Keyin_addr, x_position );
         break;
      default:
         break;
   }

   return(0);

}         /* end of MouseSVR(Keyin_addr) */


/**************************************************************************
**
** Name : CheckLBClick(item_no_addr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int CheckLBClick(int *item_no_addr)
{
   ChkVPoperation();
   ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
   current_x >>= 3;  current_y >>= 3;
   if (current_status & 1) {   // left button is still pressed
      press_m2 = 0;
      GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
      press_x >>= 3;  press_y >>= 3;
      if (press_m2 != 0) {
         *item_no_addr = press_x;
         return( WhichAreaPressed() );
      }
   }
   else if (current_status & 2) {   // right button is still pressed
      press_m2 = 1;
      GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
      press_x = -1;  press_y = -1;
      if (press_m2 != 0) {
         *item_no_addr = 0;
         return(8);
      }
   }
   return (0);
}         /* end of CheckLBClick(item_no_addr) */

/**************************************************************************
**
** Name : ChkVPoperation()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
static void ChkVPoperation()
{
int which_boarder, up_or_down_key;
int scroll_bar_pos, old_bar_pos = -1, bar_len, real_bar_pos, row_org;

   if (CmdHelpWnp != NULLP)  return;
   if ( press_y == VP[CODVP].yOrg) which_boarder = CODVP;
   else if ( press_y == VP[COMVP].yOrg) which_boarder = COMVP;
   else which_boarder = 0;

   if (current_status == 1 && which_boarder != 0) {
   /*** Zoom viewport ***/
      ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
      current_x >>= 3;  current_y >>= 3;
      while ( (current_status == 1) && (COMVPMax == 0) ) {
         ZoomDragSVR(which_boarder);
         ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
         current_x >>= 3;  current_y >>= 3;
      }
   }
   else {
      ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
      current_x >>= 3;  current_y >>= 3;
      if ((up_or_down_key=ScrollKeyPressed()) != -1) {
      /*** Scroll viewport ***/
         ScrollVPLine(VP[ActVP].Ptr, up_or_down_key);
         TimeDelay(30);
         while (1) {
            ButtonStatusAndMousePosition(&current_status,
                                         &current_x, &current_y);
            current_x >>= 3;  current_y >>= 3;
            if (current_status != 1) break;
            if ( (up_or_down_key=ScrollKeyPressed()) != -1 ) {
               ScrollVPLine(VP[ActVP].Ptr, up_or_down_key);
               TimeDelay(5);
            }
         }  /* end of while */
      }
      else if ( (scroll_bar_pos=ScrollBarPressed()) != -1 ) {
      /*** Pressing scroll bar ***/
         while (current_status == 1) {
            if (scroll_bar_pos == -1) ShowCursor();
            else if (scroll_bar_pos != old_bar_pos) {
               ShowCursor();
               HideCursor();
               bar_len = VP[ActVP].Height - 4;
               if (scroll_bar_pos == 0)  row_org = 0;
               else
                  for (row_org = 1; 1; row_org++) {
                     real_bar_pos = (bar_len - 1) * 16 /
                        ( (VP[ActVP].Maxr - bar_len - 1)*16 / row_org );
                     if (real_bar_pos >= scroll_bar_pos)  break;
                  }
               VP[ActVP].Ptr->row_org = row_org;
               wn_upd(VP[ActVP].Ptr);
               old_bar_pos = scroll_bar_pos;
            }
            ButtonStatusAndMousePosition(&current_status,
                                         &current_x, &current_y);
            current_x >>= 3;  current_y >>= 3;
            scroll_bar_pos = ScrollBarPressed();
         }  /* end of while */
         ShowCursor();
         GetCodeVPRange(2);  // 2 : PARTIAL
      }  /* end of else if ( (scroll_bar_pos=ScrollBarPressed()) != -1 ) */
   }

}         /* end of ChkVPoperation() */



/****************************************************************************
**
** Name     : FuncKeyNo()
**
** Function : choice the function key number
**
**    Input : Keyin_addr -- accept the choise
**            x -- mouse horizontal position
**
**   Output : none
**
** Notes    : coded by Chen
**
****************************************************************************/
void FuncKeyNo( int *Keyin_addr, int x )
{
char buffer[81];    // store the bottom message
int item_no;        // function key number

// initialize the keyin value
    *Keyin_addr = 0;

// get the bottom line message
    FuncKeyVP->r = 0;
    v_stcpy( buffer, FROM_WN, ROW, FuncKeyVP );

// if bottom line is not "...10StepOv", then return
    if ( !strstr(buffer, "10StepOv") ) {
        return;
    }

// skip backward to start position of a word
    if ( buffer[x] == ' ' ) {
        for ( ; x > 0 && buffer[x] == ' '; x-- );
    }
    for ( ; x > 0 && buffer[x] != ' '; x-- );
    if ( buffer[x] == ' ' ) {
        x++;
    }

// extract function key number
    if ( !isdigit(buffer[x]) ) {
        *Keyin_addr = 0;
        return;
    }
    if ( buffer[x] > '0' && buffer[x+1] != '0' ) {
        item_no = buffer[x] - '0';
    }
    else if ( buffer[x] == '1' && buffer[x+1] == '0' ) {
        item_no = 10 + buffer[x+1] - '0';
    }

// assign the Keyin_addr value
    *Keyin_addr = KEY_F1 - (item_no-1);

}   /* end of FuncKeyNo() */



/****************************************************************************
**
** Name     : CtrlKeyNo()
**
** Function : choice the Ctrl_* key number
**
**    Input : Keyin_addr -- accept the choise
**            x -- mouse horizontal position
**
**   Output : none
**
** Notes    : coded by Chen
**
****************************************************************************/
void CtrlKeyNo( int *Keyin_addr, int x )
{
char buffer[81];    // store the bottom message
int item_no;        // Ctrl_* key number

// initialize the keyin value
    *Keyin_addr = 0;

// get the bottom line message
    CtrlKeyVP->r = 0;
    v_stcpy( buffer, FROM_WN, ROW, CtrlKeyVP );

// if bottom line is not "...10Text  ", then return
    if ( !strstr(buffer, "10Text  " ) ) {
        return;
    }

// skip backward to start position of a word
    if ( buffer[x] == ' ' ) {
        for ( ; x > 0 && buffer[x] == ' '; x-- );
    }
    for ( ; x > 0 && buffer[x] != ' '; x-- );
    if ( buffer[x] == ' ' ) {
        x++;
    }

// extract function key number
    if ( !isdigit(buffer[x]) ) {
        *Keyin_addr = 0;
        return;
    }
    if ( buffer[x] > '0' && buffer[x+1] != '0' ) {
        item_no = buffer[x] - '0';
    }
    else if ( buffer[x] == '1' && buffer[x+1] == '0' ) {
        item_no = 10 + buffer[x+1] - '0';
    }

// assign the Keyin_addr value
    *Keyin_addr = KEY_CF1 - (item_no-1);

}   /* end of CtrlKeyNo() */



/****************************************************************************
**
** Name     : AltKeyNo()
**
** Function : choice the Alt_* key number
**
**    Input : Keyin_addr -- accept the choise
**            x -- mouse horizontal position
**
**   Output : none
**
** Notes    : coded by Chen
**
****************************************************************************/
void AltKeyNo( int *Keyin_addr, int x )
{
char buffer[81];    // store the bottom message
int item_no;        // function key number

// initialize the keyin value
    *Keyin_addr = 0;

// get the bottom line message
    AltKeyVP->r = 0;
    v_stcpy( buffer, FROM_WN, ROW, AltKeyVP );

// if bottom line is not "...10Shrink", then return
    if ( !strstr(buffer, "10Shrink" ) ) {
        return;
    }

// skip backward to start position of a word
    if ( buffer[x] == ' ' ) {
        for ( ; x > 0 && buffer[x] == ' '; x-- );
    }
    for ( ; x > 0 && buffer[x] != ' '; x-- );
    if ( buffer[x] == ' ' ) {
        x++;
    }

// extract function key number
    if ( !isdigit(buffer[x]) ) {
        *Keyin_addr = 0;
        return;
    }
    if ( buffer[x] > '0' && buffer[x+1] != '0' ) {
        item_no = buffer[x] - '0';
    }
    else if ( buffer[x] == '1' && buffer[x+1] == '0' ) {
        item_no = 10 + buffer[x+1] - '0';
    }

// assign the Keyin_addr value
    *Keyin_addr = KEY_AF1 - (item_no-1);

}   /* end of AltKeyNo() */



/**************************************************************************
**
** Name : MenuBarItemPos(Keyin_addr, x_position)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void MenuBarItemPos(int *Keyin_addr, int x_position)
{
static int HotKeys[] = {
   KEY_AF, KEY_AS, KEY_AM, KEY_AE, KEY_AT, KEY_AY, KEY_AO, KEY_AP, KEY_AL
};
int ItemNo;

   if ( (ItemNo=MenubarItemNo(x_position, 0)) != -1 )
      *Keyin_addr = HotKeys[ItemNo];
   else
      *Keyin_addr = 0;
}         /* end of MenuBarItemPos(Keyin_addr, x_position) */



/**************************************************************************
**
** Name : WhichAreaPressed()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int WhichAreaPressed()
{
int x, y;
char buffer[81];    // store the bottom message

    x = press_x;
    y = press_y;

    if ( y == (vs_rowq()-1) ) {
        CmdHelpVP->r = 0;
        v_stcpy( buffer, FROM_WN, ROW, CmdHelpVP );
        if ( strstr(buffer, "10Text  ") ) {
            return ( 10 );   // Ctrl_* menu
        }
        else if ( strstr(buffer, "10Shrink") ) {
            return ( 9 );   // Alt_* menu
        }
        else if ( strstr(buffer, "10StepOv") ) {
            return ( 1 );   // Function key menu
        }
        else {
            return ( 0 );
        }
    }

    if (y == 0)  return (2);               // menu bar

    if (COMVPMax == 1 || CmdHelpWnp != NULLP)  return (0);

    if (y > 0 && y < VP[CODVP].yOrg && x > 0)
        return (3);   // top viewport
    else if (y>=VP[COMVP].yOrg && y<VP[COMVP].yOrg+VP[COMVP].Height-1 && x>0)
        return (4);
    else if (y == VP[COMVP].yOrg + VP[COMVP].Height - 1)
        return (0);
    else if (x > 0 && x < VP[CODVP].xOrg + VP[CODVP].Width)
        return (5);
    else if (wn_isup(VP[STAVP].Ptr) && x > VP[STAVP].xOrg)
        return (6);
    else if (wn_isup(VP[DATVP].Ptr) && x > VP[DATVP].xOrg)
        return (7);
    else
        return (0);
}         /* end of WhichAreaPressed() */

/**************************************************************************
**
** Name : ToActiveAnyOneVP(int which_vp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void ToActiveAnyOneVP(int which_vp)
{
   if (ActVP == which_vp)  return;
   VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
   v_titleatt( NULLP, LVPTITLEINACT, VP[ActVP].Ptr );
   ActVP = which_vp;
   VP[ActVP].Ptr->titleatt = LVPTITLEACT;
   v_titleatt( NULLP, LVPTITLEACT, VP[ActVP].Ptr );
   if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
      csr_hide();
   else if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
      csr_show();
   csr_plwn( VP[COMVP].Ptr );
}     /* end of ToActiveAnyOneVP(int which_vp) */

/**************************************************************************
**
** Name : ToggleBrkpoint(x, y)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ToggleBrkpoint(int x, int y)
{
extern unsigned long RedrawFlag;
int  breakID, ret;
long addr;
U8 tmpBuf[80];

   /* Check valid area in code viewport */
   if ( (x > VP[CODVP].xOrg) && (x < VP[CODVP].xOrg + VP[CODVP].Width - 1) &&
        (y > VP[CODVP].yOrg) && (y < VP[CODVP].yOrg + VP[CODVP].Height - 1) ) {
      if ((ret = GetAddrInCODVP(VP[CODVP].Ptr->row_org + y - VP[CODVP].yOrg - 1,
            &addr)) == 1 || ret == 3 || ret == 6)  {

         if ((breakID = IsBKPT(addr, (addr>>16)*0x0ffff)) >= 0)
            sprintf(tmpBuf, "CL %2X", breakID+1 );
         else sprintf(tmpBuf, "BR %04X:%04X", (U16)(addr>>16), (U16)addr);
         ExecuteCmdLine( tmpBuf );
         return(TRUE);

//       if ((breakID=ChkBreak(addr)) == -1)   // not set breakpoint yet
//          BreakpointCmd(addr, 0, 1);
//       else
//          ClrBrkRange(breakID, breakID);
//       RedrawFlag = 2;   // In oldgbl.h, #define REDRAWBRE 2
//       UpdateVP();
      }
      else  beep_vv( BPMEDIUM, BPMIDDLE);
   }
   return(FALSE);
}   /* end of ToggleBrkpoint() */

/**************************************************************************
**
** Name : ZoomDragSVR(which_boarder)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void ZoomDragSVR(int which_boarder)
{
   if (current_y == VP[which_boarder].yOrg)  return;
   if ( (which_boarder == CODVP &&
         current_y >= VP[REGVP].yOrg + 2 &&
         current_y <= VP[COMVP].yOrg + VP[COMVP].Height - 5) ||
        (which_boarder == COMVP &&
         current_y >= VP[REGVP].yOrg + 4 &&
         current_y <= VP[COMVP].yOrg + VP[COMVP].Height - 3) ) {
      if (which_boarder == CODVP && !wn_isup(VP[REGVP].Ptr) &&
          !wn_isup(VP[BREVP].Ptr) && !wn_isup(VP[TRAVP].Ptr)) return;
      HideCursor();
      if (current_y < VP[which_boarder].yOrg)
         ZoomVP( ActVP, TOPSIDE, ZOOMUP );
      else if (current_y > VP[which_boarder].yOrg)
         ZoomVP( ActVP, TOPSIDE, ZOOMDOWN );
      ShowCursor();
   }
   GetCodeVPRange(2); // 2 : PARTIAL
}         /* end of ZoomDragSVR(which_boarder) */

/**************************************************************************
**
** Name : ScrollKeyPressed()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int ScrollKeyPressed()
{
   if (current_status != 1)  return (-1);
   if (current_x != press_x || current_y != press_y)  return (-1);
   if (VP[ActVP].Height <= 4)  return (-1);
   ActVP = (COMVPMax) ? COMVP : ActVP;
   if (current_x == VP[ActVP].xOrg+VP[ActVP].Width-1) {
      if (current_y == VP[ActVP].yOrg+1)
         return (2);
      else if (current_y == VP[ActVP].yOrg+VP[ActVP].Height-2)
         return (3);
      else  return (-1);
   }
   else  return (-1);
}         /* end of ScrollKeyPressed() */

/**************************************************************************
**
** Name : ScrollBarPressed()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int ScrollBarPressed()
{
   if (current_status != 1)  return (-1);
   if ( VP[ActVP].Height <= 5 )  return(-1);
   if ( (press_x != (VP[ActVP].xOrg+VP[ActVP].Width-1)) ||
        (press_y <= (VP[ActVP].yOrg+1)) ||
        (press_y >= (VP[ActVP].yOrg+VP[ActVP].Height-2)) )
      return (-1);
   if ( (current_x == (VP[ActVP].xOrg+VP[ActVP].Width-1)) &&
        (current_y > (VP[ActVP].yOrg+1)) &&
        (current_y < (VP[ActVP].yOrg+VP[ActVP].Height-2)) )
      return (current_y - VP[ActVP].yOrg - 2);
   else  return (-1);
}         /* end of ScrollBarPressed() */

/**************************************************************************
**
** Name : ScrollVPLine(wnp, up_or_down_key)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void ScrollVPLine(WINDOWPTR wnp, int up_or_down_key)
{
EXTERN CURRENT_MODULE curModule;
EXTERN FLAG dspMode;
U32 addr;
EXTERN U16 curLineNum;
U8 ret;

   if (ActVP == CODVP) {
      VP[CODVP].Ptr->c = 0;
      v_ch( ' ' , VP[CODVP].Ptr );
   }
   if (up_or_down_key == 2) { /* Up Arrow Key */
      if (dspMode != ASM && ActVP == CODVP) {
         ret=GetAddrInCODVP( wnp->row_org, &addr );  // get curLineNum
         if (ret==6) Addr2LinNum( addr, &curLineNum);
         if ( curLineNum == 1) {
            beep_vv( BPMEDIUM, BPMIDDLE);
            goto GET_RANGE;
         }
      }
      if ( --wnp->row_org < 0 ) {
         ++wnp->row_org;
         HideCursor();
         /* previous page */
         if (ActVP == CODVP) UpdateCODVP(CODVP_PREV);
         else if (ActVP == TRAVP) UpdateTRAVP(TRAVP_PREV);
         ShowCursor();
      }
      else  wn_upd(wnp);
      if ( ActVP == COMVP )
         if ( (wnp->r == (wnp->row_org+VP[ActVP].Height-2)) &&
              (cursor_appear_or_not==1) ) {
            csr_hide();
            cursor_appear_or_not = 0;
         } else if ( (wnp->r == wnp->row_org) &&
                     (cursor_appear_or_not==0) ) {
            csr_show();
            cursor_appear_or_not = 1;
            csr_plwn(wnp);
         } else if ( cursor_appear_or_not == 1 ) csr_plwn(wnp);
   } else if (up_or_down_key == 3) { /* Down Arrow Key */
      if (ActVP == CODVP && IsLastRowOfModule(KEY_DN)) {
         beep_vv( BPMEDIUM, BPMIDDLE);
         goto GET_RANGE;
      }
      if ( ++wnp->row_org > ( VP[ActVP].Maxr - VP[ActVP].Height + 3 ) ) {
         --wnp->row_org;
         HideCursor();
         /* next page */
         if (ActVP == CODVP) UpdateCODVP(CODVP_NEXT);
         else if (ActVP == TRAVP)
            UpdateTRAVP(TRAVP_NEXT);
         ShowCursor();
      }
      else  wn_upd(wnp);
      if ( ActVP == COMVP ) {
         if ( (wnp->r == (wnp->row_org+VP[ActVP].Height-3)) &&
              (cursor_appear_or_not==0) ) {
            csr_show();
            cursor_appear_or_not = 1;
            csr_plwn(wnp);
         } else if ( (wnp->r == (wnp->row_org - 1)) &&
                     (cursor_appear_or_not==1) ) {
            csr_hide();
            cursor_appear_or_not = 0;
         } else if ( cursor_appear_or_not == 1 ) csr_plwn(wnp);
      }
   }
   if (ActVP == CODVP) {
      VP[CODVP].Ptr->r = up_or_down_key == 2 ? VP[CODVP].Ptr->row_org :
                         VP[CODVP].Ptr->row_org + VP[CODVP].Height-3;
   }
GET_RANGE:
   if (ActVP == CODVP) {
      VP[CODVP].Ptr->c = 0;
      v_ch( 0x10, VP[CODVP].Ptr );
   }
   GetCodeVPRange(2);
   return;
}        /* end of ScrollVPLine() */

/**************************************************************************
**
** Name : PulldownDialogKi
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int PulldownDialogKi(FORMPTR fmp)
{
  int key;

    if (CmdFileKi(&key)) return( key );
    if (pulldown_or_dialog == PULLDOWN) return( PulldownKi(fmp) );
    else if (special_dialog == 0) return( DialogKi(fmp) );
    else if (special_dialog == 1) return( RedDialogKi() );
}        /* end of PulldownDialogKi() */

/**************************************************************************
**
** Name : PulldownKi(fmp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int PulldownKi(FORMPTR fmp)
{
int mouse_status, number_of_button;
int item;

   ShowCursor();
wait_input:
   if ( !mouse_have_been_pressed ) {
      do {
         press_m2 = 1;
         GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
         press_x /= 8;
         press_y /= 8;
         if (press_m2 > 0) {
             HideCursor();
//           ResetAndStatus(&mouse_status, &number_of_button);
//           SetTextCursor(0, SCREEN_MASK, CURSOR_MASK);
             return( KEY_ESC );
         }
         ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
         current_x /= 8;
         current_y /= 8;
         if (current_status == 1) {
             mouse_have_been_pressed = mouse_not_released = 1;
             break;
         } else if ( ki_chk() != 0) {
             HideCursor();
             return( ki() );
         }
      } while ( 1 );
   }
   do {
      if (mouse_not_released) {
         ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
         current_x /= 8;
         current_y /= 8;
         switch ( AreaWhileLBDown(fmp, &item) ) {
            case LBDOWN_ANOTHER_ITEM:
               need_next_mn_rd = 1;
               next_menubar_item = item;
               HideCursor();
               return(KEY_ESC);
            case LBDOWN_MENUBAR_BLANK:
               need_next_mn_rd = 2;
               HideCursor();
               return(KEY_ESC);
            case LBDOWN_NOACTION:
               goto next_mouse_status;
            case LBDOWN_INSIDE_PULLDOWN:
               if ( ((item-500) != fmp->cur_item) && ((MenuItem[current_menubar_item][item-500]->flags & UNAVAILABLE) == 0) ) {
                   HideCursor();
                   return(item);
               } else goto next_mouse_status;
         }
      } else {
         mouse_have_been_pressed = mouse_not_released = 0;
         ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
         current_x /= 8;
         current_y /= 8;
         switch ( AreaWhileRelease(fmp) ) {
            case RELEASE_NOACTION:
               HideCursor();
//             ResetAndStatus(&mouse_status, &number_of_button);
//             SetTextCursor(0, SCREEN_MASK, CURSOR_MASK);
               return(KEY_ESC);
            case RELEASE_CURRENT_ITEM:
               goto wait_input;
            case RELEASE_INSIDE_PULLDOWN:
               if ( (MenuItem[current_menubar_item][item-500]->flags & UNAVAILABLE) == 0) {
//                if ( (item == 506) && (current_menubar_item==0) ) {
//                   pulldown_or_dialog = DIALOG;
//                   special_dialog = 1;
//                }
                  HideCursor();
                  return(KEY_ENTER);
               } else  goto wait_input;
         }
      }

next_mouse_status:
      ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
      current_x /= 8;
      current_y /= 8;
      if (current_status != 1)    mouse_not_released = 0;
   } while ( 1 );
}           /* end of PulldownKi(fmp) */

/**************************************************************************
**
** Name : AreaWhileLBDown(fmp, item)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int AreaWhileLBDown(FORMPTR fmp,int *item)
{
    int retval;

    if ( (current_x >= (fmp->wnp->cb-1) ) &&
             (current_x <= (fmp->wnp->ce+1) ) &&
             (current_y >= fmp->wnp->rb)      &&
             (current_y <= fmp->wnp->re)         )
    {
        *item = current_y - 2 + 500;
        retval = LBDOWN_INSIDE_PULLDOWN;

    } else if (current_y == 0) {
        if ( (*item = MenubarItemNo(current_x, current_y)) == -1 )  retval = LBDOWN_MENUBAR_BLANK;
        else if (current_menubar_item != *item)  retval = LBDOWN_ANOTHER_ITEM;
        else {
            *item = -1;
            retval = LBDOWN_NOACTION;
        }
    } else {
        *item = -1;
        retval = LBDOWN_NOACTION;
    }
    return( retval );
}         /* end of AreaWhileLBDown(fmp, item) */

/**************************************************************************
**
** Name : AreaWhileRelease(fmp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int AreaWhileRelease(FORMPTR fmp)
{
int retval;

   if ( (current_x >= (fmp->wnp->cb-1) ) &&
            (current_x <= (fmp->wnp->ce+1) ) &&
            (current_y >= fmp->wnp->rb)      &&
            (current_y <= fmp->wnp->re)         )
   {
       retval = RELEASE_INSIDE_PULLDOWN;

   } else if ( MenubarItemNo(current_x, current_y) != -1 )    retval = RELEASE_CURRENT_ITEM;
   else retval = RELEASE_NOACTION;
   return(retval);
}           /* end of AreaWhileRelease(fmp) */

/**************************************************************************
**
** Name : MenubarItemNo(int x, int y)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int MenubarItemNo(int x, int y)
{
int offset, i;

   if (y != 0)  return (-1);
   for (i = 0; i<= 8; i++) {
      if (MenuBarItem[i] == NULL)  break;
      if (MenuBarItem[i]->tag != 0x4E4D)  break;   /* "MN" (4D,4E) */
      offset = x - MenuBarItem[i]->cb;
      if (offset >= 0 && offset < MenuBarItem[i]->len)
         return (i);
   }
   return (-1);
}         /* end of MenubarItemNo(int x, int y) */

/**************************************************************************
**
** Name :  DialogKi
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int DialogKi(FORMPTR fmp)
{
int item, execution_flag, in_dialog_box;
DFIELDPTR fldptr;

   ShowCursor();
wait_input_dialog:
   if ( !mouse_have_been_pressed ) {
       do {
           press_m2 = 1;
           GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
           press_x /= 8;
           press_y /= 8;
           if (press_m2 > 0) {
               HideCursor();
               return( KEY_ESC );
           }
           ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
           current_x /= 8;
           current_y /= 8;
           if (current_status == 1) {
               mouse_have_been_pressed = mouse_not_released = 1;
               press_m2 = 0;
               GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
               press_x /= 8;
               press_y /= 8;
               if ( (press_m2 > 0) && (special_dialog != 1) ) {
                   item = DialogItem(fmp, press_x, press_y);
                   in_dialog_box = InDialogWin(fmp, press_x, press_y);
                   if ( (item == -1) && (in_dialog_box == 1) )
                       execution_flag = 1;
                   else execution_flag = 0;
                   if (item==fmp->cur_item) {
                       fldptr = (DFIELDPTR) i_numptr(item, fmp);
                       if (fldptr->type==F_BOOL) {
                           HideCursor();
                           return(599);
                       } else if ( ( (fldptr->type==F_STRING) && (fldptr->clistp!=NULLP) ) ||
                               (fldptr->type==F_MEMO) ) {
                           mouse_have_been_pressed = mouse_not_released = 1;
                           HideCursor();
                           return(KEY_F2);
                       }
                   }
               }
               break;
           } else if (ki_chk() != 0) {
               HideCursor();
               return( ki() );
           }
       } while ( 1 );
   }
   do {
       if (mouse_not_released) {
           item = DialogItem(fmp, current_x, current_y);
           fldptr=(DFIELDPTR) i_numptr(item,fmp);
           if ( (item != -1) && (item != fmp->cur_item) && ((fldptr->flags & SKIP) != SKIP) ) {
               HideCursor();
               return(item+500);
           } else  goto next_mouse_status_dialog;
       } else {
           mouse_have_been_pressed = mouse_not_released = 0;
           item=DialogItem(fmp, current_x, current_y);
           in_dialog_box=InDialogWin(fmp, current_x, current_y);
           if ( (item == -1) && (in_dialog_box==1) && (execution_flag == 1) ) {
               HideCursor();
               return(KEY_F10);
           } else if (in_dialog_box == 0) {
               HideCursor();
               return(KEY_ESC);
           } else  goto wait_input_dialog;
       }

next_mouse_status_dialog:
       ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
       current_x /= 8;
       current_y /= 8;
       if (current_status != 1)  mouse_not_released = 0;

   } while ( 1 );
}          /* end of DialogKi() */

/**************************************************************************
**
** Name : DialogItem(fmp, x, y)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int DialogItem(FORMPTR fmp,int  x, int y)
{
int i, retval;
DFIELDPTR fldptr;
MEMOPTR memoptr;

   retval = -1;
   for (i = 0; i < fmp->itemq; i++) {
       fldptr = (DFIELDPTR) i_numptr(i, fmp);
       if (fldptr->type == 10) { /* Memo Field */
           memoptr = (MEMOPTR) i_numptr(i,fmp);
           if ( ( y == memoptr->wnp->rb ) &&
                ( x >= memoptr->wnp->cb ) &&
                ( x <= memoptr->wnp->ce)    )
           {
               retval = i;
               break;
           }
       } else {
           if ( ( y == (fldptr->rb + fmp->wnp->rb) ) &&
                ( x >= (fldptr->cb + fmp->wnp->cb) ) &&
                ( x <= (fldptr->cb + fmp->wnp->cb + fldptr->len - 1)))
           {
               retval = i;
               break;
           }
       }
   }
   return(retval);
}              /* END OF DialogItem() */

/**************************************************************************
**
** Name : InDialogWin(fmp, x, y)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int InDialogWin(FORMPTR fmp,int x, int y)
{
int retval;

   if ( (x >= fmp->wnp->cb)  &&
            (x <= fmp->wnp->ce)  &&
            (y >= fmp->wnp->rb)  &&
            (y <= fmp->wnp->re)     )
   {
       retval = 1;
   } else  retval = 0;

   return(retval);
}         /* END OF InDialogWin(fmp, x, y) */

/**************************************************************************
**
** Name : CListKi(clistp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int CListKi(CLISTPTR clistp)
{
int item, key;

   if (CmdFileKi(&key)) return( key );
   ShowCursor();

wait_input_clist:
   if ( !mouse_have_been_pressed ) {
       do {
           press_m2 = 1;
           GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
           press_x /= 8;
           press_y /= 8;
           if (press_m2 > 0) {
               HideCursor();
               return( KEY_ESC );
           }
           ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
           current_x /= 8;
           current_y /= 8;
           if (current_status == 1) {
               mouse_have_been_pressed = mouse_not_released = 1;
               break;
           } else if ( ki_chk() != 0) {
               HideCursor();
               return( ki() );
           }
       } while ( 1 );
   }
   do {
       if (mouse_not_released) {
           ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
           current_x /= 8;
           current_y /= 8;
           if ( ((item = CListItem(clistp, current_x, current_y) ) > -1) &&
                ((item+clistp->wnp->row_org) != clistp->itemnum) ) {
               HideCursor();
               return(item+500);
           } else if ( (current_status==1) && (item == -2) ) {    /* Up Arrow Key */
               TimeDelay(10);
               HideCursor();
               return(KEY_UP);
           } else if ( (current_status==1) && (item == -3) ) {    /* Down Arrow Key */
               TimeDelay(10);
               HideCursor();
               return(KEY_DN);
           } else goto next_mouse_status_clist;
       } else {
           mouse_have_been_pressed = mouse_not_released = 0;
           ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
           current_x /= 8;
           current_y /= 8;
           if ( (item=CListItem(clistp, current_x, current_y)) > -1 ) {
               HideCursor();
               return(KEY_ENTER);
           } else  if (item == -4) {
               HideCursor();
               return(KEY_F10);
           } else  goto wait_input_clist;
       }

next_mouse_status_clist:
       ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
       current_x /= 8;
       current_y /= 8;
       if (current_status != 1)  mouse_not_released = 0;

   } while ( 1 );
}         /* END OF CListKi(clistp) */

/**************************************************************************
**
** Name : CListItem(clistp, x, y)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

CListItem(CLISTPTR clistp, int x, int y)
{
int retval;

   if ( (x >= (clistp->wnp->cb-2) )  &&
            (x <= (clistp->wnp->ce+2) )  &&
            (y >= (clistp->wnp->rb-1) )  &&
            (y <= (clistp->wnp->re+1) )     )
   {
       if ( (x >= (clistp->wnp->cb-1) )  &&
                (x <= (clistp->wnp->ce+1) )  &&
                (y >= clistp->wnp->rb)    &&
                (y <= clistp->wnp->re)       )
       {
           retval = y - clistp->wnp->rb;
       } else if ( (clistp->wnp->sbarp != NULL) && (x == (clistp->wnp->ce+2) ) && (y == clistp->wnp->rb) )
           retval = -2;
       else if ( (clistp->wnp->sbarp != NULL) && (x == (clistp->wnp->ce+2) ) && (y == clistp->wnp->re) )
           retval = -3;
       else retval = -4;
   } else retval = -1;

   return(retval);
}         /* End of CListItem(clistp, x, y) */

/**************************************************************************
**
** Name : TimeDelay(cen_sec)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void TimeDelay(int cen_sec)
{
union REGS M_INREG, M_OUTREG;
union REGS *M_INREG_ptr=&M_INREG, *M_OUTREG_ptr=&M_OUTREG;
int start_time, end_time;

   M_INREG_ptr->x.ax = 0x2c00;
   int86(0x21,M_INREG_ptr,M_OUTREG_ptr);
   start_time = end_time = ((M_OUTREG_ptr->x.dx & 0xff00)>>8)*100 + (M_OUTREG_ptr->x.dx & 0x00ff);
   while ( ((end_time-start_time) < cen_sec) && ((end_time-start_time) >= 0) ) {
       int86(0x21,M_INREG_ptr,M_OUTREG_ptr);
       end_time = ((M_OUTREG_ptr->x.dx & 0xff00)>>8)*100 + (M_OUTREG_ptr->x.dx & 0x00ff);
   }
}         /* end of TimeDelay(cen_sec) */

/**************************************************************************
**
** Name : RedDialogKi()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int RedDialogKi()
{
int retval, key;

   if (CmdFileKi(&key)) return( key );
   ShowCursor();
   press_m2 = 0;
   GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
   press_m2 = 1;
   GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
   do {
       press_m2 = 0;
       GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
       press_x /= 8;
       press_y /= 8;
       if (press_m2 > 0) {
           retval = KEY_ENTER;
           break;
       } else {
           press_m2 = 1;
           GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
           press_x /= 8;
           press_y /= 8;
           if (press_m2 > 0) {
               retval = KEY_ESC;
               break;
           } else if ( ki_chk() != 0 ) {
               retval = ki();
               if (retval != 0x0d)
                  if ((retval < 0x20) || (retval > 0x7f)) retval = 0x20;
               break;
           }
       }
   } while (1);
   HideCursor();
   return(retval);
}         /* end of RedDialogKi() */

/**************************************************************************
**
** Name : HelpKi(helpwnp)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int HelpKi(WINDOWPTR helpwnp)
{
int item, tempki;
extern unsigned char actF1;

   if (CmdFileKi(&tempki)) return( tempki );
   ShowCursor();

wait_input_help:
   if ( !mouse_have_been_pressed ) {
       do {
           press_m2 = 1;
           GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
           press_x /= 8;
           press_y /= 8;
           if (press_m2 > 0) {
               HideCursor();
               return( KEY_ESC );
           }
           ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
           current_x /= 8;
           current_y /= 8;
           if (current_status == 1) {
               mouse_have_been_pressed = mouse_not_released = 1;
               break;
           } else if ( ki_chk() != 0) {
               tempki = ki();
               if ((tempki == KEY_PGUP) ||
                   (tempki == KEY_PGDN) ||
                   (tempki == KEY_LEFT) ||
                   (tempki == KEY_RIGHT) ||
                   (tempki == KEY_UP) ||
                   (tempki == KEY_DN) ||
                   (tempki == KEY_HOME) ||
                   (tempki == KEY_END) ||
                   (tempki == KEY_AF8) ||
                   ((actF1) && (tempki == KEY_F1)) ||
                   (tempki == KEY_ESC))
               {
                  HideCursor();
                  return( tempki );
               }
           }
       } while ( 1 );
   }
   do {
       if (mouse_not_released) {
           ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
           current_x /= 8;
           current_y /= 8;
           item = HelpUpOrDown(helpwnp, current_x, current_y);
           if ( (current_status==1) && (item == 0) ) {
               TimeDelay(10);
               HideCursor();
               return(KEY_UP);
           } else if ( (current_status==1) && (item == 1) ) {
               TimeDelay(10);
               HideCursor();
               return(KEY_DN);
           } else goto next_mouse_status_help;
       } else {
           mouse_have_been_pressed = mouse_not_released = 0;
           goto wait_input_help;
       }

next_mouse_status_help:
       ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
       current_x /= 8;
       current_y /= 8;
       if (current_status != 1)  mouse_not_released = 0;

   } while ( 1 );
}         /* end of HelpKi(helpwnp) */

/**************************************************************************
**
** Name : HelpUpOrDown(helpwnp, x, y)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int HelpUpOrDown(WINDOWPTR helpwnp, int x, int y)
{
int retval;

   if ( (x == (helpwnp->ce+2) ) && (y == helpwnp->rb) )
       retval = 0;
   else if ( (x == (helpwnp->ce+2) ) && (y == helpwnp->re) )
       retval = 1;
   else retval = -1;

   return(retval);
}         /* end of HelpUpOrDown(helpwnp, x, y) */

/**************************************************************************
**
** Name : DialogColorKi(wnp, curfld)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int DialogColorKi(WINDOWPTR wnp, int *curfld)
{
int item, execution_flag, in_dialog_box, key;

   if (CmdFileKi(&key)) return( key );
   ShowCursor();
wait_input_dialog_color:
   if ( !mouse_have_been_pressed ) {
       do {
           ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
           current_x /= 8;
           current_y /= 8;
           if ( (current_status == 1) || (current_status == 2) ) {
               mouse_have_been_pressed = mouse_not_released = 1;
               press_m2 = 0;
               GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
               press_x /= 8;
               press_y /= 8;
               if ( press_m2 > 0 ) {
                   item = DialogColorItem(press_x, press_y);
                   in_dialog_box = InDialogColorWin(press_x, press_y);
                   if ( (item == -1) && (in_dialog_box == 1) )
                       execution_flag = 1;
                   else execution_flag = 0;
                   if (item == *curfld) {
                       HideCursor();
                       mouse_have_been_pressed = mouse_not_released = 0;
                       return(KEY_F9);
                   }
               }
               press_m2 = 1;
               GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
               press_x /= 8;
               press_y /= 8;
               if ( press_m2 > 0 ) {
                   mouse_have_been_pressed = mouse_not_released = 0;
                   item = DialogColorItem(press_x, press_y);
                   execution_flag = 0;
                   if (item == *curfld) {
                       HideCursor();
                       return(KEY_F10);
                   } else if (current_status == 2) {
                       HideCursor();
                       return(KEY_ESC);
                   }
               }
               break;
           } else if ( ki_chk() != 0) {
               HideCursor();
               return( ki() );
           }
       } while ( 1 );
   }
   do {
       if (mouse_not_released) {
           item = DialogColorItem(current_x, current_y);
           if ( (item != -1) && (item != *curfld) ) {
               HideCursor();
               return(item+0x30);
           } else  goto next_mouse_status_dialog_color;
       } else {
           mouse_have_been_pressed = mouse_not_released = 0;
           item = DialogColorItem(current_x, current_y);
           in_dialog_box = InDialogColorWin(current_x, current_y);
           if ( (item == -1) && (in_dialog_box==1) && (execution_flag == 1) ) {
               HideCursor();
               *curfld = 2;
               return(KEY_ENTER);
           } else if (in_dialog_box == 0) {
               HideCursor();
               return(KEY_ESC);
           } else  goto wait_input_dialog_color;
       }

next_mouse_status_dialog_color:
       ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
       current_x /= 8;
       current_y /= 8;
       if (current_status != 1)  mouse_not_released = 0;
   } while ( 1 );
}         /* end of DialogColorKi(wnp, curfld) */

/**************************************************************************
**
** Name : DialogColorItem(x, y)
**
** Function
**
**    Input  : position (x,y)
**
**    Output :
**
** Notes:
**
**************************************************************************/

int DialogColorItem(int x, int y)
{
   if ( ( x > 54 ) || ( x < 31 ) ) return(-1);
   else if ( y ==  8 ) return(0);
   else if ( y == 10 ) return(1);
   else if ( y == 12 ) return(2);
   else return(-1);
}         /* end of DialogColorItem(x, y) */

/**************************************************************************
**
** Name : InDialogColorWin(x, y)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int InDialogColorWin(int x, int y)
{
int retval;

   if ( (y >= 4) && (y <= 14) && (x >= 18) && (x <= 62) ) retval = 1;
   else retval = 0;

   return(retval);
}         /* end of InDialogColorWin(x, y) */

/**************************************************************************
**
** Name : ChkMouseLBAndEsc(keyin)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

void ChkMouseLBAndEsc(int *keyin)
{
extern int HAND_SHAKE;
int x, y;

   press_m2 = 1;
   GetButtonPressInfomation(&press_m1, &press_m2, &x, &y);
   if (press_m2 > 0) *keyin = KEY_ESC;
}         /* end of ChkMouseLBAndEsc(keyin) */

/**************************************************************************
**
** Name : CmdFileKi(key)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int CmdFileKi(int *key)
{
  if (!cmdfile_flag || ((*key = *cmdFileKeyPtr) == NULL)) return( FALSE );
  cmdFileKeyPtr++;
  return (TRUE);
}         /* end of CmdFileKi(key) */

/*************************** End of File *********************************/

