/***************************************************************************
**
** File name : Process.c for MICE-III
**
** A. Date -- 10/18/1992 By Cheerson
**        0. Received from Matthew's initial verson.
**        1. Add header and Docs.
**        2. Include cmdid.h
**
** B. Date -- 10/24/1992 By Cheerson
**        0. Add null routines for process-command cases.
**        1. Add "C_CLOSE" in cmdid.h for "CLOSE" command.
**        2. Add C_CLOSE case foe the "CLOSE" command.
**        3. Rename "srecall_cmd()" to be "SrecallCmd()".
**        4. "go_cmd" to "GoCmd"
**        5. "ssave_cmd" to "SsaveCmd" ..etc.
**
** C. Date -- 10/25/1992 By Cheerson
**        0. Rename "monitor_cmd()" to be "MonitorCmd()".
**        1. Modify the "cmd_argc" and "cmd_srgv" to "cmd_syntax.argc" and
**               "cmd_syntax.argv[]".
**
** D. Date -- 01/19/1992 By Joyce Lin
**        0. Fix a bug in "Copy" module.
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/
#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include "cmdid.h"
#include "database.h"

#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif

#ifndef _ABI_FUNC_
#include "abifunc.h"
#endif

#include "sdabiext.h"

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int sizeFlag;
extern char cmd_logged ;
extern char menu_logged ;
extern char out_logged;
extern char cmd_flag;
extern char menu_flag;
extern char out_flag;
extern int cmdIdx;
extern int MaskRedrawFlag;
extern U32 RedrawFlag;
extern U8 cntFlag;
extern char bno[];
extern int BreakNumber;
extern S8 pathName[4][50];      // Chen
extern S8 extName[4][5];
extern S16 backLevel;
extern int ESCflag;
extern MICE;
extern int NECflag;
extern S16 cmdLineArgc;
extern U8 lineBuf[512];
extern S16 posPtr;
extern unsigned char first_c;   // Chen

// added by Chen 06/01/94
/*  marked by Chen, 07/22/94
EXTERN S16 flagTotal;
EXTERN U8 **ctlName;
EXTERN U8 *ctlNameEB[];
EXTERN U8 *ctlNameDefault[];
EXTERN U8 *ctl8086Min[];
EXTERN U8 *ctl8086Max[];
EXTERN U8 *ctlNEC8086Min[];
EXTERN U8 *ctlNEC8086Max[];
*/

/**************************************************************************
**
** Local define
**
***************************************************************************/

//#define TRUE 1
#define MAX_ERROR 62
//#define ON    1
#define FAIL -1

/**************************************************************************
**
** Local/GBL variables
**
***************************************************************************/

int verifyFlag, timeBase;
int timerReg;
static char *error_msg[]={
/* -62: STACK_ERROR            */ "Stack will be overflow",
/* -61: ICE_ERROR_COMMAND      */ "Invalid command ",
/* -60  ICE_INVALID_FIRMWARE   */ "",
/* -59: ICE_INVALID_FLY_COMMAND*/ "Invalid command on fly mode",
/* -58: ICE_CPU_FLY            */ "",
/* -57: ICE_COV_RBW_FAIL       */ "",
/* -56: ICE_TRACE_BOARD_FAIL   */ "",
/* -55: ICE_EMM_FAIL           */ "",
/* -54: ICE_MCE16A_FAIL        */ "",
/* -53: ICE_INVALID_CPU        */ "",
/* -52: REC_TIME_OUT        */ "Time out while receiving data",
/* -51: EP_PENDING          */ "Emulation processor pending",
/* -50: EMM_SET_ERROR       */ "Emulation memory set failure",
/* -49: BUFFER_EMPTY        */ "Trace buffers are empty",
/* -48: EVENT_FULL          */ "Event setting full",
/* -47: TIMER_ERROR         */ "Timer boundary is between 1 and 0FFFFFH",
/* -46: CNT_ERROR           */ "CNT0/CNT1 boundary is between 1 and 0400H",
/* -45: NO_EMM              */ "No EMM module",
/* -44: TARGET_RESET        */ "Target Reset",
/* -43: USER_CC             */ "User CC code",
/* -42: NO_VCC              */ "No target VCC",
/* -41: ADDR_MISMATCH       */ "Invalid input address",
/* -40: SPACE_MISMATCH      */ "Only Program/Data is allowed",
/* -39: BANK_MISMATCH       */ "Memory bank cannot be greater than 4",
/* -38: ATTRIBUTE_MISMATCH  */ "Attribute cannot other than I/IR/E/ER/G",
/* -37: ADDR_RANGE_OVERFLOW */ "Mapped memory range overflow",
/* -36: BANK_FULL           */ "No more memory bank can be set",
/* -35: WARN_START          */ "Warm start the emulator",
/* -34: LINK_MICE_FAIL      */ "Link MICE-III failure",
/* -33: TRIG_HALT           */ "Target CPU broke, due to trigger condition matched",
/* -32: RBW_HALT            */ "Target CPU broke, due to Read-Before-Write breakpoint",
/* -31: VIOL_HALT           */ "Target CPU broke, due to memory violation",
/* -30: BKPT2_HALT          */ "Target CPU broke, due to Execution Event hit",  // EV4
/* -29: BKPT1_HALT          */ "Target CPU broke, due to Execution Event hit",  // EV5
/* -28: NO_TRACE_MODULE     */ "No trace module in HW configuration",
/* -27: TIME_OUT            */ "Communication time-out",
/* -26: COMMAND_ERROR       */ "Protocol error",
/* -25: NOT_READY           */ "Target is not ready at ",
/* -24: BROKE               */ "CPU stop",
/* -23: CPU_RUN             */ "CPU free running",
/* -22: TEST_FAIL           */ "Test failure",
/* -21: ABS_OVERFLOW        */ "Absolute address overflow",
/* -20: MAP_FAIL            */ "No more emulation memory can be mapped",
/* -19: ERROR_BOUN          */ "Incorrect map boundary",
/* -18: BAD_FRAME           */ "Invalid frame number",
/* -17: BUS_REQUEST         */ "Bus request",
/* -16: MICE_LIMIT          */ "MICE-III limitation",
/* -15: ERROR_MICE          */ "Linking incorrect MICE-III model",
/* -14: ERROR_COM           */ "Communication error",
/* -13: HALT_USER           */ "Stopped by user",
/* -12: BAD_IN              */ "Error encountered on user input",
/* -11: BAD_REG             */ "Bad register number encountered",
/* -10: BREAK_I             */ "Break on instruction fetch",
/*  -9: BREAK               */ "Break on memory access",
/*  -8: NO_FOUND            */ "Not found in memory search",
/*  -7: NO_DIFF             */ "No difference in memory compare",
/*  -6: STEP_ERROR          */ "Target cannot step",
/*  -5: ERROR_WRITE         */ "Memory write failure at ",
/*  -4: ERROR_READ          */ "Memory read failure",
/*  -3: MEM_PROTECT         */ "Access the protected memory",
/*  -2: MEM_GUARD           */ "Access the guarded memory",
/*  -1: MICE_HALT           */ "Target CPU halted"
};
static char *ONOFF[]={"OFF","ON"};
struct patch_strct
{
   int flag;
   U32 src_ent1;
   U32 src_ent2;
   U32 start;
   U32 dest;
} patch;

int nFillFlag = FALSE;  // Chen 06/03/94
                // don't update code viewport to current PC after memory
                // fill command, such as Byte, Word, Fill...
                // used by UpdateCODVP() in DISPLAY.C
                //
                // TRUE : the special command
                // FALSE: not the memory fill command

U32 RunStart = 0L;  // start address used in DOWN.C, Chen 07/08/94

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : CmdProcess()
**
** Function : command dispatching to file "complex.c".
**
**    Input  : command id -- int
**
**    Output : none
**
** Notes:
**
**************************************************************************/

CmdProcess()
{
U8 goEndFlag, ch, *pch;
U32 addr, addr1, addr2;
U32 len, ii;
U16 portData,aa;
U16 tmpData;
unsigned char temp[80];
unsigned char temp_path[512];       // added by Chen, for PATH only
char *tempBuf;
int i, j, ret;

// S16 mode=0;     // added by Chen ; for C_SETUP


// added by Chen 06/03/94
    nFillFlag = FALSE;

   errorCode=0;
   ESCflag = 0;     // added by Matthew     06/23/94
   memset(tx_buf, NULL, sizeof(tx_buf));  // 06/30/94
   send_ESC();      // added by Chen, 08/11/94
   switch(cmdIdx) {
      case  C_ASSEMBLE:
            nFillFlag = TRUE;   // Chen 06/03/94
         if (!cmd_syntax.argc) emuGetReg(I86_REG, REG_PC, &addr);
         else {
            if (!addr_form.csFlag) {
               emuGetReg(I86_REG, CS, &addr);
               addr =(addr << 16) + addr_form.addr;
            } else addr = addr_form.addr;
         }
         if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         // added by Chen, 07/20/94
		if ( MICE >= V20MAX ) {   // INTEL 286, NEC V20, V30
            TransAssembleCmd(addr);
        }
        else {
            AssembleCmd(addr);
        }
         RedrawFlag = ~MaskRedrawFlag;
         UpdateVP();
         backLevel = 0;
         break;
      case  C_BACK:
         BackCmd();
         break;
      case  C_BREAKPOINT:
         if (!cmd_syntax.argc) BreakpointCmd( 0L,(int) -1, 0);
         else {
            if ((cmd_syntax.argc == 2) && (cmd_syntax.argv[0] > 0xffff)) {
               DisplayStr(" Count cannot exceed 0FFFFH!\r\n");
               break;
            }
            if (!addr_form.csFlag) {
               emuGetReg(I86_REG, CS, &addr);
               addr =(addr << 16) + addr_form.addr;
            } else addr = addr_form.addr;
            if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
               errorCode = ABS_OVERFLOW;
               break;
            }
            if (cmd_syntax.argc == 1) BreakpointCmd(addr ,(int) 0, 1);
            else BreakpointCmd(addr, 0, (U16)cmd_syntax.argv[0]);
         }
//       UpdateVP();
         if ( wn_isup( VP[BREVP].Ptr )) UpdateBREVP( 0 );
         break;
      case  C_BYTE:
      case  C_LONG:
      case  C_WORD:
      case  C_DWORD:
            nFillFlag = TRUE;   // Chen 06/03/94
         if (!cmd_syntax.argc) emuGetReg(I86_REG, REG_PC, &addr);
         else {
            if (!addr_block.CSflag1) {
               emuGetReg(I86_REG, CS, &addr);
               addr = (addr << 16) + addr_block.addr1;
            } else addr = addr_block.addr1;
         }
         if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         if (cmd_syntax.argc == 2)
            errorCode = SdEmuSetMemN(addr, addr_block.buff, addr_block.count);
         else {
            if (cmdIdx == C_BYTE) len=1;
            else if (cmdIdx == C_WORD) len=2;
            else len = 4;
            SetMemCmd(addr, len);
         }
         if (errorCode != OK) break;
         RedrawFlag = ~MaskRedrawFlag;
         UpdateVP();
         break;
      case  C_CHECKSUM:
		 Transparent();
		 break;
		/*****
		 if (!addr_block.CSflag1) {
             emuGetReg(I86_REG, CS, &addr);
             addr = (addr << 16) + addr_block.addr1;
         } else addr = addr_block.addr1;
         if (CheckOverflow((U16)(addr>>16), (U16)addr)){
            errorCode = ABS_OVERFLOW;
            break;
         }
         ChecksumCmd(addr, addr_block.length);
		 *****/

      case  C_TEST:
	   /***
         if (!addr_block.CSflag1) {
            emuGetReg(I86_REG, CS, &addr);
            addr = (addr << 16) + addr_block.addr1;
         } else addr = addr_block.addr1;
         if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         errorCode=TestCmd(addr, addr_block.length);
		 ****/
		 Transparent();
		 nFillFlag = TRUE;	 // Chen 06/03/94
         RedrawFlag = ~MaskRedrawFlag;
         UpdateVP();
         break;
      case  C_CLEAR:
         if (!cmd_syntax.argc) ClearCmd((unsigned int) 0,(unsigned int) 0);
         else ClearCmd((unsigned int) cmd_syntax.argv[0],(unsigned int) cmd_syntax.argv[1]);
         RedrawFlag = ~MaskRedrawFlag;
//       UpdateVP();
         if ( wn_isup( VP[BREVP].Ptr ) ) UpdateBREVP( 0 );
         break;
      case C_CLOCK:
        if ( MICE == I80C186EB ) {  // added by Chen, 09/02/94
            DisplayStr(" This command cannot be supported!");
            break;
        }
         if ( cmd_syntax.argc )
             emuSetClock((S16) cmd_syntax.argv[0]);
         send_str2("clock");
         send(CR);
         pch = tx_buf;
         while((ch = receive()) != HAND_SHAKE) *pch++ = ch;
         *pch = NULL;
         if (strstr(tx_buf, "Internal") != NULL)
			DisplayStr(" Internal clock.\n\r");
		 else DisplayStr("Target clock.\n\r");
         break;
      case  C_COMPARE:
         if (!addr_block.CSflag1) {
            emuGetReg(I86_REG, CS, &addr1);
            addr1 = (addr1 << 16) + addr_block.addr1;
         } else addr1 = addr_block.addr1;
         if (!addr_block.CSflag2)
            addr2 = (addr1 & 0xffff0000) + addr_block.addr2;
         else addr2 = addr_block.addr2;
         if (CheckOverflow((U16)(addr1>>16), (U16)addr1) ||
             CheckOverflow((U16)(addr2>>16), (U16)addr2)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         errorCode=CompareCmd(addr1, addr_block.length, addr2);
         break;
      case  C_CONTROL:
         emuControl();
         break;
      case  C_COPY:
		 if (!addr_block.CSflag1) {
            emuGetReg(I86_REG, CS, &addr1);
            addr1 = (addr1 << 16) + addr_block.addr1;
         } else addr1 = addr_block.addr1;
		 if (addr_block.CSflag2 < 0) addr2 = addr1;
         else
            if (!addr_block.CSflag2)
               addr2 = (addr1 & 0xffff0000) + addr_block.addr2;
            else addr2 = addr_block.addr2;

// Chen 05/23/94
        if ( addr1==addr2 ) {
            break;
        }
	   //
        if ( addr_block.length==addr2-addr1+1 ) {
            errorCode = emuCopy(addr1+1, addr_block.length-1, addr2+1);
            if ( errorCode != 0 ) {
                break;
            }
            errorCode = emuCopy(addr1, 1l, addr2);
            break;
        }

         errorCode = emuCopy(addr1, addr_block.length, addr2);
		 nFillFlag = TRUE;	 // Chen 06/03/94
         UpdateBkptData( addr2, addr_block.length );
         RedrawFlag = ~MaskRedrawFlag;
         UpdateVP();
         break;
      case  C_CPU:
         tmpData = NECflag;
         if ( !cmd_syntax.argc ){
              emuGetMode();
              DisplayStr(tx_buf);
         }
         else{
			if (MICE >= 9 && MICE <= 16 ) {
			   if ( (MICE >= 9 && MICE <= 12)
                    && cmd_syntax.argv[0] == 1 ){
                  DisplayStr(" Not V20/V30 emulation processor !\n\r");
                  break;
               }
               else
                   errorCode  = emuSetMode2((U16) cmd_syntax.argv[0]);
            }
            else errorCode= emuSetMode ((U16) cmd_syntax.argv[0]);
         }
         if ( NECflag != tmpData ) {
            emuGetAllReg(cpuReg);
            RedrawFlag = (~MaskRedrawFlag) & (~REDRAWCOD);
            UpdateVP();
            UpdateCODVP(-1);
        }
         break;
      case  C_CREATE:
            nFillFlag = TRUE;   // Chen 06/03/94
         CreateCmd();
         break;
 /**  case  C_CYCLE:   // have no ABI
         if(!cmd_syntax.argc){
             emuGetCycle(&tmpData);
             DisplayStr(" Display CYcle status.\n\r");
         }
         else {
            if (cmd_syntax.argc == 1) DisplayStr(" Cycle Wait.\n\r");
            else if(cmd_syntax.argc ==2) DisplayStr(" Cycle count.\n\r");
         }
         break;
     **/
      case  C_DELETE:
            nFillFlag = TRUE;   // Chen 06/03/94
         DeleteCmd();
         break;
/***  case  C_DIAGNOSTIC:
         Diagnostic(1);
         break;    ***/
      case   C_DISASSEMBLE:
		 if (!cmd_syntax.argc) emuGetReg(I86_REG, REG_PC, &addr);
         else {
             if (!addr_block.CSflag1) {
                 emuGetReg(I86_REG, CS, &addr);
                 addr = (addr << 16) + addr_block.addr1;
             } else addr = addr_block.addr1;
         }
         if (cmd_syntax.argc == 2) len = addr_block.length;
         else if ( MICE >= 13 ) len = 0;
         else len = 0xffff;
         if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         // added by Chen, 07/20/94
		if ( MICE >= 13 ) {    // INTEL 286, NEC V20, V30
            TransDisassembleCmd(addr, len);
        }
        else {
            DisassembleCmd(addr, len);
        }
         backLevel = 0;
         break;
      case  C_DOS:
         DosCmd();
         break;
      case  C_DOSA:     // added by Chen, 07/14/94
         DosACmd();
         break;
      case  C_DOUBLE:
            nFillFlag = TRUE;   // Chen 06/03/94
         if (!cmd_syntax.argc) emuGetReg(I86_REG, REG_PC, &addr);
         else {
            if (!addr_block.CSflag1) {
               emuGetReg(I86_REG, CS, &addr);
               addr = (addr << 16) + addr_block.addr1;
            } else addr = addr_block.addr1;
         }
         if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         DoubleCmd(addr);
         RedrawFlag = ~MaskRedrawFlag;
         UpdateVP();
         break;
      case  C_DOWNLOAD:
        if ( BreakNumber>0 ) {     // added by Chen 05/27/94
            ClrBrkRange( 0, BreakNumber-1); // added by Frank, 5/17/1994
        }
         DownloadCmd(cmd_syntax.asc);
         RedrawFlag = ~MaskRedrawFlag;
         UpdateVP();
        if ( first_c == INTEL ) {
            DownView(TRUE);        // added by Chen, 5/19/1994
        }
         backLevel = 0;
         break;
      case  C_EV1:
      case  C_EV2:
         if (existTraceBoard != ON ) {
            errorCode = NO_TRACE_MODULE;
            break;
         }
      case  C_EV3:
      case  C_EV4:
      case  C_EV5:
      case  C_EV6:
      case  C_EV7:
      case  C_EV8:
         errorCode = EventCmd(1+cmdIdx-C_EV1);
         break;
      case  C_EVENT:
         errorCode = EventCmd(0);
         break;
      case  C_EXTENSION:
         if (!cmd_syntax.argc) {
            DisplayStr(" The source file extension names are :\r\n");
            strcpy(temp," Search order :  ");
            for (i=0; i < 4; i++ ) {
               if (extName[i][0]) {
                  strcat(temp, extName[i]);
                  strcat(temp, "  ");
               }
            }
            strcat(temp,".C  .ASM\r\n");
            DisplayStr(temp);
         }
         else if(cmd_syntax.argc== 5) memset( extName, NULL, sizeof(extName));
         else {
            FreeLinNumInfo();
            UpdateCODVP(-1);
         }
         break;
      case  C_PATH:     // Chen 05/20/94
         if (!cmd_syntax.argc) {
            strcpy(temp_path," Path = ");
            for (i=0; i < 4; i++ ) {
               if (pathName[i][0]) {
                  strcat(temp_path, pathName[i]);
                  strcat(temp_path, ";");
               }
            }
            strcat(temp_path,"\r\n");
            DisplayStr(temp_path);
         }
         else if(cmd_syntax.argc== 5 )
              memset( pathName, NULL, sizeof(pathName));
         else{
            FreeLinNumInfo();
            UpdateCODVP(-1);
         }
         break;
      case  C_FIND:
         FindCmd();
         break;
      case  C_FILL:
         if (!addr_block.CSflag1) {
            emuGetReg(I86_REG, CS, &addr1);
            addr1 = (addr1 << 16) + addr_block.addr1;
         } else addr1 = addr_block.addr1;
         if (CheckOverflow((U16)(addr1>>16), (U16)addr1)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         errorCode = emuFill(addr1, addr_block.length,addr_block.buff,
                             addr_block.count);
         if (errorCode != OK) break;
		 nFillFlag = TRUE;	 // Chen 06/03/94
         UpdateBkptData(addr1, addr_block.length);
         RedrawFlag = ~MaskRedrawFlag;
         UpdateVP();
         break;
      case  C_FLOAT:
            nFillFlag = TRUE;   // Chen 06/03/94
         if (!cmd_syntax.argc) emuGetReg(I86_REG, REG_PC, &addr);
         else {
            if (!addr_block.CSflag1) {
               emuGetReg(I86_REG, CS, &addr);
               addr = (addr << 16) + addr_block.addr1;
            } else addr = addr_block.addr1;
         }
         if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         FloatCmd(addr);
         RedrawFlag = ~MaskRedrawFlag;
         UpdateVP();
         break;
      case  C_GO:
         /** exist addr or(and) addr1 between argc 2 to 5 **/
         if (cmd_syntax.argc >= 2 && cmd_syntax.argc <= 5
             && cmd_syntax.argc != 4) {
            if (!addr_block.CSflag1) {
               emuGetReg(I86_REG, CS, &addr);
               addr =(addr << 16) + addr_block.addr1;
            } else addr = addr_block.addr1;
            if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
               errorCode = ABS_OVERFLOW;
               break;
            }
            if (addr_block.CSflag1) emuSetReg(I86_REG, CS, (addr>>16)&0xffffL);
            emuSetReg(I86_REG, IP, addr&0xffffL);
         }
         /** Go @n **/
         if (cmd_syntax.argc == 6) {
            if (GetLevelRetAddr(0,(U16)cmd_syntax.argv[0],&addr,&addr1) == FAIL) {
               DisplayStr(" Return address not found!\r\n" );
               break;
            }
            errorCode = emuRunUntil(addr);
         }
         else /** Go Till addr1   ||   Go From addr (Till) addr1 **/
         if (cmd_syntax.argc == 4 || cmd_syntax.argc == 5) {
            if (!addr_block.CSflag2) {
               emuGetReg(I86_REG, CS, &addr);
               addr =(addr << 16) + addr_block.addr2;
            } else addr = addr_block.addr2;
            if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
               errorCode = ABS_OVERFLOW;
               break;
            }
            errorCode=emuRunUntil(addr);
         }
         else  /** Go Run ||  Go Run From addr **/
          if (cmd_syntax.argc == 1 || cmd_syntax.argc == 3) {
            errorCode = GoCmd(FREE_RUN, 0L, &ret);
            break;
         }
         else /* Go || Go From */
          errorCode = GoCmd(NORMAL_RUN, 0L, &ret);

         if (ret == 1 ) break;
         /* mask off REDRAWCOD and REDRAWTRA */
         RedrawFlag = (~MaskRedrawFlag) & (~4) & (~64);
         UpdateVP();
         UpdateTRAVP(-1);
         UpdateCODVP(-1);  // backLevel = 0
         break;
      case  C_HALT:
         emuAbort();
         if ((errorCode=emuGetAllReg(cpuReg)) != 0) break;
         DisplayStr(" Target CPU Halted!\r\n");
         RedrawFlag = (~MaskRedrawFlag) & (~4);   // mask off REDRAWCOD
         UpdateVP();
         UpdateCODVP(-1);  // backLevel = 0
         break;
      case  C_HELP:
         HelpCmd();
         break;
      case  C_HISTORY:
         if (!cmd_syntax.argc) HistoryCmd(0);
         else HistoryCmd(cmd_syntax.argv[0]);
         break;
      case  C_ICE:
            IceMode();
            // added by Chen, 07/21/94
            emuGetCpuStatus(&goEndFlag);
            if ( goEndFlag == 0 )
                break;
            emuGetAllReg(cpuReg);
            RedrawFlag = (~MaskRedrawFlag) & (~REDRAWCOD);
            UpdateVP();
            UpdateCODVP(-1);
            break;
      case  C_IDENTIFY:
            chk_ID();
            DisplayStr(tx_buf);
            /**  changed by Frank , 4/13/1994
            sprintf(temp," Target CPU is %s\r\n",cpu[MICE]);
            DisplayStr(temp);
            sprintf(temp," Firmware Version is V%1d.%1d\r\n",
                (ID_Info[FIRMWARE_VER]>>4)&0xf,(ID_Info[FIRMWARE_VER]&0xf));
            DisplayStr(temp);
            **/
         break;
      case  C_INCLUDE:
         IncludeCmd();
         break;
      case  C_INPUT:
//         portData=(U16)BUF[0]+((U16)BUF[1] << 8);
         if (cmd_syntax.argc == 1)
            errorCode = emuInput((U16)cmd_syntax.argv[0],1,0,(U8 *)&portData);  /* default BYTE */
         else
            errorCode = emuInput((U16)cmd_syntax.argv[0],(U16)cmd_syntax.argv[1]+1,(U16)cmd_syntax.argv[1],(U8 *)&portData);
         if (errorCode != OK) break;
         if (cmd_syntax.argc == 1 || cmd_syntax.argv[1] == 0)
            sprintf(temp," port = %04lX, data = %02X\r\n",
                    cmd_syntax.argv[0], portData&0xff);
         else
            sprintf(temp," port = %04lX, data = %04X\r\n",
                    cmd_syntax.argv[0], portData);
         DisplayStr(temp);
         break;
      case  C_INTERVAL:
         IntervalCmd();
         break;
      case  C_JOURNAL:
         JournalCmd();
         break;
      case  C_JUMP:
         if (!addr_form.csFlag) {
            emuGetReg(I86_REG, CS, &addr);
            addr =(addr << 16) + addr_form.addr;
            if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
               errorCode = ABS_OVERFLOW;
               break;
            }
            emuSetReg(I86_REG, IP,addr_form.addr);
         } else {
            if (CheckOverflow((U16)(addr_form.addr>>16), (U16)addr_form.addr)) {
               errorCode = ABS_OVERFLOW;
               break;
            }
            emuSetReg(I86_REG, REG_PC, addr_form.addr);
         }
         RedrawFlag = (~MaskRedrawFlag) & (~4);   // mask off REDRAWCOD
         UpdateVP();
         UpdateCODVP(-1);  // backLevel = 0
         break;
      case  C_MODE:
         ModeCmd();
         break;
      case  C_LIST:
         send_ESC();
         send_ESC();
         errorCode = ListCmd();
         break;
      case  C_LOAD:
         LoadCmd(cmd_syntax.asc);
         backLevel = 0;
         break;
      case  C_LOG:
         LogCmd();
         break;
      case  C_MAP:      // by Matthew
         nFillFlag = TRUE;   // Chen 06/03/94
         MapCmd();
         if (cmdLineArgc) {
            RedrawFlag = ~MaskRedrawFlag;
            UpdateVP();
         }
         backLevel = 0;
         break;
      case  C_MEMORY:
		 if (!cmd_syntax.argc) emuGetReg(I86_REG, REG_PC, &addr);
         else {
             if (!addr_block.CSflag1) {
                 emuGetReg(I86_REG, CS, &addr);
                 addr = (addr << 16) + addr_block.addr1;
             } else addr = addr_block.addr1;
         }
         if (cmd_syntax.argc == 2) len = addr_block.length;
         else len = 0x10000;
         if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         DumpCmd(addr,len);
         break;
      case  C_MODULE:
         ModuleCmd(0);
         break;
      case  C_MONITOR:
         MonitorCmd();
         UpdateVP();
         break;
      case  C_NOMONITOR:
         NomonitorCmd(cmd_syntax.argv[0],cmd_syntax.argv[1]);
         UpdateVP();
         break;
      case  C_OPTIONS:
         OptionsCmd();
         break;
      case  C_OUTPUT:
         if (cmd_syntax.argc == 2)
            errorCode = emuOutput((U16)cmd_syntax.argv[0],(U8 *)&cmd_syntax.argv[1],1,0);  /* default BYTE */
         else  /* == 3 */
            errorCode = emuOutput((U16)cmd_syntax.argv[0],(U8 *)&cmd_syntax.argv[1],(U16)cmd_syntax.argv[2]+1,(U16)cmd_syntax.argv[2]);
         break;
      case  C_PATCH:
         if (!cmd_syntax.argc) {
            if (!patch.flag) sprintf(temp, " Patch is not set\n\r");
            else if (patch.flag == 1)
               sprintf(temp," skip codes (%04X:%04X to %04X:%04X)\r\n",
                  (U16) (patch.src_ent1 >> 16), (U16) patch.src_ent1,
                  (U16) (patch.src_ent1 >> 16), (U16) patch.src_ent2-1);
            else if (patch.flag == 2)
               sprintf(temp," insert codes (%04X:%04X to %04X:%04X) at %04X:%04X location\r\n",
                  (U16) (patch.start >> 16), (U16) patch.start,
                  (U16) (patch.start >> 16), (U16) patch.dest-1,
                  (U16) (patch.src_ent1 >> 16), (U16) patch.src_ent1);
            else if (patch.flag == 3)
               sprintf(temp," replace codes (%04X:%04X to %04X:%04X) by codes (%04X:%04X to %04X:%04X)\r\n",
                  (U16) (patch.src_ent1 >> 16), (U16) patch.src_ent1,
                  (U16) (patch.src_ent1 >> 16), (U16) patch.src_ent2-1,
                  (U16) (patch.start >> 16), (U16) patch.start,
                  (U16) (patch.start >> 16), (U16) patch.dest-1);
            DisplayStr(temp);
         } else if (cmd_syntax.argc == 1) {
            patch.flag=0;
         } else {
            if (!patch_addr.CSflag1) {
               emuGetReg(I86_REG, CS, &addr1);
               addr1 = (addr1 << 16) + patch_addr.addr1;
            } else addr1 = patch_addr.addr1;
            if (CheckOverflow((U16)(addr1>>16),(U16)addr1)) {
               errorCode = ABS_OVERFLOW;
               break;
            }
            if (cmd_syntax.argc == 3 || cmd_syntax.argc == 4) {
                if (!patch_addr.CSflag2) {
                       emuGetReg(I86_REG, CS, &addr2);
                   addr2 = (addr2 << 16) + patch_addr.addr3;
                 } else addr2 = patch_addr.addr3;
                    if (CheckOverflow((U16)(addr2>>16),(U16)addr2)) {
                   errorCode = ABS_OVERFLOW;
                       break;
                }
            }
            patch.src_ent1 = addr1;
            patch.start = addr2;
            patch.flag=cmd_syntax.argc-1;
            if (patch.flag&1) {
                 patch.src_ent2 = (addr1&0xffff0000) | patch_addr.addr2;
                 if (patch.flag == 1) break;
            }
            patch.dest = (patch.start & 0xffff0000) | patch_addr.addr4;
         }
         break;
      case  C_QUERY:
         QueryCmd();
         break;
      case  C_QUIT:
         QuitCmd();
         break;
      case C_QUALIFY:
         Transparent();
         break;
      case  C_READY:
         if (cmd_syntax.argc != 0)
            emuSetReady((char)cmd_syntax.argv[0]);
         emuGetReady(&tmpData);
         if (tmpData) DisplayStr(" Emulation memory Ready signal generated externally\n\r");
         else DisplayStr(" Emulation memory Ready signal generated internally\n\r");
         break;
      case  C_RECALL:
         RecallCmd(1);
        emuGetAllReg(cpuReg);
        RedrawFlag = (~MaskRedrawFlag) & (~REDRAWCOD);
        UpdateVP();
        UpdateCODVP(-1);
         break;
      case  C_REGISTER:
         RegisterCmd();
         break;
/****  case  C_REPEATDIAG:
         RepeatDiagnostic(1);
         break;   ****/
      case  C_RESET:
        if ((errorCode=emuReset()) != OK) break;
        // added by Chen, 08/30/94
        if ( MICE >= V20MAX && MICE <= V30MIN ) {
            NECflag = 1;
        }
        if ( cmd_syntax.argc != 0 ) {
            emuSetReg(I86_REG, CS, cmd_syntax.argv[0]);
            if ( cmd_syntax.argc == 2 ) {
                emuSetReg(I86_REG, IP,  cmd_syntax.argv[1]);
            }
        }
         emuGetAllReg(cpuReg);
         RedrawFlag = (~MaskRedrawFlag) & (~4);   // mask off REDRAWCOD
         UpdateVP();
         UpdateCODVP(-1); // backLevel = 0
         break;
      case  C_RESTART:  // added by Chen, 07/08/94
         if ( RunStart ) {
            emuSetReg(I86_REG, REG_PC, RunStart);
            UpdateCODVP(-1);
            RedrawFlag = (~MaskRedrawFlag) & (~REDRAWCOD);
            UpdateVP();
         }
         else {
            DisplayStr(" Program Starting Address is not available!\n\r");
         }
         break;
      case  C_SAVE:
         SaveCmd();
         break;
      case  C_SEARCH:
         if (!addr_block.CSflag1) {
            emuGetReg(I86_REG, CS, &addr1);
            addr1 = (addr1 << 16) + addr_block.addr1;
         } else addr1 = addr_block.addr1;
         addr2 = addr_block.addr1 + addr_block.length;
         if (CheckOverflow((U16)(addr1>>16), (U16)addr1)||
             CheckOverflow((U16)(addr2>>16), (U16)addr2) ) {
            errorCode = ABS_OVERFLOW;
            break;
         }
         errorCode=SearchCmd(addr1, addr_block.length, addr_block.buff,
                    (U16)addr_block.count);
         break;
      case  C_SETUP:
            Transparent();  // changed mode by Chen, 07/22/94
            break;
      case  C_SIZE:
         if (!cmd_syntax.argc) {
            if (sizeFlag) DisplayStr(" Memory access size is Word\n\r");
            else DisplayStr(" Memory access size is Byte\n\r");
         } else {
            sizeFlag = (int)cmd_syntax.argv[0];
            emuSetAccessSize(sizeFlag);
         }
         break;
      case  C_SOFTKEY:
         SoftkeyCmd(cmd_syntax.argv[0]);
         break;
      case  C_SRECALL:
            nFillFlag = TRUE;   // Chen 06/03/94
         SrecallCmd(cmd_syntax.asc);
         break;
      case  C_SSAVE:
         SsaveCmd(cmd_syntax.asc);
         break;
      case  C_STEP:
         errorCode = StepCmd();
         backLevel = 0;
         break;
      case  C_SYMBOL:
         SymbolCmd();
         break;                 // argv[0], argv[1]
      case  C_SYNC://argc= 0 or 2; input=0; off=0;
         if (cmd_syntax.argc != 0) {
            tmpData = 0;
            if (cmd_syntax.argv[0]) tmpData = 2;
            if (cmd_syntax.argv[1]) tmpData |=1;
            emuSetSync(tmpData);
         }
         emuGetSync(&tmpData);
         sprintf(temp," Sync Start in %s\n\r", ONOFF[tmpData&1]);
         DisplayStr(temp);
         sprintf(temp," Sync Slave out %s\n\r", ONOFF[tmpData >> 1]);
         DisplayStr(temp);
         break;
/**** case  C_SUSPEND:
         if (!cmd_syntax.argc) {
            if (timerReg == 0xff)  sprintf(temp," All CPU timers are resumed\n\r");
            else sprintf(temp," CPU timer-%1d is suspended\n\r", timerReg);
            DisplayStr(temp);
         } else if (cmd_syntax.argc == 1) {
                emuSetTimerReg(0xff);
                timerReg = 0xff;
         } else {
                emuSetTimerReg((char)cmd_syntax.argv[0]);
                timerReg=(int)cmd_syntax.argv[0];
         }
         break; *****/
      case  C_TIMEBASE:
      case  C_TRIGGER:
          Transparent();
          break;

      case  C_TLEVEL:
         if (!LAM2) DisplayStr(" MICE-III cannot support this command\n\r");
         else errorCode = TriggerLevelCmd();
         break;

      case  C_INITIALIZE:
      case  C_COVERAGE:
          if( !LAM2)
              DisplayStr(" MICE-III cannot support this command\n\r");
           else Transparent();
           break;
      case  C_UPDATE:
         UpdateCmd();
         break;
      case  C_UPLOAD:
         UploadCmd();
         break;
      case  C_URECALL:
         UrecallCmd();
         break;
      case  C_USAVE:
         UsaveCmd();
         break;
      case  C_VERIFY:
         if (cmd_syntax.argc != 0) { //set verify flag
            verifyFlag = cmd_syntax.argv[0];
            emuSetVerify(cmd_syntax.argv[0]);
         }
         else emuGetVerify(&verifyFlag); // get verify flag
         if (verifyFlag == ON) tempBuf = ONOFF[1];
         else tempBuf = ONOFF[0];
         sprintf(temp," Memory verification : %s\r\n",tempBuf);
         DisplayStr(temp);
         break;
      case  C_WAIT:
         if (MICE <= 8){
               if (cmd_syntax.argc != 0 )
                  emuSetWait(cmd_syntax.argv[0]);
               emuGetWait(&tmpData);
               sprintf(temp, " Inserted %x wait state\n\r", tmpData);
              DisplayStr(temp);
         }
         else DisplayStr(" this command doesn't exit in the firmware.\n\r");
         break;
      case  C_CLOSE:
         i = 0;
         if ( (cmd_logged == TRUE) && (cmd_flag == TRUE) ) {
            Blog_close(); i = 1;
            DisplayStr(" Command log file is closed!\n\r");
         }
         if ( (menu_logged == TRUE) && (menu_flag == TRUE) ) {
            CloseMenuLogFile(); i=1;
            DisplayStr(" Menu log file is closed!\n\r");
         }
         if ( (out_logged == TRUE) && (out_flag == TRUE) ) {
            Olog_close(); i=1;
            DisplayStr(" Journal file is closed!\n\r");
         }
         if (!i) prn_ferr(57);
         break;
      case C_VIEW:
         errorCode = ViewCmd(1);
         break;
      case C_WATCH:
         WatchCmd();
         break;
//      case C_MATH: // 06/06/1994 James
//         MathCmd();
//         break;
   } /* end of switch() */

// Chen 05/26/94
    memset(lineBuf, NULL, sizeof(lineBuf));
    posPtr = 0;

   if (errorCode) error_handle(errorCode);
}                 /* end of CmdProcess() */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
error_handle(int error_code)
{
int i;
char BUF[60];
   if (error_code > 0 || (error_code+MAX_ERROR) < 0) {
      sprintf(BUF," Invalid error code, %x !\n\r", error_code);
   } else {
      i = error_code + MAX_ERROR;
      if (error_code == ERROR_WRITE || error_code == NOT_READY)
         sprintf(BUF," %s%04X:%04X !\n\r",error_msg[i],HighWord(ret_addr1),LowWord(ret_addr1));
      else sprintf(BUF," %s!\n\r", error_msg[i]);
   }
   DisplayStr(BUF);
}

/**************************************************************************
**
** Name :
**
** Function
**
** Notes:
**
**************************************************************************/
CheckOverflow(U16 cs_val, U16 ip_val)
{
U32 l;
   l = (U32) cs_val;
   l = l * 16 + ip_val;
   if (l > 0xfffff) return(-1);else return(0);
}



/****************************************************************************
**
** Name     : IceMode()
**
** Function : MICE transparent command
**
** Note     : Coded by Matthew
**      In ICE mode, it doesn't support to modify HANdshake, BAud rate and
**      Prompt.     -- Chen
**
****************************************************************************/
IceMode()
{
char  *ptr, *ptr1, c, quotMark, key, cmdKeyword, continueMode;
char  buf1[60];
char *ptr2;
U8 goEndFlag;
U8 tmpBuf[512];

   lineBuf[511] = NULL;    // Chen 06/15/94
   continueMode = 0;

   if ( (ptr = strstr(lineBuf, "ICE")) != NULL ||
                (ptr2 = strstr(lineBuf, "ICe")) != NULL ){
        if ( ptr != NULL )
            ptr1 = ptr + 3 * sizeof(char);
        else
            ptr1 = ptr2 + 3 * sizeof(char);
         while ( *ptr1 == ' ') ptr1++;
         cmdKeyword = *ptr1;
       // added by Chen, 07/21/94
       strcpy(tmpBuf, strupr(ptr1));
       if ( tmpBuf[0] == 'B' && tmpBuf[1] == 'A' ) {
            strcpy(tmpBuf, "BAUD");
            ptr1 = tmpBuf;
       }
       else if ( tmpBuf[0] == 'H' && tmpBuf[1] == 'A' && tmpBuf[2] == 'N' ) {
            strcpy(tmpBuf, "HANDSHAKE");
            ptr1 = tmpBuf;
       }
       else if ( tmpBuf[0] == 'P' ) {
            strcpy(tmpBuf, "PROMPT");
            ptr1 = tmpBuf;
       }
       else if ( tmpBuf[0] == 'M' && tmpBuf[1] == 'O' ) {
            if ( MICE >= V20MAX && MICE <= V30MIN ) {
                strcpy(tmpBuf, "MOde");
                ptr1 = tmpBuf;
            }
       }
        send_str2(ptr1);
   }
   else return(0);

 /***
   if ((c=*ptr) == '"') {
                quotMark = c;
		ptr++;
		while ((cmdKeyword=*ptr++) == ' ');
		send(cmdKeyword);
		while ((c=*ptr++) != '"' && c) send(c);
   } else {
                cmdKeyword = *ptr;
   		send_str2(ptr);
   }
 ***/

   send(CR);
   for (;;) {
      key = chk_hlt();
      if (key == ESC || ESCflag) {
            ESCflag = 0;
            // ptr = tx_buf;
            // send(ESC);
            // while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
            // *--ptr = NULL;
            // DisplayStr(tx_buf);
            // marked by Chen, 07/21/94
            send_ESC();
            DisplayStr("\n\r");
            break;
      }
      if (key == ' ') {
      	send(key);
      	continueMode = 0;
      }
      ptr = tx_buf;
    // added by Chen, 07/21/94
    // in order to stop Go command when pressing ESC
    // while (((c=receive()) != HAND_SHAKE) && (c != CR)) *ptr++ = c;
      while ( (c=receive())!=HAND_SHAKE && c!=CR && !ESCflag ) *ptr++ = c;
      if ( ESCflag ) {
            ESCflag = 0;
            ptr = tx_buf;
            send(ESC);
            while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
            *--ptr = NULL;
            DisplayStr(tx_buf);
            break;
      }
      *ptr = NULL;
        // if ( c == HAND_SHAKE && *--ptr == '>') break;
        // changed by Chen, 07/21/94
        if ( c == HAND_SHAKE && *--ptr == '>' )
            break;
      DisplayStr(tx_buf);
      if (c == HAND_SHAKE) {
		if (strstr(tx_buf,"[ More ]") != NULL) {
			for (;;) {
	         	if (cmdfile_flag) {
    	        	GetOneLineFromCmdFile();
        	    	key = CmdFileBuf[0];
         		}
	         	else  key = get_key();
    	     	if (key == ESC) {
        	    	DisplayStr("\r\n");
            		send_ESC();
					return(OK);
    	     	}
        	 	if (key == SPACE || key == CR)  {
					send(key);
					while (receive() != CR);
					while (receive() != CR);
        	    	DisplayStr("\r\n");
					break;
				}
			}
		} else {
          // if ((cmdKeyword&0xdf) == 'A') {
          // changed by Chen, 07/21/94
          if ( (cmdKeyword&0xdf) == 'A' || (cmdKeyword&0xdf) == 'R' ) {
              // if (get_str2(buf1,50) == ESC) {
              // changed by Chen, 07/25/94
              if (get_str2(buf1,40) == ESC) {
                send_ESC();
                DisplayStr("\\\n\r");
                break;
              }
            // ptr = strtok(buf1, " \t\r\n");
            // changed by Chen, 07/20/94
              ptr = strtok(buf1, "\r\n");
              if (ptr != NULL) {
                ptr = buf1;
                while (c=*ptr++) {
                    send(c);
                    receive();
                }
              }
              send(CR);
          } else {
    		  if (continueMode) continue;
	          while ((key=chk_hlt()) != ESC && key != CR && key != LF) {
	          	if (cmdKeyword == 'S' || cmdKeyword == 's') 
	      	    	if (key == 'R' || key == 'r' || key == ' ') break;
    	      } 
	       	  if (key == ESC) {
    	      	send_ESC();
    			DisplayStr("\n\r");
        	  	break;
	          }
        	  if (key == 'r') send('R');
        	  else send(key);
    	      if (key == ' ') continueMode = 1;
    		}
          }
      }	
   }
   return( TRUE );
}


/****************************************************************
**  Name: Transparent()
**
**
**
**
****************************************************************/
PUBLIC RETCODE Transparent()
{
U8  *ptr, c, key;

    lineBuf[511] = NULL;    // Chen 06/15/94
    send_str2(lineBuf);
    send_CR_wait(CR);
	for (;;) {
	    ptr = tx_buf;
        while ( (c=receive()) != HAND_SHAKE && c != CR ) {
            *ptr++ = c;
        }
	    *ptr = NULL;
		if (c == HAND_SHAKE) {
			if (strstr(tx_buf,"[ More ]") != NULL) {
				DisplayStr(tx_buf);
				for (;;) {
		         	if (cmdfile_flag) {
    		        	GetOneLineFromCmdFile();
        		    	key = CmdFileBuf[0];
	         		}
		         	else  key = get_key();
    		     	if (key == ESC) {
        		    	DisplayStr("\r\n");
	            		send_ESC();
						return(OK);
    		     	}
        		 	if (key == CR)  {
	                    send(key);
						while (receive() != CR);
						while (receive() != CR);
        		    	DisplayStr("\r\n");
						break;
					}
				}
			} else break;
		} else DisplayStr(tx_buf);
   }
}


/******************************* End of File *****************************/

