/***************************************************************************
**
** File name : reg86.c for MICE-III(186)
**
** Changing :
**
** 9. Date -- 03/  /1994 By Frank
** 8. Date -- 03/  /1994 By Frank
** 7. Date -- 03/  /1994 By Frank
** 6. Date -- 03/  /1994 By Frank
** 5. Date -- 03/  /1994 By Frank
** 4. Date -- 03/  /1994 By Frank
** 3. Date -- 03/  /1994 By Frank
** 2. Date -- 03/12/1994 By Frank
**     1. add SetIntReg().
**
** 1. Date -- 03/11/1994 By Frank
**     0. modify REG86_TAB[], delete "" before and behind FS
**     1. modify char *line2_86 in parseDS(), delete "FS=%x"
**     2. modify char *line3_86 in parsePC(), add "%X".
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG86_DEFINE_
#include "reg86.h"
#endif

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

#ifndef _SD_ABI_EXT_
#include "sdabiext.h"
#endif

#define OK ICE_OK
#define CR 0xd
#define HAND_SHAKE 0x3

/**************************************************************************
**
** Local variables
**
***************************************************************************/
int RegMode;

unsigned char   RegValid[REG_MAX];
unsigned char   flag_reg[11];

char *REG86_TAB[]={
        "AX","BX","CX","DX","SP","BP","SI","DI","DS","SS","ES","CS","IP","FS"
};

char *REGV20_TAB[]={
		"AW","BW","CW","DW","SP","BP","IX","IY","DS0","SS",
		"DS1","PS","PC","PSW",
		"M","V","D","I","B","S","Z","A","P","C"
};

U16 myCpuReg[23];


/* the array of registers is organized as follows:
    0   1   2   3   4   5   6   7   8   9  10  11  12
   ax, bx, cx, dx, sp, bp, si, di, ds, ss, es, cs, ip

   followed by the flags. Flags are full size for speed.
   13  14  15  16  17  18  19  20  21
   of, df, if, tf, sf, zf, af, pf, cf

   The register numbers are as follows:
      -3     -2     -1   0   1   2   3   4   5   6   7   8   9  10  11  12
   cs:ip, ss:sp, ss:bp, ax, bx, cx, dx, sp, bp, si, di, ds, ss, es, cs, ip,

   13  14  15  16  17  18  19  20  21  22  23  24  25  26  27  28  29
   of, df, if, tf, sf, zf, af, pf, cf, al, bl, cl, dl, ah, bh, ch, dh
*/
/* flags are organized as follows: (from bit 15 down)
   XX XX XX XX OF DF IF TF SF ZF XX AF XX PF XX CF
    0  0  0  0  0  0  1  0  0  0  0  0  0  0  1  0   is 0202 */

/**************************************************************************
**
** Externals
**
**************************************************************************/
extern singleIntReg[];

/**************************************************************************
**
** LOCAL
**
**************************************************************************/

setAllFlags(unsigned int id, unsigned int val);
getAllFlags();
parsePC(unsigned char *buffer);
parseDS(unsigned char *buffer);
parseAX(char *buffer);
STATUS emuGetAllReg(U16 *cpuReg);
STATUS emuGetReg(REG_MODE regMode, int regId,U32 *content);
STATUS GetReg (REG_MODE regMode, S16 regId, U32 *content);
STATUS emuSetReg(REG_MODE regMode, S16 regId,U32 content);
STATUS SetReg(REG_MODE regMode, S16 regId, U32 content);
STATUS emuSetCoReg(S16 coRegId,U8 *content);

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : PrintIntReg()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
emuPrintIntReg()
{
char *ptr, c;
   send_str2("R INT");
   send_CR_wait(CR);
   for (;;) {
       ptr = tx_buf;
       while ((c=receive()) != CR && c != HAND_SHAKE) *ptr++ = c;
       if (c == HAND_SHAKE) break;
       *ptr = 0;
       DisplayStr(tx_buf);
   }
   return (OK);
}  /* end of PrintIntReg() */

/**************************************************************************
**
** Name : PrintCopReg()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
emuPrintCopReg()
{
char *ptr, c;
   send_str2("R COP");
   send_CR_wait(CR);
   for (;;) {
       ptr = tx_buf;
       while ((c=receive()) != CR && c != HAND_SHAKE) *ptr++ = c;
       if (c == HAND_SHAKE) break;
       *ptr = 0;
       DisplayStr(tx_buf);
   }
   return (OK);
}  /* end of PrintCopReg() */

/**************************************************************************
**
** Name : emuSetCoReg(reg_id,content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetCoReg(S16 coRegId,U8 *content)
{
   DisplayStr(" Coprocessor can not accept seted values.\n\r");
   return(OK);
}  /* end of emuSetCoReg(regMode,reg_id,content) */


/**************************************************************************
**
** Name : emuGetCoReg (S16 regId, U8 *content)
**
** Function
**    Input  :
**    Output :
**
** Notes:  Coded by Frank
**
**************************************************************************/
STATUS emuGetCoReg (S16 regId,U8 *content)
{
extern char *copRegTable[];
char *ptr, c;

   send_str2("R COP");
   send_CR_wait(CR);

   DisplayStr("               SIGNIFICAND          EXPONENT         SIGN          TAG\n\r");

   DisplayStr("         15-00 31-16 47-32 63-48     78-64            79 \n\r");
   for (;;) {
       ptr = tx_buf;
       while ((c=receive()) != CR && c != HAND_SHAKE) *ptr++ = c;
       if (c == HAND_SHAKE) break;
       *ptr = 0;
       if (strstr(tx_buf, copRegTable[regId]) != 0) DisplayStr(tx_buf);
   }
   send_ESC();
  // memcpy(content, tx_buf, i);
   return (OK);
}   /* end of emuGetCoReg (reg_id) */

/**************************************************************************
**
** Name : SetReg(regMode, reg_id, content)
**
** Function  only set I86_REG, regmode is not used.
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
extern int NECflag;

STATUS SetReg(REG_MODE regMode, S16 regId, U32 content)
{
char *ptr, c;
int i;
unsigned long l;


   if ( !NECflag){
	   if (regId >= OF && regId <= CF) {
			   cpuReg[regId] = content & 1;
			   setAllFlags(regId, cpuReg[regId]);
			   return(OK);
	   }
	   ptr = REG86_TAB[regId];

	   if (regId >= AL && regId <= BL) {
					   regId = regId - AL;
					   content += cpuReg[regId] & 0xff00;
	   }
	   if (regId >= AH && regId <= BH) {
					   regId = regId - AH;
					   content = (cpuReg[regId] & 0xff) + ((content << 8) & 0xff00);
	   }

   }
   else ptr = REGV20_TAB[regId];
   if (!*ptr) return(OK);

   send('R');
   send(' ');
   while (c = *ptr++) send(c);
   send(CR);
   while(receive() != HAND_SHAKE);
   send_long(content);
   send_CR_wait(HAND_SHAKE);
   send_ESC();
   if (regId == FLAGS) {
           cpu_flags=content;
           getAllFlags();
           cpuReg[regId]=content & 0xffff;
           RegValid[regId]=1;
   }
   else{
      cpuReg[regId]=content & 0xffff;
      RegValid[regId]=1;
   }
   return(OK);
}    /* end of SetReg(regMode,regId, content) */


/**************************************************************************
**
** Name : emuSetReg(REG_MODE regMode, S16 regId, U32 content)
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:  this function is the root of interface, from here
**         split into I86_REG and INTERNAL_REGISTER two parts.
**
**************************************************************************/
STATUS emuSetReg(REG_MODE regMode, S16 regId,U32 content)
{
U32 regData;
STATUS status;

   status = ICE_OK;
   switch (regMode) {
      case I86_REG :
         switch (regId) {
            case REG_PC :
               regData = (content >> 16) & 0xffff;
               status=SetReg(regMode,CS, regData);
               if (status != ICE_OK) return(status);
               regData = content & 0xffff;
               status=SetReg(regMode,IP, regData);
               break;
            case REG_SP :
               regData = (content >> 16) & 0xffff;
               status=SetReg(regMode,SS, regData);
               if (status != ICE_OK) return(status);
               regData = content & 0xffff;
               status=SetReg(regMode,RSP, regData);
               break;
            case REG_FP :
               regData = (content >> 16) & 0xffff;
               status=SetReg(regMode,SS, regData);
               if (status != ICE_OK) return(status);
               regData = content & 0xffff;
               status=SetReg(regMode,BP, regData);
               break;
            default :
               status=SetReg(regMode,regId, content);
         }
         break;
      case INTERNAL_REG :
         status=SetIntReg(regId, content);
         break;
   }
   return (status);
}      /* end of emuSetReg(regMode, regId,content) */


/**************************************************************************
**
** Name : STATUS emuGetReg(REG_MODE regMode, int regId,U32 *content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes: 1. To get the register contents of the INTERNAL_REG group,
**           a conversion process named ConvertInternalRegID() is a must.
**           So another function named GetRegister() is recommanded.
**
**************************************************************************/
STATUS emuGetReg(REG_MODE regMode, int regId, U32 *content)
{
STATUS status;
U32 regHigh, regLow;

   switch (regMode) {
      case I86_REG :
         //if (RegValid[regId]) {
         //   *content=(U32)cpuReg[regId];
         //   return(ICE_OK);
         //}
         switch(regId) {
            case REG_PC :
               status=GetReg(regMode, CS, &regHigh); /* regMode not used in MICE-III */
               if (status != ICE_OK) return(status);
               status=GetReg(regMode, IP, &regLow);
               *content = (regHigh << 16) + (U16)regLow;
               break;
            case REG_SP :
               status=GetReg(regMode, SS, &regHigh);
               if (status != ICE_OK) return(status);
               status=GetReg(regMode,RSP, &regLow);
               *content = (regHigh << 16) + (U16)regLow;
               break;
            case REG_FP :
               status=GetReg(regMode,SS, &regHigh);
               if (status != ICE_OK) return(status);
               status=GetReg(regMode,BP, &regLow);
               *content = (regHigh << 16) + (U16)regLow;
               break;
            default :
               status = GetReg(regMode,regId, &regHigh);
               *content = regHigh;
               break;
         }
         break;
      default:
         break;
   }
   return (status);
}  /* end of emuGetReg (regId) */

/**************************************************************************
**
** Name : GetReg (regMode, regId, U32 *content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS GetReg (REG_MODE regMode, S16 regId, U32 *content)
{
char c, *ptr;
unsigned long l;
unsigned long rx_long();

   if ((regId < (NUM_REGS -1)) && RegValid[regId]) {
           l=(unsigned long) cpuReg[regId];
           *content = l;
           return(OK);
   }
   if (regId >= OF && regId <= CF) {
           *content = cpuReg[regId];
           return(OK);
   }
   if (regId == FLAGS) {
                *content = cpu_flags;
                return(OK);
   }

   ptr = REG86_TAB[regId];
   if (!*ptr) return(OK);
   send('R');
   send(' ');
   while (c = *ptr++) send(c);
   send_CR_wait(CR);
   l=rx_long();
   send_ESC();
   RegValid[regId]=1;
   if (regId >= AL && regId <= BL) *content = l & 0xff;
   if (regId >= AH && regId <= BH) *content = (l >> 8) & 0xff;
   return(OK);
}            /* end of GetReg (  ) */


/**************
STATUS GetIntReg (REG_MODE regMode, S16 regId, U32 *content)
{
char c, *ptr;
unsigned long l;
unsigned long rx_long();

   switch( regMode){
      case INT_REG_MASTER:
          ptr = intRegMaster[regId];
          break;
      case INT_REG_SLAVE:
          ptr = intRegSlave[regId];
          break;
      case INT_REG_186EB:
          ptr = intReg186EB[regId];
          break;
      case INT_REG_186EC:
          return(-1);
   }

   if (!*ptr) return(OK);
   send('R');
   send(' ');
   send_str2("IN ");
   while (c = *ptr++) send(c);
   send(CR);
   l=rx_long();
   send_ESC();
   RegValid[regId]=1;
   return(OK);
}
*************/

/**************************************************************************
**
** Name : emuGetAllReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetAllReg(U16 *cpuReg)
{
char *ptr, c;
int i;

   send('R');
   send_CR_wait(CR);
   ptr = tx_buf;
   while((c=receive()) != CR) if (c > 0) *ptr++ = c;
   *--ptr=0;
   if ( strstr(tx_buf, "stopped") != 0 )
        i = ICE_HALT_USER;
   else i = check_error(tx_buf);
   if (i != OK) {
           while(receive() != HAND_SHAKE);
           return(i);
   }
   parseAX(tx_buf);
   ptr=tx_buf;
   while ((c=receive()) != CR) if (c > 0) *ptr++=c;
   *--ptr=0;
   parseDS(tx_buf);
   ptr=tx_buf;
   while ((c=receive()) != CR) if (c > 0) *ptr++=c;
   *--ptr=0;
   parsePC(tx_buf);
   while ((c=receive()) != HAND_SHAKE) ;
   for (i=0;i<NUM_REGS;i++) RegValid[i]=1;
   getAllFlags();
   memcpy(cpuReg,myCpuReg,2*REG_NO);
   memcpy(cpu_regs,myCpuReg,2*NUM_REGS);
   return(OK);
}

/**************************************************************************
**
** Name : parseAX
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
extern int NECflag;
parseAX(char *buffer)
{
char *line1_86	=" AX=%hx  BX=%hx  CX=%hx  DX=%hx  SP=%hx  BP=%hx  SI=%hx  DI=%hx";
char *line1_V20 =" AW=%hx  BW=%hx  CW=%hx  DW=%hx  SP=%hx  BP=%hx  IX=%hx  IY=%hx";
char *line1_M3_286="AX=%x BX=%x CX=%x DX=%x SP=%x BP=%x SI=%x";

        if (MICE == I80286) {
                sscanf(buffer,line1_M3_286,&myCpuReg[AX],&myCpuReg[BX],
                        &myCpuReg[CX],&myCpuReg[DX],&myCpuReg[RSP],
                        &myCpuReg[BP],&myCpuReg[SI],&myCpuReg[DI]);
		} else if (MICE >= V20MAX && NECflag == 1) {
				sscanf(buffer,line1_V20,&myCpuReg[AX],&myCpuReg[BX],
                        &myCpuReg[CX],&myCpuReg[DX],&myCpuReg[RSP],
                        &myCpuReg[BP],&myCpuReg[SI],&myCpuReg[DI]);
		} else {
                sscanf(buffer,line1_86,&myCpuReg[AX],&myCpuReg[BX],
                        &myCpuReg[CX],&myCpuReg[DX],&myCpuReg[RSP],
                        &myCpuReg[BP],&myCpuReg[SI],&myCpuReg[DI]);
        }
}                 /* end of parseAX(buffer) */

/**************************************************************************
**
** Name : parseDS
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
parseDS(unsigned char *buffer)
{
char *line2_86 =" DS=%x  SS=%x  ES=%x  CS=%x  IP=%x";
char *line2_V20=" DS0=%x  SS=%x DS1=%x  PS=%x  PC=%x";
char *line2_M3_286="DI=%x DS=%x SS=%x ES=%x CS=%x IP=%x MS=%x %x";
long dummy;
    if (MICE == I80286) {
        sscanf(buffer,line2_M3_286,&myCpuReg[DI],&myCpuReg[DS],
                &myCpuReg[SS],&myCpuReg[ES],&myCpuReg[CS],
                &myCpuReg[IP],&dummy,&cpu_flags);
    }
    else if (MICE >= V20MAX && NECflag == 1) {
        sscanf(buffer,line2_V20,&myCpuReg[DS],&myCpuReg[SS],
                &myCpuReg[ES],&myCpuReg[CS],&myCpuReg[IP]);
    }
    else {
        sscanf(buffer,line2_86,&myCpuReg[DS],&myCpuReg[SS],
               &myCpuReg[ES],&myCpuReg[CS],&myCpuReg[IP]);
    }
}                 /* end of parseDS(buffer) */

/**************************************************************************
**
** Name : parsePC(unsigned char *buffer)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
parsePC(unsigned char *buffer)
{
   char *line3_86 = " PC=%lX                                       %X   %x";
   char *line3_V20 = " IP=%lX                                       %X   %x";
   long dummy;

   if (MICE >= V20MAX && MICE <= V30MIN && NECflag == 1)
		sscanf(buffer,line3_V20,&dummy,&myCpuReg[FLAGS],&cpu_flags);
   else sscanf(buffer,line3_86,&dummy,&myCpuReg[FLAGS],&cpu_flags);
}                 /* end of parsePC(buffer) */

/**************************************************************************
**
** Name : getAllFlags()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
getAllFlags()
{
unsigned int i;

   i = cpu_flags;
   myCpuReg[CF] = (i & 0x01) && 1;
   myCpuReg[PF] = (i & 0x04) && 1;
   myCpuReg[AF] = (i & 0x10) && 1;
   myCpuReg[ZF] = (i & 0x40) && 1;
   myCpuReg[SF] = (i & 0x80) && 1;
   myCpuReg[TF] = (i & 0x100) && 1;
   myCpuReg[IF] = (i & 0x200) && 1;
   myCpuReg[DF] = (i & 0x400) && 1;
   myCpuReg[OF] = (i & 0x800) && 1;
}  /* end of getAllFlags() */

/**************************************************************************
**
** Name : setAllFlags(id, val)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
setAllFlags(unsigned int id, unsigned int val)
{
unsigned int i;

   i = cpu_flags;
   switch (id) {
   case CF:
           i =  (i & 0xfffe) | val;
           break;
   case PF:
           if (val) i = (i & 0xfffb) | 0x4;
           else i &= 0xfffb;
           break;
   case AF:
           if (val) i = (i & 0xffef) | 0x10;
           else i &= 0xffef;
           break;
   case ZF:
           if (val) i = (i & 0xffbf) | 0x40;
           else i &= 0xffbf;
           break;
   case SF:
           if (val) i = (i & 0xff7f) | 0x80;
           else i &= 0xff7f;
           break;
   case TF:
           if (val) i = (i & 0xfeff) | 0x100;
           else i &= 0xfeff;
           break;
   case IF:
           if (val) i = (i & 0xfdff) | 0x200;
           else i &= 0xfdff;
           break;
   case DF:
           if (val) i = (i & 0xfbff) | 0x400;
           else i &= 0xfbff;
           break;
   case OF:
           if (val) i = (i & 0xf7ff) | 0x800;
           else i &= 0xf7ff;
   }
   send_str("R FS");
   send_long(i);
   send_CR_wait(HAND_SHAKE);
   send_ESC();
   cpu_flags=i;
}                 /* end of setAllFlags(id, val) */

/**************************************************************************
**
** Name : STATUS SetIntReg(S16 regId, U32 content)
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS SetIntReg(S16 regId, U32 content)
{
char *ptr, c;

   send_str2("R ");
   send_str2(singleIntReg);
   send(CR);
   while(receive() != HAND_SHAKE);
   send_long(content);
   send_CR_wait(HAND_SHAKE);
   send_ESC();

   return(OK);
}  /* end of SetIntReg(regId,content) */

/**************************** End of File **********************************/
