/***************************************************************************
**
** File name : sdabi.c for MICE-III (186)
**
**
**
** Changing :
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


/***************************************************************************
**

**    Include files
**
***************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <time.h>
#include  <signal.h>
#include  <malloc.h>
#include "vv_sys.h"
#include "usym1.h"

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif

#ifndef _REG86_DEFINE_
#include "reg86.h"
#endif

#ifndef _ABI_FUNC_
#include "abifunc.h"
#endif

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

#include "sdabiglb.h"

#define HAND_SHAKE 0x3
#define CR 0xd

/**********************************************************************
**
**
**                EXTERN
**
**
***********************************************************************/
extern WINDOWPTR  VPLink;
extern int  MaskRedrawFlag;
extern unsigned long RedrawFlag;
/* HIGH-WORD:  foreground window mask
   LOW-WORD :  get content & update window mask */
extern int AbortTarget;
extern int targetCPU;
extern char *cpu[];
extern int BreakNumber;
extern tick_temp;
extern char far cmdfile_flag;
extern int goStepFlag;
extern char MICEBuf[];
extern int P_DATA;
extern char mapTable[];
extern int ESCflag;
extern int downLoadMode;
extern struct attribute env; // added for PSA and LSA, 1994.10.14
extern char CpuNameForLsa[20];

/**********************************************************************
**
** LOCAL VARIABLES
**
***********************************************************************/
int breakReason;
int bufCount;
unsigned long oldCS;
char lastPrompted=TRUE; // a flag about broke status has been displayed or not

char level_def[]="T L A EV1 OR EV2 OR EV3 OR EV4 T ON ";
char trig_def1[]="T A BACK";
char trig_def2[]="T TI ON T ON";
char event_clr[]="E   CL";
char OR_cmd[]="T EV1 OR EV2 OR EV3";
char ver_cmd[]="V ON";
char qual_clr[]="Q   CL";
char qual_en[]="Q   EN";
char qual_dis[]="Q   DIS";
char init_en[]="INI EN";
char init_clr[]="INI CL";
char level_clr[]="T L   CL";
char trigger_clr[]="T    CL";
char tx_buf2[240];
int fwVersion;

/**********************************************************************
**
** FUNCTION PROTOTYPE DECLARATIONS
**
***********************************************************************/
U32 emuGetPC ();
GetCpuMode(int *mode);
chk_ID(VOID);
init_sw(VOID);
chk_LAM2();
chk_HEMM();
int emuInit();
ABS86_comp_addr(U32 addr1, U32 addr2);
emuSetBrk(unsigned long addr);
emuClrBrk(U32 addr);
S16 emuRunUntil(U32 addr);
S16 sw_restore(VOID);
S16 sw_set(VOID);
STATUS emuRun(U8 runFlag);
VOID SimIRET(VOID);
U32 getStack(U32 l,U16 seg);
STATUS SdEmuSetMemN(ADDR addr, U8 *buff, U16 patternLen);

/**************************************************************************
**
** Name : SdEmuSetMemN
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS SdEmuSetMemN(ADDR addr, U8 *buff, U16 patternLen)
{
STATUS status;

    status = emuSetMemN(addr, buff, patternLen);
    UpdateBkptData(addr, (U32)patternLen);
    return(status);
}

/**************************************************************************
**
** Name : getStack
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
U32 getStack(U32 l,U16 seg)
{
U32 ll;
U8 addrBuff[4];
U16 i, j;

   if (seg) j = 4;
   else j = 2;
   emuGetMemN(l,addrBuff,j);
   if (seg) ll = *(U16 *)addrBuff;
   else ll = *(U32 *)addrBuff;
   for (i=j; i > 0; i--) ll = ll*256 + addrBuff[i-1];
   return (ll);
}

/**************************************************************************
**
** Name :  SimIRET
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
VOID SimIRET(VOID)
{
U32 spPtr, retSR, retPC;

   emuGetAllReg(cpuReg);
   emuGetReg(I86_REG,REG_SP, &spPtr);
   retPC = getStack(spPtr, 1);
   retSR = getStack(spPtr+4, 0) & 0xffff;
   emuSetReg(I86_REG,REG_PC, retPC-1);
   emuSetReg(I86_REG,REG_SP, (spPtr&0xFFFF0000L)+((spPtr+6)&0x0FFFFL));
   emuSetReg(I86_REG,FLAGS, retSR & 0xfdff);
}

/**************************************************************************
**
** Name : emuRun
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuRun(U8 runFlag)
{
int i, c;
unsigned long emuGetPC ();
unsigned long l;
unsigned char cont;
unsigned int retval;
char *ptr;

        break_id=0;
	if (!runFlag) {
            if (for1step() == MICE_HALT) return(MICE_HALT);
            if (!noRAM) sw_set();
	}
      //  for (i=0; i < 256; i++) bno[i] = 0;
	if (runFlag) {
            send_str("G R");
            return(OK);
	}
	send('G');
	send(CR);
	while (receive() != CR);
        while (receive() != CR);
        ptr = tx_buf2;
	for (;;) {
            if((c=receive()) > 0) {
                 if (c == HAND_SHAKE) break;
                 else *ptr++ = c;
            }
            if (c != -1) continue;
            ESCflag=0;
            *ptr=NULL;
            i = check_error(tx_buf2);
            if (i != OK) {
               send_ESC();
               return(i);
            }
            //Frank 6/13/1994
            if ( strstr(tx_buf2, "still running") ) return(OK);
            send_ESC();
            if (!noRAM) sw_restore();
            if ((i=emuGetAllReg(cpuReg)) != OK) return(i);
            return(HALT_USER);
	}
	*--ptr=NULL;
	i = check_error(tx_buf2);
	if (i != OK) return(i);
       //Frank 6/13/1994
       if ( strstr(tx_buf2, "still running") ) return(OK);
	if (strstr(tx_buf2,"EV") != NULL) { 
		ptr = tx_buf2;
		while(*ptr++ != 'V');
		break_id = *ptr - '0';
	}

	emuGetAllReg(cpuReg);
	if (break_id != 4+LAM2) {
		breakReason=BREAK;
           // Marked by Frank, 7/18/94
           //     if (break_id == 5+LAM2) {
           //             if (!noRAM) SimIRET();
           //     } else
                if (break_id == 6+LAM2) {
                      breakReason=BREAK_I;
		} else { 
          /* check the S/W trap already executes or not */
			if (emuGetPC() == VectAdr) {
				SimIRET();
				breakReason=BREAK_I;
			}
		}
	}
	sw_restore();
	return(BREAK);
}

/**************************************************************************
**
** Name : sw_set
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 sw_set(VOID)
{
int i;

   /*   init_sw(); */
   for (i=0;i<BreakNumber;i++) {
      if (SwBreak[i].exists)
         emuSetMem(SwBreak[i].address,0xcc);
   }
   return(OK);
}

/**************************************************************************
**
** Name : sw_restore
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 sw_restore(VOID)
{
int i;

   for (i=0;i<BreakNumber;i++) {
      if (SwBreak[i].exists)
         emuSetMem(SwBreak[i].address, SwBreak[i].data);
   }
}

/**************************************************************************
**
** Name : emuRunUntil
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
S16 emuRunUntil(U32 addr)
{
char c, *ptr;
int i, iDefinedFlag ;

       i = OK;
       iDefinedFlag = emuSetTempBP(4+LAM2,addr);

       ptr = tx_buf;
       for (;;) {
           if (emuGetPC() == addr)
                for1step();
           send('G');
           send_CR_wait(CR);

           while ( (c=receive()) != HAND_SHAKE){
               if (c <= 0 ){
                   // for 8086F firmware, 6/29/94
				   if ( MICE == I8086MAX);
                   else   send_ESC();
                   if (strstr( tx_buf, "halted") != NULL)
                     i = -1;
                   else i = HALT_USER;
                   goto OUT;
                }
                else if (c != '>') *ptr++ = c;
             }
             *ptr-- = 0;
             ptr = tx_buf;
             if (strstr( tx_buf, "EV") != NULL) break;
        }
OUT:
		emuRetTempBP(iDefinedFlag, 4+LAM2);
		emuGetAllReg(cpuReg);
                return(i);
}

/**************************************************************************
**
** Name : emuClrBrk
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
emuClrBrk(U32 addr)
{
int i;

   for (i=0;i<256;i++) {
      if (SwBreak[i].exists && !(ABS86_comp_addr(SwBreak[i].address,addr)))
         break;
   }
   if (i == 256) return(BAD_IN);
   SwBreak[i].exists=0;
   return(OK);
}

/**************************************************************************
**
** Name : emuSetBrk
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
emuSetBrk(unsigned long addr)
{
int i, j;
char c,*ptr;
char tmpBuf[10];

   for (i=0;i<256;i++)
      if (SwBreak[i].exists && !(ABS86_comp_addr(SwBreak[i].address,addr)))
         break;
   if (i != 256) return(BAD_IN);
   for (i=0;i<256;i++)
      if (!SwBreak[i].exists) break;
   if (i == 256) return(MICE_LIMIT);
   emuGetMemN(addr,tmpBuf,1);
   SwBreak[i].data=tmpBuf[0];
   SwBreak[i].exists=1;
   SwBreak[i].address=addr;
   return(i);
}

/**************************************************************************
**
** Name : ABS86_comp_addr
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
ABS86_comp_addr(U32 addr1, U32 addr2)
{
unsigned long l1, l2;

   l1 = ((addr1 & 0xffff0000) >> 12) + (addr1 & 0xffff);
   l2 = ((addr2 & 0xffff0000) >> 12) + (addr2 & 0xffff);
   if (l1 == l2) return(0);
   else if (l1 > l2 ) return (1);
   else return (-1);
}


/**************************************************************************
**
** Name : emuInit()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:   Dome told us not to change the initial setting of MICE-III, such
**          as MAP, CONTROL, EVENT, SIZE and VERIFY. So that I rewrite this
**          routine. 12/28/94
**
**************************************************************************/
int emuInit()
{
extern int sizeFlag;
extern int verifyFlag;

int i;

        existTraceBoard = ON;
        VNFlag=0;

        start_up();

        if (chk_ID() == ERROR_MICE) return(ERROR_MICE);
        if (MICE >= V20MAX) emuGetMode();

        chk_HEMM();

        chk_LAM2();

        emuGetAccessSize(&sizeFlag);

        emuGetVerify(&verifyFlag); // get verify flag

        for (i=0;i<257;i++) SwBreak[i].exists = 0;

        return(OK);

}   // end of emuInit()


/*
int emuInit()
{
int i;

        existTraceBoard = ON;
        VNFlag=0;
        start_up();
        chk_LAM2();

        chk_HEMM();

        send_str("RECALL");

        if (chk_ID() == ERROR_MICE) return(ERROR_MICE);
        if (MICE >= V20MAX) emuGetMode();

        send_str("CON DIS");
        send_str(event_clr);

        emuSetAccessSize(0); // default the size as byte
        emuGetAccessSize(&sizeFlag);

        send_str(ver_cmd);
        emuGetVerify(&verifyFlag); // get verify flag

        for (i=0;i<257;i++) SwBreak[i].exists = 0;
    //    emuGetAllReg(cpuReg);

        init_sw();

        return(OK);
}
*/

/**************************************************************************
**
** Name : chk_LAM2()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
chk_LAM2()
{
unsigned char *ptr, c;

        LAM2 = 0;
        send_str_wait_CR(cov_cmd);
        ptr = tx_buf;
        while ((c=receive()) != HAND_SHAKE)     *ptr++ = c;
        if (strstr(tx_buf, "error") == NULL) LAM2=2;
}

/**************************************************************************
**
** Name : chk_HEMM()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
chk_HEMM()
{
    unsigned char *ptr, c;

    memset(tx_buf, '\0', 512);
    ptr = tx_buf;

// Chen, 12/27/94
// Dome told us not to do
//        send_str("MAP 0 FFFFF E");
//        send_str_wait_CR("MAP 0 FFFFF I");

    send_str_wait_CR("HELP MAP");

    while ( (c=receive()) != HAND_SHAKE )
//        if (c != '>') *ptr++ = c;
        *ptr++ = c;

    if ( MICE >= I8088MAX && MICE <= V30MIN ) {
        HEMM = 0;
    }
    else if ( NULL != strstr(tx_buf, "ER|G") ) {
        HEMM = 1;
    }
    else {
        HEMM = 0;
    }

//        if ( strlen(tx_buf) > 5)
//                HEMM = 0;
//         else
//                HEMM = 1;

}

/**************************************************************************
**
** Name : init_sw
**
** Function : initialize software breakpoint
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
init_sw(VOID)
{
char *ptr;
unsigned long l, l2;
unsigned long getStack();
int flag =0;

     noRAM = 0;
     if (!VNFlag) {
        l=0xc;
        if (emuSetMemN(l,newVect,4)  != OK) noRAM = 1;
        if (!noRAM)
                if (emuSetMem(VectAdr,0xcf) != OK) noRAM = 1;
        if (!noRAM) flag = emuSetTempBP(LAM2+5,VectAdr);
     } else noRAM=1;
     return(flag);
}

/**************************************************************************
**
** Name :   chk_ID
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
chk_ID(VOID)
{
char *ptr, c;

        send_str2("ID");
        send_CR_wait(CR); /* send CR and skip first line */
        ptr=tx_buf;
        while ((c=receive()) != HAND_SHAKE) *ptr++=c;
        *--ptr=0;

        if (strstr(tx_buf, "80C186EB")  != NULL) {
           targetCPU=MICE=  I80C186EB;
           env.Mmodel = 39;
           strcpy (CpuNameForLsa, "80C186");
        }
        else if (strstr(tx_buf, "80C188EB")  != NULL) {
           targetCPU=MICE=  I80C188EB;
           env.Mmodel = 39;
           strcpy (CpuNameForLsa, "80C186");
         }
         else if (strstr(tx_buf, "80C186") != NULL) {
           targetCPU=MICE=  I80C186XL;
           env.Mmodel = 39;
           strcpy (CpuNameForLsa, "80C186");
         }
         else if (strstr(tx_buf, "80C188") != NULL) {
           targetCPU=MICE=  I80C188XL;
           env.Mmodel = 39;
           strcpy (CpuNameForLsa, "80C186");
         }
         else if (strstr(tx_buf, "8086(MAX)") != NULL ) {
           targetCPU=MICE=  I8086MAX;
           env.Mmodel = 37;
           strcpy (CpuNameForLsa, "MAX86");
         }
         else if (strstr(tx_buf, "8086(MIN)") != NULL ) {
           targetCPU=MICE=  I8086MIN;
           env.Mmodel = 37;
           strcpy (CpuNameForLsa, "MIN86");
         }
         else if (strstr(tx_buf, "8088(MAX)")      != NULL ) {
           targetCPU=MICE=  I8088MAX;
           env.Mmodel = 37;
           strcpy (CpuNameForLsa, "MIN88");
         }
         else if (strstr(tx_buf, "8088(MIN)")      != NULL ) {
           targetCPU=MICE=  I8088MIN;
           env.Mmodel = 37;
           strcpy (CpuNameForLsa, "MIN88");
         }
         else if (strstr(tx_buf, "V20(MAX)")      != NULL ) {
           targetCPU=MICE=  V20MAX;
           env.Mmodel = 37;
           strcpy (CpuNameForLsa, "V20");
         }
         else if (strstr(tx_buf, "V20(MIN)")      != NULL ) {
           targetCPU=MICE=  V20MIN;
           env.Mmodel = 37;
           strcpy (CpuNameForLsa, "V20");
         }
         else if (strstr(tx_buf, "V30(MAX)")      != NULL ) {
           targetCPU=MICE=  V30MAX;
           env.Mmodel = 37;
           strcpy (CpuNameForLsa, "V30");
         }
         else if (strstr(tx_buf, "V30(MIN)")      != NULL ) {
           targetCPU=MICE=  V30MIN;
           env.Mmodel = 37;
           strcpy (CpuNameForLsa, "V30");
         }
         else if (strstr(tx_buf, "80286")         != NULL ) {
           targetCPU=MICE=  I80286;
           env.Mmodel = 41;
           strcpy (CpuNameForLsa, "80286");
         }
         else return(ERROR_MICE);

        return(OK);
}

/**************************************************************************
**
** Name : GetCpuMode(mode)
**
** Function  :
**
**    Input  : none
**
**    Output : 0 -- C186 master, 1 -- C186 slave, 2 -- 186EB
**
** Notes:
**
**************************************************************************/
GetCpuMode(int *mode)
{
extern int MICE;

   *mode = 0;
   if (MICE == I80C188EB || MICE == I80C186EB) {   // 188EB, 186EB
      *mode = 2;
      return;
   }
   if (MICE == I80C188EC || MICE == I80C186EC) {   // 188EC, 186EC
      *mode = 3;
      return;
   }
}  /* end of GetCpuMode() */

/**************************************************************************
**
** Name :   emuGetPC
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
U32 emuGetPC ()
{
U32 l;
//    RegValid[CS] = 0;
//    RegValid[IP] = 0;
    emuGetReg(I86_REG,REG_PC, &l);
    return(l);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
emuSetClock(int i)
{
   send_str2("CLOCK");
   send(' ');
   if( i == 1 ) send('E');
   else send('I');
   send(CR);
   while(receive()!=HAND_SHAKE);
}

/***
STATUS emuSetTbase(U8 *string)
{
   send_str2("TI ");
   send_str2(string);
   send_CR_wait(HAND_SHAKE);
}
****/

STATUS emuSetInterval(U8 intervalFlag)
{
   send_str2("INT ");
   if( intervalFlag) send_str("ON");
   else send_str("OFF");
   send(CR);
   while(receive() !=HAND_SHAKE);
}

emuGetCycle(U16 *cycleFlag)
{
   char *cptr, c;

   send_str2("CYCLE");
   send(CR);
   cptr = tx_buf;
   while(c=receive()!=HAND_SHAKE);
   *cptr=0;
   if(strstr(tx_buf, "WAIT")!= NULL) return(1);

}
STATUS emuGetOneFrame()
{
   return(OK);
}

STATUS emuListTraceBuff(int bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLen, TRACE_INFO *frameData)
{ 
   return(OK);
}
 
emuGetMICEBuf()
{
   char c;
   int lp;
   char *ptr;

   send_str2("L ");
//   send_word(bufID);
   send_CR_wait(CR);

   ptr = MICEBuf;
   while ((c=receive()) != HAND_SHAKE )
      if (c != '>') *ptr++ = c;
   *ptr = NULL;
   return(OK);
}
