/******************************************************************************
** File name : sld.c
**
** Description :  The routines of source level processes, including:
**                . Source and data type related commands, such as
**                  FINd, MODe, Watch, VIew commands.
**                . Line number and block information processings.
**                . Source and mixed codes browsers.
**                . Data type processings.
**
** Copyright (C) 1993 Microtek International, Inc.
** All Rights Reserved
**
** Programmed by Chung-Yee Joyce Lin
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/
#include  "system.h"
#include  <errno.h>
#include  "usd3.h"
#include  "gblext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "reg86.h"
#include  "database.h"
#include  "oldext.h"
#include  "cmdid.h"
#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif
#ifndef _LINUMDEF_
#include "linumdef.h"
#endif

/**************************************************************************
**
** Global Declarations
**
***************************************************************************/
GLOBAL FLAG langMode = ASM;     // Flag to decide High Level, Mixed mode or
                                 //  Assembly should be displayed.
GLOBAL CURRENT_MODULE curModule; // .modNum   : current module index
                                 // .lastLine : # of the last line
                                 // .modName  : current module name
GLOBAL U32 viewAddr;             // address for View command
GLOBAL U16 viewLine=0;           // line number for View command
GLOBAL U8  sourceName[80];       // filename displayed on the border of CODVP
GLOBAL struct stat oldStat;
GLOBAL U16 backLevel=0;          // current stack level on display
GLOBAL TYPE_INFO typeInfo;
GLOBAL ARRAY_INFO arrInfo;
GLOBAL STRUCT_INFO struInfo;
GLOBAL STR typeArr[] = {
 "void", "uchar", "char", "ushort", "short", "ulong",
 "long", "float", "double", "long double", "label, short jump",
 "label, long jump", "","struct"
};
GLOBAL S8  findStr[80];          // string for "FINd" command
GLOBAL U16 StruLevel = 0; // avoiding the stack overflow. 06/02/1994 James
GLOBAL S16 msgon = MSG_ON;
GLOBAL S16 arrsz;
GLOBAL S16 ArrStru = 0;

/**************************************************************************
**
** Local Declarations
**
***************************************************************************/
LOCAL LINNUMINFO *linnumInfo; // pointer to line# info. (for mem. alloc. use)
LOCAL U16 frameNo;            // frame number of a module
LOCAL U16 lineInfoCnt;        // the number of linnum records in one module
LOCAL FILE *filePtr;          // file pointer to current module
LOCAL FILEBUF fileBuf;        // buffer for source lines
LOCAL FLAG loadAll=FALSE;     // flag for EOF
LOCAL S32 filePosBuf[POSCNT];   // to record the filepos of every 50 source lines
// LOCAL S8  findStr[80];          // string for "FINd" command
LOCAL S32 filePos=0L;           // filePos of the source file
LOCAL S16 oldModule=-1;   // previous module index for linnumInfo Table
LOCAL S16 oldSource=-1;       // previous module index for Source file
LOCAL S16 oldHead=0;
LOCAL S32 typePosArr[TYPERECNO]; // to store the filepos's of 50 contigious data types
LOCAL U8 scalarLen[] = { 0, 8, 8, 16, 16, 32, 32, 32, 64, 80 };

/**************************************************************************
**
** Prototype Declarations
**
***************************************************************************/
PRIVATE S16 LinNumComp(const VOID *, const VOID *);
PRIVATE U32 GetLength( STRING typeStr, S16 *i );

/**************************************************************************
**
** External Declarations
**
***************************************************************************/
EXTERN S16 errorCode;
EXTERN S16 SymLoaded;
EXTERN S8 pathName[][50];
EXTERN S8 extName[][5];
EXTERN U16 curLineNum;
EXTERN FLAG dspMode;
EXTERN S16 cmdIdx;
EXTERN int MICE;  // 07/26/1994
EXTERN int NECflag;

/**************************************************************************
**
** Execution codes ( Public )
**
***************************************************************************/
/***************************************************************************
**
**  Name: FindCmd()
**
**  Description: The routine for text search in programs under source mode.
**               If the string for search is found, the CODE viewport is
**               to be updated.
**
**  Input: langMode, struct cmd_syntax, findStr, caseFlag
**
**  Output: findStr, struct curModule, fileBuf
**
**  Notes:
**
****************************************************************************/
PUBLIC RETCODE FindCmd(VOID)
{
S8 *tmpBuf=NULL, *ptr, *ptr1, *oldPtr, *fileEnd, modName[40];
S8  tempStr[80];
STATIC S8 direction = 0;
U16 lineCnt, i=0, bufSize;
U32 addr;
S32 filePos;
S16 retCnt, len, j, modNum;
CURRENT_MODULE tmpModule;

   VPOut = COMVP;
//********* Check error codition: CODVP isn't up *************
   if (!wn_isup(VP[CODVP].Ptr)) {
      DisplayStr(" FIND command doesn't function when CODE viewport is not up!\n\r");
      return(OK);
   }
//********* Check error codition: language mode isn't SOURCE *************
   if (langMode != HIGH) {
      DisplayStr(" Text Search is only available under Source Mode!\r\n");
      return(OK);
   }
//********* Check error codition: user defined string is absent *************
   if (((j=cmd_syntax.argc) == 1 || j == 3) && findStr[0] == '\0') {
      DisplayStr(" No string is previously assigned!\r\n");
      return(OK);
   }
//********* If a string is given, use new string, otherwise use old one. ******
   if ((j == 2 || j == 4) && cmd_syntax.asc[0])
      strcpy( findStr, cmd_syntax.asc );
   strcpy( tempStr, findStr );

   if (!caseFlag) strupr(tempStr); // If CASE option is INSENSITIVE,
                                   // convert string to uppercase
   if (!cmd_syntax.argv[1]) {      // If direction is not given, default is FORWARD
      if (!direction) direction = FORWARD;
   }
   else direction = (S8)cmd_syntax.argv[1];
   if (j > 2) { // module is assigned,
      if (NameToMod(cmd_syntax.input) != FOUND) {
         prn_ferr(72);    // invalid module!
         return (OK);
      }
      modNum = commod.mod_inx;
      StrmnCopy( modName, cmd_syntax.input, 0, 39 );
      memcpy( &tmpModule, &curModule, sizeof(CURRENT_MODULE));
      if (InitSourceEnvironment( modNum, modName ) == FAIL) {
         memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
         prn_ferr(41);    // File access failure!
         return (OK);
      }
      curModule.modNum = modNum;
      StrmnCopy( curModule.modName, cmd_syntax.input, 0, 39 );
   }
// marked by Matthew    06/23/94
//   else {
//      emuGetReg(I86_REG, REG_PC, &addr);
//      if (GetModuleAndLineNum( addr, &lineCnt) == FAIL) {
//         prn_ferr(72);    // invalid module!
//         return (OK);
//      }
//   }

   if (!cmd_syntax.argv[0]) {
      if (GetAddrInCODVP( VP[CODVP].Ptr->r, &addr ) == 0) goto NOT_FOUND;

// added by Chen
//      lineCnt = (direction == FORWARD) ? curLineNum+1 : curLineNum-1;
        lineCnt = curLineNum;
        if ( lineCnt==curModule.lastLine && direction==FORWARD ) {
            goto NOT_FOUND;
        }

   }
   else {   // added by Chen
        lineCnt = (U16)cmd_syntax.argv[0];
//        if ( lineCnt > curModule.lastLine ) {
//            DisplayStr(" Invalid line number !\n\r");
//            return (OK);
//        }   // find in the current module
   }

   if (lineCnt < 1 || lineCnt > curModule.lastLine) goto NOT_FOUND;
   j = lineCnt > BUFROW ? (lineCnt-1) / BUFROW - 1 : 0;
   if (FillFileBuf( lineCnt ) == FAIL) goto NOT_FOUND;

// added by Chen
//    if ( (U16)cmd_syntax.argv[0] > curModule.lastLine ) {
//        DisplayStr(" Invalid line number !\n\r");
//        return (OK);
//    }   // find in another module

   if (direction == FORWARD)  {
      bufSize = FINDSIZE;
      filePos = fileBuf.filePos[1];
   }
   else {
      bufSize = FINDSIZE / 8 ;
      if (fileBuf.filePos[0] <= bufSize) {
         filePos = 0L;
         bufSize = fileBuf.filePos[0];
      }
      else filePos = fileBuf.filePos[0] - bufSize;
   }
   if ((tmpBuf = malloc( bufSize + 1 )) == NULL) {
      if (cmd_syntax.argc > 2)
         memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
      return(FAIL);
   }
   retCnt = bufSize;
   fileEnd = NULL;
   while ( !fileEnd && retCnt >= bufSize ) {
      if ( fseek( filePtr, filePos, SEEK_SET ) != NULL ) goto READ_ERR;
      if (( retCnt = fread((VOID *)tmpBuf, sizeof(S8), bufSize, filePtr ))
           < bufSize && ferror(filePtr) != NULL ) goto READ_ERR;
      tmpBuf[retCnt] = '\0';
      if (!caseFlag) strupr(tmpBuf);
      if (direction == FORWARD) {
         if ((ptr = strstr( tmpBuf, tempStr )) == NULL) {
            if (retCnt < bufSize)  goto NOT_FOUND;
            if ((ptr1 = strrchr( tmpBuf, '\n')) != NULL)
               filePos += (S32)(1 + ptr1 - tmpBuf);
            else filePos += retCnt;
            continue;
         }
         else {  // found
            *ptr = '\0';
            if ((ptr1 = strrchr( tmpBuf, '\n')) != NULL)
               filePos += (S32)(1 + ptr1 - tmpBuf);
            while (j < POSCNT && filePosBuf[j] && filePos > filePosBuf[j]) j++;
            lineCnt = 1 + ( j * BUFROW );
            while ( FillFileBuf(lineCnt) == OK && !loadAll &&
                    fileBuf.filePos[ fileBuf.size-1 ] < filePos )
               lineCnt += (U16)BUFROW;
            goto STR_FOUND;
         }
      }
      else {             // Backward
         oldPtr = tmpBuf;
         len = strlen( tempStr );
         while ((ptr=strstr(oldPtr,tempStr))!=NULL && oldPtr<tmpBuf+retCnt)
            oldPtr = ptr+len;
         if (oldPtr == tmpBuf && !ptr ) { // not found in this tmpBuf
            if (!filePos) goto NOT_FOUND;
            if ((ptr = strchr( tmpBuf, '\n' )) != NULL)
               filePos += (S32)(1 + ptr - tmpBuf);
            filePos = (filePos <= bufSize) ? 0L : filePos - bufSize;
            continue;
         }
         oldPtr -= len;

        // added by Chen
            ptr = tmpBuf;
            while ( *ptr && *ptr!='\n' ) {
                if ( ptr==oldPtr ) {
                    break;
                }
                ptr++;
            }
            if ( ptr!=oldPtr ) {
                *oldPtr = '\0';
            }
            else {
                lineCnt = 1;
                viewLine = lineCnt;
                LinNum2Addr(lineCnt, &viewAddr);
                UpdateCODVP(CODVP_VIEW);
                free( tmpBuf );
                return(OK);
            }

         if ((ptr = strrchr( tmpBuf, '\n' )) != NULL) {
            filePos += (S32) (1 + ptr - tmpBuf);
            while (j >= 0 && filePos < filePosBuf[j] ) j--;

                // added by Chen
                lineCnt = 1 + (1+j) * BUFROW;
                if ( lineCnt>curModule.lastLine ) {
                    lineCnt = 1;
                }

            if (FillFileBuf(lineCnt) == FAIL) goto NOT_FOUND;
            goto STR_FOUND;
         }
      }
   }
STR_FOUND:
   for (i=0; i < fileBuf.size; i++) {
      if (fileBuf.filePos[i] == filePos) {
         lineCnt += i;
         viewLine = lineCnt;
         LinNum2Addr(lineCnt, &viewAddr);
         UpdateCODVP(CODVP_VIEW);
         free( tmpBuf );
         return(OK);
      }
   }
READ_ERR:
   prn_ferr(41);
   beep_vv( BPMEDIUM, BPMIDDLE);
   if (tmpBuf) free( tmpBuf );
   if (cmd_syntax.argc > 2)
      memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
   return(OK);
NOT_FOUND:
   DisplayStr(" String not found!\r\n");
   beep_vv( BPMEDIUM, BPMIDDLE);
   if (tmpBuf) free( tmpBuf );
   if (cmd_syntax.argc > 2)
      memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
   return(OK);
}

/***************************************************************************
**
**  Name: ModeCmd()
**
**  Description:
**     Toggle the code viewport display mode among High Level Language ,
**     Mix Mode and Assembly, or set the language mode with designated
**     argument.
**
**  Input:  langMode, struc cmd_syntax (Global)
**
**  Output: langMode
**
**  Notes : langMode == ASM  (0)  : Assembly Mode
**          langMode == HIGH (1)  : Source Mode
**          langMode == MIX  (2)  : Mix Mode
**
****************************************************************************/
PUBLIC RETCODE ModeCmd(VOID)
{
 RETCODE ret;
 U32 addr;
 S16 i;

   VPOut = COMVP;
   if (!wn_isup(VP[CODVP].Ptr)) {
      DisplayStr(" MODE command doesn't function when CODE viewport is not up!\n\r");
      return(OK);
   }
   i = VP[CODVP].Ptr->r;
   while ((ret=GetAddrInCODVP(i++, &addr)) == 2) ; // symbol
   if (!ret) {
      DisplayStr(" Update code viewport failure!\r\n");
      return(OK);
   }
   viewAddr = addr;
   viewLine = (ret > 2 && ret < 6)  ? curLineNum : 0;
   langMode = cmd_syntax.argc ? (FLAG)cmd_syntax.argv[0] : (++langMode)%3;

   if ( langMode == HIGH )     DisplayStr(" Source mode.\n\r");
   else if ( langMode == MIX ) DisplayStr(" Mixed mode.\n\r");
   else                        DisplayStr(" Assembly mode.\n\r");
   UpdateCODVP(CODVP_VIEW);
   return(OK);
}



/**************************************************************************
**
** Name : ViewCmd()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE ViewCmd(FLAG displayFlag)
{
U32 addr, dummy, curPC;
int act, modNum;
char modName[41];
CURRENT_MODULE tmpModule;
U16 uTmpLine = 0;


   VPOut = COMVP;
   if (!wn_isup(VP[CODVP].Ptr)) {
      if (!displayFlag) return(FAIL);
      DisplayStr(" VIEW command doesn't function when CODE viewport is not up!\n\r");
      return(OK);
   }
   viewLine = 0;
   memcpy( &tmpModule, &curModule, sizeof(CURRENT_MODULE));
   switch (cmd_syntax.argc) {
      case 0 :  // VIew
         emuGetReg(I86_REG, REG_PC, &addr);
         backLevel = 0;
         break;
      case 1 :  // VIew addr
         if (!addr_form.csFlag) {
            emuGetReg(I86_REG, CS, &addr);
            addr =(addr << 16) + addr_form.addr;
         } else addr = addr_form.addr;
         break;
      case 2 :  // VIew #line_number
      // added by Chen, 08/03/94
         if ( SymLoaded != OK ) {
            DisplayStr(" Symbol table not loaded!\n\r");
            return (OK);
         }
         modNum = curModule.modNum;
         StrmnCopy(modName, curModule.modName, 0, 39);
         viewLine = cmd_syntax.argv[0];
         Addr2LinNum(gblmod[curModule.modNum].modEnd, &uTmpLine);
        while ( InitSourceEnvironment( modNum, modName ) != FAIL ) {
            if ( uTmpLine == 0 ) {
                uTmpLine = 1;
            }
            FillFileBuf(uTmpLine);
            if ( curModule.lastLine != 0xffff ) {
                break;
            }
            else {
                uTmpLine += 50;
            }
        }
        if ( curModule.lastLine == 1 ) {
            viewLine = 1;
        }
        if (LinNum2Addr(viewLine, &addr) == FAIL) {
// changed by Chen, 08/03/94
//            DisplayStr(" The line number is too large !\n\r");
//            return(OK);
//            emuGetReg(I86_REG, REG_PC, &addr );
            // added by Chen, 08/04/94
            if ( langMode != ASM && viewLine >= curModule.lastLine &&
                curModule.lastLine > 1 ) {
                viewLine = curModule.lastLine-1;
                LinNum2Addr(viewLine, &addr);
            }   // cannot view the last line
        }
         break;
      case 3 :  // VIew %%module#line_number
         if (NameToMod(cmd_syntax.asc) != FOUND) {
            if (!displayFlag) return(FAIL);
            prn_ferr(72);    // invalid module!
            return (OK);
         }
         modNum = curModule.modNum = commod.mod_inx;
         StrmnCopy(curModule.modName, cmd_syntax.asc, 0, 39);
         StrmnCopy(modName, cmd_syntax.asc, 0, 39);
         viewLine = cmd_syntax.argv[0];
         Addr2LinNum(gblmod[curModule.modNum].modEnd, &uTmpLine);
        while ( InitSourceEnvironment( modNum, modName ) != FAIL ) {
            if ( uTmpLine == 0 ) {
                uTmpLine = 1;
            }
            FillFileBuf(uTmpLine);
            if ( curModule.lastLine != 0xffff ) {
                break;
            }
            else {
                uTmpLine += 50;
            }
        }
        if ( curModule.lastLine == 1 ) {
            viewLine = 1;
        }
        if (LinNum2Addr( viewLine, &addr) == FAIL) {
// changed by Chen, 08/03/94
//            DisplayStr(" The line number is too large !\n\r");
//            return(OK);
//            emuGetReg(I86_REG, REG_PC, &addr );
            // added by Chen, 08/04/94
            if ( langMode != ASM && viewLine >= curModule.lastLine &&
                curModule.lastLine > 1 ) {
                viewLine = curModule.lastLine-1;
                LinNum2Addr(viewLine, &addr);
            }   // cannot view the last line
        }
         break;
      case 4 :  // VIew @n
         if (GetLevelRetAddr( 1, (U16)cmd_syntax.argv[0], &addr, &dummy ) == FAIL) {
            if (!displayFlag) return(FAIL);
            prn_ferr(60); // invalid level!
            return(OK);
         }
         // added by Chen, 08/04/94
         Addr2LinNum(gblmod[curModule.modNum].modEnd, &curModule.lastLine);
//         curModule.lastLine = 0xffff;   // added by Chen 05/30/94
         break;
   }

//   if ( langMode != ASM && cmd_syntax.argc != 3 &&
// changed by Chen, 08/03/94
   if ( langMode != ASM && cmd_syntax.argc != 3 && cmd_syntax.argc != 2 &&
        IdentifyCurrentModule(TRUE, addr, &modNum, modName, &dummy, &dummy)
        == FAIL ) {
      if (cmd_syntax.argc == 2) {
         memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
         if (!displayFlag) return(FAIL);
         prn_ferr(71);    // Can't locate current module!
         return (OK);
      }
   }

   if (!viewLine) {
      if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
         memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
         if (!displayFlag) return(FAIL);
         errorCode = ABS_OVERFLOW;
         return( errorCode );
      }
      else if (langMode != ASM) Addr2LinNum(addr, &viewLine);
   }

   if (viewLine && InitSourceEnvironment( modNum, modName ) == FAIL) {
      memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
      viewLine = 0;
   }

   viewAddr = addr;
   UpdateCODVP(CODVP_VIEW);
   return( OK );
}



/**************************************************************************
**
** Name : DownView()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE DownView(FLAG displayFlag)
{
U32 addr, dummy, curPC;
int act, modNum;
char modName[41];
CURRENT_MODULE tmpModule;

   viewLine = 0;
   memcpy( &tmpModule, &curModule, sizeof(CURRENT_MODULE));

    emuGetReg(I86_REG, REG_PC, &addr);
    backLevel = 0;

    IdentifyCurrentModule(TRUE, addr, &modNum, modName, &dummy, &dummy);

   if (!viewLine) {
      if (CheckOverflow((U16)(addr>>16), (U16)addr)) {
         memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
         if (!displayFlag) return(FAIL);
         errorCode = ABS_OVERFLOW;
         return( errorCode );
      }
      else if (langMode != ASM) Addr2LinNum(addr, &viewLine);
   }

   if (viewLine && InitSourceEnvironment( modNum, modName ) == FAIL) {
      memcpy( &curModule, &tmpModule, sizeof(CURRENT_MODULE));
      viewLine = 0;
   }

   viewAddr = addr;
   UpdateCODVP(CODVP_VIEW);
   return( OK );
}

/**************************************************************************
**
** Name :  WatchCmd()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE WatchCmd(VOID)
{
U16 level, type, i;
U32 addr, dummy;
U8 flag, indent[NAMELEN];
S16 ret;

  level = (cmd_syntax.argc % 2) ? cmd_syntax.argv[0] : backLevel;
  if (cmd_syntax.argc < 2) {
     if ((ret=ListLocalVariables( level )) == FAIL) prn_ferr(24); // no local variable!
     else if (ret == 1) prn_ferr(26); // local variable not alive
     return(OK);
  }
  if ((ret=FindLocalVariable(level, cmd_syntax.asc, &addr, &type, &dummy,
       &flag)) != OK) {
       StrmnCopy( comsym.name, cmd_syntax.asc, 0, sizeof(comsym.name)-1);
       if ( SymToAddr() == FOUND ) {
          addr =0L;
          for (addr = 0, i = 0; i < 4; i++) addr = (addr << 8) + comsym.addr[i];
          type = comsym.type;
          ret = OK;
       }
       else if (ret != 1) {
          prn_ferr(74);
          return(OK);
       }
  }
  if (ret == 1) {
     prn_ferr(26);
     return(OK);
  }
  memset( &typeInfo , NULL, sizeof( TYPE_INFO ));
  memset( &arrInfo , NULL, sizeof( ARRAY_INFO ));
  memset( &struInfo , NULL, sizeof( STRUCT_INFO ));
  indent[0]=NULL;
  if (GetTypeInfo( type ) == FAIL) prn_ferr(74);
//else PrintVar( addr, cmd_syntax.asc, indent );  06/02/1994 James
  else {
      // 06/07/1994 James Wang
      StruLevel = 0;
      arrsz = 0;
      ArrStru = 0;   // 08/09/1994 James
      msgon = MSG_ON;
      PrintVar( addr, cmd_syntax.asc, indent );
      }
  for (i=0; i < struInfo.itemCnt; i++)
     if (struInfo.itemName[i]) free(struInfo.itemName[i]);
  return(OK);
}


/***************************************************************************
**
**  Name: IdentifyCurrentModule()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE IdentifyCurrentModule(U8 updFlag, U32 curPC, S16 *curMod,
                                     STR modName, U32 *modStart, U32 *modEnd)
{
S16 i, j, act;
U32 abs;

// neverswapmodule : flag to indicate struct gblmod ever being swapped or not.
// modcnt  : the total of modules (declared at usym3.h, coded in wusym1.c)
// NO_MODULE: 50
// gblmod[]: the information of modules (declared at usym3.h, coded in wusym1.c)
// gblmod[i].modStart: the highest address in each module
// gblmod[i].modEnd  : the lowest address in each module

   if (SymLoaded != OK) return(FAIL);
   abs = ADDR2ABS( curPC );
   if (neverswapmodule)  act = modcnt;
   else {
      act = NO_MODULE;
      swap_module(0);
   }
   for (j=0; j < modcnt; j += act) {
      for (i = 0; i < act; i++)
         if ( abs >= ADDR2ABS( gblmod[i].modStart ) &&
              abs <= ADDR2ABS( gblmod[i].modEnd ) ) {
            *curMod = j + i;
            if (updFlag) {
               curModule.modNum = *curMod;
               StrmnCopy( curModule.modName, gblmod[i].mod_name, 0, 39 );
            }
            *modStart = gblmod[i].modStart;
            *modEnd   = gblmod[i].modEnd;
            StrmnCopy( modName, gblmod[i].mod_name, 0, 39 );
            return(OK);
         }
      if (!neverswapmodule) swap_module(gblmod[act-1].mod_inx + 1);
   }
   return(FAIL);
}

/***************************************************************************
**
**  Name: GetModuleAndLineNum()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE GetModuleAndLineNum(U32 curPC, U16 *retLine)
{
U8 modName[40];
S16 curMod;
U32 dummy;

   if (IdentifyCurrentModule(TRUE,curPC,&curMod,modName,&dummy, &dummy)== OK) {
      if (Addr2LinNum( curPC, retLine )== FAIL) return(FAIL);
      if (InitSourceEnvironment( curMod, modName ) == FAIL) return(FAIL);
      return(OK);
   }
   return(FAIL);
}

/***************************************************************************
**
**  Name: GetBlockInfo()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE GetBlockInfo( U32 curPC, BLOCK_INFO *blockInfo )
{
U32 abs, startAddr, endAddr, blkPos;
S16 i, j, k, len, blkCnt, act, linNum;
BLOCK_INFO *tmpBlock;    // pointer to block info. (for mem. alloc. use)

   if (SymLoaded != OK) return(FAIL);
   abs = ADDR2ABS( curPC );
   if (neverswapmodule)  act = modcnt;
   else {
      act = NO_MODULE;
      swap_module(0);
   }
   for (j=0; j < modcnt; j += act) {
      for (i = 0; i < act; i++) {
         if ( abs >= ADDR2ABS( gblmod[i].modStart ) &&
              abs <= ADDR2ABS( gblmod[i].modEnd ) ) {
            blkCnt = gblmod[i].blkCnt;
            blkPos = gblmod[i].blkStartPos;
            if (blkCnt == 0) return(FAIL);
            len = blkCnt * sizeof(BLOCK_INFO);
            if ((tmpBlock = (BLOCK_INFO *)malloc(len)) == NULL) return(FAIL);
            lseek( fdsy, blkPos, SEEK_SET );
            read(fdsy, (char *)tmpBlock, len );
            for (k = 0; k < blkCnt; k++) {
               startAddr = ADDR2ABS(tmpBlock[k].startAddr);
               endAddr = ADDR2ABS(tmpBlock[k].endAddr);
               if ( abs >= startAddr && abs <= endAddr ) {
/*                if (GetAddressRange( tmpBlock[k].startAddr, &startAddr)==FAIL) {
                     free(tmpBlock);
                     return(1);
                  }
                  if (abs >= ADDR2ABS(startAddr)) {
                     memcpy( blockInfo, &tmpBlock[k], sizeof( BLOCK_INFO ) );
                     free(tmpBlock);
                     return(OK);
                  }
                  else {
                     free(tmpBlock);
                     return(1);
                  } */    // Marked by James 07/15/1994
                  memcpy( blockInfo, &tmpBlock[k], sizeof( BLOCK_INFO ) );
                  free(tmpBlock);
                  return(OK);
               }
            }
            free(tmpBlock);
            return(FAIL);
         }
      }
      if (!neverswapmodule) swap_module(gblmod[act-1].mod_inx + 1);
   }
   return(FAIL);
}


/***************************************************************************
**
**  Name: PutOneAsmRowinBuf()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE PutOneAsmRowinBuf( U32 *addr, U8 **ptr, S16 *j, STR tmpBuf)
{
 U16 len;

   len = Disassemble( *addr, *ptr, *j, tmpBuf );
   strcat( tmpBuf,"\r\n");
   *addr = ( *addr & 0xFFFF0000) + ((*addr + len) & 0x0000FFFF);
   *ptr += len;
   *j -= len;
   if (j <= 0) return(FAIL);
   return(OK);
}

/***************************************************************************
**
**  Name: PutOneAsmV20()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE PutOneAsmV20( U32 *addr, STR tmpBuf)
{
S16 len;

   len = DisassembleV20( *addr, tmpBuf );
   strcat(tmpBuf, "\r\n");
   *addr = ( *addr & 0xFFFF0000) + ((*addr + len) & 0x0000FFFF);
   if ( !len ) return (FAIL);
   return (OK);
}

/***************************************************************************
**
**  Name: PutSourceinCODBuf()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE PutSourceinCODBuf(U16 lineNo, S8 *cnt)
{
U16 head, j, lineCnt;
S8  tmpBuf[90], k=0, i;
U32 addr;

   lineCnt = lineNo;
   CODBuf[0] = NULL;
   while ( k < CODBUFROW ) {
      if (FillFileBuf( lineCnt ) == FAIL) return(FAIL);
      head = fileBuf.startLine;
      for ( j = lineCnt, i=0;  (j <= head + fileBuf.size - 1 ) &&
            k < CODBUFROW; j++, k++, i++ ) {
         if (LinNum2Addr( lineCnt, &addr ) == OK)
            sprintf(tmpBuf," %4d %s\r\n",lineCnt++,fileBuf.line[i]);
         else sprintf(tmpBuf,".%4d %s\r\n",lineCnt++,fileBuf.line[i]);
         strcat( CODBuf, tmpBuf );
      }
      if (j >= curModule.lastLine) break;
   }
   *cnt = k;
   return( OK);
}

/***************************************************************************
**
**  Name: PutMixinCODBuf()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE PutMixinCODBuf( U16 lineNo, S16 flag, S16 rowOrg, S8 *cnt)
{
U16 head, k, idx =0, lineCnt;
S8  tmpBuf[256], row=0, ret;
U32 addr, dummy, addr2, oldAddr;
U8 *codVPbuf=NULL, *ptr;
S16 j;
BLOCK_INFO blkInfo;

   if (flag == CODVP_PGUP || flag == CODVP_PREV)
      return( PutPrevPageinMixMode( lineNo, flag, rowOrg, cnt ) );
   if (flag == CODVP_BOTTOM) return( PutBottomPageinMixMode( lineNo, cnt ) );
   CODBuf[0] = NULL;
   lineCnt = lineNo;
   if ((codVPbuf=malloc(512)) == NULL) return(FAIL);
   if (flag == CODVP_PGDN || flag == CODVP_NEXT) {
      row = (flag == CODVP_PGDN) ? rowOrg + VP[CODVP].Height - 4 : 1 + rowOrg;
      if ((ret=GetAddrInCODVP( row, &addr)) < 4) {
         free(codVPbuf);
         return(FAIL);
      }
      lineCnt = curLineNum;
      row = 0;
      if (ret == 6) {
         if (Addr2LinNum( addr, &lineCnt) == FAIL) {
            free(codVPbuf);
            if (GetLastPageStart(&lineCnt) == FAIL) return(FAIL);
            return( PutBottomPageinMixMode( lineCnt, cnt ) );
         }
         if ((ret=LinNum2AddrRange( lineCnt++, &dummy, &addr2, &idx )) != FAIL) {
            if (ret == LASTLINE) {
               free(codVPbuf);
               if (GetLastPageStart(&lineCnt) == FAIL) return(FAIL);
               return( PutBottomPageinMixMode( lineCnt, cnt ) );
            }
         if ( MICE < V20MAX || NECflag == 0 ) {
            j = addr2 - dummy + 10;
            GetMemWrap(addr, codVPbuf, j);
            ptr = codVPbuf;
         }
            ret = OK;
            while (row < CODBUFROW && addr <= addr2 && ret == OK) {
               if ( MICE < V20MAX || NECflag == 0 )
                  PutOneAsmRowinBuf( &addr, &ptr, &j, tmpBuf);
               else
                  ret = PutOneAsmV20( &addr, tmpBuf);
               strcat(CODBuf, tmpBuf);
               row++;
            }
         }
      }
   }
   while ( row < CODBUFROW ) {
      if (lineCnt > curModule.lastLine) break;
      if (FillFileBuf( lineCnt ) == FAIL) {
         if (!row) {
            free(codVPbuf);
            return(FAIL);
         }
         break;
      }
      oldAddr = 0L;
      head = fileBuf.startLine;
      for ( k = lineCnt; k <= head + fileBuf.size - 1;  k++ ) {
         sprintf( tmpBuf, "<%4d %s\r\n", lineCnt, fileBuf.line[k-head] );
         strcat( CODBuf, tmpBuf );
         row++;
         if ((ret=LinNum2AddrRange( lineCnt++, &addr, &addr2, &idx )) != FAIL) {
         if ( MICE < V20MAX || NECflag == 0 ) {
            if (oldAddr != addr) {
               j=CODBUFROW*7;
               GetMemWrap(addr, codVPbuf, j);
               ptr = codVPbuf;
            }
         }
            if (ret == LASTLINE) {
               if (GetBlockInfo( addr, &blkInfo) == FAIL) {
                  if ( MICE < V20MAX || NECflag == 0 )
                     PutOneAsmRowinBuf( &addr, &ptr, &j, tmpBuf);
                  else
                     ret = PutOneAsmV20( &addr, tmpBuf);
                  oldAddr = addr;
                  strcat(CODBuf, tmpBuf);
                  row++;
                  break;
               }
               else addr2 = blkInfo.endAddr;
            }
            ret = OK;
            while (row < CODBUFROW && addr <= addr2 && ret == OK) {
            if ( MICE < V20MAX || NECflag == 0 ) {
               if (j < 7) {
                  j=CODBUFROW*7;
                  GetMemWrap(addr, codVPbuf, j);
                  ptr = codVPbuf;
               }
            }
               if (MICE < V20MAX || NECflag == 0 )
                  ret = PutOneAsmRowinBuf( &addr, &ptr, &j, tmpBuf);
               else
                  ret = PutOneAsmV20( &addr, tmpBuf);
               oldAddr = addr;
               strcat(CODBuf, tmpBuf);
               row++;
            }
         }
         if (row >= CODBUFROW || ret == LASTLINE) break;  // from for loop
      }
   }
   *cnt = row;
   free(codVPbuf);
   VP[CODVP].Ptr->row_org = 0;
   return(OK);
}

/***************************************************************************
**
**  Name: ViewTopPage()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Notes :
**
****************************************************************************/
PUBLIC RETCODE ViewTopPage(VOID)
{
   cmd_syntax.argc = 2;
   cmd_syntax.argv[0] = 1L;
   ViewCmd( FALSE );
   return(OK);
}

/***************************************************************************
**
**  Name: GetLastPageStart()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Notes :
**
****************************************************************************/
PUBLIC RETCODE GetLastPageStart(U16 *startLine)
{
S16 i;
U16 lineCnt;

   if (!loadAll) {
      for ( i=0; i < POSCNT; i++ )
         if (!filePosBuf[i]) {
            lineCnt = 1 + BUFROW*i;
            break;
         }
   }
   while (!loadAll) {
      if (FillFileBuf(lineCnt) == FAIL) return(FAIL);
      lineCnt += BUFROW;
   }
   *startLine = curModule.lastLine - CODBUFROW + 1 <= 0 ? 1 :
                curModule.lastLine - CODBUFROW + 1;
   return(OK);
}

/***************************************************************************
**
**  Name: LinNum2Addr()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE LinNum2Addr( U16 lineNum, U32 *addr )
{
 U16 i;
   U16 oldLineNum=0xFFFF;

   if (ReadLinNumInfo(curModule.modNum) == FAIL) return(FAIL);
   if (lineNum < linnumInfo[0].lineNum) {
      *addr = ((U32)frameNo << 16) + linnumInfo[0].offset;
      return(NOCODE);
   }
   for (i=0; i < lineInfoCnt; i++) {
      if (lineNum == linnumInfo[i].lineNum) {
         *addr = ((U32)frameNo << 16) + linnumInfo[i].offset;
         return(OK);
      }
   }
   for (i=0; i < lineInfoCnt; i++) {
      if (lineNum > oldLineNum && lineNum < linnumInfo[i].lineNum) {
         *addr = ((U32)frameNo << 16) + linnumInfo[i].offset;
         return( NOCODE );
      }
      oldLineNum = linnumInfo[i].lineNum;
   }
   return(FAIL);
}

/***************************************************************************
**
**  Name: Addr2LinNum()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE Addr2LinNum( U32 addr, U16 *lineNum )
{
U32 lAddr, oldAddr=0xFFFFF, abs1, abs2;
U16 i, tmpLine=0;
U8 modName[40];
S16 modNum;
U32 dummy;

   if (ReadLinNumInfo(curModule.modNum) == FAIL) return(FAIL);
   abs1 = ADDR2ABS( addr );

   // truely matched record is lost !!! - fixed by James
   for (i=0; i < lineInfoCnt; i++) {
      abs2 = ((U32)frameNo << 16) + linnumInfo[i].offset;
      if (abs1 == abs2) {
         *lineNum = linnumInfo[i].lineNum;
         return(OK);
      }
   }

   for (i=0; i < lineInfoCnt; i++) {
      abs2 = ((U32)frameNo << 4) + linnumInfo[i].offset;
      if (abs1 == abs2) {
         *lineNum = linnumInfo[i].lineNum;
         return(OK);
      }
      if (abs1 > oldAddr && abs1 < abs2 && !tmpLine)
         tmpLine = linnumInfo[i-1].lineNum;
      oldAddr = abs2;
   }
   if (tmpLine) {
      *lineNum = tmpLine;
      return(BETWEEN);
   }
   return( FAIL );
}

/***************************************************************************
**
**  Name: GetAddressRange()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE GetAddressRange( U32 addr1, U32 *addr2 )
{
U32 lAddr, oldAddr=0xFFFFFFFF;
U16 i;
U8 modName[40];
S16 modNum;
U32 dummy;

   if (IdentifyCurrentModule(FALSE, addr1, &modNum, modName, &dummy, &dummy)
       == FAIL) return(FAIL);
   if (ReadLinNumInfo(modNum) == FAIL) return(FAIL);

   // truely matched record is lost !!! - fixed by James
   for (i=0; i < lineInfoCnt; i++) {
      lAddr = ((U32)frameNo << 16) + linnumInfo[i].offset;
      if (addr1 == lAddr) {
         if ( i+1 >= lineInfoCnt)
            return(LASTLINE);
         *addr2 = ((U32)frameNo << 16) + linnumInfo[i+1].offset-1;
         return(OK);
      }
   }

   for (i=0; i < lineInfoCnt; i++) {
      lAddr = ((U32)frameNo << 16) + linnumInfo[i].offset;
      if (addr1 == lAddr) {
         if ( i+1 >= lineInfoCnt)
            return(LASTLINE);
         *addr2 = ((U32)frameNo << 16) + linnumInfo[i+1].offset-1;
         return(OK);
      }
      else if (addr1 > oldAddr && addr1 < lAddr) {
         *addr2 = lAddr-1;
         return(BETWEEN);
      }
      oldAddr = lAddr;
   }
   return( FAIL );
}


/**************************************************************************
**
** Name : InitLinNumInfo()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE InitLinNumInfo(VOID)
{
   memset( findStr, NULL , sizeof(findStr) );
   curModule.lastLine = 0xFFFF;
   memset( &fileBuf, NULL, sizeof(FILEBUF));
   fileBuf.modNum = -1;
   memset( extName, NULL, 20 );
   memset( pathName, NULL, 200 );
   memset( sourceName, NULL, sizeof(sourceName) );
   memset( &oldStat,  NULL, sizeof(struct stat) );
}

/***************************************************************************
**
**  Name: FreeLinNumInfo()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE FreeLinNumInfo(VOID)
{
  if (linnumInfo) free(linnumInfo);
  if (filePtr) fclose( filePtr );
  oldModule = oldSource = -1;
  oldHead = 0;
  return(OK);
}

/**************************************************************************
**
** Name : IsLastRowOfModule()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE IsLastRowOfModule(int key)
{
 S16 j;
 U32 addr, oldAddr, addr1;
 U8 dummyStr[256], *buf, *ptr;
 RETCODE ret;
 BLOCK_INFO blkInfo;
 U16 line;
 U32 abs1, abs2;


   if (dspMode != ASM && CodeVPRange.flag != FAIL) {
      if (key == KEY_DN) {
         GetAddrInCODVP( VP[CODVP].Ptr->r, &addr );
         line = curLineNum;
      }
      else {
         line = CodeVPRange.scrEndLine;
         addr = CodeVPRange.scrEndAddr;
      }

//      if (dspMode == HIGH && line >= curModule.lastLine)
// Chen 06/15/94    ; curModule.lastLine = line+1 when key==KEY_PGDN
        if ( dspMode == HIGH ) {
            if ( key == KEY_DN && line >= curModule.lastLine ) {
                return (TRUE);
            }
            else if ( key == KEY_PGDN && line >= curModule.lastLine-1 ) {
                return (TRUE);
            }
        }

      if (dspMode == MIX) {
         if (line >= curModule.lastLine && LinNum2Addr(line, &oldAddr)!= OK)
             return(TRUE);
         if ( !line && ((ret=GetAddressRange(addr, &oldAddr)) ==FAIL ||
              ret == LASTLINE)) {
            if (GetBlockInfo(addr, &blkInfo) == OK)  {
            if (MICE < V20MAX || NECflag == 0 ) {
               j = CODBUFROW*7;
               if ((buf=malloc(j)) == NULL) return(FALSE);
               GetMemWrap(addr, buf, j);
               ptr = buf;
            }
               addr1 = addr;

// added by Chen
                abs1 = (addr1>>16)+(addr1&0x0ffff);
                abs2 = (blkInfo.endAddr>>16)+(blkInfo.endAddr&0x0ffff);
                while ( abs1 <= abs2 ) {
//                 while ( addr1 <= blkInfo.endAddr) {
                   oldAddr = addr1;
                   if ( MICE < V20MAX || NECflag == 0 ) {
                     if (PutOneAsmRowinBuf(&addr1, &ptr, &j, dummyStr)==FAIL)
                      break;
                   }
                   else {
                     if (PutOneAsmV20(&addr1, dummyStr)==FAIL)
                      break;
                   }
                   abs1 = (addr1>>16)+(addr1&0x0ffff); // Chen
                }
               if (MICE < V20MAX || NECflag == 0 )
               if ( buf ) free(buf);
               if (oldAddr == addr) return(TRUE);
            }
            else if (IdentifyCurrentModule(FALSE, addr, &j, dummyStr,
                    &oldAddr, &addr1) == OK && addr >= addr1) return(TRUE);
         }
      }
   }
   return(FALSE);
}

/**************************************************************************
**
** Name : GetContentStr()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE GetContentStr(FLAG ptrFlag, FLAG isProc, U32 addr, U8 type,
                             U32 len, STRING str)
{
U8  *buffer, c, arr[4];
U32 new;
U32 u32;
U16 i;

   len /= 8;
   if ((buffer= malloc(len)) == NULL) return(FAIL);
   if (len > 0 && emuGetMemN( addr, buffer, len) != OK) {
      free(buffer);
      return(FAIL);
   }
   if (ptrFlag && typeInfo.scope) {
      new = addr;
      for (i=0; i < typeInfo.scope; i++) {
         len = typeInfo.ptrLen[i]/8;
         if ((len != sizeof(U32) && len != sizeof(U16)) ||
             emuGetMemN( new, arr, len) != OK) {
             free(buffer);
             return(FAIL);
         }
         if (len < sizeof(U32)) {
            emuGetReg(I86_REG, DS, &u32);
            new =  ((u32&0x0FFFFL) << 16) + *(U16 *)&arr[0];
         }
         else new = *(U32 *)&arr[0];
         if (!new) break;
      }
      if (!new) sprintf( str, "%04X?%04X", (U16)(new>>16),(U16)new);
      else sprintf( str, "%04X:%04X", (U16)(new>>16),(U16)new);
      free(buffer);
      return(OK);
   }
   switch( type ) {
      case SCHAR:
        if (!isProc) {
           if ((c=*buffer) >= 0x20 && c < 0x7f)
              sprintf(str, "'%c' (%d)",c,(S8)c);
//         else sprintf(str, "%02X (%d)",(S8)c,(S8)c);
//         c >= 7f : use U8 format to display hexadecimal format. 06/01/1994 James Wang
           else sprintf(str, "%02X (%d)",(U8)c,(S8)c);
        }
        else sprintf(str, "%02X", *buffer);
        break;
      case UNCHAR:
        if (!isProc) {
           if ((c=*buffer) >= 0x20 && c < 0x7f) sprintf(str, "'%c' (%u)", c, c);
           else sprintf(str, "%02X (%u)", c, c);
        }
        else sprintf(str, "%02X", *buffer);
        break;
      case UNINT:
        if (isProc) sprintf(str, "%04X", *(U16 *)&buffer[0] );
        else sprintf(str, "%04X (%u)", *(U16 *)&buffer[0], *(U16 *)&buffer[0]);
        break;
      case SINT:
        if (isProc) sprintf(str, "%04X", *(S16 *)&buffer[0] );
        else sprintf(str,"%04X (%d)", *(S16 *)&buffer[0], *(S16 *)&buffer[0]);
        break;
      case UNLONG:
        if (isProc) sprintf(str, "%08lX", *(U32 *)&buffer[0] );
        else sprintf(str,"%08lX (%lu)", *(U32 *)&buffer[0], *(U32 *)&buffer[0]);
        break;
      case SLONG:
        if (isProc) sprintf(str, "%08lX", *(S32 *)&buffer[0] );
        else sprintf(str,"%08lX (%ld)", *(S32 *)&buffer[0], *(S32 *)&buffer[0]);
        break;
      case SINGLE:
        sprintf( str, "%g", *(float *)&buffer[0]);
        break;
      case DOUBLE:
        sprintf( str, "%lg", *(double *)&buffer[0]);
        break;
      case LDOUBLE:
        sprintf( str, "%lg", *(long double *)&buffer[0]);
        break;
      default :
        free(buffer);
        return(FAIL);
   }
   if (buffer) free(buffer);
   return(OK);
}

/**************************************************************************
**
** Name : FindLocalVariable()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE FindLocalVariable(S16 level, STR symName, U32 *addr, U16 *type,
                                 U32 *blkAddr, U8 *flag)
{
S16 i, j, k, a, offset;
char nn[NAMELEN+1], frameMethod;
BLOCK_INFO blkInfo;
U32 curPC, curFP;

   if (!level) {
      emuGetReg(I86_REG, REG_PC, &curPC);
      emuGetReg(I86_REG, REG_FP, &curFP);
   }
   else if (GetLevelRetAddr( 1, level, &curPC, &curFP ) == FAIL) return(FAIL);
   if ((i=GetBlockInfo(curPC, &blkInfo)) == FAIL || !blkInfo.blkSymCnt)
      return(FAIL);
   if (i == 1) return(i);
   *blkAddr = blkInfo.startAddr;
   lseek(fdsy, blkInfo.blkSymPos, SEEK_SET);
   read(fdsy, &satable[0], blkInfo.blkSymCnt*SYMRECLEN); // defined in usym3.h
   for (i=0, k=0; k < blkInfo.blkSymCnt; k++) {
      frameMethod = satable[i];
      j = (int)satable[i+1];
      memset(nn, NULL, NAMELEN+1);
      memcpy(nn, &satable[i+2], j);
      if (( caseFlag && (a=strcmp(symName, nn)) == 0)  ||
           (!caseFlag && (a=strcmpi(symName, nn)) == 0)) {
         *flag = frameMethod ? frameMethod : 1; // static:1, stacked:2
         strcpy( symName, nn);
         i += j + 2;
         if (!frameMethod) {  // static var
            *addr = ((U32)satable[i+1] << 8) + satable[i];
            *addr = (*addr << 16) + ((U32)satable[i+3] << 8) + satable[i+2];
         }
         else {
            offset = (S16)(((U16)satable[i+3] << 8) + satable[i+2]);
            *addr = curFP + offset;
         }
         i += env.Saddrunit;
         *type = ((U16)satable[i+1] << 8) + satable[i];
         return (OK);
      }
      i += j + env.Saddrunit + 2 + sizeof(S16);
   }
   return (FAIL);
}        /* end of FindLocalVariable() */

/***************************************************************************
**
**  Name: GetLevelRetAddr()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE GetLevelRetAddr(FLAG flag, U16 level, U32 *retAddr, U32 *retFP)
{
BLOCK_INFO blockInfo;
U32 addr, curPC, curFP, curSP, nextFP;
U8 arr[4];
U16 i, retByte;

   if (level < 1) return(FAIL);

   emuGetReg(I86_REG, REG_PC, &curPC);
   emuGetReg(I86_REG, REG_FP, &curFP);

   emuGetReg(I86_REG, REG_SP, &curSP);   // added by James
   FPisNormal(curPC, curSP, &curFP);

   for ( i=0; i<level; i++ ) {
      if (GetBlockInfo( curPC, &blockInfo) != OK) return(FAIL);
      if ( blockInfo.blkSymCnt == 0 ) return (FAIL); // added by James
      addr = curFP + blockInfo.retOffset;
      retByte = blockInfo.retByte;
      emuGetMemN( addr, arr, (U32)retByte);
      if (retByte == 4) addr =  *((U32 *)&arr[0]);
      else {
          addr = (U32)(*((U16 *)&arr[0]));
          addr += curPC&0xFFFF0000;
      }
      emuGetMemN( curFP, arr, 2L);
      nextFP = (U32)(*((U16 *)&arr[0]));
      nextFP += curFP&0xFFFF0000;
      curFP = nextFP;
      curPC = addr - retByte - 1;
   }
   *retAddr = flag ? addr - retByte - 1 : addr;
   *retFP = nextFP;
   return(OK);
}

/***************************************************************************
**
**  Name: FPisNomal()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE FPisNormal( U32 curPC, U32 curSP, U32 *curFP )
{
U32 addr;
U8  temp[80];

   addr = (U32)( (curPC >> 12) & 0x000ffff0 ) + (U32)(curPC & 0x0000ffff);
   if ( Addr2Block( addr, temp ) == 1 ) {   // is block begin ?
      *curFP = curSP - 2;
   }
}
/***************************************************************************
**
**  Name: GetStackInfo()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE GetStackInfo( U32 curPC, U32 curFP, U32 curSP, STR procName, U32 *retAddr,
                             U32 *retFP, U16 *off, U8 *retByte, STRING buf)
{
BLOCK_INFO blockInfo;
U32 addr, saveFP;
U8 arr[4], frameMethod, temp[40];
S16 k, j, i, offset;
U16 typeIdx;

   saveFP = curFP; // added by James
   FPisNormal(curPC, curSP, &curFP);

   if (GetBlockInfo( curPC, &blockInfo ) == OK) {
      if ( blockInfo.blkSymCnt == 0 )  // added by James
          curFP = curSP;
      strcpy( procName, blockInfo.name );
      addr = curFP + blockInfo.retOffset;
      emuGetMemN( addr, arr, (U32)blockInfo.retByte);
      if (blockInfo.retByte == 4) *retAddr =  *((U32 *)&arr[0]);
      else {
          *retAddr = (U32)(*((U16 *)&arr[0]));
          *retAddr += curPC&0xFFFF0000;
      }
      curFP = saveFP; // added by James
      emuGetMemN( curFP, arr, 2L);
      *retFP  = (U32)(*((U16 *)&arr[0]));
      *retFP  += curFP&0xFFFF0000;
      *off = curPC - blockInfo.startAddr;
      *retByte = (U8)blockInfo.retByte;

      // check curFP is valid again. added by James
      FPisNormal(curPC, curSP, &curFP);

      lseek(fdsy, blockInfo.blkSymPos, SEEK_SET);
      read(fdsy, &satable[0], blockInfo.blkSymCnt*SYMRECLEN); // defined in usym3.h
      strcpy(buf,"(");
      for (i=0, k=0; k < blockInfo.blkSymCnt; k++) {
         frameMethod = satable[i];
         i += (S16)satable[i+1]  + 2;
         if (frameMethod == 2) {
            offset = (S16)(((U16)satable[i+3] << 8) + satable[i+2]);
            addr = curFP + offset;
         }
         else offset = -1;
         i += env.Saddrunit;
         if (offset >= 0 ) {
            typeIdx = ((U16)satable[i+1] << 8) + satable[i];
            memset( &typeInfo , NULL, sizeof( TYPE_INFO ));
            memset( &arrInfo , NULL, sizeof( ARRAY_INFO ));
            memset( &struInfo , NULL, sizeof( STRUCT_INFO ));
            if (GetTypeInfo( typeIdx ) != FAIL) {
               if ( GetContentStr( TRUE, TRUE, addr, typeInfo.type,
                    typeInfo.len, temp ) == OK ) {
                  if (strlen(buf) > 2) strcat(buf,",");
                  strcat(buf, temp);
               }
            }
            for (j=0; j < struInfo.itemCnt; j++)
               if (struInfo.itemName[j]) free(struInfo.itemName[j]);
         }
         i += 2;
      }
      strcat(buf,")");
      return(OK);
   }
   return(FAIL);
}

/***************************************************************************
**
**  Name: GetTypeInfo()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE GetTypeInfo(U16 typeIdx)
{
U32 pos;
U16 type, head, retCnt, i, j, recLen;
U8  *tmpBuf=NULL, *typeStr=NULL;
U8  *ptr, *ptrStart, temp[5];
RETCODE ret;

   if (typeIdx < 1) return(FAIL);
   i = (typeIdx-1)/TYPERECNO;
   head = i * TYPERECNO + 1;
   if (head != oldHead) {
      pos = typePos[i];
      oldHead = 0;
      memset( typePosArr, NULL, sizeof(typePosArr) );
      if ((tmpBuf = malloc(1 + 100 * TYPERECNO)) == NULL) return(FAIL);
      lseek( fdsy, pos , SEEK_SET );
      j = read(fdsy, tmpBuf, 100 * TYPERECNO);
      tmpBuf[j] = NULL;
      ptr = tmpBuf;
      for (i = head - 1, j=0; j < TYPERECNO; i++, j++) {
         if (*ptr != TYPDEF) {  // type records end
            free(tmpBuf);
            break;
         }
         typePosArr[j] = pos + (U32)(ptr-tmpBuf);
         retCnt = (U16)(*(ptr+2));
         retCnt = (retCnt << 8) + (U16)(*(ptr+1));
         if (i == typeIdx-1) {
            ptrStart = ptr + 5;
            recLen = retCnt - 3;
            if ( *(ptr+3) || *(ptr+4) ||
                 (typeStr = malloc( (S32)(recLen+1))) == NULL) {
               free(tmpBuf);
               if (typeStr) free(typeStr);
               return(FAIL);
            }
            StrmnCopy( typeStr, ptrStart, 0, recLen );
         }
         ptr += ( 3 + retCnt );
      }
      oldHead = head;
      free(tmpBuf);
   }
   else {
      pos = typePosArr[ (typeIdx - 1) % TYPERECNO  ];
      lseek( fdsy, pos , SEEK_SET );
      read(fdsy, temp, 5);
      if (temp[0] != TYPDEF) return(FAIL);
      retCnt = (U16)temp[2];
      retCnt = (retCnt << 8) + (U16)temp[1];
      recLen = retCnt - 3;
      if (temp[3] || temp[4] || (typeStr = malloc( (S32)(1+recLen))) == NULL) {
         if (typeStr) free(typeStr);
         return(FAIL);
      }
      read( fdsy, typeStr, recLen+1 );
   }
   ret = ProcessTypeRecord( recLen, typeStr );
   free(typeStr);
   return( ret );
}


/***************************************************************************
**
**  Name: CheckType()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC RETCODE CheckType(U16 typeIdx)
{
RETCODE ret=OK;
U16 i;

  if (cmdIdx != C_WATCH && cmdIdx != C_MONITOR) return(OK);
  memset( &typeInfo , NULL, sizeof( TYPE_INFO ));
  memset( &arrInfo , NULL, sizeof( ARRAY_INFO ));
  memset( &struInfo , NULL, sizeof( STRUCT_INFO ));
  if (GetTypeInfo( typeIdx ) == FAIL) ret = FAIL;
  else if (typeInfo.type == ARRAY && !arrInfo.size[0] ) ret = FAIL;
  for (i=0; i < struInfo.itemCnt; i++)
     if (struInfo.itemName[i]) free(struInfo.itemName[i]);
  return( ret );
}

/***************************************************************************
**
**  Name: BackTraceUp()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Notes :
**
****************************************************************************/
PUBLIC RETCODE BackTraceUp(VOID)
{
 S8 temp[80];

   cmd_syntax.argc = 4;
   cmd_syntax.argv[0] = (S32)++backLevel;
   if (ViewCmd( FALSE ) != OK) {
      beep_vv( BPMEDIUM, BPMIDDLE);
      backLevel--;
   }
   return(OK);
}

/***************************************************************************
**
**  Name: BackTraceDown()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Notes :
**
****************************************************************************/
PUBLIC RETCODE BackTraceDown(VOID)
{
 S8 temp[80];

   if (backLevel <  1) beep_vv( BPMEDIUM, BPMIDDLE);
   else if (backLevel == 1) {
      cmd_syntax.argc = backLevel = 0;
   }
   else if (backLevel > 1) {
      cmd_syntax.argc = 4;
      cmd_syntax.argv[0] = (S32)(--backLevel);
   }
   if (ViewCmd( FALSE ) != OK) beep_vv( BPMEDIUM, BPMIDDLE);
   return(OK);
}


/**************************************************************************
**
** Execution codes ( Private )
**
***************************************************************************/

/***************************************************************************
**
**  Name: PutPrevPageinMixMode()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE RETCODE PutPrevPageinMixMode( U16 lineNo, S16 flag, S16 rowOrg, S8 *cnt)
{
U16 head, k, idx =0, len;
S8  tmpBuf[256], ret;
U32 addr, addr2, oldAddr;
U8 *codVPbuf=NULL, *ptr;
U16 lineCnt, donePoint=0;
U8  (*rowBuf)[1+CODBUFCOL], *buffer;
S8  temp[1+CODBUFCOL], *ptrTemp;
S16 j, row;
BLOCK_INFO blkInfo;

   row = (flag == CODVP_PREV) ? rowOrg + VP[CODVP].Height - 4 : 1 + rowOrg;
   k = VP[CODVP].Ptr->r;
   while (1) {
      VP[CODVP].Ptr->r = row--;
      v_stcpy(temp, FROM_WN, ROW, VP[CODVP].Ptr);
      ptrTemp = &temp[CODVPINDENT];
      if (temp[CODVPINDENT-1] == '<' || isxdigit(*ptrTemp) ) break;
      if (row < 0) return(FAIL);
   }
   VP[CODVP].Ptr->r = k;
   lineCnt = lineNo;
   if ((buffer= malloc( CODBUFROW*(1+CODBUFCOL))) == NULL) return(FAIL);
   *rowBuf = buffer;
   memset( rowBuf, NULL, CODBUFROW*(1+CODBUFCOL) );
   row=0;
   if ((codVPbuf= malloc(512)) == NULL) {
      free(buffer);
      return(FAIL);
   }
   while ( row < 200 ) {
      if (lineCnt > curModule.lastLine) {
         if (!donePoint) donePoint = row;
         break;
      }
      if (FillFileBuf( lineCnt ) == FAIL) {
         if (!row) {
            free(buffer);
            free(codVPbuf);
            return(FAIL);
         }
         if (!donePoint) donePoint = row;
         break;
      }
      oldAddr = 0L;
      head = fileBuf.startLine;
      for ( k = lineCnt; k <= head + fileBuf.size - 1;  k++ ) {
         sprintf( tmpBuf, "<%4d %s\r\n", lineCnt, fileBuf.line[k-head] );
         strcpy( rowBuf[(row++) % CODBUFROW], tmpBuf );
         if ((len=strlen(tmpBuf)-2) < 10) {
            for (ret = len; ret < 10; ret++) tmpBuf[ret] = ' ';
            tmpBuf[10] = NULL;
         }
         if (strncmp( ptrTemp, 1+tmpBuf, 9 ) == NULL ) donePoint = row;
         if ((ret=LinNum2AddrRange( lineCnt++, &addr, &addr2, &idx )) != FAIL) {
         if (MICE < V20MAX || NECflag == 0 ) {
            if (oldAddr != addr) {
               j=CODBUFROW*7;
               GetMemWrap(addr, codVPbuf, j);
               ptr = codVPbuf;
            }
         }
            if (ret == LASTLINE) {
               ret = OK;
               if (GetBlockInfo(addr, &blkInfo) == FAIL) {
                  if (!donePoint || row <= CODBUFROW) {
                     if (MICE < V20MAX || NECflag == 0 )
                        PutOneAsmRowinBuf( &addr, &ptr, &j, tmpBuf );
                     else
                        ret = PutOneAsmV20( &addr, tmpBuf );
                     oldAddr = addr;
                     strcpy( rowBuf[(row++) % CODBUFROW], tmpBuf );
                  }
                  if (!donePoint) donePoint = row;
                  break; // from for loop
               }
               else addr2 = blkInfo.endAddr;
            }
            ret = OK;
            while (addr<=addr2 && (!donePoint || row < CODBUFROW) && ret==OK) {
            if (MICE < V20MAX || NECflag == 0 ) {
               if (j < 7) {
                  j=CODBUFROW*7;
                  GetMemWrap(addr, codVPbuf, j);
                  ptr = codVPbuf;
               }
            }
               if (MICE < V20MAX || NECflag == 0 )
                  ret = PutOneAsmRowinBuf( &addr, &ptr, &j, tmpBuf );
               else
                  ret = PutOneAsmV20( &addr, tmpBuf );
               oldAddr = addr;
               strcpy( rowBuf[(row++) % CODBUFROW], tmpBuf );
               if (strncmp( ptrTemp, tmpBuf, 9 ) == NULL) donePoint = row;
            }
         }
         if (donePoint && row >= CODBUFROW)  break;
      }  // end of for loop
      if (donePoint && row >= CODBUFROW)  break;
   }  // end of while
   if (donePoint) {
      CODBuf[0] = NULL;
      if (row <= CODBUFROW ) {
         for ( j=0; j < row; j++ ) strcat( CODBuf, rowBuf[j] );
         *cnt = row;
      }
      else {
         for ( j = row % CODBUFROW, idx=0; j < CODBUFROW; j++, idx++ )
            strcat( CODBuf, rowBuf[j] );
         for ( j = 0; idx < CODBUFROW; j++, idx++ )
            strcat( CODBuf, rowBuf[j] );
         *cnt = CODBUFROW;
      }
//    if (flag == CODVP_PREV) VP[CODVP].Ptr->row_org = *cnt - VP[CODVP].Height;
//    else VP[CODVP].Ptr->row_org = *cnt - VP[CODVP].Height + 2;
      VP[CODVP].Ptr->row_org = *cnt - VP[CODVP].Height + 2;
      if (donePoint < CODBUFROW) {
         VP[CODVP].Ptr->row_org = (donePoint > VP[CODVP].Height - 2)  ?
                                   donePoint - VP[CODVP].Height + 2 : 0;
      }
   }
   free(buffer);
   free(codVPbuf);
   return(donePoint ? OK : FAIL);
}

/***************************************************************************
**
**  Name: PutBottomPageinMixMode()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE RETCODE PutBottomPageinMixMode( U16 lineNo, S8 *cnt)
{
U16 head, k, idx =0;
S8  tmpBuf[256], ret;
U32 addr, addr2, oldAddr;
U8 *codVPbuf=NULL, *ptr;
U16 lineCnt, donePoint=0;
U8  (*rowBuf)[1+CODBUFCOL], *buffer;
S16 j, row;
BLOCK_INFO blkInfo;

   lineCnt = lineNo;
   if ((buffer= malloc( CODBUFROW*(1+CODBUFCOL))) == NULL) return(FAIL);
   *rowBuf = buffer;
   memset( rowBuf, NULL, CODBUFROW*(1+CODBUFCOL) );
   row=0;
   if ((codVPbuf= malloc(512)) == NULL) {
      free(buffer);
      return(FAIL);
   }
   while ( 1 ) {
      if (lineCnt > curModule.lastLine) {
         if (!donePoint) donePoint = row;
         break;
      }
      if (FillFileBuf( lineCnt ) == FAIL) {
         if (!row) {
            free(buffer);
            free(codVPbuf);
            return(FAIL);
         }
         if (!donePoint) donePoint = row;
         break;
      }
      oldAddr = 0L;
      head = fileBuf.startLine;
      for ( k = lineCnt; k <= head + fileBuf.size - 1;  k++ ) {
         sprintf( tmpBuf, "<%4d %s\r\n", lineCnt, fileBuf.line[k-head] );
         strcpy( rowBuf[(row++) % CODBUFROW], tmpBuf );
         if ((ret=LinNum2AddrRange( lineCnt++, &addr, &addr2, &idx )) != FAIL) {
         if (MICE < V20MAX || NECflag ==0 ) {
            if (oldAddr != addr) {
               j=CODBUFROW*7;
               GetMemWrap(addr, codVPbuf, j);
               ptr = codVPbuf;
            }
         }
            if (ret == LASTLINE) {
               if (GetBlockInfo(addr, &blkInfo) == FAIL) {
                  if (MICE < V20MAX || NECflag == 0 )
                     PutOneAsmRowinBuf( &addr, &ptr, &j, tmpBuf );
                  else
                     ret = PutOneAsmV20( &addr, tmpBuf );
                  oldAddr = addr;
                  strcpy( rowBuf[(row++) % CODBUFROW], tmpBuf );
                  break;
               }
               else addr2 = blkInfo.endAddr;
            }
            ret = OK;
            while (addr<=addr2 && (!donePoint || row < CODBUFROW) && ret==OK) {
            if (MICE < V20MAX || NECflag == 0 ) {
               if (j < 7) {
                  j=CODBUFROW*7;
                  GetMemWrap(addr, codVPbuf, j);
                  ptr = codVPbuf;
               }
            }
               if (MICE < V20MAX || NECflag == 0 )
                  ret = PutOneAsmRowinBuf( &addr, &ptr, &j, tmpBuf );
               else
                  ret = PutOneAsmV20( &addr, tmpBuf );
               oldAddr = addr;
               strcpy( rowBuf[(row++) % CODBUFROW], tmpBuf );
            }
         }
         if (ret == LASTLINE) break;
      }  // end of for loop
   }  // end of while
   if (donePoint) {
      CODBuf[0] = NULL;
      if (row <= CODBUFROW ) {
         for ( j=0; j < row; j++ ) strcat( CODBuf, rowBuf[j] );
         *cnt = row;
      }
      else {
         for ( j = row % CODBUFROW, idx=0; j < CODBUFROW; j++, idx++ )
            strcat( CODBuf, rowBuf[j] );
         for ( j = 0; idx < CODBUFROW; j++, idx++ )
            strcat( CODBuf, rowBuf[j] );
         *cnt = CODBUFROW;
      }
      VP[CODVP].Ptr->row_org = *cnt - VP[CODVP].Height + 2;
      if (donePoint < CODBUFROW) {
         VP[CODVP].Ptr->row_org = (donePoint > VP[CODVP].Height - 2)  ?
                                   donePoint - VP[CODVP].Height + 2 : 0;
      }
   }
   free(buffer);
   free(codVPbuf);
   return(donePoint ? OK : FAIL);
}

/***************************************************************************
**
**  Name: LinNum2AddrRange()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE RETCODE LinNum2AddrRange( U16 lineNum, U32 *addr1, U32 *addr2, S16 *idx )
{
U16 i, j=0;

   if (ReadLinNumInfo(curModule.modNum) == FAIL) return(FAIL);
   do {
      for (i = *idx; i < lineInfoCnt; i++) {
         if (lineNum == linnumInfo[i].lineNum) {
            *addr1 = ((U32)frameNo << 16) + linnumInfo[i].offset;
            *idx  = i + 1;
            if ( i+1 >= lineInfoCnt )
               return(LASTLINE);
            *addr2 = ((U32)frameNo << 16) + linnumInfo[i+1].offset-1;
            return(OK);
         }
      }
      if (*idx) {
         if (!j) *idx = 0;
         ++j;
      }
      else break;
   } while (j < 2 ) ;
   return( FAIL );
}

/***************************************************************************
**
**  Name: ReadLinNumInfo()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE RETCODE ReadLinNumInfo(S16 modNum)
{
U32 len, pos;
U16 modIdx;
// LINNUMINFO *base;
// fdsy : the handle of the symbol(.USD) file.
// lineInfoPos[]: the array to store the file positions (in the designated .USD
//                file) of the linnum info. for modules.

   if (SymLoaded != OK) return(FAIL);
   if ( modNum != oldModule ) {
      oldModule = -1;
      if (linnumInfo) free(linnumInfo);
      if (!(pos=lineInfoPos[modNum])) return(FAIL);
      lseek( fdsy, pos , SEEK_SET );
      read(fdsy, (unsigned char *)&modIdx,  sizeof(U16));
      if (modIdx != modNum ) return(FAIL);
      read(fdsy, (unsigned char *)&frameNo, sizeof(U16)); // local variable
      read(fdsy, (unsigned char *)&len,     sizeof(U32));
      if (!len || len%4 ) return(FAIL);
      if ((linnumInfo = (LINNUMINFO *)malloc(len)) == NULL) return(FAIL);
      read(fdsy, (unsigned char *)linnumInfo, sizeof(LINNUMINFO)*(len/4) );
      oldModule = modNum;
      lineInfoCnt = len/4;
   }
   return(OK);
}

/***************************************************************************
**
**  Name: InitSourceEnvironment()
**
**  Description:
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE RETCODE InitSourceEnvironment(S16 curMod, STR fileTmp)
{
U8 fileName[80], i, j;
U8 tempExt[6][5];

  if (curMod != oldSource) {
     oldSource = -1;
     if (filePtr) fclose(filePtr);
     for (i=0; i < 4; i++) strcpy( tempExt[i], extName[i] );
     strcpy(tempExt[4], ".C");
     strcpy(tempExt[5], ".ASM");
     for (i=0; i < 5; i++) {
        for (j=0; j < 6; j++) {
           if (!i) sprintf( fileName, "%s%s", fileTmp, tempExt[j]);
           else sprintf( fileName, "%s\\%s%s", pathName[i-1], fileTmp, tempExt[j]);
           if ((filePtr = fopen( fileName, "rb" )) != NULL) {
              strcpy( sourceName, strupr(fileName) );
              memset( filePosBuf, NULL, sizeof( filePosBuf ) );
              curModule.lastLine = 0xFFFF;
              memset( &fileBuf, NULL, sizeof(FILEBUF));
              fileBuf.modNum = -1;
              oldSource = curMod;
              return(OK);
           }
        }
     }
     return(FAIL);
  }
  return(OK);
}

/***************************************************************************
**
**  Name: FillFileBuf(lineNo)
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC  RETCODE FillFileBuf(U16 lineNo)
{
S8 *tmpBuf, *ptrStart, *ptrEnd, inx=0, *fileEnd, tmpStr[256];
S16 retCnt, len, fullLen, i, j, curMod, tail;
U16 lineCnt = 1;
S32 leftOver, filePos=0;
U32 curPC;

   if (filePtr == NULL) return(FAIL);
   if ( curModule.modNum == fileBuf.modNum) {
      if (lineNo > curModule.lastLine ) return(FAIL);
      else if ( lineNo == fileBuf.startLine ) return(OK);
   }
   else if (InitSourceEnvironment(curModule.modNum, curModule.modName) == FAIL)
      return(FAIL);
   tail = fileBuf.startLine + fileBuf.size - 1;
   if (lineNo <= fileBuf.startLine && lineNo >= tail) {
      lineCnt = lineNo;
      filePos = fileBuf.filePos[lineNo - fileBuf.startLine];
   }
   else {
      i = (lineNo-1) / BUFROW - 1;
      filePos = (i >= 0) ? filePosBuf[i] : 0L;
      if (filePos) lineCnt = 1 + BUFROW*(i+1);
      else if ( i > 0 ) {
         for (j = i-1; j >= 0; j--) {
            if ( filePosBuf[j] ) {
               lineCnt = 1 + BUFROW*(j + 1) ;
               filePos = filePosBuf[j];
               break;
            }
         }
      }
   }
   memset( &fileBuf, NULL, sizeof(FILEBUF));
   fileBuf.modNum = -1;
   loadAll = FALSE;
   if ((tmpBuf = malloc( BUFSIZE*2 )) == NULL) return(FAIL);
   retCnt = 1+BUFSIZE;
   fileEnd = NULL;
   while ( !fileEnd && inx < BUFROW && retCnt >= BUFSIZE ) {
      ptrStart = tmpBuf;
      // Added by Frank, 02/22/95
      memset(tmpBuf, NULL, sizeof(tmpBuf));
      if ( fseek( filePtr, filePos, SEEK_SET )  ||
          ( (retCnt = fread((VOID *)tmpBuf, sizeof(S8), BUFSIZE, filePtr ))
                      < BUFSIZE && ferror(filePtr) ) ) {
         free( tmpBuf );
         return(FAIL);
      }

//      while ( (ptrStart < tmpBuf + retCnt ) &&
//              (ptrEnd = strstr(ptrStart, "\r\n")) != NULL) {

        while ( (ptrStart <= tmpBuf + BUFSIZE) &&
                (ptrEnd = strstr(ptrStart, "\r\n")) != NULL) {
         if (lineCnt >= lineNo && inx < BUFROW) {
            if (inx==0) {
               fileBuf.modNum = curModule.modNum;
               fileBuf.startLine = lineCnt;
            }
            fullLen = ptrEnd-ptrStart;
            len = (fullLen >= ROWLEN) ? ROWLEN : fullLen;
            StrmnCopy( tmpStr, ptrStart, 0, fullLen );
            if ((fileEnd=strchr( tmpStr, '\x1A')) != NULL) *fileEnd = '\0';
            strncpy( fileBuf.line[inx], tmpStr, len );
            fileBuf.line[inx][len] = '\0';
            fileBuf.filePos[inx] = filePos + (S32)(ptrStart - tmpBuf);
            GetRidofTabs( fileBuf.line[inx] );
            if (!fileEnd || fullLen > 0) inx++;
         }
         ptrStart = ptrEnd+2;
         i = lineCnt / BUFROW - 1;
         if ( !(lineCnt % BUFROW))
            filePosBuf[i] = filePos + (S32)(ptrStart - tmpBuf);
         if (inx >= BUFROW  || fileEnd) break;
         lineCnt++;
      }
      filePos +=  (S32)(ptrStart - tmpBuf);
   }
   leftOver = tmpBuf + retCnt - ptrStart;
   if (!fileEnd && inx < BUFROW) {
      if (!leftOver) lineCnt--;
      else {
         if ((fileEnd=strchr(ptrStart, '\x1A')) != NULL && *ptrStart != '\x1A') {
            if (inx==0) {
               fileBuf.modNum = curModule.modNum;
               fileBuf.startLine = lineCnt;
            }
            len = fileEnd-ptrStart-1 >= ROWLEN ? ROWLEN : (S16)(fileEnd-ptrStart-1);
            strncpy( fileBuf.line[inx], ptrStart, len );
            fileBuf.line[inx][len] = '\0';
            fileBuf.filePos[inx] = filePos + (S32)(ptrStart - tmpBuf);
            GetRidofTabs( fileBuf.line[inx] );
            inx++;
         }
      }
   }
   if (!inx) {
      free(tmpBuf);
      return(FAIL);
   }
   fileBuf.size = inx;
   if ( fileEnd || (retCnt < BUFSIZE && ptrStart >= tmpBuf + retCnt) ||
        inx < BUFROW ) {
      loadAll = TRUE;
      curModule.lastLine = lineCnt;
   }
   free(tmpBuf);
   return(OK);
}

/***************************************************************************
**
**  Name: GetRidofTabs()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE RETCODE GetRidofTabs(STR string)
{
  S8 *tmpBuf, *ptr, *tmpBuf1, *ptrStr;
  S16 len;

  if ((tmpBuf = malloc( 100 )) == NULL) return(FAIL);
  if ((tmpBuf1 = malloc( 100 )) == NULL) {
     free(tmpBuf1);
     return(FAIL);
  }
  ptrStr = string ;
  while ((ptr = strchr( ptrStr, '\t')) != NULL ) {
     strcpy(tmpBuf1, string);
     len = ptr-string;
     tmpBuf1[ len ] = '\0';
     sprintf( tmpBuf, "%s%s%s", tmpBuf1, TABS, ptr+1 );
     strncpy( string, tmpBuf, ROWLEN );
     string[ ROWLEN ] = 0;
     ptrStr = string+len+3;
  }
  free(tmpBuf);
  free(tmpBuf1);
  return(OK);
}

/***************************************************************************
**
**  Name: GetLength()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE U32 GetLength( STRING typeStr, S16 *i )
{
U32 len= 0L;
U8 c;
S16 k;

   k = *i;
   c = typeStr[k++];
   switch (c) {
      case T_U16:   // 0x81
          len = typeStr[k];
          len += (U32)(((U16)typeStr[k+1]) << 8);
          k += 2;
          break;
      case T_U24:
          len = typeStr[k+2];
          len = (U32)(len << 8) + typeStr[k+1];
          len = (U32)(len << 8) + typeStr[k];
          k += 3;
          break;
      default:
          len = (U32)c;
          break;
   }
   *i = k;
   return( len );
}

/***************************************************************************
**
**  Name: GetName()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE RETCODE GetName( STRING typeStr, S16 *i, STR name )
{
U32 len, j;

   j = GetLength( typeStr, i);
   len = j > NAMELEN ? NAMELEN : j;
   StrmnCopy( name, typeStr, *i, len );
   *i += j;
   return(OK);
}

/***************************************************************************
**
**  Name: ProcessIndex()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PRIVATE RETCODE ProcessIndex( STRING typeStr, S16 *i )
{
U16 j, typeIdx;

  j = (U16)typeStr[(*i)++];
  typeIdx = (j & 0x80) ? ((j&0x7F) << 8) + typeStr[(*i)++] : (U16)j;
  return( GetTypeInfo( typeIdx ) );
}

/**************************************************************************
**
** Name : ProcessTypeRecord
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE ProcessTypeRecord(S16 recLen, STRING typeStr)
{
S16 i=0;
U8 type, c;
U16 k;
U32 j;
S16 itemCnt;  // 06/15/1994 James Wang  for union format.
static S16 curitem;

   while (i < recLen) {
      type = typeStr[i++];
      switch ( type ) {
         case T_LABEL:  // 0x71
            if (typeStr[i++] != T_NULL) return(FAIL); // 0x80
            if ((c=typeStr[i++]) == T_LONG) {  // 0x72
                typeInfo.type = LABEL_LONG;
                break;
            }
            else if (c == T_SHORT) {  // 0x73
                typeInfo.type = LABEL_SHORT;
                break;
            }
            else return(FAIL);
         case T_PROCEDURE: // 0x74
            if (!typeInfo.type) typeInfo.type = PROCEDURE;
            break;
         case T_ARRAY:     // 0x77
            j = GetLength( typeStr, &i );
            if (!typeInfo.type) {
               typeInfo.type = ARRAY;
               arrInfo.dim = 1;
               typeInfo.len = j;
               arrInfo.size[ 0 ] = (U16)j;
            }
            else {
               arrInfo.size[arrInfo.dim] = (U16)j;
               arrInfo.size[arrInfo.dim-1] /= (U16)j;
               arrInfo.dim++;
            }
            if (typeStr[i++] != T_INDEX || ProcessIndex( typeStr, &i) == FAIL)
               return(FAIL);
            break;
         case T_STRUCTURE: // 0x79
            j = GetLength( typeStr, &i );
            if (!typeInfo.type) {
               typeInfo.type = STRUCTURE;
               typeInfo.len  = j;
            }
            else if (typeInfo.type == ARRAY) {
               arrInfo.subType = STRUCTURE;
               arrInfo.size[arrInfo.dim - 1] /= (U16)j;
            }

            if (typeStr[i+1] != T_INDEX) { // union format 06/15/1994 James
               typeInfo.type = UNION;
               while ( typeStr[i++] != T_UNPACKED );
               itemCnt = typeStr[i++];
               struInfo.itemCnt = 1;
               curitem = 0;
               for (j=0; j<itemCnt; j++) {
                  while ( typeStr[i++] != T_INDEX );
                  i--;
                  for (k = 0; k < 2; k++) {
                     while (typeStr[i] != T_INDEX) i++; // 06/16/1994 James
                     if (typeStr[i++] != T_INDEX || ProcessIndex(typeStr, &i) == FAIL)
                        return(FAIL);
                  }
                  curitem++;
               }
               struInfo.itemCnt = itemCnt;
               break;
            }

            struInfo.itemCnt = GetLength( typeStr, &i );
            for (k = 0; k < 2; k++) {
               if (typeStr[i++] != T_INDEX || ProcessIndex(typeStr, &i) == FAIL)
                  return(FAIL);
            }
            if ( typeStr[i++] != T_NAME ||
                 GetName(typeStr, &i, struInfo.name) != OK) return(FAIL);
            break;
         case T_POINTER:   // 0x7A
            typeInfo.scope++;
            if (typeStr[i++] != T_INDEX) return(FAIL);
            if (ProcessIndex( typeStr, &i) == FAIL) return(FAIL);
            break;
         case T_INDEX:     // 0x83
            if (ProcessIndex( typeStr, &i) == FAIL) return(FAIL);
            break;
         case T_SCALAR: // 0x7B
            j = GetLength( typeStr, &i );
            if (j % sizeof(U8)) return(FAIL);
            if ((c = typeStr[i++]) >= T_UNSIGNED && c <= T_REAL &&
//                j >= scalarLen[UNCHAR] && j <= scalarLen[LDOUBLE] ) {
               // Dome let us support customer UMAX.USD  12/26/1994
                 j >= scalarLen[NIL] && j <= scalarLen[LDOUBLE] ) {
               typeInfo.len = j;
               if (c != T_REAL) {
                  if (j > scalarLen[UNLONG] ) return(FAIL);
                  if (!typeInfo.type)
                     typeInfo.type = (j/scalarLen[UNINT])*2 +
                                     (c - T_UNSIGNED) + 1;
                  else if (typeInfo.type == ARRAY) {
                     arrInfo.subType = (j/scalarLen[UNINT])*2 +
                                       (c - T_UNSIGNED) + 1;
                     arrInfo.size[arrInfo.dim - 1] /= (U16)j;
                  }
               }
               else {
                  if ( j < scalarLen[SINGLE] ) return(FAIL);
                  if (!typeInfo.type) {
                     for (k=SINGLE; k <= LDOUBLE; k++)
                        if (scalarLen[k] == j) typeInfo.type = k;
                  }
                  else if (typeInfo.type == ARRAY) {
                     for (k=SINGLE; k <= LDOUBLE; k++)
                        if (scalarLen[k] == j) arrInfo.subType = k;
                  }
               }
            }
            else if ( c == T_INDEX ) {
               typeInfo.ptrLen[typeInfo.scope] = j;
               if (ProcessIndex( typeStr, &i ) == FAIL) return(FAIL);
            }
            else return(FAIL);
            break;
         case T_LIST:   // 0x7F
            c = typeStr[i];

            if (typeInfo.type == UNION) { // 06/15/1994 James
               k = typeStr[i++];
               if (c == T_INDEX && c == k) {
                  k = (U16)typeStr[i++];
                  struInfo.itemType[curitem] = (k & 0x80) ?
                                         ((k&0x7F) << 8) + typeStr[i++] : k;
               }
               else if (c == T_NAME && c == k) {
                  if ((struInfo.itemName[curitem]=malloc(NAMELEN+1)) == NULL) {
                     for (k=0; k<curitem; k++)
                       if (struInfo.itemName[k]) free(struInfo.itemName[k]);
                     struInfo.itemCnt = 0;
                     return(FAIL);
                  }
                  else GetName( typeStr, &i, struInfo.itemName[curitem] );
               }
               else {
                  for (k=0; k<curitem; k++)
                     if (struInfo.itemName[k]) free(struInfo.itemName[k]);
                  struInfo.itemCnt = 0;
                  return(FAIL);
               }
            break;
            }

            for ( j=0; j < struInfo.itemCnt; j++) {
               k = typeStr[i++];
               // double with pointer in struct case : fixed by James
               if ( k == 0x0 ) k = typeStr[i++];
               if (c == T_INDEX && c == k) {
                  k = (U16)typeStr[i++];
                  struInfo.itemType[j] = (k & 0x80) ?
                                         ((k&0x7F) << 8) + typeStr[i++] : k;
               }
               else if (c == T_NAME && c == k) {
                  if ((struInfo.itemName[j]=malloc(NAMELEN+1)) == NULL) {
                     for (k=0; k<j; k++)
                       if (struInfo.itemName[k]) free(struInfo.itemName[k]);
                     struInfo.itemCnt = 0;
                     return(FAIL);
                  }
                  else GetName( typeStr, &i, struInfo.itemName[j] );
               }
               else {
                  for (k=0; k<j; k++)
                     if (struInfo.itemName[k]) free(struInfo.itemName[k]);
                  struInfo.itemCnt = 0;
                  return(FAIL);
               }
            }
            break;
         case T_NULL:   // 0x80
            typeInfo.type = NIL;
            break;
         case T_NAME: // 0x82 compatiable enumeration format.06/17/1994 James
            return(OK);
         default:
            return(FAIL);
      }
   }
   return(OK);
}

/**************************************************************************
**
** Name : ListLocalVariables()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE ListLocalVariables(U16 level)
{
S16 i, j, k, offset;
S8 name[NAMELEN+1], frameMethod, indent[NAMELEN];
BLOCK_INFO blkInfo;
U32 addr, curPC, curFP;
U16 typeIdx;

   if (!level) {
      emuGetReg(I86_REG, REG_PC, &curPC);
      emuGetReg(I86_REG, REG_FP, &curFP);
   }
   else if (GetLevelRetAddr( 1, level, &curPC, &curFP ) == FAIL)  return(FAIL);
   if ((i=GetBlockInfo(curPC, &blkInfo)) == FAIL || !blkInfo.blkSymCnt)
      return(FAIL);
   if (i == 1) return(i);
   lseek(fdsy, blkInfo.blkSymPos, SEEK_SET);
   read(fdsy, &satable[0], blkInfo.blkSymCnt*SYMRECLEN); // defined in usym3.h
   for (i=0, k=0; k < blkInfo.blkSymCnt; k++) {
      frameMethod = satable[i];
      j = (S16)satable[i+1];
      memset(name, NULL, NAMELEN+1);
      memcpy(name, &satable[i+2], j);
      i += j + 2;
      if (!frameMethod) {  // static var
         addr = ((U32)satable[i+1] << 8) + satable[i];
         addr = (addr << 16) + ((U32)satable[i+3] << 8) + satable[i+2];
      }
      else {
         offset = (S16)(((U16)satable[i+3] << 8) + satable[i+2]);
         addr = curFP + offset;
      }
      i += env.Saddrunit;
      typeIdx = ((U16)satable[i+1] << 8) + satable[i];
      memset( &typeInfo , NULL, sizeof( TYPE_INFO ));
      memset( &arrInfo , NULL, sizeof( ARRAY_INFO ));
      memset( &struInfo , NULL, sizeof( STRUCT_INFO ));
      if (GetTypeInfo( typeIdx ) != FAIL) {
         indent[0] = NULL;
         StruLevel = 0; // 06/02/1994 James
         arrsz = 0;
         ArrStru = 0;   // 08/09/1994 James
         msgon = MSG_ON;
         PrintVar( addr, name, indent );
      }
      for (j=0; j < struInfo.itemCnt; j++)
         if (struInfo.itemName[j]) free(struInfo.itemName[j]);
      i += 2;
   }
   return(OK);
}        /* end of ListLocalVariables() */

/**************************************************************************
**
** Name : PrintVar()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC  RETCODE PrintVar( U32 addr, STRING name, STRING indent )
{
U32 len, new;
U8  *buffer=NULL, ptr[80], temp[100], c, *tmpPtr, str[80], dim[40], arr[4];
S16 i, j;
U32 u32;
STRUCT_INFO *tmpStruct;
U16 ptr_arr = FALSE;  // 06/14/1994 James
U16 is_union = FALSE; // 06/16/1994 James Wang

   if ( StruLevel >= 8 ) {  // 06/02/1994 James
      if ( msgon == MSG_ON ) {
         msgon = MSG_OFF;
         DisplayStr(" The scope is too deep !\r\n");
      }
      return(OK);
   }

   if (((c=typeInfo.type) < UNCHAR && c > LDOUBLE) && !typeInfo.scope) {
      len = typeInfo.len / 8;
      if ((buffer= malloc(len)) == NULL) return(FAIL);
      if (len > 0 && emuGetMemN( addr, buffer, len) != OK) {
         free(buffer);
         return(FAIL);
      }
   }
   memset(ptr, NULL, sizeof(ptr) );
   if (typeInfo.scope) {
      new = addr;
      for (i=0; i < typeInfo.scope; i++) {
         ptr[i] = '*';
         if (typeInfo.type == ARRAY)  // 06/14/1994 James Wang
            continue;
         len = typeInfo.ptrLen[i]/8;
         if ((len != sizeof(U32) && len != sizeof(U16)) ||
             emuGetMemN( new, arr, len) != OK) return(FAIL);
         if (len < sizeof(U32)) {
            emuGetReg(I86_REG, DS, &u32);
            new =  ((u32&0x0FFFFL) << 16) + *(U16 *)&arr[0];
         }
         else new = *(U32 *)&arr[0];
         if (!new) break;
      }
      if (!new) {
         sprintf( temp, " %s%s %s%s [%04X?%04X]\r\n", indent,
                  typeArr[typeInfo.type], ptr, name, (U16)(new>>16),(U16)new);
         DisplayStr(temp);
         return(OK);
      }
//    if (typeInfo.type == STRUCTURE) {
//       sprintf( temp, " %s%s %s%s [%04X:%04X]\r\n", indent,
//                typeArr[typeInfo.type], ptr, name, (U16)(new>>16),(U16)new);
//       DisplayStr(temp);
//       return(OK);
//    }
      sprintf( temp, " %s%s %s%s [%04X:%04X] = ", indent,
               typeArr[typeInfo.type], ptr, name, (U16)(new>>16),(U16)new);
      addr = new;
   }
   switch (typeInfo.type) {
     case LABEL_SHORT:
     case LABEL_LONG:
        sprintf( temp, " %s%s : %s\r\n", indent, typeArr[ typeInfo.type], name );
        DisplayStr(temp);
        break;
     case  UNION:      // 06/15/1994 James
        is_union = TRUE;
     case  STRUCTURE:
        StruLevel++;  // 06/02/1994 James
        if ((tmpStruct=malloc(sizeof(STRUCT_INFO))) == NULL) {
           free(buffer);
           return(FAIL);
        }
        memcpy( tmpStruct, &struInfo, sizeof( STRUCT_INFO ) );

        if (typeInfo.type == UNION)  // 06/15/1994 James
        sprintf( temp, " %s%s %s {\r\n", indent, "union",
                       struInfo.name ); else

        sprintf( temp, " %s%s %s {\r\n", indent, typeArr[typeInfo.type],
                       struInfo.name );
        DisplayStr(temp);
        strcat(ptr, name);
        if (typeInfo.scope) {
           sprintf( temp, " [%04X:%04X]", (U16)(addr>>16),(U16)addr );
           strcat(ptr, temp );
        }
        strcpy( temp, indent );
        strcat( indent, "  ");
        for ( i = 0; i < tmpStruct->itemCnt; i++ ) {
           memset( &typeInfo , NULL, sizeof( TYPE_INFO ));
           memset( &arrInfo , NULL, sizeof( ARRAY_INFO ));
           memset( &struInfo , NULL, sizeof( STRUCT_INFO ));
           if (GetTypeInfo( tmpStruct->itemType[i] ) == FAIL) {
              if (tmpStruct->itemType[i]) free( tmpStruct->itemName[i] );
              for (j=0; j < struInfo.itemCnt; j++)
                 if (struInfo.itemName[j]) free(struInfo.itemName[j]);
              continue;
           }
           len = (typeInfo.len/8);
           len = typeInfo.scope ? 4 : len; // 06/03/1994 James
           PrintVar( addr, tmpStruct->itemName[i], indent );
//         if ( StruLevel > 0 && typeInfo.type == ARRAY ) // 06/04/1994 James
           if ( StruLevel > 0 && typeInfo.type == ARRAY
               && arrInfo.subType != STRUCTURE ) // 08/08/1994 James for array with structure.
               len *= arrsz;
           if (is_union == TRUE) len = 0; // 06/04/1994 James Wang
           addr += len;
           for (j=0; j < struInfo.itemCnt; j++)
              if (struInfo.itemName[j]) free(struInfo.itemName[j]);
           struInfo.itemCnt = 0;
//         free( tmpStruct->itemName[i] );  // 08/09/1994 James
           if ( !ArrStru )   free( tmpStruct->itemName[i] );
        }
        if ( StruLevel > 0 ) StruLevel--;   // 08/04/1994 James
        if ( !ArrStru && StruLevel > 0 ) arrsz = 1;    // 08/09/1994 James
        strcpy( indent, temp );
        sprintf( temp, " %s} %s;\r\n", indent, ptr );
        DisplayStr(temp);
//      free(tmpStruct);   // 08/09/1994 James
        if ( !ArrStru ) free(tmpStruct);
        break;
     case ARRAY:
        memset( dim, NULL, sizeof(dim) );
        for (i=0, new=1; i < arrInfo.dim; i++) {
           // 06/08/1994 James, 06/14/1994
           if (typeInfo.scope && !ptr_arr) { arrInfo.size[i] /= 4; ptr_arr = TRUE; }
           // 06/09/1994 James
           if ( arrInfo.subType == SINGLE && (i == arrInfo.dim-1) )
            arrInfo.size[i] /= 32;
           if ( arrInfo.subType == DOUBLE && (i == arrInfo.dim-1) )
            arrInfo.size[i] /= 64;
           sprintf(dim, "%s[%d]", dim, arrInfo.size[i]);
           new *= arrInfo.size[i];
        }
        // 06/07/1994 James
//      if ( StruLevel > 0 || arrInfo.subType == STRUCTURE ) arrsz = new;
        // 06/16/1994 James Wang
        if ( StruLevel > 0 || arrInfo.subType == STRUCTURE || arrInfo.subType == UNION ) arrsz = new;
        sprintf( temp," %s%s %s%s%s", indent,
                      typeArr[arrInfo.subType], ptr, name, dim );
        DisplayStr( temp );
        sprintf(temp, " %s", indent);
        // 06/16/1994 James Wang
//      if (arrInfo.dim > 1 || arrInfo.subType == STRUCTURE)
        if (arrInfo.dim > 1 || arrInfo.subType == STRUCTURE || arrInfo.subType == UNION)
           DisplayStr("\r\n");
        u32 = addr;
        // 06/16/1994 James Wang
//      len = (typeInfo.type == STRUCTURE) ? typeInfo.len / new / 8 :
        len = (typeInfo.type == STRUCTURE || typeInfo.type == UNION) ? typeInfo.len / new / 8 :
                                             typeInfo.len / 8;
        if (typeInfo.scope)  // 06/14/1994 James Wang
             len = 4;
        ProcessArray( &u32, 0, temp, name, typeInfo, arrInfo, struInfo, len );
        break;
     default :
       if ( typeInfo.type >= UNCHAR && typeInfo.type <= LDOUBLE) {
           if ( GetContentStr(FALSE, FALSE, addr, typeInfo.type, typeInfo.len,
                str)==OK){
              if (typeInfo.scope) sprintf(temp, "%s%s\r\n", temp, str );
              else sprintf(temp, " %s%s %s = %s\r\n", indent,
                                 typeArr[typeInfo.type], name, str );
           }
           else if (typeInfo.scope) {
              tmpPtr = strchr(temp, ':');
              *tmpPtr = '?';
              strcat(temp, "\r\n");
           }
           else {
              free(buffer);
              return(FAIL);
           }
        }
        else sprintf( temp, " %s %s\r\n", typeArr[0], name );
        DisplayStr(temp);
        break;
   }
   free(buffer);
   return(OK);
}


/**************************************************************************
**
** Name : ProcessArray()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE ProcessArray( U32 *addr, U16 dim, STRING temp, STRING name,
             TYPE_INFO tmpType, ARRAY_INFO tmpArr, STRUCT_INFO tmpSt, U32 len)
{
 U8 str[100], *buf, ptr[60], indent[NAMELEN];
 U16 i;
 U16 j; // 08/08/1994 James

   if (dim < tmpArr.dim ) {
      strcpy( str, temp );
      if ((buf = malloc(tmpArr.size[dim]*50)) == NULL) return(FAIL);
      buf[0] = NULL;
      for (i=0; i < tmpArr.size[dim]; i++) {
         if (dim < tmpArr.dim-1 ) {
            sprintf(temp, "%s[%d]",  str, i);
            ProcessArray( addr, dim+1, temp, name, tmpType, tmpArr, tmpSt, len );
         }
         else {
            // 06/16/1994 James Wang
//          if ( tmpArr.subType == STRUCTURE ) {
            if ( tmpArr.subType == STRUCTURE || tmpArr.subType == UNION) {
               ArrStru = 1; // 08/09/1994
               strcpy( indent, str+1 );
               sprintf( ptr, "%s%s[%d]", name, indent, i );
               indent[0] = NULL;
               // 06/16/1994 James Wang
//             typeInfo.type = STRUCTURE;
               typeInfo.type = tmpArr.subType;
               typeInfo.len = len * 8;
               PrintVar( *addr, ptr, indent );
               memcpy( &typeInfo, &tmpType, sizeof( TYPE_INFO ) );
               memcpy( &arrInfo, &tmpArr, sizeof( ARRAY_INFO ) );
               memcpy( &struInfo, &tmpSt, sizeof( STRUCT_INFO ) );
               // 08/08/1994 James for array with structure.
               for (j=0; j<tmpSt.itemCnt; j++)
                  strcpy( struInfo.itemName[j], tmpSt.itemName[j] );
            }
            else {
               if ( i == 0 ) {
                  if (tmpArr.dim > 1) sprintf( buf, "%s[]={ ", str );
                  else strcpy( buf, "={ " );
               }
               if (GetContentStr( TRUE, FALSE, *addr, tmpArr.subType,
                    (U32)scalarLen[tmpArr.subType], ptr) == FAIL) {
                  free(buf);
                  return(FAIL);
               }
               if ( i == tmpArr.size[dim] - 1 )
                  sprintf( buf, "%s%s }\r\n", buf, ptr );
               else sprintf( buf, "%s%s, ", buf, ptr );
            }
            // 06/16/1994 James Wang
//          if ( arrsz && tmpArr.subType == STRUCTURE )
            if ( arrsz && (tmpArr.subType == STRUCTURE || tmpArr.subType == UNION) )
               *addr += len/arrsz;  else // 06/07/1994 James
            *addr += len;
         }
      }
      ArrStru = 0;  // 08/09/1994 James
      DisplayStr( buf );
      if (buf) free(buf);
      return(OK);
   }
   return(FAIL);
}
/***************************************************************************
**
**  Name: GetSourceLinebyAddr()
**
**  Description:
**
**
**  Input:
**
**  Output:
**
**  Notes :
**
****************************************************************************/
PUBLIC RETCODE GetSourceLinebyAddr(U32 addr, U8 *sourceLine)
{
 U16 lineNo, lineCnt=1;
 S8 *tmpBuf, *ptrStart, *ptrEnd, tmpStr[256], *fileEnd;
 S16 retCnt, len, fullLen, curMod;
 S32 filePos=0;
 U8 modName[40];
 U32 dummy;

   if (IdentifyCurrentModule(TRUE,addr,&curMod,tmpStr,&dummy, &dummy)== OK) {
      if (Addr2LinNum( addr, &lineNo ) != OK) return(FAIL);
      if (InitSourceEnvironment( curMod, tmpStr ) == FAIL) return(FAIL);
      if (filePtr == NULL) return(FAIL);
      if ( curModule.modNum == fileBuf.modNum && lineNo >= fileBuf.startLine &&
           lineNo < fileBuf.startLine + fileBuf.size ) {
         strcpy( sourceLine, fileBuf.line[lineNo - fileBuf.startLine] );
         return(OK);
      }
      if ((tmpBuf = malloc( BUFSIZE )) == NULL) return(FAIL);
      retCnt = 1+BUFSIZE;
      while ( retCnt >= BUFSIZE ) {
         ptrStart = tmpBuf;
         if ( fseek( filePtr, filePos, SEEK_SET )  ||
             ( (retCnt = fread((VOID *)tmpBuf, sizeof(S8), BUFSIZE, filePtr ))
                         < BUFSIZE && ferror(filePtr) ) ) {
            free( tmpBuf );
            return(FAIL);
         }
         while ( (ptrStart < tmpBuf + retCnt ) &&
                 (ptrEnd = strstr(ptrStart, "\r\n")) != NULL ) {
            if (lineCnt == lineNo) {
               fullLen = ptrEnd-ptrStart;
               len = (fullLen >= 79) ? 79 : fullLen;
               StrmnCopy( tmpStr, ptrStart, 0, fullLen );
               if ((fileEnd=strchr( tmpStr, '\x1A')) != NULL) *fileEnd = '\0';
               strncpy( sourceLine, tmpStr, len );
               *(sourceLine+len) = '\0';
               GetRidofTabs( sourceLine );
               return(OK);
            }
            ptrStart = ptrEnd+2;
            lineCnt++;
         }
         filePos +=  (S32)(ptrStart - tmpBuf);
      }
   }
   return(FAIL);
}

/***************************************************************************
**
**  Name: Addr2SourceLine()
**
**  Description: for searching C source
**
**
**  Input:
**
**  Output:
**
**  Return:
**
****************************************************************************/
PUBLIC  RETCODE Addr2SourceLine(U32 addr, U8 *buffer)
{
U8  fname[40];
S16 curMod;
U16 linenum;
U32 dummy;
static char modSGN[3] = "%%";

   if (IdentifyCurrentModule(TRUE,addr,&curMod,fname,&dummy, &dummy)!= OK)
      return(FAIL);
//   if (InitSourceEnvironment( curMod, fname ) == FAIL) return(FAIL);
   // 02/22/95 mismatched source.
   if (InitSourceEnvironment( curMod, fname ) == FAIL) return(-2);
   if (Addr2LinNum( addr, &linenum ) != OK) return(FAIL);
   if (FillFileBuf( linenum ) == FAIL) return(FAIL);
   strupr(fname);
   sprintf(buffer, "%s%s#%d  %s", modSGN, fname, linenum, fileBuf.line[0]);
   buffer[77] = '\0';
   return(OK);

}
/***************************************************************************
**
**  Name: Addr2Block()
**
**  Description: Is on block header, tail or else.
**
**  Input:   address from trace buffer
**
**  Output:
**           Message: I   = Module name.
**                    II  = Block name.
**                    III = addr.
**
**  Return:
**           0: Not any block in module ( Null Module or Assembly Code )
**           1: Block begin.
**           2: Block end
**           3: Block middle
**          -1: Can not locate in module
**
****************************************************************************/
PUBLIC  RETCODE Addr2Block(U32 addr, U8 *buffer)
{
U32 startAddr, endAddr, blkPos;
S16 i, j, k, len, blkCnt, act;
BLOCK_INFO *tmpBlock;    // pointer to block info. (for mem. alloc. use)
static char modSGN[3] = "%%", blkSGN[3] = "%";

   if (SymLoaded != OK) return(0);
   if (neverswapmodule)  act = modcnt;
   else {
      act = NO_MODULE;
      swap_module(0);
   }
   for (j=0; j < modcnt; j += act) {
      for (i = 0; i < act; i++) {
         if ( addr >= ADDR2ABS(gblmod[i].modStart)  &&
              addr <= ADDR2ABS(gblmod[i].modEnd ) ) {
            blkPos = gblmod[i].blkStartPos;
            blkCnt = gblmod[i].blkCnt;
            if (blkCnt == 0) {
                  memset(buffer, NULL, sizeof(buffer));
                  sprintf( buffer, "Address:%05lX  %s%s", addr,
                        modSGN, strupr(gblmod[i+j].mod_name) );
                  return (0);
               }
            len = blkCnt * sizeof(BLOCK_INFO);
            if ((tmpBlock = (BLOCK_INFO *)malloc(len)) == NULL) return(FAIL);
            lseek( fdsy, blkPos, SEEK_SET );
            read(fdsy, (char *)tmpBlock, len );
            for (k = 0; k < blkCnt; k++) {
               startAddr = ADDR2ABS( tmpBlock[k].startAddr );
               endAddr = ADDR2ABS( tmpBlock[k].endAddr );
               if ( addr >= startAddr && addr <= endAddr ) {
                  memset(buffer, NULL, sizeof(buffer));
                  sprintf( buffer, "Address:%05lX  %s%s%s%s()", addr, modSGN,
                        strupr(gblmod[i+j].mod_name), blkSGN,
                        strupr(tmpBlock[k].name) );
                  free(tmpBlock);
                  if ( addr == startAddr )
                     return (1);
                  else  if ( addr == endAddr )
                           return (2);
                        else
                           return (3);
               }
            }
            free(tmpBlock);
            return (-1);
         }
      }
      if (!neverswapmodule) swap_module(gblmod[act-1].mod_inx + 1);
   }
   return (-1);
}
/******************************* End of File ******************************/
