/***************************************************************************
**
** File name : sub86.c
**
**
**
** Changing :
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


/***************************************************************************
**

**    Include files
**
***************************************************************************/
#include <string.h>  //

#include <conio.h>
#include <time.h>
#include <ctype.h>

#ifndef _SD_ABI_EXT_
#include "sdabiext.h"
#endif

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG86_DEFINE_
#include "reg86.h"
#endif

#ifndef _ABI_GLOBAL_
#include "abiglbs.h"
#endif

U16 portAddr, portStatus;
int NECflag;
/**************************************************************************
**
** Local define
**
***************************************************************************/

#define inportb(a)           inp(a)
#define outportb(a,b)        outp(a,b)
#define HighByte(x)          ((U8)((U16)(x) >> 8))
#define LowByte(x)           ((U8)(x))

#define   RV_RDY         1   /* status of receive ready is 00000001 */
#define   SD_RDY         2   /* status of send ready is    00000010 */
#define OK 0
#define HAND_SHAKE 0x3
#define NULL 0
#define CR 0xd
#define CTRL_C 0x3

/**************************************************************************
**
** Local variables
**
***************************************************************************/
#define IO_LOOP   20000
long    baud_tbl[11] = {110, 150, 300, 600, 1200, 2400, 4800, 9600, 19200,
			 38400, 57600};
#define COM_IBM 2

/**************************************************************************
**
** Externals
**
**************************************************************************/
extern int targetCPU, fwVersion;
extern U8 Bit_N[]={2,6,9,10};
extern U16 P_DATA, P_STATUS, PORT;

extern U8 **ctlName;  //added by frank, 4/14/1994
extern S16 flagTotal; //added by frank, 4/14/1994
extern int RS232_COM;
extern int baud;
extern DisplayLinkMsg(int row, char *buff);

extern int open_pcport();
extern int write_pcport(char *);
extern InitFlag; //7/08/94, Frank
extern U8 lineBuf[512];
/**************************************************************************
**
** Functions Prototype
**
**************************************************************************/
set_EV5();
SetVectMem(unsigned long addr, unsigned char *buffer, int i);
int receiveB();
receiveWait(U16 waitSec);
unsigned long rx_long();
rx_byte();
start_up();
check_error(char *buff);
check_KB();
send_long(unsigned long addr);
send_csip(unsigned long addr);
send_word(unsigned int addr);
send_byte(unsigned char d);
sendB(U8 txData);
send_str2(char *str);
send_ESC();
sendWait(U8 txData);
send_CR_wait(int c);
send_str_wait_CR(char *str);
send_str(char *str);
send(char txc);
TX_DATAP(char txc);
RX_DATAP();
TX_DAT(char txc);
RX_DAT();
STATUS emuGetID(U8 *ID_Info);
STATUS emuGetWait(U16 *count);
STATUS emuSetWait(U16 count);
STATUS emuGetVerify(U16 *verifyFlag);
STATUS emuSetVerify(U16 verifyFlag);
STATUS emuGetSync(U16 *sync);
STATUS emuSetSync(U16 syncFlag);
STATUS emuGetMode();
STATUS emuControl();
//STATUS emuSetControl();
STATUS emuGetReady(U16 *readyFlag);
STATUS emuSetReady(U16 readyFlag);
STATUS emuGetAccessSize(U16 *sizeFlag);
STATUS emuSetAccessSize(U16 sizeFlag);

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : sendB()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int sendB(U8 txData)
{
U16 i;

   for ( i = 0; i < IO_LOOP; i++ )
      if(inportb(portStatus) & SD_RDY) {
         outportb(portAddr,txData);
         return(GOOD);
      }
   return(-1);
}        /* end of sendB() */

/**************************************************************************
**
** Name :  receiveWait()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
receiveWait(U16 waitSec)
{
U16 i;
int rxData;
time_t startTime,currentTime;

   time(&startTime);
   while (1) {
     for ( i = 0; i < IO_LOOP; i++ )
        if(inportb(portStatus) & RV_RDY) {
           rxData = inportb(portAddr);
           return(rxData);
        }
     chk_hlt();
     time(&currentTime);
     if ((currentTime - startTime) > waitSec) return(-1);
   }
}        /* end of receiveWait() */

/**************************************************************************
**
** Name : sendWait()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int sendWait(U8 txData)
{
U16 i;

   while(1) {
      for ( i = 0; i < IO_LOOP; i++ )
         if(inportb(portStatus) & SD_RDY) {
            outportb(portAddr,txData);
            return(GOOD);
         }
      chk_hlt();
   }
} /* end of sendWait() */

/**************************************************************************
**
** Name : receiveB()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
int receiveB()
{
int rxData;
U16 i;

   for ( i = 0; i < IO_LOOP; i++ ){
      rxData = upRX_DATA();
      if (rxData > 0) return(rxData);
   }
   return(-1);
} /* end of receiveB() */

/**************************************************************************
**
** Name : emuSetAccessSize
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

STATUS emuSetAccessSize(U16 sizeFlag)
{
	send_str2("SI ");
	if (!sizeFlag) send('B'); else send('W');
	send_CR_wait(HAND_SHAKE);
}

/**************************************************************************
**
** Name : emuGetAccessSize
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

STATUS emuGetAccessSize(U16 *sizeFlag)
{
char c, *ptr;

	send_str2("SI");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf, "Word") != NULL) *sizeFlag=1;else *sizeFlag=0;
}

/**************************************************************************
**
** Name :   emuSetReady
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

STATUS emuSetReady(U16 readyFlag)
{
	send_str2("REA ");
	if (readyFlag == 1) send('E'); else send('I');
	send_CR_wait(HAND_SHAKE);
}

/**************************************************************************
**
** Name : emuGetReady
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

STATUS emuGetReady(U16 *readyFlag)
{
char c, *ptr;

	*readyFlag = 0;
	send_str2("REA");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf, "externally") != NULL) *readyFlag=1;
}

/**************************************************************************
**
** Name :  emuControl
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

STATUS emuControl()
{
char *ptr, c;

		send_str2(lineBuf);
        send_CR_wait(CR);

		while(1){
		   ptr = tx_buf;
		   while ( (c=receive()) != CR && c != HAND_SHAKE)
			   if ( c != '>' ) *ptr++ = c;
		   *ptr = NULL;
		   DisplayStr(tx_buf);
		   if (c == HAND_SHAKE) break;
		}

	return(OK);
}

/**************************************************************************
**
** Name :  emuGetMode
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetMode()
{
    char c, *ptr;

	send_str2("MO");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE)
	  if ( c != '>') *ptr++ = c;
	*ptr = NULL;

	if ( strstr(tx_buf, "V20/V30") != NULL ) NECflag = 1;
        else NECflag = 0;   // added by Chen, 07/23/94
	return(OK);
}

STATUS emuSetMode(U16 modeFlag)
{
char c, *ptr;

        send_str2("MO ");
        if(modeFlag) send('Q');
        else send('C');
		send_CR_wait(CR);
		ptr = tx_buf;
		while ( (c=receive()) != HAND_SHAKE)
		   if (c != '>') *ptr++ = c;
		DisplayStr(tx_buf);
        return(OK);
}

STATUS emuSetMode2(U16 flag1)
{
char c, *ptr;

        if (flag1 == 0) NECflag = 0;
        else NECflag = 1;
        send_str2("MO ");
        if (flag1 == 0) send('I');
        else send('N');
		send_CR_wait(CR);

		ptr = tx_buf;
		while ( (c=receive()) != HAND_SHAKE)
		   if (c != '>') *ptr++ = c;
		DisplayStr(tx_buf);
        return(OK);
}

/**************************************************************************
**
** Name :  emuSetSync
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetSync(U16 syncFlag)
{
	send_str2("SY ");
	if (syncFlag&2) send_str2("OU ");else send_str2("I ");
        if (syncFlag&1) send_str2("ON");else send_str2("OF");
	send_CR_wait(HAND_SHAKE);
}

/**************************************************************************
**
** Name : emuGetSync
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetSync(U16 *sync)
{
char c, *ptr;

	*sync=0;
	send_str2("SY");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != CR) *ptr++ = c;
        *ptr = NULL;
        if (strstr(tx_buf,"ON") != NULL) *sync = 1;
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr = NULL;
	if (strstr(tx_buf,"ON") != NULL) *sync = *sync | 2;
}

/**************************************************************************
**
** Name : emuSetVerify
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetVerify(U16 verifyFlag)
{
	if (verifyFlag) send_str("V O");
	else send_str("V OF");
	return(OK);
}

/**************************************************************************
**
** Name :  emuGetVerify
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetVerify(U16 *verifyFlag)
{
char c, *ptr;

	send('V');
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	if (strstr(tx_buf, "OFF") != NULL) *verifyFlag = 0;
	else *verifyFlag = 1;
	return(OK);
}

/**************************************************************************
**
** Name :  emuSetWait
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuSetWait(U16 count)
{
	send_str2("WA ");
        send(hex[count]);
	send_CR_wait(HAND_SHAKE);
}

/**************************************************************************
**
** Name :  emuGetWait
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetWait(U16 *count)
{
char c, *ptr;

	send_str2("WA");
	send_CR_wait(CR);
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
	*ptr = NULL;
	ptr = tx_buf;
	while (*ptr++ != '(');
	sscanf(ptr, "%x", &c);
	*count = c;
}

/**************************************************************************
**
** Name :  emuGetID
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS emuGetID(U8 *ID_Info)
{
	ID_Info[0] = (U8)targetCPU;
	ID_Info[2] = (U8)fwVersion;
}

/**************************************************************************
**
** Name :  set_EV5
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
set_EV5()
{
     event_cmd[2]='5';
     send_str2(event_cmd);
     send_csip(VectAdr);
     send_CR_wait(HAND_SHAKE);
}

/**************************************************************************
**
** Name :  SetVectMem
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
SetVectMem(unsigned long addr, unsigned char *buffer, int i)
{
int j;
char c;

        send('B');
        send(' ');
        send_csip(addr);
        for (j=0;j < i;j++) {
                send(' ');
                send_byte(*buffer++);
        }
        send_CR_wait(CR); /* send CR and skip the command line */
        for (;;) {
                c=receive();
                if (c == 't') {
                        while (receive() != HAND_SHAKE);
                        noRAM=1;
                        return;
                }
                if (c == HAND_SHAKE) {
                        noRAM=0;
                        return;
                }
        }
}

/**************************************************************************
**
** Name : check_error
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
check_error(char *buff)
{
   char *ptr;
   U16 addrHi, addrLo;

        if (strstr(buff, "halted") != NULL) return(ICE_MICE_HALT);
        if (strstr(buff, "Guarded") != NULL) return(ICE_MEM_GUARD);
        if (strstr(buff, "write failure") != NULL) {
              if ( (ptr=strrchr(buff, ':')) ) {  //Frank , 5/23/1994
                  sscanf(ptr-4, "%X:%X", &addrHi,&addrLo);
                  ret_addr1 = (((U32) addrHi)<<16)+addrLo;
              }
              return(ICE_ERROR_WRITE);
        }
        if (strstr(buff, "protected") != NULL) return(ICE_MEM_PROTECT);
        if (strstr(buff, "can't step") != NULL) return(ICE_STEP_ERROR);
        if (strstr(buff, "request") != NULL) return(ICE_BUS_REQUEST);
        if (strstr(buff, "overflow") != NULL) return(ICE_ABS_OVERFLOW);
        if (strstr(buff, "error") != NULL) return( ICE_ERROR_COMMAND );
        return(OK);
}


/**************************************************************************
**
** Name :  send_long
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_long(unsigned long addr)
{
    char c;
    int i;

    if (!downLoadMode && addr < 2) {
        c=addr&0xf;
        send(hex[c]);
        return;
    }
    for (i=3; i >= 0; i--) {
        c=(addr>>i*4)&0xf;
        send(hex[c]);
    }
}


/**************************************************************************
**
** Name : send_csip
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_csip(unsigned long addr)
{
        send_long(addr >> 16);
        send(':');
        send_long(addr);
}


/**************************************************************************
**
** Name : send_word
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_word(unsigned int addr)
{
char c;
int i;

        for (i=3; i >= 0; i--) {
                c=(addr>>i*4)&0xf;
                send(hex[c]);
        }
}


/**************************************************************************
**
** Name :  send_byte
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_byte(unsigned char d)
{
char c;

      c=(d>>4)&0xf;
      send(hex[c]);
      c=d&0xf;
      send(hex[c]);
}

/**************************************************************************
**
** Name :  rx_long
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
unsigned long rx_long()
{
int c;
unsigned long l;

        l=0;
        while (receive() != ' ');
        for (;;) {
                c=receive();
                if (c == HAND_SHAKE) break;
                if (isxdigit(c)) {
                        c=asc__h(c);
                        l = (l<<4) + c;
                }
        }
        return(l);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
rx_byte()
{
char c, i, j;

        while ((c=receive()) <= 0);
        i=asc__h(c);    // get low 4-bit from ASCII charater
        while ((c=receive()) <= 0);
        j=asc__h(c);
        i = (i<<4)+j;
        return(i);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_str2(char *str)
{
char c, *ptr;

        if ( ! (*str)) return;
        ptr=str;
        while (c = *ptr++) send(c);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_ESC()
{
    // Added by Chen, 02/16/95
    // Cannot send ESC to FW on V20 module.
//    if ( MICE >= V20MAX && MICE <= V30MIN ) {
//        return;
//    }

        send(ESC);
        while(receive() != HAND_SHAKE);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_CR_wait(int c)
{
        send(CR);
        while(receive() != c);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_str_wait_CR(char *str)
{
char c;
        if (! (*str)) return;
        while (c=*str++) {
                send(c);
                while (receive() != c);
        }
        send(CR);
        while (receive() != CR);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
check_KB()
{
        if(chk_kb() == -1) return(getch());
        else return(NULL);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send_str(char *str)
{
char c;
        if (!(*str )) return;
	while (c=*str++) {
		send(c);
		while (receive() != c);
	}
	send(CR);
	while (receive() != HAND_SHAKE);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
start_up()
{
int i, j;
char c, *ptr;
extern const int nLinkStartLine;  // declared in INITOLD.C by Chen, 07/13/94

    portAddr = P_DATA;
    portStatus = P_DATA+1;
	if (!PORT) {
                open_pcport();
	}
        send(CR);
	pause_delay(1);
	if (receiveB() == -1) { /* nothing echo */
		for (;;) {
                        if ( InitFlag == 1 ) send('S');
                        else send('M');
			send(CR);
			pause_delay(1);
			if (receiveB() > 0) break;
		}
                ptr = tx_buf;
                j = nLinkStartLine; // changed by Chen, 07/13/94
                while ((c=receive()) != HAND_SHAKE){
                      if (c == CR){
                             *--ptr = NULL;
                             DisplayLinkMsg(j, tx_buf);
                             ptr = tx_buf;
                             j++;
                       } else *ptr++ = c;
                }
		while (receiveB() != -1); /* flush the data in MICE buffer */
	} else {
		while (receiveB() != HAND_SHAKE);
		while (receiveB() != -1); /* flush the data in MICE buffer */
	}
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
send(char txc)
{
	int c, i;
	while(1) {
		if ((c=TX_DATAP(txc)) >= 0) return;
		if (chk_kb() == -1) {
			c = getch();
			if (c == CTRL_C) exit(1);
		}
	}
}


/**************************************************************************
**
** Name : TX_DATAP
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
TX_DATAP(char txc)
{
   int ret;

      if (PORT) return(TX_DAT(txc));
    ret= write_pcport(&txc);
//    if (ret == 1) return(ret);
    if (ret >= 0) return (1);
	else return(-1);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RX_DATAP()
{
//	if (PORT) return(RX_DAT());
//	else return(rx_data());
	return(RX_DAT());
}


/**************************************************************************
**
** Name :    TX_DAT
**
** Function : send a character to firmWare.
**
** Notes: the most basic routine except inp() and outp()
**
**************************************************************************/
TX_DAT(char txc)
{
	if(inp(portStatus) & SD_RDY) {
		outp(portAddr,txc);
		return(1);
	} else return(-1);
}

/**************************************************************************
**
** Name : RX_DAT
**
** Function:  receive a character from firmWare
**
** Notes: the most basic routine except inp() and outp()
**
**************************************************************************/
RX_DAT()
{
        if(inp(portStatus) & RV_RDY) return(inp(portAddr) & 0x7f);
	else return(-1);
}

/**************************** End of File **********************************/
