/***************************************************************************
**
** File name : swbkpt.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/22/1992 By Cheerson
**     0. Delete all "send_ESC()" calling in this file.
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "reg86.h"
#include  "database.h"

#ifndef _SD_ABI_DEF_
#include  "sdabidef.h"
#endif

#ifndef _ABI_FUNC_
#include  "abifunc.h"
#endif

#ifndef _LINUMDEF_
#include  "linumdef.h"
#endif

#include "sdabiext.h"
/**************************************************************************
**
** Local define
**
***************************************************************************/
LOCAL char *OutputPtr = NULL;
LOCAL int   OutputRows = 16, RowCount = 0;
/**************************************************************************
**
** Local variables
**
***************************************************************************/

extern char tx_buf2[];
int tick_temp;

// static char EV_BUF[80];
static char EV_BUF[512];    // Chen 06/07/94
static char PCstr[10];
static struct pcstatus mypc;

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int LAM2;
extern unsigned long VectAdr;
extern int errorCode;
EXTERN CURRENT_MODULE curModule;
extern struct patch_strct
{
   int flag;
   U32 src_ent1;
   U32 src_ent2;
   U32 start;
   U32 dest;
} patch;

extern S8 langMode;    // 06/07/1994 James Wang
/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : BackCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
BackCmd()
{
#define STRLEN 20
U32 curPC;
S8 procName[80], prevName[80], temp[80], *para, *prevPara, *BUFF;
U32 retAddr, dummy;
U32 retFP, curFP, curSP;
U16 offset, i, len;
U8 retByte, flag= FALSE;

   VPOut = COMVP;
   emuGetReg(I86_REG, REG_PC, &curPC);
   emuGetReg(I86_REG, REG_FP, &curFP);
   emuGetReg(I86_REG, REG_SP, &curSP); // 07/15/1994 James

   if ((para=malloc(256)) == NULL || (prevPara=malloc(256)) == NULL ||
       (BUFF=malloc(512)) == NULL ) {
      if (para) free(para);
      if (prevPara) free(prevPara);
      if (BUFF) free(BUFF);
      prn_ferr(45);
      return(OK);
   }
   for (i=0;;i++) {
      para[0] = NULL;
      if ( GetStackInfo(curPC,curFP,curSP,procName,&retAddr,&retFP,&offset,&retByte,
           para) == FAIL ) {
         procName[0] = NULL;
         flag=TRUE;
         if (IdentifyCurrentModule(FALSE, curPC, &offset, BUFF,&retAddr, &dummy)
             == OK) {
            offset = ADDR2ABS(curPC)-ADDR2ABS(retAddr);
            len = 0; // don't get type
            if (GetSymByAddr( 1, retAddr, procName, &len) != OK) break;
         }
         else break;
      }

      // if compiler mode was samall, the status of stack may be abnomal ! 08/15/1994 James
      if ( !strcmp(prevName, procName) )  break;

      ConvCplusplusName( procName );
      sprintf( temp, "%s+%04X:", procName,offset );
      len = strlen(temp);
      if (i) {
        if (len > STRLEN)
           sprintf(BUFF," %d: %04X:%04X  %s %s%s\r\n",i,(U16)(curPC>>16),
                        (U16)curPC,temp,prevName, prevPara);
        else
           sprintf(BUFF," %d: %04X:%04X  %-20s %s%s\r\n",i,(U16)(curPC>>16),
                        (U16)curPC,temp,prevName, prevPara);
      }
      else {
         sprintf(BUFF," %d: %04X:%04X  %s+%04X:\n\r",i,(U16)(curPC>>16),
                      (U16)curPC,procName,offset);
      }
      DisplayStr(BUFF);
      if (chk_hlt() == ESC) break;
      if (flag) break;

//    Back command should stop after meeting main(); it's not enough just
//    checking stack information, because we don't know what is stored in
//    the stack beforehand(it might be a legitimate address.) Literally
//    checking "main" has to be done. 4/11/94 Joyce

//     if (strstr(procName,"main")) break; //Frank 6/1/1994

      strcpy(prevName, procName);
      strcpy(prevPara, para);
      curPC = retAddr - retByte -1;
      curFP = retFP;
   }
   free(BUFF);
   free(para);
   free(prevPara);
   return(OK);
}
/**************************************************************************
**
** Name : BreakpointCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

BreakpointCmd(U32 addr, int type, U16 count)
{
char temp[80], *ptr;
unsigned long addr1;
int i, len;

   VPOut = COMVP;
   if (type == -1) {   /* display breakpoint information */
      if (noRAM) DisplayStr(" S/W breakpoint toggle is OFF.\r\n");
      else {
         DisplayStr(" S/W breakpoint toggle is ON.       ");
         sprintf(EV_BUF," EV%d will be used for S/W breakpoint.\r\n",LAM2+5);
         DisplayStr(EV_BUF);
      }
      if (!noRAM) {
         DisplayStr(" Trap vector is at location 0:0CH.  ");
         sprintf(EV_BUF," Handler routine is at location %lX:%lX.\n",
                (VectAdr>>16)&0xffff, VectAdr&0xffff);
         DisplayStr(EV_BUF);
      }
      SetPutsBuf(NULL, 16, 0);
      EV_BUF[0] = '\0';
      for (i = 0; i < BreakNumber; i++) {
         if (SwBreak[i].sym[0] != '\0')
            sprintf(temp," %3X. %s  count=%X", i+1,
                    SwBreak[i].sym, SwBreak[i].count);
         else
            sprintf(temp," %3X. %04lX:%04lX  count=%X", i+1,
                   (SwBreak[i].address & 0xFFFF0000L) >> 16,
                    SwBreak[i].address & 0x0000FFFFL, SwBreak[i].count);
         if (strlen(temp) <= 38) {
            len = strlen(temp);
            memset(&temp[len], ' ', 38 - len);
            temp[38] = '\0';
         }
         else {   /* too long */
            if (EV_BUF[0] != '\0')
               if (PutsMore(EV_BUF) == ESC)  break;
            strcpy(EV_BUF, temp);
            temp[0] = '\0';
         }
         if (EV_BUF[0] != '\0' || i == BreakNumber-1) {
            strcat(EV_BUF, temp);
            if (PutsMore(EV_BUF) == ESC)  break;
            EV_BUF[0] = '\0';
         }
         else  strcpy(EV_BUF, temp);
      }  /* end of for */
      return (TRUE);
   }  /* end of if (type == -1) */

   if (noRAM) {
      DisplayStr(" S/W breakpoint is disabled!\r\n");
      return(TRUE);
   }
   addr1 = addr;
   if ((i=emuSetBrk(addr)) < 0) {
      if (i == BAD_IN) DisplayStr(" S/W breakpoint is already set!\r\n");
      else             DisplayStr(" No more breakpoint can be set!\r\n");
      return(TRUE);
   }
   SwBreak[i].count = count;
   SwBreak[i].tmp_count = 0;
   strncpy(SwBreak[i].sym, addr_form.sym, sizeof(SwBreak[i].sym) - 1);
   SwBreak[i].sym[sizeof(SwBreak[i].sym)-1] = '\0';
   BreakNumber++;

// adr2str(addr1,PCstr);
// MarkBKPTinCodeVP('*');
   i = 1;
   if (addr_form.sym[0] == '%' ) {
      if ((ptr = strchr( &addr_form.sym[2], '#')) == NULL)
         ptr = strchr( &addr_form.sym[2], '%');
      if (ptr) {
         StrmnCopy( temp, addr_form.sym, 2, ptr - addr_form.sym - 2 );
         if (stricmp( curModule.modName, temp)) i = 0;
      }
   }
   if (i) MarkBKPTinCodeVP(addr1, '*');
   MarkPC(CurrentPC);
   return (TRUE);
}

/**************************************************************************
**
** Name : GoCmd(run)
**
** Function
**
**     Input  : run flag to indicate free-running(GoRun in MICE)
**            or run with breakpoint care.
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  NORMAL_RUN, FREE_RUN (FLY_RUN) start from this point  */
GoCmd(int run, long interval, int *frank)
{
int i,status, inPatch=0;
unsigned long adr2hex();
unsigned long l, addr2;
U8 goEndFlag;
int iBpFlag, iBpFlag2;  //Frank
char tmp_buf[256];  // James Wang 06/04/1994
U32  absaddr;
int  ItemNo, ii;
static U8 symSGN = '%';

   *frank = 0;
   break_id = 0;
   tick_temp = tick_count;
   VPOut = COMVP;
   if (emuGetCpuStatus(&goEndFlag) == CPU_FLY)
          return(ICE_INVALID_FLY_COMMAND);
   if (!noRAM && BreakNumber && (run != FREE_RUN)) {
        if (bp_record[1].defined){
             if (!LAM2)
                 DisplayStr(" Current setting of EV5 is masked, due to S/W breakpoint is set\n\r");
             else
                 DisplayStr(" Current setting of EV7 is masked, due to S/W breakpoint is set\n\r");
        }
        iBpFlag2 = init_sw();
   }

   if (patch.flag && bp_record[0].defined && (run != FREE_RUN)){
       if (!LAM2)
           DisplayStr(" Current setting of EV4 is masked, due to patching function\n\r");
       else
           DisplayStr(" Current setting of EV6 is masked, due to patching function\n\r");
   }
   if (patch.flag && run != FREE_RUN)
        iBpFlag = emuSetTempBP(4+LAM2, patch.src_ent1);

   if (existTraceBoard == ON) DisplayStr(" Trace in progress...\r\n");
   else DisplayStr(" Program is running...\r\n");


   for (;;) { //  NORMAL_RUN, FLY_RUN, FREE_RUN start from this point
       status = emuRun(run == MONITOR_RUN ? FLY_RUN : run);
#ifndef MICEPACK
       if (run == FREE_RUN)   return(OK);
       if ( strstr(tx_buf2, "still running")) {
          *frank = 1;
          if (patch.flag && run != FREE_RUN)
                  emuRetTempBP(iBpFlag, 4+LAM2);
          if (!noRAM && BreakNumber && (run != FREE_RUN))
                  emuRetTempBP(iBpFlag2, LAM2+5);
          DisplayStr(" Emulation processor is still running... !\n\r");
          return(OK); // tell cmdProcess to break, just like "Go Run"
      }
#endif
       if (status == HALT_USER) break;
       if ((!noRAM) && (BreakNumber) && (break_id == LAM2+5)) {
            GetPC(&mypc);
            l = adr2hex(mypc.addr);
            i = ChkBreak(l);
            if (i == -1) {
                sprintf(EV_BUF," Program broke at unexpected location, PC=%s\r\n", mypc.ascii);
                DisplayStr(EV_BUF);
                errorCode = 0;
                break;
            }
            else {
                if (langMode == HIGH && Addr2SourceLine(l, tmp_buf) == OK) {
                    tmp_buf[45] = '\0'; // cut the tail at long line.
                    sprintf(EV_BUF," SW bkpt is encountered at: %s\r\n",tmp_buf);
                }
                else {
                    absaddr = (U32)((l>>12) & 0x000ffff0) + (U32)(l & 0x0000ffff);
                    for (ii=0; ii<4; ii++)
                        comsym.addr[ii] = (U8) ( (absaddr >> (8 * (3-ii))) & 0x000000FF);
                    comsym.mask = MSK_ABS;
                    if ( AddrToSym(&ItemNo) == FALSE )
                        sprintf(EV_BUF," SW bkpt is encountered at: %s\r\n",mypc.ascii);
                    else
                        sprintf(EV_BUF," SW bkpt is encountered at: %c%s[%s]\r\n",symSGN,comsym.name,mypc.ascii);
                }
    	     DisplayStr(EV_BUF);
            }
            SwBreak[i].tmp_count++;
            if (SwBreak[i].count != SwBreak[i].tmp_count) continue;
            errorCode = 0;
            break;
       }
       else
       if (patch.flag && break_id == LAM2+4) {
            if (chk_hlt() == ESC) {
               emuAbort();
               status=HALT_USER;
               break;
            }
            if (patch.flag == 1) {
               emuSetReg(I86_REG, REG_PC, patch.src_ent2);
               continue;
            }
            if (!inPatch) {
               inPatch = 1;
               emuSetReg(I86_REG, REG_PC, patch.start);
               iBpFlag = emuSetTempBP(LAM2+4, patch.dest);
            }
            else {
               if (patch.flag == 2)
                    emuSetReg(I86_REG, REG_PC, patch.src_ent1);
               else emuSetReg(I86_REG, REG_PC, patch.src_ent2);
               emuStepRange(0L, 0L);
               iBpFlag = emuSetTempBP(LAM2+4, patch.src_ent1);
               inPatch = 0;
            }
            continue;
       }
       if (run == MONITOR_RUN) {
          while (1) {
             if (!CheckInterval(interval)) {
                emuAbort();                  // Halt by user
                DisplayBreak(HALT_USER);
                return(OK); // halted by user
             }
             if (emuGetCpuStatus(&goEndFlag) != CPU_FLY) return(OK);
             if ( wn_isup( VP[REGVP].Ptr ) ) UpdateREGVP();
             if ( wn_isup( VP[DATVP].Ptr ) ) UpdateDATVP();
             if ( wn_isup( VP[CODVP].Ptr ) ) UpdateCODVP(-1);
          }
       }
       if (status) break;
   }

   if (patch.flag && run != FREE_RUN) emuRetTempBP(iBpFlag, 4+LAM2);
   if (!noRAM && BreakNumber && (run != FREE_RUN))
            emuRetTempBP(iBpFlag2, LAM2+5);
   for (i = 0; i < BreakNumber; i++) SwBreak[i].tmp_count = 0;
   if (break_id == LAM2+4 && !patch.flag) errorCode = BKPT1_HALT;
   if (break_id == LAM2+5 && (!BreakNumber || noRAM)) errorCode = BKPT2_HALT;
#ifdef MICEPACK
   if (!reloadFlag) {
       DisplayBreak(status);
       emuGetTraceInfo(&lastBuff, &curCNT0, &curCNT1, &bufNO);
       if (status != CPU_RUN && status != CPU_FLY && existTraceBoard == ON) {
          sprintf(EV_BUF," %x trace buffers are used, current CNT0=%x CNT1=%x\r\n",
                  lastBuff, curCNT0, curCNT1);
          DisplayStr(EV_BUF);
       }
   }
#else
	if (!BreakNumber || 
                ( (break_id != LAM2+4) && (break_id != LAM2+5)
                 && (break_id != LAM2+6)) ){
                  if (strstr(tx_buf2, "halted")){
                      *frank = 1;
                      send_ESC();
                  }
                DisplayStr(tx_buf2);
            }
#endif
   tick_count = 0xffff; //reset tick_count as default value
   return(errorCode);
}        /* End of GoCmd(run) */

/**************************************************************************
**
** Name : CheckBreak(status)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
DisplayBreak(int status) {
static char *breakMsg[]={
   " Target CPU in running state",
   "",
   " Halt by user",
   " Target CPU halted",
   " Target cannot step",
   " Bus request error",
   " Access guard memory",
   " Memory write protected",
   " Program broke, due to trigger condition matched",
   " emulator process pending"
   };

   switch (status) {
      case CPU_FLY :
      case CPU_RUN :
         sprintf(EV_BUF,"%s\r\n",breakMsg[0]);
         DisplayStr(EV_BUF);
         break;
      case HALT_USER :
         sprintf(EV_BUF,"%s\r\n",breakMsg[2]);
         DisplayStr(EV_BUF);
         break;
      case MICE_HALT :
         sprintf(EV_BUF,"%s\r\n",breakMsg[3]);
         DisplayStr(EV_BUF);
         break;
      case STEP_ERROR :
         sprintf(EV_BUF,"%s\r\n",breakMsg[4]);
         DisplayStr(EV_BUF);
         break;
      case BUS_REQUEST :
         sprintf(EV_BUF,"%s\r\n",breakMsg[5]);
         DisplayStr(EV_BUF);
         break;
      case MEM_GUARD  :
         sprintf(EV_BUF,"%s\r\n",breakMsg[6]);
         DisplayStr(EV_BUF);
         break;
      case MEM_PROTECT :
         sprintf(EV_BUF,"%s\r\n",breakMsg[7]);
         DisplayStr(EV_BUF);
         break;
      case TRIG_HALT :
         sprintf(EV_BUF,"%s\r\n",breakMsg[8]);
         DisplayStr(EV_BUF);
         break;
      case EP_PENDING :
         sprintf(EV_BUF,"%s\r\n",breakMsg[9]);
         DisplayStr(EV_BUF);
         break;
   }
}        /* end of DisplayBreak */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ClearCmd(unsigned int id, unsigned int id2)
{
   if (cmd_syntax.argc == 0) ClrBrkRange(0, BreakNumber-1); /* Clear All */
   else if (cmd_syntax.argc == 1) ClrBrkRange(id-1, id-1);  /* Clear #id */
// Chen 05/26/94
//   else ClrBrkRange(id-1, id2-1);                   /* Clear #id to #id2 */
   else if (cmd_syntax.argc == 2) ClrBrkRange(id-1, id2-1);
                                    /* Clear #id to #id2 */

   return(TRUE);
}

/**************************************************************************
**
** Name : ClrBrkRange(min, max)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ClrBrkRange(int min, int max)
{
int i;
int tmpVP;      // Chen 05/26/94

// added by Chen 05/26/94

// no any breakpoints
    if ( BreakNumber == 0 ) {
        tmpVP = VPOut;
        VPOut = COMVP;
        DisplayStr( " No any breakpoints ! \n\r");
        VPOut = tmpVP;
        return;
    }

// start number is large than end number
    if ( min > max ) {
        tmpVP = VPOut;
        VPOut = COMVP;
        DisplayStr( " Breakpoint number is incorrect ! \n\r");
        VPOut = tmpVP;
        return;
    }

// start number less than 0 or end number large than (BreakNumber-1), error
    if ( min < 0 || max > BreakNumber-1 ) {
        tmpVP = VPOut;
        VPOut = COMVP;
        DisplayStr( " Breakpoint number is incorrect ! \n\r");
        VPOut = tmpVP;
        return;
    }


/*
// Chen 05/26/94
// The below processing is based on user friendly, but now they are bugs!
// So I must remark them.

   if (BreakNumber == 0) return;
   if (min > max) { i = min; min = max; max = i; }  // swap min and max
   if (max < 0 || min > BreakNumber - 1) return;    // range not overlapped
   if (min < 0) min = 0;
   if (max > BreakNumber - 1) max = BreakNumber - 1;

*/


   for (i = min; i <= max; i++) {
//    adr2str(SwBreak[i].address, PCstr);
//    MarkBKPTinCodeVP(' ');
      MarkBKPTinCodeVP(SwBreak[i].address, ' ');
      MarkPC(CurrentPC);
   }
   memcpy(&SwBreak[min], &SwBreak[max + 1],
          sizeof(SwBreak[0]) * (BreakNumber-1 - max) );
   for (i = BreakNumber - (max-min+1); i < BreakNumber; i++)
      SwBreak[i].exists = 0;
   BreakNumber -= (max - min + 1);
}       /* end of ClrBrkRange() */

/**************************************************************************
**
** Name : ChkBreak(addr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ChkBreak(unsigned long addr)
{
int i;

   for (i = 0; i < BreakNumber; i++)
      if (ADDR2ABS(SwBreak[i].address) == ADDR2ABS(addr)) return (i);
   return (-1);
}

/**************************************************************************
**
** Name : UpdateBkptData
**
** Function: This function updates data at S/W breakpoint(s) address(es) if
**           they are modified.  In order to break execution at breakpoint(s),
**           0xCC(INT 3) codes have to be stuffed to the breakpoint addresses
**           each time before "Go" session; the original data are then
**           kept in SwBreak[i].data. This function has to be done after
**           a "Memory-Write" action to ensure that after breakpoint(s)
**           encountered, the accurate data are to be recovered.
**
**    Input  : addr, len
**
**    Output : swBreak[i].data
**
** Notes:
**
** Programmed by C. Joyce Lin, 12/01/1993
**
**************************************************************************/
UpdateBkptData(U32 addr, U32 len)
{
U16 i;
U32 abs;
U8 tmpBuf[2];

   for (i = 0; i < BreakNumber; i++) {
      abs = ADDR2ABS(SwBreak[i].address);
      if ( abs >= ADDR2ABS(addr) && abs < ADDR2ABS(addr+len) ) {
         emuGetMemN( SwBreak[i].address, tmpBuf, 1L );
         SwBreak[i].data = tmpBuf[0];
      }
   }
}

/**************************************************************************
**
** Name : adr2str(addr, buf)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

adr2str(addr, buf)
unsigned long addr;
char *buf;
{
char c;
int i, j;
   for (i=7; i >= 0; i--) {
      c=(addr>>i*4)&0xf;
      *buf++=hex[c];
      if (i == 4) *buf++=':';
   }
}        /* end of adr2str(addr, buf) */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

unsigned long adr2hex(buf)
unsigned char *buf;
{
int i, j;
unsigned char ii;
unsigned long l;
   l = 0;
   i = 4;
   for (j=0; j < i;j++) {
      ii = *buf++;
      l = (l << 8) + ii;
   }
   return(l);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
static CheckInterval(long interval)
{
long ll, lll;

   GetTime(&ll);
   lll = ll + interval;
   do {
      if(chk_hlt() == ESC)  return(FALSE);
      GetTime(&ll);
   } while(ll < lll);
   return(TRUE);
}
/***************************************************************************
**
**  Name: SetPutsBuf(Buffer, MaxRows, InitialCount)
**
**  Description:
**     assign the buffer where output is to be placed and max rows which
**     can be put;
**     if Buffer = NULL, output is displayed on screen;
**     if InitialCount < 0, no [More] in PutsMore();
**
**  Input: output buffer, max rows, and initial count of rows
**
****************************************************************************/
PUBLIC SetPutsBuf(char *Buffer, int BufRows, int InitialCount)
{
   OutputPtr = Buffer;
   if (Buffer != NULL)  *Buffer = '\0';
   OutputRows = BufRows;
   RowCount = InitialCount;
}  /* end of SetPutsBuf */

/***************************************************************************
**
**  Name: PutsMore(str)
**
**  Description:
**     print a string and process user's key input
**
**  Input:  string
**
**  Return: code of pressed key
**
****************************************************************************/
PUBLIC int PutsMore(char *str)
{
int key;

   if (OutputPtr == NULL) {
/*** Output is displayed on screen ***/
      key = chk_hlt();
      if (key == ESC) {
         DisplayStr("\\\r\n");
         return (ESC);
      }
      if (key == SPACE)
         if (RowCount < 0)  RowCount = OutputRows;   /* set [More] mode */
      if (RowCount >= OutputRows) {
         RowCount = 0;
         DisplayStr("[More]");
         if (cmdfile_flag) {
            GetOneLineFromCmdFile();
            key = CmdFileBuf[0];
         }
         else  key = get_key();
         if (key == ESC) {
            DisplayStr("\\\r\n");
            return (ESC);
         }
         if (key == SPACE)  RowCount = -1;   /* unset [More] mode */
         DisplayStr("\r\n");
      }
      DisplayStr(str);  DisplayStr("\r\n");
      if (RowCount >= 0)  RowCount ++;
      return (key);
   }
   else {
/*** Output is placed in buffer pointed by OutputPtr ***/
      strcpy(OutputPtr, str);
      OutputPtr += strlen(str);
      strcpy(OutputPtr,"\r\n");
      OutputPtr += 2;
      RowCount ++;
      if (RowCount >= OutputRows) {
         RowCount = 0;
         return (ESC);
      }
      else  return (0);
   }
}  /* end of PutsMore() */

/**************************** End of File **********************************/
