/***************************************************************************
**
** File name : upload.c
**
** Upload file from Michelle.
**
** Changing :
**
** A. Date -- 10/21/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**     3. Delete all "MICEEchoESC()" calling.
**     4. Change all "cmd_argv[]" to be "cmd_syntax.asc[]".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "reg86.h"
#include  "database.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/


/**************************************************************************
**
** Local variables
**
***************************************************************************/

char EOFRec[]=":00000001FF\r\n";
char Rec02[]=":020000020000FC\r\n";
int fdupload;
unsigned long up_addr1, up_addr2;
unsigned int def_cs, up_cs;
int CSFlag;
unsigned char up_buf[256];

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern char dw_buf[];
extern char tmp_ip[], cs_val[];
extern char hex[];


/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : uploadcmd()
**
** Function
**
**     Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

UploadCmd()
{
struct malloc_tag upload_ptr_malloc;
char *hlld_lmalloc();

   VPOut = COMVP;
   if(cbuf = hlld_lmalloc(0 ,256)) {
      memcpy(&upload_ptr_malloc,&ptr_malloc,sizeof(struct malloc_tag));
      upload();
      memcpy(&ptr_malloc,&upload_ptr_malloc,sizeof(struct malloc_tag));
      hlld_lfree(&ptr_malloc);
   } else prn_ferr(45);
   return(TRUE);
}        /* end of upload_cmd() */

/**************************************************************************
**
** Name : upload()
**
** Function
**
**     Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

upload()
{
int i, stop;
unsigned long addr;
long len, length;
unsigned long getMemRange();
int first_cs;

   if(open_a_o(cmd_syntax.asc,(LPINT)&fdupload,'I') != OPEN_OK) {
//    prn_ferr(15);   // already called in open_a_o()
      return;
   }
   DisplayStr(" CS = ");
   emuGetReg(I86_REG, CS, (U32)&def_cs);
   for (i=3;i >= 0; i--) cs_val[3-i] = hex[(def_cs>>(i*4))&0xf];
   for (i=0;i < 4; i++) DisplayCh(cs_val[i]);
   DisplayStr("\r\n");
   first_cs = 1;
   for (stop = FALSE; !stop; ) {
      len = getMemRange();
      if (len == NULL) break;
      if (len == -1) continue;
      if (first_cs || CSFlag) {
         for (i=0;i < 4;i++) Rec02[i+9]=cs_val[i];
         i = ((up_cs >> 8) & 0xff) + (up_cs & 0xff);
         i = 0xfc - i;
         hex2asc(&Rec02[13],i);
         write(fdupload,Rec02,strlen(Rec02));
         first_cs = 0;
      }
     DisplayStr("\n\r");
      addr = up_cs;
      addr = (addr << 16) + up_addr1;
      DisplayStr(" Upload in progress: ");
      do {
       if (len > 240) length = 240;else length=len;
         len -= length;
         emuGetMemN(addr,up_buf,length);
         for (i=3;i >= 0; i--) tmp_ip[3-i] = hex[(addr>>(i*4))&0xf];
         displayCSIP();
         writeRec00(addr,length);
         AdvanceAddr(&addr, length);
         if (chk_hlt() == ESC) {
            stop = TRUE;
            break;
         }
      } while (len != 0);
     DisplayStr("\n\r");
   }
   write(fdupload,EOFRec,strlen(EOFRec));
   close(fdupload);
   DisplayStr("\n\r");
}        /* end of upload() */

/**************************************************************************
**
** Name : getMemRange()
**
** Function
**
**     Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

unsigned long getMemRange() {
char cbuf[128];
int i;
unsigned long temp1, temp2;
   up_addr1=up_addr2=0;
   DisplayStr("\r Upload memory range: ");
   if(get_str2(cbuf,30) == ESC) return(NULL);
   if (strlen(cbuf) == NULL) return(NULL);
   if (cbuf[0] == '\r') return(NULL);
   if (strstr(cbuf,":") != NULL) {
      if (sscanf(cbuf, "%x:%x %x:%x", &up_cs, &up_addr1,
         &temp1, &up_addr2) == 4) {
           if (up_cs != temp1) {
              DisplayStr("\n\r Must have the same CS in memory range\n\r");
                        return(-1);
                }
//              temp2 = (unsigned long) up_cs;
//              up_addr2 = (temp1*16) + up_addr2 - (temp2*16);
          } else {
        sscanf(cbuf, "%x:%x %x", &up_cs, &up_addr1, &up_addr2);
          }
      if (up_cs != def_cs) CSFlag = 1;else CSFlag = 0;
   } else {
      sscanf(cbuf, "%x %x", &up_addr1, &up_addr2);
      if (up_cs == def_cs) CSFlag = 0;
      else {
         up_cs = def_cs;
         CSFlag = 1;
      }
   }
   for (i=3;i >= 0; i--) cs_val[3-i] = hex[(up_cs>>(i*4))&0xf];
   if (up_addr1 > up_addr2) {
      DisplayStr(" Invalid memory range\n\r");
                return(-1);
   }
   return(up_addr2-up_addr1+1);
}        /* end of getMemRange() */

/**************************************************************************
**
** Name : writeRec00(addr, length)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

writeRec00(unsigned long addr, int length)
{
int i;
unsigned char chksum;
   dw_buf[0]=':';
   i = (addr >> 8) & 0xff;
   chksum = i + (addr&0xff) + length;
   hex2asc(&dw_buf[1],length);
   hex2asc(&dw_buf[3],i);
   hex2asc(&dw_buf[5],addr&0xff);
   dw_buf[7]='0';
   dw_buf[8]='0';
   for (i=0;i < length;i++) {
      chksum += up_buf[i];
      hex2asc(&dw_buf[i*2+9],up_buf[i]);
   }
   chksum = 0 - chksum;
   hex2asc(&dw_buf[i*2+9],chksum);
   dw_buf[i*2+11]='\r';
   dw_buf[i*2+12]='\n';
   dw_buf[i*2+13]=NULL;
   write(fdupload,dw_buf,strlen(dw_buf));
}        /* end of writeRec00() */

/**************************** End of File **********************************/
