/***************************************************************************
**
** File name : usd3.c
**
**
** Changing :
**
** A. Date -- 10/20/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "menu.h"
#include  <vv_main.h>
#include  "usd3.h"
#include  "gbl.h"
#include  "oldgbl.h"
#include  "usym1.h"
#include  "usym2.h"
#include  "funcext.h"
#include  <signal.h>
#include  "dos16.h"
#include  "database.h"


/**************************************************************************
**
** Local define
**
***************************************************************************/

#ifndef _MICHELLE_
#define _MICHELLE_
#endif

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int  USD3CtrlCHandler();
extern int MAXFlag, COMVPMax;
extern int errorflag;       // Chen 06/01/94 MV186.V13

/**************************************************************************
**
** Local variables
**
***************************************************************************/

int  (*OldCtrlCHandler)();


/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : main()
**
** Function : Main Procedure
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

main( int argc, char *argv[] )
{
   PTR         TmpMemory;
   int cmdIndex, retCode;

   if ( argc > 2 ) { ErrorCondition = TOO_MANY_ARGUMENT; goto End5; }

 // Initialize mouse here in order to allow abort when Ctrl-Break is pressed
   InitMouse();

   init_vv();
   if (_vid_scr.vbufp == NULL)   /* under DPMI ? */
      _vid_scr.vbufp =           /* create a protected-mode pointer */
         D16SegAbsolute(vid_getmode() == MONO ? 0xB0000L : 0xB8000L, 0x8000);
   OldVideoMode = vid_getmode();
   vs_clr();
   OldCtrlCHandler = signal( SIGINT, USD3CtrlCHandler );

 /*  initialize global variables  */
   if ( ! InitGbl() ) { goto End4; }

 /*  manage the initialization of MICE  */
   if ( ! InitMICE() ) { goto End3; }

 /*  create menus  */
   if ( ! CreateMenu() ) { ErrorCondition = MEM_INSUFFICIENT; goto End2; }

 /*  create viewports  */
   if ( ! CreateVP() ) { ErrorCondition = MEM_INSUFFICIENT; goto End1; }

 // Initialize mouse here in order to reconfigure mouse according to the
 // video mode(25/50 lines)
   InitMouse();
   ScrnDisplay = 1;

   if ( ( TmpMemory = malloc( 5 * 1024 ) ) == NULLP ) {
     ErrorCondition = MEM_INSUFFICIENT;
     goto End1;
   }
   else  free( TmpMemory );

 /*  set initial display of each viewport  */
   if (!MAXFlag) {
     InitVPDisplay();
   } else {
     InitNewCmd();
//      d_o_prompt();
     COMVPMax = 1;
     VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
     if (TopVP >= BREVP) wn_dn( VP[TopVP].Ptr );
     wn_dn( VP[CODVP].Ptr );
     sw_opt( WNECHO, OFF, VP[COMVP].Ptr );
     sw_bdr( &SingleVPBdr, VP[COMVP].Ptr );
     wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, 23, VP[REGVP].Width, VP[COMVP].Ptr );
     wn_mod_no_pre_wn_unset( VP[COMVP].yOrg=VP[REGVP].yOrg, VP[COMVP].xOrg=VP[REGVP].xOrg, VP[COMVP].Height=23, VP[REGVP].Width, VP[COMVP].Ptr );
     if ( VP[COMVP].Ptr->r < (VP[COMVP].Ptr->row_org+20) ) {
       sw_msorg( 0, VP[COMVP].Ptr->col_org, VP[COMVP].Ptr );
       wn_msadj( VP[COMVP].Ptr );
       csr_plwn( VP[COMVP].Ptr );
     }
     sw_opt( WNECHO, ON, VP[COMVP].Ptr );
     wn_upd( VP[COMVP].Ptr );
     ActVP = COMVP;
     VP[COMVP].Ptr->titleatt = LVPTITLEACT;
     v_titleatt( NULLP, LVPTITLEACT, VP[COMVP].Ptr );
     v_st(MICEBuf, VP[COMVP].Ptr);
   }

/*  check if there is a file to be downloaded */
   if (argc == 2) DownloadCmd(argv[1]);
   for ( ; ; ) {
//   keep_it_for_IF = 1;
     errorflag = 0;     // Chen 06/01/94    MV186.V13
     retCode = InputProcess();
     if ( retCode != -1 ) prn_ferr(retCode);
     else CmdProcess();
     if ( ExitUSD3 )  break;
   }

 /*  destroy viewports  */
   DestroyVP();

End1 :
   DestroyMenu();

End2 :
   WmClose();

End3 :
   FreeGbl();

End4 :
   signal( SIGINT, OldCtrlCHandler );
   vs_clr();
   USD3vid_setmode( OldVideoMode );
   exit_vv();

End5 :
   switch( ErrorCondition ) {
     case TOO_MANY_ARGUMENT     :
               printf( "\nError! Too many arguments.\n" );
             break;
     case MEM_INSUFFICIENT      :
               printf( "\nError! Insufficient memory to run MICEview.\n" );
             break;
     case CANNOT_LOAD_HANDLER     :
               printf( "\nError! Can't install RS-232 handler.\n" );
             break;
     case USD3DLG_TXT_OPEN_ERR   :
               printf( "\nError! Can't open \"MV86DLG.TXT\".\n" );
             break;
     case USD3DLG_LIB_OPEN_ERR   :
               printf( "\nError! Can't open \"MV86DLG.LIB\".\n" );
             break;
     case USD3CLST_TXT_OPEN_ERR   :
               printf( "\nError! Can't open \"MV86CLST.TXT\".\n" );
             break;
   }
}  /*  of Main()  */

/**************************************************************************
**
** Name : USD3vid_setmode()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

USD3vid_setmode(int mode)
{
unsigned char far* vbufsave;

   vbufsave = _vid_scr.vbufp;
   vid_setmode(mode);
   if (_vid_scr.vbufp == NULL)     /* under DPMI ? */
      _vid_scr.vbufp = vbufsave;   /* restore original value */
}

/**************************** End of File **********************************/
