/***************************************************************************
**
** File name : usd3.h
**
**
** Changing :
**
** A. Date -- 10/27/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

/**************************************************************************
**
** Local define
**
***************************************************************************/

/*  transform Aztec C to Microsoft C  */
#define  MSC_TRUNC       ( O_CREAT | O_RDWR | O_TRUNC )
#define  index( a, b )       strchr( a, b )
#define  rindex( a, b )       strrchr( a, b )
#define  inportb( a )       inp( a )
#define  outportb( a, b )   outp( a, b )
#define  movmem( a, b, c )  memmove( b, a, c )
#define  setmem( a, b, c )  memset( a, c, b )

/*  transform MS-WINDOWS to Microsoft C  */
#define  OF_CREATE     ( O_CREAT | O_TRUNC )
#define  OF_READ       O_RDONLY
#define  OF_WRITE      O_WRONLY
#define  OF_READWRITE  O_RDWR

#define  _lopen   open
#define  _lclose  close
#define  _lcreat  creat
#define  _llseek  lseek
#define  _lread   read
#define  _lwrite  write

#ifdef NEC_PC9801
#define  LVPBDR  LGRE_BLA
#else
#define  LVPBDR  LWHI_BLA
#endif

/*  used for resizing viewport  */
#define  TOPSIDE     1
#define  BOTTOMSIDE  0
#define  ZOOMUP      1
#define  ZOOMDOWN    0

/*  size of the commmand buffer "CmdBuf[]"  */
#define  CMDBUFSIZE  512

/*  size of the command file buffer "CmdFileBuf[]"  */
#define  CMDFILEBUFSIZE  CMDBUFSIZE

/*  size of the function key buffer "FuncKeyBuf[]"  */
#define  FUNCKEYBUFSIZE  ( CMDBUFSIZE + 1 )

/*  size of each entry of the softkey buffer "SoftKeyBuf[]"  */
#define  SOFTKEYBUFSIZE  220
// but we only support 80 characters to keyin at the command line

/*  size of the dialog-box buffer "DlgBuf[]"  */
#define  DLGBUFSIZE  ( CMDBUFSIZE * 5 )

/*  size of the MICE buffer "MICEBuf[]"  */
#define  MICEBUFSIZE  ( 80 * 25 )

/*  size of the viewport information buffer "VPInfoBuf"  */
#define  VPINFOBUFSIZE  18

/*  mnemonic names of special characters  */
#define  BS   0x08
#define  LF   0x0a
#define  CR   0x0d
#define  ESC   0x1b
#define  SP   0x20
#define  EXCL   0x21
#define  EQUAL  0x3d

/*  memory file size for choice list  */
// #define  CLISTMFILEMAXROW  130
#define  CLISTMFILEMAXROW  400
#define  CLISTMFILEMAXCOL  40

/* memory file size for help */
#define  DLGMFILEMAXROW  630
// #define  CMDMFILEMAXROW  250
#define  CMDMFILEMAXROW  300

/*  return value of "LinkMICEDlgBox()"  */
#define  RETRYLINKMICE  0
#define  ABORTLINKMICE  1

/*  starting column that the source line will be displayed at CODE viewport  */
#define  CODVPINDENT  2

/*  command cursor '_'  */
#define  CMDCURSOR  0x5f

/*  return values of function, OK : successful, FAIL : unsuccessful  */
#define  OK    0
#define  FAIL  -1
#define  BUFFULL  FAIL

/*  the following constants are defined in "OMF_DWN.H" of USD-II  */
#define  omf_size    ( 1024 + 16 )
#define  intel_size  300

/*  */
#define  TOO_MANY_ARGUMENT   -101
#define  MEM_INSUFFICIENT   -102
#define  CANNOT_LOAD_HANDLER   -103
#define  USD3DLG_TXT_OPEN_ERR   -104
#define  USD3CMD_TXT_OPEN_ERR   -105
#define  USD3CLST_TXT_OPEN_ERR   -106
#define  USD3DLG_LIB_OPEN_ERR   -107
#define  CMDWORDFILE_OPEN_ERR   -108

/*  available viewports  */
#define  BREVP  0
#define  CODVP  1
#define  COMVP  2
#define  REGVP  3
#define  STAVP  4
#define  TRAVP  5
#define  DATVP  6

/*  display-buffer size of each viewport  */
#define  BREBUFROW  50
#define  BREBUFCOL  78
#define  CODBUFROW  50
#define  CODBUFCOL  78
#define  COMBUFROW  100
#define  COMBUFCOL  78
#define  REGBUFROW  50
#define  REGBUFCOL  78
#define  STABUFROW  50
#define  STABUFCOL  40
#define  TRABUFROW  50
#define  TRABUFCOL  78
#define  DATBUFROW  50
// #define  DATBUFCOL  40
#define  DATBUFCOL  50

/*  available pull-down menus  */
#define  FILMENU  0
#define  SETMENU  1
#define  MEMMENU  2
#define  EMUMENU  3
#define  TRAMENU  4
#define  SYMMENU  5
#define  OPTMENU  6
#define  SPAMENU  7
#define  LSAMENU  8

/*  available colors  */
#define  BLACOLOR  0
#define  BLUCOLOR  1
#define  MAGCOLOR  2
#define  REDCOLOR  3
#define  WHICOLOR  4
#define  BROCOLOR  5
#define  CYACOLOR  6
#define  GRECOLOR  7
#define  YELCOLOR  8

/*  child viewports of BREAKPOINT, TRACE and CODE viewports  */
#define  BREVP_PREV  7
#define  BREVP_NEXT  8
#define  TRAVP_PREV  9
#define  TRAVP_NEXT  10
#define  CODVP_PREV  11
#define  CODVP_NEXT  12
#define  CODVP_VIEW  13
#define  CODVP_PGUP  14
#define  CODVP_PGDN  15
#define  CODVP_TOP   16
#define  CODVP_BOTTOM 17

#define  HANDLE  unsigned short

/*   macro which calculates the index of logical attribute array "_att_tbl[][]"  */

#define  COLOR( ForegrndColor, BackgrndColor )  ( ( ForegrndColor + 5 ) * 10 \
                    + BackgrndColor )

/**************************************************************************
**
** Local variables
**
***************************************************************************/

typedef  unsigned char    BYTE;
typedef  unsigned short    WORD;
typedef  unsigned long   DWORD;
typedef  char         *PSTR;
typedef  char near    *NPSTR;
typedef  char far    *LPSTR;
typedef  int  far    *LPINT;

/*  information of each viewport  */
struct VPtag {
         WINDOWPTR  Ptr;
         int    yOrg;       /*  screen coordinate  */
         int    xOrg;       /*  screen coordinate  */
         int    Height;
         int    Width;
         SCRPTR    Buf;
         int    Maxr;       /*  memory screen coordinate  */
         int    Maxc;       /*  memory screen coordinate  */
         int    TextColor;
         int    BackgrndColor;
};

/*  color of viewport's border  */
/* CORE 90.08.014 */
/*  */
struct MonVarTag {
        int   Num;
        char  Sym[41];
        char  Addr[14];
        unsigned int Type;
        int   Count;
        char  Format;  // byte / word /long
        char  isLocal; // global=0, local static=1, local stacked=2
        unsigned long blkAddr;
};

/**************************** End of File **********************************/
