/***************************************************************************
**
** File name : viewport.c
**
** View port process.
**
** Changing :
**
** A. Date -- 10/21/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**        3. Delete all "MICEEchoESC()" calling.
**        4. Change all "cmd_argv[]" to be "cmd_syntax.asc[]".
**        5. Delete all send_ESC() calling.
**        6. Delete all checking of "agrc".
**        7. Rename "urecall_cmd()" to be "UrecallCmd()".
**        8. Rename "usave_cmd()" ot be "UsaveCmd()".
**        9. Delete arguments of "UrecallCmd()" and "UsaveCmd()".
**        10. Add include file "database.h".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "database.h"
#include  "reg86.h"
#include  "cmdid.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define PULLDOWN        1
#define DIALOG          2
#define SD86HLPS_TXT_OPEN_ERR 1
#define SD86HLPC_TXT_OPEN_ERR 2
#define KEYWORD_NOT_FOUND     3

/**************************************************************************
**
** GBL variables
**
***************************************************************************/

//UCHAR DlgColorLATT[102];
UCHAR isAF8=0, actF1;
CmdHelpWnToggle(KEYCTRLPTR kcp );
SingleCmdHelp(KEYCTRLPTR kcp );
MFILEPTR sCmdMFilePtr;
WINDOWPTR sCmdHelpWnp;

// added by Chen, 07/08/94
char sdHlpFileName[512];

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern UCHAR GblDlgColor[],GblDlgMono[];
extern int cmdIdx, Text50Lines;
extern int special_dialog;
extern int pulldown_or_dialog;
extern struct cmdStruc {
    const char cmdText[12];
    const U8 minValidNo, synType;
}  cmdRecord[];

extern char sdLayFileName[512];     // added by Chen, 08/03/94
extern char sdLibFileName[512];     // refer to "LAM2" variable

/**************************************************************************
**
** Name :
**
** Function : UPDate command
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

UpdateCmd()
{
int  VPID, MaskFlag;

 /*  list the status of each viewport's updating flag  */
 if (cmd_syntax.argc == 0) {
   if ( MaskRedrawFlag&REDRAWBRE ) DisplayStr( " BREAKPOINT viewport: OFF" );
   else  DisplayStr( " BREAKPOINT viewport: ON " );

   if ( MaskRedrawFlag&REDRAWCOD ) DisplayStr( "              CODE  viewport: OFF\r\n" );
   else  DisplayStr( "              CODE  viewport: ON\r\n" );

   if ( MaskRedrawFlag&REDRAWREG ) DisplayStr( " REGISTER   viewport: OFF" );
   else  DisplayStr( " REGISTER   viewport: ON " );

   if ( MaskRedrawFlag&REDRAWSTA ) DisplayStr( "              STACK viewport: OFF\r\n" );
   else  DisplayStr( "              STACK viewport: ON\r\n" );

   if ( MaskRedrawFlag&REDRAWTRA ) DisplayStr( " TRACE      viewport: OFF" );
   else  DisplayStr( " TRACE      viewport: ON " );

   if ( MaskRedrawFlag&REDRAWDAT ) DisplayStr( "              DATA  viewport: OFF\r\n" );
   else  DisplayStr( "              DATA  viewport: ON\r\n" );

    return( TRUE );
 }

   /*  check updating flag   */
   MaskFlag = cmd_syntax.argv[1];

   /*  check viewport name and set MaskRedrawFlag  */
   if   ( cmd_syntax.argv[0] == 0 )
     if ( MaskFlag )  MaskRedrawFlag |= REDRAWBRE;
     else { MaskRedrawFlag &= ( ~REDRAWBRE );
       if ( wn_isup( VP[BREVP].Ptr ) )  UpdateBREVP( 0 );
     }
 else  if ( cmd_syntax.argv[0] == 1 )
     if ( MaskFlag )  MaskRedrawFlag |= REDRAWCOD;
     else { MaskRedrawFlag &= ( ~REDRAWCOD );
       if ( wn_isup( VP[CODVP].Ptr ) )  UpdateCODVP(CODVP_VIEW);
     }
 else  if ( cmd_syntax.argv[0] == 2 )
     if ( MaskFlag )  MaskRedrawFlag |= REDRAWREG;
     else { MaskRedrawFlag &= ( ~REDRAWREG );
       if ( wn_isup( VP[REGVP].Ptr ) )  UpdateREGVP();
     }
 else  if ( cmd_syntax.argv[0] == 3 )
     if ( MaskFlag )  MaskRedrawFlag |= REDRAWSTA;
     else { MaskRedrawFlag &= ( ~REDRAWSTA );
       if ( wn_isup( VP[STAVP].Ptr ) )  UpdateSTAVP();
     }
 else  if ( cmd_syntax.argv[0] == 4 )
     if ( MaskFlag )  MaskRedrawFlag |= REDRAWTRA;
     else { MaskRedrawFlag &= ( ~REDRAWTRA );
       if ( wn_isup( VP[TRAVP].Ptr ) )  UpdateTRAVP( 0 );
     }
 else  if ( cmd_syntax.argv[0] == 5 )
     if ( MaskFlag )  MaskRedrawFlag |= REDRAWDAT;
     else { MaskRedrawFlag &= ( ~REDRAWDAT );
       if ( wn_isup( VP[DATVP].Ptr ) )  UpdateDATVP();
     }
 return( TRUE );
}  /*  of UpdateCmd()  */


/**************************************************************************
**
** Name : SoftkeyCmd(Kn, Command )
**
** Function : Softkey command, shift-F1 to shift-F10
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

SoftkeyCmd( U32 Kn )
{
int  KnBufIdx, i;
// char temp[240];
char temp[512];   // Chen 06/08/94


// initialize the temp[]
    memset(temp, NULL, sizeof(temp));

// list all of the softkey definitions
   if (cmd_syntax.argc == 0) {      // display all Kn
//   if (cmd_syntax_softkey.argc == 0) {      // Chen
      for (i=0; i<10; i++) {
          if (i<9) sprintf(temp," K%1d  = %s\n\r",i+1, SoftKeyBuf[i] );
          else     sprintf(temp," K%2d = %s\n\r",i+1, SoftKeyBuf[i] );
          DisplayStr(temp);
        memset(temp, NULL, sizeof(temp));   // Chen 06/08/94
      }
      return( TRUE );
   }
   strcpy( SoftKeyBuf[Kn - 1], cmd_syntax.asc );
//   strcpy( SoftKeyBuf[Kn - 1], cmd_syntax_softkey.asc );
   return( TRUE );

}  /*  of SoftkeyCmd()  */



/****************************************************************************
** the initial structure of SDLAYOUT.SAV : -- Chen
**
** position :  0 + 1   + 7*VPINFOBUFSIZE-1 + 1 + 10*(1+SOFTKEYBUFSIZE)-1
**             |---|---------------------|---|-------------------------|
** content  :   '0'     ( VP info )       '0'        ( Softkey )
**               |                         |
** flag     :   VP saved? 1:Yes; 0:No      SK saved? 1:Yes; 0:No
**
** position :    + 1              + 3               + 3               + 2
**             |---|----------------|-----------------|-----------------|
** content  :   '0'  ( GblDlgMono )   ( GblDlgColor )   ( Text50Lines )
**               |
** flag     :
**
****************************************************************************/
/**************************************************************************
**
** Name : UsaveCmd()
**
** Function : USave command
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

UsaveCmd()
{
 int  VPID;
 int  WorK;  /*  bit 1 : W, bit 0 : K  */
 extern int  AskAbortUSD3;
 char *pch1, *pch2;
 char temp[512];

 if ( AskAbortUSD3 )  AskAbortUSD3 = 0;
 if ( cmd_syntax.argc == 0 )  WorK = 3;
 else
    if ( cmd_syntax.argv[0] == 0 )  WorK = 2;
    else  WorK = 1;

 if ( ! wn_isup( VP[CODVP].Ptr ) && (WorK-1)) { prn_ferr( 64 ); return( TRUE ); }

 /*  open "SDLAYOUT.SAV" for writing  */
    _searchenv("MVLAYOUT.SAV", "MV186", sdLayFileName);  // Chen 08/03/94
    if ( *sdLayFileName == NULL ) {
        strcpy(temp, sdLibFileName);
        pch1 = temp;
        pch2 = NULL;
        if ( LAM2 == 0 ) {
            while ( (pch1=strstr(pch1, "MV86LAM.LIB\\")) != NULL ) {
                pch1 += 11;
                pch2 = pch1;
            }
            if ( pch2 == NULL ) {
                pch2 = temp;
            }
            if ( (pch2 = strstr(pch2, "MV86LAM.LIB")) != NULL ) {
                *pch2 = NULL;
            }
        }
        else if ( LAM2 == 2 ) {
            while ( (pch1=strstr(pch1, "MV86LAM2.LIB\\")) != NULL ) {
                pch1 += 12;
                pch2 = pch1;
            }
            if ( pch2 == NULL ) {
                pch2 = temp;
            }
            if ( (pch2 = strstr(pch2, "MV86LAM2.LIB")) != NULL ) {
                *pch2 = NULL;
            }
        }
        strcpy(sdLayFileName, temp);
        strcat(sdLayFileName, "MVLAYOUT.SAV");
    }

 if ( ( USD3SAVFileHan = open( sdLayFileName, O_WRONLY ) ) == -1 )
    if ( ( USD3SAVFileHan = open( sdLayFileName, O_CREAT | O_WRONLY, S_IREAD | S_IWRITE ) ) != -1 ) {
        // 1 line: DLGCOLOR modified
       chsize( USD3SAVFileHan, (long) ( 7*VPINFOBUFSIZE + 10*(1+SOFTKEYBUFSIZE) + 9) );
       lseek( USD3SAVFileHan, (long) 0, SEEK_SET );
       write( USD3SAVFileHan, "0", 1 );
       lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );
       write( USD3SAVFileHan, "0", 1 );
        // 2 lines:  DLGCOLOR: writing color settings to SDLAYOUT.SAV
       lseek( USD3SAVFileHan, (long) (10*(1+SOFTKEYBUFSIZE)), SEEK_SET );
       write( USD3SAVFileHan, "0", 1 );
       lseek( USD3SAVFileHan, (long) 0, SEEK_SET );
    } else { prn_ferr( 31 ); return( TRUE ); }

 /*  write viewport information ( screen layout ) to "SDLAYOUT.SAV"  */
 if ( ( WorK & 2 ) != 0 ) {
    for ( VPID = BREVP; VPID <= DATVP; VPID++ ) WriteVPInfoToUSD3SAV( VPID );
// 3 lines: DLGCOLOR
        lseek( USD3SAVFileHan, (long) -8, SEEK_END );
        write(USD3SAVFileHan,GblDlgColor,3);
        write(USD3SAVFileHan,GblDlgMono,3);
 /*  Write 25/50 lines text display mode to "SDLAYOUT.SAV"  */
        write(USD3SAVFileHan, (char *)&Text50Lines, sizeof(Text50Lines));
 }


 /*  write softkey definitions to "SDLAYOUT.SAV"  */
 if ( ( WorK & 1 ) != 0 )  WriteSoftKeyToUSD3SAV();

 /*  close "SDLAYOUT.SAV"  */
 close( USD3SAVFileHan );
 return( TRUE );
}  /*  of UsaveCmd()  */

/**************************************************************************
**
** Name : WriteVPInfoToUSD3SAV( VPID )
**
** Function :  write viewport information ( screen layout ) to "SDLAYOUT.SAV"
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

WriteVPInfoToUSD3SAV( int VPID )
{
 VPInfoBuf[0] = '1';
 VPInfoBuf[1] = VPID + '0';
 if ( wn_isup( VP[VPID].Ptr ) )  VPInfoBuf[2] = '1';
 else  VPInfoBuf[2] = '0';

 if      ( VPID == BREVP )
         VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWBRE) ? 1 : 0 ) ) + '0';
 else if ( VPID == CODVP )
         VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWCOD) ? 1 : 0 ) ) + '0';
 else if ( VPID == COMVP )
         VPInfoBuf[3] = '1';  /*  this value has no meaning  */
 else if ( VPID == REGVP )
         VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWREG) ? 1 : 0 ) ) + '0';
 else if ( VPID == STAVP )
         VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWSTA) ? 1 : 0 ) ) + '0';
 else if ( VPID == TRAVP )
         VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWTRA) ? 1 : 0 ) ) + '0';
 else if ( VPID == DATVP )
         VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWDAT) ? 1 : 0 ) ) + '0';

 if      ( VP[VPID].BackgrndColor == BLACOLOR )  VPInfoBuf[4] = '0';
 else if ( VP[VPID].BackgrndColor == BLUCOLOR )  VPInfoBuf[4] = '1';
 else if ( VP[VPID].BackgrndColor == MAGCOLOR )  VPInfoBuf[4] = '2';
 else if ( VP[VPID].BackgrndColor == REDCOLOR )  VPInfoBuf[4] = '3';
 else if ( VP[VPID].BackgrndColor == WHICOLOR )  VPInfoBuf[4] = '4';
 else if ( VP[VPID].BackgrndColor == CYACOLOR )  VPInfoBuf[4] = '6';
 else if ( VP[VPID].BackgrndColor == GRECOLOR )  VPInfoBuf[4] = '7';
 else if ( VP[VPID].BackgrndColor == YELCOLOR )  VPInfoBuf[4] = '8';

 if      ( VP[VPID].TextColor == BLACOLOR )  VPInfoBuf[5] = '0';
 else if ( VP[VPID].TextColor == BLUCOLOR )  VPInfoBuf[5] = '1';

 else if ( VP[VPID].TextColor == MAGCOLOR )  VPInfoBuf[5] = '2';
 else if ( VP[VPID].TextColor == REDCOLOR )  VPInfoBuf[5] = '3';
 else if ( VP[VPID].TextColor == WHICOLOR )  VPInfoBuf[5] = '4';
 else if ( VP[VPID].TextColor == CYACOLOR )  VPInfoBuf[5] = '6';
 else if ( VP[VPID].TextColor == GRECOLOR )  VPInfoBuf[5] = '7';
 else if ( VP[VPID].TextColor == YELCOLOR )  VPInfoBuf[5] = '8';

 VPInfoBuf[6]  = ( VP[VPID].yOrg / 100 ) + '0';
 VPInfoBuf[7]  = ( ( VP[VPID].yOrg % 100 ) / 10 ) + '0';
 VPInfoBuf[8]  = ( VP[VPID].yOrg % 10 ) + '0';

 VPInfoBuf[9]  = ( VP[VPID].xOrg / 100 ) + '0';
 VPInfoBuf[10] = ( ( VP[VPID].xOrg % 100 ) / 10 ) + '0';
 VPInfoBuf[11] = ( VP[VPID].xOrg % 10 ) + '0';

 VPInfoBuf[12] = ( VP[VPID].Height / 100 ) + '0';
 VPInfoBuf[13] = ( ( VP[VPID].Height % 100 ) / 10 ) + '0';
 VPInfoBuf[14] = ( VP[VPID].Height % 10 ) + '0';

 VPInfoBuf[15] = ( VP[VPID].Width / 100 ) + '0';
 VPInfoBuf[16] = ( ( VP[VPID].Width % 100 ) / 10 ) + '0';
 VPInfoBuf[17] = ( VP[VPID].Width % 10 ) + '0';

 write( USD3SAVFileHan, VPInfoBuf, VPINFOBUFSIZE );

}  /*  of WriteVPInfoToUSD3SAV()  */

/**************************************************************************
**
** Name : WriteSoftKeyToUSD3SAV()
**
** Function : write softkey definitions to "SDLAYOUT.SAV"
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

WriteSoftKeyToUSD3SAV()
{
 int  i;

 lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );

 for ( i = 0; i <= 9; i++ ) {

     write( USD3SAVFileHan, "1", 1);
     write( USD3SAVFileHan, SoftKeyBuf[i], SOFTKEYBUFSIZE );
 }

}  /*  of WriteSoftKeyToUSD3SAV()  */

/**************************************************************************
**
** Name : UrecallCmd()
**
** Function : UREcall command
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

UrecallCmd()
{
 int   VPID;
 int   WorK;  /*  bit 1 : W, bit 0 : K  */
 char  c[2];

   if ( cmd_syntax.argc == 0 )  WorK = 3;
   else
          if ( cmd_syntax.argv[0] == 0 )  WorK = 2;
          else  WorK = 1;

 if ( ! wn_isup( VP[CODVP].Ptr ) && (WorK-1) ) { prn_ferr( 64 ); return( TRUE ); }

 /*  open "SDLAYOUT.SAV" for reading  */
   _searchenv("MVLAYOUT.SAV", "MV186", sdLayFileName);  // Chen 08/03/94
 if ( ( USD3SAVFileHan = open( sdLayFileName, O_RDONLY ) ) == -1 ) {
    prn_ferr( 15 );
    return( TRUE );
 }

 /*  read viewport information ( screen layout ) from "SDLAYOUT.SAV"  */
 if ( ( WorK & 2 ) != 0 ) {
    read( USD3SAVFileHan, c, 1 );
    if ( c[0] == '1' ) {
       ReadVPInfoFromUSD3SAV();

// Adjust positions of FuncKeyVP, CtrlKeyVP, AltKeyVP and CmdHelpVP
   wn_mod_no_pre_wn_unset(vs_rowq() - 1, 0, 1, 80, FuncKeyVP);
   wn_mod_no_pre_wn_unset(vs_rowq() - 1, 0, 1, 80, CtrlKeyVP);
   wn_mod_no_pre_wn_unset(vs_rowq() - 1, 0, 1, 80, AltKeyVP);
   wn_mod_no_pre_wn_unset(vs_rowq() - 1, 0, 1, 80, CmdHelpVP);

       if ( wn_isup( VP[REGVP].Ptr ) )  UpdateREGVP();
       if ( wn_isup( VP[CODVP].Ptr ) )  UpdateCODVP(0);  else  GetPC(&PC);
       if ( wn_isup( VP[STAVP].Ptr ) )  UpdateSTAVP();
       if ( wn_isup( VP[BREVP].Ptr ) )  UpdateBREVP( 0 );

       if ( wn_isup( VP[TRAVP].Ptr ) )  UpdateTRAVP( 0 );
       if ( wn_isup( VP[DATVP].Ptr ) )  UpdateDATVP();
    }
 }

 /*  read softkey definitions from "SDLAYOUT.SAV"  */
 if ( ( WorK & 1 ) != 0 ) {
    lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );
    read( USD3SAVFileHan, c, 1 );
    if ( c[0] == '1' )  ReadSoftKeyFromUSD3SAV();
 }

 /*  close "SDLAYOUT.SAV"  */
 close( USD3SAVFileHan );
 return( TRUE );
}  /*  of urecallcmd()  */

/**************************************************************************
**
** Name : ReadVPInfoFromUSD3SAV()
**
** Function :  read viewport information ( screen layout ) from "SDLAYOUT.SAV"
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ReadVPInfoFromUSD3SAV()
{
 int  STAVPIsUp = 0, DATVPIsUp = 0;
 int  VPID;

// 13 lines: DLGCOLOR

 long lpos;
 DFORMPTR  dfmptr;
    lpos = tell(USD3SAVFileHan);
    lseek(USD3SAVFileHan,(long)-8,SEEK_END);
    read(USD3SAVFileHan,GblDlgColor,3);
    read(USD3SAVFileHan,GblDlgMono,3);
    /* set the video text mode for 50/25 lines display */
    read( USD3SAVFileHan, (char *)&Text50Lines, sizeof(Text50Lines) );
    vid_vga50(Text50Lines);
    vid_hibg( ON );

    lseek(USD3SAVFileHan,lpos,SEEK_SET);


 /*  hide all viewports  */
 for ( VPID = BREVP; VPID <= DATVP; VPID++ )
     if ( wn_isup( VP[VPID].Ptr ) ) wn_dn( VP[VPID].Ptr );

 VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
 VP[ ActVP = COMVP ].Ptr->titleatt = LVPTITLEACT;
 MaskRedrawFlag = 0;
 lseek( USD3SAVFileHan, (long) 0, SEEK_SET );
 TopVP = -1;

 for ( VPID = BREVP; VPID <= DATVP; VPID++ ) {
     read( USD3SAVFileHan, VPInfoBuf, VPINFOBUFSIZE );
     if ( ( VPID == BREVP ) || ( VPID == REGVP ) || ( VPID == TRAVP ) ) {
        if ( VPInfoBuf[2] == '1' )  TopVP = VPID;
     } else  if ( ( VPID==STAVP ) && ( VPInfoBuf[2]=='1' ) )  STAVPIsUp = 1;
             else  if ( ( VPID==DATVP ) && ( VPInfoBuf[2]=='1' ) )  DATVPIsUp = 1;
     if        ( VPID == BREVP ) {
        if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWBRE;
     } else if ( VPID == CODVP ) {
        if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWCOD;
     } else if ( VPID == REGVP ) {
        if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWREG;
     } else if ( VPID == STAVP ) {
        if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWSTA;
     } else if ( VPID == TRAVP ) {
        if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWTRA;
     } else if ( VPID == DATVP ) {
        if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWDAT;
     }

     if       ( VPInfoBuf[4] == '0' )  VP[VPID].BackgrndColor = BLACOLOR;
     else  if ( VPInfoBuf[4] == '1' )  VP[VPID].BackgrndColor = BLUCOLOR;
     else  if ( VPInfoBuf[4] == '2' )  VP[VPID].BackgrndColor = MAGCOLOR;
     else  if ( VPInfoBuf[4] == '3' )  VP[VPID].BackgrndColor = REDCOLOR;
     else  if ( VPInfoBuf[4] == '4' )  VP[VPID].BackgrndColor = WHICOLOR;
     else  if ( VPInfoBuf[4] == '6' )  VP[VPID].BackgrndColor = CYACOLOR;
     else  if ( VPInfoBuf[4] == '7' )  VP[VPID].BackgrndColor = GRECOLOR;
     else  if ( VPInfoBuf[4] == '8' )  VP[VPID].BackgrndColor = YELCOLOR;

     if       ( VPInfoBuf[5] == '0' )  VP[VPID].TextColor = BLACOLOR;
     else  if ( VPInfoBuf[5] == '1' )  VP[VPID].TextColor = BLUCOLOR;
     else  if ( VPInfoBuf[5] == '2' )  VP[VPID].TextColor = MAGCOLOR;
     else  if ( VPInfoBuf[5] == '3' )  VP[VPID].TextColor = REDCOLOR;
     else  if ( VPInfoBuf[5] == '4' )  VP[VPID].TextColor = WHICOLOR;
     else  if ( VPInfoBuf[5] == '6' )  VP[VPID].TextColor = CYACOLOR;
     else  if ( VPInfoBuf[5] == '7' )  VP[VPID].TextColor = GRECOLOR;
     else  if ( VPInfoBuf[5] == '8' )  VP[VPID].TextColor = YELCOLOR;

     sw_att( COLOR( VP[VPID].TextColor, VP[VPID].BackgrndColor ), VP[VPID].Ptr );
     ms_clratt( COLOR( VP[VPID].TextColor, VP[VPID].BackgrndColor ), VP[VPID].Buf );
     v_chattrow( 0, 0, ' ', COLOR( VP[VPID].TextColor, VP[VPID].BackgrndColor ),
                 ENDWN, ATT, VP[VPID].Ptr );

     VP[VPID].yOrg   = ( VPInfoBuf[6]-'0'  ) * 100 + ( VPInfoBuf[7]-'0'  ) * 10 +
                       ( VPInfoBuf[8]-'0'  );
     VP[VPID].Height = ( VPInfoBuf[12]-'0' ) * 100 + ( VPInfoBuf[13]-'0' ) * 10 +
                       ( VPInfoBuf[14]-'0' );

     if ( VPID == STAVP ) {

        VP[STAVP].Width = CountSTAVPWidth();
        VP[STAVP].xOrg  = 80 - VP[STAVP].Width;

     } else {
        VP[VPID].Width = (VPInfoBuf[15]-'0')*100+(VPInfoBuf[16]-'0')*10+(VPInfoBuf[17]-'0');
        VP[VPID].xOrg  = (VPInfoBuf[9]- '0')*100+(VPInfoBuf[10]-'0')*10+(VPInfoBuf[11]-'0');
     }
     wn_mod_no_pre_wn_unset( VP[VPID].yOrg, VP[VPID].xOrg, VP[VPID].Height, VP[VPID].Width, VP[VPID].Ptr );
 }

 if ( STAVPIsUp || DATVPIsUp ) {
    if (TopVP >= BREVP) sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
    else sw_bdr( &TopLeftVPBdr, VP[CODVP].Ptr );
    if ( STAVPIsUp )  VP[CODVP].Width = VP[REGVP].Width - VP[STAVP].Width;
    else  VP[CODVP].Width = VP[REGVP].Width - VP[DATVP].Width;
    wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
 }
 else if (TopVP >= BREVP) sw_bdr( &MiddleVPBdr, VP[CODVP].Ptr );
 else sw_bdr( &TopVPBdr, VP[CODVP].Ptr );


 if ( ( TopVP >= BREVP && (wn_up( VP[TopVP].Ptr ) == 0 ) ) ||
      ( wn_up( VP[CODVP].Ptr ) == 0 ) || ( wn_up( VP[COMVP].Ptr ) == 0 ) ||
      ( STAVPIsUp && ( wn_up( VP[STAVP].Ptr ) == 0 ) ) ||
      ( DATVPIsUp && ( wn_up( VP[DATVP].Ptr ) == 0 ) ) )
    return( FALSE );
 else  return( TRUE );

}  /*  of ReadVPInfoFromUSD3SAV()  */

/**************************************************************************
**
** Name : ReadSoftKeyFromUSD3SAV()
**
** Function : read softkey definitions from "SDLAYOUT.SAV"
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ReadSoftKeyFromUSD3SAV()
{
 char  c[2];
 int   i;

 lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );

 for ( i = 0; i <= 9; i++ ) {
     read( USD3SAVFileHan, c, 1 );
     read( USD3SAVFileHan, SoftKeyBuf[i], SOFTKEYBUFSIZE );
     SoftKeyBuf[i][ SOFTKEYBUFSIZE ] = '\0';
 }

}  /*  of ReadSoftKeyFromUSD3SAV()  */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

CmdHelpWnToggle(KEYCTRLPTR kcp )
{
int iX,iY;      // iX --- row; iY --- column

// set the ALT_F8 flag
    isAF8 = 1;

// adjust the prompt position at COMVP
    csr_plwn(VP[COMVP].Ptr);
    csr_rd(&iY, &iX);
    if ( iY <= CmdHelpWnp->re ) {
        csr_mvwn( CmdHelpWnp->re-VP[COMVP].Ptr->rb+2, 0, VP[COMVP].Ptr );
        DisplayPrompt(FALSE);
    }
    csr_plwn(CmdHelpWnp);

// exit the CmdHelp window
  k_exit( kcp );

  return ( TRUE );

}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

SingleCmdHelp(KEYCTRLPTR kcp )
{
  char rowBuf[80], keyWord[30], c, *ptr, *msg;
  int cnt, rowq;

  if (!CmdHelpWnp || !wn_isup( CmdHelpWnp )) return TRUE;
    if ( sCmdHelpWnp ) {
        return ( TRUE );
    }

    memset( rowBuf, NULL, sizeof(rowBuf) );
  v_stcpy( rowBuf, FROM_WN, ROW, CmdHelpWnp );

  if (((c=rowBuf[0]) >= 'A' ) && (c <= 'Z')) {
     if ((ptr = strchr(rowBuf, ' ')) != NULL)  *ptr = '\0';
     for ( cnt=0; cnt<= C_DOSA; cnt++ ) {
        if ( stricmp(rowBuf, cmdRecord[ cnt ].cmdText) == NULL ) {
           if (sCmdHelpWnp != NULLP ) CloseHelpWindows( 1 );
           sprintf(keyWord,"*%s,", cmdRecord[ cnt ].cmdText );
           if ( ( sCmdMFilePtr = mf_def( CMDMFILEMAXROW, 60) ) == NULLP )  {
              HelpWindowError( MEM_INSUFFICIENT );
              return( FALSE );
           }
           // added by Chen, 07/08/94
           _searchenv("MV86HLPC.TXT", "MV186", sdHlpFileName);
           if ( mf_rd( sdHlpFileName, sCmdMFilePtr ) == 0 ) {
              if ( VV_ERR == ERROPEN )  HelpWindowError( SD86HLPC_TXT_OPEN_ERR);
              else HelpWindowError( MEM_INSUFFICIENT );
              return( FALSE );
           }
           if (!mf_kwdload(keyWord, sCmdMFilePtr) || !mf_kwdset(keyWord, sCmdMFilePtr)) {
              HelpWindowError( MEM_INSUFFICIENT );
              return( FALSE );
           }
           rowq = mf_rowq( sCmdMFilePtr )+2;
           if (rowq > 12 ) rowq = 12;
           if ( ( sCmdHelpWnp = wn_def( 2, 9, rowq, 63, LBLA_BRO, BDR_DLNP ) ) == NULLP ) {
              ErrorCondition = MEM_INSUFFICIENT;
              return( FALSE );
           }
           sw_sb(AUTOUPD,VSBAR,sCmdHelpWnp);
           sw_mgcol( 1, 1, sCmdHelpWnp );
#ifndef NEC_PC9801
           sw_updnfp( wn_expset, wn_expunset, sCmdHelpWnp );
#endif
           sw_mf( sCmdMFilePtr, sCmdHelpWnp );
           if (sCmdHelpWnp && !wn_isup( sCmdHelpWnp )) wn_up( sCmdHelpWnp );
           if (sCmdHelpWnp && wn_isup( sCmdHelpWnp )) {
              msg= " Cursor keys to scroll, <ESC> Quit, <Alt-F8> Toggle HELP/Input";
              return( BrowseHelpWindow( &sCmdHelpWnp, &sCmdMFilePtr, msg ) );
           }
        }
     }
  }
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
BrowseHelpWindow(WINDOWPTR *wnp, MFILEPTR *mfp, UCHAR *msg )
{
 WINDOWPTR msgwnp;
 KEYFP tmpAF8;

   msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
   wn_up(msgwnp);
   v_st( msg, msgwnp );
   tmpAF8 = kt_rplkey(KEY_AF8,(KEYFP)CmdHelpWnToggle ,VIEWKTP);
   isAF8 = 0;
   if (*wnp && wn_isup( *wnp )) mf_browse( *wnp );
   kt_rplkey(KEY_AF8,(KEYFP)tmpAF8 ,VIEWKTP);
   wn_dn(msgwnp);
   wn_free(msgwnp);
   if (isAF8) return( FALSE );
   if (wn_isup( *wnp )) wn_dn( *wnp );
   if ( *mfp ) mf_free( *mfp );
   if ( *wnp ) wn_free( *wnp );
   *wnp = NULLP;
   *mfp = NULLP;
   return TRUE;
}

/**************************************************************************
**
** Name : DisplayHelp
**
** Function :
**
**    Input  : Flag 0: Create file; diplay single cmd HELP Window
**                  1: Create file; display HELP Summery
**                  2: not create file; display HELP
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayHelp(int flag)
{
   KEYFP tmpF1;
   UCHAR *msg;
   int retcode;

   if (flag < 2) {
      if (!(retcode=CreateHelpMemFile(flag))) return FALSE;
   }
   if ((cmdIdx < 0 ) || (flag)) {   /* Summery */
      msg = " Cursor keys to scroll <ESC> Quit <F1> Help <A-F8> Toggle Help/Input";
      tmpF1 = kt_rplkey(KEY_F1,(KEYFP)SingleCmdHelp, VIEWKTP);
      actF1 = 1;
   }
   else {
      msg= " Cursor keys to scroll, <ESC> Quit, <Alt-F8> Toggle HELP/Input";
      actF1 = 0;
   }
   if (CmdHelpWnp && !wn_isup( CmdHelpWnp )) wn_up( CmdHelpWnp );
   retcode = BrowseHelpWindow( &CmdHelpWnp, &CmdMFilePtr, msg );
   kt_rplkey(KEY_F1,(KEYFP)tmpF1, VIEWKTP);
   return retcode;

}  /*  of DisplayHelp()  */

/**************************************************************************
**
** Name : CreateHelpMemFile
**
** Function :
**
**    Input  : flag - 0: single command; 1:summery
**    Output :
**
** Notes:
**
**************************************************************************/
CreateHelpMemFile(int flag)
{
 int rowq, colq, maxCol, errCode;
 char keyWord[30], temp[30], title[30];

   if (CmdHelpWnp != NULLP ) CloseHelpWindows( 2 );
   if ((cmdIdx < 0 ) || (flag)) {   /* Summery */
      colq = vs_colq()-7;
      maxCol = vs_colq();
//      fileName = "SD86HLPS.TXT";
      _searchenv("MV86HLPS.TXT", "MV186", sdHlpFileName);   // Chen 07/08/94
      strcpy( keyWord, "*MICE_SD_HELPSUMMARY,");
      errCode = SD86HLPS_TXT_OPEN_ERR;
   }
   else {                          /* Single Command */
      colq = 64;
      maxCol = 64+2;
//      fileName = "SD86HLPC.TXT";
      _searchenv("MV86HLPC.TXT", "MV186", sdHlpFileName);   // Chen 07/08/94
      errCode = SD86HLPC_TXT_OPEN_ERR;
      sprintf(keyWord,"*%s,", cmdRecord[ cmdIdx ].cmdText );
   }
   if ( (CmdMFilePtr = mf_def( CMDMFILEMAXROW, maxCol) ) == NULLP )  {
      HelpWindowError( MEM_INSUFFICIENT );
      return( FALSE );
   }
   if ( mf_rd( sdHlpFileName, CmdMFilePtr ) == 0 ) {
      if ( VV_ERR == ERROPEN )  HelpWindowError( errCode );
      else HelpWindowError( MEM_INSUFFICIENT );
      return( FALSE );
   }
   if (!mf_kwdload(keyWord, CmdMFilePtr) || !mf_kwdset(keyWord, CmdMFilePtr)) {
      HelpWindowError( KEYWORD_NOT_FOUND );
      return( FALSE );
   }
   rowq = mf_rowq( CmdMFilePtr )+2;
   if (rowq > 14 ) rowq = 14;
   if ( ( CmdHelpWnp = wn_def( 1, 4, rowq, colq, LBLA_WHI, BDR_DLNP ) ) == NULLP ) {
      ErrorCondition = MEM_INSUFFICIENT;
      return( FALSE );
   }
   sw_title( " HELP ", LBLA_WHI, TOPCENTER, CmdHelpWnp );
   sw_sb(AUTOUPD,VSBAR,CmdHelpWnp);
   sw_mgcol( 1, 1, CmdHelpWnp );
/* CORE 90.08.014 */
#ifndef NEC_PC9801
// sw_updnfp( wn_expset, wn_expunset, CmdHelpWnp );
   sw_updnfp( wn_set, wn_unset, CmdHelpWnp );
#endif
   sw_mf( CmdMFilePtr, CmdHelpWnp );
   return( TRUE );
}
/**************************************************************************
**
** Name : HelpCmd
**
** Function : help command process
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

int HelpCmd()
{
  char temp[100];
  int row, maxRow;

  if ( cmd_syntax.argc ) {
     CreateHelpMemFile( 1 );  /* Create a mem. file for HELP summery */
     for ( row = 0; row < ( maxRow = mf_rowq( CmdMFilePtr )-1); row++ ) {
       InitArray( temp, 100, 0);
       mf_rowget( temp, row, CmdMFilePtr);
       st_toupper(temp);
       st_toupper(cmd_syntax.asc);
       if ( temp == strstr(temp, cmd_syntax.asc)) {
//     if ( strstr(temp, cmd_syntax.asc)) {
            sw_mforg( row, 0, CmdHelpWnp );
            break;
       }
     }
     if (row >= maxRow ) {
        prn_ferr( 66 );
        return;
     }
     DisplayHelp(2);  /* Display Summery without creating a file */
  }
  else DisplayHelp(1);  /* Create a File and Display Summery */
}  /*  of helpcmd()  */

/**************************************************************************
**
** Name : CloseHelpWindows
**
** Function :  Check if "Cmd Help Window" is up, if yes, remove it
**             and free the memory.
**    Input  : flag = 0:CmdHelpWnp, 1:sCmdHelpWnp, 2:Both
**
** Notes:
**
**************************************************************************/

CloseHelpWindows(int flag)
{
    isAF8 = 0;

  if (flag && ( sCmdHelpWnp != NULLP )) {
     if ( wn_isup( sCmdHelpWnp ) ) wn_dn( sCmdHelpWnp );
     if (sCmdMFilePtr) mf_free( sCmdMFilePtr );
     wn_free( sCmdHelpWnp );
     sCmdMFilePtr = NULLP;
     sCmdHelpWnp = NULLP;
  }
  if ((flag != 1) && ( CmdHelpWnp != NULLP )) {
     if ( wn_isup( CmdHelpWnp ) ) wn_dn( CmdHelpWnp );
     if (CmdMFilePtr) mf_free( CmdMFilePtr );
     wn_free( CmdHelpWnp );
     CmdMFilePtr = NULLP;
     CmdHelpWnp = NULLP;
  }
}  /* end of CloseHelpWindows */

/**************************************************************************
**
** Name : QuitCmd()
**
** Function :  USD-III command : QUIt
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

QuitCmd()
{
extern int      COMVPMax;

   if (!cmd_syntax.argc ) {
      if (!AbortUSD3()) {
         ShowCursor();
         return(FALSE);
      }
   }
   else if ( !COMVPMax && ( VerUSAV1() == TRUE ) )  UsaveCmd();
   DestroyVP();
   DestroyMenu();
   WmClose();
   FreeGbl();
   vs_clr();
   USD3vid_setmode( OldVideoMode );
   exit_vv();
   exit( 0 );
   return( TRUE );

}  /*  of quitcmd()  */


/**************************************************************************
**
** Name : VerUSAV1()
**
** Function
**
**        Input  :
**
**        Output :
**
** Notes:
**
**************************************************************************/

VerUSAV1()
{
DFORMPTR   DFormPtr;
DFIELDPTR  DFieldPtr;
char       DoUSAV[2];

   DoUSAV[0] = 'Y';
   DoUSAV[1] = '\0';

   DFormPtr  = fm_def( 10, 23, 5, 34, LWHI_RED, BDR_DLNP );
   DFieldPtr = fld_def( 1, 3, "Save screen and softkey? ", FADJACENT, "!", F_STRING, DoUSAV, DFormPtr );
   sf_attact( LRED_WHI, DFieldPtr );
   sf_attinact( LWHI_RED, DFieldPtr );

   sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );

   if ( fm_proc( 0, DFormPtr ) == AC_QUIT ) {

          fm_free( DFormPtr );
          return( FALSE );
   }

   fm_free( DFormPtr );

   if ( DoUSAV[0] == 'Y' )  return( TRUE );
   else return( FALSE );

}  /*  of VerUSAV1()  */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
HelpWindowError( int errCode)
{
   DFORMPTR   DFormPtr;
   DFIELDPTR  DFieldPtr;
   char       anyKey[2], *errMsg;
   extern int  COMVPMax;
   int save_pulldown_or_dialog, i;

   switch ( errCode ) {
     case MEM_INSUFFICIENT :
          errMsg = "Insufficient memory to activate HELP window!";
          break;
     case SD86HLPS_TXT_OPEN_ERR:
          errMsg = "MV86HLPS.TXT open error!";
          break;
     case SD86HLPC_TXT_OPEN_ERR:
          errMsg = "MV86HLPC.TXT open error!";
          break;
     case KEYWORD_NOT_FOUND:
          errMsg = "No available HELP information in \"MV86HLPC.TXT\"!";
          break;
     defult : return;
   }
   // memset(anyKey, NULL, 2);
   // changed by Chen, 07/25/94
   anyKey[0] = '!';
   anyKey[1] = NULL;
   DFormPtr  = fm_def( 10, 10, 6, 60, LWHI_RED, BDR_DLNP );
   bg_txtdef( 1, 5, errMsg, LWHI_RED, DFormPtr );
   DFieldPtr = fld_def( 2, 5, "Press <CR> or <ESC> to continue ... ", FADJACENT, "!", F_STRING, anyKey, DFormPtr );
   if (DFieldPtr == NULLP) return (FALSE);
   sf_attact( LRED_WHI, DFieldPtr );
   sf_attinact( LWHI_RED, DFieldPtr );
   sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );

   save_pulldown_or_dialog = pulldown_or_dialog;
   pulldown_or_dialog = DIALOG;
   special_dialog = 1;
   // added by Chen, 07/25/94
   anyKey[0] = '!';
   i = fm_proc( 0, DFormPtr );
   fm_free( DFormPtr );
   pulldown_or_dialog = save_pulldown_or_dialog;
   special_dialog = 0;
}  /*  of HelpWindowError()  */


/**************************************************************************
**
** Name : MonitorCmd
**
** Function : MONitor command for data watch in the DATA-viewport
**
** Syntax :   [[%%module]%symbol|addr [number] [Byte|Word|Long]]
** Notes:
**  no argument : argc = 0;
**
**  argc=3; argv[0]= number, argv[1] = Byte/Word/Long(0/1/2), argv[2] = type,
**          argv[3]= isLocal(0/1/2), argv[4] = localBlkAddr, asc = %%module
**  addr filled in struct addr_form
**
**************************************************************************/

MonitorCmd()
{
char  *Ptr;
char  Addr[15];
int   Count, i;
unsigned long addr, absAddr;
unsigned int  type=0;
extern int      COMVPMax;

   if ( cmd_syntax.argc == 0 )  goto MonEnd;

   if ( MonVPfull || MonVarCount >= DATBUFROW)  { prn_ferr(32); return; }

/*** Get total count and type ***/
   if (cmd_syntax.argv[0] > 0x100L) Count = 0x100;
   else Count = (int)cmd_syntax.argv[0];

   type = (unsigned int)cmd_syntax.argv[2];

/*** Get symbol and address ***/
   if (addr_form.symFlag != 0)  addr = addr_form.addr; // is symbol
   else {
      if (addr_form.csFlag != 0)  addr = addr_form.addr;  // hex data
      else {
          emuGetReg(I86_REG, CS,&addr);
          addr = (addr << 16) + addr_form.addr;
      }
      GetSymByAddr(0, addr, addr_form.sym, &type);
   }

   sprintf( Addr, "%04X:%04X", (U16)(addr >> 16), (U16)addr);


/*** Fill MonVar[] ***/
   strncpy(MonVar[MonVarCount].Sym, addr_form.sym, sizeof(MonVar[MonVarCount].Sym) - 1);
   MonVar[MonVarCount].Sym[sizeof(MonVar[MonVarCount].Sym)-1] = '\0';
   strcpy(MonVar[MonVarCount].Addr, Addr);
   MonVar[MonVarCount].Type = type;
   MonVar[MonVarCount].Count = Count;
   MonVar[MonVarCount].Format = (char)cmd_syntax.argv[1];
   MonVar[MonVarCount].isLocal = (char)cmd_syntax.argv[3];
   MonVar[MonVarCount].blkAddr = (unsigned long)cmd_syntax.argv[4];
   MonVarCount++;
   RedrawFlag = REDRAWDAT;



MonEnd :

   if ( wn_isup( VP[DATVP].Ptr ) )  return;
   else {
      if ( COMVPMax )  return( TRUE );
      if ( wn_isup( VP[STAVP].Ptr ) ) {
         wn_dn( VP[STAVP].Ptr );
         VP[CODVP].Width = VP[REGVP].Width - VP[DATVP].Width;
         // added by Chen 06/06/94
        if ( TopVP == -1 ) {
            sw_bdr( &TopLeftVPBdr, VP[CODVP].Ptr );
            sw_bdr( &TopRightVPBdr, VP[DATVP].Ptr );
        }
        else {
            sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
            sw_bdr( &RightVPBdr, VP[DATVP].Ptr );
        }
         wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg,
                        VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
         v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
         wn_up( VP[DATVP].Ptr );
         if ( ! (MaskRedrawFlag & REDRAWDAT) )   UpdateDATVP();
         if ( ActVP == STAVP ) {
            VP[STAVP].Ptr->titleatt = LVPTITLEINACT;
            ActVP = DATVP;
            VP[DATVP].Ptr->titleatt = LVPTITLEACT;
            v_titleatt( NULLP, LVPTITLEACT, VP[DATVP].Ptr );
         }
      }
      else {
         VP[CODVP].Width = VP[REGVP].Width - VP[DATVP].Width;
         // added by Chen 06/06/94
        if ( TopVP == -1 ) {
            sw_bdr( &TopLeftVPBdr, VP[CODVP].Ptr );
            sw_bdr( &TopRightVPBdr, VP[DATVP].Ptr );
        }
        else {
            sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
            sw_bdr( &RightVPBdr, VP[DATVP].Ptr );
        }
         wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg,
                    VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
         v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
         wn_up( VP[DATVP].Ptr );
      }
      return;
   }
}  /*  of monitorcmd()  */


/**************************************************************************
**
** Name : NomonitorCmd()
**
** Function : NOMonitor command
**
**    Input  :
**
**    Output :
**
** Notes:       modified by Chen, 05/21/94
**
**************************************************************************/
NomonitorCmd(long min, long max)
{
long i;
int tmpVP;

// no any variable monitored
    if ( MonVarCount == 0 ) {
        tmpVP = VPOut;
        VPOut = COMVP;
        DisplayStr( " No any monitored variables ! \n\r");
        VPOut = tmpVP;
        return;
    }

// no number gived: clear all monitor information
   if (cmd_syntax.argc == 0) {
      MonVarCount = 0;
      RedrawFlag = REDRAWDAT;
      return;
   }

// large than 2 numbers or less than 0 number
    if ( cmd_syntax.argc > 2 || cmd_syntax.argc < 0 ) {
        tmpVP = VPOut;
        VPOut = COMVP;
        DisplayStr( " Variable number is incorrect ! \n\r");
        VPOut = tmpVP;
        return;
    }

// input only 1 number
    if ( cmd_syntax.argc == 1 ) {
        if ( min<1 || min>MonVarCount ) {
            tmpVP = VPOut;
            VPOut = COMVP;
            DisplayStr( " Variable number is incorrect ! \n\r");
            VPOut = tmpVP;
            return;
        }
        max = min;
    }

// start number is large than end number
    if ( min > max ) {
        tmpVP = VPOut;
        VPOut = COMVP;
        DisplayStr( " Variable number is incorrect ! \n\r");
        VPOut = tmpVP;
        return;
    }

// start number less than 1 or end number large than MonVarCount, error
    if ( min < 1 || max > MonVarCount ) {
        tmpVP = VPOut;
        VPOut = COMVP;
        DisplayStr( " Variable number is incorrect ! \n\r");
        VPOut = tmpVP;
        return;
    }


/*
// Chen 05/26/94
// The below processing is based on user friendly, but now they are buggers!
// So I must reamrk them.

// swap min and max
    if ( min > max ) {
        i = min;
        min = max;
        max = i;
    }

// check range
    if ( max < 1 || min > MonVarCount ) {
        tmpVP = VPOut;
        VPOut = COMVP;
        DisplayStr( " Variable number is incorrect ! \n\r");
        VPOut = tmpVP;
        return;
    }

// user friendly
   if (min < 1)  min = 1;
   if (max > MonVarCount)  max = MonVarCount;

*/


/* Rearrange MonVar[] */
    memcpy( &MonVar[min - 1], &MonVar[max],
            sizeof(MonVar[0]) * (MonVarCount - max) );
   MonVarCount -= (max - min + 1);
   RedrawFlag = REDRAWDAT;
   return;

}  /*  of NomonitorCmd()  */


/**************************** End of File **********************************/

