/***************************************************************************
**
** File name : vvsource.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/
#include  "system.h"
#include  "menu.h"
#include  "usd3.h"
#include  "funcext.h"


/**************************************************************************
**
** Local define
**
***************************************************************************/


/**************************************************************************
**
** Global variables
**
***************************************************************************/

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern struct VPtag  VP[];

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  original function name : v_bdr()                   */

void FASTCALL  v_bdr_csr_plwn(bdrp, wnp)
BORDERPTR bdrp;                         /*pointer to border structure         */
WINDOWPTR wnp;                          /*pointer to window structure         */
{
    UCHAR att;
    ULONG flags;                        /*window flags                        */
    int rt, ct;                         /*temporary storage                   */
    register int col_q, row_q;          /*column and row quantities           */
    UCHAR * title;                      /*window title pointer                */
    int len;                            /*length of window title              */
    int sbflag;            /*scroll bar drawing flag         */
#ifndef NO_DEBUG_CODE
    UCHAR * fn = (UCHAR *) "v_bdr_csr_plwn";
#endif

    INIT_MODULE(fn);

   if (!bdrp)                     /*draw no border               */
        goto END_v_bdr_csr_plwn;

   rt = wnp->r;                  /*save initial values            */
    ct = wnp->c;
   flags = wnp->flags;             /*avoid indirection             */

   wnp->flags &= ~BUFFERED;         /*set window temporarily to direct */

   if (flags & INSIDE)             /*window must be FULL to correctly */
      sw_dim(FULL, wnp);            /*draw border                  */

    col_q = wn_colq(wnp);
    row_q = wn_rowq(wnp);
    att = wnp->bdratt;


                                        /* top left corner                    */
    v_chattrow(0, 0, bdrp->uplft_ch, att, 1, CHATT, wnp);

                              /* top border             */
    v_chattrow(0, 1, bdrp->up_ch, att, col_q - 2, CHATT, wnp);

                              /* top right corner        */
    v_chattrow(0, col_q - 1, bdrp->uprt_ch, att, 1, CHATT, wnp);

                              /* left side border        */
    v_chattcol(1, 0, bdrp->lft_ch, att, row_q - 2, CHATT, wnp);

                              /* bottom left corner       */
    v_chattrow(row_q - 1, 0, bdrp->lowlft_ch, att, 1, CHATT, wnp);


               /* initialize flag to draw everything */
    sbflag = NO_SBARCORNER | NO_HSBAR | NO_VSBAR;

   if ((flags & HVSBAR))         /*draw the scroll bars          */
        sbflag = wn_sbdraw(wnp);

   if ((sbflag & NO_HSBAR))      /* bottom border             */
        v_chattrow(row_q - 1, 1, bdrp->low_ch, att, col_q - 2, CHATT, wnp);

    if ((sbflag & NO_SBARCORNER))       /* bottom right corner                */
        v_chattrow(row_q - 1, col_q - 1, bdrp->lowrt_ch, att, 1, CHATT, wnp);

    if ((sbflag & NO_VSBAR))       /* right side border                  */
        v_chattcol(1, col_q - 1, bdrp->rt_ch, att, row_q - 2, CHATT, wnp);

    att = wnp->titleatt;

    if (title = wnp->title)      /*if window title is present          */
    {
        len = min((int) strlen(title), col_q - 4);
                                        /*truncate title if too long          */
        if (len > 0)
        {
            switch (wnp->titleloc)      /*determine where to place title      */
            {
                default:
                case TOPLEFT:
                    cs_mv(0, 2, wnp);
                    break;
                case TOPCENTER:
                    cs_mv(0, (col_q - len) / 2, wnp);
                    break;
                case TOPRIGHT:
                    cs_mv(0, col_q - len - 2, wnp);
                    break;
                case BOTTOMLEFT:
                    cs_mv(row_q - 1, 2, wnp);
                    break;
                case BOTTOMCENTER:
                    cs_mv(row_q - 1, (col_q - len) / 2, wnp);
                    break;
                case BOTTOMRIGHT:
                    cs_mv(row_q - 1, col_q - len - 2, wnp);
                    break;
            }
                              /* write the text            */
            _v_strow(title, att, len, STATT, wnp);
        }
    }

    wnp->c = ct;
   wnp->r = rt;                  /*restore cs to home position   */

   if (flags & INSIDE) sw_dim(INSIDE, wnp);  /* restore inital dimension */

   if (flags & BUFFERED)  wnp->flags |= BUFFERED;   /*restore buffered mode       */

END_v_bdr_csr_plwn:
    EXIT_NOERRH(fn);

    if ( wnp == VP[COMVP].Ptr )  csr_plwn( VP[COMVP].Ptr );

    return;

}  /*  of v_bdr_csr_plwn()  */


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  modified from v_bdr()                           */

/*  title == NULLP : use original title
    att   == 0     : use original att    */

v_titleatt( UCHAR *title, UCHAR att, WINDOWPTR wnp )
{
    ULONG flags;                        /*window flags                        */
    int rt, ct;                         /*temporary storage                   */
    register int col_q, row_q;          /*column and row quantities           */
    int len;                            /*length of window title              */
    BORDERPTR bdrp;                     // ptr to border

    rt = wnp->r;                        /*save initial values                 */
    ct = wnp->c;
    flags = wnp->flags;                 /*avoid indirection                   */
    bdrp = wnp->bdrp;                   // pointer to window border

    wnp->flags &= ~BUFFERED;            /*set window temporarily to direct    */

    if (flags & INSIDE)                 /*window must be FULL to correctly    */
        sw_dim(FULL, wnp);              /*draw border                         */

    col_q = wn_colq(wnp);
    row_q = wn_rowq(wnp);

    if ( title == NULLP )  title = wnp->title;
    else v_chattrow(0, 1, bdrp->up_ch, wnp->bdratt, col_q - 2, CHATT, wnp);
    if ( title )         /*if window title is present          */
    {
      len = min((int) strlen(title), col_q - 4); /*truncate title if too long        */
        if (len > 0)
        {
            switch (wnp->titleloc)      /*determine where to place title      */
            {
                default:
                case TOPLEFT:
                    cs_mv(0, 2, wnp);
                    break;
                case TOPCENTER:
                    cs_mv(0, (col_q - len) / 2, wnp);
                    break;
                case TOPRIGHT:
                    cs_mv(0, col_q - len - 2, wnp);
                    break;
                case BOTTOMLEFT:
                    cs_mv(row_q - 1, 2, wnp);
                    break;
                case BOTTOMCENTER:
                    cs_mv(row_q - 1, (col_q - len) / 2, wnp);
                    break;
                case BOTTOMRIGHT:
                    cs_mv(row_q - 1, col_q - len - 2, wnp);
                    break;
            }
                              /* write the text      */
            if ( att == 0 )  att = wnp->titleatt;
            _v_strow(title, att, len, STATT, wnp);
        }
    }

    wnp->c = ct;
   wnp->r = rt;                  /*restore cs to home position   */

   if (flags & INSIDE) sw_dim(INSIDE, wnp); /*restore inital dimension */

    if (flags & BUFFERED)               /*restore buffered mode               */
        wnp->flags |= BUFFERED;

    if ( wnp == VP[COMVP].Ptr )  csr_plwn( VP[COMVP].Ptr );
    return;

}  /*  of v_titleatt()  */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

/*  original function name : wn_mod()                   */

int FASTCALL  wn_mod_no_pre_wn_unset(rb, cb, rowq, colq, wnp)
int rb;
int cb;
int rowq;
int colq;
WINDOWPTR wnp;
{
    ULONG flags;                        /* window flags                       */
    ULONG dimflags;                     /* flags storing the working dim      */
    SCRPTR wrscrp;                      /* screen pointer for writing         */
    SCRPTR destp;                       /* destination screen pointer         */
    int retval = 0;                     /* return value                       */
#ifndef NO_DEBUG_CODE
    UCHAR * fn = (UCHAR *) "wn_mod_no_pre_wn_unset";
#endif

    INIT_MODULE(fn);

   flags = wnp->flags;             /*save window flags            */

    dimflags = wnp->flags;
   sw_dim(FULL, wnp);               /*work on full dimensions        */
    destp = wnp->destp;

   if (rb == CENTER_WN) rb = (vs_rowq() - rowq) / 2; /*Take care of #defined arguments */

   if (cb == CENTER_WN) cb = (vs_colq() - colq) / 2;

   wnp->rb = max(rb, 0);            /*modify the window coordinates   */
    wnp->cb = max(cb, 0);
    wnp->re = min(rb + rowq - 1, destp->row_q - 1);
    wnp->ce = min(cb + colq - 1, destp->col_q - 1);

   if (dimflags & INSIDE) sw_dim(INSIDE, wnp); /*change dimensions back */

    if (flags & BUFFERED)
    {
      wrscrp = wnp->bufp;       /*modify origin if necessary   */
        wnp->row_org = min(wnp->row_org, wrscrp->row_q - wn_rowq(wnp));
        wnp->col_org = min(wnp->col_org, wrscrp->col_q - wn_colq(wnp));
#ifndef NO_DEBUG_CODE
        if (wnp->col_org < 0 || wnp->row_org < 0)
      {                        /*window too big            */
            VV_ERR = WNTOOBIG;
            goto END_wn_mod_no_pre_wn_unset;
        }
#endif
    }

    if (flags & SET)                    /*set the window if it was up before  */
        if (!wn_set_no_pre_wn_clr(wnp))
            goto END_wn_mod_no_pre_wn_unset;

   retval = 1;                   /*set successful return       */

END_wn_mod_no_pre_wn_unset:
#ifndef NO_DEBUG_CODE
    EXIT_MODULE(fn);
#else
    EXIT_NOERRH(fn);
#endif

    if ( wnp == VP[COMVP].Ptr )  csr_plwn( VP[COMVP].Ptr );

    return(retval);
}  /*  of wn_mod_no_pre_wn_unset()  */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

/*  original function name : wn_set()                   */

int FASTCALL  wn_set_no_pre_wn_clr(wnp)
WINDOWPTR wnp;                          /*pointer to window structure         */
{
    int r, c;                           /*cursor coordinates                  */
    int rb, re, cb, ce;                 /*full dimensions                     */
    int retval = 0;
    ULONG flags;                        /*window flags                        */
    BORDERPTR bdrp;                     /*pointer to border structure         */
#ifndef NO_DEBUG_CODE
    UCHAR * fn = (UCHAR *) "wn_set_no_pre_wn_clr";
#endif

    INIT_MODULE(fn);

   if (!_wn_setup(wnp))            /*if the window is not OK        */
      goto END_wn_set_no_pre_wn_clr;   /*return with an error           */

   flags = wnp->flags;             /*get current flags             */
   bdrp = wnp->bdrp;               /*initialize bdrp to window border */

   if (flags & BUFFERED)            /*set buffered window to direct    */
    {
      r = wnp->r;                /*save cursor coordinates         */
        c = wnp->c;
        wnp->flags &= ~BUFFERED;
    }
   if (flags & INSIDE) sw_dim(FULL, wnp); /* do checks on full window */

   rb = wnp->rb;                  /*save full dimensions            */
    re = wnp->re;
    cb = wnp->cb;
    ce = wnp->ce;

   wnp->flags &= ~VSECHO;            /*turn updating off       */

    v_bdr(bdrp, wnp);       /*draw the border                     */

   sw_dim(INSIDE, wnp);            /*adjust dimensions to inside */
   wnp->flags |= SET;               /*window is now set         */

    if (flags & BUFFERED)
    {
      wnp->flags |= BUFFERED;
      wnp->r = r;                /*restore cursor coordinates */
        wnp->c = c;
        wn_upd(wnp);
    }

   if (flags & VSECHO)          /*if VSECHO was originally ON     */
    {
      wnp->flags |= VSECHO;         /*turn it back ON           */
      if (VID_ECHO)               /*update if globally enabled  */
            vs_updrgn(rb, cb, re, ce);
    }

    if (!shad_up(wnp))         /* display shadows            */
       goto END_wn_set_no_pre_wn_clr;

    retval = 1;                         /*non-zero return if successful       */

END_wn_set_no_pre_wn_clr:
#ifndef NO_DEBUG_CODE
    EXIT_MODULE(fn);
#else
    EXIT_NOERRH(fn);
#endif
    return(retval);

}  /*  of wn_set_no_pre_wn_clr()  */


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
// /*  cl_rd.c                           */
// /*  cl_rd.c
//
//     ************* Copyright 1988 by Vermont Creative Software **************
//
// cl_rd()
// Passes control to the user for selecting from the choice list
//
// Call
//
// #include <vv_clist.h>
//
// int cl_rd(start_item, clistp)
// int start_item;         Choice list item to be initially highlighted
// CLISTPTR clistp;       Choice list to read
//
// Returns
//
// AC_EXIT    The user made a choice from the choice list.
//
// AC_QUIT    The user quit without choosing an item from the choice list.
//
// 0       Error.  VV_ERR is set to one of the following:
//
//          KWDNOTFOUND   The keyword marking the choice list was not
//                     found in the memory file.
//          MEMLACK      There is insufficient memory to allocate the
//                     underlying screen image.
//
// Description
//
// Before calling cl_rd(), the choice list must be displayed on the video
// screen.
//
// cl_rd() calls mf_kwdset() to set the memory file to operate within
// the appropriate keyword section.  The memory file is then redisplayed
// within the window to ensure that the starting item is visible.  The
// keyboard is then scanned for user input and processed using the
// choice list keytable CLKTP.
//
// The user may move up or down in the choice list, quit, or select an
// item.  If the user selects an item, the number of the item selected
// is transferred to the item number member of the choice list structure
// and AC_EXIT is returned.  If the user quits, the current item number
// member is left unchanged, and AC_QUIT is returned.
//
// Related Functions
//
// cl_dn(), cl_proc(), cl_up()
//
// */
//
// /*  #include <vv_clist.h>  */

int FASTCALL cl_rd(start_item, clistp)
int start_item;
CLISTPTR clistp;
{
    int retval = 0;                     /*default return value (error)        */
    int key;                            /*keycode                             */
    int keyret;                         /*return value from kt_proc()         */
    int row_high;                       /*currently highlighted row           */
    int row_org;                        /*previous window coordinates in mf   */
    int r;                              /*previous virtual cursor row         */
    int row_q;                          /*#of rows in window                  */
    int len;                            /*length of highlight                 */
    WINDOWPTR wnp;                      /*variables to avoid indirection      */
    MFILEPTR mfp;
    UCHAR act_att;
    UCHAR inact_att;
    UCHAR * mfkwdp;                     /*temporary storage                   */
    UCHAR * kwdp;
    int titemnum;
    int tr, tc;
#ifndef NO_DEBUG_CODE
    UCHAR * fn = (UCHAR *) "cl_rd";
#endif

    INIT_MODULE(fn);

    wnp = clistp->wnp;                  /*avoid indirection                   */
    inact_att = wnp->att;
    act_att = clistp->act_att;
    mfp = wnp->mfp;
    kwdp = clistp->kwdp;
    len = clistp->len;
    row_q = wn_rowq(wnp);               /*avoid repeated calculation          */
    mfkwdp = mfp->kwdp;                 /*save old keyword                    */
    csr_rd(&tr, &tc);                   /*save the physical cursor position   */
    csr_mv(vs_rowq(), 0);               /*hide the cursor                     */

#ifndef NO_DEBUG_CODE
    if (clistp->tag != CL_TAG)          /*check the tag                       */
    {
        VV_ERR = BADCLSTRUC;
        _dbdumpp = (UCHAR *)clistp;
        goto END;
    }
#endif

    if (!(mf_kwdset(kwdp, mfp)))        /*change memory file keyword info     */
        goto END;

#ifndef NO_DEBUG_CODE
    if (start_item < 0 || start_item >= mfp->vln_q)
    {
        VV_ERR = BADCLITEM;
        goto END;
    }
#endif

    if (start_item < wnp->row_org ||    /*if active item not already visible  */
        start_item >= wnp->row_org + row_q)
    {                                   /*make it visible                     */
        if (start_item < row_q)
            wnp->row_org = 0;
        else if (mfp->vln_q - start_item < row_q)
            wnp->row_org = mfp->vln_q - row_q;
        else
            wnp->row_org = start_item;
    }

    wnp->r = start_item - wnp->row_org; /*move virtual cursor to active item  */
    clistp->nextact = AC_CONTINUE;
    row_high = FALSE;
    titemnum = clistp->itemnum;
    clistp->itemnum = start_item;

    mf_disp(wnp);                       /*display choice list                 */

    while (clistp->nextact != AC_EXIT && clistp->nextact != AC_QUIT)
    {
        if (!row_high)
        {
            v_attq(act_att, len, wnp);  /*highlight active row                */
            row_high = TRUE;
        }

        if (_csrvis)                    /*if cursor is not hidden             */
            csr_plwn(wnp);              /*place it on the current line        */

        key = CListKi(clistp);                     /*get a keystroke                     */
        LogInteraction( key );

        row_org = wnp->row_org;         /*save window position                */
        r = wnp->r;                     /*save virtual cursor's row           */
        clistp->nextact = AC_CONTINUE;  /*ensure nextact is not AC_NEXT       */

if (key < 500) {
        if ((keyret = kt_proc(key, SYSKTP, (PTR)clistp)) == -1)
            keyret = kt_proc(key, CLKTP, (PTR)clistp);
        if (!keyret)                    /*zero returned from the key function */
            goto END;
} else {
   key -= 500;
   wnp->r = key;
}

        wnp->col_org = 0;               /*force cursor to stay at column 0    */
        wnp->c = 0;
                                        /*if window origin moves              */
        if (clistp->nextact == AC_NEXT || row_org != wnp->row_org)
        {
            mf_disp(wnp);               /*redraw window                       */
            row_high = FALSE;
        }
        else if (r != wnp->r)           /*virtual cursor changed row          */
        {
                                        /*unhighlight old item                */
            v_chattrow(r, wnp->c, (UCHAR)0, inact_att, len, ATT, wnp);
            row_high = FALSE;
        }
               /*maintain the current item number    */
        clistp->itemnum = wnp->row_org + wnp->r;
    }

    if (row_high)                       /*unhighlight row if highlighted      */
        v_chattrow(r, wnp->c, (UCHAR)0, inact_att, len, ATT, wnp);

    if (clistp->nextact != AC_EXIT)     /*if user did not exited normally     */
                                        /*restore the original row            */
        clistp->itemnum = titemnum;

    retval = clistp->nextact;

END:
    mf_kwdset(mfkwdp, mfp);             /*restore keyword information         */
    csr_mv(tr, tc);                     /*restore cursor                      */

#ifndef NO_DEBUG_CODE
    EXIT_MODULE(fn);
#else
    EXIT_NOERRH(fn);
#endif
    return(retval);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
// /*  _fld_ed.c                           */
// /*  _fld_ed.c
//
//      ************* Copyright 1988 by Vermont Creative Software **************
//
// _fld_ed(fmp)
// Edits a data field, menu field or memo field
//
// Call
//
// #include <vv_form.h>
//
// int _fld_ed(fmp)
// FORMPTR fmp;          The form pointer
//
// Returns
//
// 1      Success
//
// 0      Error.  VV_ERR is set to the following:
//
//         MEMLACK      Insufficient memory to set the message window
//
//         or
//
//         a fatal error occurred in one of the user written functions.
//         That function is then responsible for setting VV_ERR.
//
// Description
//
// _fld_ed() is the field editor for menu fields and data fields.  It does not
// assume that the field being entered is a valid one, so it is not necessary
// for this check to be done ahead of time.  If the field is not a SKIP field,
// _fld_ed() will display the field message if there is one.  Then it will move
// the cursor (in data fields only), and call the begin field function (if
// any).  If there is an auto popup choice list, it will be processed.   Next is
// the main keystroke processing loop.   Before getting the next keystroke,
// _fld_ed() always checks to see if there has been a field validation error.
// If there has been, and the error message has not been printed, _fld_ed()
// will set the error window and print the message.
//
// Next _fld_ed() will get the next keystroke, take down the error window if it
// is set, and process the key function.  When field editing is complete,
// the end field function will be called, and the field will be made inactive.
//
// Related Functions
//
// fm_rd(), _fm_ed()
//
// Cautions
//
// None
//
// */
//
// /*  #include <vv_clist.h>
//
// #include <vv_form.h>  */

int FASTCALL _fld_ed(fmp)
FORMPTR fmp;                            /* pointer to data entry form         */
{
    int retval = 0;
    int space_toggle = 0;/* USD-III V2.0x */
    int the_key;
    int result;
    int clpop = FALSE;
    int row_org, col_org;
    int mcol_org, mrow_org;
    int cur_item;
#ifdef LINT_ARGS
    int (FASTCALL * fp)(DFORMPTR);
    int (FASTCALL * scrlfp)(int, int, DFORMPTR);
    int (FASTCALL * dcv_func)(UCHAR *, PTR, DFIELDPTR, UCHAR *);
#else
    PFI fp;
    PFI scrlfp;
    PFI dcv_func;
#endif
    long flags;
    ULONG msg_flags;         /*message window flag            */
    UCHAR *msg;
    int *nextsfld = (int *) NULLP;      /*next scrollable field pointer       */
    WINDOWPTR wnp, err_wnp, msg_wnp, memo_wnp;
    KTPTR key_tablep;
    FIELDPTR fldp;
    SRPTR srp;
#ifndef NO_DEBUG_CODE
    UCHAR * fn = (UCHAR *) "_fld_ed";
#endif

    INIT_MODULE(fn);

    fldp = _curfldp(fmp);               /*dereference the field pointer       */
    cur_item = fmp->cur_item;           /*save current item number            */

/*----------------------------------------------------------------------------*/
/*  If the current form item is a scrollable region, use the sr key table and */
/*  get a pointer to the nextact in the sr structure                          */
/*----------------------------------------------------------------------------*/
    if (_i_issr(curitemp(fmp)))
    {
        srp = cursrp(fmp);
        key_tablep = _ktptbl[srp->type];
        nextsfld = &srp->nextact;
    }
    else if (_i_ismemofld(curitemp(fmp)))  /*this is a memo field             */
    {
        key_tablep = _ktptbl[curmemop(fmp)->ktinx];
        memo_wnp = ((MEMOPTR)fldp)->wnp;
        mcol_org = memo_wnp->col_org;
        mrow_org = memo_wnp->row_org;
    }
    else                                /*otherwise use the form key table    */
        key_tablep = _ktptbl[fmp->type];

    flags = fldp->flags;                /*dereference the field flags         */
    wnp = fmp->wnp;                     /*dereference the form window pointer */
    msg_wnp = fmp->msg_wnp;             /*dereference the message window ptr  */
    err_wnp = fmp->err_wnp;             /*dereference the error window pointer*/
    scrlfp = fmp->scrlfp;               /*dereference the user scroll function*/

    if (!(flags & SKIP))                /*do not process skip fields          */
    {
        fmp->flags &= ~NOREALFLDS;      /*we found a non-skip field           */
/*----------------------------------------------------------------------------*/
/*  Display the field with its active attribute.  For F_MENU fields, call     */
/*  _mnf_disp() to take care of menu-specific features such as checkmarks.    */
/*  For other field types, simply change the field's display attribute.       */
/*----------------------------------------------------------------------------*/
        _fld_init(fmp);                 /*reset field edit values             */

/*----------------------------------------------------------------------------*/
/*  If there is a message for this field, set the message window and display  */
/*  the message                                                               */
/*----------------------------------------------------------------------------*/
        if ((msg = fldp->msg))          /*display the field message           */
        {
       msg_flags = msg_wnp->flags;
            msg_wnp->flags &= ~VSECHO;

            if (!wn_isup(msg_wnp))      /*is window already set?              */
            {
                if (!wn_up(msg_wnp))    /*no, set the message window          */
                    goto END;
            }
            else if (wn_rowq(msg_wnp) == 1)
                cs_mv(0, 0, msg_wnp);   /*v_st() will clear to end of row     */
            else
                wn_clr(msg_wnp);

            v_st(msg, msg_wnp);         /*write out the message               */

       if (msg_flags & VSECHO)    /*update screen               */
       {
           msg_wnp->flags |= VSECHO;
           if (VID_ECHO)
           {
               sw_dim(FULL, msg_wnp);
                 vs_updrgn(msg_wnp->rb, msg_wnp->cb, msg_wnp->re,
               msg_wnp->ce);
               sw_dim(INSIDE, msg_wnp);
           }
       }
        }
        else if (wn_isup(msg_wnp))      /*no message, take down the window    */
            wn_dn(msg_wnp);

        row_org = wnp->row_org, col_org = wnp->col_org;
        if (_fld_wbadj(fldp, fmp))      /*adjust the window for vforms        */
        {
            if (scrlfp)
                if (!(* scrlfp)(wnp->row_org - row_org, wnp->col_org - col_org,
                                fmp))
          goto END;
            wn_upd(wnp);                /*and update the physical screen      */
        }
   else if (fm_isvirtual(fmp) && _i_ismemofld(fldp))
       wn_updrgn(memo_wnp->rb, memo_wnp->cb, memo_wnp->re, memo_wnp->ce,
                 wnp);

/*----------------------------------------------------------------------------*/
/*  Figure out whether to place the cursor or not.               */
/*----------------------------------------------------------------------------*/
   if (!(             /*Don't place the cursor if         */
       !_csrvis          /* the cursor is not visible      */
       &&             /* and at the same time         */
       ( _i_ismfld(fldp)      /*it is either a menu field   */
           ||            /*or a data field             */
           ( _i_isdfld(fldp)
          &&             /*with toggle ON         */
          ( ((DFIELDPTR)fldp)->togglep
              ||
                          /*or a nonprintable NOECHO*/
            (flags & NOECHO && !ch_istxt(_noechoch))
          )
           )
       )
      ) )
       csr_plwn(wnp);

/*----------------------------------------------------------------------------*/
/* Call the begin field function:                        */
/*  If the begin field function returns '0', the field editor will return '0' */
/*     to indicate that a fatal error has occurred.               */
/*  If the field fails validation, but the next action code is still          */
/*    AC_CONTINUE, processing simply continues and the field editor will    */
/*     report the validation error.                     */
/*  If the field fails validation but the begin field function has changed    */
/*     the next action code, the next action code will be reset to          */
/*     AC_CONTINUE.  Field processing will continue and the validation         */
/*     error will be reported.  The next action code set by the begin field  */
/*     function will be ignored.                     */
/*  If the field passes validation and the begin field function has changed   */
/*     the action code, the return value is set to '1' so the field editor   */
/*     will return success.                        */
/*----------------------------------------------------------------------------*/

        if ((fp = fldp->begfp))         /*call the begin field function       */
        {
            if ((*fp)(fmp))      /*begin field function succeeded      */
       {
/*----------------------------------------------------------------------------*/
/*  If attempting to leave form, validate whatever the begfp did.  If         */
/*  validation fails, force the user to stay in the field.            */
/*----------------------------------------------------------------------------*/
      if (fmp->nextact != AC_CONTINUE)
                    if (!_fld_val(fmp))
         fmp->nextact = AC_CONTINUE;
       }
            else
                goto END;               /*begin field function error          */
        }

/*----------------------------------------------------------------------------*/
/*  If there is a choice list for this field, and if the CLPOP option is      */
/*  selected, pop up the choice list.                                         */
/*----------------------------------------------------------------------------*/
        if (_i_isdfld(fldp) && ((DFIELDPTR)fldp)->clistp &&
            (((DFIELDPTR)fldp)->clistp->flags & CLPOP))
            clpop = TRUE;

/*----------------------------------------------------------------------------*/
/*  Field processing loop                                                     */
/*----------------------------------------------------------------------------*/
        while (fmp->nextact == AC_CONTINUE)
        {
/*----------------------------------------------------------------------------*/
/*  Key processing loop                                                       */
/*----------------------------------------------------------------------------*/
            while (fmp->nextact == AC_CONTINUE)
            {
/*----------------------------------------------------------------------------*/
/*  If there has been a validation error, and the key function has not set    */
/*  the error window and displayed the message, do it here.  Also, put the    */
/*  cursor at the beginning of left entry fields.                             */
/*----------------------------------------------------------------------------*/
                if (VAL_ERR && !wn_isup(err_wnp))
                {
                    if (!(flags & RTENTRY || flags & PROTECTED))
                        kd_begfld(fmp);
                    if (!_fm_errdisp(VAL_ERR, BPERROR, fmp))
                        goto ENDFUNC;
                }

      VAL_ERRLAST = VAL_ERR;
                VAL_ERR = 0;
                _errstp = (UCHAR *) NULLP;

/*----------------------------------------------------------------------------*/
/*  If this is a menu form, and if the menu form has been altered, redisplay  */
/*  the menu.                                                                 */
/*----------------------------------------------------------------------------*/
                if (fmp->type == MNINX && fmp->flags & FMALTERED)
                    (*_mn_updfp)(fmp);

/*----------------------------------------------------------------------------*/
/*  If this is a memo field, and if the memo field window origin has changed, */
/*  redisplay the memo field.                                                 */
/*----------------------------------------------------------------------------*/
                if (fldp->type == F_MEMO)
                {
                                        /*reset the form cursor               */
                    wnp->r = memo_wnp->r + memo_wnp->rb;
                    wnp->c = memo_wnp->c + memo_wnp->cb;
                    if (!fm_isvirtual(fmp))
                    {
                        wnp->r -= wnp->rb;
                        wnp->c -= wnp->cb;
                    }

                    if (mcol_org != memo_wnp->col_org ||  /*redisplay the memo*/
                        mrow_org != memo_wnp->row_org)
                        (*_memo_updfp)(memo_wnp);

                    mcol_org = memo_wnp->col_org;
                    mrow_org = memo_wnp->row_org;
                }

                row_org = wnp->row_org, col_org = wnp->col_org;
                if (wn_msadj(wnp))          /*adjust the window for vforms    */
                {
                    if (scrlfp)
                        if (!(* scrlfp)(wnp->row_org - row_org,
                                        wnp->col_org - col_org, fmp))
             goto ENDFUNC;
                    wn_upd(wnp);            /*update the physical screen      */
                }
      else if (fm_isvirtual(fmp) && _i_ismemofld(fldp))
      {
          sw_dim(FULL, memo_wnp);
          wn_updrgn(memo_wnp->rb, memo_wnp->cb, memo_wnp->re,
               memo_wnp->ce, wnp);
          sw_dim(INSIDE, memo_wnp);
      }

/*----------------------------------------------------------------------------*/
/*  Figure out whether to place the cursor or not.               */
/*----------------------------------------------------------------------------*/
      if (!(          /*Don't place the cursor if         */
          !_csrvis       /* the cursor is not visible      */
          &&          /* and at the same time         */
          ( _i_ismfld(fldp)   /*it is either a menu field   */
              ||         /*or a data field             */
              ( _i_isdfld(fldp)
             &&          /*with toggle ON         */
             ( ((DFIELDPTR)fldp)->togglep
                 ||
                      /*or a nonprintable NOECHO    */
               (flags & NOECHO && !ch_istxt(_noechoch))
             )
              )
          )
         ) )
          csr_plwn(wnp);

/*----------------------------------------------------------------------------*/
/*  Process a keystroke.  If the MNSELECT flag has been set by (nth)          */
/*  character selection of a menu item, force the key to be the selection key.*/
/*  If we must pop up a choice list, for the key to be the choice key.        */
/*  Otherwise, get the next keystroke.                                        */
/*----------------------------------------------------------------------------*/
                if (flags & MNSELECT)
                {
                    the_key = _mnselectkey;
                    fldp->flags &= ~MNSELECT;
                    flags &= ~MNSELECT;
                }
                else if (clpop)
                {
                    the_key = _clistkey;
                    clpop = FALSE;
                }
                else
        {
         if (space_toggle == 1) (*(fldp->endfp))(fmp);
         space_toggle = 0;
         the_key = PulldownDialogKi(fmp);
         LogInteraction( the_key );
         if (the_key >= 500) _ki_last = 0;
         else _ki_last = the_key;
      }

                if (wn_isup(err_wnp))   /*if error window set, take it down   */
                    wn_dn(err_wnp);

if ( the_key >= 500 ) {
   if (the_key == 599) {
      the_key = 0x20;
      if (fldp->endfp != NULLP) space_toggle = 1;
   } else if (the_key != 599) {
      sfm_nextitem( (the_key-500), fmp );
      continue;
   }
}
/*----------------------------------------------------------------------------*/
/*  Process the keystroke.  the system key table is searched first.  If the   */
/*  key is not found, the key table for the form is searched.                 */
/*----------------------------------------------------------------------------*/
                if ((result = kt_proc(the_key, SYSKTP, (PTR)fmp)) == -1) {
                    result = kt_proc(the_key, key_tablep, (PTR)fmp);
      }
                if (!result)                /*key function error              */
                    goto ENDFUNC;

/*----------------------------------------------------------------------------*/
/*  If this is a scrollable field and the scrollable region, terminator is    */
/*  not AC_CONTINUE, set the form field terminator so we can get out of the   */
/*  loop.                                                                     */
/*----------------------------------------------------------------------------*/
                if (nextsfld && *nextsfld != AC_CONTINUE)
                    sfm_nextitem(AC_SAMEITEM, fmp);
            }

            if (fmp->nextact != AC_QUIT)            /*if the form not quit    */
            {
                if (!_fld_val(fmp))                 /*validate the field      */
                {
                    fldp->flags &= ~REQAUTOMOVE;
                    sfm_nextitem(AC_CONTINUE, fmp); /*invalid entry           */
                    if (nextsfld)       /*return back to the loop for scrl fld*/
                        sfm_nextitem(AC_CONTINUE, (DFORMPTR)srp);
                }
            }
        }

/*----------------------------------------------------------------------------*/
/*  If we reached this point, we must have fallen through the field processing*/
/*  loop without any errors occurring.  Set retval to indicate success.         */
/*----------------------------------------------------------------------------*/
   retval = 1;

ENDFUNC:
/*----------------------------------------------------------------------------*/
/*  Call end-field function if any.  If it fails, override retval.         */
/*----------------------------------------------------------------------------*/
        if ((fp = fldp->endfp) && !(*fp)(fmp))
       retval = 0;

END:
        _fld_redisp(fldp, fmp);         /* redisplay the field                */
   if (fm_isvirtual(fmp) && _i_ismemofld(fldp))
       wn_updrgn(memo_wnp->rb, memo_wnp->cb, memo_wnp->re, memo_wnp->ce,
                 wnp);
                                        /*update the user data variable       */
        if (fmp->nextact != AC_QUIT && _i_isdfld(fldp) && flags & FORCECONVERT)
   {
                                        /*get the data conversion function    */
            dcv_func = _fldinfo[fldp->type].st_varfp;
               /*convert the field value         */
            (*dcv_func)(((DFIELDPTR)fldp)->editbufp, ((DFIELDPTR)fldp)->datap,
                        (DFIELDPTR) fldp, ((DFORMPTR)fmp)->cvbufp);
               /*flag field as unALTERed         */
       fldp->flags &= ~FLDALTERED;
   }

        fmp->prev_item = cur_item;      /*save the item number as previous    */

   if (fmp->flags & INSERTMODE)   /*make sure INSERT mode is off         */
   {
            fmp->flags &= ~INSERTMODE;  /*turn off INSERT mode                */
            csr_type(BOT_LINE);         /*reset the cursor type               */
   }
    }
    else                                /*SKIP field                          */
    {
        retval = 1;                     /*successful                          */
   sfm_nextitem(AC_SAMEDIR, fmp);  /*keep moving in same direction       */
    }

    EXIT_NOERRH(fn);
    return(retval);
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
//
// /*  help_pro.c                           */
// /*  help_proc.c
//
//      ************* Copyright 1988 by Vermont Creative Software **************
//
// help_proc()
// Calls the help system
//
// Call
//
// #include <vv_help.h>
//
//
// int help_proc(helpp)
// HELPPTR helpp;            Help structure pointer
//
// Returns
//
// 1   The help information was successfully displayed and viewed.
//
// 0   A key function returned 0 or an error occurred.  In case of error,
//      VV_ERR is set to the following:
//
//      MEMLACK       There is insufficient memory to save the underlying
//                  image for the pop-up help window.
//
// Description
//
// help_proc() examines the help structure whose address is passed and
// determines if there is help information that can be displayed.  This is
// done by doing the following checks in the order presented:
//
//      *  If there is a memory file assigned to the help window, help_proc()
//        calls mf_kwdset() to set the keyword specified in the help
//        structure.  If found, that section of the memory file is displayed
//        in the help window.
//
//      *  If there is not a memory file assigned to the window or the keyword
//        is not found in the memory file, the keyword is considered a help
//        string.  The help string is then displayed in the help window.
//
//      *  If there is a pointer to a next help structure, then help_proc() is
//        called to find information to display from the next help structure.
//
//      *  If help information is not available from this help structure or
//        subsequent next help structures, the default help message is
//        displayed.
//
//      *  If the default help message is a NULLP, help_proc() beeps if
//        beep on no action is enabled.
//
// If any help information is to be displayed and the help window is not
// already set, a local copy of the help window is set on the video
// screen.   The appropriate help string or text is then displayed in the
// window.
//
// A message is also displayed in the message window when the help text
// is displayed.  If the information in the help window can be scrolled,
// the SCRLHELPMSG informational message is displayed.   If the
// information fits completely in the help window, the EXHELPMSG
// informational message is displayed.   Both of these messages are
// defined in vv_infomsg.c and can be changed.
//
// Control is then passed to the user.   The keyboard is scanned for user
// input.  Keystrokes entered by the user are searched for first in the
// system keytable and then the help keytable.   Provisions are made for
// the user to scroll in all directions, page up and down, toggle the
// size of the help window, and exit or quit the help system.  The
// default function in the help keytable is to beep.
//
// Whenever a key function moves the origin of the window within the
// memory file, the window is redrawn to display the appropriate part
// of the memory file.
//
// If the AC_ZOOM action code is set by a key function, help_proc() zooms
// or unzooms the help window depending on its previous state.
//
// If the AC_EXIT or AC_QUIT action code is set by a key function, then
// (1) the message window is removed from the screen, (2) if the help
// window was set at this help level, the help window is removed from
// the video screen, and (3) help_proc() returns.
//
// Cautions
//
// Do not enable the top and bottom of file messages for the help memory
// files.
//
// */
//
// /*  #include <vv_help.h>  */
//
int FASTCALL help_proc(helpp)
HELPPTR helpp;
{
    WINDOW msg_wn;                      /*local message window                */
    int r, c;                           /*temp storage for window members     */
    int r_org, c_org;
    ULONG flags;                        /*help window flags                   */
    ULONG loopflags;         /*help window flags in the loop         */
    ULONG msgflags;         /*message window flags            */
    int tr, tc;                         /*storage for cursor coordinates      */
    register int i;
    register int row_org;               /*help window coordinates in mf       */
    register int col_org;
    int trb, tcb, tre, tce;             /*temporary window coordinates        */
    MFILEPTR mfp;                       /*memory file pointer                 */
    HELPPTR nexthelp;                   /*pointer to the next help level      */
    UCHAR * mfkwdp;                     /*temporary storage for mf members    */
    UCHAR * kwdp;                       /*the keyword in the help structure   */
    int key;                            /*keycode                             */
    UINT keyq;            /*number of keystrokes pressed         */
    int nextact;
    int keyret;                         /*return value from kt_proc()         */
    int retval = 0;                     /*predefined error return             */
    int secmsg = TRUE;                  /*second message flag                 */
    int strhelp = FALSE;                /*help string only flag               */
#ifndef NO_DEBUG_CODE
    UCHAR * fn = (UCHAR *) "help_proc";
#endif

// adjust position in between 25/50 lines mode
    wn_mod( vs_rowq()-10, 5, 9, vs_colq()-10, HELP_WNP );

    INIT_MODULE(fn);

    csr_rd(&tr, &tc);                   /*read the physical cursor position   */
    helpp->tag = HELP_TAG;              /*initialize the help structure       */
    helpp->wnp = HELP_WNP;
    flags = HELP_WNP->flags;
    r = HELP_WNP->r;
    c = HELP_WNP->c;
    r_org = HELP_WNP->row_org;
    c_org = HELP_WNP->col_org;

    cs_mv(0, 0, HELP_WNP);              /*start in zero position              */
    HELP_WNP->flags |= CSRPLACE;        /*turn on cursor placement for mf_disp*/
    mfp = HELP_WNP->mfp;
    nexthelp = helpp->nexthelp;
    kwdp = helpp->kwdp;

    if (mfp)                            /*if mfp assigned                     */
    {                                   /*save members likely to change       */
        sw_mforg(0, 0, HELP_WNP);
        mfkwdp = mfp->kwdp;
    }

    if (!_wn_dupstruc(&msg_wn, MSG_WNP))
   goto END;
    msg_wn.flags &= ~HEAP_WN;      /*not a heap window            */

    if (mfp && kwdp && *kwdp == _kwdch && mf_kwdset(kwdp, mfp))
    {                                   /*display the memory file             */

   HELP_WNP->flags &= ~VSECHO;   /*turn screen update off         */

        if (!wn_isup(HELP_WNP))
        {
            if (!wn_up(HELP_WNP))       /*set the help window                 */
                goto END;
        }

        mf_disp(HELP_WNP);              /*display memory file                 */

        if (flags & VSECHO)      /*update screen               */
   {
       HELP_WNP->flags |= VSECHO;

       if (VID_ECHO)
       {
           sw_dim(FULL, HELP_WNP);
           vs_updrgn(HELP_WNP->rb, HELP_WNP->cb, HELP_WNP->re,
           HELP_WNP->ce);
           sw_dim(INSIDE, HELP_WNP);
       }
   }
    }
    else if (kwdp && *kwdp != _kwdch || !nexthelp && (kwdp = _dhelpmsg))
   {                           /*display the message directly */

   HELP_WNP->flags &= ~VSECHO;   /*turn screen update off         */

        if (!wn_isup(HELP_WNP))
        {
         if (!wn_up(HELP_WNP))      /*set the help window         */
                goto END;
        }
      else wn_clr(HELP_WNP);          /*clear the window          */

      v_st(kwdp, HELP_WNP);         /*print the message          */
      csr_mv(vs_rowq(), 0);         /*hide the cursor            */
   if (_csrvis)         /*place if could not hide         */
       csr_mvwn(0, 0, HELP_WNP);
      secmsg = FALSE;             /*do not print the first message */
      strhelp = TRUE;             /*no scrolling possible        */

        if (flags & VSECHO)      /*update screen               */
   {
       HELP_WNP->flags |= VSECHO;
       if (VID_ECHO)
       {
           sw_dim(FULL, HELP_WNP);
           vs_updrgn(HELP_WNP->rb, HELP_WNP->cb, HELP_WNP->re,
           HELP_WNP->ce);
           sw_dim(INSIDE, HELP_WNP);
       }
   }
    }
    else if (nexthelp)
    {                                   /*call the next help level            */
        retval = help_proc(nexthelp);
        goto END;
    }
    else                                /*nothing to display - beep         */
    {
   retval = 1;
        beep_vv(_beeps[BPNOACTION].duration, _beeps[BPNOACTION].pitch);
        goto END;
    }

    msgflags = msg_wn.flags;
    msg_wn.flags &= ~VSECHO;      /*turn screen update off         */

    if (!wn_up(&msg_wn))                /*set the message window              */
        goto END;

// adjust message position
    wn_mod( vs_rowq()-1, 0, 1, vs_colq(), &msg_wn );

    if (secmsg)                         /*if both messages to be shown        */
                                        /*print the first message             */
        v_st(vv_infomsg(SCRLHELPMSG), &msg_wn);
    else
                                        /*else print the second message       */
//        v_st(vv_infomsg(EXHELPMSG), &msg_wn);
    v_st("Press the <ESC> key to exit help and continue", &msg_wn);

    if (msgflags & VSECHO)      /*update screen               */
    {
        msg_wn.flags |= VSECHO;
        if (VID_ECHO)
        {
            sw_dim(FULL, &msg_wn);
              vs_updrgn(msg_wn.rb, msg_wn.cb, msg_wn.re, msg_wn.ce);
       sw_dim(INSIDE, &msg_wn);
   }
    }

    do
    {
        if (strhelp)
            helpp->nextact = AC_FIXED;
        else
            helpp->nextact = AC_CONTINUE;
         key = HelpKi(/*&keyq,*/ HELP_WNP);          /*get one or more keystrokes         */
         LogInteraction( key );
         keyq = 1;
        row_org = HELP_WNP->row_org;    /*save window position                */
        col_org = HELP_WNP->col_org;
        for (i = 0; i < keyq; i++)      /*loop for number of keystrokes       */
        {                               /*search both keytables               */
            if ((keyret = kt_proc(key, SYSKTP, (PTR)helpp)) == -1)
           keyret = kt_proc(key, HELPKTP, (PTR)helpp);
            if (!keyret)                /*zero returned from the key function */
           goto END;
   }

        nextact = helpp->nextact;
                                        /*if window origin moves              */
        if (nextact == AC_NEXT || nextact == AC_ZOOM ||
            row_org != HELP_WNP->row_org || col_org != HELP_WNP->col_org)
        {
       loopflags = HELP_WNP->flags;
       HELP_WNP->flags &= ~VSECHO;   /*turn off screen updating         */

            sw_dim(FULL, HELP_WNP);    /*work on full dimensions             */
            trb = HELP_WNP->rb;
            tcb = HELP_WNP->cb;
            tre = HELP_WNP->re;
            tce = HELP_WNP->ce;

            if (nextact == AC_ZOOM)
            {                           /*Zoom the help window                */
           wn_dn(HELP_WNP);   /*unset the help window               */
               /*modify coordinates                  */
           HELP_WNP->rb = _help_rb;
           HELP_WNP->cb = _help_cb;
           HELP_WNP->re = _help_re;
           HELP_WNP->ce = _help_ce;
           if (!wn_up(HELP_WNP))   /*set the help window again           */
                    goto END;
            }

       sw_dim(INSIDE, HELP_WNP);

            if (strhelp)                /*print the message                   */
            {
                wn_clr(HELP_WNP);       /*clear the window                    */
                v_st(kwdp, HELP_WNP);
                csr_mv(vs_rowq(), 0);   /*hide the cursor                     */
      if (_csrvis)      /*place if could not hide         */
          csr_mvwn(0, 0, HELP_WNP);
            }
            else
            {
                mf_disp(HELP_WNP);      /*redraw window                       */
            }

       if (nextact == AC_ZOOM)
       {
           if (loopflags & VSECHO)
      {
          HELP_WNP->flags |= VSECHO;
          if (VID_ECHO)
              vs_updrgn(min(trb, _help_rb), min(tcb, _help_cb),
                   max(tre, _help_re), max(tce, _help_ce));
      }
                _help_rb = trb;
           _help_cb = tcb;
                _help_re = tre;
           _help_ce = tce;
       }
       else
       {
           if (loopflags & VSECHO)
      {
          HELP_WNP->flags |= VSECHO;
          if (VID_ECHO)
              vs_updrgn(trb, tcb, tre, tce);
      }
       }
        }
        else if (!strhelp)              /*if not string help                  */
            csr_plwn(HELP_WNP);         /*place cursor at new location        */

        if (secmsg)                     /*if the second message to be printed */
        {                               /*print it                            */
            cs_mv(0, 0, &msg_wn);
//            v_st(vv_infomsg(EXHELPMSG), &msg_wn);
    v_st("Press the <ESC> key to exit help and continue", &msg_wn);
            secmsg = FALSE;
        }
    }
    while (nextact != AC_QUIT && nextact != AC_EXIT);

    wn_dn(&msg_wn);                     /*unset the message window            */
    wn_free(&msg_wn);         /*free scroll bars and shadows         */

    if (!(flags & SET))
        wn_dn(HELP_WNP);                /*unset the help window               */

    csr_mv(tr, tc);                     /*restore cursor                      */
    retval = 1;                         /*set successful return               */

END:
    if (mfp && !mf_kwdset(mfkwdp, mfp))   /*restore keyword            */
   retval = 0;

    HELP_WNP->mfp = mfp;
    HELP_WNP->r = r;
    HELP_WNP->c = c;
    HELP_WNP->row_org = r_org;
    HELP_WNP->col_org = c_org;

    EXIT_NOERRH(fn);
    return(retval);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
//
// /*  mf_brows.c                           */
// /*  mf_browse.c
//
//      ************* Copyright 1988 by Vermont Creative Software **************
//
// mf_browse()
// Allows the user to view and scroll a memory file in a window
//
// Call
//
// #include <vv_wnkt.h>
//
// int mf_browse(wnp)
// WINDOWPTR wnp;          Pointer to window with an associated memory file
//
// Returns
//
// AC_QUIT    The user pressed the quit key (i.e., the action code was set by
//          a key function to AC_QUIT).
//
// AC_EXIT    The user pressed the exit key (i.e., the action code was set by
//          a key function to AC_EXIT).
//
// 0       A key function returned 0 or an error occurred.  In case of an
//          error, the global error code VV_ERR is set to:
//
//          MEMLACK     There is insufficient memory to display the window.
//
// Description
//
// mf_browse() displays a memory file in a window and passes control to
// the user for viewing.  Before calling mf_browse(), the memory file
// must be initialized by a call to mf_def().  The memory file must be
// associated with the window by calling sw_mf().
//
// First, if the window has not already been set on the screen,
// mf_browse() calls wn_up() to set the window.
//
// mf_disp() is then called to display the appropriate portion of the
// memory file in the window.  Thus, if the memory file is set to operate
// on one keyworded section, only that keyworded section is displayed.
// Top-of-file and bottom-of-file messages are displayed if enabled for
// the memory file (use mf_msg() to control the display of these messages).
//
// ki_same() is called to obtain one or more identical keycodes from the
// keyboard.  The system keytable SYSKTP is searched first.  If there is
// a key function assigned to the keycode in the system keytable, this
// function is called.   Otherwise, the view keytable (VIEWKTP) is
// searched.  If the keycode has an associated key function in the view
// keytable, it is called.   The default function in the view keytable is
// called if no match is found in either keytable.   (There should always
// be a default function in the view table).
//
// Whenever a key function sets the window origin within the memory file,
// the window is redrawn to display the appropriate part of the memory file.
// Because ki_same() is used, identical keystrokes are processed all at
// once to avoid numerous screen updates.
//
// The function returns when a key function sets the action code to
// AC_EXIT or AC_QUIT.
//
// If the action code is set to AC_QUIT, mf_browse() calls wn_dn() to
// remove the window prior to returning.
//
// Cautions
//
// Prior to using this function, a memory file structure must be
// established.
//
// Buffered windows cannot be used to view memory files.
//
// */
//
// /*  #include <vv_wnkt.h>  */
//
int FASTCALL mf_browse(wnp)
WINDOWPTR wnp;
{
   int tr, tc;            /*storage for cursor coordinates      */
   int key;              /*keycode                      */
   ULONG flags;           /*window flags                  */
   int row_org;           /*window coordinates in mf         */
   int col_org;
   int retval = 0;         /*predefined error return          */
   UINT keyq;              /*quantity of keys found            */
   register int i;
   int extra_line;         /*flag if tof message displayed      */
   int keyret;            /*return value from kt_proc()       */
   KEYCTRL view;


#ifndef NO_DEBUG_CODE
    UCHAR * fn = (UCHAR *) "mf_browse";
#endif

    INIT_MODULE(fn);

   csr_rd(&tr, &tc);         /*read the physical cursor position   */
   flags = wnp->flags;       /*save window flags               */
   wnp->flags |= CSRPLACE;    /*turn on cursor placement for mf_disp*/

    wnp->flags &= ~VSECHO;      /*turn screen update off         */

    if (!wn_isup(wnp))
        if (!wn_up(wnp))
            goto END;

    mf_disp(wnp);
    view.tag = VIEW_TAG;                /*prepare a view structure            */
    view.wnp = wnp;

    if (flags & VSECHO)         /*update screen               */
    {
        wnp->flags |= VSECHO;

        if (VID_ECHO)
        {
            sw_dim(FULL, wnp);
            vs_updrgn(wnp->rb, wnp->cb, wnp->re, wnp->ce);
            sw_dim(INSIDE, wnp);
        }
    }

    do
    {
        view.nextact = AC_CONTINUE;
       key = HelpKi(wnp);         /*get one or more keystrokes         */

       LogInteraction( key );
       keyq = 1;
        row_org = wnp->row_org;         /*save window position                */
        col_org = wnp->col_org;
        for (i = 0; i < keyq; i++)      /*loop for number of keystrokes       */
        {                               /*search both keytables               */
            if ((keyret = kt_proc(key, SYSKTP, (PTR)&view)) == -1)
                keyret = kt_proc(key, VIEWKTP, (PTR)&view);
            if (!keyret)                /*zero returned from the key function */
                goto END;
        }
                              /*if window origin moves    */
        if (view.nextact == AC_NEXT || row_org != wnp->row_org ||
                                       col_org != wnp->col_org)
        {
         mf_disp(wnp);            /*redraw window           */
        }
        else
        {
            extra_line = (wnp->mfp->flag & TOPBOTMSG && row_org < 0) ? 1 : 0;
            if ((row_org < 0 && wnp->r == 0) ||
                (wnp->r + row_org == wnp->mfp->vln_q + extra_line))
            {
                csr_mv(vs_rowq(), 0);
                                        /*hides the cursor off screen         */
                if (_csrvis)      /*if impossible, move the cursor      */
                {
                    wnp->r = 0;         /*window -- will appear on tof or bof */
                    csr_plwn(wnp);      /*message                             */
                }
            }
            else
            csr_plwn(wnp);         /*place cursor at new location     */
        }
    }
    while (view.nextact != AC_EXIT && view.nextact != AC_QUIT);

    if ((retval = view.nextact) == AC_QUIT)
    {
      wn_dn(wnp);             /*unset the window              */
      csr_mv(tr, tc);             /*restore cursor              */
    }

   if (!(flags & CSRPLACE))         /*restore CSRPLACE option        */
        wnp->flags &= ~CSRPLACE;

END:
    EXIT_NOERRH(fn);
    return(retval);

}   // end of mf_browse()

/**************************** End of File **********************************/

