/*  vv_main.h
    ************* Copyright 1988 by Vermont Creative Software **************
Description
The header file with global declarations to be included in the main module.
*/

/*  Do not allow to process the file more than once               */
#ifndef VV_MAIN
#define VV_MAIN

/*  Include the system header file                     */
#ifndef VV_SYS
#include <vv_sys.h>
#endif

/*  Include the error reporting system if appropriate               */
#ifndef NO_DEBUG_CODE
#ifndef VV_ERRF
#include <vv_debug.h>
#endif
#endif

/*  Check if librarian file included so tables are alright            */
#ifdef VV_DES
#ifndef VV_LIB
#include <vv_lib.h>
#endif
#endif


/******************************************************************************/
/*
/*  Video Attributes Definitions
/*
/******************************************************************************/

#ifdef VV_PATT            /*if physical attributes in use       */

GLOBAL int _lattsw = OFF;
GLOBAL UCHAR _latt[1];
GLOBAL UCHAR _att_tbl[1][PATTQ];
GLOBAL int _attrowq = 1;
GLOBAL int _attcolq = 1;

#else               /*logical attributes in use         */

GLOBAL int _lattsw = ON;      /*"logical attributes in use" flag    */
GLOBAL UCHAR _latt[LATTQ];      /*array of logical attributes         */

GLOBAL UCHAR _att_tbl[LATTQ][PATTQ] =
{

#ifdef   NEC_PC9801

   {NORMAL,                     catt_def98(WHITE, 0x00)},          /*LSYS     */
   {NORMAL,                     catt_def98(WHITE, 0x00)},          /*LNORMAL  */
   {REVERSE,                    catt_def98(BLUE,  REVERSE)},       /*LREVERSE */
   {NORMAL | HIGH_INT,          catt_def98(WHITE, 0x00)},          /*LHIGHLITE*/
   {NORMAL | HIGH_INT | BLINK,  catt_def98(RED ,  BLINK)},         /*LURGENT  */
   {NORMAL | HIGH_INT,          catt_def98(BLUE,  REVERSE)},       /*LHELP    */
   {REVERSE,                    catt_def98(RED,   REVERSE)},       /*LERROR   */
   {NORMAL | HIGH_INT,          catt_def98(WHITE, 0x00)},          /*LMESSAGE */
   {NORMAL | HIGH_INT,          catt_def98(CYAN,  0x00)},          /*LFLDINACT*/
   {REVERSE,                    catt_def98(CYAN,  REVERSE)},       /*LFLDACT  */
   {NORMAL,                     catt_def98(WHITE, REVERSE)},       /*LFLDSKIP */

/* MICROTEK, 08/08/90 modified */
   {NORMAL | HIGH_INT,          catt_def98(CYAN, REVERSE)},      /*LMNINACT */
   {REVERSE,                    catt_def98(WHITE, REVERSE)},       /*LMNACT   */
   {REVERSE,                    catt_def98(CYAN, REVERSE)},       /*LMNUNAVAIL*/
   {REVERSE,                    catt_def98(YELLOW,  REVERSE)},       /*LMNSELCH */

   {NORMAL | HIGH_INT,          catt_def98(GREEN, REVERSE)},       /*LCLINACT */
   {REVERSE,                    catt_def98(GREEN, 0x00 )},         /*LCLACT   */
   {REVERSE,                    catt_def98(WHITE, REVERSE)},       /*LMARK    */
   {0,                          0x00                  },           /*LNODISPLA*/

/* MICROTEK, 08/08/90 modified */
   {REVERSE,                    catt_def98(GREEN, REVERSE)},      /*LARROW   */
   {NORMAL,                     catt_def98(GREEN,  0x00)},      /*LCORNER  */
   {NORMAL,                     catt_def98(GREEN, REVERSE)},      /*LPAGERGN */
   {REVERSE,                    catt_def98(GREEN, REVERSE)},       /*LTHUMB   */

   {NORMAL,         catt_def98(WHITE, 0x00)},      /*LSHADOW  */
   {REVERSE,                    catt_def98(RED,   REVERSE)},       /*LDEBUG   */
   {NORMAL | HIGH_INT,          catt_def98(RED,   0x00)},          /*LDEBUGMSG*/
   {REVERSE,                    catt_def98(BLUE,  REVERSE)},       /*LBLACK   */
   {REVERSE,                    catt_def98(BLUE,  0x00)},          /*LBLUE    */
   {NORMAL,                     catt_def98(GREEN, 0x00)},          /*LGREEN   */
   {NORMAL,                     catt_def98(CYAN,  0x00)},          /*LCYAN    */
   {REVERSE,                    catt_def98(RED,   0x00)},          /*LRED     */
   {REVERSE,                    catt_def98(MAGENTA,0x00)},         /*LMAGENTA */
   {NORMAL,                     catt_def98(BROWN, 0x00)},          /*LBROWN   */
   {NORMAL,                     catt_def98(WHITE, 0x00)},          /*LWHITE   */

/* MICROTEK, 08/08/90 modified */
   {NORMAL,         catt_def98(YELLOW, 0x00)},       /*LFORMS     */
   {REVERSE,         catt_def98(YELLOW, REVERSE)},       /*LFLDACTON  */
   {HIGH_INT|NORMAL,      catt_def98(CYAN, REVERSE)},       /*LFLDACTOFF */

   {0, 0},                                            /*RESERVED */
   {0, 0}, {0, 0}, {0, 0}, {0, 0},                                 /*RESERVED */

/* MICROTEK, 08/08/90 added */

   { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 },
   { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 },

   { REVERSE,      catt_def98( BLACK,    REVERSE ) },  /*  LBLA_BLA */
   { REVERSE,      catt_def98( BLUE,     REVERSE ) },  /*  LBLA_BLU */
   { REVERSE,      catt_def98( MAGENTA,  REVERSE ) },  /*  LBLA_MAG */
   { REVERSE,      catt_def98( RED,      REVERSE ) },  /*  LBLA_RED */
   { REVERSE,      catt_def98( WHITE,    REVERSE ) },  /*  LBLA_WHI */
   { REVERSE,      catt_def98( BROWN,    REVERSE ) },  /*  LBLA_BRO */
   { REVERSE,      catt_def98( CYAN,     REVERSE ) },  /*  LBLA_CYA */
   { REVERSE,      catt_def98( GREEN,    REVERSE ) },  /*  LBLA_GRE */
   { REVERSE,      catt_def98( YELLOW,   REVERSE ) },  /*  LBLA_YEL */

   { 0, 0 },

   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_BLA */
   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_BLU */
   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_MAG */
   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_RED */
   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_WHI */
   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_BRO */
   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_CYA */
   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_GRE */
   { REVERSE,      catt_def98( BLUE,        0x00 ) },  /*  LBLU_YEL */

   { 0, 0 },

   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_BLA */
   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_BLU */
   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_MAG */
   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_RED */
   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_WHI */
   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_BRO */
   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_CYA */
   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_GRE */
   { REVERSE,      catt_def98( MAGENTA,     0x00 ) },  /*  LMAG_YEL */

   { 0, 0 },

   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_BLA */
   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_BLU */
   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_MAG */
   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_RED */
   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_WHI */
   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_BRO */
   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_CYA */
   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_GRE */
   { REVERSE,      catt_def98( RED,         0x00 ) },  /*  LRED_YEL */

   { 0, 0 },

   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_BLA */
   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_BLU */
   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_MAG */
   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_RED */
   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_WHI */
   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_BRO */
   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_CYA */
   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_GRE */
   { NORMAL,       catt_def98( WHITE,      0x00 ) },  /*  LWHI_YEL */

   { 0, 0 },

   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_BLA */
   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_BLU */
   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_MAG */
   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_RED */
   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_WHI */
   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_BRO */
   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_CYA */
   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_GRE */
   { NORMAL,       catt_def98( BROWN,       0x00 ) },  /*  LBRO_YEL */

   { 0, 0 },

   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_BLA */
   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_BLU */
   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_MAG */
   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_RED */
   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_WHI */
   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_BRO */
   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_CYA */
   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_GRE */
   { NORMAL,       catt_def98( CYAN,        0x00 ) },  /*  LCYA_YEL */

   { 0, 0 },

   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_BLA */
   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_BLU */
   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_MAG */
   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_RED */
   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_WHI */
   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_BRO */
   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_CYA */
   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_GRE */
   { NORMAL,       catt_def98( GREEN,       0x00 ) },  /*  LGRE_YEL */

   { 0, 0 },

   { NORMAL,       catt_def98( YELLOW,      0x00 ) },  /*  LYEL_BLA */
   { NORMAL,       catt_def98( YELLOW,      0x00 ) },  /*  LYEL_BLU */
   { NORMAL,       catt_def98( YELLOW,      0x00 ) },  /*  LYEL_MAG */
   { NORMAL,       catt_def98( YELLOW,      0x00 ) },  /*  LYEL_RED */
   { NORMAL,       catt_def98( YELLOW,      0x00 ) },  /*  LYEL_WHI */
   { NORMAL,       catt_def98( YELLOW,      0x00 ) },  /*  LYEL_BRO */
   { NORMAL,       catt_def98( YELLOW,      0x00 ) },  /*  LYEL_CYA */
   { NORMAL,       catt_def98( YELLOW,      0x00 ) },  /*  LYEL_GRE */
   { NORMAL,       catt_def98( YELLOW,      0x00 ) }   /*  LYEL_YEL */

#else   /* NEC_PC9801 */

   {NORMAL,         catt_def(WHITE, BLACK)},      /*LSYS     */
   {NORMAL,         catt_def(WHITE, BLUE)},       /*LNORMAL  */
   {REVERSE,         catt_def(BLUE, WHITE)},       /*LREVERSE */
   {NORMAL | HIGH_INT,      catt_def(WHITE | LIGHT, BLUE)},    /*LHIGHLITE*/
   {NORMAL | HIGH_INT | BLINK,   catt_def(RED | BLINK, BLACK)},      /*LURGENT  */
   {NORMAL | HIGH_INT,      catt_def(BLUE, WHITE)},       /*LHELP    */

/* MICROTEK, 08/08/90 modified */

/* {REVERSE,         catt_def(RED, BLACK)}, */
   {REVERSE,         catt_def(LIGHT|WHITE, LIGHT|RED)}, /*LERROR   */

   {NORMAL | HIGH_INT,      catt_def(WHITE | LIGHT, BLUE)},    /*LMESSAGE */
   {NORMAL | HIGH_INT,      catt_def(CYAN, BLUE)},         /*LFLDINACT*/
   {REVERSE,         catt_def(BLACK, CYAN)},       /*LFLDACT  */
   {NORMAL,         catt_def(BLACK, WHITE)},      /*LFLDSKIP */

/* MICROTEK, 08/08/90 modified */

/* {NORMAL | HIGH_INT,      catt_def(CYAN, BLUE)},
   {REVERSE,         catt_def(BLACK, CYAN)},
   {NORMAL,         catt_def(BLACK, WHITE)},
   {REVERSE,         catt_def(BLACK, CYAN)}, */
   {NORMAL,         catt_def(LIGHT | BLACK, LIGHT | CYAN)},   /*LMNINACT */
   {REVERSE,         catt_def(LIGHT | WHITE, LIGHT | RED)},   /*LMNACT   */
   {REVERSE,         catt_def(BLACK, CYAN)},           /*LMNUNAVAIL*/
   {NORMAL | HIGH_INT,      catt_def(LIGHT | RED, LIGHT | CYAN)},   /*LMNSELCH */

   {NORMAL | HIGH_INT,      catt_def(BLACK, GREEN)},      /*LCLINACT */
   {REVERSE,         catt_def(GREEN, BLACK)},      /*LCLACT   */
   {REVERSE,         catt_def(BLUE, WHITE)},       /*LMARK    */
   {0,            catt_def(BLUE, BLUE)},         /*LNODISPLA*/

/* MICROTEK, 08/08/90 modified */

/* {REVERSE,         catt_def(WHITE, BLACK)},
   {NORMAL,         catt_def(WHITE, BLUE)},
   {NORMAL,         catt_def(WHITE, BLACK)},
   {REVERSE,         catt_def(BLACK, WHITE)}, */
   {REVERSE,         catt_def(LIGHT | WHITE, LIGHT|BLACK)},   /*LARROW   */
   {NORMAL,         catt_def(LIGHT | WHITE, LIGHT|BLUE)},   /*LCORNER  */
   {NORMAL,         catt_def(LIGHT | WHITE, LIGHT|BLACK)},   /*LPAGERGN */
   {REVERSE,         catt_def(LIGHT | BLACK, LIGHT|WHITE)},   /*LTHUMB   */

   {NORMAL,         catt_def(WHITE, BLACK)},      /*LSHADOW  */
   {REVERSE,         catt_def(LIGHT | WHITE, RED)},      /*LDEBUG   */
   {NORMAL | HIGH_INT,      catt_def(RED, WHITE)},         /*LDEBUGMSG*/
   {REVERSE,         catt_def(BLACK, BLUE)},       /*LBLACK   */
   {REVERSE,         catt_def(BLUE, WHITE)},       /*LBLUE    */
   {NORMAL,         catt_def(GREEN, BLUE)},       /*LGREEN   */
   {NORMAL,         catt_def(CYAN, BLUE)},         /*LCYAN    */
   {REVERSE,         catt_def(RED, BLUE)},         /*LRED     */
   {REVERSE,         catt_def(MAGENTA, BLUE)},      /*LMAGENTA */
   {NORMAL,         catt_def(BROWN, BLUE)},       /*LBROWN   */
   {NORMAL,         catt_def(WHITE, BLUE)},       /*LWHITE   */

/* MICROTEK, 08/08/90 modified */

/* {0, 0}, {0, 0}, {0, 0}, */
   {NORMAL,         catt_def(LIGHT|BROWN, BLUE)},       /*LFORMS     */
   {REVERSE,         catt_def(BLUE, LIGHT|BROWN)},       /*LFLDACTON  */
   {HIGH_INT|NORMAL,      catt_def(LIGHT|BROWN, CYAN)},       /*LFLDACTOFF */

   {0, 0},                           /*RESERVED */
   {0, 0}, {0, 0}, {0, 0}, {0, 0},               /*RESERVED */

/* MICROTEK, 08/08/90 added */

   { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 },
   { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 },

   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | BLACK   ) },  /*  LBLA_BLA */
   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | BLUE    ) },  /*  LBLA_BLU */
   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | MAGENTA ) },  /*  LBLA_MAG */
   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | RED     ) },  /*  LBLA_RED */
   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | WHITE   ) },  /*  LBLA_WHI */
   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | BROWN   ) },  /*  LBLA_BRO */
   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | CYAN    ) },  /*  LBLA_CYA */
   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | GREEN   ) },  /*  LBLA_GRE */
   { REVERSE, catt_def( LIGHT | BLACK,   LIGHT | YELLOW  ) },  /*  LBLA_YEL */

   { 0, 0 },

   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | BLACK   ) },  /*  LBLU_BLA */
   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | BLUE    ) },  /*  LBLU_BLU */
   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | MAGENTA ) },  /*  LBLU_MAG */
   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | RED     ) },  /*  LBLU_RED */
   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | WHITE   ) },  /*  LBLU_WHI */
   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | BROWN   ) },  /*  LBLU_BRO */
   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | CYAN    ) },  /*  LBLU_CYA */
   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | GREEN   ) },  /*  LBLU_GRE */
   { REVERSE, catt_def( LIGHT | BLUE,    LIGHT | YELLOW  ) },  /*  LBLU_YEL */

   { 0, 0 },

   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | BLACK   ) },  /*  LMAG_BLA */
   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | BLUE    ) },  /*  LMAG_BLU */
   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | MAGENTA ) },  /*  LMAG_MAG */
   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | RED     ) },  /*  LMAG_RED */
   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | WHITE   ) },  /*  LMAG_WHI */
   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | BROWN   ) },  /*  LMAG_BRO */
   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | CYAN    ) },  /*  LMAG_CYA */
   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | GREEN   ) },  /*  LMAG_GRE */
   { REVERSE, catt_def( LIGHT | MAGENTA, LIGHT | YELLOW  ) },  /*  LMAG_YEL */

   { 0, 0 },

   { REVERSE, catt_def( LIGHT | RED,     LIGHT | BLACK   ) },  /*  LRED_BLA */
   { REVERSE, catt_def( LIGHT | RED,     LIGHT | BLUE    ) },  /*  LRED_BLU */
   { REVERSE, catt_def( LIGHT | RED,     LIGHT | MAGENTA ) },  /*  LRED_MAG */
   { REVERSE, catt_def( LIGHT | RED,     LIGHT | RED     ) },  /*  LRED_RED */
   { REVERSE, catt_def( LIGHT | RED,     LIGHT | WHITE   ) },  /*  LRED_WHI */
   { REVERSE, catt_def( LIGHT | RED,     LIGHT | BROWN   ) },  /*  LRED_BRO */
   { REVERSE, catt_def( LIGHT | RED,     LIGHT | CYAN    ) },  /*  LRED_CYA */
   { REVERSE, catt_def( LIGHT | RED,     LIGHT | GREEN   ) },  /*  LRED_GRE */
   { REVERSE, catt_def( LIGHT | RED,     LIGHT | YELLOW  ) },  /*  LRED_YEL */

   { 0, 0 },

   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | BLACK   ) },  /*  LWHI_BLA */
   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | BLUE    ) },  /*  LWHI_BLU */
   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | MAGENTA ) },  /*  LWHI_MAG */
   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | RED     ) },  /*  LWHI_RED */
   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | WHITE   ) },  /*  LWHI_WHI */
   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | BROWN   ) },  /*  LWHI_BRO */
   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | CYAN    ) },  /*  LWHI_CYA */
   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | GREEN   ) },  /*  LWHI_GRE */
   { NORMAL,  catt_def( LIGHT | WHITE,   LIGHT | YELLOW  ) },  /*  LWHI_YEL */

   { 0, 0 },

   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | BLACK   ) },  /*  LBRO_BLA */
   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | BLUE    ) },  /*  LBRO_BLU */
   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | MAGENTA ) },  /*  LBRO_MAG */
   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | RED     ) },  /*  LBRO_RED */
   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | WHITE   ) },  /*  LBRO_WHI */
   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | BROWN   ) },  /*  LBRO_BRO */
   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | CYAN    ) },  /*  LBRO_CYA */
   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | GREEN   ) },  /*  LBRO_GRE */
   { NORMAL,  catt_def( LIGHT | BROWN,   LIGHT | YELLOW  ) },  /*  LBRO_YEL */

   { 0, 0 },

   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | BLACK   ) },  /*  LCYA_BLA */
   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | BLUE    ) },  /*  LCYA_BLU */
   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | MAGENTA ) },  /*  LCYA_MAG */
   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | RED     ) },  /*  LCYA_RED */
   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | WHITE   ) },  /*  LCYA_WHI */
   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | BROWN   ) },  /*  LCYA_BRO */
   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | CYAN    ) },  /*  LCYA_CYA */
   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | GREEN   ) },  /*  LCYA_GRE */
   { NORMAL,  catt_def( LIGHT | CYAN,    LIGHT | YELLOW  ) },  /*  LCYA_YEL */

   { 0, 0 },

   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | BLACK   ) },  /*  LGRE_BLA */
   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | BLUE    ) },  /*  LGRE_BLU */
   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | MAGENTA ) },  /*  LGRE_MAG */
   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | RED     ) },  /*  LGRE_RED */
   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | WHITE   ) },  /*  LGRE_WHI */
   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | BROWN   ) },  /*  LGRE_BRO */
   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | CYAN    ) },  /*  LGRE_CYA */
   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | GREEN   ) },  /*  LGRE_GRE */
   { NORMAL,  catt_def( LIGHT | GREEN,   LIGHT | YELLOW  ) },  /*  LGRE_YEL */

   { 0, 0 },

   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | BLACK   ) },  /*  LYEL_BLA */
   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | BLUE    ) },  /*  LYEL_BLU */
   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | MAGENTA ) },  /*  LYEL_MAG */
   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | RED     ) },  /*  LYEL_RED */
   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | WHITE   ) },  /*  LYEL_WHI */
   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | BROWN   ) },  /*  LYEL_BRO */
   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | CYAN    ) },  /*  LYEL_CYA */
   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | GREEN   ) },  /*  LYEL_GRE */
   { NORMAL,  catt_def( LIGHT | YELLOW,  LIGHT | YELLOW  ) }   /*  LYEL_YEL */

#endif   /* NEC_PC9801 */

};

GLOBAL int _attrowq = LATTQ;      /*number of rows in attribute table   */
GLOBAL int _attcolq = PATTQ;      /*number of columns in attribute table*/

#endif               /*end of the video attributes         */



/******************************************************************************/
/*                                 */
/*  Key Tables                              */
/*                                 */
/******************************************************************************/

#ifdef VV_KEY

GLOBAL KT _syskt[] =         /*System (User) Key Table         */
{
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_WNKT

GLOBAL KT _viewkt[] =         /*View System Key Table          */
{
    {KEY_LEFT, (KEYFP)kv_lft},      /*cursor left               */
    {KEY_RIGHT, (KEYFP)kv_rt},      /*cursor right               */
    {KEY_UP, (KEYFP)kv_up},      /*cursor up               */
    {KEY_DN, (KEYFP)kv_dn},      /*cursor down               */
    {KEY_PGUP, (KEYFP)kv_pgup},    /*cursor page up            */
    {KEY_PGDN, (KEYFP)kv_pgdn},    /*cursor page down            */
    {KEY_HOME, (KEYFP)kv_home},    /*cursor home               */
    {KEY_END, (KEYFP)kv_end},      /*cursor end               */
    {KEY_F10, (KEYFP)k_exit},      /*exit                  */
    {KEY_ESC, (KEYFP)k_quit},      /*quit                  */
    {KT_DEFAULT, (KEYFP)k_beep},   /*beep otherwise            */
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_HELP

GLOBAL KT _helpkt[] =         /*Help System Key Table          */
{
    {KEY_LEFT, (KEYFP)kv_lft},      /*cursor left               */
    {KEY_RIGHT, (KEYFP)kv_rt},      /*cursor right               */
    {KEY_UP, (KEYFP)kv_up},      /*cursor up               */
    {KEY_DN, (KEYFP)kv_dn},      /*cursor down               */
    {KEY_PGUP, (KEYFP)kv_pgup},    /*cursor page up            */
    {KEY_PGDN, (KEYFP)kv_pgdn},    /*cursor page down            */
    {KEY_HOME, (KEYFP)kv_home},    /*cursor home               */
    {KEY_END, (KEYFP)kv_end},      /*cursor end               */
    {KEY_ESC, (KEYFP)k_exit},      /*exit help level            */
    {KEY_ENTER, (KEYFP)k_exit},    /*exit help level            */
    {KEY_F1, (KEYFP)kh_help},      /*next help level            */
    {KEY_AF1, (KEYFP)kh_zoom},      /*zoom help window            */
    {KT_DEFAULT, (KEYFP)k_beep},   /*beep otherwise            */
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_WNKT

GLOBAL KT _dragkt[] =         /*Draw & Drag Key Table          */
{
    {KEY_LEFT, (KEYFP)k_lft},      /*left                  */
    {KEY_RIGHT, (KEYFP)k_rt},      /*right                */
    {KEY_UP, (KEYFP)k_up},      /*up                  */
    {KEY_DN, (KEYFP)k_dn},      /*down                  */
    {KEY_F10, (KEYFP)k_exit},      /*exit                  */
    {KEY_ESC, (KEYFP)k_quit},      /*quit                  */
    {KT_DEFAULT, (KEYFP)k_beep},   /*beep otherwise            */
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_CLIST

GLOBAL KT _clistkt[] =         /*Choice Lists Key Table         */
{
#ifdef VV_HELP
    {KEY_F1, (KEYFP)kc_help},      /*help                  */
#endif
    {KEY_UP, (KEYFP)kv_up},      /*item up               */
    {KEY_DN, (KEYFP)kv_dn},      /*item down               */
    {KEY_PGUP, (KEYFP)kv_pgup},    /*page up               */
    {KEY_PGDN, (KEYFP)kv_pgdn},    /*page down               */
    {KEY_HOME, (KEYFP)kv_home},    /*home                  */
    {KEY_END, (KEYFP)kv_end},      /*end                  */
    {KEY_ENTER, (KEYFP)k_exit},    /*select               */
    {KEY_ESC, (KEYFP)k_quit},      /*quit                  */
    {KT_DEFAULT, (KEYFP)kc_chproc},   /*first character selection         */
    {0, (KEYFP)NULLFP},  // increase 5 more entries
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_FIELD

GLOBAL KT _formkt[] =         /*Form Editor Key Definition Table    */
{
#ifdef VV_HELP
    {KEY_F1, (KEYFP)kd_help},      /*help key               */
#endif
#ifdef VV_CLIST
    {KEY_F2, (KEYFP)kd_clist},      /*choice list key            */
#endif
    {KEY_SF3, (KEYFP)kd_undofld},   /*restore field to original value     */
    {KEY_F6, (KEYFP)kd_clrfld},    /*clear field               */
    {KEY_SF6, (KEYFP)kd_clreofld},   /*clear to end of field          */
    {KEY_F7, (KEYFP)kd_previtem},   /*previous item key            */
    {KEY_SF7, (KEYFP)kd_prevfm},   /*previous form key            */
    {KEY_F8, (KEYFP)kd_nextitem},   /*next item key             */
    {KEY_SF8, (KEYFP)kd_nextfm},   /*next form key             */
    {KEY_F10, (KEYFP)k_exit},      /*exit data form key            */
    {KEY_HOME, (KEYFP)kd_begfld},   /*begin field               */
    {KEY_CHOME, (KEYFP)kd_firstitem},   /*go to first form item          */
    {KEY_END, (KEYFP)kd_endfld},   /*end field               */
    {KEY_CEND, (KEYFP)kd_lastitem},   /*go to last form item            */
    {KEY_LEFT, (KEYFP)kd_lftcsr},   /*left arrow key            */
    {KEY_RIGHT, (KEYFP)kd_rtcsr},   /*right arrow key            */
    {KEY_UP, (KEYFP)kd_upitem},    /*up arrow key               */
    {KEY_DN, (KEYFP)kd_dnitem},    /*down arrow key            */
    {KEY_ESC, (KEYFP)k_quit},      /*quit data form key            */
    {KEY_ENTER, (KEYFP)kd_nextitem},   /*next field key            */
    {KEY_INS, (KEYFP)kd_instoggle},   /*insert mode key            */
    {KEY_DEL, (KEYFP)kd_chdel},    /*delete key               */
    {KEY_BACK, (KEYFP)kd_backsp},   /*backspace key             */
#ifdef VV_BOOL
    {KEY_SPACE, (KEYFP)kd_booltoggle},   /*boolean toggle key            */
#endif
    {KEY_TAB, (KEYFP)kd_nextitem},   /*next item key             */
    {KEY_STAB, (KEYFP)kd_previtem},   /*previous item key            */
    {KT_DEFAULT, (KEYFP)kd_chproc},   /*print keystroke in field         */
    {0, (KEYFP)NULLFP},            // increase 5 entries
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_MENU

GLOBAL KT _menukt[] =         /*Menu System Key Definition Table    */
{
#ifdef VV_HELP
    {KEY_F1, (KEYFP)kd_help},      /*help key               */
#endif
    {KEY_CHOME, (KEYFP)kd_firstitem},   /*go to first menu item          */
    {KEY_CEND, (KEYFP)kd_lastitem},   /*go to last menu item            */
    {KEY_LEFT, (KEYFP)km_lft},      /*left arrow key            */
    {KEY_RIGHT, (KEYFP)km_rt},      /*right arrow key            */
    {KEY_UP, (KEYFP)kd_upitem},    /*up arrow key               */
    {KEY_DN, (KEYFP)kd_dnitem},    /*down arrow key            */
    {KEY_ESC, (KEYFP)km_esc},      /*escape key               */
    {KEY_ENTER, (KEYFP)km_select},   /*enter key               */
    {KT_DEFAULT, (KEYFP)km_chproc},   /*possible first character for item   */
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_SR

GLOBAL KT _srkt[] =         /*Scrollable Region Key Table         */
{
#ifdef VV_HELP
    {KEY_F1, (KEYFP)kd_help},      /*help key               */
#endif
#ifdef VV_CLIST
    {KEY_F2, (KEYFP)kd_clist},      /*choice list key            */
#endif
    {KEY_SF3, (KEYFP)kd_undofld},   /*restore field to original value     */
    {KEY_F6, (KEYFP)kd_clrfld},    /*clear field               */
    {KEY_SF6, (KEYFP)kd_clreofld},   /*clear to end of field          */
    {KEY_F7, (KEYFP)kd_previtem},   /*previous item key            */
    {KEY_SF7, (KEYFP)kd_prevfm},   /*previous form key            */
    {KEY_F8, (KEYFP)kd_nextitem},   /*next item key             */
    {KEY_SF8, (KEYFP)kd_nextfm},   /*next form key             */
    {KEY_F10, (KEYFP)k_exit},      /*exit data form key            */
    {KEY_HOME, (KEYFP)ks_home},    /*scrollable region home         */
    {KEY_CHOME, (KEYFP)kd_firstitem},   /*go to first form item          */
    {KEY_END, (KEYFP)ks_end},      /*scrollable region end          */
    {KEY_CEND, (KEYFP)kd_lastitem},   /*go to last form item            */
    {KEY_PGUP, (KEYFP)ks_pgup},    /*page up               */
    {KEY_PGDN, (KEYFP)ks_pgdn},    /*page down               */
    {KEY_LEFT, (KEYFP)kd_lftcsr},   /*left arrow key            */
    {KEY_RIGHT, (KEYFP)kd_rtcsr},   /*right arrow key            */
    {KEY_UP, (KEYFP)ks_up},      /*up arrow key               */
    {KEY_DN, (KEYFP)ks_dn},      /*down arrow key            */
    {KEY_ESC, (KEYFP)k_quit},      /*quit data form key            */
    {KEY_ENTER, (KEYFP)kd_next},   /*next field key            */
    {KEY_INS, (KEYFP)kd_instoggle},   /*insert mode key            */
    {KEY_DEL, (KEYFP)kd_chdel},    /*delete key               */
    {KEY_BACK, (KEYFP)kd_backsp},   /*backspace key             */
#ifdef VV_BOOL
    {KEY_SPACE, (KEYFP)kd_booltoggle},   /*boolean toggle key            */
#endif
    {KEY_TAB, (KEYFP)kd_next},      /*next scrollable field key         */
    {KEY_STAB, (KEYFP)kd_prev},    /*previous scrollable field key       */
    {KT_DEFAULT, (KEYFP)kd_chproc},   /*print keystroke in field         */
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_MEMO

GLOBAL KT _memokt[] =         /*Memo Editor Key Definition Table    */
{
#ifdef VV_HELP
    {KEY_F1, (KEYFP)kd_help},      /*help key               */
#endif
    {KEY_SF3, (KEYFP)ke_undofld},   /*restore field to original value     */
    {KEY_F4, (KEYFP)ke_reflow},    /*paragraph reflow            */
    {KEY_SF4, (KEYFP)ke_rowjoin},   /*row join               */
    {KEY_F5, (KEYFP)ke_rowins},    /*insert a row               */
    {KEY_F6, (KEYFP)ke_rowdel},    /*delete a row               */
    {KEY_SF6, (KEYFP)ke_deleorow},   /*delete to end of row            */
    {KEY_CF6, (KEYFP)ke_worddel},   /*delete to end of word          */
    {KEY_F7, (KEYFP)kd_previtem},   /*previous item key            */
    {KEY_SF7, (KEYFP)kd_prevfm},   /*previous form key            */
    {KEY_F8, (KEYFP)kd_nextitem},   /*next item key             */
    {KEY_SF8, (KEYFP)kd_nextfm},   /*next form key             */
    {KEY_F10, (KEYFP)k_exit},      /*exit data form key            */
    {KEY_HOME, (KEYFP)ke_rowbeg},   /*beginning of line, window and data  */
    {KEY_CHOME, (KEYFP)kd_firstitem},   /*go to first form item          */
    {KEY_END, (KEYFP)ke_txtend},   /*go to end of text            */
    {KEY_CEND, (KEYFP)kd_lastitem},   /*go to last form item            */
    {KEY_PGUP, (KEYFP)ke_pgup},    /*page up               */
    {KEY_CPGUP, (KEYFP)ke_memobeg},   /*go to beginning of memo         */
    {KEY_PGDN, (KEYFP)ke_pgdn},    /*page down               */
    {KEY_CPGDN, (KEYFP)ke_memoend},   /*go to end of memo            */
    {KEY_LEFT, (KEYFP)ke_lft},      /*move the cursor to the left         */
    {KEY_CLEFT, (KEYFP)ke_wordprev},   /*go to previous word            */
    {KEY_RIGHT, (KEYFP)ke_rt},      /*move the cursor to the right         */
    {KEY_CRIGHT, (KEYFP)ke_wordnext},   /*go to next word            */
    {KEY_UP, (KEYFP)ke_up},      /*move up one row            */
    {KEY_DN, (KEYFP)ke_dn},      /*move down one row            */
    {KEY_ESC, (KEYFP)k_quit},      /*abort data form key            */
    {KEY_ENTER, (KEYFP)ke_rowsplit},   /*split line key            */
    {KEY_INS, (KEYFP)kd_instoggle},   /*insert mode key            */
    {KEY_DEL, (KEYFP)ke_chdel},    /*delete key               */
    {KEY_BACK, (KEYFP)ke_backsp},   /*backspace key             */
    {KEY_TAB, (KEYFP)kd_nextitem},   /*next item key             */
    {KEY_STAB, (KEYFP)kd_previtem},   /*previous item key            */
    {KT_DEFAULT, (KEYFP)ke_chproc},   /*print keystroke in field         */
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};


GLOBAL KT _ttmemokt[] =       /*Ticker Tape Memo Field Key Table    */
{
#ifdef VV_HELP
    {KEY_F1, (KEYFP)kd_help},      /*help key               */
#endif
    {KEY_SF3, (KEYFP)ke_undofld},   /*restore field to original value     */
    {KEY_F6, (KEYFP)ke_rowdel},    /*delete row               */
    {KEY_SF6, (KEYFP)ke_deleorow},   /*delete to end of row            */
    {KEY_CF6, (KEYFP)ke_worddel},   /*delete to end of word          */
    {KEY_F7, (KEYFP)kd_previtem},   /*previous item key            */
    {KEY_SF7, (KEYFP)kd_prevfm},   /*previous form key            */
    {KEY_F8, (KEYFP)kd_nextitem},   /*next item key             */
    {KEY_SF8, (KEYFP)kd_nextfm},   /*next form key             */
    {KEY_F10, (KEYFP)k_exit},      /*exit data form key            */
    {KEY_HOME, (KEYFP)ke_rowbeg},   /*beginning of line            */
    {KEY_CHOME, (KEYFP)kd_firstitem},   /*go to first form item          */
    {KEY_END, (KEYFP)ke_txtend},   /*go to end of text            */
    {KEY_CEND, (KEYFP)kd_lastitem},   /*go to last form item            */
    {KEY_LEFT, (KEYFP)ke_lft},      /*move the cursor to the left         */
    {KEY_CLEFT, (KEYFP)ke_wordprev},   /*go to previous word            */
    {KEY_RIGHT, (KEYFP)ke_rt},      /*move the cursor to the right         */
    {KEY_CRIGHT, (KEYFP)ke_wordnext},   /*go to next word            */
    {KEY_UP, (KEYFP)kd_upitem},    /*up arrow key               */
    {KEY_DN, (KEYFP)kd_dnitem},    /*down arrow key            */
    {KEY_ESC, (KEYFP)k_quit},      /*abort data form key            */
    {KEY_ENTER, (KEYFP)kd_nextitem},   /*move to next item            */
    {KEY_INS, (KEYFP)kd_instoggle},   /*insert mode key            */
    {KEY_DEL, (KEYFP)ke_chdel},    /*delete key               */
    {KEY_BACK, (KEYFP)ke_backsp},   /*backspace key             */
    {KEY_TAB, (KEYFP)kd_nextitem},   /*move to next item            */
    {KEY_STAB, (KEYFP)kd_previtem},   /*move to previous item          */
    {KT_DEFAULT, (KEYFP)ke_chproc},   /*print keystroke in field         */
    {0, (KEYFP)NULLFP},
    {0, (KEYFP)NULLFP},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif


#ifdef VV_DEBUG

GLOBAL KT _dbkt[] =         /*Debugging System Key Table         */
{
    {KEY_LEFT, (KEYFP)kv_lft},
    {KEY_RIGHT, (KEYFP)kv_rt},
    {KEY_UP, (KEYFP)kv_up},
    {KEY_DN, (KEYFP)kv_dn},
    {KEY_PGUP, (KEYFP)kv_pgup},
    {KEY_PGDN, (KEYFP)kv_pgdn},
    {KEY_HOME, (KEYFP)kv_home},
    {KEY_END, (KEYFP)kv_end},
    {KEY_ESC, (KEYFP)k_exit},
    {KT_DEFAULT, (KEYFP)k_beep},
    {KT_END, (KEYFP)NULLFP}      /*end of table marker            */
};

#endif

#ifdef VV_KEY

GLOBAL KTPTR _ktptbl[] =      /*Table of Key Tables            */
{
    _syskt,            /*system key table            */
#ifdef VV_WNKT
    _viewkt,            /*view system key table          */
#else
    (KTPTR)NULLP,
#endif
#ifdef VV_HELP
    _helpkt,            /*help system key table          */
#else
    (KTPTR)NULLP,
#endif
#ifdef VV_WNKT
    _dragkt,            /*drag key table            */
#else
    (KTPTR)NULLP,
#endif
#ifdef VV_CLIST
    _clistkt,            /*choice list key table          */
#else
    (KTPTR)NULLP,
#endif
#ifdef VV_FIELD
    _formkt,            /*form editor key table          */
#else
    (KTPTR)NULLP,
#endif
#ifdef VV_MENU
    _menukt,            /*menu system key table          */
#else
    (KTPTR)NULLP,
#endif
#ifdef VV_SR
    _srkt,            /*scrollable region editor key table  */
#else
    (KTPTR)NULLP,
#endif
#ifdef VV_MEMO
    _memokt,            /*memo editor key table          */
    _ttmemokt            /*ticker tape memo key table         */
#else
    (KTPTR)NULLP,
    (KTPTR)NULLP
#endif
};

#endif


/******************************************************************************/
/*                                 */
/*  Field type specific information table                  */
/*                                 */
/******************************************************************************/

#ifdef VV_FORM

#ifndef NO_DEBUG_CODE
#define PICVALFP    pic_val
#else
#define PICVALFP    NULLFP
#endif

GLOBAL FLDTYPE _fldinfo[] =
{
#ifdef VV_BOOL            /*BOOLEAN field             */
    { FIELDTAG, dc_tobool, dc_frbool, vf_bool, PICVALFP, OFF_CHAR,
      sizeof(UCHAR), 0, 0, 0L, (UCHAR *) "XA!Z", NULLFP, ALLOW_PROT_CH },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_CHAR, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_CHAR            /*CHARACTER field            */
    { FIELDTAG, dc_toch, dc_frch, vf_ch, PICVALFP, OFF_CHAR,
      sizeof(UCHAR), 0, sizeof(RGCH), 0L, (UCHAR *) "XA9#!@ZU",
      rgset, ALLOW_PROT_CH | ALLOW_DECIMAL },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_CHAR, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_STR            /*STRING field               */
    { FIELDTAG, dc_tost, dc_frst, vf_st, PICVALFP, OFF_STRING, 0, 0,
      sizeof(RGST), 0L, (UCHAR *) "XA9#!@ZU", rgset_st,
      ALLOW_PROT_CH | ALLOW_DECIMAL | ALLOW_MULT_PICSYM },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_DATE            /*DATE field               */
    { FIELDTAG, dc_todate, dc_frdate, vf_date, PICVALFP, OFF_STRING, 0, 0,
      sizeof(RGLONG), TRAILBLANKS, (UCHAR *) "9UA!X", rgset_date,
      ALLOW_PROT_CH | ALLOW_MULT_PICSYM },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_TIME            /*TIME field               */
    { FIELDTAG, dc_totime, dc_frtime, vf_time, PICVALFP, OFF_STRING, 0, 0,
      sizeof(RGLONG), TRAILBLANKS, (UCHAR *) "9UA!X", rgset_time,
      ALLOW_PROT_CH | ALLOW_MULT_PICSYM },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_SHORT          /*SHORT INTEGER field            */
    { FIELDTAG, dc_toshort, dc_frshort, vf_short, PICVALFP, OFF_SHORT,
      sizeof(short), 6,sizeof(RGSHORT), CLEARONKEY | RTADJUST,
      (UCHAR *) "9U", rgset, ALLOW_MULT_PICSYM },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_SHORT, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_INT            /*INTEGER field             */
    { FIELDTAG, dc_toint, dc_frint, vf_int, PICVALFP, OFF_INT,
      sizeof(int), 6, sizeof(RGINT), CLEARONKEY | RTADJUST,
      (UCHAR *) "9U", rgset, ALLOW_MULT_PICSYM },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_INT, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_LONG            /*LONG INTEGER field            */
    { FIELDTAG, dc_tolong, dc_frlong, vf_long, PICVALFP, OFF_LONG,
      sizeof(long), 11, sizeof(RGLONG), CLEARONKEY | RTADJUST, (UCHAR *) "9U",
      rgset, ALLOW_MULT_PICSYM },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_LONG, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_DEC            /*DECIMAL field             */
    { FIELDTAG, dc_todec, dc_frdec, vf_dec, PICVALFP, OFF_LONG,
      sizeof(long), 24, sizeof(RGLONG), CLEARONKEY | RTADJUST,
      (UCHAR *) "9#@U", rgset, ALLOW_DECIMAL | ALLOW_MULT_PICSYM },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_LONG, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_FLOAT          /*FLOATING POINT field            */
    { FIELDTAG, dc_tofloat, dc_frfloat, vf_float, PICVALFP, OFF_DOUBLE,
      sizeof(double), 32, sizeof(RGFLOAT), CLEARONKEY | RTADJUST,
      (UCHAR *) "9#@U", rgset,  ALLOW_DECIMAL | ALLOW_E | ALLOW_MULT_PICSYM },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_DOUBLE, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_MEMO            /*MEMO field               */
    { FIELDTAG, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif

#ifdef VV_MENU            /*MENU field               */
    { FIELDTAG, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#else
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
#endif
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 },
    { 0, NULLFP, NULLFP, NULLFP, NULLFP,
   OFF_STRING, 0, 0, 0, 0L, (UCHAR *)NULLP, NULLFP, 0 }
};



/******************************************************************************/
/*                                 */
/*  Field picture symbol (character validation) table               */
/*                                 */
/******************************************************************************/

/*  The order of this array must conform to the picture symbol type #defines  */

GLOBAL DPICDEF _dpictbl[] =
{
    {'X', vc_ascii},                    /*any ascii character                 */
    {'A', vc_alpha},                    /*any alpha character                 */
    {'9', vc_digit},                    /*any digit 0-9, +, -                 */
    {'#', vc_num},                      /*any number 0-9, +, -, ., E          */
    {'!', vc_toupper},                  /*convert any ascii to uppercase      */
    {'@', vc_num},                      /*soft decimal point                  */
    {'Z', vc_anych},                    /*any character that can be generated */
    {'U', vc_unsigned},                 /*any digit 0-9 (no sign allowed)     */
    { 0 , NULLFP},
    { 0 , NULLFP},
    {KT_END, NULLFP}         /*end of table marker            */
};

#endif

/******************************************************************************/
/*                                 */
/*  Extended Character Set Support                     */
/*                                 */
/******************************************************************************/

#ifdef VV_EXTCH

GLOBAL int _chsetext = ON;      /*turn on extended character set      */
GLOBAL CHEXT _chsettbl[] =      /*case conversion table for codes:    */
{
    {135, CH_ALPHA | CH_UPPER},              /*128         */
    {154, CH_ALPHA | CH_LOWER},              /*129         */
    {144, CH_ALPHA | CH_LOWER},              /*130         */
    {'A', CH_ALPHA | CH_LOWER},                             /*131             */
    {142, CH_ALPHA | CH_LOWER},              /*132         */
    {'A', CH_ALPHA | CH_LOWER},                             /*133             */
    {143, CH_ALPHA | CH_LOWER},              /*134         */
    {128, CH_ALPHA | CH_LOWER},              /*135         */
    {'E', CH_ALPHA | CH_LOWER},                             /*136             */
    {'E', CH_ALPHA | CH_LOWER},                             /*137             */
    {'E', CH_ALPHA | CH_LOWER},                             /*138             */
    {'I', CH_ALPHA | CH_LOWER},                             /*139             */
    {'I', CH_ALPHA | CH_LOWER},                             /*140             */
    {'I', CH_ALPHA | CH_LOWER},                             /*141             */
    {132, CH_ALPHA | CH_UPPER},              /*142         */
    {134, CH_ALPHA | CH_UPPER},              /*143         */
    {130, CH_ALPHA | CH_UPPER},              /*144         */
    {146, CH_ALPHA | CH_LOWER},              /*145         */
    {145, CH_ALPHA | CH_UPPER},              /*146         */
    {'O', CH_ALPHA | CH_LOWER},                             /*147             */
    {153, CH_ALPHA | CH_LOWER},              /*148         */
    {'O', CH_ALPHA | CH_LOWER},                             /*149             */
    {'U', CH_ALPHA | CH_LOWER},                             /*150             */
    {'U', CH_ALPHA | CH_LOWER},                             /*151             */
    {'Y', CH_ALPHA | CH_LOWER},                             /*152             */
    {148, CH_ALPHA | CH_UPPER},              /*153         */
    {129, CH_ALPHA | CH_UPPER},              /*154         */
    {155, 0},                      /*155         */
    {156, 0},                      /*156         */
    {157, 0},                      /*157         */
    {158, 0},                      /*158         */
    {159, 0},                      /*159         */
    {'A', CH_ALPHA | CH_LOWER},                             /*160             */
    {'I', CH_ALPHA | CH_LOWER},                             /*161             */
    {'O', CH_ALPHA | CH_LOWER},                             /*162             */
    {'U', CH_ALPHA | CH_LOWER},                             /*163             */
    {165, CH_ALPHA | CH_LOWER},              /*164         */
    {164, CH_ALPHA | CH_UPPER},              /*165         */
    {'A', CH_ALPHA | CH_LOWER},                             /*166             */
    {'O', CH_ALPHA | CH_LOWER},                             /*167             */
    {168, 0},                      /*168         */
    {169, 0},                      /*169         */
    {170, 0},                      /*170         */
    {171, 0},                      /*171         */
    {172, 0},                      /*172         */
    {173, 0},                      /*173         */
    {174, 0},                      /*174         */
    {175, 0},                      /*175         */
    {176, CH_GRAPHIC},                   /*176         */
    {177, CH_GRAPHIC},                   /*177         */
    {178, CH_GRAPHIC},                   /*178         */
    {179, CH_GRAPHIC},                   /*179         */
    {180, CH_GRAPHIC},                   /*180         */
    {181, CH_GRAPHIC},                   /*181         */
    {182, CH_GRAPHIC},                   /*182         */
    {183, CH_GRAPHIC},                   /*183         */
    {184, CH_GRAPHIC},                   /*184         */
    {185, CH_GRAPHIC},                   /*185         */
    {186, CH_GRAPHIC},                   /*186         */
    {187, CH_GRAPHIC},                   /*187         */
    {188, CH_GRAPHIC},                   /*188         */
    {189, CH_GRAPHIC},                   /*189         */
    {190, CH_GRAPHIC},                   /*190         */
    {191, CH_GRAPHIC},                   /*191         */
    {192, CH_GRAPHIC},                   /*192         */
    {193, CH_GRAPHIC},                   /*193         */
    {194, CH_GRAPHIC},                   /*194         */
    {195, CH_GRAPHIC},                   /*195         */
    {196, CH_GRAPHIC},                   /*196         */
    {197, CH_GRAPHIC},                   /*197         */
    {198, CH_GRAPHIC},                   /*198         */
    {199, CH_GRAPHIC},                   /*199         */
    {200, CH_GRAPHIC},                   /*200         */
    {201, CH_GRAPHIC},                   /*201         */
    {202, CH_GRAPHIC},                   /*202         */
    {203, CH_GRAPHIC},                   /*203         */
    {204, CH_GRAPHIC},                   /*204         */
    {205, CH_GRAPHIC},                   /*205         */
    {206, CH_GRAPHIC},                   /*206         */
    {207, CH_GRAPHIC},                   /*207         */
    {208, CH_GRAPHIC},                   /*208         */
    {209, CH_GRAPHIC},                   /*209         */
    {210, CH_GRAPHIC},                   /*210         */
    {211, CH_GRAPHIC},                   /*211         */
    {212, CH_GRAPHIC},                   /*212         */
    {213, CH_GRAPHIC},                   /*213         */
    {214, CH_GRAPHIC},                   /*214         */
    {215, CH_GRAPHIC},                   /*215         */
    {216, CH_GRAPHIC},                   /*216         */
    {217, CH_GRAPHIC},                   /*217         */
    {218, CH_GRAPHIC},                   /*218         */
    {219, CH_GRAPHIC},                   /*219         */
    {220, CH_GRAPHIC},                   /*220         */
    {221, CH_GRAPHIC},                   /*221         */
    {222, CH_GRAPHIC},                   /*222         */
    {223, CH_GRAPHIC},                   /*223         */
    {224, CH_ALPHA | CH_LOWER | CH_UPPER},          /*224         */
    {225, CH_ALPHA | CH_LOWER | CH_UPPER},          /*225         */
    {226, CH_ALPHA | CH_LOWER | CH_UPPER},          /*226         */
    {227, CH_ALPHA | CH_LOWER | CH_UPPER},          /*227         */
    {228, CH_ALPHA | CH_LOWER | CH_UPPER},          /*228         */
    {229, CH_ALPHA | CH_LOWER | CH_UPPER},          /*229         */
    {230, CH_ALPHA | CH_LOWER | CH_UPPER},          /*230         */
    {231, CH_ALPHA | CH_LOWER | CH_UPPER},          /*231         */
    {232, CH_ALPHA | CH_LOWER | CH_UPPER},          /*232         */
    {233, CH_ALPHA | CH_LOWER | CH_UPPER},          /*233         */
    {234, CH_ALPHA | CH_LOWER | CH_UPPER},          /*234         */
    {235, CH_ALPHA | CH_LOWER | CH_UPPER},          /*235         */
    {236, CH_ALPHA | CH_LOWER | CH_UPPER},          /*236         */
    {237, CH_ALPHA | CH_LOWER | CH_UPPER},          /*237         */
    {238, 0},                      /*238         */
    {239, 0},                      /*239         */
    {240, 0},                      /*240         */
    {241, 0},                      /*241         */
    {242, 0},                      /*242         */
    {243, 0},                      /*243         */
    {244, 0},                      /*244         */
    {245, 0},                      /*245         */
    {246, 0},                      /*246         */
    {247, 0},                      /*247         */
    {248, 0},                      /*248         */
    {249, 0},                      /*249         */
    {250, 0},                      /*250         */
    {251, 0},                      /*251         */
    {252, 0},                      /*252         */
    {253, 0},                      /*253         */
    {254, 0},                      /*254         */
    {255, 0}                      /*255         */
};

#else

GLOBAL int _chsetext = OFF;      /*turn off extended character set     */
GLOBAL CHEXT _chsettbl[1];

#endif               /*end of extended characters support  */


/******************************************************************************/
/*                                 */
/*  Line intersection characters array                     */
/*                                 */
/*  The initialization is only for PCDOS and OS2.  Intersecting lines are not */
/*  supported under UNIX and VMS.                     */
/*                                 */
/******************************************************************************/

#ifdef   NEC_PC9801
GLOBAL UCHAR _linecode [LNCHARQ] =
{
/*  Character      143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153,     */
/*  Line code */    85,  69,  84,  81,  21, 255,  68,  17, 255,  20,  80,

/*  154, 155, 156, 157, 158, 159 */
      5,  65,  40, 160,  10, 130
};
GLOBAL UCHAR _linecode2 [LNCHARQ2] =
{
/*  Character      224, 225, 226, 227 */
/*  Line code */   136,  25, 153, 145
} ;
#else   /* NEC_PC9801 */
GLOBAL UCHAR _linecode [LNCHARQ] =
{
/*                                                         */
/*  Character      179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,     */
/*  Line code */    17,  81, 145,  98,   96, 144, 162,  34, 160, 130,  66,

/*                                                               */
/*  190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203,     */
    129,  80,   5,  69, 84,  21,  68,  85,  25,   38,  10,  40, 138, 168,

/*                                                              */
/*  204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218 */
     42, 136, 170, 137,  70, 152, 100,    6,   9,  24,  36, 102, 153,  65, 20
};
#endif   /* NEC_PC9801 */

/******************************************************************************/
/*                                 */
/*  Month names                            */
/*                                 */
/******************************************************************************/

GLOBAL UCHAR *_months[12] =
{
    (UCHAR *) "January",
    (UCHAR *) "February",
    (UCHAR *) "March",
    (UCHAR *) "April",
    (UCHAR *) "May",
    (UCHAR *) "June",
    (UCHAR *) "July",
    (UCHAR *) "August",
    (UCHAR *) "September",
    (UCHAR *) "October",
    (UCHAR *) "November",
    (UCHAR *) "December"
};

/******************************************************************************/
/*                                 */
/*  Globals associated with the form processing                */
/*                                 */
/******************************************************************************/

#ifdef VV_FORM

GLOBAL int _val_err;         /*field editor validation error       */
GLOBAL int _val_last;         /*last validation error          */
GLOBAL UCHAR _dvalmsg[12];      /*default validation message         */
               /*supplemental boolean validation msg */
GLOBAL UCHAR * _boolerr = (UCHAR *) " / ";
GLOBAL UCHAR * _errstp;       /*validation error string         */
GLOBAL int _mnselectkey = KEY_ENTER;   /*set the menu selection key         */
GLOBAL int _clistkey = KEY_F2;      /*set the choice list key         */
GLOBAL WINDOW _fm_wn;         /*default form window            */
GLOBAL WINDOW _mn_wn;         /*default menu window            */
GLOBAL WINDOW _err_wn;         /*default error window            */
GLOBAL int _bgtxtsize = sizeof(BG_TXT); /*size of the background text struc   */
GLOBAL int _bgboxsize = sizeof(BG_BOX); /*size of the background box struc    */
GLOBAL int _bgfillsize = sizeof(BG_FILL);  /*size of the background fill struc*/
GLOBAL int _bglinesize = sizeof(BG_LINE);  /*size of the background line struc*/
GLOBAL int _formsize = sizeof(DFORM);   /*size of the form structure         */
GLOBAL int _mnsize = sizeof(MFORM);   /*size of the menu structure         */
GLOBAL int _srsize = sizeof(SR);   /*size of the scrollable region struct*/
GLOBAL int _dfldsize = sizeof(DFIELD);   /*size of the data field structure    */
GLOBAL int _mfldsize = sizeof(MFIELD);   /*size of the menu field structure    */
GLOBAL int _memosize = sizeof(MEMO);   /*size of the memo structure         */
               /*Default Data Entry Form Options     */
GLOBAL long _fmopt = VERIFYQUIT | AUTOEXIT | AUTOMOVE;
               /*Default Menu Options            */
GLOBAL long _mnopt = MNCHSELECT | MNTOPESCAPE | MNREDISPLAY | MNMSGAUTOPLACE |
           FMWRAP;
GLOBAL NODEPTR _pichdndp;      /*pointer to header node in linked    */
               /*list of picture strings         */
GLOBAL FORMPTR _fmhdndp;      /*pointer to header node in linked    */
               /*list of forms             */
GLOBAL UCHAR _dpholdr = '.';            /*decimal place holder                */
GLOBAL UCHAR _thsep = ',';              /*thousands separator                 */
GLOBAL UCHAR _noechoch = '\0';          /*character to echo for NOECHO fields */
               /*nothing to echo by default         */
GLOBAL UCHAR _bool_no = 'n';            /*character used for negative boolean */
GLOBAL UCHAR _bool_yes = 'y';           /*character used for positive boolean */
GLOBAL UCHAR _d_padch = '0';            /*character used for padding dates    */
GLOBAL UCHAR _t_padch = '0';            /*character used for padding times    */

GLOBAL UCHAR _checkmark = 251;      /*default checkmark character         */

#ifdef LINT_ARGS

#ifdef VV_MENU
GLOBAL int (FASTCALL * _mn_updfp)(DFORMPTR) = (PFI)mn_upd;
#else
GLOBAL int (FASTCALL * _mn_updfp)(DFORMPTR) = (PFI)NULLFP;
#endif

#ifdef VV_MEMO
GLOBAL int (FASTCALL * _memo_updfp)(WINDOWPTR) = (PFI)mf_disp;
#else
GLOBAL int (FASTCALL * _memo_updfp)(WINDOWPTR) = (PFI)NULLFP;
#endif

#else

#ifdef VV_MENU
GLOBAL int (FASTCALL * _mn_updfp)() = (PFI)mn_upd;
#else
GLOBAL int (FASTCALL * _mn_updfp)() = (PFI)NULLFP;
#endif

#ifdef VV_MEMO
GLOBAL int (FASTCALL * _memo_updfp)() = (PFI)mf_disp;
#else
GLOBAL int (FASTCALL * _memo_updfp)() = (PFI)NULLFP;
#endif

#endif

#endif               /*End form processing globals         */


/******************************************************************************/
/*                                 */
/*  Designer Library Forms Support                     */
/*                                 */
/******************************************************************************/

/*----------------------------------------------------------------------------*/
/*  These externals are needed in all applications -- referenced in exit_vv() */
/*  and other low level functions                     */
/*----------------------------------------------------------------------------*/

GLOBAL NODEPTR _liblathdndp;      /*linked list of library logical att  */
GLOBAL int     _dllocking = TRUE;   /*Enable/disable library locking      */
GLOBAL UCHAR   *_lock_ext = (UCHAR *) ".vv$";
               /*extension used to create directories*/
               /*for file-level locking         */

/*----------------------------------------------------------------------------*/
/*  Remaining Designer variables are conditional               */
/*----------------------------------------------------------------------------*/
#ifdef VV_DES
GLOBAL int _maxrgconv = 0;      /*Maximum size for range conv. buffer */
GLOBAL int _lswap = VVNOSWAP;      /*Indicates whether to swap bytes when*/
               /*reading shorts or longs from library*/
GLOBAL UCHAR _align_offset[QALIGN];   /*Data structure alignment offset     */
GLOBAL UCHAR *_temp_strp;      /*Temporary string buffer pointer     */
GLOBAL UCHAR *_perm_strp;      /*Permanent string buffer pointer     */
               /*Lib log attr. for default windows   */
GLOBAL UCHAR *_deflibname = (UCHAR *) NULLP;   

GLOBAL BORDERPTR _borders[] =
{
    BDR_NULLP, BDR_SLNP, BDR_DLNP, BDR_SOLIDP, BDR_SPACEP, BDR_DOTP, BDR_STARP
};

/*----------------------------------------------------------------------------*/
/*  Globals used by designer library                     */
/*----------------------------------------------------------------------------*/
GLOBAL short _dirblankct = 20;   /*number of blank directory records to add    */
            /*when creating or packing a library         */
GLOBAL short _locktryct = 5;   /*number of times we will try to lock a file  */
            /*before returning               */
GLOBAL long  _lockdelay = 100;   /*hundredths of seconds to delay before trying*/
            /*again to lock a file               */

/*----------------------------------------------------------------------------*/
/*  Tables to use when reading/writing library records               */
/*----------------------------------------------------------------------------*/
GLOBAL LT_HDR _lt_hdr =       /*global table for library header     */
{               /*record               */
    LRT_HDR,            /*record type               */
    LRC_HDR,            /*number of entries in table         */
    {{LD_SHORT, 2, 0},         /*library type               */
    {LD_UCHAR,   1, 2},         /*library version            */
    {LD_UCHAR,   1, 3},         /*library sub version            */
    {LD_SHORT,   2, 4},         /*active record count            */
    {LD_SHORT,   2, 6},         /*total record count            */
    {LD_LONG,   4, 8},         /*offset to logical attribute records */
    {LD_SHORT,   2, 12},       /*library flags             */
    {LD_UCHARRAY, 50, 14}}      /*reserved bytes for password         */
};

GLOBAL LT_LATT _lt_latt =      /*global table for logical attribute  */
{               /*record               */
    LRT_LATT,            /*record type               */
    LRC_LATT,            /*number of entries in table         */
    {{LD_UCHARRAY, 102, 0},      /*Array of monochrome attributes      */
    {LD_UCHARRAY, 102, 102}}      /*array of color physical attributes  */
};

GLOBAL LT_LANAMES _lt_lanames =    /*global table for logical attribute  */
{               /*names                */
    LRT_LANAMES,
    LRC_LANAMES,
    {{LD_UCHARRAY, 12, 0},      /*Name of User Logical Attribute 0    */
    {LD_UCHARRAY, 12, 12},      /*Name of User Logical Attribute 1    */
    {LD_UCHARRAY, 12, 24},      /*Name of User Logical Attribute 2    */
    {LD_UCHARRAY, 12, 36},      /*Name of User Logical Attribute 3    */
    {LD_UCHARRAY, 12, 48},      /*Name of User Logical Attribute 4    */
    {LD_UCHARRAY, 12, 60},      /*Name of User Logical Attribute 5    */
    {LD_UCHARRAY, 12, 72},      /*Name of User Logical Attribute 6    */
    {LD_UCHARRAY, 12, 84},      /*Name of User Logical Attribute 7    */
    {LD_UCHARRAY, 12, 96},      /*Name of User Logical Attribute 8    */
    {LD_UCHARRAY, 12, 108},      /*Name of User Logical Attribute 9    */
    {LD_UCHARRAY, 12, 120},      /*Name of User Logical Attribute 10   */
    {LD_UCHARRAY, 12, 132},      /*Name of User Logical Attribute 11   */
    {LD_UCHARRAY, 12, 144},      /*Name of User Logical Attribute 12   */
    {LD_UCHARRAY, 12, 156},      /*Name of User Logical Attribute 13   */
    {LD_UCHARRAY, 12, 168},      /*Name of User Logical Attribute 14   */
    {LD_UCHARRAY, 12, 180},      /*Name of User Logical Attribute 15   */
    {LD_UCHARRAY, 12, 192},      /*Name of User Logical Attribute 16   */
    {LD_UCHARRAY, 12, 204},      /*Name of User Logical Attribute 17   */
    {LD_UCHARRAY, 12, 216},      /*Name of User Logical Attribute 18   */
    {LD_UCHARRAY, 12, 228},      /*Name of User Logical Attribute 19   */
    {LD_UCHARRAY, 12, 240},      /*Name of User Logical Attribute 20   */
    {LD_UCHARRAY, 12, 252},      /*Name of User Logical Attribute 21   */
    {LD_UCHARRAY, 12, 264},      /*Name of User Logical Attribute 22   */
    {LD_UCHARRAY, 12, 276},      /*Name of User Logical Attribute 23   */
    {LD_UCHARRAY, 12, 288},      /*Name of User Logical Attribute 24   */
    {LD_UCHARRAY, 12, 300},      /*Name of User Logical Attribute 25   */
    {LD_UCHARRAY, 12, 312},      /*Name of User Logical Attribute 26   */
    {LD_UCHARRAY, 12, 324},      /*Name of User Logical Attribute 27   */
    {LD_UCHARRAY, 12, 336},      /*Name of User Logical Attribute 28   */
    {LD_UCHARRAY, 12, 348},      /*Name of User Logical Attribute 29   */
    {LD_UCHARRAY, 12, 360},      /*Name of User Logical Attribute 30   */
    {LD_UCHARRAY, 12, 372},      /*Name of User Logical Attribute 31   */
    {LD_UCHARRAY, 12, 384},      /*Name of User Logical Attribute 32   */
    {LD_UCHARRAY, 12, 396},      /*Name of User Logical Attribute 33   */
    {LD_UCHARRAY, 12, 408},      /*Name of User Logical Attribute 34   */
    {LD_UCHARRAY, 12, 420},      /*Name of User Logical Attribute 35   */
    {LD_UCHARRAY, 12, 432},      /*Name of User Logical Attribute 36   */
    {LD_UCHARRAY, 12, 444},      /*Name of User Logical Attribute 37   */
    {LD_UCHARRAY, 12, 456},      /*Name of User Logical Attribute 38   */
    {LD_UCHARRAY, 12, 468},      /*Name of User Logical Attribute 39   */
    {LD_UCHARRAY, 12, 480},      /*Name of User Logical Attribute 40   */
    {LD_UCHARRAY, 12, 492},      /*Name of User Logical Attribute 41   */
    {LD_UCHARRAY, 12, 504},      /*Name of User Logical Attribute 42   */
    {LD_UCHARRAY, 12, 516},      /*Name of User Logical Attribute 43   */
    {LD_UCHARRAY, 12, 528},      /*Name of User Logical Attribute 44   */
    {LD_UCHARRAY, 12, 540},      /*Name of User Logical Attribute 45   */
    {LD_UCHARRAY, 12, 552},      /*Name of User Logical Attribute 46   */
    {LD_UCHARRAY, 12, 564},      /*Name of User Logical Attribute 47   */
    {LD_UCHARRAY, 12, 576},      /*Name of User Logical Attribute 48   */
    {LD_UCHARRAY, 12, 588},      /*Name of User Logical Attribute 49   */
    {LD_UCHARRAY, 12, 600},      /*Name of User Logical Attribute 50   */
    {LD_UCHARRAY, 12, 612},      /*Name of User Logical Attribute 51   */
    {LD_UCHARRAY, 12, 624},      /*Name of User Logical Attribute 52   */
    {LD_UCHARRAY, 12, 636},      /*Name of User Logical Attribute 53   */
    {LD_UCHARRAY, 12, 648},      /*Name of User Logical Attribute 54   */
    {LD_UCHARRAY, 12, 660},      /*Name of User Logical Attribute 55   */
    {LD_UCHARRAY, 12, 672},      /*Name of User Logical Attribute 56   */
    {LD_UCHARRAY, 12, 684},      /*Name of User Logical Attribute 57   */
    {LD_UCHARRAY, 12, 696},      /*Name of User Logical Attribute 58   */
    {LD_UCHARRAY, 12, 708},      /*Name of User Logical Attribute 59   */
    {LD_UCHARRAY, 12, 720},      /*Name of User Logical Attribute 60   */
    {LD_UCHARRAY, 12, 732},      /*Name of User Logical Attribute 61   */
    {LD_UCHARRAY, 12, 744},      /*Name of User Logical Attribute 62   */
    {LD_UCHARRAY, 12, 756},      /*Name of User Logical Attribute 63   */
    {LD_UCHARRAY, 12, 768},      /*Name of User Logical Attribute 64   */
    {LD_UCHARRAY, 12, 780},      /*Name of User Logical Attribute 65   */
    {LD_UCHARRAY, 12, 792},      /*Name of User Logical Attribute 66   */
    {LD_UCHARRAY, 12, 804},      /*Name of User Logical Attribute 67   */
    {LD_UCHARRAY, 12, 816},      /*Name of User Logical Attribute 68   */
    {LD_UCHARRAY, 12, 828},      /*Name of User Logical Attribute 69   */
    {LD_UCHARRAY, 12, 840},      /*Name of User Logical Attribute 70   */
    {LD_UCHARRAY, 12, 852},      /*Name of User Logical Attribute 71   */
    {LD_UCHARRAY, 12, 864},      /*Name of User Logical Attribute 72   */
    {LD_UCHARRAY, 12, 876}}      /*Name of User Logical Attribute 73   */
};

GLOBAL LT_DIR _lt_dir =       /*global table for directory record   */
{
    LRT_DIR,            /*record type               */
    LRC_DIR,            /*number of entries in table         */
    {{LD_LONG,      4, 0},      /*starting offset of data         */
    {LD_LONG,      4, 4},      /*length of data            */
    {LD_SHORT,      2, 8},      /*Type of directory record         */
    {LD_SHORT,      2, 10},      /*length of directory record key      */
    {LD_UCHARRAY, 16, 12},      /*directory record key            */
    {LD_USHORT,    2, 28},      /*library flags             */
    {LD_UCHARRAY,  4, 30}}      /*user ID               */
};

GLOBAL LT_TEST _lt_test =
{
    LRT_TEST,
    LRC_TEST,
    {LD_LSTRING, 80, 0}
};

GLOBAL LT_OBJ _lt_obj =
{
    LRT_OBJ,
    LRC_OBJ,
    {{LD_SHORT,  2,  8},      /*object type               */
    {LD_SHORT,   2, 10},       /*object row begin            */
    {LD_SHORT,   2, 12},       /*object column begin            */
    {LD_SHORT,   2, 14},       /*object row end            */
    {LD_SHORT,   2, 16},       /*object column end            */
    {LD_SHORT,   2, 18},       /*sub_count               */
    {LD_USHORT, 2, 20},       /*object flags               */
    {LD_UCHAR,   1, 22},       /*attribute byte            */
    {LD_UCHAR,   1, 23},       /*border type               */
    {LD_SHORT,   2, 24},       /*object ID               */
    {LD_SHORT,   2, 26},       /*parent ID               */
    {LD_SHORT,   2, 28}}       /*text/field ID             */
};

GLOBAL LT_TEXT _lt_text =
{
    LRT_TEXT,
    LRC_TEXT,
    {LD_LSTRING, 254, 0}
};

GLOBAL LT_SR _lt_sr =
{
    LRT_SR,
    LRC_SR,
    {{LD_SHORT,    2,  0},      /*datarowq               */
    {LD_SHORT,     2,  2},      /*item count               */
    {LD_SHORT,     2,  4},      /*vis_rb               */
    {LD_SHORT,     2,  6},      /*vis_cb               */
    {LD_SHORT,     2,  8},      /*vis_rowq               */
    {LD_SHORT,     2, 10},      /*vis_colq               */
    {LD_UCHAR,     1, 12},      /*fill_att               */
    {LD_UCHAR,     1, 13},      /*flags                */
    {LD_SHORT,     2, 14},      /*rec_size               */
    {LD_LSTRING, 16, 16},      /*rec_name               */
    {LD_LSTRING, 16, 32},      /*scrlfunc               */
    {LD_LSTRING, 82, 48},      /*help string or keyword         */
    {LD_SHORT,     2, 130},      /*sequence ID               */
    {LD_LSTRING, 16, 132},      /*begin SR function            */
    {LD_LSTRING, 16, 148},      /*end SR function            */
    {LD_LSTRING, 16, 164},      /*begin row function            */
    {LD_LSTRING, 16, 180}}      /*end row function            */
};

GLOBAL LT_FMBEG _lt_fmbeg =
{
    LRT_FMBEG,
    LRC_FMBEG,
    {{LD_UCHARRAY, 10, 0},
    {LD_UCHARRAY, 16, 10}}
};

GLOBAL LT_FMEND _lt_fmend =
{
    LRT_FMEND,
    LRC_FMEND,
    {{LD_UCHARRAY, 7, 0}}
};

GLOBAL LT_FM _lt_fm =
{
    LRT_FM,
    LRC_FM,
    {{LD_SHORT,   2,   8},      /*type                  */
    {LD_SHORT,     2,  10},      /*objcount               */
    {LD_SHORT,     2,  12},      /*itemcount               */
    {LD_SHORT,     2,  14},      /*mncheckmark               */
    {LD_SHORT,     2,  16},      /*mnretlevel               */
    {LD_SHORT,     2,  18},      /*maxfldseq               */
    {LD_SHORT,     2,  20},      /*maxfldid               */
    {LD_SHORT,     2,  22},      /*permstbufsize             */
    {LD_SHORT,     2,  24},      /*tempstbufsize             */
    {LD_SHORT,     2,  26},      /*hfldscrlq               */
    {LD_SHORT,     2,  28},      /*vfldscrlq               */
    {LD_UCHAR,     1,  30},      /*security               */
    {LD_UCHAR,     1,  31},      /*border type               */
    {LD_LONG,     4,  32},      /*crdate               */
    {LD_LONG,     4,  36},      /*crtime               */
    {LD_LONG,     4,  40},      /*lmoddate               */
    {LD_LONG,     4,  44},      /*lmodtime               */
    {LD_LONG,     4,  48},      /*vv_flags               */
    {LD_LONG,     4,  52},      /*flags                */
    {LD_LSTRING, 16,  56},      /*name                  */
    {LD_LSTRING, 82,  72},      /*fmhelp               */
    {LD_LSTRING, 78, 154},      /*fmtitle               */
    {LD_LSTRING, 16, 232},      /*scrlfunc               */
    {LD_LSTRING, 16, 248},      /*begfunc               */
    {LD_LSTRING, 16, 264},      /*endfunc               */
    {LD_LSTRING, 16, 280},      /*valfunc               */
    {LD_LSTRING, 16, 296},      /*next_form               */
    {LD_LSTRING, 16, 312},      /*prev_form               */
    {LD_UCHAR,     1, 328}}      /*bgobjatt               */
};

GLOBAL LT_FMWN _lt_fmwn =
{
    LRT_FMWN,
    LRC_FMWN,
    {{LD_SHORT, 2,  0},       /*window rb               */
    {LD_SHORT, 2,  2},         /*window cb               */
    {LD_SHORT, 2,  4},         /*window re               */
    {LD_SHORT, 2,  6},         /*window ce               */
    {LD_SHORT, 2,  8},         /*title location            */
    {LD_UCHAR, 1, 10},         /*window attribute            */
    {LD_UCHAR, 1, 12},         /*border att               */
    {LD_UCHAR, 1, 11},         /*border type               */
    {LD_UCHAR, 1, 13},         /*title att               */
    {LD_SHORT, 2, 14},         /*row quantity for buffered window    */
    {LD_SHORT, 2, 16},         /*col quantity for buffered window    */
    {LD_SHORT, 2, 18}}         /*form type               */
};

GLOBAL LT_FMMSGWN _lt_fmmsgwn =
{
    LRT_FMMSGWN,
    LRC_FMMSGWN,
    {{LD_SHORT,    2,   0},      /*window rb               */
    {LD_SHORT,      2,   2},      /*window cb               */
    {LD_SHORT,      2,   4},      /*window rowq               */
    {LD_SHORT,      2,   6},      /*window colq               */
    {LD_SHORT,      2,   8},      /*title location            */
    {LD_UCHAR,      1,  10},      /*window attribute            */
    {LD_UCHAR,      1,  11},      /*border type               */
    {LD_UCHAR,      1,  12},      /*border att               */
    {LD_UCHAR,      1,  13},      /*title att               */
    {LD_LSTRING,  78,  14}}      /*title                */
};


GLOBAL LT_FMDOC _lt_fmdoc =
{
    LRT_FMDOC,
    LRC_FMDOC,
    {{LD_LSTRING, 24,  0},      /*project name               */
    {LD_LSTRING, 16, 24},      /*form ID               */
    {LD_LSTRING, 24, 40},      /*programmer name            */
    {LD_LSTRING, 16, 64},      /*revision level            */
    {LD_SHORT,     2, 80}}      /*length of form notes            */
};

GLOBAL LT_FMNOTES _lt_fmnotes =
{
    LRT_FMNOTES,
    LRC_FMNOTES,
    {{LD_LSTRING, 301, 0}}
};

GLOBAL LT_CLIST _lt_clist =
{
    LRT_CLIST,
    LRC_CLIST,
    {{LD_SHORT,   2,   0},      /*clist window row begin         */
    {LD_SHORT,     2,   2},      /*clist window col begin         */
    {LD_SHORT,     2,   4},      /*clist window rowq            */
    {LD_SHORT,     2,   6},      /*clist window colq            */
    {LD_SHORT,     2,   8},      /*curitem               */
    {LD_SHORT,     2,  10},      /*title location            */
    {LD_SHORT,     2,  12},      /*VV flags               */
    {LD_UCHAR,     1,  14},      /*act_att               */
    {LD_UCHAR,     1,  15},      /*inact_att               */
    {LD_UCHAR,     1,  16},      /*border type               */
    {LD_UCHAR,     1,  17},      /*border attribute            */
    {LD_UCHAR,     1,  18},      /*title attribute            */
    {LD_UCHAR,     1,  19},      /*flags                */
    {LD_LSTRING, 78,  20},      /*choice list title            */
    {LD_LSTRING, 82,  98},      /*choice list keyword            */
    {LD_LSTRING, 82, 180}}      /*choice list help            */
};

GLOBAL LT_FLDRANGE _lt_fldrange =
{
    LRT_FLDRANGE,
    LRC_FLDRANGE,
    {{LD_LSTRING, 82,  0},      /*min                  */
    {LD_LSTRING, 82, 82}}      /*max                  */
};

GLOBAL LT_TOGGLE _lt_toggle =
{
    LRT_TOGGLE,
    LRC_TOGGLE,
    {{LD_SHORT,    2,   0},      /*number of leading underscores       */
    {LD_SHORT,    2,   2},      /*number of trailing underscores      */
    {LD_UCHAR,   1,   4},      /*yes string attribute            */
    {LD_UCHAR,    1,   5},      /*no string attribute            */
    {LD_LSTRING, 82,  6},      /*yes string               */
    {LD_LSTRING, 82, 88}}      /*no string               */
};

GLOBAL LT_FLD _lt_fld =
{
    LRT_FLD,
    LRC_FLD,
    {{LD_SHORT,   2,   0},      /*field type               */
    {LD_SHORT,     2,   2},      /*sequence id               */
    {LD_SHORT,     2,   4},      /*field id number            */
    {LD_SHORT,     2,   6},      /*memo_rowq               */
    {LD_SHORT,     2,   8},      /*memo_colq               */
    {LD_SHORT,     2,  10},      /*picskiplen               */
    {LD_LONG,     4,  12},      /*VV field flags            */
    {LD_LONG,     4,  16},      /*VVD flags               */
    {LD_UCHAR,     1,  20},      /*active att               */
    {LD_UCHAR,     1,  21},      /*inactive att               */
    {LD_UCHAR,     1,  22},      /*skip att               */
    {LD_UCHAR,     1,  23},      /*selchar att               */
    {LD_UCHAR,     1,  24},      /*selchar position            */
    {LD_UCHAR,     1,  25},      /*dummy                */
    {LD_UCHAR,     1,  26},      /*bool_yes               */
    {LD_UCHAR,     1,  27},      /*bool_no               */
    {LD_LSTRING, 16,  28},      /*field name               */
    {LD_LSTRING, 82,  44},      /*field message             */
    {LD_LSTRING, 82, 126},      /*field help string            */
    {LD_LSTRING, 16, 208},      /*begin field func            */
    {LD_LSTRING, 16, 224},      /*end field func            */
    {LD_LSTRING, 16, 240},      /*val field func            */
    {LD_LSTRING, 16, 256},      /*action func               */
    {LD_LSTRING, 16, 272},      /*sub_form name             */
    {LD_LSTRING, 22, 288},      /*date/time format string         */
    {LD_LSTRING, 16, 310}}      /*variable name             */
};

GLOBAL LT_FLDPIC _lt_fldpic =
{
    LRT_FLDPIC,
    LRC_FLDPIC,
    {{LD_LSTRING, 256, 0}}      /*field picture             */
};

GLOBAL LT_FLDNOTES _lt_fldnotes =
{
    LRT_FLDNOTES,
    LRC_FLDNOTES,
    {{LD_LSTRING, 301, 0}}      /*field notes               */
};

GLOBAL LT_TABLEPTR _tblarray[] =
{
    (LT_TABLEPTR) NULLP,
    (LT_TABLEPTR)&_lt_hdr,
    (LT_TABLEPTR)&_lt_latt,
    (LT_TABLEPTR)&_lt_dir,
    (LT_TABLEPTR)&_lt_fm,
    (LT_TABLEPTR)&_lt_fmwn,
    (LT_TABLEPTR)&_lt_fmmsgwn,
    (LT_TABLEPTR)&_lt_fmdoc,
    (LT_TABLEPTR)&_lt_sr,
    (LT_TABLEPTR)&_lt_obj,
    (LT_TABLEPTR)&_lt_text,
    (LT_TABLEPTR)&_lt_fld,
    (LT_TABLEPTR)&_lt_fldpic,
    (LT_TABLEPTR)&_lt_fldnotes,
    (LT_TABLEPTR)&_lt_toggle,
    (LT_TABLEPTR)&_lt_fldrange,
    (LT_TABLEPTR)&_lt_clist,
    (LT_TABLEPTR)&_lt_fmnotes,
    (LT_TABLEPTR)&_lt_test,
    (LT_TABLEPTR)&_lt_lanames,
    (LT_TABLEPTR)&_lt_fmend,
    (LT_TABLEPTR)&_lt_fmbeg
};

#endif

/******************************************************************************/
/*                                 */
/*  Globals associated with the choice list processing               */
/*                                 */
/******************************************************************************/

GLOBAL int _clsize = sizeof(CLIST);   /*size of the choice list structure   */

/******************************************************************************/
/*                                 */
/*  Globals associated with the help system                  */
/*                                 */
/******************************************************************************/

#ifdef VV_HELP

GLOBAL int _help_rb;         /* Secondary help window coordinates  */
GLOBAL int _help_cb;
GLOBAL int _help_re;
GLOBAL int _help_ce;
GLOBAL UCHAR *_dhelpmsg;      /*default help message            */

#endif

/******************************************************************************/
/*                                 */
/*  Globals associated with the keyboard input system               */
/*                                 */
/******************************************************************************/

#ifdef VV_KEY

GLOBAL int _ki_last;         /* last keystroke entered         */
GLOBAL int _ki_max = SAMEKEYMAX;   /* max number of keys read by ki_same */

#ifdef LINT_ARGS
GLOBAL int (FASTCALL *_keyloopfp)(int);   /* pointer to key loop function       */
GLOBAL int (FASTCALL *_keyfilterfp)(int);/* pointer to key filter function    */
#else
GLOBAL int (FASTCALL *_keyloopfp)();   /* pointer to key loop function       */
GLOBAL int (FASTCALL *_keyfilterfp)();   /* pointer to key filter function     */
#endif

#endif

/******************************************************************************/
/*                                 */
/*  Border Structures                           */
/*                                 */
/******************************************************************************/

GLOBAL BORDER _bdr_space = {32, 32, 32, 32, 32, 32, 32, 32};
GLOBAL BORDER _bdr_star = {'*', '*', '*', '*', '*', '*', '*', '*'};

#ifdef   NEC_PC9801
GLOBAL BORDER _bdr_dot = {0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87};
GLOBAL BORDER _bdr_dln = {0x95, 0x95, 0x96, 0x96, 0x98, 0x99, 0x9b, 0x9a};
GLOBAL BORDER _bdr_sln = {0x95, 0x95, 0x96, 0x96, 0x98, 0x99, 0x9b, 0x9a};
GLOBAL BORDER _bdr_solid = {0x95, 0x95, 0x96, 0x96, 0x98, 0x99, 0x9b, 0x9a};
#else   /* NEC_PC9801 */
GLOBAL BORDER _bdr_dot = {178, 178, 178, 178, 178, 178, 178, 178};
GLOBAL BORDER _bdr_dln = {205, 205, 186, 186, 201, 187, 188, 200};
GLOBAL BORDER _bdr_sln = {196, 196, 179, 179, 218, 191, 217, 192};
GLOBAL BORDER _bdr_solid = {223, 220, 219, 219, 219, 219, 219, 219};
#endif   /* NEC_PC9801 */

/******************************************************************************/
/*                                 */
/*  Beep Array                              */
/*                                 */
/******************************************************************************/

GLOBAL BEEP _beeps[] =
{
    {BPLONG,   BPMIDDLE},      /* BPERROR               */
    {BPMEDIUM,   BPLOW},       /* BPNOACTION               */
    {OFF,   OFF}         /* BPAUTOMOVE               */
};

/******************************************************************************/
/*                                 */
/*  Globals necessary for the basic system                  */
/*                                 */
/******************************************************************************/

GLOBAL UCHAR _vv_yes = 'y';             /*valid positive response             */
GLOBAL UCHAR _vv_no = 'n';              /*valid negative response             */
               /*default date format            */
GLOBAL UCHAR *_datefmtp = (UCHAR *) "MM/DD/YY";
               /*default time format            */
GLOBAL UCHAR *_timefmtp = (UCHAR *) "HH:MM:SS";
               /* end of string table marker         */
GLOBAL UCHAR *_trt_end = (UCHAR *) "TRT_END";
               /* delimiter for start of translation */
GLOBAL UCHAR *_tr_beg = (UCHAR *) "<<";
               /* delimiter for end of translation   */
GLOBAL UCHAR *_tr_end = (UCHAR *) ">>";
GLOBAL UCHAR *_dbdumpp;       /* pointer to corrupted structure     */
GLOBAL WINDOW _clist_wn;      /*default choice list window         */
GLOBAL WINDOW _fullwn;         /*predefined full screen user window  */
GLOBAL WINDOW _msgwn;         /*default message window         */
GLOBAL WINDOW _vcswn;         /*VCS internal window            */
GLOBAL WINDOW _wn_wn;         /*default generic window         */
GLOBAL WINDOW _helpwn;         /*default help window            */
GLOBAL WINDOWPTR _help_wnp = &_helpwn;   /*global help window pointer         */
               /*index file extension            */
GLOBAL UCHAR * _indext = (UCHAR *) ".inx";
GLOBAL UCHAR _kwdch = '*';              /*keyword character for memory files  */
GLOBAL UCHAR _kwddelim = ',';           /*keyword delimiter for memory files  */
GLOBAL int _v_mode = -1;      /* current video mode            */
GLOBAL int _vid_echo;         /* enable updating under MSWindows or */
               /* TERMINAL.  For PCDOS systems, this */
               /* will be set to one if TopView or   */
               /* MS Windows system is present.      */
GLOBAL int _vv_err;         /* error code variable            */
GLOBAL UCHAR _derrmsg[12];      /* default error message         */
GLOBAL int _vv_init = FALSE;      /* initialization flag            */
GLOBAL int _vpstlen = VPSTMAXLEN;   /* maximum length of buffer associated*/
               /* with v_printf()            */
GLOBAL int _vv_tabq = 8;      /* Tab stops set every 8 columns      */
               /* Used for window tab expansion      */
GLOBAL int _csrvis;         /* cursor visibility flag         */
GLOBAL int _vpbytes;         /* number of bytes in vrb page         */
GLOBAL int _mfsize = sizeof(MFILE);   /* memory file structure size         */
GLOBAL int _wnsize = sizeof(WINDOW);   /* window structure size         */
GLOBAL int _scrsize = sizeof(SCR);   /* screen structure size         */
GLOBAL int _hiderow = -1;      /* hidden cursor coordinates storage  */
GLOBAL int _hidecol = -1;      /* must be initialized to -1         */
GLOBAL int _sbarsize = sizeof(SBAR);   /*size of the scroll bar structure    */
GLOBAL int _sbcoversize = 4;      /*size of the scroll bar cover region */

GLOBAL short _wnsetstepq = 8;      /* explosion speed            */
GLOBAL ULONG _wnsteppause = 2L;    /* pause time               */
GLOBAL USHORT _timer_scale = 0;         /* fine timing not available          */
GLOBAL USHORT _vert_retrace = FALSE;    /* vertical retrace not available     */

GLOBAL SCR _vid_scr = {0, 0, ROWQ_25};   /*video screen structure         */
               /*the rest of the members will be     */
               /*initialized in init_vv()         */

#ifdef LINT_ARGS

GLOBAL ISVRP _abortfp;         /* pointer to abort function         */
GLOBAL ISVRP _breakfp;         /* pointer to break function         */
GLOBAL ISVRP _oldbreakfp;      /* pointer to original break function */
GLOBAL void (FASTCALL * _errfp)(UCHAR *) = _db_dummy;
                   /* pointer to user's error function   */

#ifndef NO_DEBUG_CODE

GLOBAL void (FASTCALL * _finitfp)(UCHAR *) = _db_dummy;
               /* begin of module function         */
GLOBAL void (FASTCALL * _fexitfp)(UCHAR *) = _db_dummy;
               /* end of module function         */
#endif

#else

GLOBAL ISVRP _abortfp;
GLOBAL void (ISVR *_breakfp)();
GLOBAL void (ISVR *_oldbreakfp)();
GLOBAL void (FASTCALL * _errfp)() = _db_dummy;
#ifndef NO_DEBUG_CODE
GLOBAL void (FASTCALL * _finitfp)() = _db_dummy;
GLOBAL void (FASTCALL * _fexitfp)() = _db_dummy;
#endif

#endif

/*----------------------------------------------------------------------------*/
/*  Array of initialization functions                     */
/*----------------------------------------------------------------------------*/

#ifdef LINT_ARGS
GLOBAL void (FASTCALL * _inittbl[])(void) =
#else
GLOBAL void (FASTCALL * _inittbl[])() =
#endif
{
    (PFV)NULLFP,         /*No default user initialization      */
    _init_sys,            /*Basic system               */
#ifdef VV_DEBUG
    _init_db,            /*Debugging system            */
#else
    (PFV)NULLFP,
#endif
#ifdef VV_HELP
    _init_help,          /*Help system               */
#else
    (PFV)NULLFP,
#endif
#ifdef VV_CLIST
    _init_cl,            /*Choice list system            */
#else
    (PFV)NULLFP,
#endif
#ifdef VV_FORM
    _init_fm,            /*Form processing system         */
#else
    (PFV)NULLFP,
#endif
#ifdef VV_DES
    _init_des            /*Vermont Views Designer         */
#else
    (PFV)NULLFP
#endif
};

#ifdef   NEC_PC9801
#ifdef VV_BKG
#ifdef LINT_ARGS
GLOBAL   void (*_initbkgfp)(void) = _init_bk;
GLOBAL   void (*_exitbkgfp)(void) = _exit_bk;
#else
GLOBAL   void (*_initbkgfp)(void) = _init_bk;
GLOBAL   void (*_exitbkgfp)(void) = _exit_bk;
#endif
#else   /* VV_BKG */
#ifdef LINT_ARGS
GLOBAL   void (*_initbkgfp)(void) = NULLFP;
GLOBAL   void (*_exitbkgfp)(void) = NULLFP;
#else
GLOBAL   void (*_initbkgfp)() = NULLFP;
GLOBAL   void (*_exitbkgfp)() = NULLFP;
#endif
#endif   /* VV_BKG */
#endif   /* NEC_PC9801 */

/*----------------------------------------------------------------------------*/
/*  Global variables for PCDOS and OS2 Systems                  */
/*----------------------------------------------------------------------------*/

GLOBAL int _vda;         /* current video display adapter      */
GLOBAL int _vnochk = DOS_EXTEND;   /* controls checks in init_vv()       */
GLOBAL UCHAR _v_retr;         /* wait for retrace switch         */

#ifdef   NEC_PC9801
GLOBAL UCHAR _sbuparrow = 0x1e;         /*scroll bar up arrow character       */
GLOBAL UCHAR _sbdnarrow = 0x1f;         /*scroll bar down arrow               */
GLOBAL UCHAR _sblftarrow = 0x1d;        /*scroll bar left arrow               */
GLOBAL UCHAR _sbrtarrow = 0x1c;         /*scroll bar right arrow              */
GLOBAL UCHAR _sbcorner = 0;      /*scroll bar corner character         */
#else   /* NEC_PC9801 */
GLOBAL UCHAR _sbuparrow = 0x18;    /*scroll bar up arrow character       */
GLOBAL UCHAR _sbdnarrow = 0x19;    /*scroll bar down arrow          */
GLOBAL UCHAR _sblftarrow = 0x1b;   /*scroll bar left arrow          */
GLOBAL UCHAR _sbrtarrow = 0x1a;    /*scroll bar right arrow         */
GLOBAL UCHAR _sbcorner = 0;      /*scroll bar corner character         */
#endif   /* NEC_PC9801 */
               /*(0 = use the border character)      */
GLOBAL UCHAR _sbpagergn = 0xb0;    /*scroll bar page region character    */
GLOBAL UCHAR _sbthumb = 0x20;      /*scroll bar thumb            */

               /*printer name               */
GLOBAL UCHAR *_printname = (UCHAR *) "prn";
               /*printer mode               */
GLOBAL UCHAR *_printmode = (UCHAR *) "w";

GLOBAL UCHAR _kb_ext;         /* BIOS extended keyboard support flag*/
GLOBAL UINT _dos_extender;      /*type of DOS extender            */
GLOBAL UCHAR FAR * _bios_seg;      /*pointer to BIOS data area         */
GLOBAL USHORT _code_mask;      /*data selector to code selector mask */

GLOBAL USHORT _vid_segs[][2] =      /*video screen memory addresses for   */
{               /*DOS and extenders            */
    {0xB000, 0xB800},         /*DOS mono and color video segments   */
    {0x001C, 0x001C},         /*PHARLAP mono and color selectors    */
    {0x00B0, 0x00B8},         /*OS/286 mono and color selectors     */
    {0x00B0, 0x00B8},         /*OS/386 mono and color selectors     */
    {0x0000, 0x0000}         /*OS/386-HB -  determined at runtime  */
};

GLOBAL UINT FAR * _breaksp;      /*stack pointer for break isr         */

/*----------------------------------------------------------------------------*/
/*  Global variables for TERMINAL systems                  */
/*----------------------------------------------------------------------------*/
/******************************************************************************/
/*                                 */
/*  Globals necessary for the debugging system                  */
/*                                 */
/******************************************************************************/

#ifdef VV_DEBUG

GLOBAL UCHAR *_dblog[DBLOGSIZE];   /* call log - a circular list         */
GLOBAL int _dblogq = DBLOGSIZE;    /* size of call log list         */
GLOBAL UCHAR *_dbstk;         /* pointer to call stack         */
GLOBAL int _dbstkq = DBSTKSIZE;    /* maximum size of call stack         */
GLOBAL UCHAR *_dbstkp;         /* current position in call stack     */
GLOBAL UCHAR *_dbstklim;      /* last position in call stack         */
GLOBAL MFLINEPTR *_dblogp;      /* pointer to log memory file         */
GLOBAL int _dblogbeg = 0;      /* beginning index of call log list   */
GLOBAL int _dblogcur = -1;      /* current entry in call log list     */
GLOBAL UINT _dblogsum = 0;      /* checksum for call log         */
GLOBAL UINT _dbstksum = 0;      /* checksum for call stack         */
GLOBAL UCHAR _db_yes = 'y';             /* valid debugging positive response  */
GLOBAL UCHAR _db_no = 'n';              /* valid debugging negative response  */

#else

#ifdef VV_ERRF
               /* these globals used by SYS_ERRF()   */
GLOBAL UCHAR _db_yes = 'y';             /* valid debugging positive response  */
GLOBAL UCHAR _db_no = 'n';              /* valid debugging negative response  */

#endif               /* VV_ERRF               */

#endif               /* VV_DEBUG               */
#endif

#ifdef   NEC_PC9801
GLOBAL   int   use_vm_swap = NO;
GLOBAL   int   grph_enable = NO;
#endif   /* NEC_PC9801 */
