/***************************************************************************
**
** File name : wusym1.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**     3. Change "cmd_argv[]" to be "cmd_syntax.asc[]".
**     4. Modify all "cmd_argv[]" to be "cmd_syntax.asc" or
**       "addr_form.sym" etc.
**     5. Delete all "env.Mmodel" relatived condition checking.
**
** B. Date -- 10/25/1992 By Cheerson
**     0.
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "dos16.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define    MSK_ABS   0x00
#define    MSK_PHY   0x08   // segment:offset
#define    MSK_MOD   0x02
#define    MSK_GBL   0x01
#define    MSK_UNK   0x00
#define    MSK_PCY   0x10
#define    MSK_PCN   0x00
#define    MSK_GRY   0x20
#define    MSK_GRN   0x00

#define    MSG_ON    ON
#define    MSG_OFF   OFF

/**************************************************************************
**
** Local variables
**
***************************************************************************/

int (*absaddr)();
int absad86();
int AddrIndexCompCnt, AddrComp(),aIndexComp(),bComp();
unsigned char absad[6];
static struct stat usdStat;

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern struct attribute env;
extern struct pcstatus  PC;
extern int InxInSatable, InxInAstable;
extern unsigned char *aentry;
extern struct stat oldStat;
extern int loadedFile;
extern char langMode;

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name :  init_all()
**
** Function :  build the input file names and initial the environment
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

init_all(fname, msgon)
char *fname;
int msgon;
{
char *tmp;

   for (tmp=fname; *tmp != NULL; tmp++)  *tmp = toupper(*tmp);
   strcpy(fnsy, fname);
   if ((tmp = strrchr(fnsy,'.')) == NULL)  strcat(fnsy,".USD");
   else  strcpy(tmp,".USD");
   return (build_perm_table(msgon));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

free_all()
{
   free(typePos);
   free(modpos);
   free(lineInfoPos);
   free(GblSXTbl);
   free(GblAXTbl);
   free(ModInxHead);
   D16MemFree(astable);
   close(fdsy);
   if (addinx > 0) {
      for (; addinx > 0; addinx--)
         free(addtable[addinx].name);
      memset(addtable, NULL, sizeof(struct addonitem)*ADDON);
   }
   addinx = modcnt = totalsymcnt = gblsymcnt = env.Saddrunit = env.Sabsflag = 0;
   FreeLinNumInfo();
   SymLoaded = FAIL;
   return;
}

/**************************************************************************
**
** Name : build_perm_table
**
** Function :  check the input files and build the module
**            table
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

build_perm_table(int msgon)
{
int  new_fdsy, i, cnt, *iinnxx, typePosInxCnt;
char tbuf[100], *tptr, *cptr;
struct two_long addrpos, gblinxpos;
long lpos, ll1;
unsigned int ui;

   VPOut = COMVP;
   memset(tbuf, NULL, 100);
   if ( (new_fdsy=open(fnsy, O_BINARY|O_RDONLY)) == -1 ) {
      if (msgon == MSG_ON)  prn_ferr(15);
      return (FAIL);
   }
   read(new_fdsy, tbuf, 20);
   if (strcmp(tbuf,"*MICROTEK 1993 MICE*") != 0)  {
      if (msgon == MSG_ON)  prn_ferr(28);
      close(new_fdsy);
      return (FAIL);
   }
   if (SymLoaded == OK)  free_all();
   fdsy = new_fdsy;

   lseek(fdsy, (long)-4, 2);
   read(fdsy, (unsigned char *)&lpos, sizeof(long));
   lseek(fdsy, lpos, 0);
/* starting reading the junk */
   read(fdsy, (unsigned char *)&env,         4);
   read(fdsy, (unsigned char *)&modcnt,      sizeof(int));
   read(fdsy, (unsigned char *)&totalinxcnt, sizeof(int));
   read(fdsy, (unsigned char *)&totalsymcnt, sizeof(int));
   read(fdsy, (unsigned char *)&gblsymcnt,   sizeof(int));
   read(fdsy, (unsigned char *)&adrinxcnt,   sizeof(int));
   read(fdsy, (unsigned char *)&typePosInxCnt, sizeof(int));
   if (typePosInxCnt) {
      if ((typePos=malloc(typePosInxCnt*sizeof(long))) == NULL) {
         if (msgon == MSG_ON)  prn_ferr(67);
         close(fdsy);
         return (FAIL);
      }
      read(fdsy, (unsigned char *)typePos, typePosInxCnt*sizeof(long));
   }
   if (gblsymcnt != 0) {
      read(fdsy, (unsigned char *)&gblinxpos, sizeof(struct two_long));
      gblinxcnt = (gblsymcnt / INDEX_RANGE) + 2;
   }
   if (totalsymcnt > 0)
      read(fdsy, (unsigned char *)&addrpos, sizeof(struct two_long));
   adrreclen = sizeof(int) + sizeof(long) +
               env.Saddrunit;  // sizeof(inx) + sizeof(fpos) + addr_unit
   absaddr = absad86;

/* checking if enough memory? */
/* sizeof modpos, modinxcnt, module_index_array, all the indexes */
   if ((tptr=malloc(modcnt*sizeof(long) + modcnt*sizeof(int) +
          (modcnt+1) * sizeof(struct module_index) +
          (totalinxcnt+1) * sizeof(struct symindex) +
          (adrinxcnt+1) * sizeof(struct adrindex) )) == NULL) {
      if (msgon == MSG_ON)  prn_ferr(67);
      free(typePos);
      close(fdsy);
      return (FAIL);
   }
   else {
      lpos = addrpos.ll2 - addrpos.ll1;
      if (lpos > 0xFFFF)  cptr = D16HugeAlloc(lpos);
      else  cptr = malloc((unsigned int)lpos);
      if (cptr == NULL) {
         if (msgon == MSG_ON)  prn_ferr(67);
         free(typePos);
         free(tptr);
         close(fdsy);
         return (FAIL);
      }
      else {
         if (lpos > 0xFFFF)  D16MemFree(cptr);
         else free(cptr);
         free(tptr);
      }
   }

/* starting loading the module positions array and module index count array */
   if ((modpos=malloc(modcnt*sizeof(long))) == NULL) {
      if (msgon == MSG_ON)  prn_ferr(67);
      free(typePos);
      close(fdsy);
      return (FAIL);
   }
   read(fdsy, (unsigned char *)modpos, sizeof(long) * modcnt);
   if ((modinxcnt=malloc(modcnt*sizeof(int))) == NULL) {
      if (msgon == MSG_ON)  prn_ferr(67);
      free(typePos);
      free(modpos);
      close(fdsy);
      return (FAIL);
   }
   read(fdsy, (unsigned char *)modinxcnt, sizeof(int) * modcnt);
   if ((lineInfoPos=malloc(modcnt*sizeof(long))) == NULL) {
      if (msgon == MSG_ON)  prn_ferr(67);
      free(typePos);
      free(modpos);
      free(modinxcnt);
      close(fdsy);
      return (FAIL);
   }
   read(fdsy, (unsigned char *)lineInfoPos, sizeof(long) * modcnt);
/* allocating the module index array */
   if ((ModInxHead=(struct module_index *)malloc((modcnt+1)*sizeof(struct module_index))) == NULL) {
      if (msgon == MSG_ON)  prn_ferr(67);
      free(typePos);
      free(modpos);
      free(modinxcnt);
      free(lineInfoPos);
      close(fdsy);
      return (FAIL);
   }
/* allocating memory for all indexes */
   if ((SXPtr=(struct symindex *)malloc((totalinxcnt+1)*sizeof(struct symindex))) == NULL) {
      if (msgon == MSG_ON)  prn_ferr(67);
      free(typePos);
      free(modpos);
      free(modinxcnt);
      free(lineInfoPos);
      free(ModInxHead);
      close(fdsy);
      return (FAIL);
   }
   if ((AXPtr=(struct adrindex *)malloc(adrinxcnt*sizeof(struct adrindex))) == NULL) {
      if (msgon == MSG_ON)  prn_ferr(67);
      free(typePos);
      free(modpos);
      free(modinxcnt);
      free(lineInfoPos);
      free(ModInxHead);
      free(SXPtr);
      close(fdsy);
      return (FAIL);
   }

/* loading the global indexes if there is any global symbol */
   GblSXTbl = SXPtr;
   GblAXTbl = AXPtr;
   if (gblsymcnt > 0) {
      lseek(fdsy, gblinxpos.ll2, 0);
      read(fdsy, (unsigned char *)SXPtr, sizeof(struct symindex) * gblinxcnt);
      SXPtr += gblinxcnt;
   }
/* loading all the address indexes */
   if (totalsymcnt > 0) {
      lseek(fdsy, addrpos.ll2, 0);
      read(fdsy, (unsigned char *)AXPtr, sizeof(struct adrindex) * adrinxcnt);
   }
/* loading the module info and all the indexes */
   if (modcnt <= NO_MODULE) {
      neverswapmodule = 1;
      cnt = modcnt;
   }
   else  cnt = NO_MODULE;
   for (CurModSAInx=ModInxHead, i=0; i < modcnt; i++)   {
      if ((!neverswapmodule) && i>=NO_MODULE)
         lseek(fdsy, modpos[i]+sizeof(struct module), 0);
      else {
         lseek(fdsy, (modpos)[i], 0);
         read(fdsy, (unsigned char *)&gblmod[i], sizeof(struct module));
      }
      CurModSAInx->cnt = modinxcnt[i];
      CurModSAInx->sxptr = SXPtr;
      read(fdsy, (unsigned char *)SXPtr, sizeof(struct symindex) * CurModSAInx->cnt);
      SXPtr += modinxcnt[i];
      CurModSAInx++;
   }
   CurModSAInx->cnt = -1;

/* loading address entries into memory */
   lpos = addrpos.ll2 - addrpos.ll1;
   astable = (unsigned char *) D16HugeAlloc(lpos);
   if (astable == NULL) {
      if (msgon == MSG_ON)  prn_ferr(67);
      free(typePos);
      free(modpos);
      free(modinxcnt);
      free(lineInfoPos);
      free(ModInxHead);
      free(SXPtr);
      close(fdsy);
      return (FAIL);
   }
   lseek(fdsy, addrpos.ll1, 0);
   for (ll1=0L; lpos > 0; lpos -= ll1)  {
      if (lpos > 64000L)  ui = 64000;
      else                ui = (unsigned int) lpos;
      read(fdsy, astable+ll1, ui);
      ll1 += (long) ui;
   }

   free(modinxcnt);
   CurModSAInx = ModInxHead;
   memset(&commod, NULL, sizeof(struct module));
   memcpy(&commod, &gblmod[0], sizeof(struct module));
   if (fstat(fdsy, &usdStat) == NULL) {
      if (memcmp( &usdStat, &oldStat, sizeof(struct stat)) != NULL) {
         MonVarCount = 0;
         RedrawFlag = REDRAWDAT; // clear monitor
      }
      memcpy( &oldStat, &usdStat, sizeof(struct stat) );
   }
   for (i=0; i < modcnt; i++) {
      if (lineInfoPos[i]) {
         langMode = 1; // Source Mode
         break;
      }
   }
   SymLoaded = OK;
   return (OK);
}        /* end of build_perm_table() */

/**************************************************************************
**
** Name :  NameToMod(name)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

NameToMod(name)
char *name;
{
int i, j, act;

   if (neverswapmodule)  act = modcnt;
   else {
      act = NO_MODULE;
      swap_module(0);
   }
   for (i = 0; i < modcnt; i += act)    {
      for (j = 0; j < act; j++)
         if ((caseFlag && strcmp(gblmod[j].mod_name, name) == 0) ||
             (!caseFlag && strcmpi(gblmod[j].mod_name, name) == 0)) {
            memset(&commod, NULL, sizeof(struct module));
            memcpy(&commod, &gblmod[j], sizeof(struct module));
            return (FOUND);
         }
      if (!neverswapmodule) swap_module(gblmod[act-1].mod_inx + 1);
   }
   return (MISS);
}        /* end of  NameToMod(name) */

/**************************************************************************
**
** Name :  swap_module(finx)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

swap_module(int finx)
{
int i,j;

   if (finx == -1)  return;
   if (commod.mod_inx == finx)  return (OK);
   if (finx >= modcnt)  return (OK);
   if (modcnt > NO_MODULE)  i = NO_MODULE;
   else  i = modcnt;
   if ((finx >= gblmod[0].mod_inx) && (finx <= gblmod[i-1].mod_inx)) {
      j = finx - gblmod[0].mod_inx;
      memset(&commod, NULL, sizeof(struct module));
      memcpy(&commod, &gblmod[j], sizeof(struct module));
      return (OK);
   }
   if ((j=modcnt-finx) >= NO_MODULE)  j = finx;
   else  j = modcnt - NO_MODULE;
   for (i = 0; i < NO_MODULE; i++, j++)  {
      lseek(fdsy, modpos[j], 0);
      read(fdsy, (unsigned char *)&gblmod[i], sizeof(struct module));
   }
   i = finx - gblmod[0].mod_inx;
   memset(&commod, NULL, sizeof(struct module));
   memcpy(&commod, &(gblmod[i]), sizeof(struct module));
   return (OK);
}            /* end of  swap_module(finx) */

/**************************************************************************
**
** Name :   SymToAddr()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

SymToAddr()
{
unsigned char temp[50]; // James
int i;

/* Marked by James 08/11/1994
   if ((comsym.mask & MSK_GBL) == MSK_GBL)
      return (find_gblsym_byn());
   else if ((comsym.mask & MSK_MOD) == MSK_MOD)
      return (find_mod_byn(comsym.modx));
*/
   // added by James 08/11/1994
   if ( find_all_mod_byn() == FOUND ) return (FOUND);
   if ( find_gblsym_byn() == FOUND )  return (FOUND);
   else if ( comsym.name[0] != '_' ) {  // added by James  06/15/1994
         sprintf( temp, "_%s", comsym.name );
         strcpy( comsym.name, temp );
         if ( find_gblsym_byn() == FOUND ) return (FOUND);
   }
// return (find_all_mod_byn());   // 08/11/1994 James
   return (MISS);
}         /* end of  SymToAddr() */

/**************************************************************************
**
** Name : find_gblsym_byn()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

find_gblsym_byn()
{
   if (addinx > 0 && find_addon_byn() == FOUND)  return (FOUND);
   if (gblsymcnt == 0)  return (MISS);
   if (swap_symaddr(-1) == FAIL)  return (MISS);
   return (find_symaddr());
}        /* end of find_gblsym_byn() */

/**************************************************************************
**
** Name :  find_addon_byn()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

find_addon_byn()
{
int i;

   if (addinx == 0)  return (MISS);
   for (i = 0; i < addinx; i++)
      if ((caseFlag && strcmp(comsym.name, addtable[i].name) == 0) ||
          (!caseFlag && strcmpi(comsym.name, addtable[i].name) == 0)) {
//         comsym.mask |= MSK_GBL;
        comsym.type = 0;        // James
         comsym.modx = -1;
         memcpy(comsym.addr, addtable[i].addr, env.Maddrunit);
         return (FOUND);
      }
   return (MISS);
}        /* end of  find_addon_byn() */

/**************************************************************************
**
** Name :  find_all_mod_byn()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

find_all_mod_byn()
{
int i;

   for (i = 0; i < modcnt; i++, CurModSAInx++) {
      if (CurModSAInx->cnt == 0)    continue;
      if (CurModSAInx->cnt == -1)   CurModSAInx = ModInxHead;
      if (swap_symaddr(0) == FAIL)  continue;
      if (find_symaddr() == FOUND)  return (FOUND);
   }
   return (MISS);
}        /* end of  find_all_mod_byn() */

/**************************************************************************
**
** Name :  find_mod_byn(modinx)
**
** Function :  for symbol listing
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

find_mod_byn(int modinx)
{
   CurModSAInx = ModInxHead + modinx;
   if (CurModSAInx->cnt == 0)    return (MISS);
   if (swap_symaddr(0) == FAIL)  return (MISS);
   return (find_symaddr());
}             /* end of find_mod_byn()  */

/**************************************************************************
**
** Name : swap_symaddr()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

swap_symaddr(int tt)
{
int i,a,cnt;

   if (tt == -1)  {
      cnt = gblinxcnt;
      SXPtr = GblSXTbl;
   }
   else {
      cnt = CurModSAInx->cnt;
      SXPtr = CurModSAInx->sxptr;
   }
   if (cnt == 0)  return (FAIL);
   for (i = 0; i < cnt; i++) {
      a = strcmpi(comsym.name, (SXPtr+i)->name);
//    a = strcmp(comsym.name, (SXPtr+i)->name);
      if (a == 0)  break;
      else if (a < 0) {
         i--;
         break;
      }
   }
   if (i == cnt)    return (FAIL);
   else if (i < 0)  return (FAIL);
   else if (i == cnt-1)  i--;
   SXPtr += i;
   lseek(fdsy, SXPtr->fpos, 0);
   read(fdsy, &satable[0], SXPtr->cnt * SYMRECLEN);
   return (OK);
}             /* end of swap_symaddr() */

/**************************************************************************
**
** Name : find_symaddr()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

find_symaddr()
{
int i, j, k, a;
char nn[42];

   for (i = 0, k = 0, InxInSatable = -1; k < SXPtr->cnt; k++) {
      j = (int) satable[i];
      memset(nn, NULL, 42);
      memcpy(nn, &satable[i+1], j);
      if (( caseFlag && (a=strcmp(comsym.name, nn)) == 0)  ||
           (!caseFlag && (a=strcmpi(comsym.name, nn)) == 0)) {
         InxInSatable = i;
         i += j + 1;
         memcpy(comsym.addr, &satable[i], env.Saddrunit);
         if (env.Maddrunit > env.Saddrunit)
            AddrAlign(comsym.addr, env.Saddrunit, env.Maddrunit, 'E');
         else if (env.Maddrunit < env.Saddrunit)
            AddrAlign(comsym.addr, env.Saddrunit, env.Maddrunit, 'S');
         i += env.Saddrunit;
         comsym.type = ((U16)satable[i+1] << 8) + satable[i];
         return( CheckType(comsym.type) == FAIL ? MISS : FOUND);
      }
      else if (a < 0 && !caseFlag)  break;
      i += j + env.Saddrunit + 1 + sizeof(int);
   }
   return (MISS);
}        /* end of find_symaddr() */


/**************************************************************************
**
** Name : AddrToSym(itemno)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

AddrToSym(itemno)
int *itemno;
{
int i, j, done=0, ret;
unsigned char tar1[6];

   memcpy(saveaddr, comsym.addr, env.Maddrunit);
   memset(tar1, NULL, 6);
   if (env.Maddrunit > env.Saddrunit)
      AddrAlign(comsym.addr, env.Maddrunit, env.Saddrunit, 'S');
   else if (env.Maddrunit < env.Saddrunit)
      AddrAlign(comsym.addr, env.Maddrunit, env.Saddrunit, 'E');

   *itemno = 0;
   if (addinx > 0 && find_addon_bya() > 0)  return (1);

   if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)   {
      (*absaddr)(comsym.addr, env.Saddrunit);
      memcpy(tar1, absad, env.Saddrunit);
   }
   else  memcpy(tar1, comsym.addr, env.Saddrunit);

   if (totalsymcnt <= 0)  return (MISS);
   if (memcmp(tar1, GblAXTbl[0].addr, env.Maddrunit) < 0)  return (MISS);
   if ((i=memcmp(tar1, GblAXTbl[adrinxcnt-1].addr, env.Maddrunit)) > 0)
      return (MISS);
   else if (i == 0)
      AXPtr = &GblAXTbl[adrinxcnt-2];
   else {
      AXPtr = GblAXTbl;
      AddrIndexCompCnt = 0;
      AXPtr = (struct adrindex *) lfind((char *)tar1, (char *)GblAXTbl,
               &adrinxcnt, sizeof(struct adrindex), aIndexComp);
      if (AXPtr == NULL)  return (MISS);
      else if (AXPtr != GblAXTbl)  AXPtr = &(GblAXTbl[AddrIndexCompCnt-2]);
   }
   // return (find_addrsym(itemno));
   // added by james
   ret = find_addrsym(itemno);
   ConvCplusplusName(comsym.name);
   return (ret);
}        /* end of AddrToSym(itemno) */

RestoreCplusplusName(char *tmpStr) {
char *ptr0, *ptr1, temp[50];

   ptr0 = tmpStr;
   if ( (ptr1=strchr(tmpStr,':')) != NULL ) {
      *ptr1 = '\0';
      ptr1 += 2;
      if ( !strcmp(ptr0,ptr1) )
         sprintf(temp, "@%s@$bctr$qv", ptr0);
            else
               sprintf(temp, "@%s@%s$xqi", ptr0, ptr1);
      strcpy(tmpStr, temp);
   }
}

ConvCplusplusName(char *tmpStr) {
char *ptr1,*ptr2,*ptr3, temp[50], temp1[50];
   if ( (ptr1=strchr(tmpStr,'@')) != NULL
               && (ptr2=strchr(++ptr1,'@')) != NULL
                     && (ptr3=strchr(++ptr2,'$')) != NULL) { // C++: constructor or member function.
                           ptr3++;
                           memcpy(temp, ptr1, ptr2-ptr1-1);
                           temp[ptr2-ptr1-1] = '\0';
                              if ( (ptr3-ptr2) == 1 )   // constructor
                                 sprintf(tmpStr, "%s::%s", temp, temp);
                                    else  {
                                       sprintf(temp1, "%s::",temp);
                                       memcpy(temp, ptr2, ptr3-ptr2-1);
                                       temp[ptr3-ptr2-1] = '\0';
                                       sprintf(tmpStr, "%s%s", temp1, temp);
                                    }
                                 }
//                               else if ( ptr1 != NULL && *ptr1 == '$' && *--ptr1 == '@' ) // internal transfer function.
//                                           sprintf(tmpStr, "__transfer");
}

/**************************************************************************
**
** Name : aIndexComp(s1,s2)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

aIndexComp(s1,s2)
unsigned char *s1;
struct adrindex *s2;
{
int i;

   AddrIndexCompCnt++;
   i = memcmp(s1, s2->addr,env.Maddrunit);
   if (i >= 0)  return (1);
   else  return (0);
}     /* end of aIndexComp(s1,s2) */

/**************************************************************************
**
** Name : find_addon_bya()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

find_addon_bya()
{
int i;
unsigned char temp[6];
struct addonitem *aptr;

   if (addinx == 0)  return (MISS);
   if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)  {
      (*absaddr)(saveaddr, env.Maddrunit);
      memcpy(temp, absad, 6);
   }
   else  memcpy(temp, saveaddr, env.Maddrunit);
   memset(comsym.name, NULL, 40);

   aptr = (struct addonitem *)lfind((char *)temp, (char *)addtable,
          &addinx, sizeof(struct addonitem), bComp);
   if (aptr == NULL)  return (MISS);
   else {
      strcpy(comsym.name, aptr->name);
      comsym.modx = -1;
      comsym.mask != MSK_GBL;
      return (FOUND);
   }
}        /* end of find_addon_bya() */

/**************************************************************************
**
** Name : bComp(s1, s2)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

bComp(s1, s2)
unsigned char *s1;
struct addonitem *s2;
{
int i;

   if (env.Sabsflag)  (*absaddr)(s2->addr, env.Maddrunit);
   else  memcpy(absad, s2->addr, env.Maddrunit);
   i = memcmp(s1, absad, env.Maddrunit);
   if (i == 0) {   /* absolute address is matched */
      if (!env.Sabsflag)  return (0);
      if ((comsym.mask & MSK_PHY) == MSK_PHY)
         return (memcmp(saveaddr, s2->addr, env.Maddrunit));
      else  return (0);
   }
   else  return (i);
}        /* end of bComp(s1,s2) */

/**************************************************************************
**
** Name : find_addrsym(*ptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

find_addrsym(int *itemno)
{
unsigned char tar1[6], *sptr, *fptr;
char tmpsym[SYMRECLEN], *cptr;
struct inxfpos *iptr;
int i;
U32 ip;

   memset(tar1, NULL, 6);
   if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)
      memcpy(tar1, absad, env.Saddrunit);
   else  memcpy(tar1, comsym.addr, env.Saddrunit);

   memset(comsym.name, NULL, sizeof(comsym.name));
   InxInAstable = 0;
   if ((ip = adrreclen * AXPtr->fpos) > 0xffff)
      sptr = (U8 *)((U32)astable + ((ip&0xffff0000L)<<3) + (U16)ip);
   else sptr = astable + ip;
//   sptr = astable + adrreclen * (int)(AXPtr->fpos);
   fptr = (unsigned char *)lfind( tar1, sptr,
                                  &(AXPtr->cnt), adrreclen, AddrComp);
   aentry = fptr;
   if (fptr == NULL)  return (MISS);
   if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag) {
      do {
         iptr = (struct inxfpos *)fptr;
         lseek(fdsy, iptr->fpos, 0);
         read(fdsy, tmpsym, SYMRECLEN);
         if (memcmp(saveaddr, &tmpsym[(int)tmpsym[0]+1], env.Saddrunit) == 0) {
            memcpy(comsym.name, &tmpsym[1], (int)tmpsym[0]);
            i = tmpsym[0] + env.Saddrunit + 1;
            comsym.type = ((U16)tmpsym[i+1] << 8) + tmpsym[i];
            if (CheckType(comsym.type) == OK) {
               aentry = fptr;
               memcpy(absad, tar1, 6);
               return (1);
            }
         }
         fptr += adrreclen;
         if ( (fptr - sptr) >= (AXPtr->cnt * adrreclen) )  break;
      } while (memcmp(tar1, fptr+6, env.Saddrunit) == 0);
      return (MISS);
   }
   else {
      iptr = (struct inxfpos *)fptr;
      lseek(fdsy, iptr->fpos, 0);
      read(fdsy, tmpsym, SYMRECLEN);
      memcpy(comsym.name, &tmpsym[1], (int)tmpsym[0]);
      i = tmpsym[0] + env.Saddrunit + 1;
      comsym.type = ((U16)tmpsym[i+1] << 8) + tmpsym[i];
      return( CheckType(comsym.type) == FAIL ? MISS : 1 );
   }
}        /* end of find_addrsym(*ptr) */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

AddrComp(s1, s2)
unsigned char *s1, *s2;
{
   InxInAstable++;
   return (memcmp(s1, s2+6, env.Saddrunit));
}

/**************************************************************************
**
** Name :   AddrAlign()
**
** Function :  shrink or extend the input address to the length
**            of symbol file or mice
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

AddrAlign(addr, slen, elen, tag)
unsigned char *addr;
int slen, elen;
char tag;
{
unsigned char temp[6];
int i,j;

   memset(temp, NULL, 6);
   memcpy(temp, addr, 6);
   memset(addr, NULL, 6);
   switch (tag) {
   case 'S':
      if (slen <= elen)  break;
      if (env.Sabsflag) {
         if (slen > 6 || elen < 4)  break;
         memcpy(addr, temp, 2);
         memcpy(&addr[2], &temp[slen-(elen-2)], elen-2);
      }
      else {
         if (slen-elen > 1)  break;
         memcpy(addr, &temp[slen-elen], elen);
      }
      break;
   case 'E':
      if (slen >= elen)  break;
      if (env.Sabsflag) {
         if (slen != 4 && elen != 6)  break;
         memcpy(addr, temp, 2);
         memcpy(&addr[elen-(slen-2)], &temp[2], slen-2);
      }
      else {
         if (slen-elen > 1)  break;
         memcpy(&addr[elen-slen], temp, slen);
      }
      break;
   }
   return (OK);
}

/**************************************************************************
**
** Name :  absad86(addr)
**
** Function : calculate the absolute address for 86 series cpus
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

absad86(addr, unit)
unsigned char *addr;
int unit;
{
unsigned long cs,ip;

   cs = ip = 0L;
   cs = (unsigned long)addr[0];
   cs = (cs << 8) + addr[1];
   ip = (unsigned long)addr[2];
   ip = (ip << 8) + addr[3];
   if (unit == 6)  {
      ip = (ip << 8) + addr[4];
      ip = (ip << 8) + addr[5];
   }
   cs = cs << 4;
   cs += ip;
   memset(absad, NULL, 6);
   absad[0] = (unsigned char)(cs >> 24);
   absad[1] = (unsigned char)(cs >> 16);
   absad[2] = (unsigned char)(cs >> 8);
   absad[3] = (unsigned char)cs;
   return;
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

addr2str(s1, s2)
unsigned char *s1;
char *s2;
{
extern char hhex[];
int i,k;

   for (i = 0, k = 0; i < env.Maddrunit; i++, s1++) {
      s2[k++] = hhex[((*s1) & 0xF0) >> 4];
      s2[k++] = hhex[(*s1) & 0x0F];
      if (i== 1)  s2[k++] = ':';
   }
   s2[k] = '\0';
}

/**************************** End of File **********************************/
