/**************************************************************************
**
** File name : wusym2.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**     3. Change "cmd_argv[]" to be "cmd_syntax.asc[]".
**
** B. Date -- 10/24/1992 By Cheerson
**     0. Rename "ssave_cmd()" to be "SsaveCmd()".
**     1. Rename "srecall_cmd()" to be "SrecallCmd()".
**     2. Rename "create_cmd()" to be "CreateCmd()".
**     3. Rename "insert_symbol()" to be "InsertSymbol()".
**     4. Remove all checking for the input syntax.
**       Such as "argc" checking.
**
** C. Date -- 10/25/1992 By Cheerson
**     0. Modify "ModuleCmd()".
**     1. Modify "SrecallCmd()".
**     2. Modify "SSaveCmd()".
**
** D. Date -- 10/27/1992 By Cheerson
**     0. Fix the "env.Maddrunit" value to be "4".
**     0. Fix the "env." value to be "".
**     0. Fix the "env." value to be "".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "errno.h"
#include  "funcext.h"
#include  "database.h"
#include  "linumdef.h"
#include  "reg86.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/

/*  #define NO_MODULE 50    */

/**************************************************************************
**
** Local variables
**
***************************************************************************/

int InxInSatable, InxInAstable;
unsigned char *aentry;

static int sxcompare(),sycompare();
char hhex[17] = "0123456789ABCDEF:";
static char hexx[23] = "0123456789ABCDEFabcdef";
static char userheader[] = "$USD320-USERSYMBOLS$";

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern unsigned char absad[];
extern struct attribute env;
extern struct pcstatus  PC;
extern int SymLoaded;
extern int (*absaddr)();
extern int absad86();
extern int AddrIndexCompCnt, aIndexComp(),bComp(), AddrComp();


/**************************************************************************
**
** Execution codes
**
**************************************************************************/


/**************************************************************************
**
** Name : LoadCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**     Set all env.* struc values
**
**************************************************************************/

LoadCmd(char *asc)
{
char tbuf[200];
int LoadResult;

   env.Maddrunit = 4;
   env.Mcsiplen = 9;

   LoadResult = init_all(asc, MSG_ON);
   VPOut = COMVP;
   if (LoadResult == OK) {
      sprintf(tbuf," Symbol table is loaded OK from file %s\r\n", fnsy);
      DisplayStr(tbuf);
      RedrawFlag = ~MaskRedrawFlag;
      UpdateVP();
   }
   return (TRUE);
}

/**************************************************************************
**
** Name :  ModuleCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ModuleCmd()
{
int i, j;
char tbuf[100];

   SetPutsBuf(NULL, 16, 0);
   VPOut = COMVP;
   sprintf(tbuf," Total number of modules: %d\r\n", modcnt);
   DisplayStr(tbuf);
   swap_module(0);
   for (i = 0; i < modcnt; i++)   {
      j = i - gblmod[0].mod_inx;
      sprintf(tbuf," %7d. %s", i+1, gblmod[j].mod_name);
      if (PutsMore(tbuf) == ESC)  return (TRUE);
      if (j == NO_MODULE-1)  swap_module(i+1);
   }
   return (TRUE);
}      /* end of ModuleCmd() */

/**************************************************************************
**
** Name : createcmd()
**
** Function : createcmd() to create symbols
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

CreateCmd()
{
int i;
U32 addr;   // Chen 06/02/94

   env.Maddrunit = 4;
   env.Mcsiplen = 9;

   VPOut = COMVP;
   strncpy(comsym.name, addr_form.sym, sizeof(comsym.name)-1);
   comsym.name[sizeof(comsym.name)-1] = '\0';

// added by Chen 06/02/94   ; default segment is CS
    if ( addr_form.csFlag==0 && (addr_form.addr & 0xffff0000L)==0L ) {
        emuGetReg(I86_REG, REG_PC, &addr);
        addr_form.addr |= (addr & 0xffff0000L);
    }

   for (i = 0; i < 4; i++)
     comsym.addr[i] = ( addr_form.addr >> (8 * (3-i)) ) & 0x000000FFL;
   InsertSymbol(MSG_ON);
   DisplayCh(CR);
//   UpdateCODVP(CODVP_VIEW);     // Chen
//   DownView(TRUE);      // Chen 05/23/94
    UpdateCODVP(0);     // Chen 06/03/94
   return (TRUE);
}         /* end of createcmd() */

/**************************************************************************
**
** Name : InsertSymbol(msgon)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

InsertSymbol(int msgon)
{
char tbuf[200], temp[15];
U16 seg, offset;

   env.Saddrunit = 4;
   env.Sabsflag = 1;
   env.Mcsiplen = 9;
   absaddr = absad86;

/* checking if the symbol exists in global table */
   if (addinx != 0)  {
      if (comsym.modx != -1)  comsym.modx = -1;
//      comsym.mask |= MSK_GBL;     // James
      if (find_addon_byn() == FOUND) {
         if (msgon == MSG_ON)  prn_ferr(20);
         if (memcmp(comsym.addr,&addr_form.addr,4) == 0)  return (OK);
         else  return (FAIL);
      }
   }

/* inserting the address and symbol name to the addon table */
   if (addinx == ADDON) {
      if (msgon == MSG_ON)  prn_ferr(23);
      return (FAIL);
   }
   memcpy(addtable[addinx].addr, comsym.addr, 6);
   if ( (addtable[addinx].name=malloc(strlen(comsym.name)+1)) == NULL ) {
      if (msgon == MSG_ON)  prn_ferr(45);
      return (FAIL);
   }
   strcpy(addtable[addinx].name, comsym.name);
   addinx++;
/* after inserting item to addon table, now do the sorting */
   if (addinx > 1)
     qsort((void *)addtable, addinx, sizeof(struct addonitem), sycompare);
   seg = addr_form.addr >> 16;
   offset = addr_form.addr & 0x0000FFFFL;
   sprintf(tbuf," Symbol %s [%04X:%04X] is created.\r\n",
           comsym.name, seg, offset);
   if (msgon == MSG_ON)  DisplayStr(tbuf);
   return (OK);
}

/**************************************************************************
**
** Name : sycompare(s1, s2)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

sycompare(s1, s2)
unsigned char *s1, *s2;
{
struct addonitem  *ss1, *ss2;

   ss1 = (struct addonitem *)s1;
   ss2 = (struct addonitem *)s2;
   return (memcmp(ss1->addr, ss2->addr, 4));
}

/**************************************************************************
**
** Name : sxcompare(s1, s2)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

sxcompare(s1,s2)
unsigned char *s1, *s2;
{
struct addonitem  *ss1, *ss2;

   ss1 = (struct addonitem *)s1;
   ss2 = (struct addonitem *)s2;
   return (caseFlag ? strcmp(ss1->name, ss2->name) :
                      strcmpi(ss1->name, ss2->name));
}

/**************************************************************************
**
** Name : deletecmd()
**
** Function : symbol delete command
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DeleteCmd()
{
int i;
char tbuf[200], temp[15];
HANDLE hhh;

   VPOut = COMVP;
   strncpy(comsym.name, addr_form.sym, sizeof(comsym.name)-1);
   comsym.name[sizeof(comsym.name)-1] = '\0';
   ExtSymAdr(comsym.name, tbuf, SYM);

   for (i = 0; i < addinx; i++) {
      if (caseFlag && strcmp(comsym.name, addtable[i].name) == 0)  break;
      else if (!caseFlag && strcmpi(comsym.name, addtable[i].name) == 0)  break;
   }
   if (i >= addinx) {
      prn_ferr(74);
      return (TRUE);
   }
   memset(temp, NULL, 15);
   addr2str(addtable[i].addr, temp);
   free(addtable[i].name);
   memcpy(&addtable[i], &addtable[addinx-1], sizeof(struct addonitem));
   addinx--;
   memset(&addtable[addinx], NULL, sizeof(struct addonitem));
   if (addinx > 1)
      qsort((void *)addtable, addinx, sizeof(struct addonitem), sycompare);
   memset(tbuf, NULL, 70);
   sprintf(tbuf," Symbol %s [%s] is deleted.\r\n", comsym.name, temp);
   DisplayStr(tbuf);
//   UpdateCODVP(CODVP_VIEW);     // Chen
//   DownView(TRUE);      // Chen 05/23/94
   UpdateCODVP(0);     // Chen 06/03/94
   return (TRUE);
}       /* end of symbol delete */

/**************************************************************************
**
** Name : SymbolCmd
**
** Function : symbol command
**
**     Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

SymbolCmd()
{
int i, j, inxcnt, curflag=0, tempId;
char *cptr, modname[42], tbuf[100];
unsigned char pc[6];

   SetPutsBuf(NULL, 16, 0);
   VPOut = COMVP;
   if ( cmd_syntax.argc == 0 )  cmd_syntax.argv[0] = 0;
   tempId = cmd_syntax.argv[0];
   switch ( tempId )  {
      case 1 : /* GBL */
         sprintf(tbuf," Global symbols newly created: %d symbols", addinx);
         if (PutsMore(tbuf) == ESC)  return (TRUE);
         if (addinx > 0)
            if (ListSymInAddon() == ESC)  return (TRUE);
         sprintf(tbuf," Global symbols from symbol file: %d symbols", gblsymcnt);
         if (PutsMore(tbuf) == ESC)  return (TRUE);
         if (gblsymcnt > 0)
            if (ListSymInTbl(-1) == ESC)  return (TRUE);
         break;
      case 2 :     /* '%' : module */
         strcpy(modname, cmd_syntax.asc);
         if (NameToMod(&modname[0]) == MISS) {
            prn_ferr(72);
            return (TRUE);
         }
         sprintf(tbuf," Module %s : %d symbols", commod.mod_name, commod.mod_symno);
         if (PutsMore(tbuf) == ESC)  return (TRUE);
         if (commod.mod_symno == 0)  break;
         CurModSAInx = ModInxHead + commod.mod_inx;
         if (ListSymInTbl(0) == ESC)  return (TRUE);
         break;
      case 0 : /* ALl */
         sprintf(tbuf," Global symbols newly created: %d symbols", addinx);
         if (PutsMore(tbuf) == ESC)  return (TRUE);
         if (addinx > 0)
            if (ListSymInAddon() == ESC)  return (TRUE);
         sprintf(tbuf," Global symbols from symbol file: %d symbols", gblsymcnt);
         if (PutsMore(tbuf) == ESC)  return (TRUE);
         if (gblsymcnt > 0)
            if (ListSymInTbl(-1) == ESC)  return (TRUE);
         sprintf(tbuf," Total number of modules: %d", modcnt);
         if (PutsMore(tbuf) == ESC)  return (TRUE);
         swap_module(0);
         for (CurModSAInx=ModInxHead, i=0; i < modcnt; i++, CurModSAInx++)  {
            j = i - gblmod[0].mod_inx;
            sprintf(tbuf," Module %s: %d symbols", gblmod[j].mod_name, gblmod[j].mod_symno);
            if (PutsMore(tbuf) == ESC)  return (TRUE);
            if (gblmod[j].mod_symno == 0)  continue;
            if (ListSymInTbl(0) == ESC)  return (TRUE);
            if (j == NO_MODULE - 1)  swap_module(i+1);
            if (chk_hlt() == ESC) {
               DisplayStr("\\\r\n");
               return (TRUE);
            }
         }
         break;
   }
   return (TRUE);
}      /* end of symbolcmd */

/**************************************************************************
**
** Name : ListSymInAddon()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ListSymInAddon()
{
char buffer[80], temp[80];
int segment, offset, result = OK;
int i, len;
U8 *addrptr;

   env.Mcsiplen = 9;
   qsort((void *)addtable, addinx, sizeof(struct addonitem), sxcompare);
   buffer[0] = '\0';
   for (i = 0; i < addinx; i++) {
      addrptr = addtable[i].addr;
      segment = ((U16)addrptr[0] << 8) + (U16)addrptr[1];
      offset  = ((U16)addrptr[2] << 8) + (U16)addrptr[3];
      sprintf(temp,"%04X:%04X %s", segment, offset, addtable[i].name);
      if (strlen(temp) <= 38) {
         len = strlen(temp);
         memset(&temp[len], ' ', 38 - len);
         temp[38] = '\0';
      }
      else {
         if (buffer[0] != '\0')
            if (PutsMore(buffer) == ESC) {
               result = ESC;
               break;
            }
         strcpy(buffer, temp);
         temp[0] = '\0';
      }
      if ((buffer[0] != '\0') || (i == addinx-1)) {
         strcat(buffer, temp);
         if (PutsMore(buffer) == ESC) {
            result = ESC;
            break;
         }
         buffer[0] = '\0';
      }
      else  strcpy(buffer, temp);
   }  /* end of for */
   qsort((void *)addtable, addinx, sizeof(struct addonitem), sycompare);
   return (result);
}  /* end of ListSymInAddon() */

/**************************************************************************
**
** Name : ListSymInTbl(tt)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ListSymInTbl(tt)
int tt;
{
int inxcnt, segment, offset;
int i, j, m, len;
char buffer[80], temp[80], name[80];
U8 *addrptr;

   VPOut = COMVP;
   if (tt == -1) {
      inxcnt = gblinxcnt;
      SXPtr = GblSXTbl;
   } else {
      inxcnt = CurModSAInx->cnt;
      SXPtr = CurModSAInx->sxptr;
   }
   buffer[0] = '\0';
   for (i = 0; i < inxcnt-1; i++, SXPtr++) {
      lseek(fdsy, SXPtr->fpos,0);
      read(fdsy, &satable[0], SXPtr->cnt * SYMRECLEN);
      for (m = 0, j = 0; j < SXPtr->cnt; j++) {
         strncpy(name, &satable[m+1], satable[m]);
         name[satable[m]] = '\0';

         // added by James.
         ConvCplusplusName(name);

         m += satable[m] + 1;
         addrptr = &satable[m];
         m += env.Saddrunit + 2;
         segment = ((U16)addrptr[0] << 8) + (U16)addrptr[1];
         offset  = ((U16)addrptr[2] << 8) + (U16)addrptr[3];
         sprintf(temp,"%04X:%04X %s", segment, offset, name);
         if (strlen(temp) <= 38) {
            len = strlen(temp);
            memset(&temp[len], ' ', 38 - len);
            temp[38] = '\0';
         }
         else {
            if (buffer[0] != '\0')
               if (PutsMore(buffer) == ESC)  return (ESC);
            strcpy(buffer, temp);
            temp[0] = '\0';
         }
         if (buffer[0] != '\0') {
            strcat(buffer, temp);
            if (PutsMore(buffer) == ESC)  return (ESC);
            buffer[0] = '\0';
         }
         else  strcpy(buffer, temp);
      }  /* end for j */
   }  /* end for i */
   if (buffer[0] != '\0')
      if (PutsMore(buffer) == ESC)  return (ESC);
   return (OK);
}        /* end of ListSymInTbl(tt) */

/**************************************************************************
**
** Name :  SsaveCmd()
**
** Function
**
**     Input  : refer to basetype's structure; argv[], and argc..etc.
**
**    Output :
**
** Notes:
**
**************************************************************************/

SsaveCmd()
{
int fd, i, *symlen, tcnt=0;
char *name, *cptr;

   VPOut = COMVP;
   if ((access(cmd_syntax.asc,2) == -1) && (errno == EACCES)) {
      prn_ferr(22);
      DisplayStr(" Symbols are not saved.\n\r");
      return (TRUE);
   }
   if ((fd=open(cmd_syntax.asc, O_RDWR|O_BINARY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE)) == -1) {
     prn_ferr(15);
     DisplayStr(" Symbols are not saved.\n\r");
     return (TRUE);
   }
   env.Maddrunit = 4;
   env.Maddrid   = 4;
   write(fd, userheader, 20);
   write(fd,(unsigned char *)&(env.Maddrunit), 2);
   write(fd,(unsigned char *)&(env.Maddrid),   2);
   write(fd,(unsigned char *)&(env.Mcsiplen),  2);
   write(fd,(unsigned char *)&addinx,          2);
   if (addinx <= 0) {
      close(fd);
      return (TRUE);
   }
   symlen = (int *)malloc(addinx*sizeof(int));
   if (symlen == NULL) {
      close(fd);
      unlink(cmd_syntax.asc);
      prn_ferr(45);
      return (TRUE);
   }
   for (i=0; i < addinx; i++)
      tcnt += (symlen[i] = strlen(addtable[i].name));
   tcnt += addinx;
   cptr = name = (char *)malloc(tcnt);
   if (name == NULL) {
      close(fd);
      unlink(cmd_syntax.asc);
      free(symlen);
      prn_ferr(45);
      return (TRUE);
   }
   for (i = 0; i < addinx; cptr += symlen[i]+1, i++)
      strcpy(cptr, addtable[i].name);
   write(fd, (char *)&tcnt, 2);
   write(fd, (char *)symlen, addinx*sizeof(int));
   write(fd, name, tcnt);
   write(fd, (char *)&addtable[0], sizeof(struct addonitem) * addinx);
   close(fd);
   free(symlen);
   free(name);
   return (TRUE);
}         /* end of SsaveCmd() */

/**************************************************************************
**
** Name : SrecallCmd()
**
** Function
**
**     Input  : refer to basetype's structure; argv[], and argc..etc.
**
**    Output :
**
** Notes:
**
**************************************************************************/

SrecallCmd()
{
int fd, *symlen, i, au, id, csip, tcnt, acnt;
char *name, *cptr, tt[80];
struct addonitem *tadd;

   VPOut = COMVP;
   if ((fd=open(cmd_syntax.asc, O_BINARY|O_RDONLY, S_IREAD)) == -1) {
      prn_ferr(15);
      return (TRUE);
   }
   read(fd, tt, 28);
   if (strncmp(tt, userheader, 20) != 0) {
      prn_ferr(42);
      close(fd);
      return (TRUE);
   }
   memcpy(&au,   &tt[20], 2);
   memcpy(&id,   &tt[22], 2);
   memcpy(&csip, &tt[24], 2);
   memcpy(&acnt, &tt[26], 2);
   if (acnt == 0) {
      close(fd);
      return (TRUE);
   }
   read(fd, (char *)&tcnt, 2);
   symlen = (int *) malloc(acnt*sizeof(int));
   name   = (char *) malloc(tcnt);
   tadd   = (struct addonitem *) malloc(acnt*sizeof(struct addonitem));
   if (!name || !symlen || !tadd) {
     close(fd);
     if (name)    free(name);
     if (symlen)  free(symlen);
     if (tadd)    free(tadd);
     prn_ferr(45);
     return (TRUE);
   }
   read(fd, (char *)symlen, sizeof(int) * acnt);
   read(fd, name, tcnt);
   read(fd, (char *)tadd, acnt * sizeof(struct addonitem));
   for (csip=addinx,i=0,cptr=name; i < acnt && addinx < ADDON; cptr += symlen[i]+1,i++,addinx++) {
     /* checking if the symbol exists in global table */
      for (id=0, au=0; id < addinx; id++) {
         if (caseFlag && strcmp(addtable[id].name, cptr) == 0)  au++;
         else if (!caseFlag && strcmpi(addtable[id].name, cptr) == 0)  au++;
      }
      if (au)  addinx--;
      else {
         addtable[addinx].name = malloc(symlen[i]+1);
         if (addtable[addinx].name == NULL) {
            prn_ferr(45);
            break;
         }
         memcpy(addtable[addinx].addr, tadd[i].addr, 6);
         strcpy(addtable[addinx].name, cptr);
      }
   }
   if ((i=addinx-csip) == 1)
      sprintf(tt," 1 symbol is loaded from %s.\r\n", cmd_syntax.asc);
   else if (i == 0)
      sprintf(tt," No symbol is loaded from %s.\r\n", cmd_syntax.asc);
   else
      sprintf(tt," %d symbols are loaded from %s.\r\n", i, cmd_syntax.asc);
   DisplayStr(tt);
//   UpdateCODVP(CODVP_VIEW); // Chen
//   DownView(TRUE);      // Chen 05/23/94
   UpdateCODVP(0); // Chen 06/03/94
   close(fd);
   free(name);
   free(symlen);
   free(tadd);
   return (TRUE);
}        /* end of srecallcmd() */

/**************************************************************************
**
** Name :  QueryCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

QueryCmd()
{
unsigned long addr, curPC;
char tmpBuf[100], modName[40];
extern CURRENT_MODULE curModule;
S16 i, j, modNum, oldMod;

   VPOut = COMVP;
   if (cmd_syntax.argc < 2 ) {    // addr/symbol query
      if (strchr(addr_form.sym, '%') == NULL)  addrquery();
      else {
         if ( SymLoaded != OK && addinx == 0 ) {
            DisplayStr(" Symbol not found!\n\r");
            return (TRUE);
         }
         symquery();
      }
   }
   else {  // line number query
      oldMod = curModule.modNum;
      if (cmd_syntax.argc == 3 ) {   // with module
         if (NameToMod(cmd_syntax.asc) != FOUND) {
             prn_ferr(72);     // invalid module
             return (TRUE);
         }
         curModule.modNum = commod.mod_inx;
         StrmnCopy( modName, cmd_syntax.asc , 0, sizeof(modName) -1 );
      }
      else {   // module is not assigned
         emuGetReg(I86_REG, REG_PC, &curPC);
         if (IdentifyCurrentModule(FALSE, curPC,&modNum, modName,&addr,&addr) !=
             OK) {
            prn_ferr(71);     // Can't locate current module
            return (TRUE);
         }
      }
      if ( LinNum2Addr((U16)cmd_syntax.argv[0], &addr ) != OK )
         prn_ferr(70); // No line number matched
      else {
         sprintf( tmpBuf, " Module : %s\r\n Address : %04X:%04X\r\n",
                 modName, (U16)(addr>>16), (U16)addr );
         DisplayStr( tmpBuf );
      }
      curModule.modNum = oldMod;
   }
   return (TRUE);
}         /* end of querycmd() */

/**************************************************************************
**
** Name : symquery()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

symquery()
{
int i, j, foundflag=0, modflag=0, even=0;
char modname[42], symname[42], *cptr, *cptr1, tbuf[80], astr[15];
unsigned char addr[6];
int tempModx;  //Frank, 5/31
char tempMask;

   memset(symname, NULL, 42);
   memset(modname, NULL, 42);
   if ((cptr=strstr(addr_form.sym, "%%")) == NULL)  cptr = addr_form.sym;
   else  {
      cptr += 2;
      modflag = 1;
   }
   cptr1 = strchr(cptr, '%');
   if (modflag)
      for (i=0; *cptr != '%' && i < 40; i++, cptr++)  modname[i] = *cptr;
   cptr1++;
   if (strlen(cptr1) > 40)  strncpy(symname, cptr1, 40);
   else  strcpy(symname, cptr1);
   strcpy(comsym.name, symname);

   // added by James 10/04/1994
   RestoreCplusplusName( comsym.name );

   if (modflag)
      if (NameToMod(modname) == FOUND) {
         tempModx = comsym.modx;     //Frank, 5/31
         tempMask = comsym.mask;     //Frank
         comsym.modx = commod.mod_inx;
         comsym.mask |= MSK_MOD;
         if (find_mod_byn(commod.mod_inx) == FOUND) {
            if (listnaddr(commod.mod_name) == ESC)  return;
         }
         else  prn_ferr(69);
         comsym.modx = tempModx;    //Frank, 5/31/1994
         comsym.mask = tempMask;
         return (TRUE);
      }
      else {
         prn_ferr(69);
         return (TRUE);
      }
   swap_module(0);
   for (i = 0; i < modcnt; i++)  {
      j = i - gblmod[0].mod_inx;
      comsym.modx = gblmod[j].mod_inx;
      if (find_mod_byn(i) >= FOUND) {
         foundflag = 1;
         if (listnaddr(gblmod[j].mod_name) == ESC)  return;
      }
      if (j == NO_MODULE-1)  swap_module(i+1);
   }
   comsym.modx = -1;
   if (addinx > 0)  {
      j = 0;
      sprintf(tbuf," Global newly created:\r\n Address:  ");
      for (i = 0; i < addinx; i++)
         if ( (caseFlag && strcmp(comsym.name,addtable[i].name) == 0) ||
              (!caseFlag && strcmpi(comsym.name,addtable[i].name) == 0) ) {
            if (!j) {
               DisplayStr(tbuf);
               j = 1;
            }
            foundflag = 1;
            memset(addr, NULL, 6);
            memset(astr, NULL, 15);
            memcpy(addr, &addtable[i], 6);
            addr2str(addr, astr);
            memset(tbuf, 0x20, 33);
            tbuf[33] = '\0';
            memcpy(tbuf, astr, strlen(astr));
            DisplayStr(tbuf);
            even++;
            if (even == 2) {
               DisplayStr("\r\n");
               even = 0;
            }
         }
      if (even == 1)  DisplayStr("\r\n");
   }
   if (gblsymcnt > 0 && swap_symaddr(-1) != FAIL && find_symaddr() >= FOUND) {
      foundflag = 1;
      if (listnaddr(NULL) == ESC)  return;
   }
   else if ( !foundflag && gblsymcnt > 0 ) {  // added by James
      sprintf( comsym.name, "_%s", symname );
//    if ( find_symaddr() >= FOUND ) {
      if ( SymToAddr() == FOUND ) {
         foundflag = 1;
         if ( listnaddr(NULL) == ESC ) return;
      }
   }

   if (!foundflag)  prn_ferr(69);
   return (OK);
}        /* end of symquery() */

/**************************************************************************
**
** Name : listnaddr(modname)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

listnaddr(modname)
char *modname;
{
int i, j, k, even=0;
char str[34], astr[15], tbuf[80];
unsigned char addr[6];

   if (InxInSatable == -1)  return (OK);
   i = InxInSatable;
   j = (int)satable[i];
   str[33] = '\0';
   if (modname == NULL)
      sprintf(tbuf," Global from symbol file:\r\n Address:  ");
   else
      sprintf(tbuf," Module:   %s\r\n Address:  ", modname);
   DisplayStr(tbuf);
   memset(tbuf, NULL, 80);
   memcpy(tbuf, &satable[i+1], j);
   while ((caseFlag && strcmp(comsym.name, tbuf) == 0) ||
          (!caseFlag && strcmpi(comsym.name, tbuf) == 0) ) {
      memset(addr, NULL, 6);
      memset(astr, NULL, 15);
      i += j+1;
      memcpy(addr, &satable[i], env.Saddrunit);
      addr2str(addr, astr);
      memset(str, 0x20, 33);
      memcpy(str, astr, strlen(astr));
      DisplayStr(str);
      even++;
      if (even == 2) {
         DisplayStr("\r\n");
         even = 0;
      }
      i += env.Saddrunit;
      j = (int)satable[i];
      if (i >= SXPtr->cnt*SYMRECLEN || j > 40)  break;
      memcpy(tbuf, &satable[i+1], j);
      tbuf[j] = '\0';
      if (chk_hlt() == ESC) {
         DisplayStr("\\\r\n");
         return (ESC);
      }
   }
   if (even == 1)  DisplayStr("\r\n");
   return (OK);
}          /* end of listnaddr(modname) */

/**************************************************************************
**
** Name :  addrquery
**
** Function : For query command with address-form query.
**
**     Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

addrquery()
{
int i, j, foundflag=0, item, even=0;
char tbuf[80];
unsigned char temp[6], tmpsym[SYMRECLEN], *sptr;
struct inxfpos *iptr;
struct addonitem *aptr;
U32 ip;

   VPOut = COMVP;
   memset(&comsym, NULL, sizeof(comsym));
   for (i = 0; i < 4; i++)
      comsym.addr[i] = ( addr_form.addr >> (8 * (3-i)) ) & 0x000000FFL;
   if (env.Sabsflag)  comsym.mask |= MSK_PHY;
   memcpy(saveaddr, comsym.addr, 6);

   if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag) {
      (*absaddr)(saveaddr, env.Maddrunit);
      memcpy(temp, absad, 6);
   }
   else  memcpy(temp, saveaddr, env.Maddrunit);

// search additional table
   j = 0;
   if (addinx > 0) {
      memset(comsym.name, NULL, 40);
      sprintf(tbuf," Global newly created:\r\n");
      aptr = (struct addonitem *)lfind((char *)temp,
         (char *)addtable, &addinx, sizeof(struct addonitem), bComp);
      if (aptr != NULL) {
         DisplayStr(tbuf);
         while (1) {
            if (aptr->name == NULL)  break;
            strcpy(tbuf, aptr->name);
            DisplayStr("   ");
            DisplayStr(tbuf);
            DisplayStr("\r\n");
            aptr++;
            j++;
            if (aptr == NULL)  break;
            if (env.Sabsflag)  (*absaddr)(aptr->addr, env.Maddrunit);
            else  memcpy(absad, aptr->addr, env.Maddrunit);
            if (memcmp(temp, absad, env.Maddrunit) != 0)  break;
            else if (memcmp(saveaddr, aptr->addr, env.Maddrunit) != 0)  break;
         }
      }
      foundflag += j;
   }

// search symbol from file
   if (totalsymcnt == 0) {
      if (!foundflag)  prn_ferr(68);
      return (OK);
   }
   if (memcmp(temp,GblAXTbl[0].addr,env.Maddrunit) < 0) {
      if (!foundflag)  prn_ferr(68);
      return (OK);
   }
   if ((i=memcmp(temp, GblAXTbl[adrinxcnt-1].addr, env.Maddrunit)) > 0) {
      if (!foundflag)  prn_ferr(68);
      return (OK);
   }
   else if (i == 0)  AXPtr = &GblAXTbl[adrinxcnt-2];
   else {
      AXPtr = GblAXTbl;
      AddrIndexCompCnt = 0;
      AXPtr = (struct adrindex *) lfind((char *)temp, (char *)GblAXTbl,
              &adrinxcnt, sizeof(struct adrindex), aIndexComp);
      if (AXPtr == NULL) {
         if (!foundflag)  prn_ferr(68);
         return (OK);
      }
      if (AXPtr != GblAXTbl)  AXPtr = &GblAXTbl[AddrIndexCompCnt-2];
   }
   InxInAstable = 0;

   if ((ip = adrreclen * AXPtr->fpos) > 0xffff)
     sptr = (U8 *)((U32)astable + ((ip&0xffff0000L)<<3) + (U16)ip);
   else sptr = astable + ip;
//   sptr = astable + adrreclen * (int)(AXPtr->fpos);
   aentry = (unsigned char *) lfind(temp, sptr, &(AXPtr->cnt), adrreclen, AddrComp);
   InxInAstable--;
   if (aentry == NULL) {
      if (!foundflag)  prn_ferr(68);
      return (OK);
   }
   iptr = (struct inxfpos *)aentry;
   i = iptr->inx;
   j = 0;
   do {
      iptr = (struct inxfpos *)aentry;
      if (i != iptr->inx) {
         j = 0;
         i = iptr->inx;
      }
      if (!j) {
         if (iptr->inx == -1)
            sprintf(tbuf," Global from symbol file:\r\n");
         else if (iptr->inx >= 0) {
            swap_module(iptr->inx);
            sprintf(tbuf," Module:   %s\r\n", commod.mod_name);
         }
      }
      lseek(fdsy, iptr->fpos, 0);
      read(fdsy, tmpsym, SYMRECLEN);
      if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)  {
         if (memcmp(saveaddr, &tmpsym[(int)tmpsym[0]+1], env.Saddrunit) == 0) {
            if (!j)  DisplayStr(tbuf);
            memset(tbuf, NULL, 70);
            memcpy(tbuf, &tmpsym[1], (int)tmpsym[0]);

            // added by james.
            ConvCplusplusName(tbuf);

            strcat(tbuf,"\r\n");
            DisplayStr("   ");
            DisplayStr(tbuf);
            j++;  foundflag++;
         }
      }
      else {
         if (!j)  DisplayStr(tbuf);
         memset(tbuf, NULL, 70);
         memcpy(tbuf, &tmpsym[1], (int)tmpsym[0]);
         strcat(tbuf,"\r\n");
         DisplayStr("   ");
         DisplayStr(tbuf);
         j++;  foundflag++;
      }
      if (chk_hlt() == ESC) {
         DisplayStr("\\\r\n");
         return (ESC);
      }
      aentry += adrreclen;
      InxInAstable++;
      if (InxInAstable == AXPtr->cnt)  break;
   } while (memcmp(temp, aentry+6, env.Saddrunit) == 0);
   if (!foundflag)  prn_ferr(68);
   return (OK);
}        /* end of addrquery */


/**************************************************************************
**
** Name :  GetSymbolByAddr
**
** Function :
**
**     Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/

GetSymByAddr(U8 findGbl, U32 addr, U8 *sym, U16 *type)
{
int i, j;
unsigned char temp[6], tmpsym[SYMRECLEN], *sptr;
struct inxfpos *iptr;
U32 ip;

   memset(&comsym, NULL, sizeof(comsym));
   for (i = 0; i < 4; i++)
      comsym.addr[i] = ( addr >> (8 * (3-i)) ) & 0x000000FFL;
   if (env.Sabsflag)  comsym.mask |= MSK_PHY;
   memcpy(saveaddr, comsym.addr, 6);
   if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag) {
      (*absaddr)(saveaddr, env.Maddrunit);
      memcpy(temp, absad, 6);
   }
   else  memcpy(temp, saveaddr, env.Maddrunit);

// search symbol from file
   memset( sym, NULL, 41 );
   if (totalsymcnt == 0 || memcmp(temp,GblAXTbl[0].addr,env.Maddrunit) < 0)
      return (FAIL);
   if ((i=memcmp(temp, GblAXTbl[adrinxcnt-1].addr, env.Maddrunit)) > 0)
      return (FAIL);
   else if (i == 0)  AXPtr = &GblAXTbl[adrinxcnt-2];
   else {
      AXPtr = GblAXTbl;
      AddrIndexCompCnt = 0;
      AXPtr = (struct adrindex *) lfind((char *)temp, (char *)GblAXTbl,
              &adrinxcnt, sizeof(struct adrindex), aIndexComp);
      if (AXPtr == NULL) return(FAIL);
      if (AXPtr != GblAXTbl)  AXPtr = &GblAXTbl[AddrIndexCompCnt-2];
   }
   InxInAstable = 0;
 //  sptr = astable + adrreclen * (int)(AXPtr->fpos);
   if ((ip = adrreclen * AXPtr->fpos) > 0xffff)
     sptr = (U8 *)((U32)astable + ((ip&0xffff0000L)<<3) + (U16)ip);
   else sptr = astable + ip;
   aentry = (unsigned char *) lfind(temp, sptr, &(AXPtr->cnt), adrreclen, AddrComp);
   InxInAstable--;
   if (aentry == NULL) return(FAIL);
   iptr = (struct inxfpos *)aentry;
   i = iptr->inx;
   do {
      iptr = (struct inxfpos *)aentry;
      if (i != iptr->inx) i = iptr->inx;
      if ((i >= 0 && !findGbl) || (i < 0 && findGbl)) {
         lseek(fdsy, iptr->fpos, 0);
         read(fdsy, tmpsym, SYMRECLEN);
         if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)  {
            if (memcmp(saveaddr, &tmpsym[(int)tmpsym[0]+1], env.Saddrunit) == 0) {
               memcpy(sym, &tmpsym[1], (int)tmpsym[0]);
               j = tmpsym[0] + env.Saddrunit + 1;
               *type = ((U16)tmpsym[j+1] << 8) + tmpsym[j];
               if (CheckType(*type) == OK) return(OK);
            }
         }
         else {
            memcpy(sym, &tmpsym[1], (int)tmpsym[0]);
            j = tmpsym[0] + env.Saddrunit + 1;
            if (*type) {
               *type = ((U16)tmpsym[j+1] << 8) + tmpsym[j];
               if (CheckType(*type) == OK) return(OK);
            }
            else return(OK);
//            *type = ((U16)tmpsym[j+1] << 8) + tmpsym[j];
//            if (CheckType(*type) == OK) return(OK);
         }
      }
      aentry += adrreclen;
      InxInAstable++;
      if (InxInAstable == AXPtr->cnt)  break;
   } while (memcmp(temp, aentry+6, env.Saddrunit) == 0);
   return (FAIL);
}

/**************************************************************************
**
** Name : ExtSymAdr(in,out,code)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ExtSymAdr(in,out,code)
char *in, *out;
int code;
{
   char c, *ptr=in;
   if(*in == NAME) {
      while((c = *ptr++) != ADDR_START && c) ;
      if(c) {
         if(code == SYM) {
            *(ptr-1) = '\0';
            strcpy(out,in);
         } else {
            strcpy(out,ptr);
            if(ptr = index(out,ADDR_END)) *ptr = '\0';
         }
         return;
      }
   }
   strcpy(out,in);
}        /* end of ExtSymAdr() */


/**************************** End of File **********************************/
