/* class comment */!!

inherit(Object, #CLISetNode, #(setType
onOff), 2, nil)!!

now(class(CLISetNode))!!

now(CLISetNode)!!

/* Compile the node into Actor source. */
Def CLICodeCompile(self | errorMessage)
{
  CLICodeCompile("setCliStatusValue(self, ");
  CLICodeCompile("set");
  select
    case setType = TECHO    is CLICodeCompile("Command");  endCase;
    case setType = TRESULTS is CLICodeCompile("Results");  endCase;
    case setType = TLOGGING is CLICodeCompile("Logging");  endCase;
    default
      errorMessage := getFormattedError(ErrorTextLibClass$Inst, 
         ER_CLI_INTERNAL_ERROR, "CLISetNode:CLICodeCompile", nil, nil);
      syntaxError(self, nil, errorMessage );
      /* syntaxError unravels call stack, and does not return */
  endSelect;
  select
    case onOff    = TOFF     is CLICodeCompile("Off");      endCase;
    case onOff    = TON      is CLICodeCompile("On");       endCase;
    default
      errorMessage := getFormattedError(ErrorTextLibClass$Inst, 
         ER_CLI_INTERNAL_ERROR, "CLISetNode:CLICodeCompile", nil, nil);
      syntaxError(self, nil, errorMessage );
      /* syntaxError unravels call stack, and does not return */
  endSelect;
  CLICodeCompile("(self))");
}!!

Def init(self, a1, a2)
{
  setType := a1;
  onOff := a2;
}!!
