/* List box of display options for displaying each template field */!!

inherit(ComboBox, #DisplayAsWindow, nil, 2, nil)!!

setClassVars(DisplayAsWindow, #($DisplayTypes /* tuple of display options */
$DisplayDefines /* tuple of display options values */))!!

now(class(DisplayAsWindow))!!

/* PUBLIC
   Create a new DisplayAs window.
 */
Def new (self, id, par | aDisplayAsWindow)
{ 
  aDisplayAsWindow := new(self:Behavior);
  setVars(aDisplayAsWindow, id, par, nil);
  create(aDisplayAsWindow, nil, "ComboBox", 
         CBS_DROPDOWNLIST bitOr CBS_SORT bitOr WS_VSCROLL bitOr WS_CHILD);
  if handle(aDisplayAsWindow) = 0
  then alert(System, self, #wCreateError)
  endif;
  ^init(aDisplayAsWindow);
}
!!

now(DisplayAsWindow)!!

/* PRIVATE
   Respond to the list box events.
 */
Def command(self, menuId, lp | sel)
{ 
}
!!

/* PUBLIC
   Returns the display option value.
 */
Def getDisplayOption(self | optText)
{ 
  optText := getSelString(self);
  do(size($DisplayTypes),
  {using(i)
    if optText = $DisplayTypes[i]
      ^$DisplayDefines[i];
    endif;
  });
  ^nil;
}
!!

/* PUBLIC
   Initialize DisplayAsWindow list box .
 */
Def init(self | tmp)
{ 
  sendMessage(self,0x0030/*WM_SETFONT*/,getFont(parent),0L);
  do($DisplayTypes,
  {using(elem)
    addString(self,elem);
  });  
}
!!

/* comment */
Def setCRect(self, rect)
{ 
  cRect := rect;
  setBottom(cRect,bottom(cRect) + (height(cRect)*5));
  ^cRect;
}
!!

/* PUBLIC
   Set the display as window to the incoming value.
 */
Def setDisplayAs(self, opt)
{ 
  do(size($DisplayDefines),
  {using(i)
    if opt = $DisplayDefines[i]
      setCurSel(self,selectString(self,$DisplayTypes[i]));
    endif;
  });
}

!!

/* DisplayAsWindow Class Initialization Code */
$DisplayTypes := tuple("hex","decimal","octal","binary","define_assert","first_assert");
$DisplayDefines := tuple(DISP_HEX,DISP_DEC,DISP_OCT,DISP_BIN,ASSERT_DEF,ASSERT_FIRST);
/*$DisplayDefines := #(0,1,2,3,4,5);*/
 