/* Dialog box for the trace search */!!

inherit(Dialog, #TraceSearchDlg, #(eventText
startFrame
), 2, nil)!!

now(class(TraceSearchDlg))!!

Def new(self | dlg)
{
  dlg := new(self:ancestor);
  ^dlg;
}!!

now(TraceSearchDlg)!!

Def command(self, wp, lp | value tracing response){ 
  select
    case wp = EVENT_TEXT_ID cand high(lp) = 3 /*CBN_SETFOCUS*/
      if( evtNumDefinedEvents($commonEventLib) = 0 )
        trcEvent(parent);
      endif; 
    endCase
    case wp = EVENT_TEXT_ID cand high(lp) = 7 /*CBN_DROPDOWN*/
      setupEventList(self);
    endCase
    case wp == IDCANCEL
      end(self, IDCANCEL);
    endCase
    case wp = IDHELP
       is contextNumber(TheHelpObject, hWnd, HE_DLGD_TRACESEA);
    endCase
    case wp == IDOK
      end(self, IDOK);
    endCase
  endSelect;
  ^0;
}!!

/* Save the control values before the dialog is destroyed. */
Def end(self, val | rc){
 rc := end(self:ancestor, val);
 if val <> 0
   eventText := getCBText(self, EVENT_TEXT_ID);
   startFrame := getItemText(self, START_FRAME_ID);
 endif;
 ^rc;
}!!

/* PUBLIC */
Def getEvent(self | val){ 
  val := eventText;
  if not(val)
    val := "";
  endif;
  ^val;
}!!

/* PUBLIC */
Def getStartFrame(self | val stFrame endFrame temp){ 
  stFrame := traceBufferStart(trace(parent));
  endFrame := traceBufferEnd(trace(parent));
  val := startFrame;
  if not(val) cor (size(val) = 0) cor not(asInt(val,10))
    val := asString(stFrame);
  endif;
  if (asInt(val,10) < stFrame) val := asString(stFrame); endif;
  if (asInt(val,10) > endFrame) val := asString(endFrame-1); endif;
  ^val;
}!!

/* Initialize the dialog text */
Def initDialog(self, wp, lp) {
  setupEventList(self);
  sendDlgItemMessage(self, EVENT_TEXT_ID, CB_SELECTSTRING, -1, 
                    asciiz(getEvent(self)));
  setItemText(self, START_FRAME_ID, getStartFrame(self));
  setText(self, "Search Buffer: "+asString(trcReadBufferGet(trace(parent))));
  registerF1Help(CLIULibraryClass$Inst, HI_DLGD_TRACESEA,
    getHWnd(self), HE_DLGD_TRACESEA);
  /* Let Windows set focus on the first tabstop */
  ^1;
}!!

/* PUBLIC */
Def setStartFrame(self,frame){ 
  startFrame := frame;
}!!

/* private */
Def setupEventList(self | num) {
  clearCBText(self,EVENT_TEXT_ID);
  /* Go to event server and get the list of defined
     events and send them to the combo box. */
  num := evtNumDefinedEvents($commonEventLib); 
  do(num,
  {using(elem | eName)
    eName := evtGetNextEvent($commonEventLib);
    if eName
      addCBText(self, EVENT_TEXT_ID, eName)
    endif;
  });
}!!
