/* a ListBoxWindow of variables.  Allows deletion from VarList */!!

inherit(ListBoxWindow, #VarListBoxWindow, #(varSet   /* set of vars */
deletedVar /* var last deleted or nil */), 2, nil)!!

now(class(VarListBoxWindow))!!

now(VarListBoxWindow)!!

/* add a variable */
Def add(self, aVarInfo)
{ if (size(varSet) <= 0) cor (not(aVarInfo in varSet))
    addString( listBox, name(aVarInfo) ); /* string for display */
    enableMenuItem(menu,550);
    add(varSet, aVarInfo);                /* variable for local memory */
  endif;
}!!

/* need to clean up in conjunction with parent window */
Def close(self)
{ if shouldClose(self)
  then destroyPopup(self, "dummy");
  endif;
}!!
/* Respond to the menu events.
  The wp argument gives the selected menu ID.
  Get a message symbol from the menu object. */
Def command(self, wp, lp | msg)
{ if msg := action(menu, wp)
  then ^perform(self, wp, msg)
  endif;
}!!

/* delete a variable (menu operation) */
Def deleteVariable(self, msg | aString)
{ if not(aString := getSelString(listBox))
  then
    displayFormattedError(ErrorTextLibClass$Inst, 
       ER_VAR_NO_DEL_SEL, FORCE_POPUP, nil, nil, nil);
  else
    if remove(self, aString, #true) cand deletedVar
    then
      removeVarByVarInfo( parent, deletedVar ) ;
      if size(varSet) > 0   /* highlight another item if one exists */
        then setCurSel(listBox, 0);
      endif;
      enableMenuItem( menu, 551 ) ;
      drawMenu( self ) ;
    else
      displayFormattedError(ErrorTextLibClass$Inst, 
         ER_INTERNAL, FORCE_POPUP, 
         "Variable info deletion failure", "varlistb", nil);
    endif ;
  endif ;
}!!

/* delete the popUp Menu */
Def destroyPopup(self, msg)
{ if hWnd(self)
  then
    destroy( self ) ;
  endif ;
  nilifyVarListWindow(parent);
}!!

Def init(self)
{ 
  init( self:ancestor ) ;
  varSet := new( Set, 0 ) ;
  menu := create( new(Menu), self );
  addItem( menu, managePopup(self) );
  grayMenuItem( menu, 550 ) ; /* DELETE item */
  grayMenuItem( menu, 551 ) ; /* UNDO   item */
  drawMenu( self ) ;
}!!

/* define MANAGE menu group "popup" */
Def managePopup(self | popup)
{ popup := newPopup(MenuItem, "&Manage");
  addItem(popup, new(MenuItem, "&Delete",        550, #deleteVariable));
  addItem(popup, new(MenuItem, "&UndoDeletion",  551, #undoDelete));
  ^popup
}!!

/* PRIVATE: remove a variable string by name 
   If rememberDeletion is #true, then stuff the associated
   varInfo into deletedVar.
*/
Def remove(self, aString, rememberDeletion | index foundOne?)
{ if index := selectString(listBox(self), aString)
  then deleteString(listBox(self), index);
  endif;
  varSet := collect( varSet, 
                     {using(varInfo)
                       if (caseOffCompare(aString, name(varInfo)) = #=)
                       then
                         if foundOne?
                         then
                           varInfo /* only remove 1st one! */
                         else
                           foundOne? := #true ;
                           if rememberDeletion
                           then deletedVar := varInfo; endif ;
                           nil
                         endif ;
                       else
                         varInfo
                       endif ;
                     }
                   ) ; /* remove varInfo by name match */
}!!

/* Return true if ok for window to close. 
** always OK
*/
Def shouldClose(self)
{
}!!

/* UNdelete a variable (menu operation) */
Def undoDelete(self, msg | aVarInfo)
{ if (aVarInfo := deletedVar)
  then
    if addVarByDeadVarInfo( parent, deletedVar )
    then
       add( self, aVarInfo );
       selectString( listBox, asciiz(asString(name(aVarInfo))) );
    endif ;
    deletedVar := nil ;
    grayMenuItem(menu, 551) ; /* undo item */
  else
    displayFormattedError(ErrorTextLibClass$Inst, 
       ER_VAR_NO_UNDO, FORCE_POPUP, nil, nil, nil);
  endif;
}!!
