/* constants and globals for the CLI language */

/* character types */
#define CHAR_EOF            0
#define CHAR_DELIMITER      1
#define CHAR_EXCLAMATION    2
#define CHAR_DOUBLE_QUOTE   3
#define CHAR_UNRECOGNIZED   4
#define CHAR_LEFT_PAREN     5
#define CHAR_RIGHT_PAREN    6
#define CHAR_ASTERISK       7
#define CHAR_PLUS           8
#define CHAR_MINUS          9
#define CHAR_SLASH         10
#define CHAR_DIGIT_0       11
#define CHAR_DIGITS_1_TO_7 12
#define CHAR_DIGITS_8_TO_9 13
#define CHAR_SEMICOLON     14
#define CHAR_LESS_THAN     15
#define CHAR_EQUAL         16
#define CHAR_GREATER_THAN  17
#define CHAR_ALPHAS_A_TO_F 18
#define CHAR_ALPHA_X       19
#define CHAR_ALPHAS_OTHER  20
#define CHAR_LEFT_BRACE    21
#define CHAR_RIGHT_BRACE   22
#define CHAR_AMPERSAND     23
#define CHAR_VBAR          24
#define CHAR_UPARROW       25
#define CHAR_TILDE         26
#define CHAR_PERCENT       27
#define CHAR_DOLLAR        28
#define CHAR_UNDERSCORE    29
!!

/* token types */
#define TALIAS           301
#define TAMPER           302
#define TAPPEND          303
#define TBAR             304
#define TCALL            305
#define TCOMMENT         306
#define TCLEAR           307
#define TDELETE          308
#define TECHO            309
#define TELSE            310
#define TEOF             0
#define TEQUALS          311
#define TEQUAL_TO        312
#define TERROR           313
#define TEXCLAM          314
#define TEXIT            315
#define TFILE            316
#define TGREATER_EQ      317
#define THELP            318
#define THELP_           319
#define THISTORY         320
#define TIDENT           321
#define TIF              322
#define TINCLUDE         323
#define TINTEGER         324
#define TLAPTIMER        325
#define TLEFT_CURLY      326
#define TLEFT_PAREN      327
#define TLESS_EQ         328
#define TLIST            329
#define TLOG_AND         330
#define TLOG_OR          331
#define TLOG             332
#define TLOGGING         333
#define TLSHIFT          334
#define TL_ANGLE         335
#define TMINUS           336
#define TNOT_EQUAL       337
#define TNUMBER          338
#define TOFF             339
#define TON              340
#define TOVERWRITE       341
#define TPERCENT         342
#define TPLUS            343
#define TPRINT           344
#define TQUOTEDSTRING    345
#define TRESULTS         346
#define TRIGHT_CURLY     347
#define TRIGHT_PAREN     348
#define TRSHIFT          349
#define TR_ANGLE         350
#define TSEMICOLON       351
#define TSLASH           352
#define TSTAR            353
#define TSTARTTIMER      354
#define TSTOPTIMER       355
#define TSTRING          356
#define TTILDE           357
#define TTIME            358
#define TUNKNOWN         359
#define TUPARROW         360
#define TVAR             361
#define TWHILE           362
#define TWORKDIR         363
#define TPLACEHOLDER     -1  /* should not be visible outside lexer */
!!

/* GLOBALS */

/* CLI statements will be compiled into Actor source using this stream */
Actor[#CLIStream] := streamOver("");!!

/* Initialized in class initialization of class which calls CLIParser */
Actor[#CLParser] := nil;
