/* File: HLBREAK.H 
** Description: Contains constant definitions about the Hi-Level Breakpoints
**    being used by the Source Presenter. (see bkptexec.h for more info).
** Include: Globals.h & Events.h
*/

/* step type */
#define HLB_STEP_INTO 0
#define HLB_STEP_OVER 1
#define HLB_STEP_FOREVER 0

/* call return type */
#define HLB_GO_CALL_RETURN 0
#define HLB_GO_RETURN_ONLY 1

#define HLB_GO_TIL_RETURN     1
#define HLB_GO_THROUGH_RETURN 2

/* hlb_granularity */
#define HLB_LINE_GRANULAR      0
#define HLB_STATEMENT_GRANULAR 1
#define HLB_ASM_GRANULAR       2

/* breakpoints life */
#define HLB_BKPT_LIFE_PERMANENT 0
#define HLB_BKPT_LIFE_TEMPORARY 1
#define HLB_BKPT_LIFE_TEMP_INT  2

/* breakpoint states */
#define HLB_BKPT_STATE_ENABLED  0
#define HLB_BKPT_STATE_DISABLED 1

/* break causes */
#define HLB_BECAUSE_NONE           0
#define HLB_BECAUSE_RESET          1
#define HLB_BECAUSE_HALT           2
#define HLB_BECAUSE_BUSBRK         3
#define HLB_BECAUSE_STEP           4
#define HLB_BECAUSE_BKPT           5
#define HLB_BECAUSE_OVERLAY_ACCESS 6
#define HLB_BECAUSE_DBL_BUS_FAULT  7
#define HLB_BECAUSE_EXTERNAL       8
#define HLB_BECAUSE_STEP_FAIL      9

/* emulation states */
#define HLB_EMU_HALTED    0
#define HLB_EMU_HUNG      1
#define HLB_EMU_RUNNING   2
#define HLB_EMU_STEPPING  3

/*      --- E O F ---     */
