/* 
 * Context numbers for online help.
 * Refer to the 2nd number in the corresponding pwrviews.hpj file's 
 * "[map]" section (see the include file dialogs.map especially).  
 * (The directory is \tbird\m332\help\)
 */!!
#define HELP_ENTRY_CPU      2032  /* cpu */
#define HELP_ENTRY_EVENT    2037  /* event */
!!
#define HELP_ENTRY_MEMORY   2044  /* memory */
#define HELP_ENTRY_SHELL    2046  /* shell */
#define HELP_ENTRY_SOURCE   2033  /* source */
#define HELP_ENTRY_STACK    2040  /* stack */
#define HELP_ENTRY_TRACE    2036  /* trace */
#define HELP_ENTRY_STATUS   2075  /* status */
!!
#define HELP_ENTRY_TOOLBAR  2039  /* toolbar */
#define HELP_ENTRY_TRIGGER  2045  /* trigger */
#define HELP_ENTRY_VARIABLE 2041  /* variable */
#define HELP_CONTENTS          1  /* powerviews */
!!
/*
 * Here are all the Help entry points for the help buttons on Dialog boxes
 *
 * Names are of form: HE_<DLG>_<FILE>_<NUM>.  Right now they all go to the
 * table of contents -- replace with the actual help entry points when they
 * are available.
 */
!!

/* These are ones that use InputDlgWithHelp */

#define HE_DLGI_CPUPRESE_1      2032 /* cpu */
#define HE_DLGI_DASMBROW_1      2023 /* singlelineassemblydialog */
#define HE_DLGI_EVENTWIN_1      2001 /* addeventdialog */
!!
#define HE_DLGI_TRACEBRO_1      2009 /* framedialog */
#define HE_DLGI_TRACEBRO_2      2009 /* framedialog */
#define HE_DLGI_VARBROWS_1      2052 /* variablesearchdialog */
#define HE_DLGI_ADDVAR          2051  /* addingvariablesto */
!!

/* These are ones that use errortex's displayMessageBox method */

!!
#define HELP_ENTRY_BREAKPOINT   2047 /* breakpoint */
#define HE_DLGM_CPUPRESE_1      2031 /* resettingtheprocessor */
#define HE_DLGM_BKPTDIAL_1      2042 /* settingandclearing */
#define HE_DLGM_BKPTPRES_1      2022 /* delete all breakpoint message box */
!!
#define HE_DLGM_SOURCEPR_1      2031 /* resettingtheprocessor */
#define HE_DLGM_SOURCEPR_2      2031 /* resettingtheprocessor */
#define HE_DLGM_SOURCEPR_3      2066 /* curexstatewarn */
#define HE_DLGM_SOURCEPR_4      2033 /* source */
#define HE_DLGM_SRCPATH_CHANGED 2063 /* newchangeswarning */
!!
#define HE_DLGM_TRACECON_1      2029 /* tracecontroldialog */
#define HE_DLGM_TRACEPRE_1      2034 /* searchingthetrace */
#define HE_DLGM_TRIGGER_1       2043 /* traceandtriggerfundamentals */
#define HE_DLGM_EVENT_1         2043 /* traceandtriggerfundamentals */
#define HE_DLGM_EVENT_2         2037 /* event */
#define HE_DLGM_EVENT_3         2076 /* deleteevent */
#define HE_DLGM_BUTTONWI_1      2050 /* exitingpowerviews */		      
!!

/*
 * Entry points for help in Resource-based dialog cases
 */
!!
#define HE_DLGR_GOTO_ADDRESS    2010 /* gotoaddressdialog */
#define HE_DLGR_SRC_GOTO_ADDRESS 2024 /* sourcegotoaddressdialog */
#define HE_DLGR_GOTO_LINE       2012 /* gotolinedialog */
#define HE_DLGR_LOAD_FILE       2013 /* loadcodedialog */
#define HE_DLGR_LOAD_OPTIONS    2014 /* loadoptionsdialog */
#define HE_DLGR_LOAD_MODULE     2004 /* browsemodulesdialog */
!!
#define HE_DLGR_MEM_SEARCH      2021 /* searchmemorydialog */
#define HE_DLGR_MEM_FILL        2008 /* fillmemorydialog */
#define HE_DLGR_MEM_COPY        2007 /* copymemorydialog */
#define HE_DLGR_OVERLAY         2015 /* mapdialogbox */
!!
#define HE_DLGR_STACK_AREA      2026 /* stacksizedialog */
#define HE_DLGR_STACK_BASE      2026 /* stacksizedialog */
#define HE_DLGR_STACK_SIZE      2026 /* stacksizedialog */
#define HE_DLGR_SET_BREAKPOINT  2022 /* setbreakointdialog */
!!
		 
/*
 * Entry points for help in DesignDialog conversions
 */
!!
#define HE_DLGD_HISTORY_SIZE    2035 /* historyshell */
#define HE_DLGD_TRACECON        2029 /* tracecontroldialog */
#define HE_DLGD_TRACENUM        2036 /* trace */
#define HE_DLGD_TRACENUM_BUFFER 2006 /* bufferdialog */
#define HE_DLGD_TRACENUM_FRAME  2009 /* framedialog */
!!
#define HE_DLGD_TRACESAV        2030 /* tracesaveasdialog */
#define HE_DLGD_TRACESEA        2019 /* searchdialog */
#define HE_DLGD_SRCPATHD        2065 /* editpathdialog */
!!
/* Entry points using the InputNumber dialog */
#define HE_DLGD_SOURCEPR_1      2028 /* tabwidthdialog */
#define HE_DLGD_SOURCEPR_2      2005 /* browserhistorydepth */
#define HE_DLGD_SOURCEPR_3      2027 /* stepcountdialog */
#define HE_DLGD_SOURCEPR_4      2020 /* searchdialogbox */
!!
#define HE_DLGD_STACKPRE        2002 /* alarmlimitdialog */
!!
#define HELP_ENTRY_ZERO_TIMESTAMP 2053  /* timestampdialog */
#define HELP_ENTRY_SYSTEM_CRYSTAL 2054  /* crystalfrequencydialog */
!!
/*
 * Entry points for help in File and SaveFile dialogs
 */
!!
#define HE_DLGF_RESTORECS       2055 /* restorecsshell */
#define HE_DLGF_SAVECS          2056 /* savecsshell */
#define HE_DLGF_LOGFILE         2057 /* loggingshell */
#define HE_DLGF_SHELL_LOGFILE   2026 /* stacksizedialog */
!!
#define HE_DLGF_RESTORE_EVENTS  2017 /* restoreeventsdialog */
#define HE_DLGF_SAVE_EVENTS     2018 /* saveeventsasdialog */
#define HE_DLGF_SAVE_TRACE      2058 /* savingtraceto */
#define HE_DLGF_ADD_SRC_PATH    2064 /* pathtosourcedialog */
!!
/*
 * Help Entry Index for F1 Key Table -- one per presenter or dialog TYPE
 */
!!
#define HI_ENTRY_TOOLBAR  0  /* toolbar */
#define HI_ENTRY_SHELL    1  /* shellcommands */
#define HI_ENTRY_SOURCE   2  /* source */
#define HI_ENTRY_EVENT    3  /* event */
!!
#define HI_ENTRY_MEMORY   4  /* cpu */
#define HI_ENTRY_STACK    5  /* stack */
#define HI_ENTRY_CPU      6  /* cpu */
#define HI_ENTRY_TRACE    7  /* event */
!!
#define HI_ENTRY_TRIGGER  8  /* event */
#define HI_ENTRY_VARIABLE 9  /* variable */

!!
/* InputDlgWithHelp, InputNumber */

#define HI_INPUT_DLG_WITH_HELP  20 
#define HI_MESSAGEBOXEX         21 

!!
/*
 * Entry point indexes for help in Resource-based dialog cases
 */

#define HI_DLGR_GOTO_ADDRESS    22 /* gotoaddressdialog */
#define HI_DLGR_GOTO_LINE       23 /* gotolinedialog */
#define HI_DLGR_LOAD_FILE       24 /* loadcodedialog */
#define HI_DLGR_LOAD_OPTIONS    25 /* loadoptionsdialog */
!!
#define HI_DLGR_LOAD_MODULE     26 /* browsemodulesdialog */
#define HI_DLGR_MEM_SEARCH      27 /* searchmemorydialog */
#define HI_DLGR_OVERLAY         28 /* baseaddressdialog */
#define HI_DLGR_STACK_AREA      29 /* stacksizedialog */
!!
#define HI_DLGD_HISTORY_SIZE    30 /* historyshell */
#define HI_DLGD_TRACECON        31 /* tracecontroldialog */
#define HI_DLGD_TRACENUM        32 /* trace */
#define HI_DLGD_TRACESAV        33 /* tracesaveasdialog */
!!
#define HI_DLGD_TRACESEA        34 /* searchdialog */
#define HI_DLGD_SRCPATHD        35 /* sourcepathsdialog */
!!
#define HI_ENTRY_BREAKPOINT     36 /* breakpoint */
#define HI_FILE_DLG             37 /* all file and savefile dialogs */
!!
#define HI_DLGR_MULTMEM         38 /* memorydialogbox: mult mem window dlg */
#define HE_DLGR_MULTMEM       2074 /* memorydialogbox: mult mem window dlg */
#define HI_ENTRY_STATUS         39 /* status window */
/* Warning!  Max HI_* index must be < MAXENTRIES in cliulib\f1hook.c 
 * (currently set to 40) */
