/* hosterrs.h - Actor version */

/* Severity flag composed of bits 0..2 */
#define E_NO_ERROR          0x00000000L
#define E_INFORMATIVE       0x20000000L
#define E_WARNING           0x40000000L
#define E_SEVERE            0x80000000L
#define E_FATAL             0xA0000000L
#define E_CATASTROPHIC      0xC0000000L

/* Internal flag is bit 3 */
#define INTERNAL_ERROR_ON   0x10000000L
#define INTERNAL_ERROR_OFF  0x00000000L


/* detecting component id is upper 2 bytes less top 4 bits */
#define E_COMPONENT_MASK    0x0FFF0000L

/* error numbber is lower 2 bytes */
#define E_ERROR_NUMBER_MASK 0x0000FFFFL
!!

/*
 *  Module component IDs : range 0x0000..0x0FFF (left shifted)
 */

/* Windows, DOS, or generic errors */
#define MODULE_GENERIC  0x0FFF0000L
#define MODULE_SYSTEM   0x00000000L

/* site-specific modules */
#define MODULE_HEAP                   0x00010000L
#define MODULE_SYMBOLS                0x00020000L
#define MODULE_ADDRESS                0x00030000L
#define MODULE_BREAKPOINT             0x00040000L
#define MODULE_CPU                    0x00050000L
#define MODULE_DISASSEMBLY            0x00060000L
#define MODULE_EVENT                  0x00070000L
#define MODULE_EVENT_TEMPLATE         0x00080000L
#define MODULE_LOADER_695             0x00090000L
#define MODULE_GENERIC_LDR            MODULE_LOADER_695
#define MODULE_LOADER_OMF             0x000A0000L
#define MODULE_MEMORY                 0x000B0000L
#define MODULE_SHARED_DATA            0x000C0000L
#define MODULE_STACK                  0x000D0000L
#define MODULE_SWAT                   0x000E0000L
#define MODULE_TRACE                  0x000F0000L
#define MODULE_TRIGGER                0x00100000L
#define MODULE_VAR                    0x00110000L
#define MODULE_LOADER_SREC            0x00120000L
#define MODULE_LOADER_TEK             0x00130000L
#define MODULE_MAP                    0x00140000L
#define MODULE_ENLIB                  0x00150000L
#define MODULE_WSCOM                  0x00160000L
#define MODULE_BKROOT                 0x00170000L
#define MODULE_CLIULIB                0x00180000L
#define MODULE_PROC                   0x00190000L
#define MODULE_LAST_SVR               MODULE_PROC    /* note dependency
                                                        on previous line */
!!

/* presenter ID's */
#define MODULE_CLI                    0x00200000L
#define MODULE_PROJECT_DEFINITION     0x00300000L
#define MODULE_SOURCE                 0x00400000L

/* display types for displayErrorText */
#define CHECK_MODE    0
#define FORCE_POPUP   1
#define FORCE_CLI     2

/* general error numbers */
/* Note: The text for these must be in errtext.rc at the corresponding index */
/* @@@ Now defined in errcodea.h -- in here to remap names for now @@@ */
#define ERR_FILE_NOT_FOUND       ER_FILE_NOT_FOUND
#define ERR_PROFILE_WRITE_FAIL   ER_PROFILE_WRITE
#define ERR_PCALL_RECURSION      ER_PCALL_RECURSE
#define ERR_ABORT_FROM_ESC       ER_ABORT_FROM_ESC
!!

/*
** LL ERRORS
*/
#define ER_BUS_TERMINATION ER_INTERNAL_TERMINATION

/*
** ADDRESS SERVER ERRORS
*/
#define ER_ADDRESS_OVERFLOW ER_ADR_RESULT_OVERFLOW 
#define ER_ADDRESS_UNDERFLOW ER_ADR_RESULT_UNDERFLOW 

/* End of File */
