/* File: PCPU.H
** Description: Contains menu and child control id of the CPU Presenter.
** Include: GLOBALS.H
*/
   
/* Error codes */
#define ERROR       0x200500 

/* Define Cpu Presenter Window menu item ID */

/* Options Menu */
#define CPU_RESET     600
#define CPU_RESET_CPU_ONLY 615
#define CPU_EXIT      601

/* Register Groups */
#define CPU_USERREG   602  
#define CPU_SUPERREG  603
#define CPU_MEMREG    604
#define CPU_FLOATREG  605  
#define CPU_CUSTREG   606

/* Signals Popup Menu */
#define MAX_SIGNAL_NAME_SIZE 15 /* must match inc\cpu.h */
#define CPU_SIG_BASE 700
#define CPU_SIG00 700   /* defined just to reserve 700-715 */
#define CPU_SIG01 701
#define CPU_SIG02 702
#define CPU_SIG03 703
#define CPU_SIG04 704
#define CPU_SIG05 705
#define CPU_SIG06 706
#define CPU_SIG07 707
#define CPU_SIG08 708
#define CPU_SIG09 709
#define CPU_SIG10 710
#define CPU_SIG11 711
#define CPU_SIG12 712
#define CPU_SIG13 713
#define CPU_SIG14 714
#define CPU_SIG15 715
#define CPU_NO_SIGNAL 716

/* must match number generated by sd.exe */
#define SD_CLK_SIG    0
#define SD_RESET_SIG  1

/* Help Menu */  
#define CPU_PV_HELP   697
#define CPU_HELP      698
#define CPU_WIN_HELP  699
   
/* Define CPU Presenter child objects ID */
/* Define CPU registers ID */
#define PC_REG        610
#define SP_REG        611
#define SR_REG        612
#define CCR_REG       613

#define ADDR_REG_BASE 620
#define NUM_ADDR      6

#define DATA_REG_BASE 630
#define NUM_DATA      8      

/* Supervisor registers set */
#define USR_REG       640 /* alias A7 */
#define ISP_REG       641
#define SFC_REG       642
#define DFC_REG       643
#define VB_REG        644

/* Floating-point register set */
#define FP_REG_BASE   660
#define NUM_FP        8
#define FPCR_REG      670
#define FPSR_REG      671
#define FPIAR_REG     672

/*  E O F  */
