/* File: PROC.H
** Description: Contains definitions for the PROC dll.
** Include: GLOBALS.H
*/
   
/* processor endian */
#define PROC_LITTLE_ENDIAN    0
#define PROC_BIG_ENDIAN       1

/* processor family */
#define PROC_FAMILY_UNKNOWN   0
#define PROC_FAMILY_680X0     1
#define PROC_FAMILY_X86       2

/* processor type */
/* must match values in sdtempl.h */
#define PROC_MC68330          0x1001
#define PROC_MC68331          0x1002
#define PROC_MC68332          0x1003
#define PROC_MC68333          0x1004
#define PROC_MC68340          0x1005
#define PROC_MC68HC16Y1       0x1006
#define PROC_MC68HC16Z1       0x1007

#define PROC_MC68360          0x1101
#define PROC_MC68349          0x1102

/* processor fetch size */
#define PROC_BYTE             0
#define PROC_WORD             1
#define PROC_LONG             2
#define PROC_DWORD            3

/* system type */
#define PROC_POWERPACK        0
#define PROC_POWERSCOPE       1
#define PROC_MICEPACK         2
#define PROC_DUMMY            0xFFFF

/* cpu type */
#define PROC_CPU_68000 0
#define PROC_CPU_68010 1
#define PROC_CPU_68020 2
#define PROC_CPU_68030 3
#define PROC_CPU_68040 4
#define PROC_CPU_CPU32 5
#define PROC_CPU_CPU32P 6
#define PROC_CPU_CPU16 7
#define PROC_CPU_80186 8
#define PROC_CPU_80386 9
#define PROC_CPU_80486 10
#define PROC_CPU_DUMMY 0xFFFF


/* E O F */