/***************************************************************************
**
** File name : mem68k.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _mem_
#include "mem.h"
#endif

#ifndef _COMM_
#include "comm.h"
#endif

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _ABI_FUNC_
#include "abifunc.h"
#endif

#ifndef _REG68306_DEFINE_
#include "reg68k.h"
#endif

#ifndef ABI_EXTERNAL_
#include "abiexts.h"
#endif

#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif

#ifndef _SDNUM_
#include "sdnum.h"
#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif

#ifndef __STRING_H
#include <string.h>
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define BLOCK_64K    65536.0
#define BUFF_SIZE        240
BAD_MEMORY verifyErrorInfo;
DOUBLE   freqTimes;

VOID PRIVATE CheckStatus(RETCODE status,RET_ADDR addr) ;

/**************************************************************************
** Name :
** Function
**    Input  :
**    Output :
** Notes:
**************************************************************************/
RETCODE EXPORT iceSetMap (U32 addr1, U32 addr2, U16 attr) {
   return(GOOD);
}
/*
U16 lp;
RETCODE status;
U8 varWidth;

   SaveId(SET_MAP,lp);

   varWidth = sizeof(addr1);
   SaveVar(addr1,lp,varWidth);
   varWidth = sizeof(addr2);
   SaveVar(addr2,lp,varWidth);
   varWidth = sizeof(attr);
   SaveVar(attr,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetMapSize(U32 *emmSize) {
   *emmSize = 1;
   return(GOOD);
}
/*
RETCODE status;
U8 lp;

   SaveId(GET_MAP_SIZE,lp);
   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) {
      *emmSize = *(U32 *)&inputStream[3];
   }
   return(status);
}
*/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetMap(MAP_INFO *mapData) {
   return(GOOD);
}
/*
RETCODE status;
U16 lp;
U8 *inputPtr;
U32 emmSize;

   iceGetMapSize(&emmSize);
   if(emmSize != 0) {
      SaveId(GET_MAP,lp);
      outputStream[lp++] = 0;
      SendStream(outputStream,lp);
      status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
      if (status == ICE_REC_TIME_OUT) return(status);
      inputPtr = inputStream + 2;
      status = *((U16 *)&inputStream[0]);
      lp = 0;
      if ((U16)status == ICE_OK) {
         while ((*(U16 *)inputPtr != 0xaa55) && lp < (mapNo -1)) {
            _fmemcpy(&mapData[lp],inputPtr,8);  // kkk
            mapData[lp].attr = (U16)*((U16 *)(inputPtr+8)); // kkk
            inputPtr +=10;
            lp++;
         }
         mapData[lp].addr1 = 0xfffffffful; // kkk
      }
      return(status);
   }
   else mapData[0].addr1 = 0xfffffffful; // No EMM
   return(NO_EMM);
}
*/
/****************************************************************************
**
**  iceSize
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
RETCODE EXPORT iceSize(ABI_SIZE size) {
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(SET_SIZE,lp);

   varWidth = sizeof(size);
   SaveVar(size,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));

}

/****************************************************************************
**
**  iceFill
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
RETCODE EXPORT iceFill(ADDR *addr, U32 len, U8 *buff, U16 patternLen) {
RETCODE status;
U16 lp,tCount;
U8 varWidth;

   if (addr->space == 8) addr->space = 5;
   lp = 0;

   SaveId(FILL_COMMAND,lp);

   varWidth = sizeof(*addr);
   SaveVar(*addr,lp,varWidth);
   varWidth = sizeof(len);

   SaveVar(len,lp,varWidth);
   SaveBuff(buff,lp,patternLen);

   outputStream[lp++] = 0;
   tCount = (U16) (((DOUBLE)len / BLOCK_64K) * freqTimes);
   if (tCount < 4) tCount = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME+60*tCount);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (((U16)status == ICE_NOT_READY) || ((U16)status == ICE_ERROR_WRITE))
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1)); // error addr
   ret_addr1.space = addr->space ;
   CheckStatus(status,ret_addr1) ;
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT GetMem240(ADDR addr, U8 *buff, U8 len) {
RETCODE status;
U16 lp;
U8 varWidth;

   if (addr.space == 8) addr.space = 5;
   lp = 0;

   SaveId(READ_MEM_N,lp);

   varWidth = sizeof(addr);
   SaveVar(addr,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   if (((U16)status = (*(U16 *)&inputStream[0])) == ICE_OK)
      _fmemcpy(buff,&inputStream[3],inputStream[2]);
   return( status );
}

/****************************************************************************
**
**   iceGetMemN
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
RETCODE EXPORT iceGetMemN(ADDR addr, U8 *buff, U16 len) {
RETCODE status;
U16 lp,blockLen;
U8 patternLen,*buffPtr;

   if (addr.space == 8) addr.space = 5;
   status = ICE_OK;
   buffPtr = buff;
   blockLen = len / BUFF_SIZE;
   for (lp = 0; lp < blockLen; lp++) {
      if ((status = GetMem240(addr,buffPtr,BUFF_SIZE)) == ICE_OK) {
         addr.pos += BUFF_SIZE;
         buffPtr += BUFF_SIZE;
      }
      else break;
   }
   patternLen = len % BUFF_SIZE;
   if ((patternLen) && ((U16)status == ICE_OK))
      status = GetMem240(addr,buffPtr,patternLen);
   if ((U16)status == ICE_NOT_READY)
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1)); /* error addr */
   return(status);
}

/****************************************************************************
**
**   iceGetMem
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
RETCODE EXPORT iceGetMem(ADDR addr, U8 *buff) {
RETCODE status;
U16 len,lp;
U8 varWidth;

   if (addr.space == 8) addr.space = 5;
   len = 1;
   lp = 0;

   SaveId(READ_MEM_N,lp);

   varWidth = sizeof(addr);
   SaveVar(addr,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *(U16 *)&inputStream[0];
   if ((U16)status  == ICE_OK)
      *buff = inputStream[3];
   else if ((U16)status == ICE_NOT_READY)
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1)); /* error addr */  // kkk
   return(status);

}

/**************************************************************************
**
** Name : SetMem240()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT SetMem240(ADDR addr, U8 *buff, U8 patternLen) {
RETCODE status;
U16 lp;
U8 varWidth;

   if (addr.space == 8) addr.space = 5;
   lp = 0;

   SaveId(SET_MEM_N,lp);

   varWidth = sizeof(addr);
   SaveVar(addr,lp,varWidth);

   SaveBuff(buff,lp,patternLen);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));

}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetMemN(ADDR addr, U8 *buff, U16 patternLen) {
RETCODE status;
U16 lp,len;
U8 *buffPtr;

   if (addr.space == 8) addr.space = 5;
   status = ICE_OK;
   buffPtr = buff;
   len = patternLen / BUFF_SIZE;
   for (lp = 0; lp < len; lp++) {
      if ((status = SetMem240(addr,buffPtr,BUFF_SIZE)) == ICE_OK) {
         addr.pos += BUFF_SIZE;
         buffPtr += BUFF_SIZE;
      }
      else break;
   }
   len = patternLen % BUFF_SIZE;
   if ((len) && ((U16)status == ICE_OK))
      status = SetMem240(addr,buffPtr,(U8)len);
   if (((U16)status == ICE_NOT_READY) || ((U16)status == ICE_ERROR_WRITE))
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1)); /* error addr */
   ret_addr1.space = addr.space ;
   CheckStatus(status,ret_addr1);
   return(status);

}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetMem(ADDR addr, U8 ch) {
RETCODE status;
U16 lp; // ,len;
U8 patternLen,varWidth;
U8 buff[4];

   if (addr.space == 8) addr.space = 5;
//   len = 1;
   lp = 0;
   buff[0]=ch;

   SaveId(SET_MEM_N,lp);

   varWidth = sizeof(addr);
   SaveVar(addr,lp,varWidth);

   patternLen = 1;
   SaveBuff(buff,lp,patternLen);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *(U16 *)&inputStream[0];
   if (((U16)status == ICE_NOT_READY) || ((U16)status == ICE_ERROR_WRITE))
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1)); /* error addr */  // kkk
   ret_addr1.space = addr.space ;
   CheckStatus(status,ret_addr1);
   return(status);
}

/**************************************************************************
**
** Name : iceCopy()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceCopy(ADDR addr1, U32 len, ADDR addr2) {
RETCODE status;
U16 lp,tCount;
U8 varWidth;

   if (addr1.space == 8) addr1.space = 5;
   if (addr2.space == 8) addr2.space = 5;
   lp = 0;
   SaveId(COPY,lp);

   varWidth = sizeof(addr1);
   SaveVar(addr1,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   varWidth = sizeof(addr2);
   SaveVar(addr2,lp,varWidth);

   outputStream[lp++] = 0;

   tCount = (U16) (((DOUBLE)len/BLOCK_64K) * freqTimes);
   if (tCount < 4) tCount = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME+60*tCount);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_NOT_READY || (U16)status == ICE_ERROR_WRITE) {
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1)); // addr1  // kkk
      _fmemcpy(&ret_addr2,&inputStream[7],sizeof(ret_addr2)); // addr2  // kkk
   }
   if ((U16)status == ICE_ERROR_WRITE)
      ret_addr1.addr = ret_addr1.addr_dummy;
   CheckStatus(status,ret_addr1);

   return(status);
}

/**************************************************************************
**
** Name : iceCompare()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2) {
RETCODE status;
U16 lp,tCount;
U8 varWidth;

   if (addr1.space == 8) addr1.space = 5;
   if (addr2.space == 8) addr2.space = 5;
   lp = 0;
   SaveId(COMPARE,lp);

   varWidth = sizeof(addr1);
   SaveVar(addr1,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   varWidth = sizeof(addr2);
   SaveVar(addr2,lp,varWidth);

   outputStream[lp++] = 0;

   tCount = (U16) (((DOUBLE)len/BLOCK_64K) * freqTimes);
   if (tCount < 4) tCount = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME+60*tCount);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
//   if (status == ICE_OK) {
   if ((U16)status == ICE_DIFF_FOUND) {
      _fmemcpy(findAddr1,&inputStream[3],8); // addr1  // kkk
      _fmemcpy(findAddr2,&inputStream[11],8); // addr2  // kkk
   }
   else if ((U16)status == ICE_NOT_READY) {
      _fmemcpy(&ret_addr1,&inputStream[3],8); // addr1  // kkk
      _fmemcpy(&ret_addr2,&inputStream[11],8); // addr2  // kkk
   }
   return(status);
}                       /* end of iceCompare() */

/**************************************************************************
**
** Name : iceSearch(addr, len, buff, size)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSearch(ADDR *addr, U32 len, U8 *buff, U16 patternLen) {  /* search block for pattern */
RETCODE status;
U16 lp,tCount;
U8 varWidth;

   if (addr->space == 8) addr->space = 5;
   lp = 0;
   SaveId(SEARCH,lp);

   varWidth = sizeof(ADDR);
   SaveVar(*addr,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   SaveBuff(buff,lp,patternLen);

   outputStream[lp++] = 0;

   tCount = (U16) (((DOUBLE)len/BLOCK_64K) * freqTimes);
   if (tCount < 4) tCount = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME+60*tCount);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (((U16)status == ICE_MATCH) || ((U16)status == ICE_NOT_READY ||
        (U16)status == ICE_ERROR_WRITE))
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1));  // kkk
   CheckStatus(status,ret_addr1);
   if (status == ICE_OK)
      addr->pos = *((U32 *)&inputStream[3]);
   return(status);
} /* end of iceSearch() */

/**************************************************************************
**
** Name : iceChecksum(addr, len, buff, size)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceChecksum(ADDR addr, U32 len, U16 *n) {
RETCODE status;
U16 lp,tCount;
U8 varWidth;

   if (addr.space == 8) addr.space = 5;
   lp = 0;
   SaveId(CHECKSUM,lp);

   varWidth = sizeof(addr);
   SaveVar(addr,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   outputStream[lp++] = 0;

   tCount = (U16) (((DOUBLE)len/BLOCK_64K) * freqTimes);
   if (tCount < 4) tCount = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME+60*tCount);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = (*(U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK)
      *n = *(U16 *)&inputStream[3]; /* checksum */
   else if ((U16)status == ICE_NOT_READY)
           _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1)); /* error addr */  // kkk
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceTest(ADDR addr, U32 len,ADDR *ret_addr) {
RETCODE status;
U16 lp,tCount;
U8 varWidth;

   if (addr.space == 8) addr.space = 5;
   lp = 0;
   SaveId(TEST,lp);

   varWidth = sizeof(addr);
   SaveVar(addr,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   outputStream[lp++] = 0;

   tCount = (U16) (((DOUBLE)len/BLOCK_64K) * freqTimes);
   if (tCount < 4) tCount = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME+60*tCount);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *(U16 *)(&inputStream[0]);
   if ((U16)status == ICE_NOT_READY || (U16)status == ICE_TEST_FAIL || (U16)status == ICE_ERROR_WRITE)
      _fmemcpy(&ret_addr1,&inputStream[3],sizeof(ret_addr1));  // kkk
   ret_addr1.space = addr.space ;
   CheckStatus(status,ret_addr1);
   ret_addr->pos = ret_addr1.addr ;
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceInput(U16 port, U16 len, U16 size, U8 *buff) {
    *buff = 0;
    return(GOOD);
}
/*
RETCODE status;
U16 lp;
U8 varWidth;

   lp = 0;
   SaveId(INPUT,lp);

   varWidth = sizeof(port);
   SaveVar(port,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   varWidth = sizeof(size);
   SaveVar(size,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK)
     _fmemcpy(buff,&inputStream[3],inputStream[2]);
   return(status);
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceOutput(U16 port, U8 *data, U16 len, U16 size) {
   return(GOOD);
}
/*
U16 lp;
RETCODE status;
U8 varWidth;

   lp = 0;
   SaveId(OUTPUT,lp);

   varWidth = sizeof(port);
   SaveVar(port,lp,varWidth);

   SaveBuff(data,lp,len);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   varWidth = sizeof(size);
   SaveVar(size,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
void EXPORT iceGetVerifyErrorInfo(BAD_MEMORY *badMemory)
{
   badMemory->offset = verifyErrorInfo.offset ;
   badMemory->space = verifyErrorInfo.space ;
   badMemory->expected = verifyErrorInfo.expected ;
   badMemory->actual = verifyErrorInfo.actual ;
}

/************************************************************************
**
**
**
*************************************************************************/
VOID PRIVATE CheckStatus(RETCODE status,RET_ADDR addr) {
//   U32 expData, actData;
//   U8 *DataAddr, i;

   if ((U16) status == ICE_ERROR_WRITE) {
      verifyErrorInfo.offset = addr.addr;
      verifyErrorInfo.space = addr.space;
      verifyErrorInfo.expected = addr.expected;
      verifyErrorInfo.actual = addr.actual;
   }

/*   expData = addr.actual;
   actData = addr.expected;

   DataAddr = (U8 *)&addr ;
   if ((U16) status == ICE_ERROR_WRITE) {
      SdnWriteMember(SDN_VERIFY_OFFSET,DataAddr,GOOD);
      SdnWriteMember(SDN_VERIFY_EXPECTED,(U8 *)&expData,GOOD);
      SdnWriteMember(SDN_VERIFY_ACTUAL,(U8 *)&actData,GOOD);
      SdnWriteMember(SDN_VERIFY_SPACE,DataAddr+4,GOOD);
      if (doIt)
         for (i=0;i<4;i++) {
            SdnWriteMember(SDN_LVERIFY_OFFSET+i,DataAddr,GOOD);
            SdnWriteMember(SDN_LVERIFY_EXPECTED+i,(U8 *)&expData,GOOD);
            SdnWriteMember(SDN_LVERIFY_ACTUAL+i,(U8 *)&actData,GOOD);
            SdnWriteMember(SDN_LVERIFY_SPACE+i,DataAddr+4,GOOD);
         }
   }*/
   return ;
}
/**************************** End of File **********************************/
