/***************************************************************************
**
** File name : reg68k.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
** B. Date -- 10/25/1992 By Cheerson
**        0. Check "register operation"
**
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#ifndef _COMM_
#include "comm.h"
#endif

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG68306_DEFINE_
#include "reg68k.h"
#endif

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

/**************************************************************************
**
** Local define
**
***************************************************************************/

/**************************************************************************
**
** Externals
**
**************************************************************************/

/**************************************************************************
**
** Execution codes
**
**************************************************************************/
#define REG_NO 20
// 1/26/95 U32 regBuff[REG_NO];
/**************************************************************************
**
** Name : SetReg(regmode,reg_id,content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT SetReg(REG_MODE regMode, S16 regId, U32 content) {
U16 lp,regNo;
U8 varWidth;
RETCODE status;

// 1/26/95    if (regBuff[regId] == content) return ICE_OK;

   regNo = regId;
   lp = 0;
   SaveId(SET_REG,lp);

   varWidth = 2;
   SaveVar(regMode,lp,varWidth);

   varWidth = 2;
   SaveVar(regNo,lp,varWidth);

   varWidth = sizeof(content);
   SaveVar(content,lp,varWidth);

   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) {
      if (regMode == M68K_REG) {           // kkk
         cpu_regs[regId]=content;
      }
   }
   return(status);
}                 /* end of SetReg(regMode,reg_id,content) */


/**************************************************************************
**
** Name : iceSetReg(reg_id,content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetReg(REG_MODE regMode, S16 regId,U32 content) {
//U32 regData;
RETCODE status;

   status = ICE_OK;
   switch (regMode) {
      case M68K_REG :
         status=SetReg(regMode,regId, content);
         break;
      case INTERNAL_REG :
         status=SetReg(regMode,regId, content);
         break;
   }
   return (status);
}                 /* end of iceSetReg(reg_id,content) */

/**************************************************************************
**
** Name : GetReg (reg_id)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
//RETCODE EXPORT GetReg (REG_MODE regMode, S16 regId, U32 *content) {
RETCODE GetReg (REG_MODE regMode, S16 regId, U32 *content) {
RETCODE status;
U16 lp,regNo;
U8 varWidth;

   regNo = regId;
   lp = 0;
   SaveId(GET_REG,lp);

   varWidth = 2;
   SaveVar(regMode,lp,varWidth);

   varWidth = 2;
   SaveVar(regNo,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK)
      _fmemcpy(content,&inputStream[3],4);
   return(status);
}                 /* end of GetReg (reg_id) */

/**************************************************************************
**
** Name : iceGetReg (reg_id)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetReg(REG_MODE regMode, int regId,U32 *content) {
RETCODE status;

   switch (regMode) {
      case M68K_REG :
         status = GetReg(regMode,regId, content);
         break;
      case INTERNAL_REG :
         status = GetReg(regMode,regId, content);
         break;
   }

   return (status);
}                 /* end of iceGetReg (reg_id) */

/**************************************************************************
**
** Name : iceGetAllReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetAllReg(U16 *cpuReg) {
RETCODE status;
U16 lp;
U8 regLen;

   lp = 0;
   SaveId(GET_ALL_REG,lp);
   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   regLen = inputStream[2];
   if((U16)status == ICE_OK) {
// 1/26/95       memcpy(regBuff,&inputStream[3],regLen);
      _fmemcpy(cpuReg,&inputStream[3],regLen);
   }
   return(status);
}

/**************************************************************************
**
** Name : iceGetAllIntReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetAllIntReg(U16 *intReg) {
RETCODE status;
U16 lp;
U8 regLen;

   lp = 0;
   SaveId(GET_ALL_INTERNAL_REG,lp);
   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   regLen = inputStream[2];
   if((U16)status == ICE_OK)
      _fmemcpy(int_regs,&inputStream[3],regLen*2);  // kkk
   return(status);
}

/**************************************************************************
**
** Name : iceSetIntReg(offset,len,data)
**
** Function  Set internal register value
**
**    Input  : offset - register offset
**             len - register length 1 or 2 or 4 bytes
**             date - register value (U32 *)
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetIntReg(U16 offset,U16 len,U32 data) {
   return(GOOD);
}
/*
U16 lp;
U8 varWidth;
RETCODE status;

   lp = 0;
   SaveId(SET_INT_REG,lp);

   varWidth = sizeof(offset);
   SaveVar(offset,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   varWidth = sizeof(data);
   SaveVar(data,lp,varWidth);

   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   return(status);
}
*/
/**************************************************************************
**
** Name : iceGetIntReg(offset,len)
**
** Function  Set internal register value
**
**    Input  : offset - register offset
**             len - register length 1 or 2 or 4 bytes
**    Output : register value - (U32 *)inputStream[3]
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetIntReg(U16 offset,U16 len,U32 *data) {
   return(GOOD);
}
/*
   U16 lp;
   U8 varWidth;
   RETCODE status;

   lp = 0;
   SaveId(GET_INT_REG,lp);

   varWidth = sizeof(offset);
   SaveVar(offset,lp,varWidth);

   varWidth = sizeof(len);
   SaveVar(len,lp,varWidth);

   outputStream[lp++] = 0;
   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (status == ICE_OK)
      _fmemcpy(data,&inputStream[3],4);
   return(status);
}
*/
/**************************** End of File **********************************/
