/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the dll.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcmmcf/cliulib/libmain.c_v  $
** 
**    Rev 1.0   03 Jun 1996 11:15:30   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:08:28   gene
** Initial revision.
** 
**    Rev 1.3   28 Jul 1993 17:47:14   john
** hack hack hack
** 
**    Rev 1.2   21 Jul 1993 16:44:40   paul
** Save hInstance for later use.
** 
**    Rev 1.1   26 Apr 1993 15:36:46   tom
** UNIX filename support
** 
**    Rev 1.0.1.1   06 Apr 1993 15:20:08   tom
** Must register errors with error text server.
**
**    Rev 1.0   01 Apr 1992 10:39:02   tom
** Initial revision.
**
**  $Header:   S:/tbird/arcmmcf/cliulib/libmain.c_v   1.0   03 Jun 1996 11:15:30   gene  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define MODULE_NAME "cliulib.dll"
HANDLE hInstance;
                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
VOID InitDict(VOID);

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the CLIULIB.DLL
**
** Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInst, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    hInstance = hInst;

    ErrInitDLL(MODULE_CLIULIB, (LPSTR)MODULE_NAME);  /* set up for error text */
    InitDict();
    /* initialize successfully */
    return(TRUE);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
** Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif

/******************************** E O F ***********************************/
