/****************************************************************************
**
**  Name:  dq306.c
**
**  Description:
**     This is a dequeuer for Motorola 68306
**
**
**  Status:
**
**
**  $Header:
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _DAD_SERVER_
#include "dasm.h"
#endif

#ifndef _DAD_DEFINE_
#include "daddef.h"
#endif

#ifndef _DQ306_
#include "dq306.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

//#ifndef _STRING_
//#include "strlib.h"
//#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SDNUM_
#include "sdnum.h"
#endif


#ifndef _TRACE_
#include "trace.h"
#endif

#ifndef __STDIO_H
#include <stdio.h>
#endif

#include "string.h"

                        /****************************
                         *                          *
                         *     DEFINITIONS          *
                         *                          *
                         ****************************/
#define FRAME_LEN      0x40 // Read 64 frames data each times.
                        /****************************
                         *                          *
                         *     EXTERNALS            *
                         *                          *
                         ****************************/

extern HANDLE cliServerHandle;

                        /****************************
                         *                          *
                         *     LOCAL VARIABLES      *
                         *                          *
                         ****************************/
//U8 *spaceString[] = {"","UW",  "",  "",  "","SW",  "","AK",
//                     "","UR",  "","UP",  "","SR","SP",  ""};

S8 spaceString[][11] = {"","Data write",  "",  "",  "","Data write",  "","AK",
                        "","Data read ",  "","UP",  "","Data read ","SP",  ""};

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

/////////////////////// Temporal function of trace //////////////////////////
VOID OutputStringToFile(LPSTR buffer,U16 textLen){
FILE *fStream;

   fStream = fopen("dqstring.log","w");
   fwrite(buffer, textLen, 1, fStream);
   fclose(fStream);
}

                        /****************************
                         *                          *
                         *     EXECUTABLE           *
                         *                          *
                         ****************************/


/****************************************************************************
**
** Name:  AdddqStateTable
**
****************************************************************************/
RETCODE AddDqStateTable(DESCRIPTOR dqStateId,S32 startReadFrame) {
DQ_STATE *dqState;
S32 numGotten;
U16 lp;
RETCODE err;
LPSTR buffer;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   TrcReadFrameSet(dqState->traceId,startReadFrame);
   for (lp = 0; lp < MAX_FRAME_NO; lp++)
      dqState->frameArray[lp].frameNo = 0x7fffffffl;
   if ((err = TrcTraceReadRaw(dqState->traceId,64L,&numGotten,
             &buffer)) != GOOD) return(err);
   for (lp = 0; lp < numGotten; lp++) {
      memcpy(&(dqState->frameArray[lp]),
             (buffer+lp*TRACE_FRAME_WIDTH),TRACE_FRAME_WIDTH);
   }
   TFree(buffer);
   TrcReadFrameSet(dqState->traceId,startReadFrame);
   dqState->frameStart = dqState->frameArray[0].frameNo;
   dqState->frameEnd = dqState->frameArray[numGotten - 1].frameNo;
   return(GOOD);
}

/****************************************************************************
**
** Name:  CreatedqStateTable // Create Dis-continue Table
**
****************************************************************************/
RETCODE CreateDqStateTable (DESCRIPTOR dqStateId) {
DQ_STATE  *dqState;
S32 curFrame;
U16 tempBuffId;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   TrcReadBufferGet(dqState->traceId,(U16 FAR *)&tempBuffId); // read current buffer ID
   dqState->traceBufId = tempBuffId; // read current buffer ID
   TrcReadFrameGet(dqState->traceId,&curFrame);
   AddDqStateTable(dqStateId,curFrame);

   return(GOOD);
}

/****************************************************************************
**
** Name:  DestroydqStateTable // Create
**
****************************************************************************/
RETCODE DestroyDqStateTable(DESCRIPTOR id) {
DQ_STATE *dqState;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   if ((err = TFree((LPSTR)dqState)) != GOOD)
      return err;
   return(GOOD);
}

/****************************************************************************
**
** Name:  ReCreatedqStateTable // Create Dis-continue Table
**
****************************************************************************/
RETCODE ReCreateDqStateTable (DESCRIPTOR dqStateId,S32 curFrame) {
DQ_STATE  *dqState;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   AddDqStateTable(dqStateId,curFrame);
   return(GOOD);
}
/****************************************************************************
**
** Name:  CheckSpaceType
**
****************************************************************************/
RETCODE CheckSpaceType(SPACE_TYPE spaceType, U16 fcPin) {
   switch (spaceType) {
      case S_PROGRAM :
         if ((fcPin == F_SP) | (fcPin == F_UP)) return(GOOD);
         break;
      case S_DATA :
         if ((fcPin == F_UD) | (fcPin == F_SD) | (fcPin == F_CPU))
            return(GOOD);
         break;
      case S_DONT_CARE :
         return(GOOD);
      default :
         return(!GOOD);
   }
   return(!GOOD);
}
/****************************************************************************
**
** Name:  SkipTraceFrame
**
****************************************************************************/
RETCODE SkipTraceFrame
        (DESCRIPTOR dqStateId,
         S8 frameLen,
         S32 startSkipFrame,
         SPACE_TYPE spaceType){
DQ_STATE FAR *dqState;
S32 curOffset;
U8 count = 0;
U16 traceBuf;
S32 oldest, newest, trig;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

   if ((traceBuf != dqState->traceBufId) ||  // different buffer ID.
       (startSkipFrame < dqState->frameStart)||
       (startSkipFrame > dqState->frameEnd)) { 
      ReCreateDqStateTable(dqStateId,startSkipFrame);
      dqState->traceBufId = traceBuf;
   }
   curOffset = startSkipFrame - dqState->frameStart;

   count = 0;
   if (frameLen > 0) {
      do {
         if (CheckSpaceType
             (spaceType, dqState->frameArray[(U16)curOffset].fcPin) == GOOD)
            count++;
         curOffset++;
         if (dqState->frameArray[curOffset].frameNo >= dqState->frameEnd) {
            ReCreateDqStateTable(dqStateId,dqState->frameEnd);
            curOffset = 1;
         }
         if (dqState->frameArray[curOffset].frameNo >= newest)
            return(!GOOD); // not find enough program frame.
      }while (count < frameLen);
      TrcReadFrameSet(dqState->traceId,dqState->frameArray[curOffset].frameNo);
      DadSetDqOffset(dqStateId,0);
   }
   else {
      // Add code latter
   }
   return(GOOD);


}

/****************************************************************************
**
** Name:  ReadTraceFrame
**
****************************************************************************/
RETCODE ReadTraceFrame
        (DESCRIPTOR dqStateId,
         S8 frameLen,
         S32 startReadFrame,
         DQ_FRAME *dqFrame,
         SPACE_TYPE spaceType){
DQ_STATE FAR *dqState;
S32 curOffset;
U8 count,frameCount;
U16 traceBuf;
S32 oldest, newest, trig;
RETCODE err;


   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   memset(dqFrame,0x7f,sizeof(DQ_FRAME)); /* initialize struct */
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

   if ((startReadFrame < dqState->frameStart)||
       (startReadFrame > dqState->frameEnd)) 
      ReCreateDqStateTable(dqStateId,startReadFrame);
   curOffset = startReadFrame - dqState->frameStart;
   count = frameCount = 0;
   do {
      if (CheckSpaceType
          (spaceType, dqState->frameArray[(U16)curOffset].fcPin) == GOOD) {
         dqFrame->frameNo[count] = dqState->frameArray[(U16)curOffset].frameNo;
         dqFrame->addr[count] = dqState->frameArray[(U16)curOffset].addr;
         dqFrame->data[count] = dqState->frameArray[(U16)curOffset].data;
         dqFrame->fcPin[count] = dqState->frameArray[(U16)curOffset].fcPin;
         dqFrame->rwPin[count] = dqState->frameArray[(U16)curOffset].rwPin;
         dqFrame->dsPin[count] = dqState->frameArray[(U16)curOffset].dsPin;
         count++;
      }
      frameCount++;
      curOffset++;
      if (dqState->frameArray[(U16)curOffset].frameNo >= dqState->frameEnd) {
         AddDqStateTable(dqStateId,dqState->frameEnd); // read trace frames from hardware.
         curOffset = 0;
      }
      if (startReadFrame+frameCount >= newest)
         return(!GOOD); // not find enough program frame.
   }while (count < frameLen);
   return(GOOD);
}

/****************************************************************************
**
** Name:  ReadInstDataAndAddress
**
****************************************************************************/
RETCODE ReadInstDataAndAddress(DESCRIPTOR dqStateId,DQ_FRAME *dqFrame) {
DQ_STATE FAR *dqState;
S32 curFrame;
RETCODE status;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadFrameGet(dqState->traceId,&curFrame);
   status = ReadTraceFrame(dqStateId,MAX_INST_LEN + 2,curFrame,dqFrame,S_PROGRAM);
   return(status);
}

/****************************************************************************
**
** Name:  CheckInterrupt
**
****************************************************************************/
INST_TYPE CheckInterrupt(DESCRIPTOR dqStateId, S32 nextFrame) {
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   ReadTraceFrame(dqState,6,nextFrame,&dqFrame,S_DATA);

   if ((dqState->frameArray[dqFrame.frameNo[0] % MAX_FRAME_NO].rwPin == 0) &&
       (dqState->frameArray[dqFrame.frameNo[1] % MAX_FRAME_NO].fcPin == F_CPU) &&
       (dqState->frameArray[dqFrame.frameNo[2] % MAX_FRAME_NO].rwPin == 0) &&
       (dqState->frameArray[dqFrame.frameNo[3] % MAX_FRAME_NO].rwPin == 0) &&
       (dqState->frameArray[dqFrame.frameNo[4] % MAX_FRAME_NO].rwPin == 1) &&
       (dqState->frameArray[dqFrame.frameNo[5] % MAX_FRAME_NO].rwPin == 1))
       return(HW_INT);
   else return(NORMAL_INST);

}
/****************************************************************************
**
** Name:  CheckInterrupt
**
****************************************************************************/
VOID PrintRemainsFrame(DESCRIPTOR dqStateId,
                       S32 startFrame,S32 endFrame, LPSTR string) {
S32 offset,lp;
DQ_FRAME printFrame;
S8 strPos;
LPSTR tempBuff,spaceBuff;


   if ((tempBuff = TMalloc(80)) == NULL) return(!GOOD);
   if ((spaceBuff = TMalloc(20)) == NULL) return(!GOOD);
   offset = endFrame - startFrame;
   ReadTraceFrame(dqStateId,offset,startFrame,&printFrame,S_DONT_CARE);
   for (lp = 0; lp < offset; lp++){
      strPos = (printFrame.rwPin[lp] << 3) + printFrame.fcPin[lp];
      memcpy(spaceBuff,spaceString[strPos],sizeof(spaceString[strPos]));
      if ((printFrame.fcPin[lp] == 1) ||
          (printFrame.fcPin[lp] == 5) ||
          (printFrame.fcPin[lp] == 7) ) {
         sprintf(tempBuff," %5d               ", printFrame.frameNo[lp]);
         strcat((LPSTR)string,(LPSTR)tempBuff);
         sprintf(tempBuff,"%08X    ", printFrame.addr[lp]);
         strcat((LPSTR)string,(LPSTR)tempBuff);
         sprintf(tempBuff,"%s: ", spaceBuff);
         strcat((LPSTR)string,(LPSTR)tempBuff);
         switch (printFrame.dsPin[lp]) {
            case 0 : //Word
               sprintf(tempBuff,"%04X\n", printFrame.data[lp]);
               break;
            case 1 : // High Byte
               sprintf(tempBuff,"%02X\n", (U8)(printFrame.data[lp] >> 8));
               break;
            case 2 : // Low Byte
               sprintf(tempBuff,"%02X\n", (U8)printFrame.data[lp]);
         }
         strcat((LPSTR)string,(LPSTR)tempBuff);
      }
   }
   TFree(tempBuff);
   TFree(spaceBuff);
}

/****************************************************************************
**
** Name:  DqInst
**
****************************************************************************/
RETCODE DqInst(DESCRIPTOR id,U32 *numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen) {
BOOLEAN dasmSym;
U16 trcBuffer,lp,bufferDepth;
DASM_INFO dasmInfo;
S32 oldest,newest,trig,firstFrame,nextFrame;
U32 numFrames, instNo = numInst;
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;
RETCODE err;
LPSTR bufferPtr;
U8 tempBuffer[80],tempStr[12];


   *textLen = 0;
   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   bufferDepth = MAX_LINE_LENGTH*instNo*2;

   if ((*buffer = TMalloc(bufferDepth)) == NULL)
      return(ER_OUT_OF_MEMORY);

   bufferPtr = *buffer;
   memset(bufferPtr,'\0',bufferDepth); /* initialize string */
   if ((err = TrcFrameDisplayModeSet(dqState->traceId,TRIGGER_ALIGN))
         != GOOD) {
      TFree(*buffer);
      return err;
   }

   if ((err = DadGetDasmSymbol(&dasmSym)) != GOOD) return(err);
   *startFrame = *endFrame = 0;
   if((err=TrcNumFramesGet(dqState->traceId, &numFrames))!=GOOD)
      return(err);
   if( !numFrames ) return(GOOD); /* no frames just get out! */
   
/*
** Retrieve information about trace buffer limits and requested range
*/
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);
   if ((err = TrcReadFrameGet(dqState->traceId, &firstFrame)) != GOOD)
      return(err);
   if ((err = TrcReadBufferGet(dqState->traceId, &trcBuffer)) != GOOD)
      return(err);

   dasmInfo.bytesUsed = 0;
   for ( lp = 0; lp < instNo; lp++) {
      if (ReadInstDataAndAddress(id,&dqFrame) != GOOD) {

         return(ER_DQ_NO_FRAMES_AVAILABLE);
      }
      if (!lp) *startFrame = dqFrame.frameNo[0]; // start frame at first inst.
      sprintf(tempBuffer,"%5d    ", dqFrame.frameNo[0]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      sprintf(tempBuffer,"%08X    ",dqFrame.addr[0]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      sprintf(tempBuffer,"%04X    ",dqFrame.data[0]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      sprintf(tempBuffer,"%s \n", spaceString[(dqFrame.rwPin[0] << 3) + dqFrame.fcPin[0]]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      if (TraceBufInst((U16 FAR *)dqFrame.data,dqFrame.addr[0],
                       dasmSym,bufferPtr,&dasmInfo) != GOOD) break;
      else {
         wsprintf(bufferPtr+strlen(bufferPtr),"\n");
         nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
         //Read the instruction that numbers of R/W cycle
         switch (dasmInfo.instType) {
            case MODIFY_SR :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case BRANCH :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRAP :
            case ILLEGAL :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case RETURN :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRANSFER_INST :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            default :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
               if (nextFrame > newest) break;
               if (CheckInterrupt(id,nextFrame) == HW_INT) {
               // if prev inst length =2 then delete prev inst
               }
               break;
         }
         {
             // put frameNo address data status.
             // put dasm inst string.
             // bufferPtr,tempBuffer,dqFrame); // out the executed instruction.
         }

         if (nextFrame > newest) break;
         if (nextFrame > (dqFrame.frameNo[0]+1))
            PrintRemainsFrame(id,dqFrame.frameNo[0]+1,nextFrame,bufferPtr);
         TrcReadFrameSet(dqState->traceId,nextFrame);
      }
   }
   *endFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
   numInst = instNo;
   *textLen = lstrlen(*buffer);
   OutputStringToFile(*buffer,*textLen);
   return(GOOD);

}

/****************************************************************************
**
** Name:  DadForwardDqInst
**
****************************************************************************/
RETCODE EXPORT DadForwardDqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen) {
BOOLEAN dasmSym;
U16 trcBuffer,lp,bufferDepth;
DASM_INFO dasmInfo;
S32 oldest,newest,trig,firstFrame,nextFrame;
U32 numFrames;
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;
RETCODE err;
LPSTR bufferPtr;
U8 tempBuffer[80];

   *textLen = 0;
   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   bufferDepth = MAX_LINE_LENGTH*numInst*2;

   if ((*buffer = TMalloc(bufferDepth)) == NULL)
      return(ER_OUT_OF_MEMORY);

   bufferPtr = *buffer;
   memset(bufferPtr,'\0',bufferDepth); /* initialize string */
   if ((err = TrcFrameDisplayModeSet(dqState->traceId,TRIGGER_ALIGN))
         != GOOD) {
      TFree(*buffer);
      return err;
   }

   if ((err = DadGetDasmSymbol(&dasmSym)) != GOOD) return(err);
   *startFrame = *endFrame = 0;
   if((err=TrcNumFramesGet(dqState->traceId, &numFrames))!=GOOD)
      return(err);
   if( !numFrames ) return(GOOD); /* no frames just get out! */

/*
** Retrieve information about trace buffer limits and requested range
*/
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);
   if ((err = TrcReadFrameGet(dqState->traceId, &firstFrame)) != GOOD)
      return(err);
   if ((err = TrcReadBufferGet(dqState->traceId, &trcBuffer)) != GOOD)
      return(err);

   dasmInfo.bytesUsed = 0;
   for ( lp = 0; lp < numInst; lp++) {
      if (ReadInstDataAndAddress(id,&dqFrame) != GOOD) {
         return(ER_DQ_NO_FRAMES_AVAILABLE);
      }
      if (!lp) *startFrame = dqFrame.frameNo[0]; // start frame at first inst.

      sprintf(tempBuffer," %5d  -113.475 us  ",dqFrame.frameNo[0]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);
      sprintf(tempBuffer,"%08lX", dqFrame.addr[0]);
      strcat((LPSTR)bufferPtr,(LPSTR)tempBuffer);

      if (TraceBufInst((U16 FAR *)dqFrame.data,dqFrame.addr[0],
                       dasmSym,bufferPtr,&dasmInfo) != GOOD) break;
      else {
         wsprintf(bufferPtr+strlen(bufferPtr),"\n");
         nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
         //Read the instruction that numbers of R/W cycle
         switch (dasmInfo.instType) {
            case MODIFY_SR :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case BRANCH :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRAP :
            case ILLEGAL :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case RETURN :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            case TRANSFER_INST :
               if (dqFrame.addr[dasmInfo.bytesUsed/2 + 1] !=
                        (dqFrame.addr[dasmInfo.bytesUsed/2] + 2))
                   nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 + 1];
               break;
            default :
               nextFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2];
               if (nextFrame > newest) break;
               if (CheckInterrupt(id,nextFrame) == HW_INT) {
               // if prev inst length =2 then delete prev inst
               }
               break;
         }
         {
             // put frameNo address data status.
             // put dasm inst string.
             // bufferPtr,tempBuffer,dqFrame); // out the executed instruction.
         }

         if (nextFrame > newest) break;
         if (nextFrame > (dqFrame.frameNo[0]+1))
            PrintRemainsFrame(id,dqFrame.frameNo[0]+1,nextFrame,bufferPtr);
         TrcReadFrameSet(dqState->traceId,nextFrame);
      }
   }
   *endFrame = dqFrame.frameNo[dasmInfo.bytesUsed/2 - 1];
   //GetStartEndFrame(startFrame,endFrame);
   *textLen = lstrlen(*buffer);
   OutputStringToFile(*buffer,*textLen);
   return(GOOD);

}
/****************************************************************************
**
** Name:  DadBackwardDqInst
**
****************************************************************************/
RETCODE EXPORT DadBackwardDqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen) {
}


/****************************************************************************
**
**  DadDqFlush
**
****************************************************************************/
#pragma argsused
RETCODE EXPORT DadDqFlush(DESCRIPTOR id) {
   return(GOOD);
}

