/****************************************************************************
**
**  Name:  SLDRSVR.H
**
**  Description:
**     Srecord Loader API's (external entry points).  Can be called by CLI,
**	   Symbol Server, and Project Definition Server
**
**     Prefix for Srecord Loader API's:  SLD
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcmmcf/inc/sldrsvr.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:25:28   gene
** Initial revision.
** 
**    Rev 1.0   14 Sep 1995 14:22:22   kevin
** Initial revision.
** 
**    Rev 1.5   30 Aug 1993 11:04:26   ron
** changes for Load Progress dialog
** 
**    Rev 1.4   02 Jun 1993 18:00:58   nghia
** Revised SRECORD flags value to support REPORT_WARNING. - PIP for Source.
** 
**    Rev 1.3   04 Nov 1992 17:23:46   courtney
** Added parameter to entry point for run mode (batch vs. interactive).
** Removed SldLoad entry point, since Srecord loader is not stand-alon,
** but invoked only thru the 695 loader.
** 
**    Rev 1.2   25 Sep 1992 21:08:26   courtney
** Added reload define.
** 
**    Rev 1.1   25 Sep 1992 05:43:18   courtney
** Update spelling of entry point.
** 
**    Rev 1.0   31 Dec 1991 09:36:58   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcmmcf/inc/sldrsvr.h_v   1.0   03 Jun 1996 11:25:28   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _SLDRSVR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/* Loader flags - please initialize your 'flags' parameter to zero before
   setting any of these flags when calling the Ldr API's, to allow for future
   expansion.
*/
#define L695_DBG     0x01    /* load symbols */
#define L695_CODE    0x02    /* load code */
#define L695_STATUS  0x04    /* display status indicator */
#define L695_WARNING 0x08    /* report warning */
#define L695_RELOAD  0x10    /* reload */

/* default */
#define L695_DEF_FLAGS  L695_DBG | L695_CODE | L695_STATUS | L695_WARNING

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/*--------------------------------------------------------------------------*/
/*	SldLoadWin
**
**	Description:
**      Load an Srecord file.  Flags indicate whether to load just code,
**      just symbols, or everything (the default).
**      This is the only entry point, and callable only by the parent
**      'generic' loader - the IEEE 695 loader.
**
**	Parameters:
**		input:
**			filename - filename of .ABS file to load
**			flags - indicate various options (display progress indicator, don't
**			   load code, don't load symbols, etc.)
**          runMode - BATCH or INTERACTIVE (cli vs. Windows mode)
**		output:
**			None.
**
**	Returns:
**		0 on successful load of required modules
**		-1 if an error occurred (this will be revised to indicate what kind
**		   of error)
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SldLoadWin(LPSTR filename, U16 lflags, BOOL runMode, LDRSTATBLOCK FAR *lstb);


/******************************** E O F ***********************************/
