/*
 * Name: sloader.h
 *
 * Description:
 *    Routines to provide the Loader Server's services.
 *
 * $Log:   S:/tbird/arcmmcf/inc/sloader.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:25:30   gene
** Initial revision.
** 
**    Rev 1.0   14 Sep 1995 14:22:24   kevin
** Initial revision.
 * 
 *    Rev 1.0   14 Jun 1991 13:35:36   jim
 * Initial revision.
 *
 * $Header:   S:/tbird/arcmmcf/inc/sloader.h_v   1.0   03 Jun 1996 11:25:30   gene  $
 *
 */
#ifndef LOADER_SERVER
#define LOADER_SERVER

#include "system.h"
#include "windows.h"
#include "sprjdef.h"
#include "address.h"

typedef struct {
   INT CodeLoadedComplete;
   INT SymbolsLoadedComplete;
} PERCENT_COMPLETE;

/* structure to handle loading file progress report */
typedef struct {
   BOOLEAN progressRequest;
   BOOLEAN displaySelf;
   /* Window handle to receive progress report */
   HWND progressWin;
} PROGRESS_PARAM_TYPE;

ERROR LdrLoadOMF(FILENAME omfFileName, char *groupName, 
   ADDR taskBase, char **moduleIncludeList, 
   char **moduleIgnoreList, BOOLEAN includeCode,
   BOOLEAN includeSymbols, BOOLEAN incLoad, BOOLEAN qualLoad, 
   BOOLEAN debugLoad, BOOLEAN lineNumLoad, 
   ADDR *startAddr, LOAD_FORMAT_TYPES loadFormat;
   BOOLEAN *isValidAddr, PROGRESS_PARAM_TYPE progressParam,
   ERROR (*reportFunc)(PERCENT_COMPLETE));
/*
Description:
   Routine to load an OMF file that being specified by its name, task name.
   The loading progress is report by progressParam or the reportFunc().
   
Parameters:
   input:
      omfFileName       : File name of the OMF file
      groupName         : Task name for symbol base reference
      taskBase          : Base address of task (segment)
      moduleIncludeList : List of module names to include in load
      moduleIgnoreList  : List of module names to ignore in load
      includeCode       : Flag to indicate whether or not to load code
      includeSymbols    : Flag to indicate whether or not to load symbols
      incLoad           : Flag to indicate whether or not to do an incremental
                          on-demand load
      qualLoad          : Flag to indicate whether or not to qualify symbols
      debugLoad         : Flag to indicate whether or not to include all debug
                          information of the load file
      lineNumLoad       : Flag to indicate whether or not to load the line
                          number information
      loadFormat        : User specified load format
      progressParam     : Structure to handle the loading progess
      reportFunc        : Pointer to the caller's report loading status function
   output:
      startAddr         : Value of the initial program start address used by GO
      isValidAddr       : Flag to indicate start address validity
*/

#endif
