/****************************************************************************
**
**  Name:  vrtx.h
**
**  Description:  Definitions for using vrtx
**
**  Status:  coded.
**
**  $Log:   S:/tbird/arcmmcf/inc/vrtx.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:25:54   gene
** Initial revision.
** 
**    Rev 1.0   14 Sep 1995 14:22:44   kevin
** Initial revision.
** 
**    Rev 1.2   13 Jul 1993 08:14:12   ernie
** Added prototype for PhysicalOffsetOf function
** 
**    Rev 1.1   21 Jan 1992 12:43:14   ernie
** added getdosmem and address translation routines
** 
**    Rev 1.0   23 Jul 1991 15:50:42   jim
** Initial revision.
**
**  $Header:   S:/tbird/arcmmcf/inc/vrtx.h_v   1.0   03 Jun 1996 11:25:54   gene  $
**
*****************************************************************************/

#define _VRTX_

                        /****************************
                         *                          *
                         *       INCLUDE FILES      *
                         *                          *
                         ****************************/

#ifndef _BASETYPE_
#include "basetype.h"
#endif
#ifndef _PWORD_
#include "pword.h"
#endif

                        /****************************
                         *                          *
                         *        DEFINITIONS       *
                         *                          *
                         ****************************/
/*
Memory defines
*/
#define MEM_BLOCK_SZ (4*1024) /* size of all memory blocks allocated */
#define MAX_DATA (MEM_BLOCK_SZ-50)
#define SECOND (18L)

/*
Event flags
*/
#ifndef EVFLAG
typedef U32 EVFLAG;
#endif
EVFLAG sc_fcreate (RETCODE *err);
typedef enum {
   ONLY_IF_NONE_PENDING,
   DEL_AND_READY,
   FD_END = 0x7fff        /* make word to satisfy Metaware & Microsoft C */
} FORCE_DELETE;

typedef enum {
   OR_PEND,
   AND_PEND,
   FP_END = 0x7fff        /* make word to satisfy Metaware & Microsoft C */
} FPEND_OPT;

/*
Semaphores
*/
typedef enum {
   PRIORITY,
   PO_END = 0x7fff        /* make word to satisfy Metaware & Microsoft C */
} PEND_ORDER;
#ifndef SEMAPHORE
typedef U32 SEMAPHORE;
#endif
typedef U32 SEMAVALUE;

typedef U32 QUEUE_NUM;
typedef PEND_ORDER QUEUE_ORDER;

typedef struct {
   U16 limitLsw;
   U16 baseLsw;
   U8 baseByte3;
   U8 desType;    /* descriptor type */
   U8 limitByte3;
   U8 baseByte4;
} PMODE_DESCRIPTOR;

typedef struct {
   U16 offsetLsw;
   U16 selector;
   U8 unused;
   U8 type;
   U16 offsetMsw;
} GATE_DESC;

typedef U16 SELECTOR; /* selector in GDT */


                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/*
Vrtx System Calls, see vrtx "C" manual for full descriptions
*/
/*
Character i/o
*/
U32 sc_getc (VOID);
VOID sc_putc (U32 chr);
VOID sc_waitc (U32 chr, RETCODE *err);

/*
Clock
*/
U32 sc_gtime (VOID);
VOID sc_stime (long time);
VOID sc_delay (long timeout);
VOID sc_tslice (unsigned short ticks);
VOID sc_call (U32 fcode, char *pkt, RETCODE *err);

VOID sc_fdelete (EVFLAG group_id, FORCE_DELETE opt, RETCODE *err);
U32 sc_finquiry (EVFLAG group_id, RETCODE *err);
U32 sc_fpend (EVFLAG group_id, U32 timeout, U32 mask, FPEND_OPT opt,
                RETCODE *err);
VOID sc_fpost (EVFLAG group_id, U32 mask, RETCODE *err);
U32 sc_fclear (EVFLAG group_id, U32 mask, RETCODE *err);

/*
Mailboxes
*/
typedef PWORD MBOX;
VOID sc_post (char **mboxp, char *msg, RETCODE *Err);
char *sc_pend (char **mboxp, long timeout, RETCODE *Err);
char *sc_accept (char **mboxp, RETCODE *Err);

/*
Memory allocation.
                                 NOTE
      Use sc_gmem and sc_rmem instead of sc_gblock and sc_rblock so
      partitioning information is not needed to be known.
*/

/****************************************************************************
**
**  sc_translate
**
**  Description:
**     convert linear address to physical address
**     
**  Parameters:
**     input:
**        linear:    linear address
**     output:
**        (returns): physical address
**
*****************************************************************************/
U32 sc_translate(U32 linear);

/****************************************************************************
**
**  sc_getdosmem
**
**  Description:
**     this routine gets one block of memory and maps a page in dos memory
**     (i.e. below 1M boundary) to it, returning the segment address.
**     
**  Parameters:
**     input:
**        numParas:  number of 16-byte paragraphs to allocate
**     output:
**        (returns): segment number of memory allocated (or 0 if failure)
**
*****************************************************************************/
U16 sc_getdosmem(U32 numParas);

/****************************************************************************
**
**  sc_gmem
**
**  Description:
**     this routine gets memory; if greater than 4k, physical 4k blocks are
**     concatenated together in linear space to satisfy the request
**     
**  Parameters:
**     input:
**        numbytes:  number of bytes to get from the free heap
**     output:
**        (returns): pointer to memory block (NULL if no memory available)
**
*****************************************************************************/

VOID *sc_gmem(U32 num_bytes);
RETCODE EXPORT sc_rmem(VOID *mem, U32 num_bytes);
VOID sc_pcreate (U32 pid, char *paddr, long psize, long bsize, RETCODE *err);
VOID sc_pextend (U32 pid, char *paddr, long psize, RETCODE *err);

SEMAPHORE sc_screate (U32 InitValue, PEND_ORDER Pend, RETCODE *err);
VOID sc_sdelete (SEMAPHORE SemId, FORCE_DELETE Delete, RETCODE *err);
VOID sc_spost (SEMAPHORE SemId, RETCODE *err);
SEMAVALUE sc_sinquiry (SEMAPHORE SemId, RETCODE *err);
VOID sc_spend (SEMAPHORE SemId, U32 timeout, RETCODE *err);

/*
Queues
*/
VOID sc_qpost (QUEUE_NUM qid, VOID *msg, RETCODE *err);
VOID sc_qjam (QUEUE_NUM qid, VOID *msg, RETCODE *err);
VOID *sc_qpend (QUEUE_NUM qid, long timeout, RETCODE *err);
VOID *sc_qaccept (QUEUE_NUM qid, RETCODE *err);
VOID sc_qcreate (QUEUE_NUM qid, U32 qsize, RETCODE *err);
VOID sc_qecreate (QUEUE_NUM qid, U32 qsize, QUEUE_ORDER order, RETCODE *err);
VOID *sc_qinquiry (QUEUE_NUM qid, U32 *countp, RETCODE *err);

/*
Tasks
*/
VOID sc_tcreate (_far VOID (*task)(VOID), U32 tid, U32 pri, RETCODE *err);
VOID sc_tacreate (_far VOID (*task)(VOID *), U32 tid, U32 pri, RETCODE *err,
                  VOID *ArgPtr);
VOID sc_tdelete (U32 tid_pri, U32 code, RETCODE *err);
VOID sc_tsuspend (U32 tid_pri, U32 code, RETCODE *err);
VOID sc_tresume (U32 tid_pri, U32 code, RETCODE *err);
VOID sc_tpriority (U32 tid, U32 pri, RETCODE *err);
char *sc_tinquiry (U32 info[3], U32 tid, RETCODE *err);
VOID sc_lock (VOID);
VOID sc_unlock (VOID);

/**************************************************************************
** Description:
**    Initialize the vrtx operating system.
** Parameters:
**    input:
**       none:
**    output:
**       none:
**************************************************************************/
RETCODE EXPORT vrtx_init (VOID);

/**************************************************************************
** Description:
**    Start the vrtx operating system.
** Parameters:
**    input:
**       none:
**    output:
**       none:
**************************************************************************/
VOID vrtx_go (VOID);

/*************************************************************************
**
**  SegmentOf
**
** Description:
**    Returns the segment (selector) portion of a pointer.
** Parameters:
**    input:
**       ptr: any pointer (code or data)
**    output:
**       none:
*************************************************************************/
U32 SegmentOf(VOID *Ptr);

/*************************************************************************
**
**  OffsetOf
**
** Description:
**    Returns the offset portion of a pointer.
** Parameters:
**    input:
**       ptr: any pointer (code or data)
**    output:
**       none:
*************************************************************************/
U32 OffsetOf(VOID *Ptr);

/*************************************************************************
**
**  PhysicalOffsetOf
**
** Description:
**    Returns the physical address translation.
** Parameters:
**    input:
**       ptr: any pointer (code or data)
**    output:
**       none:
*************************************************************************/
U32 PhysicalOffsetOf(VOID *Ptr);

/*************************************************************************
**
**  Enable
**
** Description:
**    Enable interrupts.
** Parameters:
**    input:
**       none
**    output:
**       none
*************************************************************************/
VOID Enable(VOID);

/*************************************************************************
**
**  Disable
**
** Description:
**    Disable interrupts.  NOTE: This disables tasking (and other Vrtx
**    features).
** Parameters:
**    input:
**       none
**    output:
**       none
*************************************************************************/
VOID Disable(VOID);

/*
GDT and IDT Utilities
*/
VOID SetGdtDesc(U16 Selector, _far void *Base, U32 Limit, U8 Type);
VOID GetGdtDesc(U16 Selector, PMODE_DESCRIPTOR **Entry);
VOID SetIdtDesc(U16 VectorNumber, _far void *Code, U8 Type);
VOID GetIdtDesc(U16 VectorNumber, _far void **Code, U8 *Type);
U32 GdtLastValidOffset(PMODE_DESCRIPTOR *Desc);
RETCODE EXPORT GetNextFreeSelector(SELECTOR *Selector);
U32 GetBaseOfDesc(PMODE_DESCRIPTOR *Desc);

/*************************************************************************
**
** GetGdtBase
**
** Description:
**    Get the base of the GDT table.
** Parameters:
**    input:
**       none
**    output:
**       none
*************************************************************************/
PMODE_DESCRIPTOR *GetGdtBase(VOID);

/*************************************************************************
**
** GetIdtBase
**
** Description:
**    Get the base of the IDT table.
** Parameters:
**    input:
**       none
**    output:
**       none
*************************************************************************/
GATE_DESC *GetIdtBase(VOID);

/******************************** E O F ***********************************/
