/****************************************************************************
**
**  Name:  libmain.cpp
**
**  Description:
**     Contains the main entry/exit point of the Peripheral Presenter DLL
**
**  $Log:   S:/tbird/arcmmcf/peri/libmain.cpv  $
** 
**    Rev 1.0   03 Jun 1996 11:08:44   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 09:48:30   gene
** Initial revision.
** 
**    Rev 1.4   03 Nov 1993 13:55:20   ron
** first cut at 2.1
** 
**    Rev 1.3   05 Oct 1993 17:17:08   marilyn
** Calling GetVersion routines to implicitly load the dlls required.
** 
**    Rev 1.2   28 Sep 1993 15:28:44   ron
** revised parser (using Paul's new config format)
** 
**    Rev 1.1   30 Jun 1993 17:32:58   ron
** Changed ErrDisplayFormattedError calls to use additional 2 arguments
** added for Help button project.
** 
**    Rev 1.0   28 Jun 1993 15:05:58   marilyn
** Initial revision.
** 
**
**  $Header:   S:/tbird/arcmmcf/peri/libmain.cpv   1.0   03 Jun 1996 11:08:44   gene  $ 
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _PERISERV_
#include "periserv.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/



#if defined (STRICT)
HWND cliServerHandle;
HINSTANCE hLib;
#else
/* Handle of the CLI instance */
HANDLE cliServerHandle;
/* Handle of the DLL instance */
HANDLE hLib;
#endif



                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

extern PTPeriServer PeriServer;

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

#ifdef __cplusplus
extern "C" {
#endif

extern VOID FAR RegisterVlist();   // vincent: FARPROC is added

#ifdef __cplusplus
}
#endif

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the base class DLL
**
**    Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/

#pragma argsused
#if defined (STRICT)
int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
#else
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
#endif
    RETCODE err;
    S16 buttonID;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */

//    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
//     UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;
    ErrInitDLL(MODULE_PERI,"peri.dll");
    RegisterVlist();
    PeriServer = new TPeriServer();
    err = PeriServer->status;
    if (err != GOOD) {
       ErrDisplayFormattedError(err, FORCE_POPUP,NULL,NULL,NULL,MB_OK,
          (S16 FAR *) &buttonID);
    }

    return(TRUE);

}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**    Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
int FAR PASCAL WEP(int) {

   delete PeriServer;
   return(TRUE);
}
#endif

/*******************************************************************************
**
**   InitCServer :
**   Register server with CLI.
**
******************************************************************************/
#if defined (STRICT)
RETCODE EXPORT InitCServer(HWND cliHandle, HANDLE dllHandle) {
   CSERVER_NEW_REGISTRATION FAR * msgBufPtr;
#else
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) {
   CSERVER_NEW_REGISTRATION FAR * msgBufPtr;
#endif
   cliServerHandle = cliHandle;
   msgBufPtr =
      (CSERVER_NEW_REGISTRATION FAR *)TMalloc(sizeof(CSERVER_VARIABLE_VALUE));
   if (msgBufPtr == NULL) {
      return(ER_OUT_OF_MEMORY);
   }

   msgBufPtr->stringResourceHandle = dllHandle;

   msgBufPtr->serverNameIndex = 0;
   msgBufPtr->dllNameIndex = 1;
   msgBufPtr->numberOfCommandsIndex = 2;
   msgBufPtr->commandStartIndex = 3;
   SendMessage(cliHandle, CLI_NEW_SVR_REGISTRATION, CLI_NEW_SVR_REGISTRATION,
      (DWORD)msgBufPtr);
   return(GOOD);
}  /* InitCServer */


/******************************** E O F ***********************************/
