/****************************************************************************
**
**  Name:  pericli.h
**
**  Description:
**     Include file for peripheral server shell interface.
**
**  $Log:   S:/tbird/arcmmcf/peri/pericli.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:09:00   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 09:49:14   gene
** Initial revision.
** 
**    Rev 1.1   12 Oct 1993 14:42:40   ron
** checkpoint after buffer editing
** 
**    Rev 1.0   28 Jun 1993 15:09:34   marilyn
** Initial revision.
**  
**  $Header:   S:/tbird/arcmmcf/peri/pericli.h_v   1.0   03 Jun 1996 11:09:00   gene  $
**
**  Copyright (C) 1991-93 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _PERICLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

//*************************************************************************
//   PCliOpen
//
//   Description:
//      Verify processor type and open and read from the appropriate
//      configuration file.  Create database of information for the
//      peripheral presenter.
//
//   Parameters:
//      cmdString (in): the shell command string
//      argc (in): number of arguments
//      argv[] (in): array of pointers to arguments
//*************************************************************************
RETCODE EXPORT PCliOpen(LPSTR cmdString, U32 argc, U32 argv[]);


//************************************************************************
//   PCliRegister
//
//   Description:
//      Display a formatted register(s) to the shell.
//
//   Parameters:
//      cmdString (in): the shell command string
//      argc (in): number of arguments
//      argv[] (in): array of pointers to arguments
//************************************************************************
RETCODE EXPORT PCliRegister(LPSTR cmdString, U32 argc, U32 argv[]);


//************************************************************************
//   PCliPregWatch
//
//   Description:
//      Display registers in the watch list to the shell or add a
//      specified register to the list and display the registers.
//
//   Parameters:
//      cmdString (in): the shell command string
//      argc (in): number of arguments
//      argv[] (in): array of pointers to arguments
//************************************************************************
RETCODE EXPORT PCliRegWatch(LPSTR cmdString, U32 argc, U32 argv[]);


//*********************************************************************
//   PCliPregDelete
//
//   Description:
//      Delete all registers or the indicated register from the watch list.
//
//   Parameters:
//      cmdString (in): the shell command string
//      argc (in): number of arguments
//      argv[] (in): array of pointers to arguments
//**********************************************************************
RETCODE EXPORT PCliRegDelete(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
**
**  PeriDebug
**
**  Status:  NEW
**
**  description:
**     _peridebug [on|off] to display (no parameters) or set the
**     peripheral presenter debug mode on or off.
**
**  input:
**     cmdString:  input text
**     argc:  argument count
**     argv:  offsets into cmdString where arguments start
**
**  output:
**     none
**
*****************************************************************************/
RETCODE EXPORT  PeriDebug(LPSTR cmdString, U32 argc, U32 argv[]);

#ifdef __cplusplus
}
#endif

//************************** E O F ****************************************/
