/*CLASS: PathToSrcDialog 
   Use the FILE_BOX resource and rename to "Path to Source".
   Call pathToSource(PathToSrcDialogObject) to retrieve the selected path
   to source.

 */!!

inherit(FileDialog, #PathToSrcDialog, #(inputPath), 2, nil)!!

now(class(PathToSrcDialog))!!

now(PathToSrcDialog)!!

/* 06/17/93 - PRIVATE
  Respond to Open button being pushed or CR being pushed. If a
  valid file is selected, exit dialog. Otherwise, switch to new
  directory, filter, etc.  */
Def open(self | fs)
{ 
  fs := fileSpec;
  fileSpec := getItemText(self, FILE_LB);
  if (size(fileSpec) = 0) then
    fileSpec := "*.*";
  endif;
  if not(checkPathBeforeExit(self)) then
    if not(indexOf(fileSpec, '*', 0) cor indexOf(fileSpec, '?', 0))
    then beep();
      setItemFocus(self, FILE_LB);
    endif;
    if not(loadList(self))
    then fileSpec := fs;
    endif;
  endif;
}!!

/* 6/10/1993 13:44 - PUBLIC
  Return the Path to source.
*/
Def pathToSource(self)
{ 
  ^pathSpec;
}
!!

/* 6/10/1993 11:23 - PRIVATE
  Handle file dialog events (OK, Cancel, etc.). Selecting OK
  will always do something, if only to reload the lists according
  to the current filter. */
Def command(self, wP, lP | action)
{ 
  action := high(lP);
  select
    case wP == IDCANCEL
      is resetDir(self);
      end(self, IDCANCEL);
    endCase
    case wP == FILE_LB and action = LBN_SELCHANGE
      is sendDlgItemMessage(self, FILE_DIRLB, LB_SETCURSEL, -1, 0);
    endCase
    case wP == FILE_DIRLB and action = LBN_SELCHANGE
      is sendDlgItemMessage(self, FILE_LB, CB_SETCURSEL, -1, 0);
      setItemText(self, FILE_LB, getLoadDir(self) + fileSpec);
    endCase
    case (wP == FILE_DIRLB and action = LBN_DBLCLK)
      cor (wP == IDOK and getLBSel(self, FILE_DIRLB))
      is newDir(self);
    endCase
    case wP == FILE_LB and action = LBN_DBLCLK
    is if getLoadFile(self) then
        resetDir(self);
        end(self, IDOK);
      endif;
    endCase
    case wP == IDOK
      is open(self);
    endCase
    case wP = IDHELP
       is command(self:ancestor, wP, lP);
    endCase        
  endSelect;
  ^1;
}
!!

/* set the help entry to use */
Def setHelpEntry(self, hEntry)
{
  setHelpEntry(self:ancestor, hEntry);
}!!


/* 6/10/1993 10:58 - PRIVATE 
  Respond to OK button being pushed or CR being pushed. If a
  valid directory is selected, exit dialog. Otherwise, 
  switch to new directory, filter, etc.  */
Def checkPathBeforeExit(self | tmpStr)
{ 
  /* Check to make sure that the same input path is not return */
  tmpStr := "";
  if size(inputPath) > 0 then
    tmpStr := pathParts(inputPath)[0];
    /* Strip off the last slash */
    if tmpStr cand size(tmpStr) > 0 cand tmpStr[size(tmpStr)-1] in asSet("\/") then
      tmpStr := subString(tmpStr, 0, size(tmpStr)-1);
    endif;
  endif;  
  /* Check for duplicate the same path */ 
  if (pathSpec cor (size(pathSpec) <> size(tmpStr)) cand
    (pathSpec <> tmpStr)) then 
    loadFile := pathString(self, fileSpec);
    resetDir(self);
    end(self, IDOK);
    ^#true;      
  endif;  
  ^nil;
}
!!

/* 6/10/1993 10:28 - PRIVATE
  Set FileSpec and InputPath for directories browsing.
*/
Def setFileSpec(self, fs)
{ 
  inputPath := fs;
  ^fileSpec := fs;
}
!!

/* 6/7/1993 11:44 - PRIVATE
  Initialize PathToSrcDialog object.
*/
Def initDialog(self, wp, lp)
{ 
  setText(self, "Path to Source");
  ^initDialog(self:ancestor, wp, lp);
}
!!
